# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: txtgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.9.1  1999/11/05  14:52:58  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.36  1999/10/13  20:13:02  Richard_Taft
# 	Call _parent's packSide proc to find out the side (top or left)
# 	to pack from.  Don't check the parent's name, it may not tell
#
# Revision 1.1.2.35  1999/02/19  19:57:05  Richard_Taft
# 	Put back the asterisks in password field.
# 	[1999/02/19  19:56:27  Richard_Taft]
#
# Revision 1.1.2.34  1998/07/23  19:24:38  William_Athanasiou
# 	Ignore cap-lock key
# 	[1998/07/20  19:54:07  William_Athanasiou]
# 
# Revision 1.1.2.33  1998/04/10  13:35:20  William_Athanasiou
# 	make passwd visible in _setState
# 	[1998/04/10  13:32:54  William_Athanasiou]
# 
# Revision 1.1.2.32  1998/04/10  13:17:01  William_Athanasiou
# 	fix else/if typo
# 	[1998/04/10  13:15:53  William_Athanasiou]
# 
# Revision 1.1.2.31  1998/04/10  02:33:45  William_Athanasiou
# 	Correct uiRep sep. curses/gui uidef
# 	[1998/04/10  02:28:24  William_Athanasiou]
# 
# Revision 1.1.2.30  1998/03/19  21:43:52  William_Athanasiou
# 	Add appendVal method for text widgets
# 	[1998/03/19  21:38:16  William_Athanasiou]
# 
# Revision 1.1.2.29  1998/03/16  20:09:26  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:06:18  William_Athanasiou]
# 
# Revision 1.1.2.28  1998/02/26  21:35:52  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:30:25  William_Athanasiou]
# 
# Revision 1.1.2.27  1998/02/11  18:44:13  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:45:00  William_Athanasiou]
# 
# Revision 1.1.2.26  1998/02/05  16:32:52  William_Athanasiou
# 	Update size of scollbar
# 	[1998/02/05  16:32:21  William_Athanasiou]
# 
# Revision 1.1.2.25  1997/10/08  14:58:11  Richard_Taft
# 	Added #@ comments for automated documentation
# 	[1997/10/08  14:57:37  Richard_Taft]
# 
# 	Took out flat look of disabled text
# 	[1997/10/07  14:59:17  Richard_Taft]
# 
# Revision 1.1.2.24  1997/09/19  15:40:18  Richard_Taft
# 	Gave non-editable text a flat look
# 	[1997/09/19  15:36:12  Richard_Taft]
# 
# Revision 1.1.2.23  1997/09/05  14:03:59  Richard_Taft
# 	Added setInsertPt, showChar, page and scroll methods
# 	[1997/09/05  14:01:05  Richard_Taft]
# 
# Revision 1.1.2.22  1997/08/18  17:11:20  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:52  William_Athanasiou]
# 
# Revision 1.1.2.21  1997/07/22  17:40:45  William_Athanasiou
# 	Fixed problem with Return being included in string
# 	[1997/07/22  17:40:28  William_Athanasiou]
# 
# Revision 1.1.2.20  1997/04/11  14:49:21  William_Athanasiou
# 	Don't accept tab to text area if disabled
# 	[1997/04/11  14:48:50  William_Athanasiou]
# 
# Revision 1.1.2.19  1997/04/11  14:12:14  William_Athanasiou
# 	fixed tab movement/passwd now invisible
# 	[1997/04/11  14:11:24  William_Athanasiou]
# 
# Revision 1.1.2.18  1997/04/09  17:10:09  William_Athanasiou
# 	Corrected problem with disabled state and focusability
# 	[1997/04/09  17:08:56  William_Athanasiou]
# 
# Revision 1.1.2.17  1997/04/09  16:30:39  William_Athanasiou
# 	Added -passwd check for single line fields, and use scrolledtext
# 	      for multiline txt widgets
# 	[1997/04/09  16:22:24  William_Athanasiou]
# 
# Revision 1.1.2.16  1997/03/31  18:49:35  William_Athanasiou
# 	set highlightthickness to 2 so its visible
# 	[1997/03/31  18:31:50  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/03/28  16:46:46  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:24  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/03/21  15:55:31  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:51  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/03/13  21:26:39  William_Athanasiou
# 	For setVal of multiline change state to normal before inserting
# 	[1997/03/13  21:26:07  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/03/13  17:45:09  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:44:00  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/03/07  20:51:41  William_Athanasiou
# 	Added capability to align labels in chamwdgts
# 	[1997/03/07  20:50:35  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/03/07  19:08:10  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:45  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/01/16  20:37:43  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:33  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/01/16  14:16:00  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:15:13  William_Athanasiou]
# 
# Revision 1.1.2.7  1996/12/02  23:00:57  Todd_Moyer
# 	In display method call $self next to cause a read to occur.
# 	[1996/12/02  22:51:24  Todd_Moyer]
# 
# Revision 1.1.2.6  1996/10/01  13:31:41  William_Athanasiou
# 	Fixed slight formatting problems
# 	[1996/10/01  13:29:17  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/09/25  15:22:54  William_Athanasiou
# 	Add non-editable type to text type
# 	[1996/09/25  15:20:19  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/09/24  20:34:47  William_Athanasiou
# 	replaced outdated call to put method with call setVal
# 	[1996/09/24  20:34:03  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/24  19:58:07  William_Athanasiou
# 	Changed put/get method names to match inherited methods
# 	[1996/09/24  19:39:40  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  14:17:31  William_Athanasiou
# 	Initial _UIT_TextGUI class.
# 	Supports single and multi-line text displays.
# 	[1996/09/24  14:05:38  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: txtgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 


#@ TextGUI implements the text widget for the GUI interface.

Class _UIT_TextGUI -superclass _UIT_TextGeneric

_UIT_TextGUI instproc init {args} {
   eval $self next $args
}


#@ Display the text widget

_UIT_TextGUI instproc display {} {
   $self instvar _displayedOnce height _valuePtr

   if {!$_displayedOnce} {
      $self instvar width editable passwd \
	  _UIrep _parent _lbl _isAlignable _window _UIrep _enabledState
      
      incr _displayedOnce
      set leaf [lindex [split $self .] end]
      set container [$_parent set containWdgt]
      
       set _UIrep [$self _makeUIrep $container $leaf [$_parent packSide]]
      $self _setState $_enabledState
   }

   # needed since text widget doesn't support variable.
   if {$height > 1} {
      upvar #0 $_valuePtr val
      $self setVal $val
   }

   $self next
}

#@ Functions to handle enable/disable widget calls.

_UIT_TextGUI instproc _setState {val} {
   $self instvar _UIrep editable
   set labelState $val
   set widgetState $val
   if [cequal $val "normal"] {
      if {!$editable} {
	 set widgetState disabled
      } else {
	 set widgetState normal
      }
   }
   $_UIrep configure -state $widgetState -labelstate $labelState
}

#@ Internal function to create a multiline text widget.
#@ Should not be used within a suitlet.

_UIT_TextGUI instproc _makeUIrep {parent leaf side} {
   $self instvar _lbl height width editable passwd \
       _window _valuePtr _isAlignable
   global _UIT_DisplayAttr

   if {$editable} {set state normal} {set state disabled}

   if {$height == 1} {
      #
      # single line entry
      #
      set uiRep [entryfield $parent.$leaf \
		     -labeltext $_lbl -textvariable $_valuePtr \
		     -width $width -state $state]
      if [cequal $state "disabled"] {
	 global _UIT_DisplayAttr
	 [$uiRep component entry] configure \
	     -background $_UIT_DisplayAttr(EntryNonEditable) \
	     -foreground $_UIT_DisplayAttr(Foreground)\
	     -font $_UIT_DisplayAttr(LabelFont)
	 #
	 # remove border to really make it look like a label.
	 [$uiRep component entry] configure -borderwidth 0
      } elseif {$passwd != 0} {
	 $uiRep config -textvariable {}
	 set ewdgt [$uiRep component entry]

	 $ewdgt configure -show {*}
      }
      pack $uiRep -expand 0 -fill x -anchor nw -padx 0 -side $side
      set _isAlignable $uiRep
      $_window _registerUImap $uiRep $self
      
   } else {
      #
      # multi line entry
      #
      set uiRep [scrolledtext $parent.$leaf \
		     -textbackground $_UIT_DisplayAttr(EntryBackground) \
		     -foreground $_UIT_DisplayAttr(EntryForeground) \
		     -textfont $_UIT_DisplayAttr(EntryFont) \
		     -visibleitems ${width}x${height} \
		     -labeltext $_lbl -labelpos nw -labelmargin 0 \
		     -vscrollmode dynamic -hscrollmode dynamic \
		     -highlightthickness 2 -wrap word -state $state]
      
      if [cequal $state "disabled"] {
	 # text area is non editable, make it look like it.
	 $uiRep configure -textbackground $_UIT_DisplayAttr(EntryNonEditable)
      }
      
      pack $uiRep -expand 1 -fill both -anchor nw -padx 0 -side $side
      $_window _registerUImap $uiRep $self
   }
   
   return $uiRep
}


#@ Return the text currently displayed in the text widget

_UIT_TextGUI instproc getVal {} {
   $self instvar _valuePtr height _displayedOnce passwd
   upvar #0 $_valuePtr val

   if {($height > 1) && ($_displayedOnce > 0)} {
      $self instvar _UIrep
      set val [$_UIrep get 0.0 end-1c]
   } elseif {$passwd} {
      $self instvar _UIrep
      set val [$_UIrep get]
   }

   return $val
}

#@ Display the given text in the text widget

_UIT_TextGUI instproc setVal {v} {
   $self next $v
   $self _updateVal $v 0
}

_UIT_TextGUI instproc appendVal {s} {
   set val [$self next $s]
   $self _updateVal $val end
}

_UIT_TextGUI instproc _updateVal {s pos} {
   $self instvar height _displayedOnce _UIrep editable passwd

   if $_displayedOnce {

      if {$height == 1} {
	  $_UIrep icursor $pos
	  if { $passwd } {
	      $_UIrep delete 0 end
	      $_UIrep insert 0 $s
	  }
	  return
      }

      if {!$editable} {
	 $_UIrep configure -state normal
	 $_UIrep delete 0.0 end
	 $_UIrep insert 0.0 $s
	 $_UIrep configure -state disabled
      } else {
	 $_UIrep delete 0.0 end
	 $_UIrep insert 0.0 $s
      }
      if {$pos == 0} {set pos 0.0}
      $_UIrep mark set insert $pos
   }
}  

#@ Internal function to filter out non-printable characters.
#@ Should not be used within a suitlet.

_UIT_TextGUI instproc _hideChar {char sym state} {
   upvar #0 [$self set _valuePtr] val

   switch $sym {
      Return -
      Tab {
	 return 1
      }
      h -
      H {
	 if [expr $state == 70] {
	    set val [csubstr $val 0 end]
	    
	    return 0
	 }
      }
      BackSpace -
      Delete {
	 set val [csubstr $val 0 end]
	 return 0
      }
   }
   
   if [cequal $char ""] {
      return 1
   }
   
   append val $char
   return 0
}


#@  Make sure that position char is visible in text box

_UIT_TextGUI instproc showChar {char} {
    $self instvar _UIrep height

    if {$height > 1} {
	if [cequal $char "end"] {
	    set idx end
	} else {
	    # 1.0 means beginning of first line
	    set idx [list 1.0 + $char chars]
	}

	$_UIrep see $idx;		# might out idx at center

    } else {
	$_UIrep xview $char;		# puts char at left unless near end
	$self _centerCursor $char
    }
}



#@  Put the insertion cursor at position char
#@   and make sure it's visible in text box.

_UIT_TextGUI instproc setInsertPt {char} {
    $self instvar _UIrep height

    if {$height > 1} {
	if [cequal $char "end"] {
	    set idx end
	} else {
	    # 1.0 means beginning of first line
	    set idx [list 1.0 + $char chars]
	}
	$_UIrep mark set insert $idx
	$_UIrep see insert;		# might put idx at center

    } else {
	$_UIrep icursor $char
	$_UIrep xview insert;		# puts char at left unless near end

	$self _centerCursor $char
    }
}


#@ Internal proc to center the cursor in the text box,
#@ unless it is near the end.
#@ Should not be used in a suitlet.

_UIT_TextGUI instproc _centerCursor { char } {
    $self instvar _UIrep width _valuePtr
    upvar #0 $_valuePtr val

    set len [string length $val]
    set atEnd [cequal $char "end"]

    if { (! $atEnd) && ($width < ($len - $char)) } {

	##  xview leaves the last char at right always!
	lassign [$_UIrep xview] left right
	set left [expr $left - ($right - $left) / 2]
	if { $left < 0 } { set left 0 }

	$_UIrep xview moveto $left
    }
}


#@ Pan the text display:
#@   move by x characters left (x < 0) or right (x > 0)
#@   move by y lines up (y < 0) or down (y > 0)

_UIT_TextGUI instproc scroll { x {y {}}} {
    $self instvar _UIrep height

    $_UIrep xview scroll $x units

    if { $height > 1 && $y != {} } {
	$_UIrep yview scroll $y units
    }
}


#@ Pan the display by screenfulls:
#@   move left if x < 0, or right if x > 0
#@   move up if y < 0, or down if y > 0

_UIT_TextGUI instproc page { x {y {}}} {
    $self instvar _UIrep height

    $_UIrep xview scroll $x pages

    if { $height > 1 && $y != {} } {
	$_UIrep yview scroll $y pages
    }
}

