#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: txtjava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.8  1998/03/26  20:01:21  Anthony_Hoffman
# 	BL 16 shared sandbox submit
# 	[1998/03/25  19:05:02  Anthony_Hoffman]
#
# Revision 1.1.2.16  1998/03/24  22:20:44  William_Athanasiou
# 	showChar method cannot be supported by java AWT
# 	[1998/03/24  22:20:24  William_Athanasiou]
# 
# Revision 1.1.2.15  1998/03/19  21:43:53  William_Athanasiou
# 	Add appendVal method for text widgets
# 	[1998/03/19  21:38:19  William_Athanasiou]
# 
# Revision 1.1.2.14  1998/03/16  20:09:27  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:06:22  William_Athanasiou]
# 
# Revision 1.1.2.13  1998/02/13  22:27:59  William_Athanasiou
# 	Added enable/disable and changeCB funtionality
# 	[1998/02/13  22:23:23  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/11/06  19:58:24  William_Athanasiou
# 	Replace all quoted strings with a call to safeXferString
# 	[1997/11/06  19:56:55  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/09/05  14:03:57  Richard_Taft
# 	Added setInsertPt and showChar. Made quote an instproc.
# 	[1997/09/05  14:02:52  Richard_Taft]
# 
# Revision 1.1.2.10  1997/08/22  18:46:22  William_Athanasiou
# 	Remove resetval call and correct display logic
# 	[1997/08/22  18:28:48  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/08/20  13:00:51  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.7 **
# 		** Merge revision:	1.1.2.8 **
# 	 	** End **
# 	Call resetVal from display to set _javaKnowsMe and sync
# 	up values between java & suit.
# 
# 	Added editable and passwd values to display string.
# 	[1997/07/24  19:43:42  Richard_Taft]
# 
# Revision 1.1.2.8  1997/08/18  17:11:21  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:55  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/07/22  21:42:29  Richard_Taft
# 	setVal needs to quote its arg
# 	[1997/07/22  21:38:58  Richard_Taft]
# 
# Revision 1.1.2.6  1997/07/21  21:48:08  Richard_Taft
# 	Implemented getVal & setVal
# 	[1997/07/21  21:18:25  Richard_Taft]
# 
# Revision 1.1.2.5  1997/07/18  19:54:42  Richard_Taft
# 	Changed puts to putJava
# 	[1997/07/18  19:48:29  Richard_Taft]
# 
# Revision 1.1.2.4  1997/07/09  20:12:25  Todd_Moyer
# 	Moved value to the end if display method.
# 	[1997/07/09  20:11:22  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/07/02  19:01:21  Deepa_Bachu
# 	Modified the creation code being sent to the applet.
# 	[1997/07/02  18:57:21  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/06/23  15:44:33  Deepa_Bachu
# 	Initial _UIT_TextJAVA class file.
# 	[1997/06/23  15:43:23  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: txtjava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 

Class _UIT_TextJAVA -superclass _UIT_TextGeneric


# No class specific init needed.
#
#_UIT_TextJAVA instproc init {args} { eval {$self next} $args }


_UIT_TextJAVA instproc display {} {
   $self instvar _displayedOnce _enabledState
   
   if { ! $_displayedOnce } {
      $self instvar _lbl _helpTag width height editable passwd _valuePtr
      upvar #0 $_valuePtr val

      putJava "_UIT_Text $self [safeXferString $_lbl] \
            $_enabledState [safeXferString $_helpTag] \
	    $width $height $editable $passwd [safeXferString $val]"
      incr _displayedOnce
   } 
}


_UIT_TextJAVA instproc getVal {} {
    $self instvar _displayedOnce

    if { $_displayedOnce } {
	# Query java for the value
	putJava "$self getVal"
	if { [ getJava val ] < 0 } {
	    logMsg "Java Applet closed?"
	    error "Java Applet closed?"
	    return ""
	} else {
	    return $val
	}

    } else {
	# Java doesn't know the value,
	# we do!
	return [$self next]
    }
}


_UIT_TextJAVA instproc setVal {val} {
    $self next $val
    if { [$self set _displayedOnce] } {
	putJava "$self setVal [safeXferString $val]"
    }
    return $val
}

_UIT_TextJAVA instproc appendVal {str} {
   set val [$self next $str]
   if [$self set _displayedOnce] {
      putJava "$self appendVal [safeXferString $str]"
   }
}

_UIT_TextJAVA instproc setInsertPt {char} {
    if { [$self set _displayedOnce] } {
       putJava "$self setInsertPt [safeXferString $char]"
    }
}

_UIT_TextJAVA instproc showChar {char} {
   return
   #
   # This option cannot be supported by the java AWT.
   #
    if { [$self set _displayedOnce] } {
       putJava "$self showChar [safeXferString $char]"
    }
}

_UIT_TextJAVA instproc _setState {val} { 
   if [cequal $val "disabled"] { 
      putJava "$self disable" 
   } else {
      putJava "$self enable"
   }
}
