# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: wincur.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.12.1  1999/11/05  14:53:01  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.22  1999/09/27  16:43:41  Waiman_Long
# 	Fix setup invocation problem in Chinese locale.
#
# Revision 1.1.2.21  1998/12/04  15:28:29  William_Athanasiou
# 	abort if window < 24 lines
# 	[1998/12/04  15:26:24  William_Athanasiou]
#
# Revision 1.1.2.20  1998/12/03  22:32:20  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:26  William_Athanasiou]
# 
# Revision 1.1.2.19  1998/10/21  13:10:40  William_Athanasiou
# 	remove focusing and curses specific stuff from wingui.tcl
# 	[1998/10/21  13:10:09  William_Athanasiou]
# 
# Revision 1.1.2.18  1998/08/11  16:41:30  William_Athanasiou
# 	Update pfh/keyboard help message
# 	[1998/08/11  16:39:08  William_Athanasiou]
# 
# Revision 1.1.2.17  1998/07/14  17:55:14  William_Athanasiou
# 	Add keyboard help for curses
# 	[1998/07/14  17:54:40  William_Athanasiou]
# 
# Revision 1.1.2.16  1998/02/26  21:35:53  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:30:33  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/12/12  14:53:17  William_Athanasiou
# 	fix pointer focus display
# 	[1997/12/12  14:51:39  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/10/27  19:00:48  William_Athanasiou
# 	nothing changed
# 	[1997/10/27  18:24:47  William_Athanasiou]
# 
# 	Provide initial help in pointer focus help area
# 	[1997/10/27  18:20:44  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/08/28  18:37:18  Richard_Taft
# 	Needed to override wingui's _setCursor
# 	[1997/08/28  18:13:38  Richard_Taft]
# 
# Revision 1.1.2.12  1997/04/09  16:30:40  William_Athanasiou
# 	expand all windows to maximum size of terminal
# 	[1997/04/09  16:23:03  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/03/31  18:49:35  William_Athanasiou
# 	add ability (commented out) to expand window to size of screen
# 	[1997/03/31  18:45:35  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/03/28  16:46:47  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:26  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/03/21  15:55:32  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:53  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/02/24  19:17:31  William_Athanasiou
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:10:57  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/01/23  19:28:20  William_Athanasiou
# 	Added displayCB functionality/removed read from display function
# 	[1997/01/23  19:23:17  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/01/16  14:16:03  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:15:19  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/11/11  15:26:55  William_Athanasiou
# 	Nothing changed.  All new operations in wingui.tcl
# 	[1996/11/05  16:51:51  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/10/29  15:01:47  William_Athanasiou
# 	Fixed problem with window buttonbox not forcing resize of window
# 	[1996/10/29  14:56:44  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/24  21:51:20  William_Athanasiou
# 	Added title to window
# 	[1996/09/24  21:47:34  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  19:58:09  William_Athanasiou
# 	initial version of implementation
# 	[1996/09/24  19:55:44  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: wincur.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 

Class _UIT_WindowCURSES -superclass _UIT_WindowGUI

_UIT_WindowCURSES instproc init {args} {
   $self instvar _usedAccels

   eval {$self next} $args
   # 
   # never use these characters when determining curses accel keys.
   set _usedAccels {.[]<>~!@\#$%^&*()_-+=\{\}\\|:;""'`,?/ 	}  
}

_UIT_WindowCURSES instproc display {} {
   $self next
   bind .$self <FocusIn> "$self _updateHelp %W"
   .$self updateHelp \
       "\n\t================ <CTRL-G> FOR KEYBOARD HELP =================="
}

_UIT_WindowCURSES instproc _specialButtonHook {i} {
   $self instvar _usedAccels
   global _UIT_g_main

   set letter [$_UIT_g_main catget $i accel]
   set len [string length $letter]
   if {$len > 1} {
      for {set ndx 0} {$ndx < $len} {incr ndx} {
	 set c  [string index $letter $ndx]
	 set lc [string tolower $c]
	 #
	 # Don't set accelerator if it is not an English alphabet
	 #
	 if {![string match {[abcdefghijklmnopqrstuvxyz]} $lc]} {continue}
	 if {[string first $lc $_usedAccels] == -1} {
	    append _usedAccels $lc
	    break
	 }
      }
      if {$ndx != $len} {
	 $self.$i config -underline $ndx
	 bind .$self <M-$lc> "$self.$i invokeWrapper"
      }
   } else {
      set underline [string first $letter [$self.$i set _lbl]]
      set letter [string tolower $letter]
      #
      # Don't set accelerator if it is not an English alphabet
      #
      if {[string match {[abcdefghijklmnopqrstuvxyz]} $letter]} {
	 append _usedAccels $letter
	 $self.$i config -underline $underline
	 bind .$self <M-$letter> "$self invokeWrapper"
      }
   }
}

_UIT_WindowCURSES instproc _showWindow {parent} {
   set h [winfo screenheight .]
   if [expr $h < 24] {
      puts stderr "Screen must have at least 24 lines"
      exit 1
   }
   wm geometry .$self \
       =[winfo screenwidth .]x[winfo screenheight .]
   .$self activate
   update idletasks
   $self _setCursor default
}
  

_UIT_WindowCURSES instproc _updateHelp {w} {
   $self instvar _ui2wdgt
   if {[info exists _ui2wdgt($w)]} {
      $self next $_ui2wdgt($w)
   } else {
      $self next $w
   }
}

_UIT_WindowCURSES instproc _registerUImap {ui wdgt} {
   $self instvar _ui2wdgt
   set _ui2wdgt($ui) $wdgt
   foreach child [winfo children $ui] {
      $self _registerUImap $child $wdgt
   }
}
   
_UIT_WindowCURSES instproc _setCursor {cursor} {

}

_UIT_WindowCURSES instproc _startWorking {} {
}
