# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: wingen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.1  1999/11/05  14:53:02  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.23  1999/10/13  20:13:03  Richard_Taft
# 	mfile.txt
#
# Revision 1.1.2.22  1998/03/16  20:09:27  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:06:26  William_Athanasiou]
#
# Revision 1.1.2.21  1998/03/02  16:49:56  Todd_Moyer
# 	Cleaned up _winStack API.
# 	[1998/03/02  16:47:34  Todd_Moyer]
# 
# Revision 1.1.2.20  1998/02/26  21:35:53  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:30:36  William_Athanasiou]
# 
# Revision 1.1.2.19  1997/08/21  14:19:05  William_Athanasiou
# 	Don't delay lookup of window title until initial display
# 	[1997/08/20  18:43:29  William_Athanasiou]
# 
# Revision 1.1.2.18  1997/08/19  21:00:32  William_Athanasiou
# 	ignore redundant hide/display methods and allow display from initcb
# 	[1997/08/19  20:59:54  William_Athanasiou]
# 
# Revision 1.1.2.17  1997/08/18  17:11:22  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:57  William_Athanasiou]
# 
# Revision 1.1.2.16  1997/03/31  18:49:36  William_Athanasiou
# 	Setup initial geometry
# 	[1997/03/31  18:29:30  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/03/21  15:55:32  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:55  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/02/24  19:17:34  William_Athanasiou
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:10:59  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/01/23  19:28:15  William_Athanasiou
# 	Added displayCB functionality/removed read from display function
# 	[1997/01/23  19:23:19  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/01/16  15:46:05  William_Athanasiou
# 	Fixed window title (lbl) display
# 	[1997/01/16  15:09:47  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/01/16  14:16:04  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:15:22  William_Athanasiou]
# 
# Revision 1.1.2.10  1996/12/20  19:36:23  William_Athanasiou
# 	Fixed winStack problem.  Windows not being popped
# 	[1996/12/20  19:34:14  William_Athanasiou]
# 
# Revision 1.1.2.9  1996/11/26  22:10:18  Todd_Moyer
# 	Move the resTree to the main Cham object.
# 	[1996/11/26  22:05:19  Todd_Moyer]
# 
# Revision 1.1.2.8  1996/11/25  15:29:48  Deepa_Bachu
# 	renamed     displayWin   -> _pushDisplayStack
# 	[1996/11/25  15:25:27  Deepa_Bachu]
# 
# Revision 1.1.2.7  1996/09/25  13:22:44  William_Athanasiou
# 	Find title of window from message catalog and set title variable
# 	[1996/09/25  13:17:40  William_Athanasiou]
# 
# Revision 1.1.2.6  1996/09/24  21:03:35  Todd_Moyer
# 	Added writeData method.
# 	[1996/09/24  20:55:32  Todd_Moyer]
# 
# Revision 1.1.2.5  1996/09/09  19:15:57  Todd_Moyer
# 	Get widget data from the data layer.
# 	[1996/09/09  19:04:39  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/09/06  18:41:51  Todd_Moyer
# 	Create and use a resrcTree to get data from data layer.
# 	[1996/09/06  18:35:10  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/09/03  20:22:56  Todd_Moyer
# 	Set default for buttons, not opers.
# 	[1996/09/03  20:21:02  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/08/30  18:41:27  Deepa_Bachu
# 	This file contains the common methods of the _UIT_WindowGeneric class.
# 	[1996/08/30  17:41:28  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: wingen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 

Class _UIT_WindowGeneric -superclass _UIT_Container

_UIT_WindowGeneric instproc init {contents args} {

   global _UIT_g_main
   $self instvar buttons display wmclose dataImp geomInit padTop padLeft \
       title defaultb
   $self set _visible 0
   
   # set defaults   
   set buttons  {ok cancel help}
   set display  0
   set wmclose  cancel   
   set dataImp  TEST
   set geomInit Down
   set padTop   0
   set padLeft  0
   set defaultb {}
   
   # init base classes and set param values
   eval $self next $args
 
   # set up title of window
   
   set t [$_UIT_g_main catget $self lbl]
   switch $t {
      MSG_NOT_FOUND -
      TAG_NOT_FOUND {
	 set title $self
      }
      default {
	 set title $t
      }
   }
  
   #
   # set up initial geometry management of window.
   
   switch $geomInit {
      Down -
      Across {
	 set contents [list $geomInit $contents \
	       -padLeft $padLeft -padTop $padTop]
      }
       None -
      default {
	 # Don't add any inital geometry.
      }
   }
   
   # fill window with contents
   $_UIT_g_main set currWin $self
   $_UIT_g_main set currPath $self
   $self fillContents $contents
}


# -----------------------------------------
#@ Should this window be displayed initially?
#@ Returns zero or one.
   
_UIT_WindowGeneric instproc isInitDisplay {} {
    return [$self set display]
}


# -----------------------------------------

_UIT_WindowGeneric instproc _registerHelp {wdgt str} {
   $self set _helpStrs($wdgt) $str
}

_UIT_WindowGeneric instproc doDisplayCB {} {
   $self updateData       ;# Update data in widgets associated with window
   $self displayCB        ;# Call the display callback for the window
}

_UIT_WindowGeneric instproc display {} { $self next; $self set _visible 1 }
_UIT_WindowGeneric instproc hide {} { $self next; $self set _visible 0 }

_UIT_WindowGeneric instproc displayCB {} {;}
_UIT_WindowGeneric instproc initCB {} {;}

_UIT_WindowGeneric instproc setLabel {str} { 
   $self instvar title _displayedOnce
   set title $str 
   if $_displayedOnce {
      global _UIT_g_main
      set ui [$_UIT_g_main getUI]
      switch $ui {
	 GUI -
	 CURSES { .$self configure -title $str }
	 JAVA   { putJava "$self setLabel [safeXferString $str]" }
      }
   }
}

