#!/usr/bin/owish
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: wingui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.13  1999/02/03  18:46:02  Sandip_Savalia
# 	Code drop for baselevel 22
# 	[1999/02/03  16:41:58  Sandip_Savalia]
#
# Revision 1.1.2.45  1998/12/03  22:32:21  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:31  William_Athanasiou]
# 
# Revision 1.1.2.44  1998/10/21  13:10:39  William_Athanasiou
# 	remove focusing and curses specific stuff from wingui.tcl
# 	[1998/10/21  13:10:15  William_Athanasiou]
# 
# Revision 1.1.2.43  1998/10/20  19:44:30  William_Athanasiou
# 	Set up default accels to avoid some keys
# 	[1998/10/20  19:43:58  William_Athanasiou]
# 
# Revision 1.1.2.42  1998/10/16  20:21:16  William_Athanasiou
# 	Add esc bindings for window buttons
# 	[1998/10/16  20:20:48  William_Athanasiou]
# 
# Revision 1.1.2.41  1998/10/02  20:33:13  William_Athanasiou
# 	Add bindings for function keys for certain buttons
# 	[1998/10/02  20:32:46  William_Athanasiou]
# 
# Revision 1.1.2.40  1998/08/11  16:47:29  William_Athanasiou
# 	Expand curses window to full screen before activating
# 	[1998/08/11  16:47:03  William_Athanasiou]
# 
# Revision 1.1.2.39  1998/04/14  20:35:52  William_Athanasiou
# 	Remove puts for focus debug
# 	[1998/04/14  20:35:32  William_Athanasiou]
# 
# Revision 1.1.2.38  1998/04/10  16:15:33  William_Athanasiou
# 	fix focus and window resize issues
# 	[1998/04/10  16:14:57  William_Athanasiou]
# 
# Revision 1.1.2.37  1998/03/02  16:49:58  Todd_Moyer
# 	Cleaned up _winStack API.
# 	[1998/03/02  16:48:00  Todd_Moyer]
# 
# Revision 1.1.2.36  1998/02/26  21:35:54  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:30:44  William_Athanasiou]
# 
# Revision 1.1.2.35  1998/02/04  21:17:19  William_Athanasiou
# 	Fix min resize of window
# 	[1998/02/04  21:06:08  William_Athanasiou]
# 
# Revision 1.1.2.34  1997/08/28  18:37:19  Richard_Taft
# 	Display a watch cursor while displaying a window.
# 	Set the cursor back to default before returning from display.
# 	[1997/08/28  18:15:28  Richard_Taft]
# 
# Revision 1.1.2.33  1997/08/21  14:19:06  William_Athanasiou
# 	Don't delay lookup of window title until initial display
# 	[1997/08/20  18:43:32  William_Athanasiou]
# 
# Revision 1.1.2.32  1997/08/19  21:00:30  William_Athanasiou
# 	ignore redundant hide/display methods and allow display from initcb
# 	[1997/08/19  20:59:58  William_Athanasiou]
# 
# Revision 1.1.2.31  1997/08/18  17:11:23  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:59  William_Athanasiou]
# 
# Revision 1.1.2.30  1997/04/24  20:40:06  William_Athanasiou
# 	Fixed problem with tag used to set up default button for window
# 	[1997/04/24  16:04:09  William_Athanasiou]
# 
# Revision 1.1.2.29  1997/04/22  14:50:22  William_Athanasiou
# 	Fixed problem with _prev_focus and hiding primary/first window
# 	[1997/04/16  14:10:32  William_Athanasiou]
# 
# Revision 1.1.2.28  1997/04/07  14:44:45  William_Athanasiou
# 	Fix focus problem: If operation in subwindow causes returning focus
# 	  to be invalid (listbox buttons disabled) then focus needs to be
# 	  moved to the next focus point.
# 	[1997/04/07  14:41:42  William_Athanasiou]
# 
# Revision 1.1.2.27  1997/03/31  18:49:37  William_Athanasiou
# 	Fixed problem with redisplaying windows and buttonboxes showing up correctly
# 	[1997/03/31  18:44:59  William_Athanasiou]
# 
# Revision 1.1.2.26  1997/03/28  19:34:15  William_Athanasiou
# 	Clear pointer help when mouse leaves widget
# 	[1997/03/28  19:33:56  William_Athanasiou]
# 
# Revision 1.1.2.25  1997/03/28  16:46:48  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:28  William_Athanasiou]
# 
# Revision 1.1.2.24  1997/03/21  15:55:33  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:57  William_Athanasiou]
# 
# Revision 1.1.2.23  1997/03/13  17:45:10  William_Athanasiou
# 	Set minsize of window
# 	[1997/03/13  17:41:44  William_Athanasiou]
# 
# Revision 1.1.2.22  1997/03/07  15:40:45  William_Athanasiou
# 	no changes
# 	[1997/03/07  15:02:14  William_Athanasiou]
# 
# Revision 1.1.2.21  1997/02/24  19:17:35  William_Athanasiou
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:11:03  William_Athanasiou]
# 
# Revision 1.1.2.20  1997/01/23  19:28:17  William_Athanasiou
# 	Added displayCB functionality/removed read from display function
# 	[1997/01/23  19:23:22  William_Athanasiou]
# 
# Revision 1.1.2.19  1997/01/16  20:37:44  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:37  William_Athanasiou]
# 
# Revision 1.1.2.18  1997/01/16  14:16:06  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:15:25  William_Athanasiou]
# 
# Revision 1.1.2.17  1996/12/23  16:45:50  William_Athanasiou
# 	Removed puts
# 	[1996/12/23  16:44:04  William_Athanasiou]
# 
# Revision 1.1.2.16  1996/12/20  19:36:24  William_Athanasiou
# 	Fixed winStack problem.  Windows not being popped
# 	[1996/12/20  19:34:17  William_Athanasiou]
# 
# Revision 1.1.2.15  1996/11/25  15:29:50  Deepa_Bachu
# 	renamed popStack     -> _popDisplayStack
# 	and     displayWin   -> _pushDisplayStack
# 	passed the arguement $self to _popDisplayStack to ensure
# 	that only the top most window in the stack can be popped.
# 	[1996/11/25  15:28:16  Deepa_Bachu]
# 
# Revision 1.1.2.14  1996/11/22  20:50:05  Deepa_Bachu
# 	Removed references to the _UIT_WindowGUI class member variable and
# 	used the cham object's _winStack attribute instead.
# 	[1996/11/22  20:35:08  Deepa_Bachu]
# 
# Revision 1.1.2.13  1996/11/11  15:26:57  William_Athanasiou
# 	Added winStack to keep track of windows being displayed.
# 	Added prev_grab to keep track of previous grab
# 	Added prev_focus to keep track of previous focus.
# 	Added hide method to remove window from screen.
# 	All windows are made transient to the first window displayed.
# 	All windows are modal.
# 	[1996/11/05  16:55:17  William_Athanasiou]
# 
# Revision 1.1.2.12  1996/10/29  15:01:48  William_Athanasiou
# 	Fixed problem with window buttonbox not forcing resize of window
# 	[1996/10/29  14:56:48  William_Athanasiou]
# 
# Revision 1.1.2.11  1996/10/01  19:37:05  William_Athanasiou
# 	Check for missed print string
# 	[1996/10/01  19:35:57  William_Athanasiou]
# 
# Revision 1.1.2.10  1996/09/25  15:22:55  William_Athanasiou
# 	Added wmclose processing and setting up a default button
# 	[1996/09/25  15:21:42  William_Athanasiou]
# 
# Revision 1.1.2.9  1996/09/25  13:22:46  William_Athanasiou
# 	Find title of window from message catalog and set title variable
# 	[1996/09/25  13:17:45  William_Athanasiou]
# 
# Revision 1.1.2.8  1996/09/24  21:51:19  William_Athanasiou
# 	Added title to window
# 	[1996/09/24  21:47:38  William_Athanasiou]
# 
# Revision 1.1.2.7  1996/09/24  21:10:46  Todd_Moyer
# 	Fixed merge screwup.
# 	[1996/09/24  21:07:57  Todd_Moyer]
# 
# Revision 1.1.2.6  1996/09/24  21:03:36  Todd_Moyer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.4 **
# 		** Merge revision:	1.1.2.5 **
# 	 	** End **
# 	Set currParent before creating buttons.
# 	[1996/09/24  20:56:48  Todd_Moyer]
# 
# Revision 1.1.2.5  1996/09/24  19:58:10  William_Athanasiou
# 	Removed window display creation from init method to allow
# 		CURSES window class to inherit the GUI window class
# 		but build a slightly different window.
# 	[1996/09/24  14:31:36  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/09/24  14:17:35  William_Athanasiou
# 	Created code to display window
# 	Uses buttonbox to contain buttons created for bottom
# 		of window.
# 	[1996/09/23  21:35:11  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/06  18:41:52  Todd_Moyer
# 	Use a containWdgt instance var so child knows where to create widgets.
# 	[1996/09/06  18:37:21  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/08/30  18:41:29  Deepa_Bachu
# 	This file contains the common methods of the _UIT_WindowGUI class.
# 	[1996/08/30  17:41:30  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: wingui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 

Class _UIT_WindowGUI -superclass _UIT_WindowGeneric

_UIT_WindowGUI instproc init {contents args} {
   global _UIT_g_main
   $self instvar buttons title _parent _occluded

   set _occluded 0
   eval {$self next $contents} $args

   # Create the buttons for the window
   #
   $_UIT_g_main set currParent $self
   foreach i $buttons {
      Button $i
   }
   $_UIT_g_main set currParent $_parent
}


_UIT_WindowGUI instproc display {} {
   global _UIT_g_main
   $self instvar _displayedOnce _visible defaultb
  
   if {!$_displayedOnce} {
      incr _displayedOnce

      $self instvar buttons title containWdgt wmclose defaultb \
	    _parent  _workingMsg _doneMsg

      set _workingMsg [$_UIT_g_main catget working txt]
      set _doneMsg    [$_UIT_g_main catget done txt]

      # Build window and point top frame to childsite.
      #
      _UIT_Dialogshell .$self
      set containWdgt [.$self childsite]

      $self _setCursor watch
      
      # now we can set the title and fill in the buttonbox
      
      .$self configure -title $title
      $_UIT_g_main set currParent $self
      foreach i $buttons {
	 .$self add $self.$i
	 $self _specialButtonHook $i
      }
      $_UIT_g_main set currParent $_parent
      
      if {[info exists wmclose] && [lsearch -exact $buttons $wmclose] != -1} {
	 wm protocol .$self WM_DELETE_WINDOW "$self.$wmclose invokeWrapper"
      }
      
      if {[info exists defaultb] && \
	    [lsearch -exact $buttons $defaultb] != -1} {
		  .$self default $self.$defaultb
		  bind .$self <Return> "$self.$defaultb invokeWrapper"
      }
   }

   $self doDisplayCB
   if {$_visible} {
      $self _setCursor default
      return
   }
   $self next

   $self _showWindow [$_UIT_g_main getTopWin]
   $_UIT_g_main pushDisplayStack $self	
}

_UIT_WindowGUI instproc _specialButtonHook {i} {
   return
}

_UIT_WindowGUI instproc _showWindow {parent} {
   if { ! [cequal $parent $self] && ! [cequal $parent {}]} {
      wm group .$self .$parent
      wm transient .$self .$parent
      .$self center .$parent
   } else {
      wm transient .$self
      .$self center
   }
   
   .$self activate
   update idletasks
   #
   # Set the minimum size for the window.  At this point, the window's
   # contents have been established, and the req{width,height} are accurate
   #
   wm minsize .$self [winfo reqwidth .$self] [winfo reqheight .$self]
   $self _setCursor default
}

_UIT_WindowGUI instproc hide {} {
   $self instvar _visible
   if {!$_visible} {return}

   $self next
   .$self deactivate
   global _UIT_g_main
   $_UIT_g_main popDisplayStack $self   
}

_UIT_WindowGUI instproc _updateHelp {wdgt} {
   $self instvar _helpStrs 
   if {![info exists _helpStrs($wdgt)]} {
      .$self updateHelp $wdgt
   } else {
      .$self updateHelp $_helpStrs($wdgt)
   }
}

_UIT_WindowGUI instproc _registerUImap {ui wdgt} {
   bind $ui <Enter> "$self _updateHelp $wdgt"
   bind $ui <Leave> ".$self updateHelp {}"
   foreach child [winfo children $ui] {
      $self _registerUImap $child $wdgt
   }
}

_UIT_WindowGUI instproc _setCursor {cursor} {
   if [cequal $cursor default] {
      set cursor {}
   }
   .$self config -cursor $cursor
}

_UIT_WindowGUI instproc _makeBusy {} {
   .$self configure -busy 1
}

_UIT_WindowGUI instproc _makeNotBusy {} {
   .$self configure -busy 0
}

_UIT_WindowGUI instproc _startWorking {{ndx -1}} {
   $self instvar _workingMsg _doneMsg _helpChanged _occluded
   
   if {[cequal [busy isbusy .$self] .$self] && !$_occluded} {
      # do while window still busy
      if [expr $ndx > -1] {
	 set sequence {| / - \\}
	 $self _updateHelp [format "%s   %s" $_workingMsg \
				[lindex $sequence $ndx]]
	 set _helpChanged 1
      } else {
	 set _helpChanged 0
      }
      after 200 "$self _startWorking [expr [incr ndx] % 4]"
   } else {
      # window nolonger busy, so change msg
      if $_helpChanged {
	 $self _updateHelp $_doneMsg
      }
   }
}
