#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: winjava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.7  1998/03/26  20:01:26  Anthony_Hoffman
# 	BL 16 shared sandbox submit
# 	[1998/03/25  19:05:19  Anthony_Hoffman]
#
# Revision 1.1.2.14  1998/03/05  15:07:35  William_Athanasiou
# 	Fixed problem with jprotocol mismatch due to addition of default button
# 	[1998/03/05  15:05:35  William_Athanasiou]
# 
# Revision 1.1.2.13  1998/02/26  21:35:55  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:30:48  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/11/06  19:58:23  William_Athanasiou
# 	Replace all quoted strings with a call to safeXferString
# 	[1997/11/06  19:56:57  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/08/27  18:40:46  William_Athanasiou
# 	check for existance of wmclose in button list
# 	[1997/08/27  18:34:18  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/08/22  18:46:23  William_Athanasiou
# 	do displayCB before window display/Fix protocol: no trailing blanks
# 	[1997/08/22  18:36:22  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/08/21  14:19:07  William_Athanasiou
# 	Don't delay lookup of window title until initial display
# 	[1997/08/20  18:43:36  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/08/20  13:00:53  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.5 **
# 		** Merge revision:	1.1.2.7 **
# 	 	** End **
# 	Added call to doDisplayCB in display so that values get updated after workon
# 	[1997/07/24  19:38:21  Richard_Taft]
# 
# Revision 1.1.2.7  1997/08/19  21:00:31  William_Athanasiou
# 	ignore redundant hide/display methods and allow display from initcb
# 	[1997/08/19  21:00:00  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/08/18  17:11:23  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:18:02  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/07/10  19:26:37  Richard_Taft
# 	Modified display to output creation information if _javaKnowsMe
# 	is false; display statement otherwise.
# 	Added hide procedure.
# 	[1997/07/10  18:52:28  Richard_Taft]
# 
# Revision 1.1.2.4  1997/07/02  19:01:23  Deepa_Bachu
# 	Modified the creation code being sent to the applet.
# 	[1997/07/02  18:57:24  Deepa_Bachu]
# 
# Revision 1.1.2.3  1997/06/23  12:58:26  Deepa_Bachu
# 	modified the text being displayed.
# 	[1997/06/23  12:57:39  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/06/19  15:26:57  Deepa_Bachu
# 	Initial WindowJAVA class.
# 	[1997/06/19  15:25:40  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: winjava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 

Class _UIT_WindowJAVA -superclass _UIT_WindowGeneric

_UIT_WindowJAVA instproc init {contents args} {
    global _UIT_g_main
    $self instvar _parent

    eval $self next [list $contents] $args ;# do parents init

    # create window buttons for the window
    $_UIT_g_main set currParent $self
    foreach i [$self set buttons] {
	Button $i
    }
    $_UIT_g_main set currParent $_parent
}

_UIT_WindowJAVA instproc display {} {
   $self instvar _displayedOnce _visible
    
   $self doDisplayCB
   if {!$_displayedOnce} {
      # communicate window name and options to the java applet
      $self instvar title buttons wmclose defaultb
      
      putJava_noNL "_UIT_Window $self [safeXferString $title] \{"
      foreach buttonName $buttons {
	 putJava_noNL " \{"
	 $self.$buttonName display putJava_noNL
	 putJava_noNL " \}"
      }

      if {[lsearch -exact $buttons $defaultb] != -1} {
	 set defB $defaultb
      } else {
	 set defB ""
      }

      if {[lsearch -exact $buttons $wmclose] != -1} {
	 putJava_noNL " \} [safeXferString $wmclose] [safeXferString $defB]"
      } else {
	 putJava_noNL " \} [safeXferString ""] [safeXferString $defB]"
      }

      # do kids display
      foreach k [$self set _kids] {
	 $k display      ;# buttons for window won't display again.
      }
      
      # send end of container message
      putJava "\}"
   
      incr _displayedOnce
      $self next
   } else {
      if {!$_visible} {
	 putJava "$self display"
      }
      $self next
      return
   }
   
}


_UIT_WindowJAVA instproc hide {} {
   if {![$self set _visible]} {return}
   $self next
   putJava "$self hide"
}

