# 
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
# 
# @(#)$RCSfile: cw_ListEdit.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:30 $
# 


# ----------------------------------------------------------------------
# A composite widget to add and delete names from a listbox.
# ----------------------------------------------------------------------

# For doing class initialization.  Not currently used.
proc cw_ListEdit.Init {} {
    global sm_ListEdit
}


# ----------------------------------------------------------------------
# Construct a composite widget to add and delete names from a listbox.
# The object and its data will NOT have a leading .
# The containing frame widget will have the leading .
# cbs {addCB delCB}:
#     Will be called during their respective operations if not null.
#     If they return <= zero, operation aborted.
# butTxt {addButtonText deleteButtonText}
# lbls {listboxLabel entryLabel}:
#     Either will be omitted if "" is specified.
# static data:
#   none
# member data:
#   addBut
#   addCB
#   butFrm
#   delBut
#   delCB
#   ent
#   entFrm
#   entLbl
#   entVar
#   lb
#   lbLbl

proc cw_ListEdit {name cbs butTxt lbls args} {
    global cw_ListEdit

    # trim leading . if necessary
    if {[string index $name 0] == "\."} {
	set name [crange $name 1 end]
    }
    global $name

    set ${name}(className) cw_ListEdit

    # name widgets
    set ${name}(lb)      .$name.listbox
    set ${name}(entFrm)  .$name.entryFrame
    set ${name}(ent)     .$name.entryFrame.entry
    set ${name}(butFrm)  .$name.buttonFrame
    set ${name}(addBut)  .$name.buttonFrame.addButton
    set ${name}(delBut)  .$name.buttonFrame.deleteButton

    set ${name}(addCB)  [lindex $cbs 0]
    set ${name}(delCB)  [lindex $cbs 1]

    set addLblTxt  [lindex $butTxt 0]
    set delLblTxt  [lindex $butTxt 1]
    if {$addLblTxt == ""} {
	set addLblTxt "Add"
    }
    if {$delLblTxt == ""} {
	set delLblTxt "Delete"
    }

    # segregate options
    set lbOpts  "$args"
    set entOpts "-textvariable ${name}(entVar)"
    set hIdx [lsearch -exact $args {-width}]
    if {$hIdx >= 0} {
	append entOpts " [lrange   $args $hIdx [expr $hIdx + 1]]"
    }
    # DEBUG puts "ent $entOpts"
    # DEBUG puts "lb $lbOpts"

    set lbLblTxt   [lindex $lbls 0]
    set entLblTxt  [lindex $lbls 1]

    if {$lbLblTxt == ""} {
	set ${name}(lbLbl)   ""
    } else {
	set ${name}(lbLbl)   .$name.listboxLabel
    }
    if {$entLblTxt == ""} {
	set ${name}(entLbl)   ""
    } else {
	set ${name}(entLbl)   .$name.entryFrame.label
    }


    # set up proc for instance that calls appropriate method
    eval [subst -nocommand {proc $name {meth args} {
	set cmd "cw_ListEdit.\$meth $name \$args" ; return [eval \$cmd]}
    }]

    # create widgets
    frame .$name -class smCompositeListEdit
    if {$lbLblTxt != ""} {
	label [set ${name}(lbLbl)] \
		-text $lbLblTxt
    }
    eval "listbox [set ${name}(lb)] $lbOpts"
    frame [set ${name}(entFrm)]
    if {$entLblTxt != ""} {
	label [set ${name}(entLbl)] \
		-text $entLblTxt
    }
    set ${name}(entVar) ""
    eval "entry [set ${name}(ent)] $entOpts"
    frame [set ${name}(butFrm)]
    button [set ${name}(addBut)] \
		-state disabled \
		-text $addLblTxt \
		-width 10
    button [set ${name}(delBut)] \
		-state disabled \
		-text  $delLblTxt \
		-width 10

    # pack widgets
    if {[set ${name}(lbLbl)] != ""} {
	pack [set ${name}(lbLbl)]  -anchor w
    }
    pack [set ${name}(lb)]     -expand 1 -fill both
    if {[set ${name}(entLbl)] != ""} {
	pack [set ${name}(entLbl)]   -side left
    }
    pack [set ${name}(ent)]    -side left -expand 1 -fill x
    pack [set ${name}(entFrm)] -fill x
    pack [set ${name}(addBut)] -side left -expand 1
    pack [set ${name}(delBut)] -side left -expand 1
    pack [set ${name}(butFrm)] -anchor s -fill x
#    pack [set ${name}(butFrm)] -anchor s -pady 3 -fill x

    # set up commands and bindings
    # put class before inst so keystroke is in var before calling inst callbacks
    sm_reverseClassInstanceBinding [set ${name}(ent)]
    bind [set ${name}(lb)]  <1>        "$name _SelectCB %y"
    bind [set ${name}(ent)] <Any-Key>  "$name _EntryCB"
    [set ${name}(addBut)] configure -command  "$name _AddCB"
    [set ${name}(delBut)] configure -command  "$name _DelCB"

    return $name
}


# ----------------------------------------------------------------------
# Destroy widget.

proc cw_ListEdit.~ {this} {
    global cw_ListEdit
    global $this
}


# ----------------------------------------------------------------------
# Return listbox contents in the form of a list.

proc cw_ListEdit.Get {this} {
    global cw_ListEdit
    global $this

    return [[set ${this}(lb)] get 0 end]
}


# ----------------------------------------------------------------------
# Set listbox contents.

proc cw_ListEdit.Set {this newList} {
    global cw_ListEdit
    global $this

    [set ${this}(lb)] delete 0 end
    foreach item $newList {
	[set ${this}(lb)] insert end $item
    }
}


#-----------------------------------------------------------
# internal callbacks. called automatically.
#-----------------------------------------------------------

proc cw_ListEdit._SelectCB {this yVal} {
    global cw_ListEdit
    global $this

    if { [[set ${this}(lb)] nearest $yVal] != -1 } {
	[set ${this}(delBut)] configure -state normal
    } else {
	[set ${this}(delBut)] configure -state disabled
    }
}


#-----------------------------------------------------------
proc cw_ListEdit._EntryCB {this} {
    global cw_ListEdit
    global $this

    set topLev [sm_getToplevelName [set ${this}(ent)]]
    set addVal [set ${this}(entVar)]

    if {$addVal != "" } {
	[set ${this}(addBut)] configure -state normal
    } else {
	[set ${this}(addBut)] configure -state disabled
    }
    sm_setDispositionButtonStates $topLev modified
}


#-----------------------------------------------------------
proc cw_ListEdit._AddCB {this} {
    global cw_ListEdit
    global $this

    set topLev [sm_getToplevelName [set ${this}(addBut)]]
    set addVal [set ${this}(entVar)]

    if {$addVal == "" } {
	[set ${this}(addBut)] configure -state disabled
	return
    }

    set newList [[set ${this}(lb)] get 0 end]
    lappend newList $addVal

    # do data specific validation
    if {[set ${this}(addCB)] != ""} {
	if {[eval [set ${this}(addCB)] [list $newList] [list $addVal]] <= 0} {
 	    return
	}
    }

    # select new item
    [set ${this}(lb)] insert end $addVal
    set new_selection [[set ${this}(lb)] size]
    [set ${this}(lb)] selection clear 0 end
    [set ${this}(lb)] selection set $new_selection
    [set ${this}(lb)] see $new_selection

    [set ${this}(ent)] delete 0 end
    [set ${this}(delBut)] configure -state normal
    [set ${this}(addBut)] configure -state disabled
    sm_setDispositionButtonStates $topLev modified
}


#-----------------------------------------------------------
proc cw_ListEdit._DelCB {this} {
    global cw_ListEdit
    global $this

    set topLev [sm_getToplevelName [set ${this}(delBut)]]
    set currIdx [[set ${this}(lb)] curselection]	

    if {$currIdx == "" } {
	[set ${this}(delBut)] configure -state disabled
	return
    }

    set delVal  [[set ${this}(lb)] get $currIdx]
    set newList [[set ${this}(lb)] get 0 end]
    set newList [setSubtract $newList $delVal]

    # do data specific validation
    if {[set ${this}(delCB)] != ""} {
	if {[eval [set ${this}(delCB)] [list $newList] [list $delVal]] <= 0} {
	    return
	}
    }

    [set ${this}(lb)] delete $currIdx
    set currSize [[set ${this}(lb)] size]
    if { $currSize > 0 } {
	if { $currSize > $currIdx } {
	    [set ${this}(lb)] selection set $currIdx
	    [set ${this}(lb)] see $currIdx
	} else {
	    [set ${this}(lb)] selection set $currSize
	    [set ${this}(lb)] see $currIdx
	}
    } else {
	[set ${this}(delBut)] configure -state disabled
    }
    sm_setDispositionButtonStates $topLev modified
}


# -----------------------------------------------------------
# Demo, sanity test and provide an example of the object.
# -----------------------------------------------------------

proc cw_ListEdit.Demo {} {

    toplevel .t
    set parent .t.f
    frame $parent

    set leName [crange $parent 1 end]     ;# get rid of leading .

    # constructor will trim leading . if necessary
    set ed1 [cw_ListEdit  $parent.listEdit1 {_cw_ListEdit_Demo_isNumeric} \
	    {"Adding it" "Deleting it"} {"Numeric List:"}]
    set ed2 [cw_ListEdit  $leName.listEdit2 {"" _cw_ListEdit_Demo_isNotEmpty} \
	    {} {"" things:}]
    puts "$ed1 $ed2"
    $ed2 Set {"one thing" "and another" "and still one more"}

    pack .$ed1 -pady 5 -expand 1 -fill both
    pack .$ed2         -expand 1 -fill both
    pack $parent
}


# ----------------------------------------------------------------------
proc _cw_ListEdit_Demo_isNotEmpty {newList newVal} {
    if {[llength $newList] <= 0} {
	puts -nonewline "\a"
	return 0
    }
    return 1
}


# ----------------------------------------------------------------------
proc _cw_ListEdit_Demo_isNumeric {newList newVal} {
    if {! [regexp {^[-+]?[0-9]+\.?[0-9]*$} $newVal]} {
	puts -nonewline "\a"
	return 0
    }
    return 1
}


# ----------------------------------------------------------------------
proc _cw_ListEdit_Demo_IsmAddCB {newList newVal} {
    global mcv_protocolItems
    global SCode

    if { [ItmMgr $mcv_protocolItems($protocolType,Item) set $attribute \
	    $newAliasList] != $SCode(OK) } {
	ShowWindow.mc_errorMessage .$topLev \
		"mc_aliasAddCB: $newAlias is invalid."
	return 0
    }
    return 1
}


# ----------------------------------------------------------------------

# DEBUG sm_applicationToolsInitialization

cw_ListEdit.Init

# DEBUG cw_ListEdit.Demo
# DEBUG bind all <3> {puts "%W"}

#-----------------------------------------------------------
#-----------------------------------------------------------
