# 
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
# 
# @(#)$RCSfile: cw_ScrolledFrame.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:30 $
# 


# -----------------------------------------------------------
# Initialize class.

proc ScrolledFrame.Init {} {
    global ScrolledFrame
}


# -----------------------------------------------------------
# Create a frame on a resizable canvas with a vertical scrollbar.
# Return the outer frame that contains the canvas.
# member data:
#   canvas
#   innerFrame

proc ScrolledFrame {name} {

    # trim leading . if necessary
    if {[string index $name 0] == "\."} {
	set name [crange $name 1 end]
    }
    global $name

    # name widgets
    set outFrame             .$name
    set vsb                  .$name.vsb
    set ${name}(canvas)      .$name.can
    set ${name}(innerFrame)  .$name.can.innerFrame

    # set up proc for instance that calls appropriate method
    eval [subst -nocommand {proc $name {meth args} {
	set cmd "ScrolledFrame.\$meth $name \$args" ; return [eval \$cmd]}
    }
    ]

    # create and manage widgets
    frame     $outFrame             -relief sunken -borderwidth 2
    scrollbar $vsb -orient vertical -command [list [set ${name}(canvas)] yview]
    canvas    [set ${name}(canvas)] -width 10 -height 10 \
	    -yscrollcommand [list $vsb set]
    frame     [set ${name}(innerFrame)] -bd 0
    set fId [[set ${name}(canvas)] create window 0 0 -anchor nw \
	    -window [set ${name}(innerFrame)]]
    pack $vsb                  -side right  -fill y
    pack [set ${name}(canvas)] -side left   -fill both  -expand true

    # when canvas resizes need to call frame resize explicitly because it's
    # geometry is managed by the canvas
    bind [set ${name}(canvas)] <Configure> \
	    "[set ${name}(canvas)] itemconfig $fId -width %w"

    return $name
}


# -----------------------------------------------------------
# Get the inner frame to fill it.

proc ScrolledFrame.GetInnerFrame {this} {
    global $this
    return [set ${this}(innerFrame)]
}


# -----------------------------------------------------------
# Set a canvas's viewport size, scroll region and y scroll increment based
# on its frame child and the child's contents.
# Good for initial setup.
# THE CHILD MUST BE VISIBLE OR IN THE PROCESS OF BECOMING VISIBLE.
# THE TOPLEVEL MUST HAVE:  'wm focusmodel .toplevel active'
# params:
#   unitWdgt  height determines vertical units
#   numShow   upper limit of viewport height in "unitWdgt" units

proc ScrolledFrame.Size {this unitWdgt numShow} {

    global $this

    # wait for the window to become visible and then
    # set up the scroll region and increment based on
    # the size of the frame and the subframes
    # DEBUG puts "waiting for idletasks"
    update idletasks
    # DEBUG puts "done waiting"

    set frame     [set ${this}(innerFrame)]
    set can       [set ${this}(canvas)]
    set oneHeight [winfo reqheight  $unitWdgt]
    set width     [winfo reqwidth   $frame]
    set height    [winfo reqheight  $frame]
    $can config -scrollregion "0 0 $width $height"
    $can config -yscrollincrement $oneHeight

    # Set viewport size to size of frame with height limited to "numShow"
    # child units.
    # DEBUG puts "before $oneHeight $width $height"
    if {$height > $numShow * $oneHeight} {
	set height [expr $numShow * $oneHeight]
    }
    # DEBUG puts "after $oneHeight $width $height"
    $can config -width $width -height $height      ;# set viewport size
}


# -----------------------------------------------------------
# Test the previous procs and provide an example.

proc ScrolledFrame.Demo {} {

  # ScrolledFrame returns object name, NOT widget name.
  # eg, top.name not .top.name
  set ftmp  [frame .f]
  set f1    [ScrolledFrame .f.f1]
  set inFr  [$f1 GetInnerFrame]

  set l [frame $inFr.lcol]
  set r [frame $inFr.rcol]
  foreach lbl {alpha beta gamma delta epsilon zeta eta theta} {
    label $l.l$lbl -text $lbl
    entry $r.e$lbl
    pack $l.l$lbl -side top -anchor w -expand true
    pack $r.e$lbl -side top -fill x
  }
  pack  $l  -side left   -fill y
  pack  $r  -side right  -fill both -expand true
  pack .$f1              -fill both -expand true
  # DO NOT PACK INNERFRAME (inFr)!  IT'S ALREADY MANAGED BY THE CANVAS

  set child [lindex [pack slaves $r] 0]
  $f1 Size $child 5



  set f2   [ScrolledFrame .f.f2]
  set inFr [$f2 GetInnerFrame]
  set i 0
  set l [frame $inFr.lcol]
  set r [frame $inFr.rcol]
  foreach at {AF BR CF DF DN DU FC FF FS GF IF LF LO MC MX NF OF PL \
	      PP PW PX PY RF SD ST TF TR VF XC XF XS YA YD YP YS YT} {
    label $l.l$i -text $at
    entry $r.e$i -textvariable x$i
    pack $l.l$i -side top -anchor w -expand true
    pack $r.e$i -side top -fill x
    incr i
      }
  pack  $l -side left   -fill y
  pack  $r -side right  -fill both -expand true
  pack .$f2             -fill both -expand true
  set child [lindex [pack slaves $r] 0]
  $f2 Size $child 7

  pack .f              -fill both -expand yes
}


# -----------------------------------------------------------

  ScrolledFrame.Init

# DEBUG  bind all <3> {puts "%W"}
# DEBUG  ScrolledFrame.Demo
