#!/usr/share/sysman/bin/sysmansh

# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
#

#---------------------------------------------------------------#
#
#  Evm Class definitions
#
#
#  The Evm class describes an instance of an evm object.  The
#   evm object can then be used to build a specific event.  The
#   event can be posted or subscribed to.  All of the tcl object
#   arguments are used by the post/subscribe methods in order to
#   interface with the evm subsystem.
#
#---------------------------------------------------------------#


# Class Event (This is defined in the interpreter)

Event instproc post {args} {
    $self instvar _status

#---------------------------------------------------------------#
#
#  Just call the internal post, it does all the work.
#   $shouldwait is a no-op right now which always does a wait.
#   This means we are always waiting for a response from the demon
#   before returning from the _post
#
#---------------------------------------------------------------#

    if {$args != {}} {
        $self set %name $args
    }

    $self _post 
}

#---------------------------------------------------------------#
#
#   Dump internal contents of the event
#
#---------------------------------------------------------------#

Event instproc _dump {args} {
    set result {}
    foreach i [lsort [$self info vars]] {
        append result "$i=[$self set $i]\n"
    }
    return $result
}

#---------------------------------------------------------------#
#
#   Return the varible contents of the object in a name/value pair
#    list suitable for using with the "array set" command.
#
#---------------------------------------------------------------#

Event instproc dump {} {

    set result {}
    foreach i [lsort "[$self vars] [$self info vars %*]"] {
        append result "$i {[$self set $i]} "
    }

    return $result
}


Event instproc _vars {{all {}}} {
    set varlist [$self info vars]
    set exclude "[lmatch -glob $varlist _*] [lmatch -glob $varlist *_TYPE] [lmatch -glob $varlist *_MSGID]"
    if {$all == {}} {
        append exclude " [lmatch -glob $varlist %*]"
    }
    return [lindex [intersect3 $varlist $exclude] 0]
}

Event instproc vars {{all {}}} {
    $self _vars $all
}

#---------------------------------------------------------------#
#
#   Subscribe to an event.
#
#   object subscribe wait|nowait [callbackscript [eventfilter]]
#
#---------------------------------------------------------------#

Event instproc subscribe {{shouldwait {nowait}} args} {

    $self instvar _callback %filter
    $self instvar _status
    set _status "ok"

    if {$args != {}} {
        lassign $args eventcmdCB eventfilter 
        set _callback $eventcmdCB
        if {$eventfilter != {}} {
            $self setFilter $eventfilter
        }
    }

    $self _subscribe $shouldwait
}


#---------------------------------------------------------------#
#
#    Format the contents of an event
#
#---------------------------------------------------------------#

Event instproc format {} {
    $self _format
}

#---------------------------------------------------------------#
#
#  Wait for an event to occur.  This will block the tcl interpreter
#   until an event matching the filter criteria has occurred.
#
#---------------------------------------------------------------#

Event instproc wait {args} {

    $self _wait
}

#---------------------------------------------------------------#
#
#
#   Cancel the current subscription, this close down the
#    associated event connection and prevent further callbacks
#
#---------------------------------------------------------------#

Event instproc cancel {args} {

    $self _cancel
}

#---------------------------------------------------------------#
#
#   Object data manipluation routines:
#
#
#    get/set filter  - User defined event filter
#    get/set name    - User defined event name
#    get/set format  - User defined format string
#    get/set var     - User defined event variables
#
#---------------------------------------------------------------#


Event instproc getFilter {args} {
    $self set  _filter
}

Event instproc setFilter {eventfilter args} {
    $self set _filter $eventfilter
}

Event instproc status {args} {
    $self set _status
}

Event instproc getVar {name} {
    if {[$self info vars $name] != {} } {
	set result [$self set $name]
    } else {
    	set result "event variable not found"
    }
}

Event instproc getType {name} {
    if {[$self info vars ${name}_TYPE] != {} } {
	set result [$self set ${name}_TYPE]
    } else {
    	set result "event TYPE variable not found"
    }
}

Event instproc setVar {name type value args} {
    $self set ${name}_TYPE $type
    if {$type == "STRING"} {
        if {$args != {}} {
            $self set ${name}_MSGID $args
        }
    }

    $self set $name $value
}




proc testme {args} {
	testproc
}
