#!/usr/share/sysman/bin/sysmansh
## 
## *****************************************************************
## *                                                               *
## *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
## *                                                               *
## *   The software contained on this media  is  proprietary  to   *
## *   and  embodies  the  confidential  technology  of  Compaq    *
## *   Computer Corporation.  Possession, use,  duplication  or    *
## *   dissemination of the software and media is authorized only  *
## *   pursuant to a valid written license from Compaq Computer    *
## *   Corporation.                                                *
## *                                                               *
## *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
## *   by the U.S. Government is subject to restrictions  as  set  *
## *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
## *   or  in  FAR 52.227-19, as applicable.                       *
## *                                                               *
## *****************************************************************
#
# HISTORY
# 
## @(#)$RCSfile: helpOnItem.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:30 $
## 

proc HelpOnItemInit applicationName {

	global helpOnItemFlag

	set mainClass [winfo class .]

	set widgetEvents { \
		<Enter> \
		<FocusIn> \
	}

	foreach event $widgetEvents {
		bind $mainClass $event "checkAndSetTags %W"
		bind Toplevel $event "checkAndSetTags %W"
	}

	set helpOnItemFlag FALSE

	bind HelpTag <Button-1> "HelpOnItemCheck $applicationName %W"
	bind all <F1> "HelpF1 $applicationName"
}

proc checkAndSetTags w {

	if { [lsearch -exact [bindtags $w] HelpTag] == -1 } {
		bindtags $w [ setAdd [bindtags $w] HelpTag ]
		set childrenList {}
		windowWidgetTree $w childrenList
		foreach child $childrenList {
			bindtags $child [ setAdd [bindtags $child] HelpTag ]
		}
	}
}

proc setAdd { setList element } {

	if { [lsearch -exact $setList $element] == -1 } {
		set setList [linsert $setList 0 $element]
	}
	
	return $setList
}

proc setSubtract { setList element } {

	set index [lsearch -exact $setList $element]
	if { $index != -1 } {
		set setList [lreplace $setList $index $index]
	}
	
	return $setList
}

proc HelpOnItemSet {} {
	global helpOnItemFlag
	global helpOnItemCursor

	set helpOnItemFlag TRUE

	checkAndSetTags [focus]
	set allToplevels ""
	widgetsByClass . Toplevel allToplevels
	foreach tl $allToplevels {
		set helpOnItemCursor($tl) [$tl cget -cursor]
		$tl configure -cursor question_arrow
	}

	set helpOnItemCursor(.) [. cget -cursor]
	. configure -cursor question_arrow
}


proc HelpOnWidget { applicationName widget } {
	global helpTagRegistry

	for {set w $widget} {$w != ""} {} {
		if {	![info exists helpTagRegistry($applicationName,$w,setNum)] ||
			![info exists helpTagRegistry($applicationName,$w,msgNum)] } {
			if { $w == "." } {
				ShowWindow.HelpOnItemError $widget
				return
			}
			set w [winfo parent $w]
			continue
		} else {
			HelpOnline $applicationName \
				$helpTagRegistry($applicationName,$w,setNum) \
				$helpTagRegistry($applicationName,$w,msgNum) \
				$helpTagRegistry($applicationName,$w,defaultLocid)
			return
		}
	}
}


proc HelpOnItemCheck { applicationName widget } {
	global helpOnItemFlag
	global helpOnItemCursor
	global helpTagRegistry

	if { $helpOnItemFlag == "TRUE" } {
		set helpOnItemFlag FALSE

		foreach tl [array names helpOnItemCursor] {
			$tl configure -cursor $helpOnItemCursor($tl)
			unset helpOnItemCursor($tl)
		}

		for {set w $widget} {$w != ""} {} {
			if {	![info exists helpTagRegistry($applicationName,$w,setNum)] ||
				![info exists helpTagRegistry($applicationName,$w,msgNum)] } {
				if { $w == "." } {
					ShowWindow.HelpOnItemError $widget
					return -code break
				}
				set w [winfo parent $w]
				continue
			} else {
				HelpOnline $applicationName \
					$helpTagRegistry($applicationName,$w,setNum) \
					$helpTagRegistry($applicationName,$w,msgNum) \
					$helpTagRegistry($applicationName,$w,defaultLocid)
				return -code break
			}
		}

	}
}


proc HelpF1 { appName } {
	global helpOnItemFlag

	while 1 {
		set helpOnItemFlag "TRUE"
		HelpOnItemCheck $appName [focus]
		set helpOnItemFlag "FALSE"
	}
}


proc HelpOnItemRegister { widget appName setNum msgNum {defaultLocid {G _hometopic}} } {
	global helpTagRegistry

	set helpTagRegistry($appName,$widget,setNum) $setNum
	set helpTagRegistry($appName,$widget,msgNum) $msgNum
	set helpTagRegistry($appName,$widget,defaultLocid) $defaultLocid
}


proc ShowWindow.HelpOnItemError { widgetName } {

	catch "destroy .helpOnItemError"

	# build widget .helpOnItemError
	toplevel .helpOnItemError

	# Window manager configurations
	wm title .helpOnItemError {Help Error}
	wm transient .helpOnItemError .

	tkwait visibility .helpOnItemError
	grab set .helpOnItemError

	# build widget .helpOnItemError.label7
	label .helpOnItemError.label7 \
		-borderwidth {15} \
		-text "There is no on item help tag registered for widget:\n\n $widgetName"

	# build widget .helpOnItemError.button8
	button .helpOnItemError.button8 \
		-command {DestroyWindow.HelpOnItemError} \
		-text {Press to dismiss}

	# pack widget .help
	pack .helpOnItemError.label7 -side top -anchor center
	pack .helpOnItemError.button8 -side top -anchor n -pady 15
}

proc DestroyWindow.HelpOnItemError {} {

	grab release .helpOnItemError

	catch "destroy .helpOnItemError"
	update
}

proc completeWidgetTree { parent memberList} {

	upvar $memberList newList
	foreach child [winfo children $parent] {
		completeWidgetTree $child newList
		lappend newList $child
	}
}

proc windowWidgetTree { parent memberList} {

	upvar $memberList newList
	foreach child [winfo children $parent] {
		if { [winfo class $child] != "Toplevel" } {
			windowWidgetTree $child newList
			lappend newList $child
		}
	}
}

proc widgetsByClass { parent class memberList} {

	upvar $memberList newList
	foreach child [winfo children $parent] {
		widgetsByClass $child $class newList
		if { [winfo class $child] == $class } {
			lappend newList $child
		}
	}
}

