#!/usr/share/sysman/bin/sysmansh
#
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
#




#
# Procedure:
#	HelpOnline - processed a help callback from a tcl/Tk config app
#       (legacy config apps). 
#
# Inputs:
#	appName	     - used first time as argument to -name param
#		       to sysmanhelp. It's used to identify the filename
#		       of the help volume to opne
#       setNum	     - set number for message catalog set with help locids
#       msgNum	     - msg cat id of the help locid we want to display
#	defaultLocid - evil - default string when we can't find the above msg.
#	altCat	     - alternate catalog to use for the lookup. This
#		       is typically used to for locids that are in shared
#		       message catalogs (e.g. i18n_motif_shared_text). 
#		       This argument is in the format
#			  -catname <catalog name>
#		    
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	The legacy config apps use traditional numeric message
#	catalogs to provide a level of indirection between
#	the code and a help locid. The symbolic locid names
#	were kept in an array in order to map to the message catalog
#	set/message number integers needed by the catgets call. 
#
#	Most legacy config apps have been "migrated" to use the 
#	new message catalog infrastructure that we created for Steel. 
#	We did not change the app's code. We simply changed the catgets call
#	to call the new catgets. This is transparent in the standard cases
#	(all UI strings and messages) but breaks the HelpOnLine help call. 
#	This is because HelpOnLine doesn't do the catalog lookup itself.
#	It calls the legacy C application - sysmanhelp - that wants
#	to do a traditional catalog lookup. sysmanhelp was enhanced
#	to support two call signatures - legacy (used catalogs to get
#	help locid) and current (is passed the locid directly by the caller).
#	We can detect a pure legacy usage vs a migrated usage as follows:
#	   - legacy apps like update install call this proc with integer
#	     values for setNum and msgNum. 
#	   - migrated legacy apps call this with a symbolic msgNum
#	     This is a msg. catalog itentifier that we use to do a catalog
#	     lookup and then call sysmanhelp with the new call signature.
#	
#	[pjw] the alternate catalog argument has always been *bogus*. 
#	It's completely ignored by sysmanhelp when it's not used
#	on the initial invocation (e.g. the first thing you ask for help
#	on is Using Help. If it is specified then 
#	sysmanhelp looks for everything there, fails (cause the 
#	locids specific to the app are asked for), and uses
#	the default string! If it's not specified, the default string
#	of "Q Help4Help" is what really used to get the Help4Help! 
#
proc HelpOnline {	appName \
			setNum \
			msgNum \
			{defaultLocid {G _hometopic}} \
			{altCat {}} } {

    global _help_onlineHelpFd SysmanDir

    # See if msgNum is numeric. Some slimey code passes -1 for
    # set/msgNum so we have to allow this. 
    if { [regexp {^[-+]*[0-9]+$} $msgNum] == 1} {
	set legacy_app "true"
    } else {
	set legacy_app "false"
    }



    if { $legacy_app == "true" } {	;# Old code

	# The first time we'd called, the fd is unitialized. This triggers
	# the catch and we open a pipe to sysmanhelp
	# [pjw] whoever coded it this way should be taken to a dark alley....
	if {[catch \
	    {puts $_help_onlineHelpFd "$setNum $msgNum $defaultLocid"}] != 0} {
		set _help_onlineHelpFd \
			[ eval {open "|${SysmanDir}/bin/sysmanhelp \
				-name $appName $altCat" w}]
		puts $_help_onlineHelpFd "$setNum $msgNum $defaultLocid"
	}


	# The Nth time we are called, just write on the existing
	# pipe. 
	# [pjw] If sysmanhelp has been closed, then the puts above
	# succeeds but this flush fails and we need a new help viewer?
	# When I tried this closing the help viewer doesn't kill the process.
	# so I'm not sure why it's coded like this
	if {[catch {flush $_help_onlineHelpFd}] != 0} {
		set _help_onlineHelpFd \
			[ eval {open "|${SysmanDir}/bin/sysmanhelp \
				-name $appName $altCat" w}]
		puts $_help_onlineHelpFd "$setNum $msgNum $defaultLocid"
		flush $_help_onlineHelpFd
	}

    } else {				;# New code for migrated legacy apps

	set catalog $appName			;# Default to app's catalog
	# Only create catalog object if it doesn't exist
	if { [_Catalog info instances smcat_$catalog] == "" } {
	    _Catalog smcat_$catalog			;# Create cat object
	    set catname [cconcat $catalog "_LocIds"]
	    smcat_$catalog catopen $catname		;# And open it
	}


	set locid [smcat_$catalog catgets $msgNum]	;# Get locid value
	if { $locid == "" } {
	    set locid $defaultLocid
	}


	if {[catch {puts $_help_onlineHelpFd "$locid $catalog"}] != 0} {
	    # -name is standard Xt argument that sysmanhelp uses to 
	    # derive the name of the help volume and open it
	    set _help_onlineHelpFd [ eval {open "|${SysmanDir}/bin/sysmanhelp \
		-name $appName" w}]

	    # sysmanhelp then reads on stdin waiting for locid's to display
	    puts $_help_onlineHelpFd "$locid $catalog"

	}

	if {[catch {flush $_help_onlineHelpFd}] != 0} {
	    set _help_onlineHelpFd [ eval {open "|${SysmanDir}/bin/sysmanhelp \
		-name $appName" w}]

	    puts $_help_onlineHelpFd "$locid $catalog"
	    flush $_help_onlineHelpFd
	}


    } ;# end if legacy app

    return TCL_OK


} ;# end proc HelpOnline


proc CreateHelpMenu {appName menu_frame} {
	global i18nfd
	global msg_i18n_motif_shared_text
	global msg_i18n_motif_shared_text_LocIds
	global i18n_motif_shared_text_dstr

	menubutton $menu_frame.help_menu_button \
		-menu [list $menu_frame.help_menu_button.m] \
		-text [catgets $i18nfd \
			$msg_i18n_motif_shared_text(i18n_shared_strings) \
			$msg_i18n_motif_shared_text(i18n_help_menu_txt) \
			$i18n_motif_shared_text_dstr(i18n_help_menu_txt)] \
		-underline {0}

	set help_menu [menu $menu_frame.help_menu_button.m -tearoff 0]

	$help_menu add command \
		-command [list HelpOnline $appName -1 -1 "G _hometopic" "-catname i18n_motif_shared_text"] \
		-label [catgets $i18nfd \
			$msg_i18n_motif_shared_text(i18n_shared_strings) \
			$msg_i18n_motif_shared_text(i18n_help_overview_txt) \
			$i18n_motif_shared_text_dstr(i18n_help_overview_txt)] \
		-underline {1}

	$help_menu add separator

	$help_menu add command \
		-command [list HelpOnline $appName -1 -1 "G Tasks" "-catname i18n_motif_shared_text"] \
		-label [catgets $i18nfd \
			$msg_i18n_motif_shared_text(i18n_shared_strings) \
			$msg_i18n_motif_shared_text(i18n_help_tasks_txt) \
			$i18n_motif_shared_text_dstr(i18n_help_tasks_txt)] \
		-underline {0}

	$help_menu add command \
		-command [list HelpOnline $appName -1 -1 "G Reference" "-catname i18n_motif_shared_text"] \
		-label [catgets $i18nfd \
			$msg_i18n_motif_shared_text(i18n_shared_strings) \
			$msg_i18n_motif_shared_text(i18n_help_reference_txt) \
			$i18n_motif_shared_text_dstr(i18n_help_reference_txt)] \
		-underline {0}

	$help_menu add command \
		-command {HelpOnItemSet} \
		-label [catgets $i18nfd \
			$msg_i18n_motif_shared_text(i18n_shared_strings) \
			$msg_i18n_motif_shared_text(i18n_help_on_item_txt) \
			$i18n_motif_shared_text_dstr(i18n_help_on_item_txt)] \
		-underline {0}

	$help_menu add separator

	$help_menu add command \
		-command {HelpOnline Help4Help \
			-1 -1 "Q Help4Help" \
			"-catname i18n_motif_shared_text"} \
		-label [catgets $i18nfd \
			$msg_i18n_motif_shared_text(i18n_shared_strings) \
			$msg_i18n_motif_shared_text(i18n_help_using_help_txt) \
			$i18n_motif_shared_text_dstr(i18n_help_using_help_txt)] \
		-underline {0}

	$help_menu add separator

	$help_menu add command \
		-command [list HelpOnline $appName -1 -1 "Q About" "-catname i18n_motif_shared_text"] \
		-label [catgets $i18nfd \
			$msg_i18n_motif_shared_text(i18n_shared_strings) \
			$msg_i18n_motif_shared_text(i18n_help_about_txt) \
			$i18n_motif_shared_text_dstr(i18n_help_about_txt)] \
		-underline {0}

	pack $menu_frame.help_menu_button -side right
}
