#!/usr/share/sysman/bin/sysmansh
# 
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
# 
# @(#)$RCSfile: ism2mif.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:30 $
# 


#---------------------------------------------------------------#
#
#   Some debug stuff
#
#---------------------------------------------------------------#

if {[info exists env(DEBUG)] == 1} {
    proc debug_puts {args} {
    	puts $args
    }
} else {
    proc debug_puts {args} {
    	return
    }
}


#---------------------------------------------------------------#
#
#  The counter class is simply used to increment through Group
#   and Attribute ID's.
#
#---------------------------------------------------------------#

Class Counter

Counter instproc init {{first {0}}} {
    $self set _counter $first
}

Counter instproc inc {} {
    $self instvar _counter
    incr _counter
    return $_counter
}

#
#  Warning! Warning! Ugly hack for improperly placed global in mailconfig.ism
#
    global DB_DIR
    set DB_DIR {}


# @@@ TSM Jul 6, 1998
# Don't think this is needed anymore and it causes problems.
#   For one thing, Component is a class, not a variable, so the check is bad.
#   Removing temporarily until we know we don't need it.
# if {[info exists Component] == 0} {
#     source $SysmanDir/utils/mifclass.tcl
# }
   

#---------------------------------------------------------------#
#
#  Initialize the whole component
#
#---------------------------------------------------------------#


Component instproc ismInit {} {
    $self instvar _ismHdl _init _Ism 
    global lastcomp

    if {![cequal $self $lastcomp] || [info exists _init] == 0} {
        $self set _ismHdl [IsmInit $_Ism]
        $self set _init 1
	} 
    return {}
}

#---------------------------------------------------------------#
#
#   Extend the Group class to add an ism specific load
#
#   I'm sure we could do better then this implementation, possibly
#    by providing our own GET() SET() methods and the
#    using those instead of the default LOAD/GET/SET model.  This
#    would allow us to defer the GET/SET to the children instead of
#    cacheing it up in the parent as a row.  A GET on the GROUP would
#    then need to call each of its children to do [itmmgr $itmhdl get $attr]
#    calls.  Might be a better design for this ISM generated MIF.
#
#    Also, we will want to tie the [itmmgr IsmHdl Commit] call to
#     the SysMan GROUP which specifies the "deferred" toggle.
#
#---------------------------------------------------------------#

set lastcomp ""

Group instproc ismLOAD {{id {}}} {
    global SCode
    global lastcomp
    $self instvar _Group itemorder _ismitems itmhdl _init

    set parent [$self parent]

    if {![cequal $parent $lastcomp] || [info exists _init] == 0} {
        set result [$parent ismInit]
	set lastcomp $parent
        if {$result != {}} {
            return $result
        }

        $parent instvar _ismHdl
    
	$self CIClearTable
	
	set itmhdl [ItmMgr $_ismHdl $_Group new]
	set row {}
        set table() {}
	set entries {}

#---------------------------------------------------------------#
#
#  Ok, this is a bit confusing at first.  What is happening is
#   that I am building the table one *column* at a time.  Each
#   time we allocate a new entry in the *local* table() array
#   we append that itmhandle ($n) to our entries list so we
#   can then loop through the completed table later on in the
#   same order we built it and add it to the parents internal
#   table (AddRow).
#
#---------------------------------------------------------------#

        set itemorder [ism_GetOrder $_ismHdl $_Group]
        foreach attr [ism_GetAttrs $_ismHdl $_Group] {
            set value [ism_GetAttrVal $_ismHdl $_Group $attr]

            if {$itemorder == 1} {
                lappend row $value

            } else {
                foreach vpair $value {
                    lassign $vpair n v
                    if {[info exists table($n)] == 0} {
                    	set table($n) {}
	                lappend entries $n
                    }

                    lappend table($n) ${v}
                }
            }
        }

#---------------------------------------------------------------#
#	
# Get rid of any annoying \n's in the string,
#  /bindconfig/restcmnt ... this is currently a hack as we
#  need to split this somehow but keep it as a single arg
#  so that the AddRow command maintains the argument list correctly.
#  Same regsub is done for the table case as well
#
#---------------------------------------------------------------#

        if {$itemorder == 1} {
            regsub "\n" $row {,} row
            $self CIAddRow $row
        } else {
            while {[set n [lvarpop entries]] != {}} {
                regsub "\n" $table($n) {,} row
                $self CIAddRow $row
            }
        }

	$self CIResetRows
	$self set _init 1
    }
return {}
}    

Group instproc ismValidate {operation oldval newval} {
    $self instvar _init
    global lastcomp

    if {$operation == "del"} {
    	return {}
    }

    global SCode
    $self instvar _Group _name itemorder itmhdl _init
    set parent [$self parent]
    $parent instvar _ismHdl

    set attributes [ism_GetAttrs $_ismHdl $_name]
    
    set tmpItm [ItmMgr $_ismHdl $_name new]
    eval lassign \$newval $attributes

    foreach item $attributes {
        if { [ItmMgr $tmpItm set $item [$self/$item _ismEnumMap [set $item]]] != $SCode(OK) } {
            ItmMgr $tmpItm free
            debug_puts "$_name $item set error"
            return "validation error setting $_name $item"
        }
    }
    if {![cequal $parent $lastcomp] && [info exists _init] == 1} {
	unset _init
	}

    ItmMgr $tmpItm free
    return {}
}	



Group instproc ismFLUSH {{id {}}} {
    global SCode
    $self instvar _Group _name itemorder itmhdl _init

    set parent [$self parent]
    $parent instvar _ismHdl
    
    if {[info exists _init] == 1} {

debug_puts "Flushing group: ($self)..."
debug_puts [$self DumpTable]
debug_puts "--------"
        set attributes [ism_GetAttrs $_ismHdl $_name]

	$self CIResetRows
	set commit 0

        set listItm [ItmMgr $_ismHdl $_name new]
        ItmMgr $listItm set _action loadList
        ItmMgr $listItm validate
        ItmMgr $listItm apply
        set itmList [ItmMgr $listItm get __list]
     
        set tmpItm [ItmMgr $_ismHdl $_name new]

        foreach cireadrow_state {NORMAL 3} {
            while { [set line [$self CIReadRow $cireadrow_state]] != {}} {
        
                set modflag [$self CIIsModified $line]
debug_puts "mf: $modflag of $line"

                if {$modflag != 0} {
                    switch $modflag {
                      {1} {set action modify}
                      {2} {set action create}
                      {3} {set action purge}
                    }
        
debug_puts "$action of $line"

                    ItmMgr $tmpItm set _action $action
            
                #---------------------------------------------------------------#
                #
                #  Ok, get all the attributes into local variables and assign
                #   them values.  The easiest way to do this is to just let
                #   lassign do the work, no iterations, no mess, just assign
                #   each of the variables to the line we got from the table.
                #
                #  We then set each of the item attribute values into the item,
                #   validate, and apply each.  (Room here for using the Validate
                #   callback in Mcl)
                #
                #---------------------------------------------------------------#
            
                    eval lassign \$line $attributes

                    foreach item $attributes {
                        if { [ItmMgr $tmpItm set $item [$self/$item _ismEnumMap [set $item]]] != $SCode(OK) } {
                                ItmMgr $tmpItm free
debug_puts "$_name $item set error"
                                return "validation error setting $_name $item"
                        }
                    }


	#---------------------------------------------------------------#
        #
        #       We need to set _which attribute in order to modify a row
        #       in a table.  
	#       *** THIS CAN ONLY BE DONE FOR A TABLE, NOT A GROUP ***
        #       Hence check to see if the component has the KEY variable.
        #       If Yes, then set _which.
        #
        #       1. Find the table of keys, associated with the table. 
	#          This table has the keys of all the rows irrespective 
	#          of their state (dirty, clean, modify or delete ):key_table
        #       2. Create the keys from the given row (current_row_keys).
        #       3. Search for the created keys in the key_table to get the
	#          index of the row in the MCL (this will correspond to 
        #          index of the row in the ISM item handle).current_row_index
	#       4. Now find the itemHandle associated with this index
        #          and set the _which attribute to it. current_itm_hdl
        #---------------------------------------------------------------#

		    ${self}_table keys key_table *

		    if { [string compare [$self info vars KEY] {KEY}] == 0 } {
			set current_row_keys [${self} MakeKEY $line]
			set current_row_index [lsearch $key_table $current_row_keys]
			set current_itmhdl [lindex $itmList $current_row_index]
			ItmMgr $tmpItm set __which $current_itmhdl
		    }
		    

        #---------------------------------------------------------------#
        #
        #       We need to set the active option on every attribute
        #        as some demon's require this to be set (ISM Quirk).
        #       It is believed to be a no-op for any attribute's outfilter
        #        that doesn't support it.
        #
        #---------------------------------------------------------------#
        
		    ItmMgr $tmpItm set _options {active}
		    
                    set rcode [ItmMgr $tmpItm validate]

                    if { $rcode != $SCode(OK) } {
                        debug_puts "$_name Validate Error $rcode"
                    }
        
                    set rcode [ItmMgr $tmpItm apply]
                    if { $rcode != $SCode(OK) } {
                        debug_puts "$_name Apply Error $rcode"
                    }
    
                    set commit 1
                }
        
    #---------------------------------------------------------------#
    #
    #       If we are a group then we break out since CIReadRow()
    #         will always return just the group
    #
    #---------------------------------------------------------------#
    
                if {$itemorder == 1} {
                    break
                }
            }

	}

        if {$commit == 1} {
            ItmMgr $_ismHdl Commit
	}

	$parent unset _init
	unset _init
    }
    return {}
}    


#---------------------------------------------------------------#
#
#   This method will return the actual string value of an
#    enumuration type given the integer value.  This is needed
#    when setting the actual value of an ISM Item.  This may
#    need to be optimized if it turns out to be costly (i.e.,
#    creating the map array on each attribute set)
#
#---------------------------------------------------------------#

Attribute instproc _ismEnumMap {value} {
    $self instvar _name _children
    if {$_children != {}} {
    #  Need the eval to strip leading blank from $_children
        eval $_children instvar VALUE
        array set map $VALUE
        if {[array names map $value] != {}} {
            return $map($value)
        }
    }

    return $value
}


#---------------------------------------------------------------#
#
#    Now build a SysManCi MCL definition and associated procs
#
#---------------------------------------------------------------#


proc ismtomif {ignore ism} {
    global SCode

    set IsmHdl [IsmInit $ism]

    if {[ctype digit $IsmHdl] != 0} {
        if {$IsmHdl == $SCode(EPERM)} {
        _Catalog i18nmsgcat
        i18nmsgcat catopen i18n_motif_shared_text
        error [i18nmsgcat catgets i18n_not_authorized_txt]
        }

        error "Initialization failed, error code $IsmHdl"
    }

    set mif "COMPONENT $ism \{
    NAME \"$ism Configuration MIF\"
    DESCRIPTION \{This is the $ism MIF\}

"

    Counter gid
    Counter aid
    gid init 3


    foreach g [ism_GetItems $IsmHdl] {

	set order [ism_GetOrder $IsmHdl $g]
	set attributes [ism_GetAttrs $IsmHdl $g]
	set gattrs($g) $attributes

	if {$attributes != {}} {
		
            append mif "
        GROUP $g \{
            CLASS \"Digital|$ism-$g|001\""
    
            if { $order != "n" } {
                append mif "
            ID [gid inc]"
            } else {
                set key {}
                set sep {}
                foreach k [ism_GetIndex $IsmHdl $g] {
                    set idx [lsearch -exact $attributes $k]
                    incr idx
                    set key "$key$sep$idx"
                    set sep ,
                }
                append mif "
            ID [gid inc]
            KEY $key"
            }
            aid init
            foreach a $attributes {
    
    
    #---------------------------------------------------------------#
    #
    #       Need to set the type here after getting it from ISM
    #
    #       If we have a set of literal validations then assume that
    #        this is really an enumuration.
    #
    #---------------------------------------------------------------#
    
                set literal [ism_GetLiteral $IsmHdl $g $a]
                if {$literal != {}} {
                    set type Enum
                    set enum "
                ENUM literal {
                    VALUE {
    "
                    set eidx 0
                    foreach e $literal {
                        append enum "                  $eidx \"$e\"\n"
                        incr eidx
                    }
                    append enum "           }
                }
    "
                } else {
                    set type string
                    set enum {}
                }
    
                append mif "
            ATTRIBUTE $a \{ 
                ID [aid inc]
                TYPE $type
                ACCESS Read-Write
                $enum
            \}"
            }
    
    
    #---------------------------------------------------------------#
    #
    #  Its not clear that this is needed since its mearly the
    #   group name.
    #
    #       ATTRIBUTE itemname \{
    #           NAME \"ISM Item Name\"
    #           ID [aid inc]
    #           TYPE string(32)
    #           ACCESS Read-Only
    #           VALUE \"$g\"
    #
    #       \}
    #
    #---------------------------------------------------------------#
    
            append mif "
        \}"
    
        }
    
    }
   append mif "
\}"


#---------------------------------------------------------------#
#
#  Now build a standard set of LOAD procs that simply call the
#   new generic Group method "ismLOAD" to do the work.
#
#---------------------------------------------------------------#

append mif "
/$ism set _Ism $ism
"

set deferredmode {}

foreach g [ism_GetItems $IsmHdl] {

    if {$gattrs($g) != {}} {
    append mif "
/$ism/$g set _Group $g

/$ism/$g proc LOAD {{key {}} {id {}}} {
    /$ism/$g ismLOAD \$id
}

/$ism/$g proc Validate {operation oldval newval} {
    /$ism/$g ismValidate \$operation \$oldval \$newval
}

/$ism/$g proc FLUSH {{key {}} {id {}}} {
    if {\[/$ism/digitalmanagementmodes/deferredcommit GET\] == 0} {
        return \[/$ism/$g ismFLUSH \$id\]
    }
    return {}
}"

    }
    append deferredmode "\n    /$ism/$g ismFLUSH\n"

}

append mif "
/$ism/digitalmanagementmodes proc deferredcommit {value} {
   if {\$value == 0} {
       $deferredmode
   }
}
"

return $mif    
}



