#!/usr/share/sysman/bin/sysmansh
# 
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
# 
# @(#)$RCSfile: mcl_include.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:30 $
# 

#----------------------------------------------------------------
##
## This file defines common typedefs used in MCL grammar and 
## processing.  The recommended method for usage of these constants
## is by calling the proc "Mcl_Include <type>".  By calling this
## proc, the needed constants are defined at the local scope of
## the calling procedure.
##
#----------------------------------------------------------------


global typedef
set typedef { 
  { "MCL_TRUE"       1 }
  { "MCL_FALSE"      0 }
  { "ROW_CLEAN"      0 }
  { "ROW_MODIFIED"   1 }
  { "ROW_ADDED"      2 }
  { "ROW_DELETED"    3 }
}



proc Mcl_Include {type} {

  global $type 
  foreach elem [keylkeys $type] {
    uplevel #0 set $elem [keylget $type $elem]
  }

}

proc Mcl_Global {type} {

  global $type 
  foreach elem [keylkeys $type] {
    uplevel global $elem 
  }

}
