#!/usr/share/sysman/bin/sysmansh
# 
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
# 
# @(#)$RCSfile: miAPI.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:30 $
# 

###
###  MI APIs -> interface to Suit and sysmansh
###

##
## Fill the rows array with all the data rows from either MCL or DMI interface.
##
##   inp>  recsRef - name of an array of data records (rows) indexed by
##                   integers starting with nextId and incremented by one.
##         orderRef - name of list of indecies indicating order of recs
##                    in array.
##         nextIdRef - name of integer indicating first ID to use.
##   out>  return a Tcl String for error; {} if no errors
##
##
proc miReadAll {component group recsRef orderRef nextIdRef {filter ""}} {

#puts "miReadAll : [time {

  global MI_METHOD
  upvar $recsRef   recs
  upvar $orderRef  order
  upvar $nextIdRef nextId

  return [${MI_METHOD}_ReadAll $component $group recs order nextId $filter]
#  set res [${MI_METHOD}_ReadAll $component $group recs order nextId]
#}]"
#return $res
}

##
## returns a row of data from either MCL or DMI interface.
##
##   inp>  component, group and optionally a seed.  If the seed is 0 then
##         the MI is requesting us to reset the current Index Pointer to
##         to the top (in MCL) or send a DMI_FIRST_ATTR flag to the SL.
##         Return the result in resultVar.
##   out>  return a Tcl String for error; {} if no errors
##
##
proc miReadRow {component group resultVar {seed 1}} {

  global MI_METHOD
  upvar $resultVar ResultVar

  ${MI_METHOD}_ReadRow $component $group ResultVar $seed
}

##
## read a row of data from either MCL or DMI interface using a key
##
##   inp>  component, group and optionally a seed.  If the seed is 0 then
##         the MI is requesting us to reset the current Index Pointer to
##         to the top (in MCL) or send a DMI_FIRST_ATTR flag to the SL.
##         Return the result in resultVar.
##   out>  return a Tcl String for error; {} if no errors
##
##
proc miReadRowByKey {component group resultVar key} {

  global MI_METHOD
  upvar $resultVar ResultVar

  ${MI_METHOD}_ReadRowByKey $component $group ResultVar $key
}

##
## Add a row to the group/table through MCL or DMI interface.
##
##   inp>  component, group, row to be added (Tcl list) and optionally
##         the nextrow (Tcl list which makes ordered table entries)
##         In Mcl its straight forward - In DMI we have to cleanTable and
##         then re-write the table in this order.
##         return variable will be a Tcl list - row that was just added.
##   out>  return a Tcl String for error; {} if no errors
##
##
proc miAddRow {component group resultVar row {nextrow {}} {rowRet {}}} {


  global MI_METHOD
  upvar $resultVar ResultVar

  if { ! [cequal $rowRet ""] } {
      upvar $rowRet RowRet
      ${MI_METHOD}_AddRow $component $group ResultVar $row $nextrow RowRet
  } else {
      ${MI_METHOD}_AddRow $component $group ResultVar $row $nextrow
  }
}

##
## Modify an entire row through MCL or DMI interface.
##
##   inp>  component, group, oldrow to be modified (Tcl list) and newrow
##         (Tcl list)
##         return variable will be a Tcl list - row that was just modified.
##   out>  return a Tcl String for error; {} if no errors
##
##
proc miModRow {component group resultVar oldrow newrow {newRowRet {}}} {

  global MI_METHOD
  upvar $resultVar ResultVar

  if { ! [cequal $newRowRet ""] } {
      upvar $newRowRet NewRowRet
      ${MI_METHOD}_ModRow $component $group ResultVar $oldrow $newrow NewRowRet
  } else {
      ${MI_METHOD}_ModRow $component $group ResultVar $oldrow $newrow
  }


}

##
## delete a row of data from either MCL or DMI interface.
##
##   inp>  component, group and the row to be deleted
##         return variable will be true(1) or false(0)
##   out>  return a Tcl String for error; {} if no errors
##
##
proc miDelRow {component group resultVar row} {

  global MI_METHOD
  upvar $resultVar ResultVar

  ${MI_METHOD}_DelRow $component $group ResultVar $row
}

##
## obtain a default row from the group definition.  This characteristic *may*
## *not* be available through the DMI interface, we may need to fake it.
##
##   inp>  component, group
##         return variable will be a tcl list of default values
##   out>  return a Tcl String for error; {} if no errors
##
##
proc miGetDefaults {component group resultVar} {

  global MI_METHOD
  upvar $resultVar ResultVar

  ${MI_METHOD}_GetDefaults $component $group ResultVar
}

##
## Try to do some validation.  This characteristic *may*
## *not* be available through the DMI interface, we may need to fake it.
##
##   inp>  component, group, result variable, row and oldrow
##         if row != {} *AND* oldrow == {} --> assumed operation: add
##         if row != {} *AND* oldrow != {} --> assumed operation: mod
##         if row == {} *AND* oldrow != {} --> assumed operation: del
##         all other combinations are invalid and will produce MCL internal
##         errors.
##
##         return variable is reserved for future use.
##   out>  return a Tcl String for error; {} if no errors
##
##
proc miValidate {component group resultVar oldrow row } {

  global MI_METHOD
  upvar $resultVar ResultVar

  ${MI_METHOD}_Validate $component $group ResultVar $oldrow $row
}

##
## return components available in MCL and/or DMI SL as a Tcl list in resultVar
##
##    inp> result variable will be a tcl list is ordered based 
##         on the MIF/MCL ordering.
##   out>  return a Tcl String for error; {} if no errors
proc miGetComponents {resultVar} {

  upvar $resultVar ResultVar

  MCL_GetComponents ResultVar
}

##
## return children for a given parent as a Tcl list
##
##   IMPORTANT:  example of parent is "/component" or "/component/group"
##               i.e., "/psinfo" or "/psinfo/psopt"
##
##
##    inp> if parent == component  output is a tcl list of groups
##         if parent == group/table output is a tcl list of attributes
##         in resultVar - a tcl list is ordered based on the MIF/MCL ordering.
##   
##   out>  return a Tcl String for error; {} if no errors
proc miGetKids {parent resultVar} {

  upvar $resultVar ResultVar

  MCL_GetKids $parent ResultVar
}

##
## Initializes the state of the Mcl engine / DMI SL:  This call will
## prepare the internal data structures so that the next mi call be
## performed.
##
##   inp>  variable number of arguments.  Each argument is the name of a
##         component.  ex, miInit psinfo crontab lmf - this will initialize
##         the Mcl engine to source in the associated Mcls whose components 
##         are psinfo, crontab and lmf.  If no argument is given then this
##         call will initialize all the Mcls on the system. 
##
##   out>  no return code NOW (*reserved for future*)
##
proc miInit {args} {

  global MI_METHOD
  set return_msg [${MI_METHOD}_Init $args]

}

##
## Clean the internal data structures and the MCL definitions
##
proc miDone {args} {
  global MI_METHOD
  ${MI_METHOD}_Done $args
}

##
## This is a very temp. routine from the MI perspective. This
## proc will dump the contents of a component in a very crude
## form to a file (if specified optionally) or to file called
## /tmp/${component}.PID or /tmp/Sm_SysMan_Tmp/${component}.PID
## depending if it is called by a non-root user, or root.
##
##
proc miDump {component {file {stdout}}} {

  global MI_METHOD
  ${MI_METHOD}_Dump $component $file

}

global MI_METHOD
global env

if { [lsearch [array names env] SYSMAN_MI ] == -1 } {
  set MI_METHOD "MCL"
} else {
  set MI_METHOD [string toupper $env(SYSMAN_MI)]
  if { $MI_METHOD != "DMI" } {
    set MI_METHOD "MCL"
  }
}

if { [lsearch [array names env] MCL_PROFILE ] != -1 } {
   
     set plist {}
     foreach p $env(MCL_PROFILE) {
     	append plist [info procs $p]
     }
     

#---------------------------------------------------------------#
#
#  Ok, this currently doesn't work as the time { catch {}} combo
#   seems to not work together, optional variables get flagged
#   as not being defined, probably due to upvar type scoping
#   issues.  Its close ...
#
#---------------------------------------------------------------#

     foreach p $plist {
	 set arglist {}
         foreach a [info args $p] {
             if {[info default $p $a def] == 1} {
                lappend arglist "{$a {$def}} "
             } else {
             	lappend arglist $a
	     }
	 }
         	
         set body [info body $p]
         eval "proc $p {$arglist} {
	     set __time \[time {catch {$body} __result }\]
             puts \"$p : \$__time\"
             return \$__result
         }"
     }
  }
