#!/usr/share/sysman/bin/sysmansh
# 
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
# 
# @(#)$RCSfile: mifclass.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:30 $
# 

global _mclPath
set    _mclPath  {}

# This flag is to note if processing is in the context of cloning or not.
#   It's important for validation, which may be more strict or lax than
#   when not cloning.  By default, it's off.  It may already be defined.
#   If not, it needs to be.
global _g_cloning
if { ! [info exists _g_cloning]} {
    set    _g_cloning  0
}


##
## Include some common typedefs
##
Mcl_Include "typedef"



#---------------------------------------------------------------
#
#	Build some standard procs to allow us to insert the
#         naming hierarchy for the objects.  This also is used
#	  to track the namespace, i.e., we track backup to the
#	  previous level (mifmap pop) when we are done with the
#	  current command.
#
#---------------------------------------------------------------

proc COMPONENT {name body} {
   global _mclPath; 
   set hold $_mclPath
   Component create $_mclPath/$name $_mclPath $name $body
   set _mclPath $hold
}

set ClassCommands {GROUP TABLE ENUM ATTRIBUTE}

foreach c $ClassCommands {
   set classname \
	 "[string range $c 0 0][string tolower [string range $c 1 end]]"
   eval [subst -nocommands {
      proc $c {name body} {
	 global _mclPath
	 $classname create \$_mclPath/\$name \$_mclPath \$name \$body
      }
   }
   ]
}

#---------------------------------------------------------------
#
#  Class MifCommon
#
#	This class creates the basis for all other classes within
#	a MIF definition. 
#
#---------------------------------------------------------------


Class MifCommon

proc mif_make_keywords {classname keywords} {
	
    foreach c $keywords {
       eval [subst -nocommands {
	  proc $c {args} {global _mclPath; eval \$_mclPath $c \$args}
	  $classname instproc $c {args} {
	     \$self instvar $c
	     if {\$args != {}} {
		set $c [join \$args]
	     } else {
		set $c ;
	     }
	  }
       }
       ]
    }
}

mif_make_keywords MifCommon {NAME ID CLASS DESCRIPTION CDFGROUPS SCOPE VALUE PRAGMA DeferMode}


#---------------------------------------------------------------
#
#  Use the default description text for all descriptions.  At
#   some point in the future, we need to optionally take the
#   description from a message catalog if a DESCRIPTION clause
#   isn't found in the definition.
#
#---------------------------------------------------------------

MifCommon instproc _description {type args} {
    $self instvar _name

    if {$type == "dmi"} {
    	set ret {}
        set quote "\""
    } else {
        set ret {"}
    	set quote {}
    }
    
    set desc [$self DESCRIPTION]
    regsub -all {"} [$self DESCRIPTION] {'} desc
    switch [$self type] {

    	Group {
	    foreach line [split $desc \n] {
	      append ret [FormatString $quote $line]
	    }

	    if { $desc == "" } {
		append ret {No description available}
	    }
	}

    	Attribute {
       	    set id [$self ID]
    	    incr id

	    foreach line [split $desc \n] {
	      append ret [FormatString $quote $line]
	    }

	    if { $desc == "" } {
		append ret {No description available}
	    }
        }
    }

    set ret [string trimright $ret]
    if {$type != "dmi"} {
	append ret {"}
    }

    return $ret
}

proc FormatString {quotechar line} {

  set nbline [string trim $line]
  set sploc [string first $nbline $line]
  set result "$quotechar$nbline$quotechar\n"
  if {$sploc >= 1} {
    set result "[string range $line 0 [incr sploc -1]]$quotechar$nbline$quotechar\n"
  } 
  return $result
}

#---------------------------------------------------------------
#
#  A utility routine for creating LOAD/RELOAD proc templates
#
#---------------------------------------------------------------

MifCommon instproc mkLOADprocs {{filename {}}} {

    if {$filename != "" } {
        set fd [open $filename w]
    } else {
    	set fd stdout
    }
    
    foreach g [$self walk groups] {
        puts $fd "$g instproc LOAD {{key {}} {id {}}} {
}"
    }

    foreach g [$self walk groups] {
        puts $fd "$g instproc RELOAD {{key {}} {id {}}} {
}"
    }

    close $fd
}

MifCommon instproc mkprocs {{filename {}}} {

    if {$filename != "" } {
        set fd [open $filename w]
    } else {
    	set fd stdout
    }
    
    foreach g [$self walk attributes] {
        puts $fd "$g instproc GET { key } {
}"
        puts $fd "$g instproc SET { value key } {
}
"
    }

    close $fd
}


#---------------------------------------------------------------
#
#  A utility routine for making message catalogs
#
#---------------------------------------------------------------

MifCommon instproc mkmsgcat {{filename {}}} {
    $self instvar _name

    if {$filename == ""} {
        set msgcat [open ${_name}_mif.msg w]
    } else {
        set msgcat [open $filename w]
    }
    
    puts $msgcat "
 
$  THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT!

$  Message catalog generated from mkmsgcat method
$  Component: ${_name}
$  Date: [fmtclock [getclock]]
   
"
    	
    foreach o [$self walk] {
    	set msgname [join [lrange [split $o /] 2 end] _]

    	switch [$o type] {
    	    Component { }
    	    Group {
		puts $msgcat "\n\$set [$o ID] $o\n"
		puts $msgcat "$ $o"
		puts $msgcat "1 \"[$o DESCRIPTION]\""
	    }
    	    Attribute {
		set id [$o ID]
		incr id
		puts $msgcat "$ $o"
		puts $msgcat "$id \"[$o DESCRIPTION]\""
	    }
    	}
    }
   close $msgcat
}

MifCommon instproc build {args} {
	set args [join [join $args]]
	eval $args
}
	
MifCommon instproc init {parent name body} {
    $self instvar _parent _children _name NAME DESCRIPTION SCOPE
    
    set _children {}
    set _parent $parent
    set SCOPE {}

    if {$_parent != {}} {
        $_parent children $self

        if { [$_parent SCOPE] != {} } {  
             set SCOPE [$_parent SCOPE]
        } else {
             set SCOPE public
        }
    }

    #
    #  Default the NAME field to the name of the object
    #
    
    set NAME $name
    set _name $name
    set DESCRIPTION "message catalog for $self"
   
    global _mclPath; set _mclPath $self
    eval $body
    set _mclPath $parent
}

MifCommon instproc children {args} {
   $self instvar _children
   if {$args != {}} {
      eval lappend _children $args
   }
   return $_children
}

MifCommon instproc parent {args} {
   if {$args == {}} {
      $self set _parent
   } else {
      $self set _parent $args
   }
}

MifCommon instproc idmap {} {
    $self instvar ID
    set parent [$self parent]
    if {[info exists ID] == 1} {
    	set id $ID
    } else {
    	set id {}
    }
    if {$parent != {}} {
        return "[$parent idmap] $id"
    } else {
    	return "$id"
    }
}

MifCommon instproc walk {{cmd {names}}} {

    if {[$self type] == "Table"} {
    	return {}
    }
    
    switch $cmd {
	names {set rval "$self\n"}
	components {return "$self\n" }
	groups { return [$self children] }
	attributes {set rval {}
		    if {[$self type] == "Group"} {
			return [$self children]
		       }
		   }
	idmap {set rval "$self [$self idmap]\n"}
	values {set rval "$self=[$self GET]\n" }
    }

    foreach c [$self children] {
        set rval "$rval[$c walk $cmd]"
    }

return $rval    
}

MifCommon instproc type {} {
	return $class
}


MifCommon instproc exists {var} {
    lsearch [$self info vars] $var 
}

#---------------------------------------------------------------
#
#    Convert a MCL based name to a legal MIB identifier.  Map
#     most special char's to some reasonable letter (i.e.,
#     ! = 'e', + = 'p', ... )  Spaces & _'s go to "-"
#
#---------------------------------------------------------------

MifCommon instproc _mibname {mibname} {

    set mibname "[string tolower [string index $mibname 0]][string range $mibname 1 end]"
    set mibname [translit !-/ eqpdpaqlrspc_ds $mibname]
    set mibname [translit "_ " -- $mibname]
    return $mibname
}

#---------------------------------------------------------------
#
#  Component Class
#
#    Loop through the defined groups and add them to the mif
#      
#    Break up the single argument into regular tcl "cmd {arg} {body}"
#     and individually eval each, adding the output to the mifs
#     "ComponentList"
#
#---------------------------------------------------------------

Class Component -superclass MifCommon

Component instproc init {parent name body} {
    $self next $parent $name $body
    $self instvar _eventPrefix _fullSystemName _nodeName _systemName
    global SysmanOnCluster SysmanFocusHost
   
   global _mclPath; set hold $_mclPath; set _mclPath $self
   Required_Groups
   set _mclPath $hold

    # initialize system, cluster and event info
    set _fullSystemName [id host]
    set _systemName     [lindex [split $_fullSystemName .] 0]
    if {$SysmanOnCluster == 0} {
	set _nodeName     $_fullSystemName
    } else {
	if {![cequal $SysmanFocusHost {}]} {
	    # running on a cluster, but focused on one node
	    set _nodeName $SysmanFocusHost
	} else {
	    #running on a cluster unfocused
	    set _nodeName [cluster alias]
	}
    } 
    set stat [catch "exec /usr/bin/evminfo -vp" _eventPrefix]
    if {$stat != 0 || [cequal $_eventPrefix ""]} {
	set _eventPrefix "sys.unix"
    }

   $self/componentid proc LOAD {{key {}} {id {}}} {
      $self instvar _init
      
      if {[info exists _init] == 0} {
	 
	 $self CIAddRow [list [$self/manufacturer VALUE] \
	       [$self/product VALUE] \
	       [$self/version VALUE] \
	       [$self/serialnumber VALUE] \
	       [$self/installation VALUE] \
	       [$self/verify VALUE] ]
	 set _init 1
      }
      return {}
   }

   $self/componentid proc FLUSH { {keylist {}} {id {}}} {
        return {}
   }

   $self/digitalmanagementmodes proc LOAD {{key {}} {id {}}} {
      $self instvar _init 
      set parent [$self parent]
      
      if {[info exists _init] == 0} {

   	catch { set cdfgroups [$parent CDFGROUPS] }

	if { ! [info exists cdfgroups] } {
	    set cdfgroups "NONE"
  	} else {
	    if { [cequal $cdfgroups "ALL"] } {
		set cdfgroups {}
  	    	foreach grp [$parent children] {
    		    lappend cdfgroups [file tail $grp]
  		    }
	        }
	    if { [lsearch $cdfgroups "componentid"] == -1} {
		lappend cdfgroups componentid
		}
	    if { [lsearch $cdfgroups "digitalmanagementmodes"] != -1} {
	    	set gnum [lsearch $cdfgroups "digitalmanagementmodes"]
	    	set cdfgroups [lreplace $cdfgroups $gnum $gnum]
		}
	    }

      $self CIAddRow [list [$self/deferredcommit VALUE] $cdfgroups]
	 set _init 1
      }
      return {}
   }

   $self/digitalmanagementmodes proc FLUSH { {keylist {}}   {id {}} } {
      return {}
   }
   
   $self/digitalmanagementmodes proc deferredcommit { value } {
      return {}
   }

   $self/digitalmanagementmodes proc cdfgroups { value } {
      return {}
   }
}


# -----------------------------------------------------
# Post a sysman event for this component.
#   Here is the list of currently supported event types:
#       config.fail
#       config.ok
#       deconfig.fail
#       deconfig.ok
#       file.create
#       file.modify
#       file.remove
#       process.restart
#       process.start
#       process.stop
#   The "name" is the name of the file, process, group, table, etc.
#   The "failReason" only applies to config.fail and deconfig.fail.
#   The "target" is optional.  This may be needed when called with a cluster
#    wide focus, but work must be done on individual nodes as a result of
#    the cluster wide change.  e.g. restarting daemons, etc.

Component instproc postEvent {type name {failReason "??"} {target ""}} {
    $self instvar _nodeName _eventPrefix

    if {[cequal $target ""]} {
	set target $_nodeName
    }

    sm_postevent $_eventPrefix.sysman.generic.$type \
	    app=$self \
	    name=$name \
	    target=$target \
	    reason=$failReason
} 



#---------------------------------------------------------------
#
#  This method provides a component level way of quickly
#   setting the (mostly) static fields in the componentid
#   of each component.
#
#---------------------------------------------------------------

Component instproc componentid {args} {
    eval array set values $args

#---------------------------------------------------------------
#
#   Determine which comes first in this local, day or month
#
#---------------------------------------------------------------

   # Commented out due to a problem with convertclock not being
   # internationalized. Remove the comments when this problem is 
   # fixed.
   #
   # set localfmt [clock format 0 -format "%x"]
   # set USfmt [clock format 0 -format "%D"]
   # set stddate [cequal $localfmt $USfmt]

    for_array_keys v values {

#---------------------------------------------------------------
#
#	Remove any RCS key string
#
#---------------------------------------------------------------

	foreach rcskey {Author Date Header Id Locker Log RCSfile Revision Source State} { 
            regsub -all "\\\$$rcskey\: (.*) \\\$" "$values($v)" {\1} values($v)
        }
        
    	switch $v {
    	    installation {
    	    	MifDate md
    	    	
    	    	lassign [split [lindex $values($v) 0] /] year month day
    	    	set time [lindex $values($v) 1]

#---------------------------------------------------------------
#
#   Based on the local we configure a date string
#
#---------------------------------------------------------------

   # Commented out due to a problem with convertclock not being
   # internationalized. Remove the comments when the problem is 
   # fixed.
   #
   #            if {$stddate == 1} {
   #                md set "$time $month/$day/$year"
   #            } else {
   #                md set "$time $day/$month/$year"
   #            }

    	    	md set "$time $month/$day/$year"
    	    		
		set values($v) [md getmif]
		md destroy
	    }
    	}
    	
        $self/componentid/$v SET $values($v)
    }
return {}
}

Component instproc digitalmanagementmodes {args} {
    eval array set values $args
    for_array_keys v values {
    	$self/digitalmanagementmodes/$v SET $values($v)
	}
    return {}
}

#---------------------------------------------------------------
#
# Procedure:
#	Component LOAD/RELOAD/GET/SET - this are really noop placeholders
#       defined only for completeness. We never
#       expect a component to have load/reload/get/set (these
#       are group methods).
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
#
#---------------------------------------------------------------
Component instproc LOAD {{key {}} {id {}}} {
        return {}
}

Component instproc RELOAD {{key {}} {id {}}} {
        return {}
}

Component instproc GET {args} {
	return {}
}

Component instproc type {} {
	return $class
}

Component instproc mif {args} {


set mif "
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//    DIGITAL MIF CREATED BY DMICI COMPONENT INSTRUMENTATION             //
//
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// . Replace the above heading with your MIF name                           //
// . Add your comments here.                                                //
//////////////////////////////////////////////////////////////////////////////
//
//
// MIF Name:         [$self NAME]
// Component Name:   [$self NAME]
// Created on:       [ fmtclock [getclock] ]
//
// Utility Used:     MIF Auto generated by DMICI Instrumentation
// Bugs/Comments:    Digital Equipment Corporation, http://www.digital.com
//
//

START COMPONENT
      NAME  = \"[$self NAME]\"
      DESCRIPTION = \"[$self _description dmi]\"

START PATH
// This is the instrumentation type
      NAME   = \"DMICI\"
      unix   = Direct-Interface
END PATH


///////////////////////////////////////////////////////////////////////// 
//                                                                     // 
//    COMPONENT ID GROUP -Required                                     // 
//                                                                     // 
// Every MIF file must contain a Component ID group with an ID = 1.    // 
// This group offers base-level identification of the component and    // 
// represents the minimum amount of information that a component       // 
// provider should provide when meaningful. An attribute that is not   // 
// supported or that has no meaning for a given component should be    // 
// given the key word UNSUPPORTED as its value.                        // 
///////////////////////////////////////////////////////////////////////// 
 
"
    foreach c [$self children] {
        set mif "$mif
[$c mif]"
    }

set mif "$mif
END COMPONENT\n"
}

Component instproc mib {{outfile {}}} {
    $self instvar _name objname
    global SysmanDir


    if {[catch {$self ID}] != 0} {
        puts stderr "COMPONENT ... { ID nnnn } is not defined"
        return {}
    }

    set objname [$self _mibname $_name]
    set upperobjname [translit a-z A-Z $objname]
    
set mib "
--- //////////////////////////////////////////////////////////////////////////////
--- //                                                                          //
--- //    DIGITAL MIB CREATED BY SYSMANCI COMPONENT INSTRUMENTATION             //
--- //                                                                          //
--- //                                                                          //
--- //////////////////////////////////////////////////////////////////////////////
--- //                                                                          //
--- // Utility Used:     MIB Auto generated by SysManCI Instrumentation		//
--- // Bugs/Comments:    Digital Equipment Corporation, http://www.digital.com  //
--- //                                                                          //
--- //////////////////////////////////////////////////////////////////////////////
--- //                                                                          
--- // MIB Name:         [$self NAME]						
--- // Component Name:   [$self NAME]						
--- // Generated on:     [ fmtclock [getclock] ]
--- // Version:		 [$self/componentid/version GET]
--- //
--- //////////////////////////////////////////////////////////////////////////////


$upperobjname-MIB DEFINITIONS ::= BEGIN

IMPORTS
    OBJECT-TYPE
    FROM RFC-1212
    Counter, enterprises
    FROM RFC1155-SMI
    DisplayString
    FROM RFC1213-MIB;

--
-- Common definitions
--

MclCounter              ::= INTEGER (0..4294967295)
MclInteger              ::= INTEGER
MclDisplaystring        ::= DisplayString
MclDate                 ::= OCTET STRING (SIZE (25))
MclRow                  ::= INTEGER (1..4294967295)     -- row number indexes DMI tables

dec                     OBJECT IDENTIFIER ::= { enterprises 36 }
ema                     OBJECT IDENTIFIER ::= { dec 2 }
mib-extensions-1        OBJECT IDENTIFIER ::= { ema 18 }
sysMan                  OBJECT IDENTIFIER ::= { mib-extensions-1 99 }

--
-- [$self NAME] definitions
-- 

$objname	OBJECT IDENTIFIER ::= { sysMan [$self ID] }
"
    set kids [$self children]

#---------------------------------------------------------------
#
#    Ok, now move the componentid group up to be processed 1st
#     and remove the digitalmanagementmodes group
#
#---------------------------------------------------------------

    set index [lsearch $kids /$_name/componentid]
    set kids [lreplace $kids $index $index]

    set index [lsearch $kids /$_name/digitalmanagementmodes]
    set kids [lreplace $kids $index $index]

    foreach c "/$_name/componentid $kids" {
        append mib "\n\t[$c mib]"
    }

append mib "\nEND\n"

}


Component instproc DumpTable {file} {

  switch $file {
    {stdout} -
    {stderr} {
      set fd $file
      set Close 0
    }
    default {
      if {[catch {fconfigure $file} err_msg]} {
        set fd [lindex [sm_sectmpopen "$file"] 0]
      } else {
        set fd $file
      }
      set Close 1
    }
  }

  foreach grp [$self children] {
      puts $fd [$grp DumpTable]
  }

  if {$Close != 0} {
    close $fd
  }

}


###
##      GROUP class methods.
###

#---------------------------------------------------------------
#
#  group class
#
#    Create the Group specific methods.  Attach a standard
#    group GET, SET, and GETNEXT method.  These can be overridden
#    on the exact instance by the MIF developer if needed.
#
#    keycount is used to quickly determine if the object represents
#    a table or a group.  For a group "next" is always 0 which implies
#    no key is needed to reference the single row in the group.
#
#    We also need to insure we pass a zero based set of key indexes
#     to the CITable class, i.e., we have to normalize the ID's
#     which can be in any order into 0-n for quick lookup.
#
#---------------------------------------------------------------

Class Group -superclass MifCommon

Group instproc init {parent name body} {
   $self instvar _atts _children table KEY keycount KEY_list \
	 mirowptr cirowptr _cirowlists makekey 

   set table "${self}_table"
   $self next $parent $name $body

    foreach att $_children {
	lappend _atts [lindex [split $att /] end]
    }

   set mirowptr {}
   set cirowptr {}
   array set _cirowlists  {clean {} added {} dirty {} removed {}}

   set loclist {}
   if {![info exists KEY]} {
      set keycount 0
      set KEY_list {}
   } else {
      set KEY_list [split $KEY ,]
      set keycount [llength $KEY_list]
      
      foreach k $KEY_list {
	 lappend loclist [$self GetLoc $k]
      }
   }
   
   CITable $table $self $loclist
   set makekey MakeKEY$keycount
}



# -----------------------------------------------------
# Post an sysman event for this group via its component.
#   Here is the list of currently supported event types:
#       config.fail
#       config.ok
#       deconfig.fail
#       deconfig.ok
#       file.create
#       file.modify
#       file.remove
#       process.restart
#       process.start
#       process.stop
#   The "name" is the name of the file, process, group, table, etc.
#   The "failReason" only applies to config.fail and deconfig.fail.
#   The "target" is optional.  This may be needed when called with a cluster
#    wide focus, but work must be done on individual nodes as a result of
#    the cluster wide change.  e.g. restarting daemons, etc.

Group instproc postEvent {type name {failReason "??"} {target ""}} {

    [$self set _parent] postEvent $type $name $failReason $target
} 



#---------------------------------------------------------------
#
#  Hmmm, only problem here is how do we know that the table
#   is at the first index ...  It will be if this is the first
#   LOAD but not sure how to insure it is ...
#
#  The advantage of this LOADALL proc is that it can become part
#   of the mifclass.tcl file as the default LOADALL method on a
#   GROUP.  All that is required is that the component instrumentation
#   supports a GROUP level GET function (basically all instrumentation which
#   uses the CITable object and LOAD/FLUSH).
#
#  An application that doesn't support a row level GET (for some
#   odd reason) can unset the default LOADALL proc during initialization.
#
#  This is a signal to SUIT that it must use MIReadRows as it currently
#   does.
#
#  Honestly, I don't think this will actually happen as its probably easier
#   to just implement a GROUP level GET that calls its children.
#
#  In any case, this routine is equivalent in speed to LOADALL-Todd
#   above.  (about 18-20 seconds for 1000 records on a bird machine)
#
# The proc signature for the method LOADALL is as follows:
##
##   /comp/group proc LOADALL { arrayPtr orderPtr numPtr} {
##   ....
##   }
#
#  arrayPtr  - Pointer to an array to create or re-use (inout)
#  orderPtr  - Pointer to an array to create or re-use (inout)
#  nextIdPtr - Pointer to a index to start the arrayPtr array at,
#             returns last value +1
##
#---------------------------------------------------------------

Group instproc LOADALL {arrayPtr orderPtr nextIdPtr {filter ""}} {
    $self instvar KEY table

    upvar $arrayPtr array
    upvar $nextIdPtr   nextId
    upvar $orderPtr orderout

    $self MISetNext {}
    
    # Load data into internal table and initialize the rec pointer.
    set stat [$self LOAD $filter]
    if { ! [cequal $stat ""]} {
	return $stat
    }
    set recId [$table NextRow ""]

    # Copy recs from internal table to array.
    #   No special treatment for groups because they're just one rec tables.
    while { ! [cequal $recId ""]} {
	set array($nextId) [$table GetRow]
	lappend orderout $nextId
	incr nextId
	set recId  [$table NextRow $recId ++]
    }

    return ""
}

#---------------------------------------------------------------
#
# The LOAD method needs to be supplied by the object to get
# the component instrumentation.  LOAD will be invoked for
# every GET and GETNEXT call.  It is up to the individual
# developer to decide when a LOAD method will actually load.
# Typically, this method will define an initialization
# variable and only load the first time through.
#
# The proc signature for the method LOAD is as follows:
##
##   /comp/group proc LOAD { {keylist {}} {id {}} } {
##   ....
##   }
#
# The argument "keylist" provides the caller the mif KEYs of the
#  LOAD requestor.  If kylist is not supplied, the LOAD is being
#  issued from the abstract method GET.
# The argument "id" provides the caller the mif ID field of
#  the LOAD requestor.  If id is not supplied, the LOAD is
#  being issued from the GROUP level.
#
#---------------------------------------------------------------

#----------------------------------------------------------------
##
## This method must only be called by mclUtils or some sysmansh
## user or by the Group's instproc GET. This also means that the 
## CIwriter did not write a LOAD method for their group, instead wrote 
## GETs and GETNEXTs for their attributes.
##
##
#----------------------------------------------------------------
Group instproc LOAD {{key {}} {id {}}} {

    $self instvar table 
    
    set row {}
    set nextrow {}
    foreach attr [$self children] {
      if {[lsearch [$attr info procs] GET] != -1} {
	set val [$attr GET $key]
      } else {
	set val [$attr VALUE]
      }
      set iloc [$self GetLoc [$attr ID]]
      set row [ linsert $row $iloc $val ]
    }
    if {[$table IsEmpty $row] == 1} {
      error "Must supply a LOAD proc for $self"
    }

    $table AddRow row nextrow

#    $self NextIndex
    $table NextRow {}
}


#---------------------------------------------------------------
#
# Procedure:
#	Group RELOAD - this is the default reload method. It is only
#	used when the mcl author did not supply a RELOAD routine.
# Inputs:
#	key - mcl key that requested this reload. IOW, a row key
#	id  - ID of the desired attribute from that row
# Outputs:
# 	None
# Returns:
#	Null string for success. Non-null string for errors
# Notes:
#
#
#---------------------------------------------------------------

Group instproc RELOAD { {key {}} {id {}} } {

    error "Must supply a RELOAD proc for $self" 

} ;# end Group instproc RELOAD


#----------------------------------------------------------------
##
## This method must only be called by mclUtils or some sysmansh
## user or by the Attribute's abstract method SET. This also 
## means that the CIwriter did not write a FLUSH method for their 
## group, instead wrote SET for their attributes.
##
#----------------------------------------------------------------
Group instproc FLUSH { {keylist {}}   {id {}} } {

    $self instvar table 

    set needed_sets [llength [$self children]]
    set have_sets 0

    foreach attr [$self children] {
      if {[lsearch [$attr info procs] SET] != -1} {
        incr have_sets
      }
    }
    if {$have_sets != $needed_sets} {
      error "Must supply a FLUSH proc for $self"
      return
    }

    $self CIResetRows

    while { [set row [$self CIReadRow ]] != {}} {
      set keylist [ $table makeKEY $row ]
      foreach child [$self children] {
        $child SET [lindex $row [ $self GetLoc [$child ID] ] ] $keylist
      }
    }
}
	
#----------------------------------------------------------------
##
## This method will be called, when the CIwriter did not write a 
## GETNEXT method for their attribute, instead wrote a LOAD method.
##
## Since they wrote a LOAD method, we can just pluck the row for this 
## keylist from our internal tables and index into the cell and return 
## the appropriate value.
##
##
##  If someone passes as errPtr in, any result from the LOAD command
##   will be passed along to the caller, in either case, we return
##   a null row.
##
#----------------------------------------------------------------
Group instproc GET {{keylist {}} {errPtr {}}} {
    $self instvar table mirowptr cirowptr

    set wasloaded [$table IsLoaded]
    set result [$self LOAD $keylist {}]

    # initilize status as OK
    if { ! [cequal $errPtr ""]} {
	upvar $errPtr err
        set err ""
    }

    # if there was a problem, report error if possible and return "".
    if { ! [cequal $result ""]} {
	if { ! [cequal $errPtr ""]} {
	    set err $result
	}
        return ""
    }

    if { $wasloaded == 0 } {
        set mirowptr [$table NextRow {}]
        set cirowptr $mirowptr
    }

    if {$keylist == {}} {
    	set result [$table GetRow]
    } else {
    	set result [$table GetRow $keylist]
    }

return $result

}

#----------------------------------------------------------------
##
## This method will be called, when the CIwriter did not write a 
## GETNEXT method for their attribute, instead wrote a LOAD method.
##
## Since they wrote a LOAD method, we can just pluck the row for this 
## keylist from our internal tables and index into the cell and return 
## the appropriate value.  Inorder to gaurantee that we are getting the
## correct row we will call the Group's GET proc.
##
#----------------------------------------------------------------

Group instproc GETNEXT {{keylist {}} {errPtr {}}} {
    $self instvar table mirowptr

    if { [$table IsLoaded] == 0} {
	set result [$self LOAD $keylist {}]
        if {$result != {}} {
            if {$errPtr != {}} {
		upvar $errPtr err
		set err $result
	    }
            return {}
        }
        set mirowptr {}
        set cirowptr {}
    }

    if {$keylist != {}} {
        set mirowptr [$table NextRow $keylist ++]
    } else {
        set mirowptr [$table NextRow $mirowptr ++]
    }

    if {$mirowptr == {}} {
        return {}
    } else {
        return [$self GET]
    }
}

#----------------------------------------------------------------
##
## This method will be called, when mclUtils and/or other MCL mgmt
## routines call a group level SET directly.
##
## The CIwriter could have written a SET at the attribute level or
## a FLUSH at the GROUP level.  Therefore, we will faithfully pass this
## row, attribute by attribute to the attribute level SET call.  If the 
## CIwriter did not write a SET at attribute, then the abstract method SET 
## will call the FLUSH correctly.
##
#----------------------------------------------------------------

Group instproc SET {row} {
    $self instvar table

    set keylist [$table makeKEY row]
    foreach child [$self children] {
	set loc_in_row [ $self GetLoc [$child ID] ]
        $child SET [lindex $row $loc_in_row ] $keylist
    }
}

#----------------------------------------------------------------
##
## Validates the whole group with respect to performing the
## operation on oldrow and newrow.
##
## returns a null string for pass and error string for fail.
##
#----------------------------------------------------------------
Group instproc Validate {operation oldrow newrow} {
  ## puts stderr "Validate@group: \ncame for $operation on \n-$oldrow- \nand\n -$newrow-"
  return {}
}

#----------------------------------------------------------------
##
## Validates the row based operation with respect to performing 
## operation on oldrow and newrow.
##
## returns a null string for pass and error string for fail.
##
#----------------------------------------------------------------
Group instproc ValidateRow {operation oldrow newrow} {
  ## puts stderr "ValidateRow@table: \ncame for $operation on \n-$oldrow- \nand\n -$newrow-"
  return {}
}

#---------------------------------------------------------------
## 
## The ID's for the attributes need not be sequential - therefore,
## we will build an IdMap and a NameMap at the beginning.  
##
## The purpose of these Maps is different from the one that MifMap builds.
## The sole purpose is to do a quick lookup from an attribute name to the 
## real ID and vice versa.
##
#---------------------------------------------------------------
Group instproc GetLoc { id } {
    $self instvar IdMap NameMap 

    if {[info exists IdMap(${id})] != 0} {
        return $IdMap($id)
	}

    set iloc 0
    foreach attr [$self children] {
	set IdMap([$attr ID]) $iloc
	set NameMap([$attr ID]) $attr
        incr iloc
        }
    if {[info exists IdMap(${id})] != 0} {
        return $IdMap($id)
    } else {
    	return 0
    }
}

# --------------------------------------------------------------------------
##
## retrieves the value stored in the NameMap array using the attribute ID
##
# --------------------------------------------------------------------------
Group instproc GetName { id } {
  $self GetLoc $id
  $self instvar NameMap

  return $NameMap($id)

}


#---------------------------------------------------------------
#  Clear out all the key maps.  The key maps are to track whenever
#  a record's keys change.  This is important because sometimes a
#  records key is changed in the FLUSH routine.  Without the map
#  tracking the change, higher level routines won't be able to find
#  the record after that change.
#---------------------------------------------------------------

Group instproc ResetKeyMap {} {
	$self instvar _keyMap
	catch "unset _keyMap"
}


#---------------------------------------------------------------
#  Build a keylist for a given row based on the MIF KEY
#  field and rules.
#---------------------------------------------------------------

Group instproc MakeKEY {row} {
    return [$self [$self set makekey] $row]
}


#---------------------------------------------------------------
#  Build a keylist for a given row based on the MIF KEY
#  field and rules.  Will see if that key has been changed in a lower
#  level routine.  If so, return the new key, not the original one.
#---------------------------------------------------------------

Group instproc MakeKeyCheckingChanges {row} {
    $self instvar _keyMap

    set key [$self [$self set makekey] $row]
    while {[info exists _keyMap($key)]} {
	set key $_keyMap($key)
    }
    return $key
}


# --------------------------------------------------------------------------
##
## No keys in this GROUP, just return a null
## 
##
# --------------------------------------------------------------------------
Group instproc MakeKEY0 {row} {
    return {}
}

# --------------------------------------------------------------------------
##
## Using a row, this method extracts the key fields and creates a key that
## will be used for indexing into the Table class data structures
##
## Only one key in the group, grab it
##
# --------------------------------------------------------------------------
Group instproc MakeKEY1 {row} {

    $self instvar KEY

    return [lindex $row [$self GetLoc $KEY]]
}

Group instproc MakeKEY2 {row} {
# --------------------------------------------------------------------------
##
## Using a row, this method extracts the key fields and creates a key that
## will be used for indexing into the Table class data structures
##
##  
## 
# --------------------------------------------------------------------------

    $self instvar KEY_list
    
    lassign $KEY_list k1 k2
    return "[lindex $row [$self GetLoc $k1]][lindex $row [$self GetLoc $k2]]"
}


#----------------------------------------------------------------
##
## This method resets the MI's next pointer to the end of the table.
##
#----------------------------------------------------------------
Group instproc ResetNext {} {
  $self instvar mirowptr table
  set mirowptr [$table NextRow {}]
}

#----------------------------------------------------------------
##
## This method sets the MI's next pointer.  If a keylist was provided,
## then this method will set the MI's next pointer to point to that 
## row, else will point to the next logical row.  If the current logical 
## row is the end of the table, then we will need to rotate the next
## pointer.
##
#----------------------------------------------------------------
Group instproc NextIndex {{keylist {}}} {
    $self instvar table mirowptr

    if {$keylist != {}} {
    	set mirowptr [$table NextRow $key]
    }

    set mirowptr [$table NextRow $mirowptr ++]
    return $mirowptr
}

# --------------------------------------------------------------------------
##
## The following methods provide a shortcut to the Table Management Routines
##
# --------------------------------------------------------------------------

Group instproc _ClearTable {{flags {}}} {
# --------------------------------------------------------------------------
##
## Clears or initializes the internal memory table
##
# --------------------------------------------------------------------------

  $self instvar table
  eval $table ClearTable $flags
}

# --------------------------------------------------------------------------
##
## Deletes a row from the internal memory table
##
# --------------------------------------------------------------------------
Group instproc _DelRow {row} {

  $self instvar table
  return [$table DelRow $row]
}

# --------------------------------------------------------------------------
##
## Modifies a row from the internal memory table
##
# --------------------------------------------------------------------------

Group instproc _ModRow {oldrow newrow} {
  $self instvar table
  return [$table ModRow $oldrow $newrow]
}

###
##   public interfaces to the Management Application Interfaces
##
##   Every publically accessible method for the MI is defined here.  They all
##   start with "MI".
###

Group instproc MIMakeKey {keylist} {
 
  switch [llength $keylist] {
    {0} { return {} }
    {1} { return [lindex $keylist 0]}
    {2} { return "[lindex $keylist 0][lindex $keylist 1]" }
  }

}

#----------------------------------------------------------------
##
## If an index into the internal memory table is known, then 
## this method will set the MI's next pointer to point there.
##
#----------------------------------------------------------------

Group instproc MISetNext {key} {
    $self instvar mirowptr table 
    set mirowptr [$table NextRow $key]
}

#----------------------------------------------------------------
##
## Returns the value of the loaded instance variable for a given  
## internal memory table.
##
#----------------------------------------------------------------
Group instproc MIIsLoaded {} {

  $self instvar table
  return [$table IsLoaded]
}

#----------------------------------------------------------------
##
## Add a new row to the internal memory table and mark the row as 
## added.
##
#----------------------------------------------------------------

Group instproc MIAddRow {row {nextrow {}}} {
  $self instvar table
  set retval [$table AddRow row nextrow]
  $table state [$table makeKEY $row] added
  return $retval
}

#----------------------------------------------------------------
##
## Modify oldrow with newrow 
##
#----------------------------------------------------------------
Group instproc MIModRow {oldrow newrow} {

  return [$self _ModRow $oldrow $newrow]
}

#----------------------------------------------------------------
##
## Delete row 
##
#----------------------------------------------------------------
Group instproc MIDelRow {row} {

  return [$self _DelRow $row]
}

###
##   public interfaces to the Component Instrumentation Interfaces
##
##   Every publically accessible method for the CI is defined here.  They all
##   start with "CI".
###

# --------------------------------------------------------------------------
##
## Clears or initializes the internal memory table on behalf of CI
##
##  If we are clearing the entire table we need to reset all of our
##   various key pointers (mirowptr in particular) to the first row
##   in the table so we simply just cause a CIResetRows to occur.
##
# --------------------------------------------------------------------------
Group instproc CIClearTable {{flags {}}} {
  $self instvar table mirowptr cirowptr
  eval $table ClearTable $flags
  if {$flags == {}} {
      $self CIResetRows
      set mirowptr $cirowptr
  }
}

# --------------------------------------------------------------------------
##
## Initializes the CI's next pointer.  Note: MIs next pointer is "next".
##
# --------------------------------------------------------------------------

Group instproc CIResetRows {} {
    $self instvar cirowptr table _cirowlists
    set savekey [$table NextRow]
    set cirowptr [$table NextRow {}]

    set _cirowlists(clean) {}
    set _cirowlists(added) {}
    set _cirowlists(dirty) {}
    set _cirowlists(removed) {}

    $table NextRow $savekey
}

# --------------------------------------------------------------------------
##
## Reads a row from the internal memory table.
##
## Optionally, the user may specify a type (based on ROW_CLEAN, ROW_MODIFIED,
## ROW_ADDED or ROW_DELETED - in which case we will call the _CIReadEachRow
##
## In any of the CI functions we need to save/restore the state of the table
##
## CIReadRow is really a clone of GETNEXT except that it must preserve the
##  MI's pointer (mirowptr) and restore it when its finished with the table
##
#
# --------------------------------------------------------------------------
Group instproc CIReadRow { {type_of_read {NORMAL}} } {

    if { $type_of_read != "NORMAL" } {
        return [$self _CIReadRow_specific $type_of_read]
    }

    $self instvar table cirowptr mirowptr

    $table NextRow $cirowptr

    if {$cirowptr == {}} {
        set row {}
    } else {
        set row [$table GetRow $cirowptr]
    }

    set cirowptr [$table NextRow $cirowptr ++]
    return $row
}

global _CIStateMap
set _CIStateMap(NORMAL)  {}
set _CIStateMap(0) clean
set _CIStateMap(1) dirty
set _CIStateMap(2) added
set _CIStateMap(3) removed


#---------------------------------------------------------------
#
#   Handle any type of specific read request for a particular
#    type of state.  There is an array of clean, dirty, added,
#     removed keys maintained to remember state between successive
#     reads.  If the list is NULL then we get the list of keys
#     and prepend a NULL key (to handle the end of list case)
#
#---------------------------------------------------------------

Group instproc _CIReadRow_specific {type_of_read} {
    $self instvar _cirowlists table cirowptr mirowptr
    global _CIStateMap
    
    set type $_CIStateMap($type_of_read)

    if {$_cirowlists($type) == {}} {
        eval $table keys keylist $type
        set _cirowlists($type) $keylist
        lvarpush _cirowlists($type) {}
    }

    set cirowptr [lvarpop _cirowlists($type) end]
    set savekey $mirowptr

    if {$cirowptr == {}} {
        set row  {}
    } else {
    	set row [$self GET $cirowptr]
    }

    set mirowptr $savekey
    return $row
}

# --------------------------------------------------------------------------
##
## return a boolean map for the row that indicates if the attributes in 
## the given row are modified (1) or not(0).
##
## caveats:  if the row is unchanged, then returns 0's
##           if the row is added or deleted, then return 1's
##           otherwise (mod) we will retrieve the value from the bitmap 
##           array and return it.
##
# --------------------------------------------------------------------------

Group instproc CIGetAttrModMask { row } {
   Mcl_Global "typedef"
   $self instvar table
   
   if { [$self CIIsModified $row]  == $ROW_CLEAN } { 
      return [ $table MakeRowWithBits row 0 ]
   }
     
   if { [$self CIIsModified $row]  == $ROW_MODIFIED } { 
      set bitrow [$table GetModMap $row ]
      if { $bitrow != {} } {
        return $bitrow
      } 
   }
   return [ $table MakeRowWithBits row 1 ]
     
}


# --------------------------------------------------------------------------
##
## This method returns 1 if the newrow has the same key as
## a row already in the table. Otherwise, it returns 0.
## 
## Put a call to this procedure in the Validate or ValidateRow
## procedure for your GROUP (ie, not at the attribute level
## validation, because you need oldrow and newrow).
##
## I couldn't figure out a way around having to pass oper
## and oldrow.  CIGetAttrModMask would have been useful,
## but all I ever got out of it was zeros.
##
# --------------------------------------------------------------------------
Group instproc CIIsDuplicate { oper oldrow newrow } {
#echo "$self CIIsDuplicate \{ \"$oldrow\" \"$newrow\" \}"

    # No need to check for duplicates for a delete
    if { [cequal $oper del] } {
	return 0
    }

    # Look for row with same key in table
    set found [$self CIGetRow $newrow] 

    set dup 0
    if { $found != {} } {

	# Row was found, but is it a dup, 
	# a deleted row or this row?

	set row_status [$self CIIsModified $found]

	# row_status == 3 => found row was deleted
	if { $row_status != 3 } {

	    # oldrow empty => user pressed add
	    if { $oldrow != {} } {
		# User pressed mod

		$self instvar table
		set newKeyList [$table makeKEY $newrow]
		set oldKeyList [$table makeKEY $oldrow]

		foreach newKey $newKeyList oldKey $oldKeyList {
		    if { ![cequal $newKey $oldKey] } {
			# User changed a key field and the
			# new key is one already in the list
			set dup 1
			break
		    }
		}
		# If dup == 0 at this point then found
		# is the row that we are modifying 
		# and the user either changed a non-key 
		# field, or pressed apply or OK without 
		# making changes

	    } else {
		# User pressed add and we found an
		# existing row with the same key
		set dup 1
	    };				# end if oldrow not empty
	};				# end if status not 3
	# ELSE we found a deleted row,
	# so this row is not a dup
    };					# end if not del

    return $dup
}


# --------------------------------------------------------------------------
##
## This method returns the value of the DirtyFlag from the internal memory
## table.  The values could be 0 (unmodified), 1(modified), 2(added) or
## 3(deleted).
##
# --------------------------------------------------------------------------
Group instproc CIIsModified {row} {

    $self instvar table
    switch [$table IsDirtyRow $row] {
    	clean { return 0 }
    	dirty { return 1 }
    	added { return 2 }
    	removed { return 3 }
    }
return {}
}

# --------------------------------------------------------------------------
##
## This method returns the contents of the previous value of
## the row.  If there was no modification the result is {}.  Deleted and
## Added rows will return {}.
##
# --------------------------------------------------------------------------
Group instproc CIGetRow {{row {}}} {
    $self instvar table
    if {$row != {}} {
        $table GetRow [$table makeKEY $row]
    } else {
    	$table GetRow
    }
} ;# end Group CIGetRow

# --------------------------------------------------------------------------
##
## This method returns the contents of the previous value of
## the row specified by key. 
##
# --------------------------------------------------------------------------
Group instproc CIGetRowByKey { key } {
    $self instvar table
    if { [lempty $key] != 1 } {
        return [$table GetRow $key]
    } 

    return {}

} ;# end Group CIGetRowByKey 


# --------------------------------------------------------------------------
##
## This method returns the previous contents of the previous value of
## the row.  If there was no modification the result is {}.  Deleted and
## Added rows will return {}.
##
# --------------------------------------------------------------------------
Group instproc CIGetOldRow {{row {}}} {
    $self instvar table
    if {$row != {}} {
        $table GetModRow [$table makeKEY $row]
    } else {
    	$table GetModRow
    }
}


#----------------------------------------------------------------
##
## Add a new row to the internal memory table and mark the row as 
## added.
##
#----------------------------------------------------------------
Group instproc CIAddRow {row {nextrow {}}} {

  $self instvar table
  set retval [$table AddRow row nextrow]
  return $retval
}


#----------------------------------------------------------------
##
## Modify oldrow with newrow 
##   Need to keep track of any key change so record can be retrieved
##   with old key too.
##
#----------------------------------------------------------------
Group instproc CIModRow {oldrow newrow} {
    $self instvar _keyMap

    set oldKey [$self MakeKEY $oldrow]
    set newKey [$self MakeKEY $newrow]
    if { ! [cequal $newKey $oldKey]} {
	set _keyMap($oldKey) $newKey
    }
    return [$self _ModRow $oldrow $newrow]
}


#----------------------------------------------------------------
##
## Delete row 
##
#----------------------------------------------------------------
Group instproc CIDelRow {row} {

  return [$self _DelRow $row]
}

Group instproc type {} {
	return $class
}

#----------------------------------------------------------------
##
##  Generate the Group portion of a MIF.  If the Group contains
##  a KEY then it defines a table, otherwise, its a simple group
##
#----------------------------------------------------------------
Group instproc mif {args} {

    set mif "\n START GROUP
     NAME = \"[$self NAME]\"
     CLASS = \"[$self CLASS]\""

    append mif "\n     ID = [$self ID]"

    foreach k {KEY PRAGMA} {
         if {[$self exists $k] != -1} {
	     append mif "\n     $k = [$self KEY]"
	 }
    }

    foreach c [$self children] {
        append mif "\n[$c mif]"
    }

    append mif "\n END GROUP"

    return $mif
}

#----------------------------------------------------------------
##
##  Generate the Group portion of a MIB.  If the Group contains
##  a KEY then it defines a table, otherwise, its a simple group
##
#----------------------------------------------------------------
Group instproc mib {args} {
    $self instvar objname _name

    set parent [$self parent]
    set objname [$self _mibname $_name]

    set mib ""
    
    if {[$self exists KEY] == -1} {
        set groupobjname "${objname}Objects"

    append mib "\n
${objname}Group       OBJECT IDENTIFIER ::= { [$parent set objname] [$self ID] }
$groupobjname     OBJECT IDENTIFIER ::= { ${objname}Group 1 }


"
    } else {
        set groupobjname "e$objname"
    }
    
    set prefix "a[$self ID]"
    
    set kids [$self children]
    set nkids [llength $kids]
    
    if {[$self exists KEY] != -1} {

    append mib "\nS${objname} ::= SEQUENCE \{\n"

    foreach c  $kids {
	
        set kidname [$self _mibname [$c set _name]]
    	append mib [format "\t%-30s %-30s\n" "${prefix}$kidname" "[$c _type_snmp],"]
    }

    append mib [format "\t%-30s %-30s\n" "${prefix}RowIndex" "MclRow"]
    append mib "\}\n"

#---------------------------------------------------------------
#
#   Need to find an unused attribute ID.   Start with
#    the number of attributes + 1, try to get a name for 
#    that ID, if successful, we're done, otherwise, increment
#    by 10 and try again.  Somewhere there has to be hole.
#
#    Note: It doesn't have to be the last ID, just an unused 
#     one.
#
#---------------------------------------------------------------

    incr nkids
    loop n $nkids 1000000000 10 {
        if {[catch { $self GetName $n }] != 0}  {
            break
        }
    }
    
    append mib "

t${objname} OBJECT-TYPE
	SYNTAX	SEQUENCE OF S${objname}
	ACCESS  not-accessible
	STATUS  mandatory
	DESCRIPTION \"\"
	::= \{ [$parent set objname] [$self ID] \}


$groupobjname OBJECT-TYPE
	SYNTAX S${objname}
	ACCESS  not-accessible
	STATUS  mandatory
	DESCRIPTION \"\"
	INDEX	{${prefix}RowIndex}
	::= \{ t${objname} 1 \}

${prefix}RowIndex OBJECT-TYPE
        SYNTAX          MclRow
        ACCESS          not-accessible
        STATUS          mandatory
        DESCRIPTION     \"Row index for table\"
        ::= \{$groupobjname $n\}

"
    }


    foreach c $kids {
        append mib "\n[$c mib $groupobjname]"
    }

    return $mib
}

#----------------------------------------------------------------
##
## Debug proc - dumps internal table structure
##
#----------------------------------------------------------------
Group instproc DumpTable {} {
  $self instvar table
  return [$table DumpTable]

}

mif_make_keywords Group {KEY}

###
##      TABLE class methods.
###

  ##
  # Support the GROUP/TABLE construct - Table is same as Group with KEY
  #

Class Table -superclass Group

	
# ----------------------------------------------------------------------  

Table instproc init {parent name body} {
    $self instvar   _atts _defaults

    $self next $parent $name $body

    set tmp  [split $self /]
    set comp [lindex $tmp 1]
    set tbl  [lindex $tmp 2]
    MCL_GetDefaults $comp $tbl defList
    _list2TagValues $_atts $defList _defaults
}



# ----------------------------------------------------------------------  
# Add a record for the current value array.

Table instproc _addRec {} {
    $self instvar      _atts _vals

    _tagValues2List _vals $_atts valList
    $self CIAddRow  $valList
}



#---------------------------------------------------------------
#
#   Attribute class
#
#       Create the attribute specific methods.  GET and SET
#
#---------------------------------------------------------------

Class Attribute -superclass MifCommon

#---------------------------------------------------------------
#
#	Ok, this is kind-of underhanded.  Set the value field to
#	{} so that if the VALUE of an attribute isn't set by
#	the time we generate a MIF then it will default to  a
#	dynamic value, otherwise if the value is set by MIF
#	generation time then we'll output a VALUE = [$self VALUE] 
#	effectively making the attribute a static.  We also need  to
#	default the ACCESS to Read-Only to insure this scheme
#	actually  works.
#
#---------------------------------------------------------------

Attribute instproc init {parent name body} {

   $self instvar _type_
   $self VALUE {}
   $self ACCESS Read-Only
   
   $self next $parent $name $body

   # Set the default value for enums (if VALUE was not defined
   set enum [$self children]
   if { $enum != {} && [cequal [$self VALUE] ""] } {
      if { $_type_ == 5 } {
	$self VALUE [lindex [split [join [$enum GET] :] :] 0]
      } else {
	$self VALUE [lindex [split [join [$enum GET] :] :] 1]
        }
      }
}

#----------------------------------------------------------------
##
## This method will be called, when the CIwriter did not write a 
## GET method for their attribute, instead wrote a LOAD method.
##
## Since they wrote a LOAD method, we can just pluck the row for this 
## keylist from our internal tables and index into the cell and return 
## the appropriate value.
##
#----------------------------------------------------------------
Attribute instproc GET { {keylist {}} {statPtr {}} } {

    set parent [$self parent]

    if { ! [cequal $statPtr ""]} {
	upvar $statPtr stat
	set row [$parent GET $keylist stat]
	if { ! [cequal $stat ""]} {
	    return ""
	}
    } else {
	set row [$parent GET $keylist]
    }
    set ncol [$parent GetLoc [$self ID]]
    return [lindex $row $ncol]
}

#----------------------------------------------------------------
##
## This method will be called, when the CIwriter did not write a 
## GETNEXT method for their attribute, instead wrote a LOAD method.
##
## Since they wrote a LOAD method, we can just pluck the row for this 
## keylist from our internal tables and index into the cell and return 
## the appropriate value.
##
#----------------------------------------------------------------
Attribute instproc GETNEXT {{keylist {}}} {

    set parent [$self parent]
    set row [$parent GETNEXT $keylist]
    set ncol [$parent GetLoc [$self ID]]
    return [join [lindex $row $ncol]]
}

#----------------------------------------------------------------
##
## This method will be called to return the current values of the
## row key pointer.  The primary consumer is DMICI who needs
## to determine if we are at the end of the table.
##
#----------------------------------------------------------------
Attribute instproc GETROWKEY {} {
	set parent [$self parent]
	return [$parent set mirowptr]
}


#----------------------------------------------------------------
##
## This method will be called, when the CIwriter did not write a 
## SET method for their attribute, instead wrote a FLUSH method.
##
## We must, modify the internal tables to reflect this change and
## immediately call the FLUSH at the parent level.
##
#----------------------------------------------------------------
Attribute instproc SET {value {key {}}} {

    ## get the row that points at this key from the group level
    ##
    set row [[$self parent] GET $key]

    ## we have nothing to modify, because its a null row.
    ##
    if {$row == {}} {
        return {}
    }
    
    ## extract the location of the cell in the row for this attribute
    ##
    set id [[$self parent] GetLoc [$self ID]]

    ## replace the whole row with the new row.  We have to
    ## use MODIFY here in case that this attribute is one of the
    ## key values.
    ##
    [$self parent] MIModRow $row [lreplace $row $id $id $value]

    ## call group level FLUSH immediately so that we can make it real
    ##
    [$self parent] FLUSH $key [$self ID]
    return $value
}

#----------------------------------------------------------------
##
## Validates the attribute with respect to performing the
## operation on oldval and newval.  Operation = add, mod, del
##
## returns a null string for pass and error string for fail.
##
#----------------------------------------------------------------
Attribute instproc Validate {operation oldval newval} {
  ## puts stderr "Validate@attr: \ncame for $operation on \n-$oldval- \nand\n -$newval-"

  $self instvar _type_
  set enum [$self children]

  if { [cequal $operation "del" ] } {
	return
	}

  if {$enum != {}} {
      switch $_type_ {
            100 {
	          if {[$enum getnum $newval] == {}} {
	            array set enumvals [split [join [$enum GET] :] :]
	            set msg {}
              	    foreach key [lsort [array names enumvals]] {
              	        append msg "$enumvals($key) "
  	                }
  	            return "Valid choices are: $msg"
	          }
       	        }
            5   {
	          if {[$enum getval $newval] == {}} {
	            array set enumvals [split [join [$enum GET] :] :]
	            set msg {}
              	    foreach key [lsort [array names enumvals]] {
              	        append msg "$key=$enumvals($key) "
  	                }
  	            return "Valid choices are: $msg"
	          }
	    }
      }

  }

  return {}
}

mif_make_keywords Attribute {CDFGROUPS ACCESS STORAGE TYPE}

Attribute instproc type {} {
	return $class
}

Attribute instproc mif {args} {

  set t [translit a-z A-Z [$self TYPE]]
  if { [cequal $t "BOOLEAN" ] } {
	set t INTEGER
	}

  set mif "
  START ATTRIBUTE
 	NAME = \"[$self NAME]\"
 	ID = [$self ID]
 	DESCRIPTION = [$self _description dmi]"
  if { [$self children] == {} } {
  	append mif "\n        TYPE = $t"
}

#---------------------------------------------------------------
#
#  If someone supplies a VALUE directly in the MIF definition
#   then this is passed directly to the output MIF and the
#   SL should never request a GET on this attribute.  However,
#   we need to make sure that if we are do request a GET we
#   return the VALUE if supplied and not invoke the default GET
#   method.  If the MIF developer overrides the GET then the
#   GET should be invoked, the default GET method is what needs
#   to support possibility of a VALUE clause.
#
#---------------------------------------------------------------

foreach k {ACCESS STORAGE} {
    if {[$self exists $k] != -1 } {
        append mif "\n        $k = [$self $k]"
    }
}

# put VALUE statement at end of attr def.  Reason being,
# if object is type enum, value can't be specified until
# ENUM is defined.
foreach c [$self children] {
    append mif "\n[$c mif]"
}


#---------------------------------------------------------------
#
#   Put out a value clause, strings need to be quoted.  If no
#    VALUE is defined as of yet, assume it is to be directly
#    instrumented, otherwise reflect it in the MIF as a static
#    VALUE
#
#---------------------------------------------------------------

append mif "\n        VALUE = *\"DMICI\""
append mif "\n  END ATTRIBUTE"
}

Attribute instproc mib {groupobjname args} {

    
    set objname [$self _mibname [$self set _name]]
    set prefix a[[$self parent] ID]
    
set mib "
${prefix}${objname} OBJECT-TYPE  
	SYNTAX  [$self _type_snmp]"

    set enum [$self children]
    if {$enum != ""} {
    	set enumtext [$enum VALUE]
        array set enumvals [split [join $enumtext :] :]
    	append mib " \{\n"
	foreach key [lsort [array names enumvals]] {
	    set name [$self _mibname $enumvals($key)]
            regsub -all { } $name {} name
	    append mib [format "\t\t%-15s %-20s\n" "v$name" "($key),"]
	}
    	set mib [string trimright $mib ", \n"]
	append mib "\n	\}\n"
    }
if { [$self SCOPE] != "private" } {    		
     append mib "	
        ACCESS  [string tolower [$self ACCESS]]
        STATUS  mandatory
 	DESCRIPTION [$self _description snmp]
 	::= \{ $groupobjname [$self ID] \}
     "
} else {
     append mib "	
        ACCESS  not-accessible
        STATUS  mandatory
 	DESCRIPTION [$self _description snmp]
 	::= \{ $groupobjname [$self ID] \}
     "
}
return $mib
}


#---------------------------------------------------------------
#
#  Provide a type mapping for the current TYPE for DMICI
#
#---------------------------------------------------------------

Attribute instproc _type {args} {
    $self instvar TYPE type_size
    $self instvar _type_


#---------------------------------------------------------------
#
#  Allow a type of "string" to mean string(24) for now.
#   We may want to add a method to the component object so
#   that this can be overridded on a per component basis by
#   the MCL developer.
#
#---------------------------------------------------------------


    if {[info exists _type_] == 0 } {
	set t [translit A-Z a-z $TYPE]

        regexp {.*\((.*)\)} $t {\1} type_size

    	switch -regexp $t {
	    counter 		{ set _type_ 1 }
	    counter64 		{ set _type_ 2 }
	    gauge 		{ set _type_ 3 }

	    integer 		-
	    number 		-
	    int 		{ set _type_ 5
				  if { [cequal $t "number"] } {
				     set TYPE INTEGER
				  }
	    			}
	    integer64 		-
	    int64 		{ set _type_ 6 }
	    octetstring(.*) 	{ set _type_ 7 }
	    displaystring(.*) 	{ set _type_ 8 }
	    string(.*) 		{ set _type_ 8 
				  if { [cequal $t "string"] } {
				     set TYPE STRING(24)
				  }
				}
	    string 		{ set _type_ 8
				  set TYPE STRING(24)
				}
	    date 		{ set _type_ 11 }


#---------------------------------------------------------------
#
#	MCL defined meta-types
#
#---------------------------------------------------------------

	    boolean             {
	    			set _type_ 5
				}
	    enum		{ set _type_ 100 }

	    default		{ set _type_ 0 }
	}
    }

return $_type_
}

#---------------------------------------------------------------
#
#  Provide a type mapping for the current TYPE for MIB generation
#
#---------------------------------------------------------------

Attribute instproc _type_snmp {args} {
     $self instvar type_size
     
     set dmitype [$self _type]

     switch $dmitype {

     	1	-
     	2	-
     	3	{ set val MclCounter}
     	5	-
      100	-
     	6	{ set val INTEGER}
     	7	{ set val "OCTET STRING (SIZE($type_size))"}
     	8	{ set val MclDisplaystring}
       11	{ set val MclDate}
  default 	{ set val MclDisplaystring}
     }

return $val
}


#---------------------------------------------------------------
#
#  Attribute passthru procs for enum's
#
#---------------------------------------------------------------

Attribute instproc enumgetval {number} {
    set enum [$self children]
    if {$enum != {}} {
        return [$enum getval $number]
    }
    return {}
}

Attribute instproc enumgetnum {val} {
    set enum [$self children]
    if {$enum != {}} {
        return [$enum getnum $val]
    }
    return {}
}


#---------------------------------------------------------------
#
#  Now redefine the standard TYPE argument to also invoke
#   the _type method so that the _type_ variable is *always*
#   set when the MCL definition is executed.  This allows
#   DMICI to always count on an _type_ variable to exist
#   for any valid attribute definition.
#
#---------------------------------------------------------------

eval "Attribute instproc TYPE {args} {
	[Attribute info instbody TYPE]
	\$self _type
	return \[\$self set TYPE\]
}"

#---------------------------------------------------------------
#
#  ENUM class
#
#---------------------------------------------------------------

Class Enum -superclass MifCommon

Enum instproc init {parent name body} {

   # If my parent is a component, level is 1, else enums are children of
   #  an attribute, making them level 3

   set pClass [$parent info class]
   if {![cequal $pClass "Component"] && ![cequal $pClass "Attribute"]} {
      error "enum $self not allowed here"
   }
   
   $self next $parent $name $body
}


#---------------------------------------------------------------
#
#  Enum don't support ID & DESCRIPTION so remove those methods
#   from the Enum class.
#
#  Enums are really dain bramaged right now, we need to give them some
#   more thought - fvc 12/13/96
#
#---------------------------------------------------------------

Enum instproc DESCRIPTION {args} { 
   error "$self: ENUM's do not support descriptions"
}
Enum instproc ID {args} {
   error "$self: ENUM's do not support ID's"
}

Enum instproc GET {args} {
   if {[string first VALUE [$self info vars]] == -1 } {
      $self VALUE {}
   }
   return [$self VALUE]
}

Enum instproc type {} {
	return $class
}

Enum instproc getval {number} {
    array set enumvals [split [join [$self GET] :] :]
    if {[info exists enumvals($number)] == 1} {
        return $enumvals($number)
    }
    return {}
}

Enum instproc getnum {val} {
    set enumvals [split [join [$self GET] :] :]
    
    set index [lsearch -exact $enumvals $val]
    if {$index == -1} {
    	return {}
    }
    incr index -1
    return [lindex $enumvals $index]
}


Enum instproc mif {args} {

  set mcl_val [$self VALUE]
  set vpair [expr [llength $mcl_val] / 2 ]
  set vstatement ""
  for {set n 1} {$n <= $vpair} {incr n} {
    append vstatement "\n            "
    append vstatement [lindex $mcl_val [expr ($n - 1)*2]]
    append vstatement " = "
    append vstatement \"[lindex $mcl_val [expr (($n - 1)*2) + 1]]\"
  }
  
  set type [[$self parent] TYPE]
  set mif "
  	TYPE = START ENUM
	  $vstatement
  	END ENUM\n"

  return $mif
}

Enum instproc mib {args} {
return {}
}

mif_make_keywords Enum {TYPE}

#---------------------------------------------------------------
#
#  Now define the MCL definition for the common GROUP headers
#
#---------------------------------------------------------------

proc Required_Groups {} {

GROUP componentid {
    NAME ComponentID
    ID 1
    CLASS "DMTF|ComponentID|001"
    DESCRIPTION \
" This group defines attributes common to all components.
The group is required in all DMTF components and must
have Group ID = 1."

    ATTRIBUTE manufacturer {
      NAME    "Manufacturer"
      ID      1 
  DESCRIPTION  "Digital Equipment Corporation Systems Management generated MIF"
      ACCESS  READ-ONLY 
      STORAGE COMMON 
      TYPE    STRING(64) 
      VALUE   "Digital Equipment Corporation"
    }

    ATTRIBUTE product {
      NAME    "Product"
      ID      2 
      DESCRIPTION " Name of the product"
      ACCESS  READ-ONLY 
      STORAGE COMMON 
      TYPE    STRING(64)
      VALUE   "unknown" 
    }

   ATTRIBUTE version {
      NAME    Version
      ID      3 
      DESCRIPTION "VERSION"
      ACCESS  READ-ONLY 
      STORAGE SPECIFIC 
      TYPE    STRING(64) 
      VALUE   "unknown" 
   }

   ATTRIBUTE serialnumber {
      NAME    "Serial Number"
      ID      4 
      DESCRIPTION "Serial Number"
      ACCESS  READ-ONLY 
      STORAGE SPECIFIC 
      TYPE    STRING(64) 
      VALUE   "unknown" 
   }

   ATTRIBUTE installation {
      NAME    "Installation"
      ID      5 
      DESCRIPTION " get the date of the current file ..."
      ACCESS  READ-ONLY 
      STORAGE SPECIFIC 
      TYPE    DATE 
      VALUE   "[exec date +%Y%m%d%H%M%S.000000-300 ]"
   }

   ATTRIBUTE verify {
      NAME    "Verify"
      ID      6 
      DESCRIPTION " Verification level"
      ACCESS  READ-ONLY 
      STORAGE SPECIFIC
      TYPE    INTEGER
      VALUE 7
   }
}
    
GROUP digitalmanagementmodes {
    NAME "Digital Management Modes"
    ID 9999
    CLASS "Digital|DeferredManagementMode|001"
    DESCRIPTION \
"This group defines attributes common to all Digital SysMan components."

    ATTRIBUTE deferredcommit {
      NAME    "Deferred Commit"
      ID      1 
  DESCRIPTION  "Deferred Commit can be used by component instrumentation to defer
  FLUSH operations.  By setting Deferred commit mode, a user interface enables
  more efficient write operations to take place in component intrumentation.  It
  is then up to the user interface to set this attribute to the cleared state which
  will then signal to all groups within the component that all queued data should
  be flushed.  If this flag is not set, data will be flushed as normal with each
  write operations"
  
      ACCESS  READ-WRITE 
      STORAGE COMMON 
      TYPE    Integer
      ENUM literal {
      	VALUE {
      	    0 "off"
      	    1 "on"
      	}
      }
      VALUE   0
    }
    ATTRIBUTE cdfgroups {
      NAME    "CDF Capable Groups"
      ID      2 
      DESCRIPTION  "CDF groups are those which data may be exported to a CDF. "
      ACCESS  READ-WRITE 
      STORAGE COMMON 
      TYPE    STRING(255)
      VALUE   "ALL"
    }
}

    
}
	
#----------------------------------------------------------------
##
## This is a debug proc that will print the IdMap and NameMap
## arrays --> see GetLoc and GetName methods.
##
#----------------------------------------------------------------
Group instproc _DumpIDMAP { args } {

  $self instvar IdMap NameMap _donethis

  if {[info exists _donethis] == 0} {
    puts "--- _donethis (internal var) does not exist"
  } else {
    puts "--- value of _donethis (internal var) = $_donethis"
  }
  if {[info exists IdMap] != 0} {
    puts "--- values stored in IdMap:\n"
    parray IdMap
    puts "--- values stored in NameMap:\n"
    parray NameMap
  } else {
    puts "--- IdMap and NameMap do not exist:\n"
  }
  puts "--------------------- end of debug - $args"
}

#----------------------------------------------------------------
##
## This is a debug proc that calls the previous method to
## dump the IdMap and NameMap arrays
##
#----------------------------------------------------------------
Attribute instproc _DumpIDMAP { args } {

  set parent [$self parent]
  $parent _DumpIDMAP $args
}

proc SrcMifCommon {} {
  set sourced true
}


###
##    Internal Memory Table Management Methods
###

Class CITable -superclass OrdArray

#----------------------------------------------------------------
##
## The initializer must supply the name of the group thats causing
## a memory table to be built.
##
#----------------------------------------------------------------

CITable instproc init {parent keylist args} {
    $self instvar keys _parent

    $self set loaded 0
    set _parent $parent

    if {$keylist != {}} {
        set cluster_size 500
    } else {
    	set cluster_size 1
    }

    set keys $keylist
    eval $self next $cluster_size $keys
}

CITable instproc ClearTable {{flags {}}} {
    eval $self Clear $flags
    if {$flags == {}} {
	$self set loaded 0
    }
}

CITable instproc IsDirtyRow {row} {
   set key [$self makeKEY $row]
   set state [$self state $key]
    return $state
}

CITable instproc GetModMap {row} {
   $self instvar mod_bitmap
   set idx [$self makeKEY row]
   set bitmap {}
   catch { set bitmap $mod_bitmap($idx) }
   return $bitmap
}

CITable instproc MakeRowWithBits { rowname bit } {
    set bitrow {}
    upvar $rowname row
    for {set i 0} {$i <= [expr [llength $row] - 1]} {incr i} {
      lappend bitrow $bit
    }
    return $bitrow
}

CITable instproc AddRow { rowname {nextrowname {}}} {

    $self set loaded 1
    upvar $rowname row
    upvar $nextrowname nextrow
   if { ! [cequal $nextrow ""] } {
       	$self next $row $nextrow
   } else {
   	$self next $row
   }
}

CITable instproc ModRow {oldrow newrow} {
    return [$self SetRow $newrow $oldrow]
}

CITable instproc DelRow {row} {
    $self state [$self makeKEY $row] removed
    return 1
}

CITable instproc MakeKEY {row} {
  return [$self makeKEY $row]
}

CITable instproc DumpTable {} {
  $self instvar _parent  

  set rt "\n\n-- Group $_parent --\n"

  $self keys k
  foreach key $k {
    append rt "\nRow:[$self state $key] [$self GetRow $key]"
  }

  append rt "\n --------- end of values -------\n"

  return $rt

}
        
set junk {
CITable instproc GetOrderIndex {tableidx} {
  $self instvar order

  set orderndx [lsearch $order $tableidx]

  if {$orderndx != -1} {
    return $orderndx
  }
  return [llength $order]

}
}

CITable instproc GetDeletedRow {oindex} {

  $self instvar deltable delorder 
  set table_index [lindex $delorder $oindex]
  return $deltable($table_index)

}

CITable instproc TotalDeletedRows {} {
  $self keys keys removed
  return [llength $keys]
}

CITable instproc TotalRows {} {
  return [$self size]
}

CITable instproc IsLoaded {} {
   $self set loaded
}

CITable instproc IsEmpty {row} {

 if {[$self size] > 0} {
     return 1
 }
 return 0
}

###### END TMR table management routines #########
#---------------------------------------------------------------
#
#   Create an otcl class to manipulate/translate date & time
#    information to/from MIF date format
#
#---------------------------------------------------------------

Class MifDate


#---------------------------------------------------------------
#
#  The MifDate class provides methods to manipulate a date/time
#   specification stored in the instance of the object.
#	
#  method index:
#
#  getmif  - Return the time in standard 25 octect MIF format
#  setmif  - Set the time using a standard 25 octect MIF string
#  get     - Get the time in normalized format (Tue Jan 07 14:17:51 EST 1997)
#  set     - Set the time from normalized format (see tcl convertclock for 
#            options)
#  getdate - Return the stored date in the format "mon day year" (Jan 07 1997)
#  gettime - Return the stored time in the format "hh:mm:ss" (14:20:31)
#  getseconds - Get the internal stored time variable directly in seconds 
#               since GMT
#  setseconds - Set the internal stored time variable directly in seconds   
#               since GMT
#  getdatefmt - Get the internal stored time variable in a format to be used 
#               with setting the date via the "date(1)" command.
#
# TODO:  Verify that setting exotic (non-EST ;-) timezones works
#
#---------------------------------------------------------------

MifDate instproc init {} {
    $self instvar _time _gmt
    $self instvar _months

    set _months {Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec}
    set _time [getclock]

  # Calculate the current UTC offset and save it
    set zerotime [convertclock 0 GMT]
    set myzerotime [convertclock 0]
    
    set _gmt [expr ($zerotime - $myzerotime) / 60]
}

MifDate instproc getmif {} {
    $self instvar _time _gmt

    fmtclock $_time "%Y%m%d%H%M%S.000000$_gmt"
}

MifDate instproc setmif {mifdate} {
    $self instvar _time _gmt _months

    if { [clength $mifdate] != 25} {
        error "date string must be 25 chars long:  yyyymmddHHMMSS.uuuuuu[+-]ooo"
        return
    }
    
    set year [csubstr $mifdate 0 4]
    set month [csubstr $mifdate 4 2]

    #Added this line because there is an
    #error if the month is 08 or 09.
    set month [string trimleft $month {0}]

    incr month -1
    set month [lindex $_months $month]
    set day [csubstr $mifdate 6 2]
    set hour [csubstr $mifdate 8 2]
    set minute [csubstr $mifdate 10 2]
    set second [csubstr $mifdate 12 2]
    set gmtoff [csubstr $mifdate 21 4]

    set _time [convertclock "$day $month $year $hour:$minute:$second"]
}

MifDate instproc get {} {
    $self instvar _time
    fmtclock $_time
}

MifDate instproc set {timespec} {
    $self instvar _time
    set _time [convertclock $timespec]
}

MifDate instproc getdate {} {
    $self instvar _time
    fmtclock $_time "%h %d %Y" 
}

MifDate instproc gettime {} {
    $self instvar _time
    fmtclock $_time "%H:%M:%S"
}

MifDate instproc getseconds {} {
    $self instvar _time
    return $_time
}

MifDate instproc setseconds {seconds} {
    $self instvar _time
    set _time $seconds
}

MifDate instproc getdatefmt {} {
    $self instvar _time
    fmtclock $_time "%y%m%d%H%M.%S"
}
