#!/usr/share/sysman/bin/sysmansh
# 
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
# 
# @(#)$RCSfile: sm_postevent.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:31 $
# 

source $SysmanDir/utils/evm.tcl

proc sm_postevent { eventname args } {

	Event event1

	# TSM: 21 Oct 1998  Don't do this anymore cause it's based on invalid
	#   assumptions.  The caller has to specify the full event name.

	# Check eventname.  If first chars are dec.unix, then
	# the complete event name was given. If not, assume
	# event in the dec.unix.sysman namespace.
	#
	# if { [regexp {^dec.unix} $eventname ] == 0 } {
	#	event1 set %name dec.unix.sysman.$eventname
	# } else {
	#	event1 set %name $eventname
	#	}

	event1 set %name $eventname

	#
	# Assign any argument values which would be needed in the
	# event format string.
	#
	foreach arg $args {
		regexp {^([^=]*)=(.*)$} $arg _bogus varname varvalue
		catch "event1 setVar $varname STRING $varvalue"
		}

	#
	# Post the event and check the status
	#
	catch "event1 post"
	if { [ event1 status ] != "ok" } {
		catch "event1 destroy"
		return "ERROR - event $eventname, status: [ event1 status ]"
		}

	#
	# Destroy the event object and return
	#
	catch "event1 destroy"
	return {}
}
