# 
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
# 
# @(#)$RCSfile: sysmancli.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:36:31 $
# 


# Set default cloning flag.
#   Will be set to 1 if doing a clone operation.
#   Should be at global scope, but just in case.
global _g_cloning
set    _g_cloning  0


proc SubstituteMin {word min whole} {

  set l [clength $word]
  incr l -1

  while {$word != $min} {
    if { [set ind [lsearch -exact $whole "$word" ]] != -1 } {
      set whole [lreplace $whole $ind $ind "$min"]
      set word $min
    } else {
      incr l -1
      set word [string range $word 0 $l]
    }
  }
  return $whole
}

proc parseOpts {keyword min_keyword bool_arg_present} {

    global argv
    set flag "${keyword}flag"
    global $flag
    set $flag 0
    set arg {}

    ## replace the entire command line argument with the minimum pattern
    # puts "keyword: $keyword, min_keyword: $min_keyword, bool: $bool_arg_present"

    set argv [ SubstituteMin "-$keyword" "-$min_keyword" $argv ]
    set keyword $min_keyword

    # Check to see if we have the keyword?
    #
    if {[set ind [lsearch $argv "-$keyword"]] != -1} {

        # we have the keyword
        set $flag 1
        set idx $ind
   
        if {$bool_arg_present != 0} {

            incr ind
            set arg [lindex $argv $ind]

            if { $arg != {} } {

                if { [string range $arg 0 0] == "-" } {

                    # Some attribute names start with - (strange, but true).
	            # Test the second character to see if it too is a -
                    #
                    if { [string range $arg 1 1] != "-" } {

                        set arg {}

                    } else {
                        set arg  [string range $arg 1 end]
                        set argv [lreplace $argv $idx $ind]
		    }

                } else {
                  # Remove the keyword and the argument
                  # from the command line args.
                  #
                  set argv [lreplace $argv $idx $ind]
                }

            }
            
        } else {
            # The keyword does not have an argument, remove
            # keyword from the command line args.
            #
            set argv [lreplace $argv $idx $idx]
        }
    }

    return $arg
}

##
## Makes all the -options to lowercase for ease of parsing
##
proc LowerizeOptions {} {
  global argv
  
  set targv ""
  foreach arg $argv {
    # strip off the "dash" 
    if {[string index $arg 0] == "-"} {
      set opt "-[string tolower [string range $arg 1 end]]"
    } else {
      set opt $arg
    }
    lappend targv $opt
  }
  set argv [string trim $targv]
}

##
## Mother of all procs for CLI argument handling
##
proc MI_ArgHandler {} {

  global _g_cloning
  global argv
  global verboseflag
  global noverboseflag
  set verboseflag 0                    ;#default to no verbose option

  ## make the -options all lowercase for ease of parsing

  LowerizeOptions 

  ## search the arguments for -verbose, so that we can set the flag rightaway
  parseOpts "noverbose" "nov" 0

  set verboseflag [expr $noverboseflag == 1 ? 0 : 1]
  Option _Comp     "component"  "c" 1 0
  Option _Group    "group"      "gr" 1 0
  Option _Attr     "attribute"  "a" 1 0
  Option _Key1     "key1"       "key1" 1 1
  Option _Key2     "key2"       "key2" 1 1
  Option _Data     "data"       "data" 1 0
  Option _File     "file"       "fi" 1 0
  Option _CDFgroups "cdfgroups"   "cdfgroup" 1 0

  set comp  [ _Comp  getarg ]
  set group [ _Group getarg ]
  set attr  [ _Attr  getarg ]
  set key1  [ _Key1  getarg ]
  set key2  [ _Key2  getarg ]
  set data  [ _Data  getarg ]
  set filename  [ _File  getarg ]
  set cdfgroups  [ _CDFgroups  getarg ]

  global componentflag groupflag attributeflag key1flag key2flag dataflag filenameflag cdfgroupsflag

  if {$componentflag != 0} {
    if {$comp != {}} {
      set errstring ""
      if { [catch {MclInit $comp} errstring] } {
	puts "[SYSMAN_INIT_ERROR 2 \ "Component initialization error: $errstring" ]"
	}
      if { [info command /$comp] != "/$comp"} {
	set verboseflag 0
	puts "[SYSMAN_INVALID_COMPONENT 2 \ "Valid Components are: \n\t [GetComponents]" ]"
      }
    }
  }

  if {$groupflag != 0} {
    ErRequired "component" $comp
    if {$group != {}} {
      foreach igroup [split $group ,] {
      	if { [info command /$comp/$igroup] != "/$comp/$igroup"} {
	    set verboseflag 0
	    puts "[SYSMAN_INVALID_GROUP 2 \ "Invalid: ($igroup)\nValid Groups are: \n\t [GetGroups $comp]" ]"
            }
	}
    }
  }

  if {$attributeflag != 0} {
    ErRequired "component" $comp
    ErRequired "group" $group
    if {$attr != {}} {
      foreach iattr [split $attr ,] {
	set realattr [lindex [split $iattr =] 0]
      	if { [info command /$comp/$group/$realattr] != "/$comp/$group/$realattr"} {
		set verboseflag 0
		puts "[SYSMAN_INVALID_ATTRIBUTE 2 \
	      		"Invalid: ($realattr)\nValid Attributes are: \n\t [GetAttributes $comp $group]" ]"
		}
        }
    }
  }
  global key1flag
  global key2flag
  global listflag
  global setflag
  global deleteflag
  global addflag
  global cdfflag

  set listopt ""
  set setopt ""
  set addopt ""
  set deleteopt ""
  set cdfopt ""
  #Added this line to fix QAR 62205.
  set lstopt ""

  set listopt [parseOpts "list" "l" 1]
  if {$listflag == 0} {
    set setopt [parseOpts "set" "s" 1]
    if {$setflag == 0} {
       set deleteopt [parseOpts "delete" "del" 1]
       if {$deleteflag == 0} {
           set addopt [parseOpts "add" "a" 1]
           if {$addflag == 0} {
              set cdfopt [parseOpts "cdf" "cdf" 1]
	       if { ! [cequal $cdfopt "" ]} {
		   set _g_cloning 1
	       }
              if {$cdfflag == 0} {
                 puts "[SYSMAN_INVALID_COMMAND]"
                 }
              }
           }
       }
    }

  regsub -all -- "\t" $argv " " argv
  regsub -all -- " +" $argv " " argv
  regsub -all -- "{}" $argv " " argv
  set argv [string trim $argv]
  if {$argv != {}} {
    puts "[SYSMAN_UNKNOWN_REQUEST 1 \"$argv\"]"
  }

  if { ! [cequal $listopt "" ] } {
  	set lstopt $listopt
  	foreach lopt { {components c} {mif mif} {mib mib} {groups g} {attributes a} \
	    {classes cl} {keys k} {types t} {accesses acc} \ 
	    {description des} {values v} {defaults def} {version ver}} {
  	    	set lstopt [SubstituteMin [lindex $lopt 0] [lindex $lopt 1] $lstopt ]
  	    }
  } elseif { ! [cequal $setopt "" ] } {
  	set lstopt $setopt
  	foreach sopt { {values v}} {
  		set lstopt [SubstituteMin [lindex $sopt 0] [lindex $sopt 1] $lstopt ]
  	    }
  } elseif { ! [cequal $addopt "" ] } {
  	set lstopt $addopt
  	foreach sopt { {row r}} {
  		set lstopt [SubstituteMin [lindex $sopt 0] [lindex $sopt 1] $lstopt ]
  	    }
  } elseif { ! [cequal $deleteopt "" ] } {
  	set lstopt $deleteopt
  	foreach sopt { {row r}} {
  		set lstopt [SubstituteMin [lindex $sopt 0] [lindex $sopt 1] $lstopt ]
  	    }
  } elseif { ! [cequal $cdfopt "" ] } {
  	set lstopt $cdfopt
  	foreach copt { {validate val} {apply app} {save sa}} {
  		set lstopt [SubstituteMin [lindex $copt 0] [lindex $copt 1] $lstopt ]
  	    }
        }

  global SYSMAN_NOT_PRESENT
  switch -exact  [lindex $lstopt 0] {
    {component}    -
    {c}            { 
		     if { [catch {GetComponents} get_comp_result] != 0 } {
                 
                           puts "\n\tERROR: $get_comp_result\n" 
                           exit 1

                     } else {
		           puts "$get_comp_result" 
                     }
                   }
    {mib}          {
		     ErRequired "component" $comp
		     ErOptional "group" group
		     ErOptional "attribute" attr
		     ErOptional "file" filename
                     if {$attr != $SYSMAN_NOT_PRESENT} {
                       # The assignment of an attribute value for a mib is no supported. 
                       puts "[SYSMAN_INVALID_COMMAND 2 "You cannot use an attribute name with this option."]"
		     } else {
		       set attr ""
		     }
                     if {$group != $SYSMAN_NOT_PRESENT} {
                       #The assignment of a group value for a mib is no supported. 
                       puts "[SYSMAN_INVALID_COMMAND 2 "You cannot use a group name with this option."]"
		     } else {
		       set group ""
		     }
                     if { ! [cequal $filename $SYSMAN_NOT_PRESENT] } {

  			set filename [file rootname $filename].mib

  			if {[catch {set fd [open $filename w]}]} {
				puts "ERROR: Cannot open $filename for writing"
				exit 1
			} else {
    
                             puts "\nSaving mib into the file $filename\n"
                        }

                        if { [catch {/${comp}${group}${attr} mib} mib_result] != 0 } {

                             puts $fd "\n\tERROR: $mib_result\n"
                             exit 1

                        } else { 
                
                             puts $fd $mib_result  
                        }
 
		     } else {

		        if { [catch {/${comp}${group}${attr} mib} mib_result] != 0 } {
                 
                             puts "\n\tERROR: $mib_result\n" 
                             exit 1

                        } else {
 
                             puts $mib_result  
                        }

                     }
		   }
    {mif}          {
		     ErRequired "component" $comp
		     ErOptional "group" group
		     ErOptional "attribute" attr
		     ErOptional "file" filename
                     if {$attr != $SYSMAN_NOT_PRESENT} {
                       #The assignment of an attribute value for a mif is no supported. 
                       puts "[SYSMAN_INVALID_COMMAND 2 "You cannot use an attribute name with this option."]"
		     } else {
		       set attr ""
		     }
                     if {$group != $SYSMAN_NOT_PRESENT} {
                       #The assignment of a group value for a mif is no supported. 
                       puts "[SYSMAN_INVALID_COMMAND 2 "You cannot use a group name with this option."]"
		     } else {
		       set group ""
		     }
                     if { ! [cequal $filename $SYSMAN_NOT_PRESENT] } {
  			set filename [file rootname $filename].mif
  			if {[catch {set fd [open $filename w]}]} {
				puts "ERROR: Cannot open $filename for writing"
				exit 1
			} else {
                 
                             puts "\nSaving mif into the file $filename\n"
                        }

                        if { [catch {/${comp}${group}${attr} mif} mif_result] != 0 } {

                             puts $fd "\n\tERROR: $mif_result\n"
                             exit 1

                        } else { 
                
                             puts $fd $mif_result  
                        }

		     } else {

		        if { [catch {/${comp}${group}${attr} mif} mif_result] != 0 } {
                 
                             puts "\n\tERROR: $mif_result\n" 
                             exit 1

                        } else {
 
                             puts $mif_result  
                        }
		     }
		   }
    {group}        -
    {g}            { 
		     ErRequired "component" $comp
		     if { [catch {GetGroups $comp} get_group_result] != 0 } {
                 
                           puts "\n\tERROR: $get_group_result\n" 
                           exit 1

                     } else {
		           puts "$get_group_result" 
                     }
		   }
    {version}     -
    {ver}	   { 
		     ErRequired "component" $comp
		     if { [catch {GetVersion $comp} get_version_result] != 0 } {
                 
                           puts "\n\tERROR: $get_version_result\n" 
                           exit 1

                     } else {
		           puts "$get_version_result" 
                     }
		   }
    {attribute}    -
    {a}            { 
		     ErRequired "component" $comp
		     ErOptional "group" group
		     if { [catch {GetAttributes $comp $group} get_attr_result] != 0 } {
                 
                           puts "\n\tERROR: $get_attr_result\n" 
                           exit 1

                     } else {
		           puts "$get_attr_result" 
                     }
		   }
    {cl}           -
    {class}        { 
		     ErRequired "component" $comp
		     ErOptional "group" group
		     if { [catch {GetClass $comp $group} get_class_result] != 0 } {
                 
                           puts "\n\tERROR: $get_class_result\n" 
                           exit 1

                     } else {
		           puts "$get_class_result" 
                     }
		   }
    {key}          -
    {k}            { 
		     ErRequired "component" $comp
		     ErOptional "group" group
		     if { [catch {GetKey   $comp $group} get_key_result] != 0 } {
                 
                           puts "\n\tERROR: $get_key_result\n" 
                           exit 1

                     } else {
		           puts "$get_key_result" 
                     }
		   }
    {type}         -
    {t}            { 
		     ErRequired "component" $comp
		     ErOptional "group" group
		     ErOptional "attribute" attr
		     if { [catch {GetType   $comp $group $attr} get_type_result] != 0 } {
                 
                           puts "\n\tERROR: $get_type_result\n" 
                           exit 1

                     } else {
		           puts "$get_type_result" 
                     }
		   }
    {acc}          -
    {access}       {
		     ErRequired "component" $comp
		     ErOptional "group" group
		     ErOptional "attribute" attr
		     if { [catch {GetAccess $comp $group $attr} get_access_result] != 0 } {
                 
                           puts "\n\tERROR: $get_access_result\n" 
                           exit 1

                     } else {
		           puts "$get_access_result" 
                     }
		   }
    {description}  -
    {des}            {
		     ErRequired "component" $comp
		     ErOptional "group" group
		     ErOptional "attribute" attr
		     if { [catch {GetDescription $comp $group $attr} get_descr_result] != 0 } {
                 
                           puts "\n\tERROR: $get_descr_result\n" 
                           exit 1

                     } else {
		           puts "$get_descr_result" 
                     }
		   }
    {defaults}  -
    {def}            {
		     ErRequired "component" $comp
		     ErRequired "group" $group
		     if { [catch {GetDefaults $comp $group} get_default_result] != 0 } {
                 
                           puts "\n\tERROR: $get_default_result\n" 
                           exit 1

                     } else {
		           puts "$get_default_result" 
                     }
		   }
    {save}  -
    {sa}            {
		     ErRequired "component" $comp
		     ErRequired "file" $filename
		     ErOptional "cdfgroups" cdfgroups
		     if { [catch {SaveCDF $comp $filename $cdfgroups} get_savecdf_result] != 0 } {
                 
                           puts "\n\tERROR: $get_savecdf_result\n" 
                           exit 1

                     } else {
		           puts "$get_savecdf_result" 
                     }
		   }
    {validate}  -
    {val}            {
		     ErRequired "file" $filename
		     if { [catch {ReadCDF $filename validate} result] != 0 } {
                 
                           puts "\n\tERROR: $result\n" 
                           exit 1

                     } else {

                           if { ![cequal $result ""] } {
                                puts "\nCDF ERROR: $result"
                                exit 1
                           }
                     }
		   }
    {apply}  -
    {app}            {
		     ErRequired "file" $filename
                     if { [catch {ReadCDF $filename apply} result] != 0 } {

                           puts "\n\tERROR: $result\n"
                           exit 1

                     } else {

                           if { ![cequal $result ""] } {
                                puts "\nCDF ERROR: $result"
                                exit 1
                           }
                     }
		   }
    {row}        -
    {r}            {
		     ErRequired "component" $comp
		     ErRequired "group" $group
		     if { $deleteflag == 1 } {
		     	ErOptional "key2" key2
			ErOptional "key1" key1

                        if { [catch {DeleteRow $comp $group $key1 $key2} res] != 0 } {

                             puts "\n\tERROR: $res\n"
                             exit 1

                        } else {

			   if { [string length $res] > 0 } {
				puts $res
                           }
                        }

		     } else {
			ErOptional "data" data

                        if { [catch {AddRow $comp $group $data} res] != 0 } {

                             puts "\n\tERROR: $res\n"
                             exit 1

                        } else {

			     if { [string length $res] > 0 } {
				puts $res
                             }
                        }
                     }
		   }
    {values}        -
    {v}            {
		     ErRequired "component" $comp
		     ErRequired "group" $group
		     ErOptional "attribute" attr
		     ErOptional "key1" key1
		     ErOptional "key2" key2

		     if { $listflag == 1 } {

		        if { [catch {GetValue $comp $group $attr $key1 $key2} get_val_result] != 0 } {
                 
                             puts "\n\tERROR: $get_val_result\n" 
                             exit 1

                        } else {
			     puts "$get_val_result" 
                        }

		     } else {

                        if { [catch {SetValue $comp $group $attr key1 key2} set_val_result] != 0 } {

                             puts "\n\tERROR: $set_val_result\n"
                             exit 1
                        } 

			if { $set_val_result == "" } {

                             if { [catch {GetValue $comp $group $attr $key1 $key2} get_val_result] != 0 } {

                                   puts "\n\tERROR: $get_val_result\n"
                                   exit 1
                             } 

			} else {

			     puts "\n\tERROR: $set_val_result\n"
                             exit 1
                        }
         
                        puts "$get_val_result"
                     }
		   }
    default        { 
		     puts "[SYSMAN_INVALID_COMMAND 1 $listopt ]" 
		   }
  }

}

proc ErOptional {type Var} {
  
  set flag "${type}flag"
  global $flag SYSMAN_NOT_PRESENT
  upvar $Var var

  if { [set $flag] == 0} {
    set var $SYSMAN_NOT_PRESENT
    }
}

proc ErRequired {type val} {
  
  set flag "${type}flag"
  global $flag

  if { [set $flag] == 0} {
    puts "[SYSMAN_MUST_SUPPLY_[string toupper $type]]"
  }
  if {$val == {}} {
    puts "[SYSMAN_MUST_SUPPLY_[string toupper $type]]"
  }
}

proc usage {} {

  puts stderr "sysman -cli "
  puts stderr "  -focus <member_hostname>"
  puts stderr "  -help"
  puts stderr "  -noverbose"
  puts stderr "    -list components"
  puts stderr "    -list version     -comp <comp>"
  puts stderr "    -list groups      -comp <comp>"
  #Commented the line to avoid presenting to the user the mif option.
  #This will be commented until future notice, because there is no support for DMI.
  #This option can be invoke because only the usage line is 
  #commented not the code that implements the functionality.
  #puts stderr "    -list mif         -comp <comp> \[-file <filename>\]"
  puts stderr "    -list mib         -comp <comp> \[-file <filename>\]"
  puts stderr "    -list defaults    -comp <comp> -group <grp>"
  puts stderr "    -list attributes  -comp <comp> \[-group <grp>\]"
  puts stderr "    -list classes     -comp <comp> \[-group <grp>\]"
  puts stderr "    -list keys        -comp <comp> \[-group <grp>\]"
  puts stderr "    -list types       -comp <comp> \[-group <grp> \[-attr <attr1>\[,<attr2>,...<attrN>\]\]\]"
  puts stderr "    -list access      -comp <comp> \[-group <grp> \[-attr <attr1>\[,<attr2>,...<attrN>\]\]\]"
  puts stderr "    -list description -comp <comp> \[-group <grp> \[-attr <attr1>\[,<attr2>,...<attrN>\]\]\]"
  puts stderr "    -list values      -comp <comp> -group <grp> \[-attr <attr1>\[,<attr2>,...attrN\]\] \[-key1 <k1> \[-key2 <k2>\]\]"
  puts stderr "    -set values       -comp <comp> -group <grp> \[-attr <attr1>\[=<newval>\],<attr2>=\[<newval>\],...<attrN>=\[<newval>\]\] \[-key1 <k1> \[-key2 <k2>\]\]"
  puts stderr "    -delete row       -comp <comp> -group <grp> \[-key1 <k1> \[-key2 <k2>\]\]"
  puts stderr "    -add row          -comp <comp> -group <grp> \[-data \"{attr1} {attr2} ... {attrN}\"\]"
  puts stderr "    -cdf save         -comp <comp> -file <filename> \[-cdfgroups \{ALL|<groups>\}\]"
  puts stderr "    -cdf validate     -file <filename>"
  puts stderr "    -cdf apply        -file <filename>"
}

proc addReturn {Str val} {
  upvar $Str str
  set str "$str\n$val"
}

proc Spacer {cols str} {
  set space "                                                  "
  return [string range "${str}${space}" 0 $cols]
}

#
# GetComponents - Return the list of components
#
proc GetComponents {} {

  set comps [miGetComponents resultvar]

  global verboseflag
  if { $verboseflag != 0 } {
    set rt "Component(s):"
    foreach comp $comps {
       addReturn rt "  $comp "
    }
    set comps $rt
  }
  return $comps
}

#
# GetVersion - Return the component version (e.g. the componentid group)
#
proc GetVersion {comp} {
  global SYSMAN_NOT_PRESENT
  return [GetValue $comp componentid $SYSMAN_NOT_PRESENT $SYSMAN_NOT_PRESENT $SYSMAN_NOT_PRESENT]
}

#
# GetGroups - Return the groups
#
proc GetGroups {comp} {

  set groups {}
  foreach grp [/$comp children] {

       #Code to handle the scope feature. If the group
       #is private then is not included in the list of
       #available groups returned by the function.  
       if { [string tolower [$grp SCOPE]] != "private" } {
            lappend groups [file tail $grp]
       }
  }

  global verboseflag
  if { $verboseflag != 0 } {

    set rt "Component: $comp"
    addReturn rt "  Group(s):"
    foreach grp $groups {
       addReturn rt "    [file tail $grp]"
    }
    set groups $rt
  }

  return $groups
}

proc SetAttributes {group attribute} {
  global SYSMAN_NOT_PRESENT
  set attrs {}

  foreach attr [split $attribute ,] {
    lappend attrs "$group/$attr"
  }
  if {$attribute == $SYSMAN_NOT_PRESENT} {
    set attrs "[$group children]"
  }
  return $attrs

}

proc SetGroups {comp group} {
  global SYSMAN_NOT_PRESENT

  set grps "/$comp/$group"

  if {$group == $SYSMAN_NOT_PRESENT} {
    set grps "[/$comp children]"
  }
  return $grps

}

#
# GetAttributes - Get list of attributes for a group
#
proc GetAttributes {comp group} {

  global verboseflag
  if { $verboseflag != 0 } {
    set rt "Component: $comp"
    foreach grp [SetGroups $comp $group] {
       #Code to handle the scope feature. If the group 
       #is private then is not included in the list of
       #available groups returned by the function.  
       if { [string tolower [$grp SCOPE]] != "private" } {
            addReturn rt "  Group: [file tail $grp]"
            addReturn rt "    Attribute(s):"
            foreach attr [$grp children] {
                 #Code to handle the scope feature. If the attribute 
                 #is private then is not included in the list of
                 #available attributes returned by the function.  
                 if { [string tolower [$attr SCOPE]] != "private" } {
                      addReturn rt "      [file tail $attr] "
                 }
            }
       }
    }
    return $rt
  }
  set attributes {}
  foreach grp [SetGroups $comp $group] {
       foreach atr [$grp children] {
           #Code to handle the scope feature (same description as above). 
           if { [string tolower [$grp SCOPE]] != "private" } {
               if { [string tolower [$atr SCOPE]] != "private" } {
                 lappend attributes [file tail $atr]
               }
           }
       }
  }

  return $attributes
}

#
# GetDescription - Get description of attributes, groups or components
#
proc GetDescription {comp group attr} {

  global SYSMAN_NOT_PRESENT
  global verboseflag

  set rt {}
  #The next line was added due to the changes for the scope feature.
  #This initializes the variable as null to avoid errors in the code.
  set rtV {}

  if {$attr == $SYSMAN_NOT_PRESENT} {
       if {$group == $SYSMAN_NOT_PRESENT} {
            catch {set rt [/$comp DESCRIPTION]}
            catch {set rtV "Component: $comp\nDescription: [/$comp DESCRIPTION]"}
       } else {
         #Code to handle the scope feature. If the group is private 
         #it doesn't show the description.
         if { [string tolower [/$comp/$group SCOPE]] != "private" } {
            catch {set rt [/$comp/$group DESCRIPTION]}
            catch {set rtV "Component: $comp\n  Group: $group \
		      \n  Description: [/$comp/$group DESCRIPTION]"}
         }
       }
  } else {
      #Code to handle the scope feature. If the attribute is private 
      #it doesn't show the description.
      if { [llength [split $attr ,]] > 1 } {
           set rtV "Component: $comp\n  Group: $group"
           foreach atr [split $attr ,] {
                if { [string tolower [/$comp/$group/$atr SCOPE]] != "private" } {
                     catch {lappend rt [/$comp/$group/$atr DESCRIPTION]}
                     catch {append rtV "\n    Attribute: $atr \
                           \n       Description: [/$comp/$group/$atr DESCRIPTION]"}
                }
           }
      } else {

           if { [string tolower [/$comp/$group/$attr SCOPE]] != "private" } {
                catch {set rt [/$comp/$group/$attr DESCRIPTION]}
                catch {set rtV "Component: $comp\n  Group: $group \
		      \n    Attribute: $attr \
		      \n    Description: [/$comp/$group/$attr DESCRIPTION]"}
           }
      }
  }

  if { $verboseflag != 0 } {
    return $rtV
  }
  return $rt
}

proc GetAccess {comp group attr} {

  global verboseflag
  if { $verboseflag == 0 } {
    set accesses {}
    foreach grp [SetGroups $comp $group] {
        #Code to handle the scope feature. If the group is private
        #it doesn't show the access type for it. 
        if { [string tolower [$grp SCOPE]] != "private" } {
             foreach atr [SetAttributes $grp $attr] {
                  #Code to handle the scope feature. If the attribute is 
                  #private it doesn't show the access type for it.
                  if { [string tolower [$atr SCOPE]] != "private" } {
                       if { ! [catch {set a [$atr ACCESS]} ] } {
                         lappend accesses $a
                       } else {
                         lappend accesses ""
                       }
                  }
             }
        }
    }
    return $accesses
  }
  set rt "Component: $comp"
  foreach grp [SetGroups $comp $group] {
       #Code to handle the scope feature. If the group is private
       #it doesn't show the access type for it.
       if { [string tolower [$grp SCOPE]] != "private" } {
            addReturn rt "  Group: [file tail $grp]"
            foreach atr [SetAttributes $grp $attr] {
             #Code to handle the scope feature. If the attribute is 
             #private it doesn't show the access type for it.
             if { [string tolower [$atr SCOPE]] != "private" } {
                  if { [catch {set a [$atr ACCESS]} ] } {
                        lappend a ""
                  }
                  addReturn rt [format "    Attribute: %s Access: %s" \
                   [Spacer 29 [file tail $atr]] \
                   $a]
             }
            }
       }
  }
  return $rt
}

#
# CheckKeys - Check validity of keys.  If not specified on
# command line, prompt for missing keys 
#
proc CheckKeys {comp group numkeys k1 k2} {
    upvar $k1 key1
    upvar $k2 key2
    global verboseflag

    set oldflag $verboseflag
    set verboseflag 0
    set keylist [split [GetKey $comp $group] ,]
    set verboseflag $oldflag

    global SYSMAN_NOT_PRESENT
    #
    # First check key1.  If not defined, prompt for it
    #
    if { [cequal $key1 $SYSMAN_NOT_PRESENT] } {
        
        #
        # Check if the number of keys is one and key2 is
        # not set to any value. 
        #
        if { $numkeys == 1 && $key2 != $SYSMAN_NOT_PRESENT } {
             puts "The group $group does not have a key2 field"
             set key2 $SYSMAN_NOT_PRESENT
        }
	set prompt "Please enter key 1 \[[lindex $keylist 0]\]: "
	puts -nonewline $prompt
	flush stdout
	set key1 [gets stdin]
	} 
    #
    # Now check key2.  It should be defined if numkeys == 2.
    # If not defined, prompt for it
    #
    if { $numkeys == 2 } {
    	if { [cequal $key2 $SYSMAN_NOT_PRESENT] } {
		set prompt "Please enter key 2 \[[lindex $keylist 1]\]: "
		puts -nonewline $prompt
		flush stdout
		set key2 [gets stdin]
    		}
    	} 

    if { $numkeys == 1 } {
        if { $key2 != "$SYSMAN_NOT_PRESENT" } {

           if { $key2 == {} } {
                  set key2 ""
           } else {

	     puts "[SYSMAN_INVALID_COMMAND 2 "The group only has key1. User supplied a key2 ('$key2'), this is not valid." ]"
           }

        } else {
	     set key2 ""
        }
    }
    return [/$comp/$group MIMakeKey [list $key1 $key2]]
}

#
# GetDefaults - Get default values for attributes
#
proc GetDefaults {comp group} {

  global SYSMAN_NOT_PRESENT
  set vals {}
  miInit $comp
  set rt "Component: $comp"
  #Code added to handle scope. If the group is private 
  #the information header for the group is not display.
  if { [string tolower [/$comp/$group SCOPE]] != "private" } {
       addReturn rt "  Group: $group"
  }
  set newresult [miGetDefaults $comp $group vals]

  #Added this if to catch the newresult in case of error.
  if { $newresult != {} } {
      #In this case the function is exiting instead of 
      #returning the error string because in some cases
      #when this function is invoked the returning string
      #is being parsed to be used for other purposes. 
      #I don't want to send that error string back because
      #it will produce more errors. 
      puts "Error: $newresult"
      exit 1
  }

  set taber "      "
  global verboseflag
  if {$verboseflag != 0} {
	set i 0
        # set vals [lindex $vals 0]
        foreach ch [/$comp/$group children] {
          #Code added to handle scope. If the group is private
          #the attributes defaults for that group are not return 
          #by the function.
          if { [string tolower [/$comp/$group SCOPE]] != "private" } {
           #Code added to handle scope. If the attribute is private
           #the attribute default value is not return by the function.
           if { [string tolower [$ch SCOPE]] != "private" } {
	    if {[$ch TYPE] == "DATE"} {
	        MifDate dt
	        dt setmif [lindex $vals $i]
	        set vals [lreplace $vals $i $i [dt get]]
	    }
            addReturn rt [format "%sAttribute: %s Value: %s" \
	       $taber [Spacer 29 [file tail $ch]] [lindex $vals $i]]
           }
          }
	   incr i
	}
      set vals $rt
  } else {
    #added this variable as a couter (related to scope code).
    set i 0
    set rt $SYSMAN_NOT_PRESENT
    foreach ch [/$comp/$group children] {
      #Code added to handle scope. Same description as above.
      if { [string tolower [/$comp/$group SCOPE]] != "private" } {
        if { [string tolower [$ch SCOPE]] != "private" } {
        set ln [lindex $vals $i]
	     if { [cequal $rt $SYSMAN_NOT_PRESENT] } {
                  set rt "$ln"
	     } else {
                  append rt "\n$ln"
       	     }
        }
        #added the next two lines to handle scope.
        incr i
      } else { set rt {} }
    }
    set vals $rt
  }
  return $vals
}

#
# GetValue - Get current value for attributes
#
proc GetValue {comp group attr key1 key2} {

  set vals {}
  miInit $comp
  set rt "Component: $comp"
  #Code added to handle scope. If the group is private the 
  #header output of the group is suppressed.
  if { [string tolower [/$comp/$group SCOPE]] != "private" } {
       addReturn rt "  Group: $group"
  }
  global SYSMAN_NOT_PRESENT
  # puts "GetValue, comp: $comp, group: $group, attr: $attr, key1: $key1, key2: $key2"

  set numkeys [llength [split [GetKey $comp $group silent] ,]]
  if {$attr == $SYSMAN_NOT_PRESENT} {
    if {$key1 == $SYSMAN_NOT_PRESENT} {

      #
      #If the number of keys for the group is one then key2 has
      #to be SYSMAN_NOT_PRESENT. Else, if the number of keys is
      #two, but only key2 is defined we have an error; key1
      #should be supplied also.
      #
      if { $numkeys == 1 && $key2 != $SYSMAN_NOT_PRESENT} {
	   puts "[SYSMAN_INVALID_COMMAND 2 "The group only has a key1 field.  User supplied a key2 ('$key2'), this is not valid." ]"
      } elseif {$numkeys == 2 && $key2 != $SYSMAN_NOT_PRESENT} {
           puts "[SYSMAN_MUST_SUPPLY_KEY1 2 "User supplied key2, but did not supply key1" ]"
      }

      set taber "    "
      set newresult [ miReadRow $comp $group row 0 ]

      #Added this if to catch the newresult in case of error.
      if { $newresult != {} } {
          return "Error: $newresult"
      }

      # Check to see if this is a group or table
      if { [/$comp/$group set keycount] != 0} {
      	  while { $row != {}} {
                
                #The next line and the for loop were added to handle the scope
                #feature. It checks the scope of the group if is private it is
                #suppressed from the output. If the group is public then every
                #attribute in the group is checked. If the attribute is private
                #it is removed from the row.   
                set i 0
                foreach ch [/$comp/$group children] {
                   if { [string tolower [/$comp/$group SCOPE]] == "private" } {
                      set vals {}
                      set row {}
                   } else { 
                      if { [string tolower [$ch SCOPE]] == "private" } {
                           set row [lreplace $row $i $i] 
                           incr i -1
                      }
                   }
                   incr i
                }
                
	        lappend vals $row

        	set newresult [miReadRow $comp $group row]

                #Added this if to catch the newresult in case of error.
                if { $newresult != {} } {
                    return "Error: $newresult"
                }

          }
       
      } else {
      		lappend vals $row
      }
    }  else {
      set taber "      "
      set rowkey [CheckKeys $comp $group $numkeys key1 key2]
      set newresult [miReadRowByKey $comp $group row $rowkey]

      #Added this if to catch the newresult in case of error.
      if { $newresult != {} } {
          return "Error: $newresult"
      }

      if { $row == "" } {
  	    if { $numkeys == 1 } {
		puts "[SYSMAN_NO_DATA 2 "No row exists with the specified key: '$key1'" ]"
	    } else {
		puts "[SYSMAN_NO_DATA 2 "No row exists with the specified keys: '$key1' and '$key2'" ]"
		}
            }
      if { $numkeys == 1 } {
            	addReturn rt "    Key: '$key1'"
	    } else {
            	addReturn rt "    Keys: '$key1' & '$key2'"
		}
      lappend vals $row
    }
  } else {
      	set taber "    "
    	if {$key1 == $SYSMAN_NOT_PRESENT} {
      		set newresult [ miReadRow $comp $group row 0 ]

                #Added this if to catch the newresult in case of error.
                if { $newresult != {} } {
                    return "Error: $newresult"
                }

      		# Check to see if this is a group or table
      		if { [/$comp/$group set keycount] != 0} {
      	  		while { $row != {}} {
				set minilist {} 
    				foreach iattr [split $attr ,] {
					set realattr [lindex [split $iattr =] 0]
    					set iloc [/$comp/$group GetLoc [/$comp/$group/$realattr ID]]
					lappend minilist [lindex $row $iloc]
					}
				lappend vals $minilist
        			set newresult [miReadRow $comp $group row]

                                #Added this if to catch the newresult in case of error.
                                if { $newresult != {} } {
                                    return "Error: $newresult"
                                }

			}
      	  	} else {
			set minilist {}
    			foreach iattr [split $attr ,] {
				set realattr [lindex [split $iattr =] 0]
    				set iloc [/$comp/$group GetLoc [/$comp/$group/$realattr ID]]
				lappend minilist [lindex $row $iloc]
				}
			lappend vals $minilist
			}
    	} else {
      		set rowkey [CheckKeys $comp $group $numkeys key1 key2]
      		set taber "      "
      		set newresult [miReadRowByKey $comp $group row $rowkey]

                #Added this if to catch the newresult in case of error.
                if { $newresult != {} } {
                    return "Error: $newresult"
                }

      		if { $row == "" } {
      			if { $numkeys == 1 } {
				puts "[SYSMAN_NO_DATA 2 "No row exists with the specified key: '$key1'" ]"
	    		} else {
				puts "[SYSMAN_NO_DATA 2 "No row exists with the specified keys: '$key1' and '$key2'" ]"
				}
            		}
      		if { $numkeys == 1 } {
            		addReturn rt "    Key: '$key1'"
	    	} else {
            		addReturn rt "    Keys: '$key1' & '$key2'"
			}
		set minilist {}
    		foreach iattr [split $attr ,] {
			set realattr [lindex [split $iattr =] 0]
    			set iloc [/$comp/$group GetLoc [/$comp/$group/$realattr ID]]
			lappend minilist [lindex $row $iloc]
			}
      		lappend vals $minilist
    		}
  	}
  global verboseflag
  if {$verboseflag != 0} {
    if {[llength $vals] > 1} {
	foreach ln $vals {
	  addReturn rt "${taber}$ln"
	}
      set vals $rt
    } else {
      set i 0
      if {$attr != $SYSMAN_NOT_PRESENT} {
        foreach ln $vals {
	  set lnind 0
    	  foreach iattr [split $attr ,] {
	    set realattr [lindex [split $iattr =] 0]
	    if {[/$comp/$group/$realattr TYPE] == "DATE"} {
	      MifDate dt
	      dt setmif [lindex $ln $lnind]
	      set ln [lreplace $ln $lnind $lnind [dt get]]
	    }
	    set enum [/$comp/$group/$realattr children]
	    if {$enum != {} && ! [cequal [translit a-z A-Z [/$comp/$group/$realattr TYPE]] "ENUM"] } {
		set val [/$comp/$group/$realattr enumgetval [lindex $ln $lnind]]
                addReturn rt "${taber}Attribute: [Spacer 29 $realattr] Value: [lindex $ln $lnind] ($val)"
	    } else {
                addReturn rt "${taber}Attribute: [Spacer 29 $realattr] Value: [lindex $ln $lnind]"
		}
	    incr lnind 
	  }
        }

      } else {
        set vals [lindex $vals 0]
        foreach ch [/$comp/$group children] {
          #Code added to handle scope. If the group is private the values 
          #are not added to the list to be return by the function.  
          if { [string tolower [/$comp/$group SCOPE]] != "private" } {
               #Code added to handle scope. If the attribute is private the values 
               #are not added to the list to be return by the function.  
               if { [string tolower [$ch SCOPE]] != "private" } {

	            if {[$ch TYPE] == "DATE"} {
	            MifDate dt
	            dt setmif [lindex $vals $i]
	            set vals [lreplace $vals $i $i [dt get]]
	            }
	            set enum [$ch children]

	            if {$enum != {} && ! [cequal [translit a-z A-Z [$ch TYPE]] "ENUM"] } {
		         set val [$ch enumgetval [lindex $vals $i]]
          	         addReturn rt [format "%sAttribute: %s Value: %s ($val)" \
			      $taber \
                              [Spacer 29 [file tail $ch]] \
			      [lindex $vals $i]]
	            } else {
          	         addReturn rt [format "%sAttribute: %s Value: %s" \
			      $taber \
                              [Spacer 29 [file tail $ch]] \
			      [lindex $vals $i]]
	            }
               }
	       incr i
          }
	}
      }
      set vals $rt
    }
  } else {
    #variable added to avoid errors (change related to scope).
    set i 0
    set rt ""

    if {$attr != $SYSMAN_NOT_PRESENT} {
      
        set mapindex 1

        #
        # Check which attribute is public and which is private: Creates
        # an array with the position of the attribute then save a zero (0)
        # if private and one (1) if public.
        #
        foreach attemp [split $attr ,] {

          set att [lindex [split $attemp =] 0]

          if { [string tolower [/$comp/$group/$att SCOPE]] != "private" } {
             
              set attrmap($mapindex) 1
         
          } else {
              
              set attrmap($mapindex) 0
          }

          incr mapindex
         
        }

        #
        # If the group is really a group and not a table
        # break the list. Set the index to 1 and the
        # length to the number of elements in vals.
        #
        if { [/$comp/$group set keycount] == 0} {
              set vals [join $vals]
        }

        set mapindex 1
        
        foreach val $vals {

              set ln [lindex $vals $i]
                  
              if { [/$comp/$group set keycount] != 0} {
                   set mapindex 1
              } 
              set maplength [llength $ln]


              # In case of strange bugs while executing a sysmancli
              # requesting specific attributes this if can be remove
              # and only leave the else section. 
              if { [/$comp/$group set keycount] == 0} {
      
                   if { $attrmap($mapindex) == 0 } {
                        incr mapindex
                        incr i
                        continue
                   }

                   incr mapindex

              } else {

                  #
                  # In case of a table the while loop will check each
                  # attribute to see if is marked inside the array as
                  # private (0). If this is the case it will be removed
                  # from the line.
                  #
                   while { $mapindex <= $maplength } {

                        if { $attrmap($mapindex) == 0 } {
                             set ln [lreplace $ln [expr $mapindex - 1] [expr $mapindex - 1]]
                        }
     
                        incr mapindex
                   }
           
              }              
              
              if { [cequal $rt "" ] } {
                   set rt $ln
              } else {
                   append rt "\n$ln"
              }

              incr i
        } 

        set vals $rt

    } else {

      if { [/$comp/$group set keycount] == 0} {
         foreach ch [/$comp/$group children] {
              #Code added to handle scope. If the group is private the values 
              #are not added to the list to be return by the function.  
              if { [string tolower [/$comp/$group SCOPE]] != "private" } {
                 #Code added to handle scope. If the attribute is private the values 
                 #are not added to the list to be return by the function.  
                 if { [string tolower [$ch SCOPE]] != "private" } {
                   
                      #set ln [lindex $vals $i]
                      #substituded by the next line.

                       set ln [lindex [join $vals] $i]

                       if { [cequal $rt "" ] } {
                            set rt $ln
                       } else {
                            append rt "\n$ln"
  	               }

               }
                 #variable added to index the list vals (change related to scope).
                 incr i
          }
        }
      } else {
         
         if { [string tolower [/$comp/$group SCOPE]] != "private"  } {

            set table_attrs [/$comp/$group children]
            set vals_counter 1
            
            foreach val $vals {

               set aindex 0 
               while { $aindex < [llength $table_attrs] } {
                  if { [string tolower [[lindex $table_attrs $aindex] SCOPE]] != "private" } {

                    set ln [lindex $val $aindex]

                    lappend rt "$ln"

                  }

                  incr aindex
               }

               if { $vals_counter < [llength $vals] } {
                    incr vals_counter
                    append rt "\n"
               }
            }
         } else {

              set vals ""   
         }
      }

      set vals "$rt"

    } 

  }
  return $vals

}

#
# GetAttrData - If add row or mod row was specified and the attribute
# information was not specified on the command line, this will prompt
# the user for the necessary information.
#
proc GetAttrData {comp group attr rowref action} {

   upvar $rowref row
   global verboseflag
   global SYSMAN_NOT_PRESENT

   set oldflag $verboseflag
   set verboseflag 0
   set vals {}

   #set deflist [split [GetDefaults $comp $group] \n]
   #The next line replaces the previous line to break the dependency
   #of GetAttrData from the GetDefaults function.
   set newresult [miGetDefaults $comp $group vals]

   #This if is to catch the newresult value in case of error.
   if { $newresult != {} } {
        return "Error: $newresult"
   }
   set deflist $vals

   set keylist [split [GetKey $comp $group] ,]

   #set typelist [GetType $comp $group $SYSMAN_NOT_PRESENT]
   #The next line substitutes the previous one. GetTypeNoSCOPE is
   #invoked in place of GetType. This allows to see all attributes
   #even if they are private.
   set typelist [GetTypeNoSCOPE $comp $group $SYSMAN_NOT_PRESENT]

   if { [cequal $attr $SYSMAN_NOT_PRESENT] } {

   	#set attrlist [GetAttributes $comp $group]
        #Added this four lines to break the dependency of GetAttrData on 
        #the function GetAttributes. This allows this function to see all
        #attributes even if they are private. 
        set attrlist {}
        foreach grp [SetGroups $comp $group] {
            foreach atr [$grp children] {
                 lappend attrlist [file tail $atr]
            }
        }

   } else {
	set attrlist $attr
	}

   foreach attr $attrlist {
    	set iloc [/$comp/$group GetLoc [/$comp/$group/$attr ID]]
	if { [lsearch -exact $keylist $attr] == -1 } {
		set keyattr 0
	    	set prompt "\nAttribute Name: $attr"
	} else {
		set keyattr 1
	    	set prompt "\nAttribute Name: $attr (key attribute)"
	}
        #Code added to handle scope. If the attribute is private the
        #output of the header is suppressed.
        if { [string tolower [/$comp/$group/$attr SCOPE]] != "private" } {
             puts $prompt
	     puts "Attribute Description: [GetDescription $comp $group $attr]"
        }

   	if { [cequal $action "MODIFY" ] } {
		set defval [lindex $row $iloc]
	} else {
		set defval [lindex $deflist $iloc]
	}
	set atype [lindex $typelist $iloc]

	while { 1 } {
         #Code added to handle scope. If the attribute is private the
         #default value is assign to it. Skipping the whole process of
         #new value assigment.
         if { [string tolower [/$comp/$group/$attr SCOPE]] != "private" } {
   	   if { [cequal $action "MODIFY" ] } {
		puts "Attribute Type: $atype, Current Value: $defval"
		puts -nonewline "Enter New Attribute Value (<CR> to keep unchanged): "
	   } else {
		if { [cequal $defval ""] } {
			puts "Attribute Type: $atype, Default Value: <NONE>"
			puts -nonewline "Enter Attribute Value: "
		} else {
			puts "Attribute Type: $atype, Default Value: $defval"
			puts -nonewline "Enter Attribute Value (<CR> to use default): "
		}
  	   }
	   flush stdout
	   set input [gets stdin]
	   if { [cequal $input ""] } {
		if { $keyattr  && [cequal $action "ADD"] && [cequal $defval ""] } {
			puts "\nERROR: Key attribute input value required!"
			puts $prompt
		} else {
			set input $defval
			break
		}
	   } else {
		break
           }
         } else {
           #Here is where the attribute is being set 
           #to its default value if it is private.
           set input $defval
           break
         }
	}

   	if { [cequal $action "ADD" ] } {
		lappend row $input 
	} else {
		set row [lreplace $row $iloc $iloc $input]
	}
   }
   set verboseflag $oldflag
}



# ------------------------------------------
# SaveCDF - Save component data into a CDF
#   If "doInit" set to zero, mcl is already loaded; just write it out.

proc SaveCDF {comp filename cdfoverride {doInit 1}} {

  global _g_cloning verboseflag
  # Flag should already be set most times, but may call this directly.
  #   One candidate is unattended install-and-config.  Just in case...
  set _g_cloning   1
  set oldflag      $verboseflag
  set verboseflag  0
  global SYSMAN_NOT_PRESENT

  # Added for unattended-install-and-config.
  #   Enables dumping values from Quick Setup.
  if {$doInit} {
      miInit $comp
  }

  # puts "SaveCDF, comp: $comp, file: $filename"


  if {[catch {set fd [open $filename w]}]} {
	puts "ERROR: Cannot open $filename for writing"
	exit 1
	}

  puts $fd "\n#\n# CDF Created: [exec /usr/bin/date]\n#"
  puts $fd "\n#\n# Component: $comp\n#"

  set newresult [ miReadRow $comp digitalmanagementmodes row 0 ]

  #Added this if to catch the newresult in case of error.
  #No error is expected here ever, because there is a 
  #digitalmanagementmode for all components by default.
  if { $newresult != {} } {
      #The next line deletes the cdf file that was being created
      #if an error occurs before the cdf is completed.
      unlink $filename
      return "Error: $newresult"
  }

  if { [cequal $cdfoverride $SYSMAN_NOT_PRESENT ] } {
	set cdfgroups [lindex $row [/$comp/digitalmanagementmodes GetLoc \
				[/$comp/digitalmanagementmodes/cdfgroups ID]]]
  } else {
	set cdfgroups $cdfoverride
	}
  if { [cequal $cdfgroups "NONE"] } {
	puts $fd "\n#\n# Error: digitalmanagementmodes/cdfgroups attribute\n# for this component is defined as NONE\n#"
	close $fd
	return
  } elseif { [cequal $cdfgroups "ALL"] } {
	set grouplist [GetGroups $comp]
  } else {
	set grouplist $cdfgroups
	if { [lsearch $grouplist "componentid"] == -1} {
		lappend grouplist "componentid"
	}
  }

  foreach group $grouplist {
      #Code added to handle scope. If the group is private 
      #is not saved in the cdf file.
      if { [string tolower [/$comp/$group SCOPE]] != "private" } {
	  if {$oldflag != 0} {
	      puts "\nSaving component $comp (group: $group)"
	  }

	  if { [cequal $group "digitalmanagementmodes"] } {
	      continue
	  }

	  puts $fd "\n#\n# Group: $group\n#"

	  set nextId 1
	  set numRecs 0
	  set order {}
	  set origNextId $nextId

	  puts $fd "/$comp/$group:"

	  # get attribute list
	  set stat [miGetKids /$comp/$group attrs]


	  # get key information
	  set keyattr [GetKey $comp $group silent]
	  set numkeys [llength [split $keyattr ,]]
	  if { [catch {set stat \
			   [miReadAll $comp $group data order nextId]}]} {
	      puts \
	     "ERROR: Occurred during read for component: $comp, group: $group"
	      exit 1
	  }

	  if { $numkeys != 0 } {
	      incr  numRecs [expr $nextId - $origNextId]
	  } else {
	      set   numRecs 1
	  }

	  # Write records preserving order
	  if { $numRecs != 0 } {
	      foreach dataIdx $order {
		  if { $numkeys != 0 } {
		      puts $fd "\tcdf_record=[format "%08.8d" $dataIdx]"
		  }
		  set attrId 0
		  foreach attr $attrs {
		      #Code added to handle scope. If the attribute is private 
		      #is not saved in the cdf file.
		      set attrVal [lindex $data($dataIdx) $attrId]
		      if { [string tolower [/$comp/$group/$attr SCOPE]] != \
			       "private" } {
			  if { ! [cequal $attrVal ""]} {
		    	      puts $fd "\t$attr=$attrVal"
			  }
		      }
		      incr attrId
		  }
	      }
	  }  ;# end if $numRecs

      }  ;# end foreach group

  }
  close $fd
}



# ------------------------------------------
# DeleteBogusRows - delete all the rows component and group.
# 
proc DeleteBogusRows { comp group upcdflist } {
upvar $upcdflist cdflist

    set nextId 1
    set numRecs 0
    set order {}
    set origNextId $nextId
    set stat [miReadAll $comp $group data order nextId]
    incr numRecs [expr $nextId - $origNextId]
    if { $numRecs != 0 } {
	foreach idx $order {
	    MakeKey $comp $group data($idx) rowkey 
	    if { ! [info exists cdflist($rowkey)] } {
		# This row is not in the CDF
		miDelRow $comp $group result $data($idx)
	    }
	}
    }
}



# ------------------------------------------
# ProcessCDFData - Take a row from a CDF and either add (table) or 
#   modify (group)

proc ProcessCDFData {comp group upattrs numkeys upcdflist pass upresult mode} {
upvar $upcdflist cdflist
upvar $upattrs attrs
upvar $upresult result

global SYSMAN_NOT_PRESENT

    set result {}
    if { $numkeys > 0 && [cequal $pass "apply"] && [cequal $mode REPLACE]} {
    	DeleteBogusRows $comp $group cdflist 
	}
    foreach key [array names cdflist] {
	set row {}
	set cdfrow $cdflist($key)
	# Build the row to validate or apply
        if { $numkeys == 0 } {
	    # Its a group.  Call modify
	    set newresult [ miReadRow $comp $group row 0 ]

            #Added this if to catch the newresult in case of error.
            if { $newresult != {} } {
                 return "Error: $newresult"
            }

	    if { [cequal $pass "validate"] } {
		set rowresult {}
		miValidate $comp $group rowresult $row $cdfrow
		if { ![cequal $rowresult "" ] } {
		    lappend result $rowresult
		    }
	    } else {
	            miModRow $comp $group result $row $cdfrow
		}
	} else {
	    if { [cequal $mode "APPEND" ] } {
                #Possible purpose of the following line is to reset the
                #table pointer to the top position.
	    	set newresult [ miReadRow $comp $group row 0 ]

                #Added this if to catch the newresult in case of error.
                if { $newresult != {} } {
                    return "Error: $newresult"
                }

		set row ""
	    } else {
		# mode is merge or replace, position to specific row.
	    	set newresult [miReadRowByKey $comp $group row $key]

                #Added this if to catch the newresult in case of error.
                if { $newresult != {} } {
                    return "Error: $newresult"
                }

		}
	   if { [cequal $row "" ] } {
		# This row does not exist.  We're going to add it.
	    	if { [cequal $pass "validate"] } {
		    set empty {}
		    set rowresult {}
		    miValidate $comp $group rowresult $empty $cdfrow 
		    if { ![cequal $rowresult "" ] } {
			lappend result $rowresult
			}
	        } else {
		    miAddRow $comp $group result $cdfrow
		    }
	    } else {
	    	if { [cequal $pass "validate"] } {
		    set rowresult {}
		    miValidate $comp $group rowresult $row $cdfrow
		    if { ![cequal $rowresult "" ] } {
		        lappend result $rowresult
		        }
		} else {
	    	    miModRow $comp $group result $row $cdfrow
		    }
		}
	}
     }
}

# 
# Given a potentially sparse CDF row of data, create a valid row 
# 
proc MakeRow { upcdfdata upattrs upcdfrow } {
upvar $upcdfdata cdfdata
upvar $upattrs attrs
upvar $upcdfrow cdfrow

    foreach attr $attrs {
	if { [info exists cdfdata($attr)] } {
	    lappend cdfrow $cdfdata($attr) 
	} else {
	    lappend cdfrow {} 
	    }
	}
}

#
# Given a row of data for a component and group, create
# a valid key based on the correct attributes.
#
proc MakeKey { comp group uprow uprowkey } {
upvar $uprowkey rowkey
upvar $uprow row
global SYSMAN_NOT_PRESENT

    set keyattr [GetKey $comp $group silent]
    set numkeys [llength [split $keyattr ,]]
    if { $numkeys == 0 } {
	set rowkey ""
	return
	}
    set keyattrs [split $keyattr ,]
    # Create a key out of a row of CDF data
    set key2 $SYSMAN_NOT_PRESENT
    set key1 [lindex $row [/$comp/$group GetLoc [/$comp/$group/[lindex $keyattrs 0] ID]]]
    if { $numkeys == 2 } {
	set key2 [lindex $row [/$comp/$group GetLoc [/$comp/$group/[lindex $keyattrs 1] ID]]]
	}
    set rowkey [CheckKeys $comp $group $numkeys key1 key2]
}

#
# ReadCDF - Read component data from a CDF
#
proc ReadCDF {filename pass} {


  global _g_cloning SYSMAN_NOT_PRESENT verboseflag
  # Flag should already be set most times, but may call this directly.
  #   One candidate is unattended install-and-config.  Just in case...
  set _g_cloning   1
  set oldflag      $verboseflag
  set verboseflag  0

  # puts "ReadCDF, file: $filename, pass: $pass"


  if {[catch {set fd [open $filename r]}]} {
	puts "ERROR: Cannot open $filename for reading"
	exit 1
	}

  # set the default CDF mode
  set cdfmode "MERGE"

  set comp {} 
  while {[ gets $fd line ] >= 0} {

        if {[regexp {^#.*$} $line] || [regexp {^[ \t]*$} $line] || \
            [regexp {CHECKSUM=.*$} $line] } {
            # comment or blank line, ignore it
            # or line starting with CHECKSUM, ignore it too
            continue
            }
	if {[regexp {^/.*/.*:} $line]} {
	    # Found a component/group line
     	    if { [info exists cdfdata ]} {
		# New component/group and previous component/group in progress
		catch {unset cdfrow}
		catch {unset rowkey}
		MakeRow cdfdata attrs cdfrow 
		MakeKey $comp $group cdfrow rowkey 
		set cdflist($rowkey) $cdfrow
		ProcessCDFData $comp $group attrs $numkeys cdflist $pass result $cdfmode
		if { [cequal $pass "validate"] && ![cequal $result ""] } {
		    puts "\n\tValidate Error: $result"

                    # The ERROR flag is set when a validation error occurs.
                    # It is used to stop the application of the CDF file is
                    # case of errors int the data.
                    set ERROR 1
		    }
		catch {unset cdfdata}
		}
	    # Reset cdflist keyedlist
	    catch {unset cdflist}

	    # get new component, group and attributes
	    regexp {^/(.*)/(.*):]*$} $line bogus newcomp newgroup
	    if { $oldflag != 0 } {
	    	if { [cequal $pass "validate"] } {
		    puts "\nValidating component $newcomp (group: $newgroup)"
	        } else {
		    puts "\nConfiguring component $newcomp (group: $newgroup)"
		    }
		}
	
	    if  { ! [cequal $newcomp $comp] } {
		# This is either the first component or a new component 
		miInit $newcomp
		}
	    set comp $newcomp
	    set group $newgroup

	    # get keys and attribute list for this component/group
  	    set keyattr [GetKey $comp $group silent]
  	    set numkeys [llength [split $keyattr ,]]
  	    set keyattrs [split $keyattr ,]
	    set stat [miGetKids /$comp/$group attrs]

	    # reset record index
  	    set record -1
	} elseif {[regexp {CDFMODE=.*$} $line]} {
	    # change the cdf mode 
	    regsub "CDFMODE=" $line "" mode
	    if { [cequal $mode "REPLACE"] || [cequal $mode "APPEND"] || [cequal $mode "MERGE"] } {
		set cdfmode $mode
	    } else {
		puts "WARNING: Ignoring unknown CDFMODE ($mode)!\nValid modes: REPLACE or APPEND\nCurrent mode: $cdfmode"
		}
	} else {
	    # Found attribute data.  Check for a record indicator.
	    if {[regexp {cdf_record=.*$} $line]} {
		# Found record number indicator.  
		# Remember,in a CDF, a group (non-table) does not have a cdf_record.
     		if { [info exists cdfdata ]} {
		    catch {unset cdfrow}
		    catch {unset rowkey}
		    MakeRow cdfdata attrs cdfrow
		    MakeKey $comp $group cdfrow rowkey 
		    set cdflist($rowkey) $cdfrow
		    catch {unset cdfdata}
		    }
		regsub "cdf_record=" $line "" record
	    } else {
		set line [string trim $line]
	    	regexp {^([^=]*)=(.*)$} $line bogus attrname attrval
		set cdfdata($attrname) $attrval
		}
	    }
	}
     if { [info exists cdfdata ]} {
	# End of file and previous component/group in progress
	catch {unset cdfrow}
	catch {unset rowkey}
	MakeRow cdfdata attrs cdfrow
	MakeKey $comp $group cdfrow rowkey 
	set cdflist($rowkey) $cdfrow
	ProcessCDFData $comp $group attrs $numkeys cdflist $pass result $cdfmode
	if { [cequal $pass "validate"] && ![cequal $result ""] } {
	    puts "\n\tValidate Error: $result"

            # The ERROR flag is set when a validation error occurs.
            # It is used to stop the application of the CDF file is
            # case of errors int the data.
            set ERROR 1
	    }
	catch {unset cdfdata}
	}
   close $fd

   # This if statement was added to fix the problem with sysmancli
   # exiting at the first validation error of a CDF. This will
   # allow sysmancli to display all the validation errors. 

   if {[info exists ERROR]} { 
        return "Some components failed to validate."
   }

   return
}

#
# AddRow - Take a row and add it to the specified component and group.
# If row data was not given on the command line, prompt for each attribute.
#
proc AddRow {comp group row} {

  global SYSMAN_NOT_PRESENT
  global verboseflag
  miInit $comp
  set realrow {}

  set keyattr [GetKey $comp $group silent]
  set numkeys [llength [split $keyattr ,]]
  if { $numkeys == 0 } {
	# No key. Must be a group.  Cannot delete row from a group
	puts "[SYSMAN_INVALID_COMMAND 2 "You cannot add rows to this group.  There are no keys (it is not a TABLE)" ]"
	}

  # Do a read to load table
  set newresult [ miReadRow $comp $group bogus 0 ]

  #Added this if to catch the newresult in case of error.
  if { $newresult != {} } {
       return "Error: $newresult"
  }


  if { [cequal $row $SYSMAN_NOT_PRESENT ] } {
	GetAttrData $comp $group $SYSMAN_NOT_PRESENT realrow "ADD"
  } else {

        #Code added to handle scope. First we create a list of attributes for the 
        #selected group.
        set attrlist {}
        foreach grp [SetGroups $comp $group] {
            foreach atr [$grp children] {
                 lappend attrlist [file tail $atr]
            }
        }

        #Then we get the length of this list and save it in an index variable and define
        #a counter variable.
        set idx_limit [llength $attrlist]
        set idx_counter -1

        #The following lines save the verboseflag value and change the value of the flag
        #to no verbose. The length of the row entered by the user is calculated. The 
        #length of the attributes without private scope is calculated. The division of
        #this two numbers will give me the number of rows entered by the user at once.
        #The original value of the verboseflag is restore.
        set oldflag $verboseflag
        set verboseflag 0
        set number_of_rows [expr [llength $row]/[llength [GetAttributes $comp $group]].0]
        set verboseflag $oldflag

        set newresult [miGetDefaults $comp $group vals]
        #This if is to catch the newresult value in case of error.
        if { $newresult != {} } {
             return "Error: $newresult"
        }
        set default_val $vals

        #The row(s) entered by the user is (are)parsed.   
  	foreach el $row {

             #Increment the counter at the beginning to set it to zero.
             incr idx_counter

             #Checks that the index counter for the row being parsed don't go over
             #the number of attributes of the group definition. If it goes over 
             #it checks if there are more rows to parse. If that is the case the 
             #counter is set to zero and the number of rows is decremented.
             if { $idx_counter == $idx_limit } {
                  if { $number_of_rows > 0 } {
                       set number_of_rows [expr $number_of_rows - 1]
                       set idx_counter 0 
                  }
             }

             #Checks for the index counter to be lower to the number of actual attributes
             #of the group definition. Then checks for the scope of the attribute: if is not
             #private, the value in the row entered by the user is appended to the new row being 
             #build. Else, inserts the default value for the private attribute and checks if the 
             #following attributes are private repeating the procedure in the case they are private.  
             if { $idx_counter < $idx_limit } { 

               if { [string tolower [/$comp/$group/[lindex $attrlist $idx_counter] SCOPE]] != "private" } {
		    lappend realrow $el
               } else {
                    while { [string tolower [/$comp/$group/[lindex $attrlist $idx_counter] SCOPE]] == "private" } {
                         lappend realrow [lindex $default_val $idx_counter]
                         incr idx_counter
                    }

                    lappend realrow $el
               }
             }  
	}
  }
  # puts "AddRow, comp: $comp, group: $group, row: $realrow"

  #
  # Validate to see if add is ok
  #
  set empty {}
  miValidate $comp $group result $empty $realrow 
  if { ! [cequal $result "" ] } {
	puts "[SYSMAN_VALIDATE_ERROR 2 "$result" ]"
	}

  return [miAddRow $comp $group result $realrow]
}

#
# DeleteRow - Delete a row from the specified component and group based
# on the keys specified on the command line.  If keys were not given on
# the command line, prompt for each key.
#
proc DeleteRow {comp group key1 key2} {

  global SYSMAN_NOT_PRESENT
  miInit $comp
  # puts "DeleteRow, comp: $comp, group: $group, key1: $key1, key2: $key2"

  set keyattr [GetKey $comp $group silent]
  set numkeys [llength [split $keyattr ,]]
  if { $numkeys == 0 } {
	# No key. Must be a group.  Cannot delete row from a group
	puts "[SYSMAN_INVALID_COMMAND 2 "You cannot delete rows from this group.  There are no keys (it is not a TABLE)" ]"
	}

  set rowkey [CheckKeys $comp $group $numkeys key1 key2]
  set newresult [miReadRowByKey $comp $group row $rowkey]

  #
  # If the value returned by CheckKeys is null and the
  # keys given by the user were null, there is no way
  # of returning a row for deletion. So we are setting
  # the row to nothing.
  #
  if { $rowkey == {} && $key1 == {} && $key2 == {} } {
       set row {}     
  }

  #Added this if to catch the newresult in case of error.
  if { $newresult != {} } {
       return "Error: $newresult"
  }
  
  if { $row == "" } {
	if { $numkeys == 2 } {
		puts "[SYSMAN_NO_DATA 2 "No row exists with the specified keys: '$key1' and '$key2'" ]"
	} else {
		puts "[SYSMAN_NO_DATA 2 "No row exists with the specified key: '$key1'" ]"
		}
       }
  #
  # Got the row in question.  Delete it via miDelRow
  # First, validate to see if delete is ok
  #
  set empty {}
  miValidate $comp $group result $row $empty 
  if { ! [cequal $result "" ] } {
	puts "[SYSMAN_VALIDATE_ERROR 2 "$result" ]"
	}

  return [miDelRow $comp $group result $row]

}

#
# SetValue - Set (modify) one or more attributes from the specified
# component and group.  If attributes not specified on the command
# line, prompt for each attribute and value to set it to.
#
proc SetValue {comp group attr k1 k2} {
  upvar $k1 key1
  upvar $k2 key2
  global SYSMAN_NOT_PRESENT

  set vals {}
  miInit $comp

  # puts "SetValue, comp: $comp, group: $group, attr: $attr, key1: $key1, key2: $key2"
  set keyattr [GetKey $comp $group silent]
  set numkeys [llength [split $keyattr ,]]
  if { $numkeys == 0 } {
	# No key.  Must be a group
        # If is a group keys should not be suppied.
        #
        if { $key1 != $SYSMAN_NOT_PRESENT || $key2 != $SYSMAN_NOT_PRESENT } {

	     puts "[SYSMAN_INVALID_COMMAND 2 "User supplied key(s), but the group is keyless"]"
        }

 	set newresult [miReadRow $comp $group row]

        #Added this if to catch the newresult in case of error.
        if { $newresult != {} } {
             return "Error: $newresult"
        }

  } else {
	# Key(s).  Must be a table
  	set rowkey [CheckKeys $comp $group $numkeys key1 key2]
  	set taber "      "
  	set newresult [miReadRowByKey $comp $group row $rowkey]

        #Added this if to catch the newresult in case of error.
        if { $newresult != {} } {
             return "Error: $newresult"
        }

  	if { [cequal $row ""] } {
  		if { $numkeys == 1 } {
			puts "[SYSMAN_NO_DATA 2 "No row exists with the specified key: '$key1'" ]"
		} else {
			puts "[SYSMAN_NO_DATA 2 "No row exists with the specified keys: '$key1' and '$key2'" ]"
			}
  		}
  	}
  #
  # Got the row in question.  Replace attribute values, validate and call miModRow
  #
  set newrow $row
  if { [cequal $attr $SYSMAN_NOT_PRESENT] } {
      # No attributes defined, prompt with each row attribute
      GetAttrData $comp $group $SYSMAN_NOT_PRESENT newrow "MODIFY"
  } else {
      foreach iattr [split $attr ,] {
	set attrname [lindex [split $iattr =] 0]
	set attrval [lindex [split $iattr =] 1]

    	set iloc [/$comp/$group GetLoc [/$comp/$group/$attrname ID]]

        if { [llength [split $iattr =]] != 2 } { 
		# new value not defined.  Prompt for it
      		GetAttrData $comp $group $attrname newrow "MODIFY"
                set attrval [lindex $newrow $iloc]
	}
	set newrow [lreplace $newrow $iloc $iloc $attrval]
      }
  }

  # puts "Oldrow:     $row"
  # puts "Validating: $newrow"
  miValidate $comp $group result $row $newrow 
  if { ! [cequal $result "" ] } {
	puts "[SYSMAN_VALIDATE_ERROR 2 "$result" ]"
	}

  set errmsg [miModRow $comp $group result $row $newrow resultingRow]

  # In case of error resultingRow doesn't exist.
  if [ info exists resultingRow ] {
        set newrow $resultingRow
  }

  #
  # Regenerate the keys in case a key value was modified
  #
  set kidx 1
  foreach kattr [split $keyattr ,] {
    	set kloc [/$comp/$group GetLoc [/$comp/$group/$kattr ID]]
	set key$kidx [lindex $newrow $kloc]
	incr kidx
	}
  return $errmsg
}

proc GetType {comp group attr} {

  set types {}
  set rt "Component: $comp"
  foreach grp [SetGroups $comp $group] {
   #Code to handle scope. If the group is private the output
   #header for that group is not displayed.
   if { [string tolower [$grp SCOPE]] != "private" } {
    addReturn rt "  Group: [file tail $grp]"
    foreach atr [SetAttributes $grp $attr] {
      #Code to handle scope. If the attribute is private the
      #the value is not included the list returned by the function. 
      if { [string tolower [$atr SCOPE]] != "private" } {
         if { [catch {set a [$atr TYPE]} ] } {
              set a ""
         }
       set a [string toupper $a]
       set enum [$atr children]
       set elist {}
       catch {unset enumvals}
       if { $enum != {} } {
 	if { [cequal $a "ENUM" ] } {
             array set enumvals [split [join [$enum GET] :] :]
 	     foreach key [lsort [array names enumvals]] {
	     	append elist "$enumvals($key)@"
		}
	     set a "$a { [string trimright [join [split $elist @] ", "] ", "] }"
	} else {
            array set enumvals [split [join [$enum GET] :] :]
	    foreach key [lsort [array names enumvals]] {
	    	append elist "$key=$enumvals($key)@"
		}
	    set a "$a ENUM { [string trimright [join [split $elist @] ", "] ", "] }"
	    }
      } else {
	set alist ""
	}
      
      addReturn rt [format "    Attribute: %s Type: %s" \
                              [Spacer 29 [file tail $atr]] $a ]
      lappend types $a
    }
    }
   }
  }
  global verboseflag
  if { $verboseflag != 0 } {
    return $rt
  }
  return $types

}

#This function is similar to GetType (without the scope functionality)
#but it will display all the group and attribute types even if they are private. 
proc GetTypeNoSCOPE {comp group attr} {

  set types {}
  set rt "Component: $comp"
  foreach grp [SetGroups $comp $group] {
    addReturn rt "  Group: [file tail $grp]"
    foreach atr [SetAttributes $grp $attr] {
         if { [catch {set a [$atr TYPE]} ] } {
         set a ""
      }
      set a [string toupper $a]
      set enum [$atr children]
      set elist {}
      catch {unset enumvals}
      if { $enum != {} } {
	if { [cequal $a "ENUM" ] } {
            array set enumvals [split [join [$enum GET] :] :]
	    foreach key [lsort [array names enumvals]] {
	    	append elist "$enumvals($key)@"
		}
	    set a "$a { [string trimright [join [split $elist @] ", "] ", "] }"
	} else {
            array set enumvals [split [join [$enum GET] :] :]
	    foreach key [lsort [array names enumvals]] {
	    	append elist "$key=$enumvals($key)@"
		}
	    set a "$a ENUM { [string trimright [join [split $elist @] ", "] ", "] }"
	    }
      } else {
	set alist ""
	}
      
      addReturn rt [format "    Attribute: %s Type: %s" \
                              [Spacer 29 [file tail $atr]] $a ]
      lappend types $a
    }
  }
  global verboseflag
  if { $verboseflag != 0 } {
    return $rt
  }
  return $types

}

proc GetKey {comp group {mode {normal}}} {

  set keys {}
  set rt ""
  set preKtab " "
  set postKtab ""
  if { "$mode" == "normal" } {
  	set rt "Component: $comp"
	}
  foreach grp [SetGroups $comp $group] {
   #Code to handle scope. 
   if { [catch {$grp SCOPE} Error] != 0} {
        puts "\n\tError: $Error"
        exit 1
   }

   if { [string tolower [$grp SCOPE]] != "private" } {
    if { ! [catch {set k [$grp KEY]} ] } {
      set kvalue {}
      set x 0
      foreach key [split $k ,] {
	lappend kvalue [file tail [$grp GetName $key]]
	incr x
      }
      lappend keys [join $kvalue ,]
      if {$x != 1} {
	set preKtab ""
	set postKtab "s"
      }
      if { "$mode" == "normal" } {
      	    addReturn rt [format "  Group: %s %sKey%s: %s" \
                              [Spacer 35 [file tail $grp]] \
			      $preKtab $postKtab [join $kvalue ,] ]
	    }
    } else {
      #Commented this line........check if it doesn't have any sec. effects.
      # set keys ""
      if { "$mode" == "normal" } {
      	    addReturn rt [format "  Group: %s %sKey%s: %s" \
                              [Spacer 35 [file tail $grp]] \
			      $preKtab $postKtab "<NONE>"]
	    }
    }
   }
  }
  global verboseflag
  if {$verboseflag != 0} {
    if { "$mode" == "normal" } {
    	return $rt
    } else {
  	return $keys
	}
  }
  return $keys
}

proc GetClass {comp group} {

  set classes {}
  set rt "Component: $comp"
  #Code to handle scope. 
  foreach grp [SetGroups $comp $group] {
       if { [string tolower [$grp SCOPE]] != "private" } {
            addReturn rt [format "  Group: %s Class: %s" \
                              [Spacer 35 [file tail $grp]] \
			      [$grp CLASS]]
            lappend classes [$grp CLASS]
       }
  }
  global verboseflag
  if {$verboseflag != 0} {
    return $rt
  }
  return $classes
}

proc ERR_Init {} {

  set ERCODES {SYSMAN_INVALID_COMPONENT \
               SYSMAN_INVALID_GROUP \
               SYSMAN_INVALID_ATTRIBUTE \
	       SYSMAN_INVALID_COMMAND \
               SYSMAN_MUST_SUPPLY_CDFGROUPS \
	       SYSMAN_MUST_SUPPLY_COMPONENT \
               SYSMAN_MUST_SUPPLY_DATA \
	       SYSMAN_MUST_SUPPLY_GROUP \
	       SYSMAN_MUST_SUPPLY_ATTRIBUTE \
	       SYSMAN_MUST_SUPPLY_FILE \
	       SYSMAN_MUST_SUPPLY_KEY1 \
	       SYSMAN_MUST_SUPPLY_KEY2 \
	       SYSMAN_UNKNOWN_REQUEST \
               SYSMAN_NO_DATA \
               SYSMAN_INIT_ERROR \
               SYSMAN_VALIDATE_ERROR}

  foreach ERcode $ERCODES {
  
    set p "proc $ERcode {{code {0}} args} {
    set arg2display \"\"
    if { \$code <= 1 } {
      if { \$args != {} } {
        set arg2display \"<<< \[join \$args\] >>>\"
      }
      puts stderr \"Error: \$arg2display \\\"$ERcode\\\" \"
      usage
    } else {
      if { \$args != {} } {
        set arg2display \"\[join \$args\]\"
      }
      puts stderr \"Error: \\\"$ERcode\\\" \"
      puts stderr \"\$arg2display\"
    }
    exit 1
  }"

    eval $p
  }

}


Class Option

Option instproc init {lname sname boolarg nullarg} {

  $self set lname $lname
  $self set sname $sname
  $self set boolarg $boolarg
  $self set nullarg $nullarg
  $self set argval {}
  $self set narg 0

}

Option instproc getarg {} {

  $self instvar lname sname boolarg nullarg narg argval
  set flag "${lname}flag"
  global $flag

  set argval [ parseOpts $lname $sname $boolarg ]
  # echo "lname: $lname,  $self $argval [set $flag] $boolarg"

  if {$boolarg == 1} {
    if { [set $flag] == 1 && $nullarg == 0 && $argval == {}} {
      set exlname [translit a-z A-Z $lname]
      puts "[SYSMAN_MUST_SUPPLY_${exlname}]"
    }
  }

  set narg 1
  return $argval

}

#
# Global
#
global SYSMAN_NOT_PRESENT
set SYSMAN_NOT_PRESENT "_SYSMAN__NOT__PRESENT_"
