#!/usr/share/sysman/bin/sysmansh
#
# *****************************************************************
# *                                                               *
# *   Copyright 2002 Compaq Information Technologies Group, L.P.  *
# *                                                               *
# *   The software contained on this media  is  proprietary  to   *
# *   and  embodies  the  confidential  technology  of  Compaq    *
# *   Computer Corporation.  Possession, use,  duplication  or    *
# *   dissemination of the software and media is authorized only  *
# *   pursuant to a valid written license from Compaq Computer    *
# *   Corporation.                                                *
# *                                                               *
# *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
# *   by the U.S. Government is subject to restrictions  as  set  *
# *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
# *   or  in  FAR 52.227-19, as applicable.                       *
# *                                                               *
# *****************************************************************
#
# HISTORY
#


proc HelpYesNoBox { {yesNoBoxMessage "Yes/no message"} {yesNoBoxTitle "HelpYesNoBox"}} {
# xf ignore me 5
##########
# Procedure: HelpYesNoBox
# Description: show yesno box
# Arguments: {yesNoBoxMessage}  - the text to display
#            {yesNoBoxTitle}    - the box title to display
# Returns: none
# Sideeffects: none
##########
#
# global yesNoBox(activeBackground) - active background color
# global yesNoBox(activeForeground) - active foreground color
# global yesNoBox(anchor) - anchor for message box
# global yesNoBox(background) - background color
# global yesNoBox(font) - message font
# global yesNoBox(foreground) - foreground color
# global yesNoBox(justify) - justify for message box
# global yesNoBox(afterNo) - destroy yes-no box after n seconds.
#                            The no button is activated
# global yesNoBox(afterYes) - destroy yes-no box after n seconds.
#                             The yes button is activated
# global yesNoBox(afterCancel) - destroy yes-no box after n seconds.
#                             The cancel button is activated

  global yesNoBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$yesNoBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$yesNoBox(activeBackground)\" "
  }
  if {"$yesNoBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$yesNoBox(activeForeground)\" "
  }
  if {"$yesNoBox(background)" != ""} {
  }
  if {"$yesNoBox(font)" != ""} {
    append tmpButtonOpt "-font \"$yesNoBox(font)\" "
    append tmpMessageOpt "-font \"$yesNoBox(font)\" "
  }
  if {"$yesNoBox(foreground)" != ""} {
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .yesNoBox}
  } {
    catch {destroy .yesNoBox}
  }
  toplevel .yesNoBox  -borderwidth 0
  catch ".yesNoBox config $tmpFrameOpt"

  wm title .yesNoBox $yesNoBoxTitle
  wm maxsize .yesNoBox 1000 1000
  wm minsize .yesNoBox 100 100
  # end build of toplevel

  message .yesNoBox.message1  \
	-anchor "$yesNoBox(anchor)" \
	-justify "$yesNoBox(justify)" \
	-relief ridge  \
	-text "$yesNoBoxMessage"
  catch ".yesNoBox.message1 config $tmpMessageOpt"

  .yesNoBox.message1 configure  -aspect 1000

  frame .yesNoBox.frame1  -borderwidth 0  -relief flat
  catch ".yesNoBox.frame1 config $tmpFrameOpt"

  frame .yesNoBox.frame1.frame20 \
    -borderwidth {10}

  button .yesNoBox.frame1.frame20.button0  -text "Yes"  -command "
      global yesNoBox
      set yesNoBox(button) 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .yesNoBox}
      } {
        catch {destroy .yesNoBox}
      }"
  catch ".yesNoBox.frame1.frame20.button0 config $tmpButtonOpt"

  pack append .yesNoBox.frame1.frame20 \
    .yesNoBox.frame1.frame20.button0 {top frame center expand fillx}


  frame .yesNoBox.frame1.frame21 \
    -borderwidth {10}

  button .yesNoBox.frame1.frame21.button1  -text "No"  -command "
      global yesNoBox
      set yesNoBox(button) 0
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .yesNoBox}
      } {
        catch {destroy .yesNoBox}
      }"
  catch ".yesNoBox.frame1.frame21.button1 config $tmpButtonOpt"

  pack append .yesNoBox.frame1.frame21 \
    .yesNoBox.frame1.frame21.button1 {top frame center expand fillx}

  frame .yesNoBox.frame1.frame22 \
    -borderwidth {10}

  button .yesNoBox.frame1.frame22.button2  -text "Cancel"  -command "
      global yesNoBox
      set yesNoBox(button) -1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .yesNoBox}
      } {
        catch {destroy .yesNoBox}
      }"
  catch ".yesNoBox.frame1.frame22.button2 config $tmpButtonOpt"

  pack append .yesNoBox.frame1.frame22 \
    .yesNoBox.frame1.frame22.button2 {top frame center expand fillx}

  frame .yesNoBox.frame1.frame23 \
    -borderwidth {10}

  button .yesNoBox.frame1.frame23.button3  -text "Help"  -command "
      global yesNoBox
      set yesNoBox(button) -1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .yesNoBox}
      } {
        catch {destroy .yesNoBox}
      }"
  catch ".yesNoBox.frame1.frame23.button3 config $tmpButtonOpt"

  pack append .yesNoBox.frame1.frame23 \
    .yesNoBox.frame1.frame23.button3 {top frame center expand fillx}

  pack append .yesNoBox.frame1 \
	 .yesNoBox.frame1.frame20 {left frame center fillx expand} \
	 .yesNoBox.frame1.frame21 {left frame center fillx expand} \
	 .yesNoBox.frame1.frame22 {left frame center fillx expand} \
	 .yesNoBox.frame1.frame23 {left frame center fillx expand}


  # packing
  pack append .yesNoBox  .yesNoBox.frame1 {bottom fill}  .yesNoBox.message1 {top fill expand}

  if {$yesNoBox(afterYes) != 0} {
    after [expr $yesNoBox(afterYes)*1000]  "catch 
\".yesNoBox.frame1.frame20.button0 invoke\""
  }
  if {$yesNoBox(afterNo) != 0} {
    after [expr $yesNoBox(afterNo)*1000]  "catch 
\".yesNoBox.frame1.frame21.button1 invoke\""
  }
  if {$yesNoBox(afterCancel) != 0} {
    after [expr $yesNoBox(afterCancel)*1000]  "catch 
\".yesNoBox.frame1.frame22.button2 invoke\""
  }

  # wait for the box to be destroyed
  update idletask
#  grab .yesNoBox
  tkwait window .yesNoBox

  return $yesNoBox(button)
}


proc HelpOkCancelBox { {okCancelBoxMessage "Yes/no message"} {okCancelBoxTitle "Mail"}} {
# xf ignore me 5
##########
# Procedure: HelpOkCancelBox
# Description: show okCancel box
# Arguments: {okCancelBoxMessage}  - the text to display
#            {okCancelBoxTitle}    - the box title to display
# Returns: none
# Sideeffects: none
##########
#
# global okCancelBox(activeBackground) - active background color
# global okCancelBox(activeForeground) - active foreground color
# global okCancelBox(anchor) - anchor for message box
# global okCancelBox(background) - background color
# global okCancelBox(font) - message font
# global okCancelBox(foreground) - foreground color
# global okCancelBox(justify) - justify for message box
# global okCancelBox(afterNo) - destroy yes-no box after n seconds.
#                            The no button is activated
# global okCancelBox(afterYes) - destroy yes-no box after n seconds.
#                             The yes button is activated
# global okCancelBox(afterCancel) - destroy yes-no box after n seconds.
#                             The cancel button is activated

  global okCancelBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$okCancelBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$okCancelBox(activeBackground)\" "
  }
  if {"$okCancelBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$okCancelBox(activeForeground)\" "
  }
  if {"$okCancelBox(background)" != ""} {
  }
  if {"$okCancelBox(font)" != ""} {
    append tmpButtonOpt "-font \"$okCancelBox(font)\" "
    append tmpMessageOpt "-font \"$okCancelBox(font)\" "
  }
  if {"$okCancelBox(foreground)" != ""} {
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .okCancelBox}
  } {
    catch {destroy .okCancelBox}
  }
  toplevel .okCancelBox  -borderwidth 0
  catch ".okCancelBox config $tmpFrameOpt"

  wm title .okCancelBox $okCancelBoxTitle
  wm maxsize .okCancelBox 1000 1000
  wm minsize .okCancelBox 100 100
  # end build of toplevel

  message .okCancelBox.message1  \
	-anchor "$okCancelBox(anchor)" \
	-justify "$okCancelBox(justify)" \
	-relief ridge  \
	-text "$okCancelBoxMessage"
  catch ".okCancelBox.message1 config $tmpMessageOpt"

  .okCancelBox.message1 configure  -aspect 1000


  frame .okCancelBox.frame1  -borderwidth 0  -relief flat
  catch ".okCancelBox.frame1 config $tmpFrameOpt"

  frame .okCancelBox.frame1.frame20 \
    -borderwidth {10}

  button .okCancelBox.frame1.frame20.button0  -text "OK"  -command "
      global okCancelBox
      set okCancelBox(button) 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .okCancelBox}
      } {
        catch {destroy .okCancelBox}
      }"
  catch ".okCancelBox.frame1.frame20.button0 config $tmpButtonOpt"

  pack append .okCancelBox.frame1.frame20 \
    .okCancelBox.frame1.frame20.button0 {top frame center expand fillx}


  frame .okCancelBox.frame1.frame21 \
    -borderwidth {10}

  button .okCancelBox.frame1.frame21.button1  -text "Cancel"  -command "
      global okCancelBox
      set okCancelBox(button) 0
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .okCancelBox}
      } {
        catch {destroy .okCancelBox}
      }"
  catch ".okCancelBox.frame1.frame21.button1 config $tmpButtonOpt"

  pack append .okCancelBox.frame1.frame21 \
    .okCancelBox.frame1.frame21.button1 {top frame center expand fillx}

  frame .okCancelBox.frame1.frame22 \
    -borderwidth {10}

  button .okCancelBox.frame1.frame22.button2  -text "Help"  -command "
      global okCancelBox
      set okCancelBox(button) -1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .okCancelBox}
      } {
        catch {destroy .okCancelBox}
      }"
  catch ".okCancelBox.frame1.frame22.button2 config $tmpButtonOpt"

  pack append .okCancelBox.frame1.frame22 \
    .okCancelBox.frame1.frame22.button2 {top frame center expand fillx}

  pack append .okCancelBox.frame1 \
	 .okCancelBox.frame1.frame20 {left frame center fillx expand} \
	 .okCancelBox.frame1.frame21 {left frame center fillx expand} \
	 .okCancelBox.frame1.frame22 {left frame center fillx expand}


  # packing
  pack append .okCancelBox  \
	.okCancelBox.frame1 {bottom fill}  \
	.okCancelBox.message1 {top fill expand}

  if {$okCancelBox(afterYes) != 0} {
    after [expr $okCancelBox(afterYes)*1000]  "catch 
\".okCancelBox.frame1.frame20.button0 invoke\""
  }
  if {$okCancelBox(afterNo) != 0} {
    after [expr $okCancelBox(afterNo)*1000]  "catch 
\".okCancelBox.frame1.frame21.button1 invoke\""
  }
  if {$okCancelBox(afterCancel) != 0} {
    after [expr $okCancelBox(afterCancel)*1000]  "catch 
\".okCancelBox.frame1.frame22.button2 invoke\""
  }

  # wait for the box to be destroyed
  update idletask
#  grab .okCancelBox
  tkwait window .okCancelBox

  return $okCancelBox(button)
}
# Procedure: HelpAlertBox
proc HelpAlertBox { {alertBoxMessage "Alert message"} {alertBoxCommand ""} {alertBoxGeometry "350x150"} {alertBoxTitle "Net Config Error"} args} {
# xf ignore me 5
##########
# Procedure: HelpAlertBox
# Description: show alert box
# Arguments: {alertBoxMessage} - the text to display
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          HelpAlertBoxFile - to open and read a file automatically
#          HelpAlertBoxFd - to read from an already opened filedescriptor
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  # show alert box
  if {[llength $args] > 0} {
    eval HelphelpAlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxCommand\}" "\{$alertBoxGeometry\}" "\{$alertBoxTitle\}" $args
  } {
    HelphelpAlertBoxInternal $alertBoxMessage $alertBoxCommand $alertBoxGeometry $alertBoxTitle
  }

# dp: I commented the "if {[llength $args] > 0}" in order
#	  to make the dialog box modal all the time.
#  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $alertBox(toplevelName)
	# dp: Added this line to ensure that there is no "leftover" focus anywhere
	focus $alertBox(toplevelName)
    tkwait window $alertBox(toplevelName)

    return $alertBox(button)
#  }
}


# Procedure: HelphelpAlertBoxInternal
proc HelphelpAlertBoxInternal { alertBoxMessage alertBoxCommand alertBoxGeometry alertBoxTitle args} {
# xf ignore me 6
  global alertBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$alertBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$alertBox(activeBackground)\" "
  }
  if {"$alertBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$alertBox(activeForeground)\" "
  }
  if {"$alertBox(background)" != ""} {
  }
  if {"$alertBox(font)" != ""} {
    append tmpButtonOpt "-font \"$alertBox(font)\" "
    append tmpMessageOpt "-font \"$alertBox(font)\" "
  }
  if {"$alertBox(foreground)" != ""} {
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy $alertBox(toplevelName)}
  } {
    catch {destroy $alertBox(toplevelName)}
  }
  toplevel $alertBox(toplevelName)  -borderwidth 0
  catch "$alertBox(toplevelName) config $tmpFrameOpt"

  wm title $alertBox(toplevelName) $alertBoxTitle
  wm maxsize $alertBox(toplevelName) 1000 1000
  wm minsize $alertBox(toplevelName) 100 100
  # end build of toplevel

  message $alertBox(toplevelName).message1  -anchor "$alertBox(anchor)"  -justify "$alertBox(justify)"  -relief ridge  -text "$alertBoxMessage"
  catch "$alertBox(toplevelName).message1 config $tmpMessageOpt"

  $alertBox(toplevelName).message1 configure  -aspect 1500

  frame $alertBox(toplevelName).frame1  -borderwidth 10  -relief flat
  catch "$alertBox(toplevelName).frame1 config $tmpFrameOpt"

  set alertBoxCounter 0
  set buttonNum [llength $args]
  if {$buttonNum > 0} {
    while {$alertBoxCounter < $buttonNum} {
      button $alertBox(toplevelName).frame1.button$alertBoxCounter  -text "[lindex $args $alertBoxCounter]"  -command "
          global alertBox
          set alertBox(button) $alertBoxCounter
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy $alertBox(toplevelName)}
          } {
            catch {destroy $alertBox(toplevelName)}
          }"
      catch "$alertBox(toplevelName).frame1.button$alertBoxCounter config $tmpButtonOpt"

      pack append $alertBox(toplevelName).frame1 $alertBox(toplevelName).frame1.button$alertBoxCounter {left fillx expand}

      incr alertBoxCounter
    }
  } {
    button $alertBox(toplevelName).frame1.button0  -text "OK"  -command "
        global alertBox
        set alertBox(button) 0
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy $alertBox(toplevelName)}
        } {
          catch {destroy $alertBox(toplevelName)}
        }
        $alertBoxCommand"
    catch "$alertBox(toplevelName).frame1.button0 config $tmpButtonOpt"

    pack append $alertBox(toplevelName).frame1 $alertBox(toplevelName).frame1.button0 {top}
  }

  # packing
  pack append $alertBox(toplevelName)  $alertBox(toplevelName).frame1 {bottom fill}  $alertBox(toplevelName).message1 {top fill expand}

  if {$alertBox(after) != 0} {
    after [expr $alertBox(after)*1000]  "catch 
\"$alertBox(toplevelName).frame1.button0 invoke\""
  }
}

proc Util_setSubtract { setList element } {

   set index [lsearch -exact $setList $element]
   if { $index != -1 } {
      set setList [lreplace $setList $index $index]
   }

   return $setList
}


######################################################################
# Window telling a user to log in as root
#
########################################################################

proc MustBeRoot {} {

  wm title . {Privilege Error}
  wm maxsize . 1000 1000
  wm minsize . 100 100
  # end build of toplevel

  # all keyboard inputs are directed to this window
  message .message1  \
	-anchor center \
	-justify center \
	-relief flat  \
	-text "You must be root to run this application"

  .message1 configure  -aspect 1000

  frame .frame1  -relief {sunken} -bd {2}

  button .frame1.button0  -text "Exit"  -width {8} -command "exit"
       

  # packing
  pack append .  \
              .frame1 {bottom frame center expand }  \
              .message1 {top frame center expand fill }

  pack append .frame1 \
              .frame1.button0 {bottom frame center expand}

  bind all <Return> {exit}

  tkwait window .

}


########################################################################
# This routine displays a window telling a user to log in as root
#
########################################################################

proc CheckforRoot {} {

global {SCode}

if { [CheckID] != 0 } {

     MustBeRoot
   }
}

########################################################################
# initialize_msg_dialog box which displays initialization message.
########################################################################

proc initialize_msg_dialog {} {

  global argv0

  toplevel .initWindow
  wm title .initWindow {Initializing....}
  wm maxsize .initWindow 1000 1000
  wm minsize .initWindow 100 100

  wm transient .initWindow .

  # end build of toplevel

  set x [winfo x .]
  set y [winfo y .]

  wm geometry .initWindow +$x+[expr $y + 50]
  update

  # all keyboard inputs are directed to this window
  message .initWindow.initialize_message  \
	-anchor center \
	-justify center \
	-relief flat  \
	-text "Initializing $argv0..."

  frame .initWindow.frame -relief {sunken} -bd {2}
  button .initWindow.frame.button  -text "Close"  -width {8} -command "destroy .initWindow"

  .initWindow.initialize_message configure  -aspect 1000

  # packing
  pack .initWindow.initialize_message -expand 1 -fill both
  pack .initWindow.frame -side bottom -expand 1
  pack .initWindow.frame.button -in .initWindow.frame -side bottom -expand 1

  bind all <Return> {destroy .initWindow}

}

##########################################################################
# procedure to build buttons on a window with horizontal inclination.
# Written by Lendy Dunaway
# Edited by Fauzia Abbasi
##########################################################################

proc buildDialogButtons { parentWidget args } {
	global i18nfd
	global i18nCatalog
	global symbolicName

	set toplevelWidgetName [getToplevelName $parentWidget]

	foreach dispositionButton $args {
		set buttonType "[translit a-z A-Z [crange $dispositionButton 0 0]][crange $dispositionButton 1 end]"

		# BUILD THE BUTTON...
		set symbolicName(${toplevelWidgetName}${buttonType}Button) $parentWidget.${dispositionButton}Button
		button $symbolicName(${toplevelWidgetName}${buttonType}Button) \
			-command "${toplevelWidgetName}${buttonType}Button" \
			-text ${buttonType} \
			-width 8

		pack $symbolicName(${toplevelWidgetName}${buttonType}Button) -side left -expand 1
        
##### to disable buttons commit close and ok on creation of the window

         switch -exact $dispositionButton {

              commit -
              close -
              ok { $symbolicName(${toplevelWidgetName}${buttonType}Button) \
                    configure -state disabled
              }
         }

	}
}

###########################################################################
# procedure to get name of the top level widget. If it is root, then
# mainWindow is returned.
# Written by Lendy Dunaway
###########################################################################

proc getToplevelName { widget } {

	for {set w $widget} {$w != ""} {} {
		if { $w == "." } {
			return "mainWindow"
		}
		if { [winfo class $w] == "Toplevel" } {
			return [string range $w [expr [string last "." $w] + 1] end]
		}
		set w [winfo parent $w]
	}
}


#########################################################################
# help box with buttons Yes, No and Help
#########################################################################

proc DmnConfirmBox { {dmn_msg} widget_name args } {

##
## If the optional argument is CANCEL then a fourth button called 
## Cancel will be created, which will return a -2 on invoking.
##
  global dmn_reply
  global i18nfd
  global msg_i18n_motif_shared_text

  toplevel .dmnConfirmBox 

  set master_window [getToplevelName $widget_name]

  if { [cequal $master_window {mainWindow}] } {
      set master_window .
   } else {
      set master_window ".$master_window"
   }

  wm transient .dmnConfirmBox $master_window
  wm title .dmnConfirmBox {Confirmation Box}
  wm maxsize .dmnConfirmBox 1000 1000
  wm minsize .dmnConfirmBox 100 100

  set parent_x [winfo x $master_window]
  set parent_y [winfo y $master_window]
  set parent_height [winfo height $master_window]
  set parent_width [winfo width $master_window]

  wm geometry .dmnConfirmBox \
+[expr $parent_x + [expr $parent_width / 10]]+[expr $parent_y + [expr $parent_height / 5]]
  # end build of toplevel

  grab set .dmnConfirmBox

  message .dmnConfirmBox.message1  \
	-anchor center \
	-justify center \
        -relief  ridge  \
	-text "$dmn_msg"

  .dmnConfirmBox.message1 configure  -aspect 1500

  frame .dmnConfirmBox.frame1  

  button .dmnConfirmBox.frame1.button0  \
    -text [catgets $i18nfd 1 $msg_i18n_motif_shared_text(i18n_yes_txt) {Yes}] \
    -width {8} \
    -command {
      global dmn_reply
      set dmn_reply 1
      destroy .dmnConfirmBox
      update
    }

  button .dmnConfirmBox.frame1.button1   \
    -text [catgets $i18nfd 1 $msg_i18n_motif_shared_text(i18n_no_txt) {No}] \
    -width {8} \
    -command {
      global dmn_reply
      set dmn_reply 0
      destroy .dmnConfirmBox
      update
    }

  if { $args == "CANCEL" } {
    button .dmnConfirmBox.frame1.button1a \
      -text [catgets $i18nfd 1 $msg_i18n_motif_shared_text(i18n_cancel_txt) {Cancel}] \
      -width {8} \
      -command {
	 global dmn_reply
	 set dmn_reply -2
	 destroy .dmnConfirmBox
	 update
       }
  }

  button .dmnConfirmBox.frame1.button2   \
  -text [catgets $i18nfd 1 $msg_i18n_motif_shared_text(i18n_help_txt) {Help}] \
  -width {8} \
  -command {
      global dmn_reply
      set dmn_reply -1
      destroy .dmnConfirmBox
      update
  }

  # packing
  pack append .dmnConfirmBox  \
              .dmnConfirmBox.frame1 {bottom frame center expand fill}  \
              .dmnConfirmBox.message1 {top frame center expand fill }

  pack append .dmnConfirmBox.frame1 \
              .dmnConfirmBox.frame1.button0 {left frame center expand} \
              .dmnConfirmBox.frame1.button1 {left frame center expand} 
  if { $args == "CANCEL" } {
    pack append .dmnConfirmBox.frame1 \
              .dmnConfirmBox.frame1.button1a {left frame center expand} 
  }
  pack append .dmnConfirmBox.frame1 \
              .dmnConfirmBox.frame1.button2 {left frame center expand}


  tkwait window .dmnConfirmBox

  grab release .dmnConfirmBox

  return $dmn_reply
}

##############################################################
##           sm_ procedure  ( GUI specific )                ##
##############################################################

proc sm_CreateArrows { foreground background } {
##
## This procedure creates two global images.  One called UpArrow and
## the other called DownArrow.  These two images are tk photo images.
## This procedures accepts a foreground and background color that needs
## to be used.  It will then try to build the images.  If the images fail
## to build then, it will use "white" and "black" as the foreground and 
## background.
##

  global UpArrow DownArrow

  # create temporary files to write the PM file and re-read it back in
  # as images and the delete the temp. files.
  #

  if { ![catch {set UPA [sm_sectmpopen "upa"]} err_msg ] } {
      set FUpArrow [lindex $UPA 1]  
      close [lindex $UPA 0]
  } else {
      error "$err_msg \"upa.[pid]\" while executing sm_CreateArrows\n"
  }

  if { ![catch {set DOWNA [sm_sectmpopen "downa"]} err_msg ] } {
      set FDownArrow [lindex $DOWNA 1]  
      close [lindex $DOWNA 0]
  } else {
      error "$err_msg \"downa.[pid]\" while executing sm_CreateArrows\n"
  }

  set bg $background
  set fg $foreground

  set ok 1
  while { $ok != 0 } {
    set fd [ open $FUpArrow r+ ]
    puts $fd "
/* XPM */
/* Created for sysmansh config apps */
static char * uparrow_pm\[\] = {
/* width height ncolors cpp x_hot y_hot */
\"24 24 2 1 -1 -1\",
/* colors */
\"       c $bg\",
\".      c $fg\",
/* pixels */
\"                        \",
\"                        \",
\"           ..           \",
\"          ....          \",
\"         ......         \",
\"        ........        \",
\"       ..........       \",
\"      ............      \",
\"     ..............     \",
\"    ................    \",
\"   ..................   \",
\"  ....................  \",
\"        ........        \",
\"        ........        \",
\"        ........        \",
\"        ........        \",
\"        ........        \",
\"        ........        \",
\"        ........        \",
\"        ........        \",
\"        ........        \",
\"        ........        \",
\"                        \",
\"                        \"};
"
    close $fd
    set ok [catch {set UpArrow [image create photo -file $FUpArrow]} ign ]
    if { $ok != 0 } {
      set fg "#FFFFFFFFFFFF"
      set bg "#000000000000"
    }
    catch "exec rm $FUpArrow"
  }

  set ok 1
  while { $ok != 0 } {
    set fd [ open $FDownArrow r+ ]
    puts $fd "
/* XPM */
/* Created for sysmansh config apps */
static char * downarrow_pm\[\] = {
/* width height ncolors cpp x_hot y_hot */
\"24 24 2 1 0 0\",
/* colors */
\".      c $fg\",
\"a      c $bg\",
/* pixels */
\"aaaaaaaaaaaaaaaaaaaaaaaa\",
\"aaaaaaaaaaaaaaaaaaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aa....................aa\",
\"aaa..................aaa\",
\"aaaa................aaaa\",
\"aaaaa..............aaaaa\",
\"aaaaaa............aaaaaa\",
\"aaaaaaa..........aaaaaaa\",
\"aaaaaaaa........aaaaaaaa\",
\"aaaaaaaaa......aaaaaaaaa\",
\"aaaaaaaaaa....aaaaaaaaaa\",
\"aaaaaaaaaaa..aaaaaaaaaaa\",
\"aaaaaaaaaaaaaaaaaaaaaaaa\",
\"aaaaaaaaaaaaaaaaaaaaaaaa\"};
"
    close $fd
    set ok [catch {set DownArrow [image create photo -file $FDownArrow]} ign ]
    if { $ok != 0 } {
      set fg "#FFFFFFFFFFFF"
      set bg "#000000000000"
    }
    catch "exec rm $FDownArrow"
  }

}

##############################################################
##           sm_ procedures ( non ui specific )             ##
##############################################################

proc sm_GetHostName {str} {

## str = Name of the application.
## Get the hostname, if found then append it to the str and return it, 
## else return the str.
## Value returned is result.

    global i18nfd
    global msg_i18n_motif_shared_text
    global msg_i18n_motif_shared_text_LocIds
    global i18n_motif_shared_text_dstr

    set on_text [catgets $i18nfd \
	   $msg_i18n_motif_shared_text(i18n_shared_strings) \
	   $msg_i18n_motif_shared_text(i18n_on_txt) \
	   $i18n_motif_shared_text_dstr(i18n_on_txt)]

        set host_name [sm_GetID]
	if { [string length $host_name] } {
       	  set result "$str $on_text $host_name"
	} else {
	  ##
	  ## empty hostname
	  ##
	  set result $str
        }

      return $result
}

proc sm_stripdots {str} {
##
## strip trailing dots
## Useful for cannonizing a hostname
##

    set pre ""
    regexp {^(.*[^.])\.*$} $str match pre
    return $pre
}


proc sm_IsDomainToken {str} {
##
## Check for RFC952 compatible syntax for a hostname token.
## It is [a-zA-Z0-9][-a-zA-Z0-9]*[a-zA-Z0-9]
## with the proviso that [0-9]* or a trailing "-" is illegal
##
## Returns 1 upon success and 0 otherwise
##

    if {![regexp {^[abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0-9]} $str] || \
	    ([cequal [cindex $str end] "-"]) \
	    || ![regexp {^[-abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0-9]+$} $str] \
    || [regexp {^[0-9]*$} $str]} {
        return 0
    }
    return 1
}

proc sm_IsDomainName {str} {
##
## Check for a valid domain name component in the hostname token
##
## Returns 1 upon success and 0 otherwise
##
    set str [sm_stripdots $str]
    if {$str == ""} {
	return 0
    }
    foreach token [split $str .] {
	if {![sm_IsDomainToken $token]} {return 0}
    }
    return 1
}

###
# Get rid of all .., . and ~ in a file path
# (Helper routine for sm_mkCDSL)
proc canonicalPath {filename} {
    # replace ~ or ~userid with home directory
    if { [regexp {^~[^/]*} $filename match] } {
	  regsub {^~[^/]*} $filename [glob $match] filename
    }

    # elide leading ./
    if { [pwd] == "/" } {
	# if at root, ./ becomes /
	set subst "/"
    } else {
	# ./ is removed
	set subst "" 
    }
    regsub {^\./} $filename $subst filename

    # if relative path, make it absolute
    if { [file pathtype $filename] == "relative" } {
	set filename "[pwd]/$filename"
    }

    # /./ becomes /
    regsub -all {/\./} $filename "/" filename
    # elide dir/../
    while {[regsub {[^/]+/\.\./} $filename "" filename]} {}
    # double slashes become single
    while {[regsub -all {//} $filename "/" filename]} {}
    # initial /../ becomes /
    while {[regsub {^/\.\./} $filename "/" filename]} {}

    return $filename
}

###
# Return how far down the directory tree the file sits.
# Assumes a canonicalized path
# (Helper routine for sm_mkCDSL)
proc fileDepth {filename} {

    set pieces [file split $filename]
    set count [llength $pieces]

    # leave out initial / and the filename itself
    return [expr $count - 2]
}

###
# isMemberSpecific takes a file path as its argument.
# It returns 1 if the file is a CDSL or if any directory
# in its path is a CDSL.
#
# NOTES: 
#   The filepath should be absolute (ie, starting
#   with / and with no .. parts).
# 
#   We don't check for links to links.  In other words,
#   if a points to b points to c (a -> b -> c), then
#   we only check if b has {memb} and not c or beyond.
#
proc isMemberSpecific {fname} {
    # Does fname have an explicit {memb} in it?
    if { [string match "*/{memb}/*" $fname] } {
	return 1
    }

    while { !([cequal $fname /] || 
	      [cequal $fname {}] || 
	      [cequal $fname .]) } {

	# Is fname a link?
	if {[file exists $fname] && 
	    [cequal [file type $fname] link] } {
	    # Get the name that link points to (lname)
	    set lname [file readlink $fname]

	    # Does lname have an explicit {memb} in it?
	    if { [string match "*/{memb}/*" $lname] } {
		return 1
	    }
	}

	# Take off the last component of fname and 
	# see if the remaining path is a CDSL
	set fname [file dirname $fname]
    }
    return 0
}
	     
###
# Given a filename return the path to the member-specific 
# file.  CDSLs should use relative paths (the default).
# (Helper routine for sm_mkCDSL)
proc memberFilename {filename {type {relative}} } {
    if { !([cequal $type relative] || [cequal $type absolute]) } {
	set emsg "Bad argument passed to memberFilename: $type"
	set emsg "$emsg\nshould be \"relative\" or \"absolute\""
	error \$emsg
    }

    # This is the absolute path to the (potential) link
    set absFilename [canonicalPath $filename]

    # No need to create a link if the directory is
    # already member specific
    if { [isMemberSpecific $absFilename] } {
	return $filename
    }

    # We need to make the CDSL relative, so we need
    # to know how many levels of directories lie
    # between the link and the top of the filesystem
    set depth [fileDepth $absFilename]
    set match "/"
    if { [regexp {^/(usr|var)/} $absFilename match] } {
	# match contains /usr/ or /var/

	# strip off /usr or /var
	set memberFile [string range $absFilename 4 end]

	#depth doesn't include /var or /usr
	incr depth -1

    } else {
	# match contains /

	set memberFile $absFilename
    }

    if { [cequal $type absolute] } {
	# return absolute path
	return ${match}cluster/members/{memb}$memberFile

    } else {
	# dots contains the relative part of the path
	for {set dots ""} {$depth > 0} {incr depth -1} {
	    set dots "${dots}../"
	}

	# return relative path
	return ${dots}cluster/members/{memb}$memberFile
    }
}

###
# This routine should be used to create a CDSL whenever it is needed.
# It will create a CDSL called linkname that points to
# the proper member specific file.  The linkname can be any valid
# file path.  The characters ~, .. and . will be handled correctly.
# The link will be made relative to the proper cluster/members/{memb}
# directory.
#
# Arguments:
#   linkname = filename of cdsl (ex: /etc/resolv.conf)
#   mkFileForNonCluster: non zero means make empty file
#                        for presteel compatibility
#
proc sm_mkCDSL {linkname {mkFileForNonCluster 0}} {

   if ![file exists $linkname] {
      if [file exists "/cluster"] {

	 set memberFile [memberFilename $linkname]
	 # If linkname is in a directory that is itself
	 # a CDSL, or a directory farther up the tree is
	 # a CDSL, then memberFilename returns the
	 # linkname.  In this case, do not make a link, 
   	 # just make the file itself.
	 if { [cequal $memberFile $linkname] } {
	    set res [catch {exec touch $linkname} msg]
	    if {$res != 0} {return $msg} {return 0}
	 }

	 set res [catch {exec ln -s $memberFile $linkname} msg]
	 if {!$res} {return $msg} {return 0}
      } else {
	 # On pre-steel systems, just make the file
	 if {$mkFileForNonCluster != 0} {
	    set res [catch {exec touch $linkname} msg]
	    if {$res != 0} {return $msg} {return 0}
	 }
      }
   }
}
