#!/bin/sh
#
# This script does the following two things:
#  1) removes directories that are older than $ARCHIVE_DAYS
#  2) compresses old log files
#

PATH=/usr/bin:/usr/sbin:/sbin:/bin
export PATH

get_inode()
{
	INODE=`ls -id $1 | awk '{print $1}'`

	echo ${INODE}
}

PROGNAME=`basename $0`
CMF_DIR=/usr/opt/ams/logs/cmf.dated
CURRDIR=${CMF_DIR}/current/.
CURRDIR_INODE=`get_inode ${CURRDIR}`
ARCHIVE_DAYS=30

# Change directory to the log directory.
cd ${CMF_DIR}

#############################################################################
# Remove directories older than ${ARCHIVE_DAYS}.
#############################################################################

echo "Searching ${CMF_DIR} for log files to remove ..."

# Find all the directories that are older than "$ARCHIVE_DAYS".
for DIR in `find . -mtime +$ARCHIVE_DAYS -type d`
do
	# Skip the directory that the "current ->" symlink is pointing to.
	if [ "${CURRDIR_INODE}" = "`get_inode ${DIR}`" ]
	then
		continue
	fi

	# Verify that this is one of the log directories created by "cmfd".
	case $DIR
	in
		*-Jan-*) IS_LOG_DIR=1;;
		*-Feb-*) IS_LOG_DIR=1;;
		*-Mar-*) IS_LOG_DIR=1;;
		*-Apr-*) IS_LOG_DIR=1;;
		*-May-*) IS_LOG_DIR=1;;
		*-Jun-*) IS_LOG_DIR=1;;
		*-Jul-*) IS_LOG_DIR=1;;
		*-Aug-*) IS_LOG_DIR=1;;
		*-Sep-*) IS_LOG_DIR=1;;
		*-Oct-*) IS_LOG_DIR=1;;
		*-Nov-*) IS_LOG_DIR=1;;
		*-Dec-*) IS_LOG_DIR=1;;
		      *) IS_LOG_DIR=0;;
	esac

	if [ ${IS_LOG_DIR} -eq 1 ]
	then
		rm -rf ${DIR}

		if [ $? -eq 0 ]
		then
			echo "${PROGNAME}: Removed ${DIR}"
		fi
	fi
done

#############################################################################
# Compress old log files.
#############################################################################

echo "Searching ${CMF_DIR} for log files to compress ..."

# Find all directories.
for DIR in `find . -type d`
do
	# Skip the directory that the "current ->" symlink is pointing to.
	if [ "${CURRDIR_INODE}" = "`get_inode ${DIR}`" ]
	then
		continue
	fi

	# Verify that this is one of the log directories created by "cmfd".
	case ${DIR}
	in
		*-Jan-*) IS_LOG_DIR=1;;
		*-Feb-*) IS_LOG_DIR=1;;
		*-Mar-*) IS_LOG_DIR=1;;
		*-Apr-*) IS_LOG_DIR=1;;
		*-May-*) IS_LOG_DIR=1;;
		*-Jun-*) IS_LOG_DIR=1;;
		*-Jul-*) IS_LOG_DIR=1;;
		*-Aug-*) IS_LOG_DIR=1;;
		*-Sep-*) IS_LOG_DIR=1;;
		*-Oct-*) IS_LOG_DIR=1;;
		*-Nov-*) IS_LOG_DIR=1;;
		*-Dec-*) IS_LOG_DIR=1;;
		      *) IS_LOG_DIR=0;;
	esac

	if [ ${IS_LOG_DIR} -eq 1 ]
	then
		# Compress all the log files in the directory.
		for LOGFILE in `ls ${DIR}/*.log`
		do
			# Only attempt to compress the file if its size is > 0.
			if [ -s ${LOGFILE} ]
			then
				compress ${LOGFILE}

				if [ $? -eq 0 ]
				then
					echo "Compressed ${LOGFILE}"
				fi
			fi
		done 2> /dev/null
	fi
done
