#
# --- the callback file for the PCM user interface
#

pcm proc initCB {} {
#
# --- check if the user is 'privileged'
#
# set isRoot [ expr [CheckID] == 0 ]
# if { !$isRoot } {
# 	InfoMsg error \
# 	[ pcm catget notroot msg ] \
# 	[ pcm catget notroot title ] wait
# 	exit
# 	}
}

#
# --- Trap SIGUSR1 signal and update the
# --- list of systems in the main window
if { [ infox have_signal_restart ] } {
        signal -restart trap SIGUSR1 {
                update_console_list
        }
} else {
        signal trap SIGUSR1 {
                update_console_list
        }
}

w1 proc initCB {} {
	global cfile
	global evfiledir
	global conslogf
	global ams_event
	global amsmgr
	global sock
	global cookiefile
	global noconnection
	global wait_on_cmfd_restart
	global errorCode
	global cmfd_cmd
	global conslogf
	global modelsf
	global ostypef
	global parent
	global conslogf_inode
#	global pcmlockf
        global max_console_lines
	global is_regex
	global amsconf_file
	global arch_var

	global mbm_suf  	# Suffix for MBM console
	global ts_suf 		# Suffix for Wildfire TS console
	global templatesf   #the marvel templates file

	set count 0
#	--- a socket connection handle used to obtain console status
	set sock 0
#	--- noconnection == 1 indicates a connection
#	--- noconnection == 0 indicates NO connection
	set noconnection 0
	set wait_on_cmfd_restart 0

#       --- the cmfd configuration file
   	set cfile /usr/opt/ams/config/cmf.conf
#       --- the cmfd event pattern matching files directory
	set evfiledir /usr/opt/ams/events
#       --- the cmfd cookie file
   	set cookiefile /usr/opt/ams/config/.cookie
#	--- the cmf daemon script
	set cmfd_cmd /etc/init.d/cmfd
#	--- the consolidated console log file which contains all
#           console output from all managed systems
	set conslogf /usr/opt/ams/logs/cmf.dated/current/consolidated.log
	set conslogftmp /usr/opt/ams/logs/cmf.dated/current/consolidated.log.tmp
#	set pcmlockf /usr/opt/ams/config/.pcm_lock
	set modelsf /usr/opt/ams/config/models
	set ostypef /usr/opt/ams/config/ostypes
	set amsconf_file "/usr/opt/ams/config/ams.conf"
	set arch_var "CMFD_ARCH_INT"
	set templatesf /usr/opt/ams/config/templates

#       --- the type of EVM event posted on console events
	set ams_event ams.cmfd.console
#       --- the amsmgr command
	set amsmgr "/usr/opt/ams/bin/amsmgr "
#	--- the utility to validate a regular expression
	set is_regex "/usr/opt/ams/bin/is_regex"

	# Suffix for MBM and TS consoles.
	set mbm_suf _MBM
	set ts_suf _TS	

        # Maximum number of console lines that our List Widget will show.
        set max_console_lines 100

	set l {}

#	if { [ file exists $pcmlockf ] } {
#           InfoMsg "warning" \
#                    [pcm catget anotherpcm msg] \
#                    [pcm catget pcm_general_warning title] wait
#	} else {
#	   set retval [ catch { exec touch $pcmlockf } ]
#
#          --- not a problem if the above fails... just no
#              lock file.
#	}
#
#	--- the cmf.conf file should always be generated on startup. 
#           Any cmf.conf file in existence should always be 
#           considered unreliable.
#
        set retval [catch { eval exec $amsmgr -write cmfconf } output ]

#       --- Check for failure.
        if { $retval != 0 } {
	   set errorNum [lindex $errorCode 2]
	   if { $errorNum == "permission denied" } {
              InfoMsg "error" \
                    [pcm catget notroot msg] \
                    [pcm catget pcm_general_error title] wait
	      exit 0
	   } elseif { $errorNum >= 20 && $errorNum < 40 } {
#	   --- error codes between 20 and 40 mean that there
#	       is invalid data or formatting in the XML file
              InfoMsg "error" \
                    [pcm catget invalid_xml msg] \
                    [pcm catget pcm_general_error title] wait
	      return
	   } else {
#	   --- something seriously wrong on the system
	      general_error
	      return
	   }
        }

	set system_count 0
#
#       --- open the cmf.conf file
	set retval [ catch { open $cfile r} InFile ]
	if { $retval != 0 } {
	   general_error
	   return
	}
#
#	--- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {

		# Get rid of leading whitespace.
	        set line [string trimleft $line " \t"]

		# If the line contains a comment then skip it.
		if { [string compare -length 1 $line "#"] == 0 } {
			continue
		}
		# if the line is blank, skip it
		if { [string length $line] == 0 } {
		   continue
		}

		# Parse the fields.

		set system [ctoken line " \t"]
		set address [ctoken line " \t"]
		set port_num [ctoken line " \t"]
		set mgmt_port_num [ctoken line " \t"]
		set mapped_port [ctoken line " \t"]
		set plat_type [ctoken line " \t"]
		set plat_name [ctoken line " \t"]
		set skipspace [ctoken line "\""]
		set ostype [ctoken line "\""]
		set skipquote [ctoken line " \t"]
		set logging [ctoken line " \t"]
		set eventgen [ctoken line " \t"]
		set enable [ctoken line " \t"]
		set auth [ctoken line " \t"]
		set evfile [ctoken line " \t"] 


		# The last field should be the comments. Get rid of 
		# leading and trailing quotes.

		set skipspace [ctoken line "\""]
		set comments [ctoken line "\""]
		set comments [string trim $comments]
# we need to set the description back to empty for display purproses
		if { [string compare $comments "none"] == 0 } {
			set comments ""
		}
			

		# Display the appropriate string in the Console field.
 
		if { [string compare $port_num $mgmt_port_num ] == 0 && 
		     [getSeriesOfModel $plat_type ] == "M" } { 
			append system $mbm_suf
		} elseif { [string compare $port_num $mgmt_port_num ] == 0 &&
		     [getSeriesOfModel $plat_type ] == "W" } { 
			append system $ts_suf
		}

		# Put the items we are going to display in a list.
		set systems_list [list $system $plat_name $plat_type \
				  "" $comments]

		# Add the items to the list window.
		$self.m_sys setListItem l $systems_list 1
		
		incr system_count
	}
	close $InFile

	$self.m_sys setVal $l

	if { $system_count == 0 } {
                InfoMsg "info" \
                    [pcm catget pcm_no_entries msg] \
                    [pcm catget pcm_no_entries title] wait
        }

# --- set values for the console log list (c_out)

	set l {}

#
#	--- Lets assume that each line in consolidated log file has 
#	    at the max 100 characters. As console log list will display
# 	    max_console_lines, set max_console_chars as 100 times
#	    max_console_lines. 
	set max_console_chars [ expr $max_console_lines * 100 ]

#
#	---  find the size of consolidated log file
	if { [ file exists $conslogf ] } {
           set log_filesize [ exec cat $conslogf | /usr/bin/wc -c ]

           set retval [ catch { open $conslogf "r" } fd ]

           if { $retval == 0 } {
              fconfigure $fd -blocking false 

# 	--- If the consolidated log file has more than max_console_chars 
#	    characters, read the last max_console_chars characters from 
#	    the consolidated log file.
              if { $log_filesize > $max_console_chars} {
                   seek $fd -$max_console_chars end
              }

              # Get the log file's inode.
              set conslogf_inode [fstat $fd ino]
#
#	   --- first time through the file, set the number of
#              lines to be read to the number of lines in the file
              fileevent $fd readable [list getIO $fd $self]
	   } else {
               after 1000 [list getIO "" $self]
	   }
        } else {
            after 1000 [list getIO "" $self]
	}

#	--- update the console status in the list box by
#	--- calling -> get_status_for_all_consoles -> which
#	--- in turn calls -> compare_status -> which in turn
#	--- calls -> update_console_status -> which will do
#	--- the actual modifying of status in the list box
#	--- The breakup is done to improve the performance
#	--- of pcm when updating the status in the list box.
	get_status_for_all_consoles

}

# --- proc to read lines from the log file and update the 
#     console output list

proc getIO {fd self} {

    global conslogf
    global conslogf_inode
    global max_console_lines
    global new_messages_list
    global last_time_we_read_data
    global num_msgs_since_last_update

    # Initialize the variable that tells us the last time that we read some
    # data from the consolidated log file. We use this variable to identify
    # whether a small period of time has gone by when no new data has been
    # written to the consolidated log file. Once we know that we are not being
    # flooded with data, then we can go ahead and update the list widget with
    # the last 100 messages that we received.
    if { ![info exists last_time_we_read_data] } {
        set last_time_we_read_data 0
    }

    # Initialize the variable that tells us how many messages we've read since
    # we last update the list widget with messages. If PCM gets flooded with
    # a large amount of messages, we cannot possibly display them all in the
    # list widget because updating the list widget is an expensive operation
    # that causes the user interface to freeze.  However, we must still
    # display some messages to give the user some sense of what's going on
    # in the console. So, in order to strike a balance, we will update the
    # list widget after 1000 messages have been read since the last time
    # we update the list widget.
    if { ![info exists num_msgs_since_last_update] } {
        set num_msgs_since_last_update 0
    }

    # Initialize the list the first time through.
    if { ![info exists new_messages_list] } {
        set new_messages_list {}
    }

    # If the consolidated log file has not been opened, then open it first.
    # One reason why we don't have a file descriptor is because cmfd may be
    # in the middle of archiving the old log file and has not created the 
    # new log file yet.
    if { $fd == "" } {
        set retval [ catch { open $conslogf "r+" } fd ]

        if { $retval == 0 } {

            # Get the log file's inode.
            set conslogf_inode [fstat $fd ino]

            fconfigure $fd -blocking false
            fileevent $fd readable [list getIO $fd $self]
        } else {
            # Since "fd" will contain the error message from the "open", we
            # need to set it back to an empty string so that we know that we
            # still don't have a valid file descriptor.
            set fd ""

            # The opened failed. Perhaps cmfd is in the middle of archiving
            # the old log file and has not had a chance to create the new
            # log file. Let's call "getIO" in a little while and hopefully
            # we'll be able to open the log file the next time around.
            after 1000 [list getIO $fd $self]
            return
        }
    }

    # read a line
    set len [gets $fd line]

    # We've reached the End-of-File. This means that, for the moment, no new
    # messages are being written to the consolidated log file. Since the flow
    # of messages has stopped, now is a good time to update the List Widget
    # with the most current messages.
    if [expr $len < 0] {

        # Do we have any new messages waiting to be put into the List Widget?
        if { ![ lempty $new_messages_list ] } {

            set time_now [ clock seconds ]

            # When messages are coming in too fast, we want to make sure that
            # we don't update the list widget too often because it is an
            # expensive operation which freezes the user interface.  We will
            # only update the list widget under two conditions:
            #    1) We have not seen any new messages in the last second. 
            #       OR
            #    2) 1000 messages have been received.  Even when messages are
            #       coming in very fast, we still need to refresh the list
            #       widget with some of the new messages so that the user can
            #       get some sense of what's going on in the console. Because
            #       the Terminal Server speed can be quite slow, if the
            #       console spits out 100,000 messages, it can be a very long
            #       time before they all reach PCM.  So, we'll update the
            #       list widget every 1000 messages when the messages are
            #       coming in quickly so as not to display stale messages on
            #       the list widget.
            if { $time_now - $last_time_we_read_data < 1 && \
                 $num_msgs_since_last_update < 1000 } {
                fileevent $fd readable {}
                after 1000 [list getIO $fd $self]
                return
            }

            # How many new messages do we have?
            set num_new_lines [ llength $new_messages_list ]

            # How many messages are already being displayed in the list widget?
            set num_items_in_list_wid [ $self.c_out sizeOfList ]

            # What would our total messages be?
            set total_lines [expr $num_new_lines + $num_items_in_list_wid]

            # If we have more new messages than the maximum we can display
            # then clear the list widget of all its old messages so we can
            # fill it up with the new messages.
            if { $num_new_lines >= $max_console_lines } {

                $self.c_out clear

            } elseif { $total_lines > $max_console_lines } {

                # We cannot fit all the messages in the list widget, so we must
                # get rid of some of the old messages to make room for the new.
                set num_lines_to_delete [expr $total_lines - $max_console_lines]

		set last_item [expr $num_lines_to_delete - 1]

                # Delete the excess old messages.
                $self.c_out deleteDspStr 0 $last_item
            }

            for { set i 0 } { $i < $num_new_lines } { incr i } {
                putMessageInListWidget $self [lindex $new_messages_list $i]
            }

            # Empty the new messages list.
            set new_messages_list {}

            # We just updated the list widget so we must reset the count.
            set num_msgs_since_last_update 0
        }

        # The end-of-file has been reached. Disable fileevent 
	# because it will cause "getIO" to get called repetitively 
	# when there is no data to be read. Almost seems like it 
	# serves no purpose. We'll disable it and set a timer down 
	# below so that "getIO" will get called once again after 
	# some reasonable amount of time has elapsed.
        fileevent $fd readable {}

        # Do a "stat" to get the inode of the log file. We need 
	# this to find out if the reason we are getting an EOF 
	# is because the log file was archived by cmfd. If so, 
	# then we would be trying to read from the archived log 
	# file to which no data is being written to.
        set retval [ catch { file stat $conslogf statVar } ]

        # Check if our "stat" was successful. If it wasn't 
	# successful, it is possible that cmfd has archived 
	# the old log file and has not had a chance to create 
	# the new log file.
        if { $retval == 0 } {
            set inode $statVar(ino)
        } else {
            set inode 0
        }

        # Since "cmfd" archives the log file periodically and 
	# creates a new one, we need to know if our file 
	# descriptor has become stale due to a new log file 
	# being created. We check if our file descriptor
        # is stale by comparing the inode of the log file 
	# we opened to the inode of the current log file. If 
	# they are different, then we need to reopen the file 
	# and get a new file descriptor.
        if { $conslogf_inode != $inode } {

            # The original log file was moved and a new one has 
	    # been created. Therefore, the file descriptor we 
	    # have is stale. Close it.
            close $fd

            # This file descriptor is no good anymore since it now 
	    # refers to an old log file. By setting it to an empty 
	    # string, we force an "open" on the new log file the 
	    # next time "getIO" gets called. We could have tried 
	    # to open the new log file here but we could have 
	    # possibly run into a timing situation where the new 
	    # log file has not yet been created by cmfd.
            set fd ""

            # Save the new inode.
            set conslogf_inode $inode
       }

       # We have reached the end-of-file for now. We'll check again in a
       # little while to see if there is any new data to be read.
       after 1000 [list getIO $fd $self]
    } else {

        set count 1

        # Read up to 50 messages at a time in order to strike a balance
        # between keeping up with incoming messages and giving the user
        # interface some cycles in which it can respond to user input or
        # other events.
        while { $count <= 100 && $len >= 0 } {

            # Check if list is full.
            if { [ llength $new_messages_list ] == $max_console_lines } {
                set new_messages_list [lrange $new_messages_list 1 $max_console_lines]
            }

            # Add the message to the message list.
            lappend new_messages_list $line

            # Read the next line from the file.
            set len [gets $fd line]

            # Increment the count.
            incr count

            # Increment the number of messages we've seen since we last
            # updated the list widget.
            incr num_msgs_since_last_update
        }

        set last_time_we_read_data [ clock seconds ]

        # Is it EOF?
        if { $len < 0 } {
            # We have finished reading all incoming messages so we will
            # ask to be notified when new messages get written to the
            # consolidated log file.
            fileevent $fd readable [list getIO $fd $self]
        } else {
            # At this point, we have not read all of the file. The reason
            # why we don't try to read all the messages at once is because
            # if we get flooded with messages then the user interface will
            # freeze while we read the messages, which is not good. So, to
            # strike a balance between keeping up with incoming messages and
            # giving the user interface time to respond to user input or
            # other events, we will set a timer of 10ms so as to give the
            # user interface some cycles.
            fileevent $fd readable {}
            after 10 [list getIO $fd $self]
        }
    }
}

proc putMessageInListWidget { self line } {

    global max_console_lines

    # Find out how many items (console messages) are in the List Widget.
    set num_items [ $self.c_out sizeOfList ]

    # If we already have the maximum number of lines, then delete the first
    # one (i.e. the oldest line) to make room for the next one.
    if { $num_items >= $max_console_lines } {
        $self.c_out deleteDspStr 0
    }

    # Format the console message to be displayed put it into a
    # a Tcl list as required by the SUIT List Widget.
    set l {}
    append l "[format "%-18.18s" [ctoken line " \t"]]"
    append l "[format "%-16.16s" [ctoken line " \t"]]"
    append l "[format "%s" [string trim $line " \t"]]"

    # Add the item to the end of the List Widget.
    $self.c_out setListItem linedsp $l {}

    if ![lempty $linedsp] {
        $self.c_out insertDspStr end $linedsp
        $self.c_out setViewable end
    }
}

logwait proc displayCB {} {
#	w1 display
	after 4000 [logwait hide]
}

w1.exit proc invokeCB {} {
#	global pcmlockf
#
#       --- remove the lock file that tells PCM if another PCM
#           is running
#	if { [ file exists $pcmlockf ] } {
#	   set retval [ catch { exec rm $pcmlockf } ]
#
#           if { $retval != 0 } {
#              InfoMsg "error" \
#                  [pcm catget deletelockf msg] \
#                  [pcm catget pcm_general_error title] wait
#	   }
#	}
	exit
}

w1.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn MainWindow
}

#
# --- proc for connect button click
w1.m_sys.b_connect proc invokeCB {} {
	global hostname
	global platname
	global useplatnameflag
	global model
	global status
	global force_console_name
	global port_holder_ipaddr
	global mbm_suf
	global ts_suf

	set self w1.m_sys

# --- get currently selected list item
# --- parse the hostname out of the string

	set disp_str [$self getCurSelection]

	# The display string is in the form of key list.
	set keylist [lindex $disp_str 0]
	set key [lindex $keylist 0]

	# Hostname is the first element of the key.
	set hostname [lindex $key 0]
	set platname [lindex $key 1]
	set model [lindex $key 2]
	set status [lindex $key 3]

#	--- If the console name in main window is displayed platformname_MBM
#	--- or platformname_TS, we need to pass the platform name to get the
#	--- status information and this is indicated by setting the
#	--- flag useplatnameflag to 1.
	set useplatnameflag 0

	if { [string compare $hostname $platname$mbm_suf] == 0 
	     || [string compare $hostname $platname$ts_suf] == 0 } {	
		set useplatnameflag 1
		
	}
	if { [string compare $status [ pcm catget console disabled ] ] == 0 } {
		InfoMsg "error" \
		   [pcm catget cannot_connect msg] \
		   [pcm catget pcm_general_error title] wait
		return
	}

	if { $status == "Refused" } {
	    if { [getSeriesOfModel $model ] == "M" } {
		if { $useplatnameflag } {
			set force_console_name $platname
		} else {
			set force_console_name $hostname
		}
		
		set port_holder_ipaddr [ get_port_holder_ipaddr ]
		if { $port_holder_ipaddr != -1 } {
			force_conn_d display
		}
	    } else {
		if { $useplatnameflag } {
			set force_console_name $platname
		} else {
			set force_console_name $hostname
		}
		force_conn_wf_d display
	    }
	} else {
		connect_d display
	}
}

#
# --- proc for console button click
w1.m_sys.b_console proc invokeCB {} {
	global hostname
	global platname
	global model
	global status
	global useplatnameflag
	global mbm_suf
	global ts_suf

	set self w1.m_sys

# --- get currently selected list item
# --- parse the hostname out of the string

	set disp_str [$self getCurSelection]

	# The display string is in the form of key list.
	set keylist [lindex $disp_str 0]
	set key [lindex $keylist 0]

	# Hostname is the first element of the key.
	set hostname [lindex $key 0]
	set platname [lindex $key 1]
	set model [lindex $key 2]
	set status [lindex $key 3]

#	--- If the console name in main window is displayed as platformname_MBM
#	--- or platformname_TS, we need to pass the platform name to get the
#	--- status information and this is indicated by setting the
#	--- flag useplatnameflag to 1.
	set useplatnameflag 0

	if { [string compare $hostname  $platname$mbm_suf] == 0
	    || [string compare $hostname $platname$ts_suf] == 0 } {
		set useplatnameflag 1
	}

	cons_d display
}

# --- proc for events button click
w1.m_sys.b_events proc invokeCB {} {
        events_d display
}

# --- proc for events dialog
events_d.ok proc invokeCB {} {

	global SysmanUi
	global evfiledir

	set arglist [list -accel event_viewer -filter "\[name ams.*\]"]

	set chosen_opt [events_d.opts getVal]

	events_d hide

	if { $chosen_opt == "view" } {
#          --- command changes based on type of display
		if { $SysmanUi == "menu" } {
			ctk_endwin
			if { [set pid [fork]] == 0 } {
#             --- start up the event viewer with a filter for 
#                 ams type events
				set cmd [execl /usr/bin/sysman $arglist]
			}
			wait $pid
			ctk_refresh
#
#          --- in graphics (X) mode
		} else {
			bgexec stat /usr/bin/sysman -accel event_viewer \
				-filter "\[name ams.*\]" &
		}
	} elseif { $chosen_opt == "create" } {
		events_create_d display
	} elseif { $chosen_opt == "modify" } {
		if { [string length [readdir $evfiledir] ] == 0 } { 
			InfoMsg error \
			   [pcm catget modify_evfile_err msg] \
			   [pcm catget pcm_general_info title] wait
		} else {
			events_modify_d display
		}
	} elseif { $chosen_opt == "delete" } {
		if { [string length [readdir $evfiledir] ] == 0 } { 
			InfoMsg error \
			   [pcm catget delete_evfile_err msg] \
			   [pcm catget pcm_general_info title] wait
		} else {
			events_delete_d display
		}
	}
}

events_d.cancel proc invokeCB {} {
	events_d hide
}

events_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn EventsDB 
}

events_create_d proc displayCB {} {
# --- create window should not show the previous file
#     created and its contents 

	$self.evfile setVal "" 
	$self.pat_list clear 
}

events_create_d.ok proc invokeCB {} {
	global evfiledir
	global ams_event 
	global parent 
	set self events_create_d
	set parent events_create_d

# --- check whether the event definition file name has been given

	if { [ string length [$self.evfile getVal] ] == 0 } {
		InfoMsg error \
		   [pcm catget nodataerror msg] \
		   [pcm catget nodataerror title] wait
		return -1
	}
# --- check whether file name given is valid
	set retval [is_valid_event_file_name]
	if { $retval != 0 } {
		InfoMsg error \
		   [pcm catget invalidfilename msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
	}
	set evfile [$self.evfile getVal]
# --- create the events file name
  	set efile [ cconcat \
               	$evfiledir/$evfile ]

	if { [file exists $efile] } {
		InfoMsg error \
		   [pcm catget file_exists msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
        } 
	set listSize [$self.pat_list sizeOfList]
# --- event definition file cannot be empty
	if { $listSize == 0 } {
               	InfoMsg error \
		   [pcm catget empty_evfile msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
# --- copy the list contents to the event definition file
	}
	set InFile [open $efile w]
	for { set i 0 } { $i < $listSize } { incr i } {
		set item [$self.pat_list  getDspStr $i]
		set item [lindex $item 0]
		set item  [lindex $item 0]
		# pattern strings which has space in between will 
		# have curly braces around them.
		if { [string compare -length 1 $item "\{" ] == 0 } {
			set item [ string trim $item "\{"]
			set pattern [ ctoken item "\}"] 
			set skipover [ctoken item " "]
			set priority [ ctoken item " "] 
			set displayCase [ ctoken item " "] 
		} else {
			scan $item "%s %s %s" pattern priority displayCase
		}
		if { [string compare $displayCase [pcm catget case yes]] == 0 } {
			set case 1
		} else {
			set case 0
		}
		set newpat [concat \
        		$ams_event \
               		$priority \
			$case \
               		$pattern] 
		puts $InFile $newpat
	}
	close $InFile
	chmod 0770 $efile
	chgrp amsuser $efile
	InfoMsg "info" \
		[pcm catget pcm_create_evfile msg] \
		[pcm catget pcm_general_info title] wait
	$self hide
}

events_create_d.cancel proc invokeCB {} {
	events_create_d hide
}

events_create_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn EventsCreateDefnDB 
}

# --- proc for event definition file add dialog
events_create_d.pat_list.add proc invokeCB {} {
	events_create_add_d display
}


# --- proc for event modify dialog
events_create_d.pat_list.modify proc invokeCB {} {
	events_create_mod_d display
}


# --- proc for event import dialog
events_create_d.pat_list.import proc invokeCB {} {
	global evfiledir
# --- If there are no event definition files , display an error window 
	if { [string length [readdir $evfiledir] ] == 0 } {
		InfoMsg error \
		   [pcm catget import_evfile_err msg] \
		   [pcm catget pcm_general_info title] wait
		return -1
	}
# --- The import button may be invoked only if the pattern list is empty 
	if { [events_create_d.pat_list sizeOfList] != 0 } {
		InfoMsg error \
		   [pcm catget import_error msg] \
		   [pcm catget pcm_general_info title] wait
		return -1
	} else {
		events_create_import_d display
		
	}
}

# --- proc for importing the events
events_create_import_d proc  displayCB {} {
	global evfiledir

# --- read the contents of the directory and create a list of all files
	set filelist {}
	foreach entry [readdir $evfiledir] {
		if { [ file isfile [cconcat $evfiledir/$entry] ] } {
			$self.evfile_list setListItem filelist $entry ""
		}
	}
	$self.evfile_list setVal $filelist
}

# --- proc for displaying the contents of the events file in the import window
events_create_import_d.evfile_list proc doubleClkCB {} {
	global parent

	set parent events_create_import_d
	# call the proc which will actually display the contents
	displayContents
}

# --- proc for importing the contents of an event definition file
events_create_import_d.ok proc invokeCB {} {
	set self events_create_import_d
	global parent
	global evfiledir

	set parent events_create_d
# --- check whether something was selected
	if { [$self.evfile_list selectedItemCount] > 0 } {
		# call the proc which will actually display the contents
		$self hide	
		displayContents
	} else {
		InfoMsg error \
		   [pcm catget noselectionerror msg] \
		   [pcm catget noselectionerror title] wait
	} 
}

proc displayContents {} {
	global evfiledir
	global parent

# --- copy the contents of the event definition file to the
#     create event definition file window
	set l {}
	set cur_file [events_create_import_d.evfile_list getCurSelection]
	scan $cur_file "\{%s" item
	if [file exists [cconcat $evfiledir/$item]] {

		# Catch the error if the file cannot be opened
		set retval [catch { open [cconcat $evfiledir/$item] r } InFile]

         	# Check for failure.
		if { $retval != 0 } {
			InfoMsg "error" \
		  	   [pcm catget pcm_cannot_open_efile msg] \
			   [pcm catget pcm_cannot_open_file title] wait
			exit 1
		}

		while { -1 != [gets $InFile line] } {

			# Parse the fields.
			set event [ctoken line " \t"]
			set pri [ctoken line " \t"]
			set case [ctoken line " \t"]
			set pattern [string trim $line " \""]
			if { $case == 0 } {
				set displayCase [pcm catget case no] 
			} else {
				set displayCase [pcm catget case yes] 
			}

			# Put the items we are going to display in a list.
			set pattern_list [list $pattern $pri $displayCase]

			# Add the items to the list window.
			$parent.pat_list setListItem l $pattern_list 1
		}
		close $InFile
		$parent.pat_list setVal $l
	}


}

events_create_import_d.cancel proc invokeCB {} {
	events_create_import_d hide
	events_create_d.pat_list clear 
}

events_create_import_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn CreateEDFImportDB 
}

#
# --- proc for the deletion of a search pattern for events
events_create_d.pat_list.delete proc invokeCB {} {
	set self events_create_d.pat_list
# ---  delete the current selection from the list
#
	$self deleteCurSelection
	InfoMsg "info" \
	  [pcm catget pcm_del_pattern msg] \
	  [pcm catget pcm_general_info title] wait
	
}

#
# --- proc for the ok button on the add a search pattern dialog
events_create_add_d.ok proc invokeCB {} {
	global parent
	set parent events_create_add_d
	set retval [create_add_a_pattern]
        if { $retval == 0 } {
		InfoMsg "info" \
		  [pcm catget pcm_add_pattern msg] \
		  [pcm catget pcm_general_info title] wait
        }
}

#
# --- proc for the apply button on the add a search pattern dialog
events_create_add_d.apply proc invokeCB {} {
	global parent
	set parent events_create_add_d
	set retval [create_add_a_pattern]
	if { $retval == 0 } {
		InfoMsg "info" \
		   [pcm catget pcm_add_pattern msg] \
		   [pcm catget pcm_general_info title] wait
	}
}

# --- proc for adding a pattern while creating an event definition file
proc create_add_a_pattern {} {
	global parent
	global is_regex 
	global efile
	global ams_event
	global evfiledir

	set items {}
#
#	--- check that the fields are filled in
	if { [string length [$parent.pattern getVal] ] == 0 ||
	     [string length [$parent.pri getVal] ] == 0 } {
		InfoMsg error \
		   [pcm catget nodataerror msg] \
		   [pcm catget nodataerror title] wait
		return -1
	} 
#
# --- the priority should be a value between 100 & 700
	if { [string is digit [$parent.pri getVal]] == 0 || 
	     [$parent.pri getVal] < 100 ||
	     [$parent.pri getVal] > 700 } {
		InfoMsg error \
		   [pcm catget not_valid_priority msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
	}
#
#	--- check whether the pattern is a valid regular expression
#	    call the utility is_regex to check this 
	set retval [catch { exec $is_regex -p [$parent.pattern getVal] \
		 -c [$parent.case getVal] } ]
	if { $retval != 0 } {
		InfoMsg error \
		   [pcm catget not_valid_regexp msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
	}
	set count 0
	set listSize [events_create_d.pat_list sizeOfList]
#
# --- the new item which was entered 
	if { [$parent.case getVal] == 0 } {
		set displayCase [pcm catget case no] 
	} else {
		set displayCase [pcm catget case yes] 
	}
	# Put curly braces around the pattern , so that even if the 
	# pattern has spaces in between , it will be handled properly 
	set pattern [ cconcat "\{" [$parent.pattern getVal] "\}"]
		 
	set newitem [concat \
		      $pattern \
		      [$parent.pri getVal] \
	 	      $displayCase]
		
# --- check whether the string is a duplicate
	for { set i 0 } { $i < $listSize } { incr i } {
		set item [events_create_d.pat_list getDspStr $i]
		set item [lindex $item 0]
		set item  [lindex $item 0]
		# pattern strings with spaces in between will have
		# curly braces around them
		if { [string compare -length 1 $item "\{" ] == 0 } {
			set item [string trim $item "\{"]
			set pattern [ctoken item "\}"]
			set skipover [ctoken item " "]
			set priority [ctoken item " "]
			set case [ctoken item " "]
		} else {
			scan $item "%s %s %s" pattern priority case
		}
		# if we are adding a new pattern , we need to check whether
		# the pattern exits 
		if { [string compare $pattern [$parent.pattern getVal] ] == 0 } {
				incr count 
		}
	}
	# if we are modifying a pattern, the pattern may not be a duplicate 
	if { [string compare $parent "events_create_mod_d"] == 0 } {
		set current_item [events_create_d.pat_list getCurSelection]
		set current_item [lindex $current_item 0]
		set current_item [lindex $current_item 0]
		if { [string compare -length 1 $current_item "\{" ] == 0 } {
			set current_item [ string trim $current_item "\{" ]
			set pattern [ ctoken current_item "\}" ]
		} else {
			scan $current_item "%s %s %s" pattern priority case
		}
		if { [string compare $pattern [$parent.pattern getVal] ] == 0 } {
			# Pattern is not a duplicate.
			# We are modifying an existing entry
			incr count -1
		}
	} 	
	
	if { $count != 0 } {
		InfoMsg error \
		   [pcm catget pattern_exists msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
	} else {
		$parent hide
		events_create_d.pat_list setListItem items $newitem ""
		# If we are adding a newitem , we add it to the end of the list
		# If we are modifying , we want to replace the item in the list
		if { [string compare $parent "events_create_add_d"] == 0 } {
			events_create_d.pat_list insertDspStr end $items
		} else {
			set index [events_create_d.pat_list curSelection] 
			events_create_d.pat_list modifyDspStr $index $items
		}
		return 0
	}
}

events_create_add_d.cancel proc invokeCB {} {
	 events_create_add_d hide
}

events_create_add_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn CreateEDFAddDB 
}

#
# --- display proc for the modify a search pattern dialog
events_create_mod_d proc displayCB {} {
	set self events_create_mod_d

	set current_item [events_create_d.pat_list getCurSelection]
	set item [lindex $current_item 0]
	set item [lindex $item 0]
	# patterns with spaces in between will have curly braces
	# around them
	if { [string compare -length 1 $item "\{" ] == 0 } {
		set item [ string trim $item "\{" ]
		set pattern [ ctoken item "\}" ]
		set skipover [ ctoken item " " ]
		set priority [ ctoken item " " ]
		set case [ ctoken item " " ]
	} else {
		scan $item "%s %s %s" pattern priority case
	}
	$self.pattern setVal $pattern
	$self.pri setVal $priority
	if { $case == [pcm catget case yes] } {
		$self.case setVal 1
	} else {
		$self.case setVal 0
	} 

}

#
# --- proc for the ok button on the modify a search pattern dialog
events_create_mod_d.ok proc invokeCB {} {
	global parent
	set parent events_create_mod_d
	set retval [create_add_a_pattern]
	if { $retval == 0 } {
		InfoMsg "info" \
		  [pcm catget pcm_mod_pattern msg] \
		  [pcm catget pcm_general_info title] wait
                events_create_mod_d hide
	}
}


events_create_mod_d.cancel proc invokeCB {} {
	events_create_mod_d hide
}

events_create_mod_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn CreateEDFAddDB 
}

events_modify_d proc displayCB {} {
	global evfiledir
	set filelist {}
# --- read the contents of the directory and create a list of all the files
	foreach entry [readdir $evfiledir] {
		if { [file isfile [cconcat $evfiledir/$entry] ] } {
			$self.evfile_list setListItem filelist $entry ""
		}
	}
	$self.evfile_list setVal $filelist
}

events_modify_d.ok proc invokeCB {} {
	# call the proc which will display the contents of
	# the event definition file to modify.
	modifyEventfile
}

events_modify_d.evfile_list proc doubleClkCB {} {
	# call the proc which will display the contents of
	# the event definition file to modify.
	modifyEventfile
}

proc modifyEventfile {} {
	set self events_modify_d
# --- check whether something was selected
	if { [$self.evfile_list selectedItemCount] > 0 } {
		$self hide
		events_modfile_d display
	} else {
		InfoMsg error \
		   [pcm catget noselectionerror msg] \
		   [pcm catget noselectionerror title] wait
	} 
}

events_modify_d.cancel proc invokeCB {} {
       events_modify_d hide 
}

events_modify_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn EventsModDefnDB 
}

events_modfile_d proc displayCB {} {
	global evfiledir
	
# --- display the event definition file in the title.

	set cur_file [events_modify_d.evfile_list getCurSelection]
	scan $cur_file "\{%s" evfile 
	set title [pcm catget $self lbl]
	set title [format $title $evfile]
	$self setLabel $title	

	set l {}
#
# --- open the file containing the list of event patterns
#     and stuff each line into an array "l", then
#     setVal them to the list
#
	if [ file exists [cconcat $evfiledir/$evfile] ] {

		# Catch the error if the file cannot be opened
		set retval [catch { open [cconcat $evfiledir/$evfile] r } InFile]

		# Check for failure.
		if { $retval != 0 } {
			InfoMsg "error" \
			   [pcm catget pcm_cannot_open_efile msg] \
			   [pcm catget pcm_cannot_open_file title] wait
			return -1	
		}

		while { -1 != [gets $InFile line] } {

			# Parse the fields.
			set event [ctoken line " \t"]
			set pri [ctoken line " \t"]
			set case [ctoken line " \t"]
			set pattern [string trim $line " \""]

			if { $case == 0 } {
				set displayCase [pcm catget case no] 
			} else {
				set displayCase [pcm catget case yes] 
			} 
			
			# Put the items we are going to display in a list.
			set pattern_list [list $pattern $pri $displayCase]

			# Add the items to the list window.
			$self.pat_list setListItem l $pattern_list 1
		}

		close $InFile
		$self.pat_list setVal $l
	}

}

events_modfile_d.pat_list.add proc invokeCB {} {
	events_modfile_add_d display
}

events_modfile_d.pat_list.modify proc invokeCB {} {
	events_modfile_mod_d display
}

# --- proc for the deletion of a search pattern for events
events_modfile_d.pat_list.delete proc invokeCB {} {

	set self events_modfile_d.pat_list
# --- delete the current selection from the list
#
	$self deleteCurSelection
	InfoMsg "info" \
	  [pcm catget pcm_del_pattern msg] \
	  [pcm catget pcm_general_info title] wait
}

events_modfile_add_d.ok proc invokeCB {} {
	global parent
	set parent events_modfile_add_d
        set retval [modfile_add_a_pattern]
        if { $retval == 0 } {
		InfoMsg "info" \
		   [pcm catget pcm_add_pattern msg] \
		   [pcm catget pcm_general_info title] wait
                events_modfile_add_d hide
        }

}

#
# --- proc for the apply button on the add a search pattern dialog
events_modfile_add_d.apply proc invokeCB {} {
	global parent
	set parent events_modfile_add_d
        set retval [modfile_add_a_pattern]
        if { $retval == 0 } {
		InfoMsg "info" \
		   [pcm catget pcm_add_pattern msg] \
		   [pcm catget pcm_general_info title] wait
	}
}

events_modfile_add_d.cancel proc invokeCB {} {
	events_modfile_add_d hide
}

events_modfile_add_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn CreateEDFAddDB 
}

# --- proc for adding a pattern while modifying an event definition file
proc modfile_add_a_pattern {} {
	global evfiledir
	global ams_event
	global parent
	global is_regex 
	set self events_modfile_d
	set items {}

#
#       --- check that the fields are filled in
	if { [string length [$parent.pattern getVal] ] == 0 ||
	     [string length [$parent.pri getVal] ] == 0 } {
		InfoMsg error \
		   [pcm catget nodataerror msg] \
		   [pcm catget nodataerror title] wait
		return -1
	} 
#
# --- the priority should be a value between 100 & 700
	if { [string is digit [$parent.pri getVal]] == 0 || 
	     [$parent.pri getVal] < 100 ||
	     [$parent.pri getVal] > 700 } {
		InfoMsg error \
		   [pcm catget not_valid_priority msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
	}
	
#
#	--- check whether the pattern is a valid regular expression
#	    call the utility is_regex to do this
	set retval [ catch { exec $is_regex -p [$parent.pattern getVal] \
		    -c [$parent.case getVal] } ]
	if { $retval != 0 } {
		InfoMsg error \
		   [pcm catget not_valid_regexp msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
	}
	set count 0
	set listSize [events_modfile_d.pat_list sizeOfList]

#
# --- the new item which was entered 
	if { [$parent.case getVal] == 0 } {
		set displayCase [pcm catget case no] 
	} else {
		set displayCase [pcm catget case yes] 
	}

	# Attach curly braces to pattern, so that patterns with spaces
	# in between will be handled properly
	set pattern [cconcat "\{" [$parent.pattern getVal] "\}"]
	set newitem [concat \
		      $pattern \
		      [$parent.pri getVal] \
	 	      $displayCase]
		
# --- check whether the string is a duplicate
	for { set i 0 } { $i < $listSize } { incr i } {
		set item [events_modfile_d.pat_list getDspStr $i]
		set item [lindex $item 0]
		set item [lindex $item 0]
		# Pattern strings with spaces in between will have 
		# curly braces 
		if { [string compare -length 1 $item "\{" ] == 0 } {
			set item [ string trim $item "\{" ]
			set pattern [ ctoken item "\}" ]
			set skipover [ ctoken item " " ]
			set priority [ ctoken item " " ]
			set case [ ctoken item " " ]
		} else {
			scan $item "%s %s %s" pattern priority case
		}
		# if we are adding a new pattern , we need to check whether
		# the pattern exits 
		if { [string compare $pattern [$parent.pattern getVal] ] == 0 } {
			incr count 
		}
	}
	if { [string compare $parent "events_modfile_mod_d"] == 0 } {
		set current_item [events_modfile_d.pat_list getCurSelection]
		set current_item [lindex $current_item 0]
		set current_item [lindex $current_item 0]
		if { [string compare -length 1 $current_item "\{" ] == 0 } {
			set current_item [ string trim $current_item "\{" ]
			set pattern [ ctoken current_item "\}" ]
		} else {
			scan $current_item "%s %s" pattern otherdata
		}
		if { [string compare $pattern [$parent.pattern getVal] ] == 0 } {
			# We are modifying an existing entry
			# The pattern is not a duplicate
			incr count -1
		}
	}
	if { $count != 0 } {
		InfoMsg error \
		   [pcm catget pattern_exists msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
	} else {
		events_modfile_d.pat_list setListItem items $newitem ""
		# If we are adding a newitem , we add it to the end of the list
		# If we are modifying , we want to replace the item in the list
		if { [string compare $parent "events_modfile_add_d"] == 0 } {
			events_modfile_d.pat_list insertDspStr end $items
		} else {
			set index [events_modfile_d.pat_list curSelection] 
			events_modfile_d.pat_list modifyDspStr $index $items
		}
		return 0
	}
}

events_modfile_d.ok proc invokeCB {} {

	global evfiledir
	global ams_event
	global cmfd_cmd 
	set self events_modfile_d

	set cur_file [ events_modify_d.evfile_list getCurSelection ]
	scan $cur_file "\{%s" evfile

# --- create the events file name.
	set efile [ cconcat \
		$evfiledir/$evfile ]

	set listSize [ $self.pat_list sizeOfList ]
	if { $listSize == 0 } {
		InfoMsg error \
		   [pcm catget empty_evfile msg] \
		   [pcm catget pcm_general_error title] wait
		return -1
	}
# --- Now modify the event definition file
	set InFile [ open $efile w ]
	for { set i 0 } { $i < $listSize } { incr i } {
		set item [ $self.pat_list  getDspStr $i ]
		set item [ lindex $item 0 ]
		set item  [ lindex $item 0 ]
		if { [string compare -length 1 $item "\{" ] == 0 } {
			set item [ string trim $item "\{" ]
			set pattern [ ctoken item "\}" ]
			set skipover [ ctoken item " " ]
			set priority [ctoken item " " ]
			set displayCase [ctoken item " " ] 
		} else {
			scan $item "%s %s %s" pattern priority displayCase
		}
		if { [string compare $displayCase [pcm catget case yes]] == 0 } {
			set case 1
		} else {
			set case 0
		} 
		set newitem [ concat \
			$ams_event \
			$priority \
			$case \
			$pattern] 
		puts $InFile $newitem
	}
	close $InFile
	InfoMsg "info" \
	     [pcm catget pcm_modify_evfile msg] \
             [pcm catget pcm_general_info title] wait
	$self hide
	events_modify_d hide
	# cmfd has to re-read the event definition file to
	# recognize the newly added patterns.
	catch { exec $cmfd_cmd update } retval
}

#
# --- display proc for the modify a search pattern dialog
events_modfile_mod_d proc displayCB {} {
	set self events_modfile_mod_d

	set current_item [ events_modfile_d.pat_list getCurSelection ]
	set item [ lindex $current_item 0 ]
	set item [ lindex $item 0]
	# patterns with spaces in between will have 
	# curly braces around them
	if { [string compare -length 1 $item "\{" ] == 0 } {
		set item [ string trim $item "\{" ]
		set pattern [ ctoken item "\}" ]
		set skipover [ ctoken item " " ]
		set priority [ ctoken item " " ]
		set case [ ctoken item " " ]
	} else {
		scan $item "%s %s %s" pattern priority case
	}
	$self.pattern setVal $pattern
	$self.pri setVal $priority
	if { $case == [pcm catget case yes] } {
		$self.case setVal 1 
	} else {
		$self.case setVal 0 
	} 

}

events_modfile_mod_d.ok proc invokeCB {} {
	global parent
	set parent events_modfile_mod_d
	set retval [modfile_add_a_pattern]
	if { $retval == 0 } {
		InfoMsg "info" \
		   [pcm catget pcm_mod_pattern msg] \
		   [pcm catget pcm_general_info title] wait
		events_modfile_mod_d hide
	}
}

events_modfile_mod_d.cancel proc invokeCB {} {
	events_modfile_mod_d hide
}

events_modfile_mod_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn CreateEDFAddDB 
}

events_modfile_d.cancel proc invokeCB {} {
	events_modfile_d hide
	events_modify_d hide
}

events_modfile_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn EventsModifyDB 
}

events_delete_d proc displayCB {} {
	global evfiledir
	global cfile
# --- put up a list of all event definition file for deletion
	set filelist {}
	foreach entry [readdir $evfiledir] {
		if { [file isfile [ cconcat $evfiledir/$entry ]] } {
			$self.evfile_list setListItem filelist $entry ""
		}
	}
	$self.evfile_list setVal $filelist
}

events_delete_d.ok proc invokeCB {} {
	# call the proc which will delete the event
	# definition file
	deleteEventfile
}

events_delete_d.evfile_list proc doubleClkCB {} {
	# call the proc which will delete the event
	# definition file
	deleteEventfile
}

proc deleteEventfile {} {
	global evfiledir
	global cfile
	set self events_delete_d

	if { [$self.evfile_list selectedItemCount] <= 0 } {
		InfoMsg error \
		   [pcm catget noselectionerror msg] \
		   [pcm catget noselectionerror title] wait
		return -1
	}
	set cur_file [ $self.evfile_list getCurSelection ]
	set cur_file [ lindex $cur_file 0 ]
	scan $cur_file "%s" cur_evfile

	set count 0
#	--- If the event definition file is being used by any console
#           display an error message, otherwise delete the event file. 
#	    Read the cmf.conf to see whether the event file is
#	    being used by any console

	set retval [ catch { open $cfile r} InFile ]
	if { $retval != 0 } {
		general_error
		return
	}
#
#       --- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {

		# Get rid of leading whitespace.
	        set line [string trimleft $line " \t"]

		# If the line contains a comment then skip it.
		if { [string compare -length 1 $line "#"] == 0 } {
			continue
		}
		# if the line is blank, skip it
		if { [string length $line] == 0 } {
		   continue
		}

		# Parse the fields.
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipspace [ctoken line "\""]
		set skipover [ctoken line "\""]
		set skipquote [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set evfile [ctoken line " \t"]
		if { [string compare $evfile $cur_evfile] == 0 } {
			incr count 	
		}
	}
	close $InFile

#	--- create the events filename
	set evfile [ cconcat $evfiledir/$cur_evfile ]
	if { $count != 0 } { 
		evfile_delete_d display
	} elseif { [ file exists $evfile ] } {
		set retval [ catch { exec rm $evfile } ]
#
# --- now delete the current selection from the list
#
		$self.evfile_list deleteCurSelection
		InfoMsg "info" \
		   [pcm catget pcm_delete_evfile msg] \
		   [pcm catget pcm_general_info title] wait
		$self hide
	}
}

events_delete_d.cancel proc invokeCB {} {
	events_delete_d hide
}

events_delete_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn EventsDelDefnDB 
}

evfile_delete_d proc displayCB {} {
	global cfile
	global mbm_suf
	global ts_suf

	set l {}
	set cur_file [ events_delete_d.evfile_list getCurSelection ]
	set cur_file [ lindex $cur_file 0 ]
	scan $cur_file "%s" cur_evfile

#	--- Get a list of all the consoles using the event definition file 
#       --- open the cmf.conf file
	set retval [ catch { open $cfile r} InFile ]
	if { $retval != 0 } {
		general_error
		return
	}
#
#       --- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {

		# Get rid of leading whitespace.
	        set line [string trimleft $line " \t"]

		# If the line contains a comment then skip it.
		if { [string compare -length 1 $line "#"] == 0 } {
			continue
		}
		# if the line is blank, skip it
		if { [string length $line] == 0 } {
		   continue
		}

		# Parse the fields.
		set system [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set port_num [ctoken line " \t"]
		set mgmt_port_num [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set plat_name [ctoken line " \t"]
		set skipspace [ctoken line "\""]
		set skipover [ctoken line "\""]
		set skipquote [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set evfile [ctoken line " \t"]

		if { [string compare $evfile $cur_evfile] == 0 } {
			if { [string compare $system $plat_name$mbm_suf] == 0 ||
			     [string compare $system $plat_name$ts_suf] == 0 } {
				set consoles $plat_name 
			} else {
				set consoles $system		
			}
			# Add the items to the list window.
			$self.console_list setListItem l $consoles 1
			}
	}
	close $InFile
	$self.console_list setVal $l
}

evfile_delete_d.ok proc invokeCB {} {
	evfile_delete_d hide
	events_delete_d hide
}

# --- proc for systems button click
w1.m_sys.b_configure proc invokeCB {} {
	set self w1.m_sys
	configure_d display
	}

# --- proc for mgmt options button click
w1.m_sys.b_mgmt proc invokeCB {} {
	set self w1.m_sys
	mgmt_d display
}

# --- proc for options button click
#w1.options proc invokeCB {} {
#	set self w1.c_out
#	options_d display
#	}

#
# --- proc for connect window display
connect_d proc displayCB {} {
	global hostname
	global platname
	global useplatnameflag
	global status

#	--- If the console name in main window is displayed as mbm port
#	--- or TS PORT, we need to set the hostname to the platform name.
	if { $useplatnameflag == 1 } {
		set hostname $platname
	}
#	--- display the selected console in the title.
	set title [pcm catget connect_d lbl]
	set title [format $title $hostname]
	connect_d setLabel $title

#	--- if the status of the selected console is in use exclusively,
#	--- the default option is read-only else default is shared.
	if {[string compare $status [pcm catget console busyex]] == 0} {
		connect_d.connect_opts setVal "ro"
	} else {
		connect_d.connect_opts setVal "sh"
	}
}

#
# --- connect to the console
# --- called on selecting the ok button in the connect window.
connect_d.ok proc invokeCB {} {
	global hostname
	global env
	global SysmanUi
	global amsmgr

	connect_d hide

	set chosen_opt [connect_d.connect_opts getVal]

#	get the ip address of the AMS system
	set host_addr [ server_info addresses [id host] ]

#	connect to a console
	if { $chosen_opt == "ro" || $chosen_opt == "sh" || $chosen_opt == "ex" } {
	    if { $SysmanUi == "menu" } {
		ctk_endwin
		if { [set pid [fork]] == 0 } {
		   execl /usr/opt/ams/bin/gopty "$hostname $chosen_opt $host_addr"
		}
		wait $pid
		ctk_refresh
	    } else {
#
#	      --- the child process will exec a terminal window.
	      set wintitle [ concat \
			   $hostname \
                           [ pcm catget console string ] \
                           [ pcm catget control char ] ]
              if { [fork] == 0 } {
                 catch { \
                 execl /usr/bin/X11/xterm [list -T $wintitle \
                     -sl 500 -display $env(DISPLAY) -sb -bg black -fg green \
                     -e /usr/opt/ams/bin/gopty $hostname $chosen_opt $host_addr] \
                 } msg

                 # Since we are the child process, and it was our
                 # parent that established the initial connection
                 # to the X Server, not us, we cannot do anything
                 # that accesses the X Server. Therefore, we can
                 # only write the error to stderr.
                 puts stderr $msg

                 # Our "execl" failed. Kill the forked process. The
                 # Tcl Help for "execl" says that if the "excl" fails
                 # in a Tk application, we cannot use the normal "exit"
                 # command but must use "kill [id process]" instead.
                 kill [id process]
                }
	    }
	}
}

#
# --- cancel the connect window.
# --- called on selecting the cancel button in the connect window.
connect_d.cancel proc invokeCB {} {
	connect_d hide
}

#
# --- callback for help in the connect window.
connect_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ConnectDB
}

#
# --- display callback for the console window.
cons_d proc displayCB {} {
	global hostname
	global platname
	global useplatnameflag

#	--- If the console name in main window is displayed as mbm port
#	--- or TS PORT, we need to set the hostname to the platform name.
	if { $useplatnameflag == 1 } {
		set hostname $platname
	}

# --- to have the selected console displayed in the title.
	set title [pcm catget cons_d lbl]
	set title [format $title $hostname]
	cons_d setLabel $title
}

#
# --- callback on "ok" for the console window.
cons_d.ok proc invokeCB {} {
	global hostname
	global env
	global SysmanUi
	global amsmgr
	global sendmsgallflg
	global platname
	global useplatnameflag

	cons_d hide

	set chosen_opt [cons_d.cons_opts getVal]

          if { $chosen_opt == "send_msg" } {
		    set sendmsgallflg 0
		    send_msg_d display
	  } elseif { $chosen_opt == "view_logs" } {
#		--- If the console name in main window is displayed as mbm or ts port
#		--- we need to pass the platform name instead of the hostname.
		if { $useplatnameflag == 1 } {
			set hostname $platname
		}
                if { $SysmanUi == "menu" } {
                    ctk_endwin
                    if { [set pid [fork]] == 0 } {
                        execl /usr/opt/ams/bin/viewlog.sh $hostname
                    }
		    wait $pid
		    ctk_refresh
                } else {
	            set wintitle [ concat \
				 $hostname \
                                 [ pcm catget console log ] ]
                    bgexec stat /usr/bin/X11/xterm -T $wintitle \
		    -sl 500 -display $env(DISPLAY) -sb -bg black -fg green \
		    -e /usr/opt/ams/bin/viewlog.sh $hostname }

          } elseif { $chosen_opt == "view_users" } {
		    view_users_d display
	  }
}

#
# callback on cancel for the console window
cons_d.cancel proc invokeCB {} {
	cons_d hide
}

#
# callback on help for the console window
cons_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ConsolesDB
}

configure_d.ok proc invokeCB {} {

	global amsmgr
	global mbm_suf
	global ts_suf

	set chosen_system_opt [configure_d.config_opts getVal]
	configure_d hide

	if { $chosen_system_opt == "add_plat" } {
#AD		add_plat_d display
		which_platf_d display
	} elseif { $chosen_system_opt == "add_cons" } {
#		add_cons_d display
		which_cons_d display
	} elseif { $chosen_system_opt == "modify" } {
#	--- Need to find out whether the selected item is a platform or a console.
#	    The window to be displayed depends on whether the selected item is
#	    is a platform or a console.
		# Check that something was selected
		if { [ w1.m_sys selectedItemCount ] > 0 } {
			set current_item [ lindex [ w1.m_sys getCurSelection ] 0 ] 
	 		scan $current_item "\{%s %s %s %s" cons_name plat_name model otherdata 

			if { [string compare $cons_name $plat_name$mbm_suf] == 0 || 
			     [string compare $cons_name $plat_name$ts_suf] == 0 ||
			     [string compare $cons_name $plat_name ] == 0 } {

			    DisplayModifyPlatformWindow	
			} else {
				DisplayModifyConsoleWindow
			}	
		} else {
	        	InfoMsg error \
			  [ pcm catget noselectionerror msg ] \
			  [ pcm catget noselectionerror title ] wait
	  	}
	} elseif { $chosen_system_opt == "delete" } {
#	--- Need to find out whether the selected item is a platform or a console.
#	    The window to be displayed depends on whether the selected item is
#	    is a platform or a console.
		# Check that something was selected
		if { [ w1.m_sys selectedItemCount ] > 0 } {
			set current_item [ lindex [ w1.m_sys getCurSelection ] 0 ] 
	 		scan $current_item "\{%s %s %s %s" cons_name plat_name model otherdata 
			if { [string compare $cons_name $plat_name$mbm_suf] == 0 || 
			     [string compare $cons_name $plat_name$ts_suf] == 0 ||
			     [string compare $cons_name $plat_name ] == 0 } { 
				del_plat_d display
			} elseif { [string compare $model <other>] == 0 } {
				del_gen_cons_d display
			} else {
				del_cons_d display
			}	
		} else {
	        	InfoMsg error \
			  [ pcm catget noselectionerror msg ] \
			  [ pcm catget noselectionerror title ] wait
	  	}
	}
}

configure_d.cancel proc invokeCB {} {
	configure_d hide
}

configure_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ConfigureDB 
}



#====================================================
#Display the list of available Marvel templates 
#====================================================
add_plat_marvel_d.b_templatesl proc invokeCB {} {

	global parent

	set parent add_plat_marvel_d

	templates_list_d display

}



#
# --- if the user turns logging off, then monitoring must also
#     be turned off and made insensitive.
add_plat_marvel_d.logging proc changeCB {} {
	set self add_plat_marvel_d

	if { [ $self.logging getVal ] == 0 } {
		$self.monitoring setVal 0
		$self.monitoring disable
	} else {
		$self.monitoring enable
	}
}

#
# --- if the user turns console access off, then logging and monitoring
#     must also be turned off and made insensitive.
add_plat_marvel_d.enable proc changeCB {} {
	set self add_plat_marvel_d

	if { [ $self.enable getVal ] == 0 } {
		$self.logging disable
		$self.monitoring disable
        } else {
		$self.logging enable
		if { [ $self.logging getVal ] == 0 } {
			$self.monitoring setVal 0
			$self.monitoring disable
		} else {
			$self.monitoring enable
		}
        }
}

#
# If a Wildfire platform is selected, then enable console access,
# but disable logging console output, and event generation. Also gray out
# event definition file field and set event file name to an
# empty string.
# A. Dokos Modified to enable console 
add_plat_marvel_d.platform_type proc changeCB {} {

	set self add_plat_marvel_d

	if { [getSeriesOfModel [$self.platform_type getVal ]] == "W" } {
#AD		$self.enable setVal 0
#AD		$self.enable disable
		$self.enable setVal 1
		$self.enable enable
		$self.logging setVal 0
		$self.logging disable
		$self.monitoring setVal 0
		$self.monitoring disable	
		# Set event file name as an empty string.
		$self.evfile setVal []
		$self.evfile disable
		$self.b_files disable
	} else {
		$self.enable setVal 1
		$self.enable enable
		$self.logging setVal 1
		$self.logging enable
		$self.monitoring setVal 1
		$self.monitoring enable	
		$self.evfile enable
		$self.b_files enable
	}
}

add_plat_marvel_d.ok proc invokeCB {} {
	set retval [add_a_platform add_plat_marvel_d]

	if { $retval == 0 } {
		add_plat_marvel_d hide
	}
}


add_plat_marvel_d.apply proc invokeCB {} {
	add_a_platform add_plat_marvel_d
}

add_plat_marvel_d.cancel proc invokeCB {} {
	add_plat_marvel_d hide
}

add_plat_marvel_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddSysDB 
}



#=================================================
# --- proc for the Event File Browse button click
#=================================================

add_plat_marvel_d.b_files proc invokeCB {} {

	global parent
	set parent add_plat_marvel_d
        eventfiles_d display
}


#===============================================================
# This proc does the actual add of a marvel platform using the 
# amsmgr command
#===============================================================

proc add_a_platform {calling_window} {
	global amsmgr
	global errorCode
	global parent 

	set items {}

#	set self add_plat_marvel_d
#	set parent $self 

	set self $calling_window
	set parent $self

	


#
# --- check that all the fields (except description) are filled in
	if { [ string length [ $self.ip_address getVal ] ] == 0 ||
             [ string length [ $self.platform_type getVal ] ] == 0 ||
             [ string length [ $self.platform_name getVal ] ] == 0 
	} {
	   InfoMsg error \
	     [ pcm catget nodataerror msg ] \
	     [ pcm catget nodataerror title ] wait
	     return -1
	}

# --- validate the event definition file name

	if { $calling_window == "add_plat_marvel_d" } {

		set retval [is_valid_event_file_name]
		if { $retval != 0 } {
			InfoMsg error \
			   [ pcm catget invalidfilename msg ] \
			   [ pcm catget pcm_general_error  title ] wait
			return -1
        } 
	}
#
#          --- create the "add a platform" command


	set platform_name [$self.platform_name getVal]
	set ip_address [$self.ip_address getVal]
	set model [$self.platform_type getVal]
	set enable [$self.enable getVal]
	set comment [$self.system_descr getVal]


	if { $calling_window == "add_plat_marvel_d" } {
		set logging [$self.logging getVal]
		set monitoring [$self.monitoring getVal]
		set evfile [$self.evfile getVal]
	   	set tDescription [$self.templatesl getVal]
		set template [getTemplateId $tDescription ]
		set ts_port_min 2001
		set ts_port_max 2008
	} else {
		set logging 0
		set monitoring 0
		set template ""
		set evfile ""
		set ts_port_min [$self.ts_port_min getVal]
		set ts_port_max [$self.ts_port_max getVal]
	}

	set newplat [ concat \
		$amsmgr \
		"-add platform " \
		"-name " \
		\"$platform_name\" \
		"-model " \
		\"$model\" \
		"-addr " \
		\"$ip_address\" \
		"-port 23" \
		"-enable " \
		\"$enable\" \
		"-logging " \
		\"$logging\" \
		"-events " \
		\"$monitoring\" \
		"-evfile "\
		\"$evfile\" \
		"-template " \
		\"$template\" \
		"-comment " \
		\"$comment\" \
		"-first_ts_port " \
		\"$ts_port_min\" \
		"-last_ts_port " \
		\"$ts_port_max\" \
	] 

        set retval [ catch { eval exec $newplat } output ]
   	if { $retval != 0 } {
	      set errorNum [lindex $errorCode 2]
#
#             --- ignore errors under 5 (platform may already exist)
	      if { $errorNum == 26 } {
		 set err_msg [pcm catget file_doesnot_exist  msg] 
		 set err_msg [format $err_msg [ $self.evfile getVal ]]
		 InfoMsg "error" \
		     $err_msg \
                     [pcm catget pcm_general_error title] wait
                 return -1
	      } elseif { $errorNum == 22 } {
		  InfoMsg "error" \
		     [ pcm catget invalidpname msg ] \
		     [ pcm catget pcm_general_error title ] wait
		  return -1
	      } elseif { $errorNum == 18 } {
		  InfoMsg "error" \
		     [ pcm catget invalidmodel msg ] \
		     [ pcm catget pcm_general_error title ] wait
		  return -1
              } elseif { $errorNum == 12 } {
	         InfoMsg "error" \
                     [pcm catget pcm_invalid_IP_address msg] \
                     [pcm catget pcm_general_error title] wait
	         return -1
              } elseif { $errorNum == 13 } {
	         InfoMsg "error" \
                     [pcm catget invalidportnumber msg] \
                     [pcm catget pcm_general_error title] wait
	         return -1
	      } elseif { $errorNum == 6 } {
		  InfoMsg "error" \
		     [format [pcm catget dupaddr msg] [$self.ip_address getVal]]\
		     [pcm catget pcm_general_error title] wait
		  return -1
	      } elseif { $errorNum == 5 } {
		  InfoMsg "error" \
		     [pcm catget pcm_platform_exists msg] \
		     [pcm catget pcm_general_error title] wait
		  return -1
	      } elseif { $errorNum > 5 } {

#	      --- an error occurred in amsmgr. tell the user 
#                 then return without modifying the record
                 InfoMsg "error" \
                    [pcm catget pcm_amsmgr_err msg] \
                    [pcm catget pcm_general_error title] wait
		 return -1
              }
	   }

	InfoMsg "info" \
	     [pcm catget pcm_add_platform msg] \
             [pcm catget pcm_general_info title] wait

	return 0
}



#================================================================
#	Wildfire add platform specific procs
#
#================================================================

#AD. mgmt port only for wildfire platforms since for Marvel the port is always 23

#---proc to initialize some defaults

add_plat_WF_d proc initCB {} {
#	add_plat_WF_d.mgmt_port setVal 23

	set self add_plat_WF_d 
	$self.enable setVal 0
	$self.ts_port_min setVal 2001
	$self.ts_port_max setVal 2008
}


# proc called when the OK button is selected

add_plat_WF_d.ok proc invokeCB {} {
	set retval [add_a_platform add_plat_WF_d]

	if { $retval == 0 } {
		add_plat_WF_d hide
	}
}


#=================================================
# proc called when the apply button is selected
#=================================================

add_plat_WF_d.apply proc invokeCB {} {
	add_a_platform add_plat_WF_d
}

#=================================================
# proc called when the cancel button is selected
#=================================================

add_plat_WF_d.cancel proc invokeCB {} {
	add_plat_WF_d hide
}


#=================================================
# proc called when the helpbutton is selected
#=================================================

	add_plat_WF_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddSysDB 
}

#=================================================
# --- proc for the Event File Browse button click
#=================================================

add_cons_plat_d.b_files proc invokeCB {} {
	global parent

	set parent add_cons_plat_d	
	eventfiles_d display
}

eventfiles_d proc displayCB {} {
        global evfiledir
	global parent
	
# --- display the appropriate  title 
	
	set title [pcm catget [append eventfiles_ $parent] lbl]
	$self setLabel $title

        set filelist {}
        foreach entry [readdir $evfiledir] {
                if { [file isfile [ cconcat $evfiledir/$entry ]] } {
                	$self.evfile_list setListItem filelist $entry ""
                }
        }
        $self.evfile_list setVal $filelist
}

eventfiles_d.ok proc invokeCB {} {
	# Call the proc which will 
	# select the event definition file
	selectEventfile
}

eventfiles_d.evfile_list proc doubleClkCB {} {
	# Call the proc which will 
	# select the event definition file
	selectEventfile
	
}

proc selectEventfile {} {
	global parent
	set evfile [ eventfiles_d.evfile_list getCurSelection ]
	set evfile [ lindex $evfile 0 ]
	scan $evfile "%s %s" evfile otherdata
	$parent.evfile setVal $evfile 
	eventfiles_d hide
}

eventfiles_d.cancel proc invokeCB {} {
	eventfiles_d hide
}


##AD
which_platf_d.ok proc invokeCB {} {
	which_platf_d hide

	set chosen_opt [which_platf_d.platf_type getVal]
	if { $chosen_opt == "MV" } {
		add_plat_marvel_d display
	} elseif { $chosen_opt == "WF" } {
		add_plat_WF_d display
	}
}

which_platf_d.cancel proc invokeCB {} {
which_platf_d hide
}

which_platf_d.help proc invokeCB {} {
pcm setHelpName "Platform Console Manager: Help"
##AD TODO: new help
pcm helpOn AddConSpecTypeDB
}



which_cons_d.ok proc invokeCB {} {
	which_cons_d hide

	set chosen_opt [which_cons_d.cons_type getVal]
	if { $chosen_opt == "PC" } {
		add_cons_plat_d display
	} elseif { $chosen_opt == "GC" } {
		add_cons_generic_d display
	}
}

which_cons_d.cancel proc invokeCB {} {
	which_cons_d hide
}

which_cons_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddConSpecTypeDB
}

# --- proc for the Browse button click
add_cons_plat_d.b_browse proc invokeCB {} {

#       --- open the cmf.conf file
	global cfile
	set platform_count 0
	set items {}
 
        set retval [ catch { open $cfile r} InFile ]
        if { $retval != 0 } {
           general_error
           return
        }
#
#       --- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
        while { -1 != [ gets $InFile line ] } {

		# Get rid of leading whitespace.
		set line [string trimleft $line " \t"]

		# If the line contains a comment then skip it.
		if { [string compare -length 1 $line "#"] == 0 } {
			continue
		}
		# if the line is blank, skip it
		if { [string length $line] == 0 } {
			continue
		}

		# Parse the fields.
		set cons_name [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set port_num [ctoken line " \t"]
		set mgmt_port_num [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set plat_type [ctoken line " \t"]
		set plat_name [ctoken line " \t"]
		set skipspace [ctoken line "\""]
		set skipover [ctoken line "\""]
		set skipquote [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " "]
	
		# The last field should be the comments. Get what is in the quotes
		
		set skipquote [ctoken line "\""]

		set skipspace [ctoken line "\""]
		set comments [ctoken line "\""]
		set comments [string trim $comments]

		# we need to set the description back to empty for display purproses
		if { [string compare $comments "none"] == 0 } {
			set comments ""
		}

		if { [string compare $port_num $mgmt_port_num ] == 0 &&
		     [string compare $cons_name $plat_name ] == 0 } {
			# Put the items we are going to display in a list.
			set platform_list [list $plat_name \
					$plat_type $comments]
	
			# Add the items to the list window.
			select_plat_d.plat_list setListItem items $platform_list 1
		}
		incr platform_count
        }
        close $InFile

        select_plat_d.plat_list setVal $items

        if { $platform_count == 0 } {
                InfoMsg "info" \
                    [pcm catget pcm_no_plat msg] \
                    [pcm catget pcm_no_plat title] wait
		add_cons_plat_d hide
        } else {
        	select_plat_d display
	}
}

#
# --- if the user turns logging off, then monitoring must also
#     be turned off and made insensitive.
add_cons_plat_d.logging proc changeCB {} {
	set self add_cons_plat_d

	if { [ $self.logging getVal ] == 0 } {
		$self.monitoring setVal 0
		$self.monitoring disable
	} else {
		$self.monitoring enable
	}
}

#
# --- if the user turns console access off, then logging and monitoring
#     must also be turned off and made insensitive.
add_cons_plat_d.enable proc changeCB {} {
	set self add_cons_plat_d

# if { [getSeriesOfModel [$self.platform_type getVal ]] != "W" } {

	if { [ $self.enable getVal ] == 0 } {
		$self.logging disable
		$self.monitoring disable
	} else {
		$self.logging enable
		if { [ $self.logging getVal ] == 0 } {
			$self.monitoring setVal 0
			$self.monitoring disable
		} else {
			$self.monitoring enable
		}
	}
#  }
}

add_cons_plat_d.ok proc invokeCB {} {
	set retval [add_a_console add_cons_plat_d]
	if { $retval == 0 } {
		add_cons_plat_d hide
	}
}

add_cons_plat_d.apply proc invokeCB {} {
	add_a_console add_cons_plat_d
}

add_cons_plat_d.cancel proc invokeCB {} {
	add_cons_plat_d hide
}

add_cons_plat_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddModConsoleDB
}

add_cons_plat_d.b_ostype proc invokeCB {} {

	global parent

	set parent add_cons_plat_d

	ostype_list_d display
}

# --- proc for the Event File Browse button click
add_cons_generic_d.b_files proc invokeCB {} {
	global parent

	set parent add_cons_generic_d	
	eventfiles_d display
}

#
# --- if the user turns logging off, then monitoring must also
#     be turned off and made insensitive.
add_cons_generic_d.logging proc changeCB {} {
	set self add_cons_generic_d

	if { [ $self.logging getVal ] == 0 } {
		$self.monitoring setVal 0
		$self.monitoring disable
	} else {
		$self.monitoring enable
	}
}

#
# --- if the user turns console access off, then logging and monitoring
#     must also be turned off and made insensitive.
add_cons_generic_d.enable proc changeCB {} {
	set self add_cons_generic_d

	if { [ $self.enable getVal ] == 0 } {
		$self.logging disable
		$self.monitoring disable
	} else {
		$self.logging enable
		if { [ $self.logging getVal ] == 0 } {
			$self.monitoring setVal 0
			$self.monitoring disable
		} else {
			$self.monitoring enable
		}
	}
}

add_cons_generic_d.ok proc invokeCB {} {
	set retval [add_a_console add_cons_generic_d]
	if { $retval == 0 } {
		add_cons_generic_d hide
	}
}

add_cons_generic_d.apply proc invokeCB {} {
	add_a_console add_cons_generic_d
}

add_cons_generic_d.cancel proc invokeCB {} {
	add_cons_generic_d hide
}

add_cons_generic_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddModGenConsoleDB
}

proc add_a_console { calling_window } {
	global amsmgr
	global errorCode
	global parent

	set items {}
	set self $calling_window
	set parent $self

	if { $calling_window == "add_cons_plat_d" } {
		set platform_name [ $self.platform_name getVal ]
		set ip_address ""
		set port [ $self.port getVal ]
		set system_name [ $self.system_name getVal ]
		set os_type [ $self.os_type getVal ]
		set enable [ $self.enable getVal ]
		set logging [ $self.logging getVal ]
		set monitoring [ $self.monitoring getVal ]
		set evfile [ $self.evfile getVal ]
		set system_descr [ $self.system_descr getVal ]
	} else {
		set platform_name ""
		set ip_address [ $self.ip_address getVal ]
		set port [ $self.port getVal ]
		set system_name [ $self.system_name getVal ]
		set enable [ $self.enable getVal ]
		set logging [ $self.logging getVal ]
		set monitoring [ $self.monitoring getVal ]
		set evfile [ $self.evfile getVal ]
		set system_descr [ $self.system_descr getVal ]
	}

	#####################################################################
	# Check if all the required fields are populated.
	#####################################################################

	set missing_data 0

	if { $calling_window == "add_cons_plat_d" } {
		if { [ string length $platform_name ] == 0 } {
			set missing_data 1
		}
	} else {
		if { [ string length $ip_address ] == 0 } {
			set missing_data 1
		}
	}

	if { [ string length $port ] == 0 ||
	     [ string length $system_name ] == 0 } {
		set missing_data 1
	}

	if { $missing_data == 1 } {
		InfoMsg error \
			[ pcm catget nodataerror msg ] \
			[ pcm catget nodataerror title ] wait
		return -1
	}

	# validate the event definition file name if the user has entered 
	# the event definition file name.
	if { [ string length $evfile ] != 0 } {
		set retval [is_valid_event_file_name]
		if { $retval != 0 } {
			InfoMsg error \
		   	    [ pcm catget invalidfilename msg ] \
		   	    [ pcm catget pcm_general_error  title ] wait
			return -1
        	} 
	}

	# If we were called from the "Add Console To Platform" window, then
	# we must specify which platform we wish our console to be added to.
	# Otherwise, if we were called from the "Add Generic Console" window,
	# then we must assign an IP address to the generic console.
	if { $calling_window == "add_cons_plat_d" } {
		set op "-platform \"$platform_name\""
	} else {
		set op "-addr \"$ip_address\""
	}

#
#	   --- create the add a system command. Note: the comment
#              field must be enclosed in quotes.
	set newsys [ concat \
		$amsmgr \
		"-add system " \
		"-name " \
		\"$system_name\" \
		$op \
		"-port " \
		\"$port\" \
		"-enable " \
		\"$enable\" \
		"-logging " \
		\"$logging\" \
		"-events " \
		\"$monitoring\" \
		"-comment " \
		\"$system_descr\" \
		]

	# If user has enter the event definition file, then we need to 
	# include -evfile 
	if { [string length $evfile ] != 0 } {
		# Append the -evfile at the end of the command line.
		set newsys [cconcat $newsys " -evfile \"$evfile\""]
	}

	# If we are adding a platform console, add os_type
	if { $calling_window == "add_cons_plat_d" } {
		# If user has entered the OS type, then we need to include -type
		if { [string length $os_type ] != 0 } {
			# Append the -type at the end of the command line.
			set newsys [cconcat $newsys " -type \"$os_type\""]
		} 
	}

	set retval [ catch { eval exec $newsys } output ]
	if { $retval != 0 } {
		set errorNum [lindex $errorCode 2]
		if { $errorNum == 1 } {
			InfoMsg "error" \
			  [pcm catget pcm_doesnot_exist msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 5 } {
			InfoMsg "error" \
			  [pcm catget pcm_already_exists msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 7 } {
			InfoMsg "error" \
			  [pcm catget pcm_port_already_exists msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 12 } {
			InfoMsg "error" \
			  [pcm catget pcm_invalid_IP_address msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 13 } {
			InfoMsg "error" \
			  [pcm catget invalidportnumber msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 17 } {
			InfoMsg "error" \
			  [pcm catget invalidostype msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
	        } elseif { $errorNum == 22 } {
			InfoMsg "error" \
			  [ pcm catget invalidcname msg ] \
			  [ pcm catget pcm_general_error title ] wait
			return -1
		} elseif { $errorNum == 26 } {
			set err_msg [pcm catget file_doesnot_exist  msg] 
			set err_msg [format $err_msg [ $self.evfile getVal ]]
			InfoMsg "error" \
		  	   $err_msg \
		  	   [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $retval != 0 } {
			InfoMsg "error" \
			  [pcm catget pcm_amsmgr_err msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		}
	}

	InfoMsg "info" \
	  [pcm catget pcm_add_console msg] \
	  [pcm catget pcm_general_info title] wait

	return 0
}





#
#
select_plat_d.ok proc invokeCB {} {
	# Call the proc which will select the platform
	# and display it in the add console window.
	selectPlatform 
}

select_plat_d.plat_list proc doubleClkCB {} {
	# Call the proc which will select the platform
	# and display it in the add console window.
	selectPlatform
}

proc selectPlatform {} {
	set self select_plat_d
# --- find the platform name from the user selection 
	if { [ select_plat_d.plat_list selectedItemCount ] > 0 } {
		set current_item [ $self.plat_list getCurSelection ]
		scan $current_item "\{\{%s " item 
		add_cons_plat_d.platform_name setVal $item
	} else {
		InfoMsg error \
		  [ pcm catget noplatformselection msg ] \
		  [ pcm catget noplatformselection title ] wait
	}
	select_plat_d hide
	
}

select_plat_d.cancel proc invokeCB {} {
	select_plat_d hide
}



#===============================================
#             Modify platform callbacks
#===============================================

proc DisplayModifyPlatformWindow {} {

	set self w1.m_sys
	set current_item [ $self getCurSelection ]

	scan $current_item "\{\{%s %s %s %s" name platform model otherdata

#		mod_plat_marvel_d display
#	


	if { [getSeriesOfModel $model ] == "M" } {
		mod_plat_marvel_d display
	} else {
		mod_plat_wildfire_d display
	}

}




mod_plat_marvel_d proc displayCB {} {

	global cfile
	global amsmgr

	set self mod_plat_marvel_d

	set current_item [ w1.m_sys getCurSelection ]

	scan $current_item "\{\{%s %s %s" system_name current_platform otherdata

	set cmd [ concat \
		$amsmgr \
		"-view cmfconf -name " \
		$current_platform ]

	set retval [ catch { eval exec $cmd } line ]

#	--- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		  [pcm catget pcm_amsmgr_err msg] \
		  [pcm catget pcm_general_error title] wait
		return
	}


	# Get rid of leading whitespace.
	set line [string trimleft $line " \t"]

	set skipover [ctoken line " \t"] 
	$self.ip_address setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]

	#Skip the mngt port (always 23) 
   	set skipover [ctoken line " \t"]

	#Skip the mapped port
	set skipover [ctoken line " \t"]

	set model [ctoken line " \t"]
	$self.platform_type setVal $model
	$self.platform_name setVal [ctoken line " \t"]
	set skipspace [ctoken line "\""]
	set skipover [ctoken line "\""]
	set skipquote [ctoken line " \t"]
	$self.logging setVal [ctoken line " \t"]
	$self.monitoring setVal [ctoken line " \t"]
	$self.enable setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set event_file [ string trim [ctoken line " \t"] "\""]
	$self.evfile setVal $event_file

	# Get the description
	set skipspace [ctoken line "\""]
	set descr [ctoken line "\""]
	set descr [string trim $descr]
# we need to set the description back to empty for display purproses
	if { [string compare $descr "none"] == 0 } {
		set descr ""
	}

	$self.system_descr setVal $descr

	set skipspace [ctoken line " \t"]
	set templateId [ctoken line " \t"]

#get the template description from the file using the current template's ID
	set templateDes [getTemplateDescription $templateId]
	$self.templatesl setVal $templateDes

}



#=======================================================================
#

mod_plat_marvel_d.enable proc changeCB {} {

	set self mod_plat_marvel_d

#if the user turns console access off, then logging and monitoring 
#must also be turned off by disabling the check boxes.

	if { [ $self.enable getVal ] == 0 } {
		$self.logging disable
		$self.monitoring disable
	} else {
		$self.logging enable
		if { [ $self.logging getVal ] == 0 } {
			$self.monitoring setVal 0
			$self.monitoring disable
		} else {
			$self.monitoring enable
		}
	}
 
}

mod_plat_marvel_d.logging proc changeCB {} {

	set self mod_plat_marvel_d

	if { [ $self.logging getVal ] == 0 } {
		$self.monitoring setVal 0
		$self.monitoring disable
	} else {
		$self.monitoring enable
	}
}

#
# If a Wildfire platform is selected, then enable console access,
# and disable logging console output, and event generation.
#A.Dokos. Modified to have the TS console enabled

mod_plat_marvel_d.platform_type proc changeCB {} {

	set self mod_plat_marvel_d

	$self.enable setVal 1
	$self.enable enable
	$self.logging setVal 1
	$self.logging enable
	$self.monitoring setVal 1
	$self.monitoring enable	
	$self.evfile enable
	$self.b_files enable
	
}


# --- proc for the Event File Browse button click
mod_plat_marvel_d.b_files proc invokeCB {} {
	global parent

	set parent mod_plat_marvel_d
        eventfiles_d display
}


mod_plat_marvel_d.b_templatesl proc invokeCB {} {

	global parent

	set parent mod_plat_marvel_d

	templates_list_d display

}



#====================================================
# --- proc for accepting the modification of a 
#     managed Marvel platform list entry. Calls
#     modify_a_platform to do the actual modification.
#====================================================


mod_plat_marvel_d.ok proc invokeCB {} {

	set retval [modify_a_platform mod_plat_marvel_d]

	if { $retval == 0 } {
		mod_plat_marvel_d hide
	}
}


#====================================================
# --- proc to modify a marvel or a wildfire platform
#    
#====================================================

proc modify_a_platform {calling_window} {
	global cfile
	global amsmgr
	global errorCode
	global parent

	set self $calling_window
	set parent $self

#	--- check that all the fields are filled in
	if { [ string length [ $self.platform_name getVal ] ] == 0 ||
	     [ string length [ $self.ip_address getVal ] ] == 0 ||
	     [ string length [ $self.platform_type getVal ] ] == 0 
	} {
	   InfoMsg error \
	     [ pcm catget nodataerror msg ] \
	     [ pcm catget nodataerror title ] wait
	   return -1
	}
#  --- If platform is marvel validate the event definition file name if the user has entered a
#  --- event definition file.
	if { $calling_window == "mod_plat_marvel_d" } {

		if { [ string length [ $self.evfile getVal ] ] != 0 } {
		    set retval [is_valid_event_file_name]
	    	if { $retval != 0  } {
			InfoMsg error \
			   [ pcm catget invalidfilename msg ] \
		   	   [ pcm catget pcm_general_error  title ] wait
			return -1
	    	}
        }
	}
#
#	--- find the item in the list to be modified
	set current_item [ w1.m_sys getCurSelection ]

	scan $current_item "\{\{%s %s %s" current_name \
		current_platform otherdata

	set platform_name [$self.platform_name getVal]
	set ip_address [$self.ip_address getVal]
	set model [$self.platform_type getVal]
	set enable [$self.enable getVal]
	set comment [$self.system_descr getVal]

	
	
	if { $calling_window == "mod_plat_marvel_d" } {
		set logging [$self.logging getVal]
		set monitoring [$self.monitoring getVal]
		set tDescription [$self.templatesl getVal]
		set template [getTemplateId $tDescription]
		set ts_port_min 2001
		set ts_port_max 2008
	} else {
		set logging 0
		set monitoring 0
		set template ""
		set ts_port_min [$self.ts_port_min getVal]
		set ts_port_max [$self.ts_port_max getVal]
	}
	
	set newplat [ concat \
	$amsmgr \
	"-update platform " \
	"-name " \
	\"$platform_name\" \
	"-model " \
	\"$model\" \
	"-addr " \
	\"$ip_address\" \
	"-port 23" \
	"-enable " \
	\"$enable\" \
	"-logging " \
	\"$logging\" \
	"-events " \
	\"$monitoring\" \
	"-template " \
	\"$template\" \
	"-comment " \
	\"$comment\" \
	"-first_ts_port " \
	\"$ts_port_min\" \
	"-last_ts_port " \
	\"$ts_port_max\" \
	] 

	
	if { $calling_window == "mod_plat_marvel_d" } {
		set newplat [cconcat $newplat " -evfile \"[ $self.evfile getVal ]\""]
	}

	set retval [ catch { eval exec $newplat } output ]
	if { $retval != 0 } {
		set errorNum [lindex $errorCode 2]
		if { $errorNum == 26 } {
			set err_msg [pcm catget file_doesnot_exist  msg]
			set err_msg [format $err_msg [ $self.evfile getVal ]]
			InfoMsg "error" \
			   $err_msg \
			   [pcm catget pcm_general_error title] wait
			return -1
	        } elseif { $errorNum == 22 } {
		  InfoMsg "error" \
		     [ pcm catget invalidpname msg ] \
		     [ pcm catget pcm_general_error title ] wait
		  return -1
	        } elseif { $errorNum == 18 } {
		  InfoMsg "error" \
		     [ pcm catget invalidmodel msg ] \
		     [ pcm catget pcm_general_error title ] wait
		  return -1
                } elseif { $errorNum == 12 } {
	         InfoMsg "error" \
                     [pcm catget pcm_invalid_IP_address msg] \
                     [pcm catget pcm_general_error title] wait
	         return -1
                } elseif { $errorNum == 13 } {
	         InfoMsg "error" \
                     [pcm catget invalidportnumber msg] \
                     [pcm catget pcm_general_error title] wait
	         return -1
	        } elseif { $errorNum == 6 } {
		  InfoMsg "error" \
		     [format [pcm catget dupaddr msg] [$self.ip_address getVal]]\
		     [pcm catget pcm_general_error title] wait
		  return -1
	        } elseif { $errorNum == 5 } {
		  InfoMsg "error" \
		     [pcm catget pcm_platform_exists msg] \
		     [pcm catget pcm_general_error title] wait
		  return -1
		} elseif { $errorNum > 0 } {
#	   --- an error occurred in amsmgr. tell the user 
#              then return without modifying the record
                InfoMsg "error" \
                    [pcm catget pcm_amsmgr_err msg] \
                    [pcm catget pcm_general_error title] wait
		return -1
	      }
	}

	InfoMsg "info" \
		[pcm catget pcm_modify_platform msg] \
		[pcm catget pcm_general_info title] wait

	return 0
}

#================================================
# ---mod_plat_marvel_d.cancel
#================================================

mod_plat_marvel_d.cancel proc invokeCB {} {
	mod_plat_marvel_d hide
}


#================================================
# ---mod_plat_marvel_d.help
#================================================

mod_plat_marvel_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddSysDB 
}



#================================================
#     Modify  wildfire platform procs
#================================================

mod_plat_wildfire_d proc displayCB {} {

	global cfile
	global amsmgr

	set self mod_plat_wildfire_d

	set current_item [ w1.m_sys getCurSelection ]

	scan $current_item "\{\{%s %s %s" system_name current_platform otherdata

	set cmd [ concat \
		$amsmgr \
		"-view cmfconf -name " \
		$current_platform ]

	set retval [ catch { eval exec $cmd } line ]

#	--- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		[pcm catget pcm_amsmgr_err msg] \
		[pcm catget pcm_general_error title] wait
		return
	}


# Get rid of leading whitespace.
	set line [string trimleft $line " \t"]
	set skipover [ctoken line " \t"] 
	$self.ip_address setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]

#We do not display the mgmt port anymore. Skip it. -AD
	set skipover [ctoken line " \t"]

   	set skipover [ctoken line " \t"]
	set model [ctoken line " \t"]
	$self.platform_type setVal $model

	$self.platform_name setVal [ctoken line " \t"]

	set skipspace [ctoken line "\""]
	set skipover [ctoken line "\""]
	set skipquote [ctoken line " \t"]

#	skip logging and monitoring	
  	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]

	$self.enable setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]

#skip the event file
#	
	set skipover [ctoken line " \t"]
	set skipquote [ctoken line "\""]
	set descr [ctoken line "\""]
	set descr [string trim $descr]
	if { [string length $descr] != 0 } { 
		set skipquote [ctoken line " \t"]
	}

# we need to set the description back to empty for display purproses
	if { [string compare $descr "none"] == 0 } {
		set descr ""
	}

	$self.system_descr setVal $descr

#skip the template
	set skipover [ctoken line " \t"]

	$self.ts_port_min setVal [ctoken line " \t"]
	$self.ts_port_max setVal [ctoken line " \t"]


}


#====================================================
# --- proc for accepting the modification of a 
#     managed Wildfire platform list entry
#====================================================

mod_plat_wildfire_d.ok proc invokeCB {} {

	set retval [modify_a_platform mod_plat_wildfire_d]

	if { $retval == 0 } {
		mod_plat_wildfire_d hide
	}
}




mod_plat_wildfire_d.cancel proc invokeCB {} {
	mod_plat_wildfire_d hide
}

mod_plat_wildfire_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddSysDB 
}


# --- proc for the Event File Browse button click

proc DisplayModifyConsoleWindow {} {

	set self w1.m_sys
        set current_item [ $self getCurSelection ]

	scan $current_item "\{\{%s %s %s %s" name platform model otherdata

	if { $model == "<other>" } {
		mod_cons_generic_d display
	} else {
		mod_cons_plat_d display
	}
}

proc PopulateModifyConsoleWindow { win } {

	global cfile
	global amsmgr

	set self w1.m_sys
        set current_item [ $self getCurSelection ]

	scan $current_item "\{\{%s %s" current_name otherdata

	set cmd [ concat \
		$amsmgr \
		"-view cmfconf -name " \
		$current_name ]

	set retval [ catch { eval exec $cmd } line ]

#	--- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		  [pcm catget pcm_amsmgr_err msg] \
		  [pcm catget pcm_general_error title] wait
		return
	}

	set self $win

	# Get rid of leading whitespace.
	set line [string trimleft $line " \t"]

	$self.system_name setVal [ctoken line " \t"] 

	# The "mod_cons_generic_d" window has the IP address field.
	if { $self == "mod_cons_generic_d" } {
		$self.ip_address setVal [ctoken line " \t"]
	} else {
		set skipover [ctoken line " \t"]
	}

	$self.port setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]


	# The "mod_cons_plat_d" window has the platform name field.
	if { $self == "mod_cons_plat_d" } {
		$self.platform_name setVal [ctoken line " \t"]
		set skipspace [ctoken line "\""]
		$self.os_type setVal [ctoken line "\""]
		set skipquote [ctoken line " \t"]
	} else {
		set skipover [ctoken line " \t"]
		set skipspace [ctoken line "\""]
		set skipover [ctoken line "\""]
		set skipquote [ctoken line " \t"]
	}

	$self.logging setVal [ctoken line " \t"]
	$self.monitoring setVal [ctoken line " \t"]
	$self.enable setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	$self.evfile setVal [string trim [ctoken line " \t"] "\""]

	# The last field should be the description. Get 
	# rid of leading and trailing quotes and 
	# whitespace.

	set skipquote [ctoken line "\""]


	set descr [ctoken line "\""]
	set descr [string trim $descr]

# we need to set the description back to empty for display purproses
	if { [string compare $descr "none"] == 0 } {
	set descr ""
	}

	$self.system_descr setVal $descr

}

proc enable_ChangeCB { win } {

	set self $win

	if { [ $self.enable getVal ] == 0 } {
		$self.logging disable
		$self.monitoring disable
	} else {
		$self.logging enable
		if { [ $self.logging getVal ] == 0 } {
			$self.monitoring setVal 0
			$self.monitoring disable
		} else {
			$self.monitoring enable
		}
	}
}

proc logging_ChangeCB { win } {

	set self $win

	if { [ $self.logging getVal ] == 0 } {
		$self.monitoring setVal 0
		$self.monitoring disable
	} else {
		$self.monitoring enable
	}
}

proc mod_cons_OK_InvokeCB { win } {

	global cfile
	global amsmgr
	global errorCode
	global parent

	set self $win
	set parent $self

#	--- check that all the fields are filled in

	set missing_data 0

	# The "mod_cons_generic_d" window has the IP address field which
	# needs to be validated.
	if { $win == "mod_cons_generic_d" } {
		if { [ string length [ $self.system_name getVal ] ] == 0 } {
			set missing_data 1
		}
	}

	if { [ string length [ $self.system_name getVal ] ] == 0 ||
	     [ string length [ $self.port getVal ] ] == 0 
	   } { 
		set missing_data 1
	}

	if { $missing_data == 1 } {
		InfoMsg error \
		  [ pcm catget nodataerror msg ] \
		  [ pcm catget nodataerror title ] wait
		return -1
	}

#  --- validate the event definition file name if the user has entered a
#  --- event definition file.
	if { [ string length [ $self.evfile getVal ] ] != 0 } {
	    set retval [is_valid_event_file_name]
	    if { $retval != 0 } {
		InfoMsg error \
		   [ pcm catget invalidfilename msg ] \
		   [ pcm catget pcm_general_error  title ] wait
		return -1
            } 
	}
#
#	--- find the item in the list to be modified
	set current_item [ w1.m_sys getCurSelection ]

	scan $current_item "\{\{%s %s %s %s" current_name \
		current_platform platform_type otherdata
		
	set newsys [ concat \
		$amsmgr \
		"-update system " \
		"-name " \
		"$current_name " \
		"-newname " \
		\"[ $self.system_name getVal ]\" \
		"-port " \
		\"[ $self.port getVal ]\" \
		"-enable " \
		\"[ $self.enable getVal ]\" \
		"-logging " \
		\"[ $self.logging getVal ]\" \
		"-events " \
		\"[ $self.monitoring getVal ]\" \
		"-evfile " \
		\"[ $self.evfile getVal ]\" \
		"-comment " \
		\"[ $self.system_descr getVal ]\" \
		]

	# If it's the "mod_cons_generic_d" window, then we need to also
	# include the IP address.
	if { $win == "mod_cons_generic_d" } {
		# Append the IP address at the end of the command line.
		set newsys [cconcat $newsys " -addr \"[$self.ip_address getVal]\""]
	}
	
	# If the user is modifying a platform console and user
	# has enter the OS type, then we need to include -type
	if { $win == "mod_cons_plat_d" } {
		if { [string length [$self.os_type getVal] ] != 0 } {
			# Append the -type at the end of the command line.
			set newsys [cconcat $newsys " -type \"[$self.os_type getVal ]\""]
		}
	}

	set retval [ catch { eval exec $newsys } output ]

#	--- if an error occurred in amsmgr, tell the user 
#           then return without modifying the record
	if { $retval != 0 } {
		set errorNum [lindex $errorCode 2]
		if { $errorNum == 26 } {
			set err_msg [pcm catget file_doesnot_exist  msg]
			set err_msg [format $err_msg [ $self.evfile getVal ]]
			InfoMsg "error" \
			   $err_msg \
			   [pcm catget pcm_general_error title] wait
			return -1
	        } elseif { $errorNum == 22 } {
			InfoMsg "error" \
			  [ pcm catget invalidcname msg ] \
			  [ pcm catget pcm_general_error title ] wait
			return -1
		} elseif { $errorNum == 5 } {
			InfoMsg "error" \
			  [pcm catget pcm_already_exists msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 7 } {
			InfoMsg "error" \
			  [pcm catget pcm_port_already_exists msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 12 } {
			InfoMsg "error" \
			  [pcm catget pcm_invalid_IP_address msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 13 } {
			InfoMsg "error" \
			  [pcm catget invalidportnumber msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum == 17 } {
			InfoMsg "error" \
			  [pcm catget invalidostype msg] \
			  [pcm catget pcm_general_error title] wait
			return -1
		} elseif { $errorNum > 0 } {
			InfoMsg "error" \
			  [pcm catget pcm_amsmgr_err msg] \
			  [pcm catget pcm_general_error title] wait
			return
		}
	}

	InfoMsg "info" \
	  [pcm catget pcm_modify_console msg] \
	  [pcm catget pcm_general_info title] wait

	$self hide
}

mod_cons_generic_d proc displayCB {} {

	PopulateModifyConsoleWindow "mod_cons_generic_d"

}

mod_cons_plat_d proc displayCB {} {

	PopulateModifyConsoleWindow "mod_cons_plat_d"

}



#
# --- if the user turns console access off, then logging and monitoring
#     must also be turned off and made insensitive.
mod_cons_plat_d.enable proc changeCB {} {

	enable_ChangeCB  "mod_cons_plat_d"

}

mod_cons_generic_d.enable proc changeCB {} {

	enable_ChangeCB  "mod_cons_generic_d"

}

#
# --- if the user turns logging off, then monitoring must also
#     be turned off and made insensitive.
mod_cons_plat_d.logging proc changeCB {} {

	logging_ChangeCB "mod_cons_plat_d"
}

mod_cons_generic_d.logging proc changeCB {} {

	logging_ChangeCB "mod_cons_generic_d"
}

# --- proc for the Event File Browse button click
mod_cons_plat_d.b_files proc invokeCB {} {
	global parent

	set parent mod_cons_plat_d
        eventfiles_d display
}

mod_cons_generic_d.b_files proc invokeCB {} {
	global parent

	set parent mod_cons_generic_d
        eventfiles_d display
}

#
# --- proc for accepting the modification of a 
#     managed system list entry
#
mod_cons_plat_d.ok proc invokeCB {} {

	mod_cons_OK_InvokeCB "mod_cons_plat_d"

}

mod_cons_generic_d.ok proc invokeCB {} {

	mod_cons_OK_InvokeCB "mod_cons_generic_d"

}
	
mod_cons_plat_d.cancel proc invokeCB {} {
	mod_cons_plat_d hide
}

mod_cons_generic_d.cancel proc invokeCB {} {
	mod_cons_generic_d hide
}

mod_cons_plat_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddModConsoleDB 
}

mod_cons_generic_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn AddModGenConsoleDB
}

mod_cons_plat_d.b_ostype proc invokeCB {} {

	global parent

	set parent mod_cons_plat_d

	ostype_list_d display
}

del_plat_d proc displayCB {} {
	global cfile
	global amsmgr

# 
# --- find the platform to delete
#
	set self w1.m_sys
	set current_item [ $self getCurSelection ]
	scan $current_item "\{\{%s %s %s" current_name \
		 current_platform otherdata

	set cmd [ concat \
		$amsmgr \
		"-view cmfconf -name " \
		$current_platform ]

	set retval [ catch { eval exec $cmd } line ]
#       --- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		  [pcm catget pcm_amsmgr_err msg] \
		  [pcm catget pcm_general_error title] wait
		return
	}

	set self del_plat_d

        # Get rid of leading whitespace.
	set line [string trimleft $line " \t"]

	set skipover [ctoken line " \t"] 
	$self.ip_address setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]

#	$self.mgmt_port setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]

	set skipover [ctoken line " \t"]
	$self.platform_type setVal [ctoken line " \t"]
	$self.platform_name setVal [ctoken line " \t"]
	set skipspace [ctoken line "\""]
	set skipover [ctoken line "\""]
	set skipquote [ctoken line " \t"]

#	$self.logging setVal [ctoken line " \t"]
#	$self.monitoring setVal [ctoken line " \t"]
#	$self.enable setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]

	set skipover [ctoken line " \t"]

#	$self.evfile setVal [string trim [ctoken line " \t"] "\""]
	set skipover [ctoken line " \t"]

	set skipspace [ctoken line "\""]
	set descr [ctoken line "\""]
	set descr [string trim $descr]

# we need to set the description back to empty for display purproses
	if { [string compare $descr "none"] == 0 } {
		set descr ""
	}

	$self.system_descr setVal $descr


}

del_plat_d.ok proc invokeCB {} {
	global cfile
	global amsmgr

	set self w1.m_sys
	set current_platform [del_plat_d.platform_name getVal]

#	--- Read the list to see whether there are any consoles
#	    configured on this platform.

	set listSize [$self sizeOfList]
	set count 0
	while { $listSize > 0 } {
		set item [ $self getDspStr [incr listSize -1] ] 
		scan $item "\{\{%s %s" system_name platform 
		if { $platform == $current_platform } {
			incr count 
		} 
	}
#       --- If there are configured consoles associated with this
#	    platform, reconfirm whether to proceed with the delete 

	if { $count > 1 } {  
		 set warn_msg [format [pcm catget confirm_delete_d_delete_l lbl] \
				 [incr count -1] ]
		 confirm_delete_d.delete_l setVal $warn_msg
		 confirm_delete_d display
	} else {
#	--- There are no consoles associated with this platform , so
#	    delete platform 		

		set cmd [ concat \
			$amsmgr \
			"-remove platform -name " \
			$current_platform ]

		set retval [ catch { eval exec $cmd } output ]
	

#	--- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
		if { $retval != 0 } {
			InfoMsg "error" \
			  [pcm catget pcm_amsmgr_err msg] \
			  [pcm catget pcm_general_error title] wait
			return
		}
		del_plat_d hide
	}
}

del_plat_d.cancel proc invokeCB {} {
	del_plat_d hide
}

del_plat_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn DelSysDb 
}

confirm_delete_d.yes proc invokeCB {} {

	global amsmgr

	set self del_plat_d
	set current_platform [$self.platform_name getVal]

	set cmd [ concat \
		$amsmgr \
		"-remove platform -name " \
		$current_platform ]

	set retval [ catch { eval exec $cmd } output ]
	

#	--- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		  [pcm catget pcm_amsmgr_err msg] \
		  [pcm catget pcm_general_error title] wait
		return
	}
	confirm_delete_d hide
	del_plat_d hide
}

confirm_delete_d.no proc invokeCB {} {
	confirm_delete_d hide
	del_plat_d hide
}

del_cons_d proc displayCB {} {
	global cfile
	global amsmgr

# 
# --- find the system to delete
#
	set self w1.m_sys
	set current_item [ $self getCurSelection ]

	scan $current_item "\{\{%s %s" current_name otherdata
	
	set cmd [ concat \
		$amsmgr \
		"-view cmfconf -name " \
		$current_name ]

        set retval [ catch { eval exec $cmd } line ]
#       --- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		  [pcm catget pcm_amsmgr_err msg] \
		  [pcm catget pcm_general_error title] wait
		return
	}

	set self del_cons_d

        # Get rid of leading whitespace.
	set line [string trimleft $line " \t"]

	$self.system_name setVal [ctoken line " \t"] 
	set skipover [ctoken line " \t"]
	$self.port setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	$self.platform_name setVal [ctoken line " \t"]
	set skipspace [ctoken line "\""]
	set skipover [ctoken line "\""]
	set skipquote [ctoken line " \t"]

#	$self.logging setVal [ctoken line " \t"]
#	$self.monitoring setVal [ctoken line " \t"]
#	$self.enable setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]

	set skipover [ctoken line " \t"]
#	$self.evfile setVal [string trim [ctoken line " \t"] "\""]
	set skipover [ctoken line " \t"]

	set skipquote [ctoken line "\""]
	set descr [ctoken line "\""]
	set descr [string trim $descr]

# we need to set the description back to empty for display purproses
	if { [string compare $descr "none"] == 0 } {
		set descr ""
	}

	$self.system_descr setVal $descr

}

del_cons_d.ok proc invokeCB {} {
	global cfile
	global amsmgr

	set self del_cons_d

	set cmd [ concat \
		$amsmgr \
		"-remove system -name " \
		[ $self.system_name getVal ] ]

	set retval [ catch { eval exec $cmd } output ]

#	--- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		  [pcm catget pcm_amsmgr_err msg] \
		  [pcm catget pcm_general_error title] wait
		return
	}

	del_cons_d hide
}

del_cons_d.cancel proc invokeCB {} {
	del_cons_d hide
}

del_cons_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn DelConsoleDB 
}

#
# --- Delete generic consoles.
#
del_gen_cons_d proc displayCB {} {
	global cfile
	global amsmgr

# 
# --- find the system to delete
#
	set self w1.m_sys
	set current_item [ $self getCurSelection ]

	scan $current_item "\{\{%s %s" current_name otherdata
	
	set cmd [ concat \
		$amsmgr \
		"-view cmfconf -name " \
		$current_name ]

        set retval [ catch { eval exec $cmd } line ]
#       --- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		  [pcm catget pcm_amsmgr_err msg] \
		  [pcm catget pcm_general_error title] wait
		return
	}

	set self del_gen_cons_d

        # Get rid of leading whitespace.
	set line [string trimleft $line " \t"]

	$self.system_name setVal [ctoken line " \t"] 
	$self.ip_address setVal [ctoken line " \t"]
	$self.port setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipspace [ctoken line "\""]
	set skipover [ctoken line "\""]
	set skipquote [ctoken line " \t"]
#	$self.logging setVal [ctoken line " \t"]
#	$self.monitoring setVal [ctoken line " \t"]
#	$self.enable setVal [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]
	set skipover [ctoken line " \t"]

	set skipover [ctoken line " \t"]
#	$self.evfile setVal [string trim [ctoken line " \t"] "\""]
	set skipover [ctoken line " \t"]
	
	set skipspace [ctoken line "\""]
	set descr [ctoken line "\""]
	set descr [string trim $descr]
# we need to set the description back to empty for display purproses
	if { [string compare $descr "none"] == 0 } {
		set descr ""
	}

	$self.system_descr setVal $descr




}

del_gen_cons_d.ok proc invokeCB {} {
	global cfile
	global amsmgr

	set self del_gen_cons_d

	set cmd [ concat \
		$amsmgr \
		"-remove system -name " \
		[ $self.system_name getVal ] ]

	set retval [ catch { eval exec $cmd } output ]

#	--- if an error occurred in amsmgr, tell the user 
#           then return without deleting the record
	if { $retval != 0 } {
		InfoMsg "error" \
		  [pcm catget pcm_amsmgr_err msg] \
		  [pcm catget pcm_general_error title] wait
		return
	}

	del_gen_cons_d hide
}

del_gen_cons_d.cancel proc invokeCB {} {
	del_gen_cons_d hide
}

del_gen_cons_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn DelConsoleDB 
}

# --- procs to launch tools
mgmt_d.ok proc invokeCB {} {
	global stat
	global hostname
	global platname
	global env
	global SysmanUi
	global cmfrestart
	global cmfstop
	global sendmsgallflg

	set self w1.m_sys
#
# --- get currently selected list item
	set list_item [ $self getCurSelection ]
#
# --- parse the hostname out of the string
	# The display string is in the form of key list.
	set keylist [lindex $list_item 0]
	set key [lindex $keylist 0]

	# Hostname is the first element of the key.
	set hostname [lindex $key 0]
	set platname [lindex $key 1]
#          --- get the chosen option
	set chosen_opt [mgmt_d.mgmt_opts getVal]
	if { $chosen_opt == "os_mgr" } {
#          --- launch sysman against that host
	   bgexec stat sysman -ui gui -display $env(DISPLAY) -host $hostname &
	} elseif { $chosen_opt == "part" } {
#               --- launch CAPM
#	   bgexec stat /usr/opt/ams/bin/capmgui $env(DISPLAY) &
	      InfoMsg warning \
		[ pcm catget nocapm msg ] \
		[ pcm catget nocapm title ] wait
	} elseif { $chosen_opt == "send_msg_all" } {
		    mgmt_d hide
		    set sendmsgallflg 1
		    send_msg_d display
	} elseif { $chosen_opt == "cmf_start_stop" } {
	   mgmt_d hide
	   cmf_start_stop_d display
	} elseif { $chosen_opt == "map_port" } {
	   mgmt_d hide
	   mapped_ports_list_d display
	} elseif { $chosen_opt == "archive_int" } {
	   mgmt_d hide
	   archive_int_d display
	}

	mgmt_d hide
}

mgmt_d.cancel proc invokeCB {} {
	mgmt_d hide
	}

mgmt_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ToolsDB
}

options_d.ok proc invokeCB {} {
	options_d hide
	}

options_d.cancel proc invokeCB {} {
	options_d hide
	}

# --- proc not being used.
# --- replaced with update_console_status
proc update_console_and_os_status {} {

	global mbm_suf
	global ts_suf

	set self w1.m_sys

	# Save the currently selected item (if any). The reason for this is
	# because we lose the selected item in the list when we update
	# the list below. We need to save the selected item prior to updating
	# the list so we can set it back after we update the list.
	set cur_sel [$self curSelection]

	set list_len [$self sizeOfList]

	for { set i 0 } { $i < $list_len } { incr i } {
		set disp_str [$self getDspStr $i]

		set keylist [lindex $disp_str 0]
		set key [lindex $keylist 0]
		set val [lindex $keylist 1]

		set tag [lindex $key 0]
		set platname [lindex $key 1]

# 	        --- commented out until implemented
#		set os_status [get_os_status $tag]
#
#		--- If the console name in main window is displayed as 
#		--- platformname_MBM or platformname_TS, we need to pass 
#		--- the platform name to get the status information.

		if { [string compare $tag $platname$mbm_suf] == 0 ||
		    [string compare $tag $platname$ts_suf] == 0 } {
			set tag $platname
		}

		set console_in_use [get_console_in_use $tag]

		# lreplace will barf if the fields specified are null.
		set key [lreplace $key 3 3 $console_in_use]

		# We can't use the "keylset" command because it barfs
		# when it finds a "." in the key, such as in the case
		# of the "comments" field. We'll construct the keylist
		# ourselves.
		set keylist [list $key $val]
		set disp_str [list $keylist]

		$self modifyDspStr $i $disp_str
	}

	if { $cur_sel != "" } {
		$self setSelection $cur_sel
	}

	after 12000 update_console_and_os_status
}

#
# currently, this proc is not being used. We don't have any
# mechanism to determine os status on a reliable basis.
proc get_os_status { tag } {
        # get_os_status checks to see that a cmf connection
        # for this console was established.
        set cmd_status "/usr/opt/ams/bin/cmfmgr show console $tag"
        set retval [catch { eval exec $cmd_status } output ]

        if { $retval == 0 } {
            # get line which has what we need
            set line2 [ ctoken output "\n " ]
            set cons [ ctoken line2 " \t" ]

            # cons should contain the console name, check it.
            if { $cons == $tag } {
                # get the next token, that should be the status
                set os_stat [ ctoken line2 "\n"]
                if { $os_stat == 1 } {
                    return [ pcm catget status up ]
                } else {
                    return [ pcm catget status down]
                }
            }
        }
}

# --- proc not being used.
# --- replaced with get_status_for_all_consoles
proc get_console_in_use { tag } {

# Determine the state of the console
# 
	global sock
	global cookiefile
	global noconnection
	global wait_on_cmfd_restart

#
#	--- if the daemon is being restarted or has been stopped,
#	    don't try to connect until the daemon is back up
	if { $wait_on_cmfd_restart == 1 } {
           return [ pcm catget console unknown ]
	}

#	--- we'll connect to the local system's 6500 port
#           where the cmf daemon resides
	if { $sock == 0 || $noconnection == 0 } {
#	--- open the socket connection
	   set host "localhost"
           set port 6500
#
#       --- try to connect via a socket to the cmf daemon.
	   set sock [Connect_Socket $host $port]

	   if { $sock == 0 } {
#
#          --- couldn't connect to the cmf daemon, so we can't
#              determine what the state of the consoles are. 

              return [ pcm catget console unknown ]
	   } else {
#	     --- have a good connection, so tell the daemon to
#	         init a structure of information. In addition,
#		 pass a cookie for security.
#
#            --- open the cookie file
	     set retval [ catch { open $cookiefile r } InFile ]
	     if { $retval != 0 } {
	        general_error
	        return
	     }
	     gets $InFile cookie
	     close $InFile
#
#	     --- create an initializing message for the daemon
#                from the keyword 'token', the cookie, and an
#		 init string, then send it to the daemon
	     set msg [ concat token $cookie @@@@ ]
	     puts $sock $msg
	   }
	}
#
#       --- established a socket connection, and we
#           know the daemon is responding

	set cmd "console $tag"

        puts -nonewline $sock $cmd
        flush $sock

	set mesg [read $sock 8]

#
#       --- if the socket connection to the daemon has been
#       lost due to the daemon being killed or crashing, then the 
#       read message will have no length. Set the socket to zero
#       and return a status of unknown

	if { [string length $mesg] == 0 } {
	   set sock 0
	   set noconnection 0
           return [ pcm catget console unknown ]
	}

        binary scan $mesg i1i1 type mesg_num

        set numberOfMessages $mesg_num

        if { $type == 1 } {
                for { set i 0 } { $i < $numberOfMessages } { incr i } {
                        set cname [read $sock 64] 
                        set ipaddr [read $sock 64] 
                        set cport [read $sock 2]
                        binary scan $cport s1 cons_port
                        set mport [read $sock 2]
                        binary scan $mport s* mgmt_port
                        set model [read $sock 64] 
                        set pname [read $sock 64] 
                        set status [read $sock 2] 
                        if { [string compare -length 1 $status 1] == 0 } {
                            set mode [read $sock 2]
                        }
                }   
		if { $numberOfMessages > 0 } {
	                if { [string compare -length 1 $status 0] == 0 } {
	                    return [ pcm catget console open ]
	                } elseif { [string compare -length 1 $status 1] == 0 } {
	                    if { [string compare -length 1 $mode 1] == 0 } {
	                        return [ pcm catget console busyro ]
	                    } elseif { [string compare -length 1 $mode 2] == 0 } {
	                        return [ pcm catget console busysh ]
	                    } elseif { [string compare -length 1 $mode 3] == 0 } {
	                        return [ pcm catget console busyex ]
	                    } elseif { [string compare -length 1 $mode 4] == 0 } {
	                        return [ pcm catget console busyer ]
	                    } else {
	                        return [ pcm catget console busy ]
	                    }
	                } elseif { [string compare -length 1 $status 2] == 0 } {
	                    return [ pcm catget console inaccessible ]
	                } elseif { [string compare -length 1 $status 3] == 0 } {
	                    return [ pcm catget console refused ]
	                } elseif { [string compare -length 1 $status 4] == 0 } {
	                    return [ pcm catget console trying ]
	                } elseif { [string compare -length 1 $status 5] == 0 } {
	                    return [ pcm catget console disabled ]
	                } else {
	                    return [ pcm catget console unknown ]
	                }
		}
        } else {
#		--- the daemon is returning a bad type for some
#                   reason, so close the socket. It will be 
#                   reopened automatically after the refresh
#                   period.

		catch { close $sock }
		set sock 0
	        set noconnection 1
                return [ pcm catget console unknown ]
	}
}

#
# --- opens a socket connection to the specified host and port
#
proc Connect_Socket { host port } {
	global noconnection
	global DisplayErrMsg

#	--- noconnection == 1 indicates a connection
#	--- noconnection == 0 indicates NO connection
#
#	--- DisplayErrMsg == 1 indicates that the error message should be displayed.
#	--- This is used to prevent the error message from poppin up everytime
#	--- this proc is called. Instead, the error message is displayed only
#	--- when there is no connection to cmfd when PCM is started, or when
#	--- a connection that has been established is lost.
	if { ![info exists DisplayErrMsg] } {
		set DisplayErrMsg 1
	}

        if { [catch { socket $host $port } sock ] } {
	   if { $DisplayErrMsg == 1 } {
              set DisplayErrMsg 0
              InfoMsg error \
                 [pcm catget pcm_socket_err msg] \
                 [pcm catget pcm_socket_err title] wait
	   }
	   set noconnection 0
           return 0
        } else {
           fconfigure $sock -translation { binary binary } \
                        -buffering line -encoding binary
	   set noconnection 1
	   set DisplayErrMsg 1
           return $sock
        }
}

proc general_error { } {
           InfoMsg "error" \
              [pcm catget pcm_general_error msg] \
              [pcm catget pcm_general_error title] wait
}

#
# --- cmfd Start/Stop display window
#
cmf_start_stop_d proc displayCB {} {

	global cmfd_cmd

	set retval [catch { eval exec $cmfd_cmd status } output ]
	if { [ string compare $output "cmfd is running" ] != 0 } {
		set output "cmfd is NOT running"
	}
	set status_val [pcm catget cmf_start_stop_d_status lbl]
	set status_val [format $status_val $output]
	$self.status setLabel $status_val

}

cmf_start_stop_d.ok proc invokeCB {} {

	set chosen_opt [cmf_start_stop_d.cmfd_opts getVal ]

	if { $chosen_opt == "restart" } { 
		cmf_start_stop_d hide
#	--- confirm the restart
		set ret [ cmfd_confirm $chosen_opt ]
	} elseif { $chosen_opt == "stop" } {
		cmf_start_stop_d hide
#	--- confirm the stop
		set ret [ cmfd_confirm $chosen_opt ]
	}
}

cmf_start_stop_d.cancel proc invokeCB {} {
	cmf_start_stop_d hide
}

cmf_start_stop_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ToolsRestartStopDB
}

#
# --- Setting log archiving interval window
#
archive_int_d proc displayCB {} {

	global amsmgr
	global amsconf_file 
	global arch_var

	set retval [catch { eval exec $amsmgr -config $amsconf_file -get $arch_var} output ]

	if { $retval != 0 } {
		InfoMsg error \
			[pcm catget cannot_open_amsconf msg] \
			[pcm catget pcm_general_error title] wait
		return
	} else {
		$self.arch_time setVal $output
	}
}

archive_int_d.ok proc invokeCB {} {

	global amsmgr
	global amsconf_file 
	global arch_var

	set parent archive_int_d

	set new_archtime [ $parent.arch_time getVal]

	if { [ctype digit $new_archtime ] !=1 } {
		InfoMsg error \
			[pcm catget invalid_arch_time msg] \
			[pcm catget pcm_general_error title] wait
		return
	}

	set retval [catch { eval exec $amsmgr -config $amsconf_file -set $arch_var=$new_archtime } output]

	if { $retval != 0 } {
		InfoMsg error \
			[pcm catget cannot_open_amsconf msg] \
			[pcm catget pcm_general_error title] wait
		return
	}

	archive_int_d hide
}

archive_int_d.cancel proc invokeCB {} {
	archive_int_d hide
}

archive_int_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ToolsViewLogArchDB
}

#
# --- ask the user to confirm that they want to stop or restart the
#     cmfd daemon
proc cmfd_confirm {option} {

	if { $option == "restart" } {
	   cmfd_restart_confirm_d display
	} elseif { $option == "stop" } {
	   cmfd_stop_confirm_d display
	}
}

cmfd_restart_confirm_d.yes proc invokeCB {} {
	cmfd_restart_confirm_d hide
	cmfd_restart { 0 }
}

cmfd_restart_confirm_d.no proc invokeCB {} {
	cmfd_restart_confirm_d hide
}

cmfd_stop_confirm_d.yes proc invokeCB {} {
	cmfd_stop_confirm_d hide
	cmfd_restart { 1 }
}

cmfd_stop_confirm_d.no proc invokeCB {} {
	cmfd_stop_confirm_d hide
}

proc cmfd_restart {option} {
	   global env
	   global SysmanUi
	   global cmfd_cmd
	   global wait_on_cmfd_restart

#
#	   --- set a flag which prevents a console status
#	       update upon a restart
	   set wait_on_cmfd_restart 1

	   set opt [expr $option]
	   set cmfd_cmd_opt(0) "restart"
	   set cmfd_cmd_opt(1) "stop"

           if { $SysmanUi == "menu" } {
              ctk_endwin
              if { [set pid [fork]] == 0 } {
                 execl $cmfd_cmd $cmfd_cmd_opt($opt)
              }
              wait $pid
              ctk_refresh
           } else {
	      if { $opt == 0 } { 
	         set wintitle [ concat \
                              [ pcm catget restart cmf ] ]
	      } else {
	         set wintitle [ concat \
                              [ pcm catget stop cmf ] ]
	      }
              bgexec stat /usr/bin/X11/xterm \
		-sl 500 -display $env(DISPLAY) -sb -bg black -fg green \
		-geometry 80x12 -T $wintitle \
		-e $cmfd_cmd $cmfd_cmd_opt($opt) &
           }

#
#	   --- reset the flag which prevents a console status
#	       update upon a restart. Keep it in effect when
#              the daemon is stopped.
	   if { $opt == 0 } {
	      set wait_on_cmfd_restart 0
           }
}

#
# --- a hack to fix the 24 line, no button problem
#
#w1.m_sys proc _makeLstBox {args} {
#     set _lstbox [eval $self next $args]
#
#     global SuitUi
#     if {[cequal $SuitUi cui]} {
#        $_lstbox configure -height 4
#     }
#
#     return $_lstbox
#}

#w1.c_out proc _makeLstBox {args} {
#     set _lstbox [eval $self next $args]
#
#     global SuitUi
#     if {[cequal $SuitUi cui]} {
#        $_lstbox configure -height 4
#     }
#
#     return $_lstbox
#}

# --- proc to validate the event definition file name
proc is_valid_event_file_name {} {
	global parent

	set len [ string length [$parent.evfile getVal] ]
	#  --- validate the event definition file name 
        # File name cannot begin with a "."
        if { [ string match ".*" [$parent.evfile getVal] ] } {
                return -1
        } 
        # File name can contain only alphanumerics,
        # period , hyphen or an underscore
        for { set i 0 } { $i < $len } { incr i } {
                set ch [ string index [$parent.evfile getVal] $i ]
                if { [string is alnum $ch] } {
                        continue
                } elseif { $ch == "."  } {
                        continue
                } elseif { $ch == "-"  } {
                        continue
                } elseif { $ch == "_"  } {
                        continue
                } else {
                        return -1
                }
        }
	return 0
}

events_create_import_d.evfile_list proc _makeLstBox {args} {
     set _lstbox [eval $self next $args]

     global SuitUi
     if {[cequal $SuitUi cui]} {
        $_lstbox configure -height 4
     }

     return $_lstbox
}

events_create_import_d.pat_list proc  _makeLstBox {args} {
     set _lstbox [eval $self next $args]

     global SuitUi
     if {[cequal $SuitUi cui]} {
        $_lstbox configure -height 4
     }

     return $_lstbox
}

#
# begin - proc to get connection to cmfd
# if no connection, returns -1
# on connection, returns $sock
proc get_connection { } {
        global sock
        global noconnection
        global cookiefile
        global wait_on_cmfd_restart

#       --- we'll connect to the local system's 6500 port
#                     where the cmf daemon resides
        if { $sock == 0 || $noconnection == 0 } {
#               --- open the socket connection
                set host "localhost"
                set port 6500
#
#                --- try to connect via a socket to the cmf daemon.
                set sock [Connect_Socket $host $port]
                if { $sock == 0 } {
#                        --- couldn't connect to the cmf daemon.
                        set noconnection 0
                        return -1
                } else {
#                       --- have a good connection, so tell the daemon to
#                            init a structure of information. In addition,
#                            pass a cookie for security.
#                       --- open the cookie file
                        set retval [ catch { open $cookiefile r } InFile ]
                        if { $retval != 0 } {
                                general_error
                                return -1
                        }
                        gets $InFile cookie
                        close $InFile
#
#                       --- create an initializing message for the daemon
#                            from the keyword 'token', the cookie, and an
#                            init string, then send it to the daemon
#			--- Send the username and host ip address also.
			set user [id user]
			set retval [catch { server_info addresses [id host] } host_addr ]
			if { $retval == 0 } {
                        	set msg [ concat token $cookie @@@@ user=$user addr=$host_addr ]
			} else {
				set msg [ concat token $cookie @@@@ user=$user ]
			}
                        puts $sock $msg
                        return $sock
		}
        } else {
#		--- have a socket connection, and we
#		--- know the daemon is responding
                return $sock
        }
}
# end of get_connection

#
# display callback to send message window
send_msg_d proc displayCB {} {
	global sendmsgallflg
	global hostname

        set self send_msg_d

# 	--- the title will reflect if the message is to be sent
#	--- to a selected console or, to all consoles.
        if { $sendmsgallflg == 1 } {
                set title [pcm catget send_msg_d lbl]
                set title [format $title "Tools" "all consoles" ]
        } else {
                set title [pcm catget send_msg_d lbl]
                set title [format $title "Console" $hostname]
        }
        send_msg_d setLabel $title
}

# callback to send message
#
send_msg_d.ok proc invokeCB {} {
        global sock
        global noconnection
        global hostname
        global platname
        global useplatnameflag
        global sendmsgallflg
#	--- variable for the length of the message.
        set MSGLEN 160

        set self send_msg_d
#	--- get the connection.
        set connret [ get_connection ]
        if { $connret != -1 } {
#               --- have a good connection.
                set msgtxt [send_msg_d.msgtxt getVal]
                set msglen [clength $msgtxt]
#		--- set the command based on the flag which indicates
#		--- if the message is to be sent to all the consoles
#		--- of to a selected console.
                if { $sendmsgallflg == 1 } {
#		    --- to send to all the consoles.
                    set cmd [ concat msg "-" $msgtxt ]
                } else {
#		    --- to send to the selected console.
			if { $useplatnameflag == 0 } {
				set cmd [ concat msg $hostname $msgtxt ]
			} else {
				set cmd [ concat msg $platname $msgtxt ]
			}
                }
#		--- check for the length of the message.
                if { $msglen >= $MSGLEN } {
                        InfoMsg error \
                                [pcm catget sendmsgerr toolong] \
                                [pcm catget sendmsgerr title] wait
                        return
                }
                puts -nonewline $sock $cmd
                flush $sock
                set mesg [read $sock 8]

#		--- if the socket connection to the daemon has been
#		--- lost due to the daemon being killed or crashing, then the
#		--- read message will have no length. 
#		--- Set the socket to zero and noconnection to 0.
                if { [string length $mesg] == 0 } {
                        catch { close $sock }
                        set sock 0
                        set noconnection 0
#				--- error message to indicate that 
#				--- message has not been sent.
				set errmsg [read $sock $count]
				set errmsg [ctoken errmsg "\0"]
                                InfoMsg error \
                                        $errmsg \
                                        [pcm catget sendmsgerr title] wait
                        return
                }
                binary scan $mesg i1i1 type count
                if { $type == 3 } {
#			--- message has been sent.
                        InfoMsg info \
                                [pcm catget sendmsgok msg] \
                                [pcm catget sendmsgok title] wait
			$self hide
                        return
                } elseif { $type == 2 } {
#			--- error message to indicate that 
#			--- message has not been sent.
			set errmsg [read $sock $count]
			set errmsg [ctoken errmsg "\0"]
			InfoMsg error \
				$errmsg \
				[pcm catget sendmsgerr title] wait
                        return
                } else {
                        catch { close $sock }
                        set sock 0
                        set noconnection 0
                        return
                }
        } else {
                return
        }
}

#
# --- callback for cancel in the Send Message window.
send_msg_d.cancel proc invokeCB {} {
        send_msg_d hide
}

#
# --- callback for help in the Send Message window.
send_msg_d.help proc invokeCB {} {
	global sendmsgallflg
	pcm setHelpName "Platform Console Manager: Help"
	if {$sendmsgallflg == 1 } {
		pcm helpOn ToolsSendMsgDB
	} else {
		pcm helpOn ConnectSendMsgDB 
	}
}
#
# --- proc for View Users window display
view_users_d proc displayCB {} {
        global hostname
        set self view_users_d

	view_users_reset
# 	--- to have the selected console displayed in the title.
        set title [pcm catget view_users_d lbl]
        set title [format $title $hostname]
        $self setLabel $title
        update_view_users
}

proc view_users_reset {} {

#	--- clear out the listwidget.
	view_users_d.out clear
#	--- set the label which indicates the number of users.
	set noofusers [pcm catget view_users_d nousers_lbl]
	set noofusers [format $noofusers 0]
	view_users_d.nousers setLabel $noofusers
}

proc update_view_users {} {
        global sock
        global noconnection
        global cookiefile
        global wait_on_cmfd_restart
        global hostname
	global platname
	global model
	global useplatnameflag
	global cons_status

        set self view_users_d
        set l {}

	# Cancel any pending call to update_view_users.
        after cancel update_view_users
	# get the connection.
        set connret [ get_connection ]
        if { $connret != -1 } {
	    # have a good connection.
	    # Find the status of the console.
	    # If the console name in main window is displayed as mbm or ts port
	    # we need to pass the platform name instead of the hostname.
	    if { $useplatnameflag == 0} {
		set cmd [concat console $hostname]
	    } else {
		set cmd [concat console $platname]
	    }
	    puts -nonewline $sock $cmd
	    flush $sock
	    set mesg [read $sock 8]

	    # if the socket connection to the daemon has been
	    # lost due to the daemon being killed or crashing, then the
	    # read message will have no length. 
	    # Set the socket to zero and noconnection to 0.
	    if { [string length $mesg] == 0 } {
            	catch { close $sock }
            	set sock 0
            	set noconnection 0
            	view_users_reset
           	after 900 update_view_users
            	return
            }
	    binary scan $mesg i1i1 type mesg_num
	    set numberOfMessages $mesg_num
	    # if there are no consoles, numberOfMessages will be 0.
            if { $numberOfMessages == 0 } {
		catch { close $sock }
		set sock 0
		set noconnection 0
            	view_users_reset
           	after 900 update_view_users
    		return
            }

	    if { $type == 1 } {
		for { set i 0 } { $i < $numberOfMessages } { incr i } {
		    set skip [read $sock 260]
		    set cons_status [read $sock 2]
		    set skip [read $sock 2]

		    # If the status is "Refused" and the console is not a
		    # marvel console, set IP Address as Unknown as we don't
		    # know who is using the port.
		    if { [string compare -length 1 $cons_status 3 ] == 0 &&
			 [ getSeriesOfModel $model ] != "M" } {
			set ipaddr "Unknown"
			set user "Unknown"
			set mode "Direct"
			set userslist [list $user $ipaddr $mode]
			view_users_d.out setListItem l $userslist 1
			# set the display list only if there are users.
			set len [llength $l]
			if { $len != 0 } {
			    view_users_d.out setVal $l
			} else {
			    view_users_d.out clear
			}
			# set the label which indicated the number of users.
			set title [pcm catget view_users_d nousers_lbl]
			set title [format $title $len]
			view_users_d.nousers setLabel $title
		    # Otherwise, use "who" command to get the connected user.
		    } else {
			if { $useplatnameflag == 0} {
	        	    set cmd [concat who $hostname]
			} else {
	        	    set cmd [concat who $platname]
			}

			puts -nonewline $sock $cmd
			flush $sock
			set mesg [read $sock 8]

			# if the socket connection to the daemon has been
			# lost due to the daemon being killed or crashing, 
			# then the read message will have no length.
			# Set the socket to zero and noconnection to 0.
			if { [string length $mesg] == 0 } {
			    catch { close $sock }
			    set sock 0
			    set noconnection 0
			    view_users_reset
			    after 900 update_view_users
			    return
			}
			binary scan $mesg i1i1 type mesg_num
			set NoOfMessages $mesg_num
			if { $type == 1 } {
                            for { set i 0 } { $i < $NoOfMessages } { incr i } {
                                set user [read $sock 32]
                                set user [ctoken user "\0"]
                                set ipaddr [read $sock 64]
                                set ipaddr [ctoken ipaddr "\0"]
                                set mode [read $sock 2]
                                set mode [ctoken mode "\0"]
				if { [string compare -length 1 $mode 1] == 0 } {
				    set mode [ pcm catget viewusermode ro ]
				} elseif { [string compare -length 1 $mode 2] == 0 } {
				    set mode [ pcm catget viewusermode sh ]
				} elseif { [string compare -length 1 $mode 3] == 0 } {
				    set mode [ pcm catget viewusermode ex ]
				} elseif { [string compare -length 1 $mode 4] == 0 } {
				    set mode [ pcm catget viewusermode er ]
				} elseif { [string compare -length 1 $mode 5] ==
 0 } {
				    set mode "Direct"
				}
				set userslist [list $user $ipaddr $mode]
				view_users_d.out setListItem l $userslist 1
                            }

			    # set the display list only if there are users.
			    set len [llength $l]
			    if { $len != 0 } {
				view_users_d.out setVal $l
			    } else {
				view_users_d.out clear
			    }

			    # set the label which indicated the number of users.
			    set title [pcm catget view_users_d nousers_lbl]
			    set title [format $title $len]
			    view_users_d.nousers setLabel $title
			} else {
                            catch { close $sock }
                            set sock 0
                            set noconnection 0
			    view_users_reset
                	}
	    	    } 
	        }
	    } else {
		catch { close $sock }
		set sock 0
		set noconnection 0
		view_users_reset
	    }
	} else {
	    view_users_reset
	}
	after 900 update_view_users
}

#
# callback for view users window
view_users_d.ok proc invokeCB {} {
        after cancel update_view_users
        view_users_d hide
}

#
# Disconnect callback for view users window
view_users_d.out.disconnect proc invokeCB {} {
        global sock
        global noconnection
        global hostname
	global platname
	global model
	global useplatnameflag
	global cons_status

	# get the connection.
        set connret [ get_connection ]
        if { $connret != -1 } {
	   # have a good connection.
	   # If status is "Refused" and the console is on a marvel, then
	   # call "force" command to disconnect the external user. 
	   # Otherwise, use "clear" command to disconnect the ams users.
	   if { [string compare -length 1 $cons_status 3 ] == 0 &&
	        [ getSeriesOfModel $model ] == "M" } {
		# If the console name in main window is displayed as mbm or ts 
		# port we need to pass the platformname instead of the hostname.
		if { $useplatnameflag == 0} {
		    set cmd [concat force $hostname]
		} else {
		    set cmd [concat force $platname]
		}
		puts -nonewline $sock $cmd
		flush $sock
		set mesg [read $sock 8]

		# if the socket connection to the daemon has been
		# lost due to the daemon being killed or crashing, 
		# then the read message will have no length.
		# Set the socket to zero and noconnection to 0.
		if { [string length $mesg] == 0 } {
		    catch { close $sock }
		    set sock 0
		    set noconnection 0
		    view_users_reset
		    after 900 update_view_users
		    return
		}
		binary scan $mesg i1i1 type mesg_num
		# If "force" command fails, close the socket connection and 
		# reset the view user dialog.
		if { $type != 3 } {
	    	    catch { close $sock }
	    	    set sock 0
		    set noconnection 0
		    view_users_reset
		    after 900 update_view_users
		    return
		}
	    } else {
		if { $useplatnameflag == 0} {
		    set cmd [concat clear $hostname]
		} else {
		    set cmd [concat clear $platname]
		}
		puts -nonewline $sock $cmd
		flush $sock
		set mesg [read $sock 8]

		# if the socket connection to the daemon has been
		# lost due to the daemon being killed or crashing, 
		# then the read message will have no length.
		# Set the socket to zero and noconnection to 0.
               	if { [string length $mesg] == 0 } {
               	    catch { close $sock }
               	    set sock 0
               	    set noconnection 0
               	    view_users_reset
               	    after 900 update_view_users
               	    return
              	}
		binary scan $mesg i1i1 type mesg_num
		# If "who" command fails, close the socket connection and 
		# reset the view user dialog.
		if { $type != 3 } {
	    	    catch { close $sock }
	    	    set sock 0
		    set noconnection 0
		    view_users_reset
               	    after 900 update_view_users
               	    return
		}
	    }
	}
	update_view_users
}

#
# Help callback for view users window.
view_users_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ConsoleViewUsersDB 
}

# --- proc to determine the status of the consoles
proc get_status_for_all_consoles { } {
        global sock
        global cookiefile
        global noconnection
        global wait_on_cmfd_restart
#	The status_list is a list of consoles and their current status
#	as returned by cmfd. This is used by the proc that updates
#	the status in the pcm main window.
	global status_list

	set status_list {}
#
#       --- if the daemon is being restarted or has been stopped,
#           don't try to connect until the daemon is back up
        if { $wait_on_cmfd_restart == 1 } {
           catch { close $sock }
           set sock 0
           set noconnection 0
	   after 500 compare_status
           return -1
        }

#       --- we'll connect to the local system's 6500 port
#           where the cmf daemon resides
#	--- noconnection == 1 indicates a connection
#	--- noconnection == 0 indicated NO connection
        if { $sock == 0 || $noconnection == 0 } {
#       --- open the socket connection
           set host "localhost"
           set port 6500
#
#       --- try to connect via a socket to the cmf daemon.
           set sock [Connect_Socket $host $port]

           if { $sock == 0 } {
#
#          --- couldn't connect to the cmf daemon, so we can't
#              determine what the state of the consoles are.

	      after 500 compare_status
              return -1
           } else {
#            --- have a good connection, so tell the daemon to
#                init a structure of information. In addition,
#                pass a cookie for security.
#
#            --- open the cookie file
             set retval [ catch { open $cookiefile r } InFile ]
             if { $retval != 0 } {
                general_error
		after 500 compare_status
                return -1
             }
             gets $InFile cookie

             close $InFile
#
#            --- create an initializing message for the daemon
#                from the keyword 'token', the cookie, and an
#                init string, then send it to the daemon
# 	     --- Send the username and ip address also.
	     set user [ id user ]
	     set retval [ catch { server_info addresses [id host] } host_addr ]
	     if { $retval == 0 } {
		set msg [ concat token $cookie @@@@ user=$user addr=$host_addr ]
	     } else {
             	set msg [ concat token $cookie @@@@ user=$user ]
	     }
             puts $sock $msg
           }
        }
#
#       --- established a socket connection, and we
#           know the daemon is responding

        set cmd "console"

        puts -nonewline $sock $cmd
        flush $sock

        set mesg [read $sock 8]

#
#       --- if the socket connection to the daemon has been
#       lost due to the daemon being killed or crashing, then the
#       read message will have no length. Set the socket to zero

        if { [string length $mesg] == 0 } {
           catch { close $sock }
           set sock 0
           set noconnection 0
	   after 500 compare_status
           return -1
        }

        binary scan $mesg i1i1 type mesg_num

        set numberOfMessages $mesg_num
#	--- if there are no consoles, numberOfMessages will be 0.
#	--- in this case, return.
	if { $numberOfMessages == 0 } {
		after 500 compare_status
		return
	}

        if { $type == 1 } {
                for { set i 0 } { $i < $numberOfMessages } { incr i } {
                        set cname [read $sock 64]
			set cname [ctoken cname " \t"]
                        set ipaddr [read $sock 64]
                        set cport [read $sock 2]
                        binary scan $cport s1 cons_port
                        set mport [read $sock 2]
                        binary scan $mport s* mgmt_port
                        set model [read $sock 64]
                        set pname [read $sock 64]
                        set status [read $sock 2]
                        if { [string compare -length 1 $status 1] == 0 } {
                            set mode [read $sock 2]
                        } else {
                            set mode ""
                            set pad [read $sock 2]
                        }
                        if { [string compare -length 1 $status 0] == 0 } {
                            set status [ pcm catget console open ]
                        } elseif { [string compare -length 1 $status 1] == 0 } {
                            if { [string compare -length 1 $mode 1] == 0 } {
                                set status [ pcm catget console busyro ]
                            } elseif { [string compare -length 1 $mode 2] == 0 } {
                                set status [ pcm catget console busysh ]
                            } elseif { [string compare -length 1 $mode 3] == 0 } {
                                set status [ pcm catget console busyex ]
                            } elseif { [string compare -length 1 $mode 4] == 0 } {
                                set status [ pcm catget console busyer ]
                            } else {
                                set status [ pcm catget console busy ]
                            }
                        } elseif { [string compare -length 1 $status 2] == 0 } {
                            set status [ pcm catget console inaccessible ]
                        } elseif { [string compare -length 1 $status 3] == 0 } {
                            set status [ pcm catget console refused ]
                        } elseif { [string compare -length 1 $status 4] == 0 } {
                            set status [ pcm catget console trying ]
                        } elseif { [string compare -length 1 $status 5] == 0 } {
                            set status [ pcm catget console disabled ]
                        } else {
                            set status [ pcm catget console unknown ]
                        }
                        lappend status_list [ list $cname $status]
                }
        } else {
#               --- the daemon is returning a bad type for some
#                   reason, so close the socket. It will be
#                   reopened automatically after the refresh
#                   period.

                catch { close $sock }
                set sock 0
                set noconnection 0
		after 500 get_status_for_all_consoles
                return -1
        }
	after 500 compare_status
}

# --- proc to compare the status in the main window and
# --- the status returned by cmfd and to create a list which
# --- contains the information of only those systems
# --- that need to be updated.
proc compare_status {} {
	global status_list
	global slist_old
	global slist_new
	global slist_update
	global mbm_suf
	global ts_suf

	set self w1.m_sys
	set listlen [$self sizeOfList]

#	--- Set the currently selected item (if any).
	set cur_sel [$self curSelection]
	if { $cur_sel != "" } {
		$self setSelection $cur_sel
	}

#	--- slist_old is a list of the systems and their status as in the main window
#	--- slist_new is a list of systems and their status as returned by cmfd
#	--- slist_update will contain the information of systems and their current status
#	--- for only those that need to be updated
	set slist_old [$self getDspStr 0 end]
	set slist_new $status_list
	set slist_update {}
#	--- the list will be empty if the proc get_status_for_all_consoles
#	--- has for some reason not been able to connect to cmfd or
#	--- there are no systems configured currently.
	if { ![lempty $slist_new] } {
		for { set i 0 } { $i < $listlen } { incr i } {
			set disp_str [list [lindex $slist_old $i]]
			set keylist [lindex $disp_str 0]
			set key [lindex $keylist 0]
			set val [lindex $keylist 1]
			set cname [lindex $key 0]
			set platname [lindex $key 1]
			set status [lindex $key 3]
#			--- If the console name in main window is displayed as 
#			--- platformname_MBM or platformname_TS, we need to 
#			--- use the platform name
		if { [string compare $cname $platname$mbm_suf] == 0 ||
		    [string compare $cname $platname$ts_suf] == 0 } {
				set cname $platname
			}
#			--- find the system in the list of systems and status returned by cmfd.
			set searchkey [concat $cname "*"]
			set cnamematch [ lindex [ lmatch $slist_new $searchkey] 0 ]
			if { ![lempty $cnamematch] } {
				set slist_idx [ lsearch $slist_new $searchkey]
				lvarpop slist_new $slist_idx
				lassign $cnamematch list_cname list_status
#				--- compare the status of the that displayed in main window to the
#				--- status returned by cmfd.
#				--- if the status has been changed, add it to the list of systems to be updated.
				if { [string compare $status $list_status ] != 0 } {
					set key [lreplace $key 3 3 $list_status]
					set keylist [list $key $val]
					set disp_str [ list $keylist $i ]
					lappend slist_update $disp_str
				}
			}
		}
	} else {
#	--- if the proc get_status_for_all_consoles has not been able to connect to cmfd,
#	--- the status should be "Unknown".
#	--- if there are no systems configured currently, listlen will be zero.
		for { set i 0 } { $i < $listlen } { incr i } {
			set disp_str [list [lindex $slist_old $i]]
			set keylist [lindex $disp_str 0]
			set key [lindex $keylist 0]
			set val [lindex $keylist 1]
			set key [lreplace $key 3 3 [ pcm catget console unknown ]]
			set keylist [list $key $val]
			set disp_str [ list $keylist $i ]
			lappend slist_update $disp_str
		}
	}
	after 500 update_console_status
}

# --- proc to update the status
# --- of all the consoles in the main window
proc update_console_status {} {
	global slist_new
	global slist_update

	set self w1.m_sys
	set listlen [$self sizeOfList]
#	--- Save the currently selected item (if any). The reason for this is
#	--- because we lose the selected item in the list when we update
#	--- the list below. We need to save the selected item prior to updating
#	--- the list so we can set it back after we update the list.
	set cur_sel [$self curSelection]

#	Update the status only if there has been a change.
	if { ![lempty $slist_update] } {
		set list_len [llength $slist_update]
		for { set i 0 } { $i < $list_len } { incr i } {
			set str [lindex $slist_update $i]
			set disp_str [list [lindex $str 0] ]
			set idx [lindex $str 1]
			$self modifyDspStr $idx $disp_str
		}
	}

#	--- Set back the currently selected item (if any).
	if { $cur_sel != "" } {
		$self setSelection $cur_sel
	}

	after 5000 get_status_for_all_consoles
}

# --- proc to update the console list
# --- when PCM receives a SIGUSR1
proc update_console_list { } {
	global cfile
	global mbm_suf
	global ts_suf

	set self w1.m_sys
#	--- Save the currently selected item (if any). The reason for this is
#	--- because we lose the selected item in the list when we update
#	--- the list below. We need to save the selected item prior to updating
#	--- the list so we can set it back after we update the list.
	set cur_sel [$self curSelection]
	set list_len [$self sizeOfList]

#	--- systems_displayed is the list of systems as displayed in the pcm main window.
#	--- systems_del will have the systems to be deleted from the display
#	--- systems_add will have the systems to be added to the display
#	--- systems_sorted will have the final list of systems in a sorted order
	set systems_displayed [$self getDspStr 0 end]
	set systems_del {}
	set systems_add {}
	set systems_temp {}
	set systems_sorted {}
	set l {}
#	--- Initialize systems_sorted and systems_del
	for { set i 0 } { $i < $list_len } { incr i } {
		set dispstr [lindex $systems_displayed $i]
		set keylist [ lindex $dispstr 0 ]
		set val [ lindex $dispstr 1 ]
		lappend systems_sorted $keylist
		set key [lrange $keylist 0 2 ]
		set comment [lindex $keylist end]
		set l [concat $key $comment]
		lappend systems_del $l
	}

#	--- open the cmf.conf file
	set retval [ catch { open $cfile r} InFile ]
	if { $retval != 0 } {
		general_error
		return
	}

#	--- read each line in the file, throwing out comments
#	--- or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {
#		--- Get rid of leading whitespace.
		set line [string trimleft $line " \t"]

#		--- If the line contains a comment then skip it.
		if { [string compare -length 1 $line "#"] == 0 } {
			continue
		}

#		--- If the line is blank, skip it
		if { [string length $line] == 0 } {
			continue
		}

#		--- Parse the fields.
		set system [ctoken line " \t"]
		set address [ctoken line " \t"]
		set port_num [ctoken line " \t"]
		set mgmt_port_num [ctoken line " \t"]
		set mapped_port [ctoken line " \t"]
		set plat_type [ctoken line " \t"]
		set plat_name [ctoken line " \t"]
		set skipspace [ctoken line "\""]
		set os_type [ctoken line "\""]
		set skipquote [ctoken line " \t"]
		set logging [ctoken line " \t"]
		set eventgen [ctoken line " \t"]
		set enable [ctoken line " \t"]
		set auth [ctoken line " \t"]
		set evfile [ctoken line " \t"]

		set skipquote [ctoken line "\""]

		set comment [ctoken line "\""]
		set comment [string trim $comment]

		# we need to set the description back to empty for display purproses
		if { [string compare $comment "none"] == 0 } {
			set comment ""
		}


		set status [ pcm catget console inaccessible ]

#		--- Display the appropriate string in the Console field.
		if { [string compare $port_num $mgmt_port_num ] == 0 &&
		     [getSeriesOfModel $plat_type ] == "M" } { 
			append system $mbm_suf
		} elseif { [string compare $port_num $mgmt_port_num ] == 0 &&
		           [getSeriesOfModel $plat_type ] == "W" } { 
			append system $ts_suf
		}

		set skey [concat $system $plat_name $plat_type $comment]
		set idx [ lsearch $systems_del $skey ]

#		--- systems_del will initially contain all the systems that are displayed.
#		--- As we go thru the list of systems from the conf file, we will remove
#		--- those that are found in the systems_del list and, those that are not
#		--- found, we will add to the systems_add list.
#		--- In the end,
#		--- the systems that are not in the conf file, will still be in the
#		--- systems_del and, they are the ones that need to be deleted.
#		--- the systems that are not in display, will be in the
#		--- systems_add and, they are the ones that need to be added to the display.
		if { $idx == -1 } {
#			--- Indicates that the system has to be added to the display
#			--- Put the items we are going to add in a list.
			set s_add [list $system $plat_name $plat_type $status $comment]
			lappend systems_add [list $s_add 1]
			lappend systems_temp [list $system $plat_name $plat_type $status $comment]
		} else {
#			--- Indicated that the system has to be deleted.
			lvarpop systems_del $idx
		}
	}

#	--- NOTE: the Deleting of the systems has to be done first. (before the add...)
#	--- this is because for the delete, we are working on the list of systems displayed
#	--- and, once the delete is done, the list of systems to be added is merged with the
#	--- list of systems displayed. The list is then sorted so that when we add to the display
#	--- we don't lose the sort order.
#	--- $systems_sorted at this point has the list of systems as displayed in the main window.
#
#	--- Commenting out the following line,
#	--- as $systems_sorted is the list of the systems that are displayed and,
#	--- they are already in a sorted order, and don't need to be sorted again.
#	set systems_sorted [ getsortedlist $self $systems_sorted ]
	if { ![lempty $systems_del] } {
		foreach j $systems_del {
			set sysname [lindex $j 0]
			set platname [lindex $j 1]

			if { [string compare $sysname $platname$mbm_suf] == 0 || 
			    [string compare $sysname $platname$ts_suf] == 0 } {
				set sysname [concat $sysname $platname]
			}
			set skey [concat $sysname *]
#			--- find the index in the display which has to be deleted
			set delidx [lsearch $systems_sorted $skey ]
#			--- delete the systems from the display in the main window
#			--- and from the systems_sorted list.
			lvarpop systems_sorted $delidx
			$self deleteDspStr $delidx
		}
	}

#	--- systems_sorted at this point has the list of systems that were displayed in 
#	--- the main window minus the ones that have been deleted from the display
#	--- merge this list with the list of systems to be added to the display
	set systems_sorted [union $systems_sorted $systems_temp]

#	--- sort the list
#	--- systems_sorted will contain the final list of systems in a sorted order.
	set systems_sorted [ getsortedlist $self $systems_sorted ]

	if { ![lempty $systems_add] } {
		foreach j $systems_add {
			set sysname [lindex [lindex $j 0] 0]
			set platname [lindex [lindex $j 0] 1]

			if { [string compare $sysname $platname$mbm_suf] == 0 || 
			    [string compare $sysname $platname$ts_suf] == 0 } {
				set sysname [concat $sysname $platname]
			}
			set skey [concat $sysname *]
#			--- find the index in the display where the system has to added
#			--- we are finding the index from a sorted list, and, the
#			--- adding to the display will retain the sort.
			set addidx [lsearch $systems_sorted $skey ]
			$self insertDspStr $addidx [list $j]
		}
	}
	close $InFile

#	--- Set back the currently selected item (if any).
	if { $cur_sel != "" } {
		$self setSelection $cur_sel
	}
}

# proc to sort the list based on the
# column and order that the list widget
# is currently sorted on
proc getsortedlist { lwidget lname } {
	$lwidget instvar headings
	$lwidget instvar _column
	$lwidget instvar _sortDirection
	if { [info exists headings] &&
	     [info exists _column] &&
	     [info exists _sortDirection] } {
		if { $_sortDirection == 1 } {
			set sortorder "-decreasing"
		} else {
			set sortorder "-increasing"
		}
		set sortidx [lsearch $headings $_column*]
		set lname [lsort -index $sortidx $sortorder $lname]
	}
	return $lname
}

#############################################################################
# Called when the "mapped_ports_list_d" window is displayed.
#############################################################################

mapped_ports_list_d proc displayCB {} {

	global cfile

#       --- open the cmf.conf file
	set retval [ catch { open $cfile r} InFile ]
	if { $retval != 0 } {
	   general_error
	   return
	}
#
#	--- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {

		# Get rid of leading whitespace.
	        set line [string trimleft $line " \t"]

		# If the line contains a comment then skip it.
		if { [string compare -length 1 $line "#"] == 0 } {
			continue
		}
		# if the line is blank, skip it
		if { [string length $line] == 0 } {
		   continue
		}

		# Parse the fields.

		set system [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set mapped_port [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipspace [ctoken line "\""]
		set skipover [ctoken line "\""]
		set skipquote [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set auth [ctoken line " \t"]
		set skipover [ctoken line " \t"]
		set skipover [ctoken line " \t"] 

		if { $mapped_port == "0" } {
			set mapped_port ""
			set auth ""
		} else {
			if { $auth == "0" } {
				set auth "Off"
			} else {
				set auth "On"
			}	
		}

		# Put the items we are going to display in a list.
		set systems_list [list $system $mapped_port $auth ]

		# Add the items to the list window.
		$self.mp_list setListItem l $systems_list 1
	}

	close $InFile

	$self.mp_list setVal $l
}

#############################################################################
# Displayes the "mapped_port_d" window when the "Modify..." button is pressed.
#############################################################################

mapped_ports_list_d.mp_list.modify proc invokeCB {} {
	mapped_port_d display
}

#############################################################################
# Called when the "OK" button is pressed in the "mapped_ports_list_d" window.
# It checks which consoles had their mapped ports or authentication indicator
# modified and updates their entries in the "cmf.conf" file by calling 
# amsmgr.
#############################################################################

mapped_ports_list_d.ok proc invokeCB {} {

	global amsmgr

	# Get the console list. This is necessary because, when we call amsmgr,
	# we need to know whether we are updating a platform or a console.
	set console_list [GetConsoleList]

	set list_len [mapped_ports_list_d.mp_list sizeOfList]

	for { set i 0 } { $i < $list_len } { incr i } {
		set disp_str [mapped_ports_list_d.mp_list getDspStr $i]

		set keylist [lindex $disp_str 0]
		set key [lindex $keylist 0]
		set val [lindex $keylist 1]

		set name [lindex $key 0]
		set port [lindex $key 1]
		set auth [lindex $key 2]

		if { [string equal -nocase $auth "On"] } {
			set auth "1"
		} elseif { [string equal -nocase $auth "Off"] } {
			set auth "0"
		} elseif { $port == "" } {
			set port "0"
			set auth "1"
		} else {
			error "Bad value for \"auth\" = $auth"
		}

		# If the mapped port or authentication indicator have not
		# been changed, then do bother calling amsmgr. Each call to
		# amsmgr is expensive so we don't want to cause any
		# unnecessary delays.
		if { ![MappedPortChanged $name $port $auth $console_list] } {
			continue
		}

		# Is this a platform or a console?
		if { [IsPlatform $name $console_list] } {
			set what_is_it "platform"
		} else {
			set what_is_it "system"
		}

		# Call amsmgr to update the mapped port and authentication.
        	set retval [catch { eval exec $amsmgr -update $what_is_it \
			-name $name -mport $port -auth $auth } output ]

        	if { $retval != 0 } {
			InfoMsg "error" \
				$output \
				[pcm catget pcm_general_error title] wait
			return
		}
	}

	mapped_ports_list_d hide
}

#############################################################################
# Hides the "mapped_ports_list_d" window when the "Cancel" button is pressed.
#############################################################################

mapped_ports_list_d.cancel proc invokeCB {} {
	mapped_ports_list_d hide
}

mapped_ports_list_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ToolsMappedPortsDB
}

#############################################################################
# Called when the "mapped_port_d" window is displayed.
#############################################################################

mapped_port_d proc displayCB {} {

	global orig_mapped_port

	set disp_str [mapped_ports_list_d.mp_list getCurSelection]

	# The display string is in the form of key list.
	set keylist [lindex $disp_str 0]
	set key [lindex $keylist 0]

	set name [lindex $key 0]
	set port [lindex $key 1]
	set auth [lindex $key 2]

	# The value of "auth" must match the name in the Window Definition
	# File. This means we need a lowercase "no" and a lowercase "yes".
	if { $auth == "Off" } {
		set auth "no"
	} elseif { $port == "" || $auth == "On" } {
		set auth "yes"
	}

	$self.name setVal $name
	$self.port setVal $port
	$self.auth setVal $auth

	# Save the original mapped port value. This value is needed so that
	# we don't try to compare for a duplicate mapped port number against
	# ourselves.
	set orig_mapped_port $port
}

#############################################################################
# Called when the "OK" button in the "mapped_port_d" window is pressed.
#############################################################################

mapped_port_d.ok proc invokeCB {} {

	global orig_mapped_port

	# Get values for the mapped port and the authencation indictator 
	# that the user entered.
	set port [mapped_port_d.port getVal]
	set auth [mapped_port_d.auth getVal]

	# Get rid of leading and trailing whitespace.
	set port [string trim $port]

	# Show a blank in the "authenticate?" field when there is no mapped
	# port for the console.
	if { $port == "" } {
		set auth ""
	}

	# Check if the mapped port is already assigned to another console.
	# However, don't check if the mapped port number is the same one
	# we started with.
	#if { $port != $orig_mapped_port &&
	#     [mapped_ports_list_d.mp_list IsDuplicateMappedPort $port] } {
	#	return
	#}

	# If the mapped port number was changed, then check if the new mapped
	# port number is in use by another application.  If so, then ask the
	# user if he still wants to go ahead and use the mapped port number.
	if { $port != $orig_mapped_port &&
	     [catch {exec /usr/opt/ams/bin/isportinuse $port} output] != 0 } {

		set warn_msg [pcm catget confirm_mapped_port_in_use_d_msg_l lbl]

		confirm_mapped_port_in_use_d.msg_l setVal \
			[format $warn_msg $port [mapped_port_d.name getVal]]

		confirm_mapped_port_in_use_d display
	} else {
		mapped_ports_list_d.mp_list UpdateSelectedItem $port $auth

		mapped_port_d hide
	}
}

#############################################################################
# Hides the "mapped_port_d" window when the "Cancel" button is pressed.
#############################################################################

mapped_port_d.cancel proc invokeCB {} {
	mapped_port_d hide
}

mapped_port_d.help proc invokeCB {} {
	pcm setHelpName "Platform Console Manager: Help"
	pcm helpOn ToolsMapPortsModDB
}

#############################################################################
# Updates the selected item in the "mp_list" widget with the specified
# mapped port and authentication indicator.
#############################################################################

mapped_ports_list_d.mp_list proc UpdateSelectedItem { port auth } {

	# Make sure we capitalize the first letter. It just looks nicer.
	if { $auth == "yes" } {
		set auth "On"
	} elseif { $auth == "no" } {
		set auth "Off"
	}

	# Get the index of the item selected in the "mapped ports list".
	set index [$self curSelection] 

	# Get the "display string" of the item selected in the 
	# "mapped ports list".
	set disp_str [$self getCurSelection]

	set keylist [lindex $disp_str 0]
	set key [lindex $keylist 0]
	set val [lindex $keylist 1]

	# Update the display string with the new values.
	set key [lreplace $key 1 1 $port]
	set key [lreplace $key 2 2 $auth]
	set keylist [list $key $val]
	set disp_str [list $keylist]

	# Update the selected item in the list with the new values.
	$self modifyDspStr $index $disp_str
}

#############################################################################
# Checks if the mapped port the user entered is already assigned to another
# console.
#############################################################################

mapped_ports_list_d.mp_list proc IsDuplicateMappedPort { port_to_test } {

	# If the user did not enter a port number then that means that he
	# does not want the console to be mapped to a port. Stop here and
	# don't check for a duplicate, because it is likely that there will
	# be other consoles which have no port assigned to them. We don't
	# want those to be considered duplicates by PCM.
	if { $port_to_test == "" } {
		return 0
	}

	set list_len [$self sizeOfList]

	for { set i 0 } { $i < $list_len } { incr i } {
		set disp_str [$self getDspStr $i]

		set keylist [lindex $disp_str 0]
		set key [lindex $keylist 0]
		set val [lindex $keylist 1]

		set name [lindex $key 0]
		set port [lindex $key 1]

		if { $port == $port_to_test } {
		    InfoMsg "error" \
		       [format [pcm catget dupmappedport msg] $port $name] \
		       [pcm catget pcm_general_error title] wait

		    return 1
		}
	}

	return 0
}

#############################################################################
# Checks if the model that was entered is valid.
#############################################################################

proc getSeriesOfModel { model } {

	global modelsf

	set series ""

	# Initialize the list.
	set l {}

#       --- open the models file
	set retval [ catch { open $modelsf r} InFile ]

	if { $retval != 0 } {
		general_error
		return ""
	}
#
#	--- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {

		# Get rid of leading whitespace.
	        set line [string trimleft $line " \t"]

		# If the line contains a comment then skip it.
		if { [string compare -length 1 $line "#"] == 0 } {
			continue
		}

		# if the line is blank, skip it
		if { [string length $line] == 0 } {
		   continue
		}

		# Parse the series and model fields.
		set s [ctoken line "|"]
		set m [ctoken line "|"]

		if { $m == $model } {
			set series $s
			break
		}
	}

	close $InFile

	# Will be "W" for Wildfire, "M" for Marvel, "U" for unknown, or
	# "" if the model number is not found in the "models" file.
	return $series
}

#############################################################################
# Called when the "Yes" button is pressed in the "confirm_mapped_port_in_use_d"
# window.
#############################################################################

confirm_mapped_port_in_use_d.yes proc invokeCB {} {

	# Get values for the mapped port and the authencation indictator 
	# that the user entered.
	set port [mapped_port_d.port getVal]
	set auth [mapped_port_d.auth getVal]

	# Get rid of leading and trailing whitespace.
	set port [string trim $port]

	mapped_ports_list_d.mp_list UpdateSelectedItem $port $auth

	confirm_mapped_port_in_use_d hide

	mapped_port_d hide
}

#############################################################################
# Called when the "No" button is pressed in the "confirm_mapped_port_in_use_d"
# window.
#############################################################################

confirm_mapped_port_in_use_d.no proc invokeCB {} {

	confirm_mapped_port_in_use_d hide
}

#############################################################################
# Gets a two-dimensional list of consoles. Each row represents a console and
# each column represents the fields belonging to the console.
#############################################################################

proc GetConsoleList {} {

	global amsmgr

	# Get all the consoles from the "cmf.conf" file in one shot.
       	set retval [catch { eval exec $amsmgr -view cmfconf } output ]

       	if { $retval != 0 } {
		InfoMsg "error" \
			$output \
			[pcm catget pcm_general_error title] wait
		return
	}

	# Create an empty list in which to put the consoles with the parsed
	# fields.
	set console_list {}

	# Split output were received from amsmgr into a list of lines, where
	# each line represents a console entry.
	set lines [split $output "\n"]

	set num_lines [ llength $lines ]

	# Go through each line and parse out the fields.
	for { set i 0 } { $i < $num_lines } { incr i } {
		# Take the i'th line, split its fields, and put them in a list.
		set field_list [split [lindex $lines $i]]

		# Put the field list into the console list. Think of this as
		# a two dimensional array, where the "console_list" represents
		# the rows (consoles) and the "field_list" represents the
		# columns (fields).
		lappend console_list $field_list
	}

	return $console_list
}

#############################################################################
# Returns "1" if the specified name is a platform. Returns "0" if the
# specified name is a console.
#############################################################################

proc IsPlatform { name console_list } {

	set num_consoles [ llength $console_list ]

	for { set i 0 } { $i < $num_consoles } { incr i } {

		# Get the next console line from the list.
		set console_line [lindex $console_list $i]

		# Get the console name from the console line.
		set cons_name [lindex $console_line 0]

		# If this is not the console we're looking for, then skip it.
		if { $name != $cons_name } {
			continue
		}

		# Get the platform name.
		set plat_name [lindex $console_line 6]

		# If the console name is the same as the platform name then
		# this is a platform.
		if { $cons_name == $plat_name } {
			return 1
		}
	}

	# Not a platform.
	return 0
}

#############################################################################
# Returns "1" if the "mapped port" or authentication indicator were changed.
# Returns "0" otherwise.
#############################################################################

proc MappedPortChanged { name mapped_port auth console_list } {

	set num_consoles [ llength $console_list ]

	# Locate the specified console and see if the specified mapped port
	# or authentication indicator differ from its original value.
	for { set i 0 } { $i < $num_consoles } { incr i } {

		# Get the next console line from the list.
		set console_line [lindex $console_list $i]

		# Get the console name from the console line.
		set cons_name [lindex $console_line 0]

		# If this is not the console we're looking for, then skip it.
		if { $name != $cons_name } {
			continue
		}

		# Get the original mapped port and authentication indicator.
		set orig_mapped_port [lindex $console_line 4]
		set orig_auth [lindex $console_line 11]

		# If the console port is the same as the management port then
		# this is a platform.
		if {$mapped_port != $orig_mapped_port || $auth != $orig_auth} {
			return 1
		}
	}

	# Didn't change.
	return 0
}

force_conn_d proc displayCB {} {
	global force_console_name
	global port_holder_ipaddr

	set msg [pcm catget $self.msg_l lbl]
	$self.msg_l setLabel \
		[format $msg $force_console_name $port_holder_ipaddr ]
}

force_conn_d.yes proc invokeCB {} {

	global force_console_name

	force_conn_d hide

        set sock [ get_connection ]

	if { $sock == -1 } {
		InfoMsg error \
			[pcm catget pcm_socket_err msg] \
			[pcm catget pcm_socket_err title] wait

		return
	}

	set cmd "force $force_console_name"

	puts -nonewline $sock $cmd

	flush $sock

	set mesg [read $sock 8]

#	--- if the socket connection to the daemon has been
#	--- lost due to the daemon being killed or crashing, then the
#	--- read message will have no length. 
#	--- Set the socket to zero and noconnection to 0.
	if { [string length $mesg] == 0 } {
		catch { close $sock }
		set sock 0
		set noconnection 0
#		--- error message to indicate that there was a problem.
		set errmsg [read $sock $count]
		set errmsg [ctoken errmsg "\0"]
		InfoMsg error \
			$errmsg \
			[pcm catget force_conn_d title] wait
		return
	}

	binary scan $mesg i1i1 type count

	# Request was successfuly sent to cmfd. We assume that cmfd
	# immediately disconnected the external user from the cmfd and
	# now has control of the port. Thus, we can now connect to it.
	if { $type == 3 } {

		# Display the window with the connect options.
		connect_d display

	} elseif { $type == 2 } {
#		--- error message to indicate that there was a problem.
		set errmsg [read $sock $count]
		set errmsg [ctoken errmsg "\0"]
		InfoMsg error \
			$errmsg \
			[pcm catget force_conn_d title] wait
		return
	} else {
		catch { close $sock }
		set sock 0
		set noconnection 0
		return
	}
}

force_conn_d.no proc invokeCB {} {
	force_conn_d hide
}

force_conn_wf_d proc displayCB {} {
	global force_console_name

	set title [pcm catget force_conn_wf_d lbl]
	set title [format $title $force_console_name]
	$self setLabel $title

	set msg [pcm catget $self.msg_l lbl]
	$self.msg_l setLabel \
		[format $msg $force_console_name ]
}

force_conn_wf_d.ok proc invokeCB {} {
	force_conn_wf_d hide
}

# get_port_holder_ipaddr proc determines the IP Address of the host
# from which any user is connected to the MBM or OS console port
# of ES47/80 or GS1280 series.
proc get_port_holder_ipaddr { } {

	global force_console_name

        set sock [ get_connection ]

	if { $sock == -1 } {
		InfoMsg error \
			[pcm catget pcm_socket_err msg] \
			[pcm catget pcm_socket_err title] wait

		return -1
	}

	set cmd "portholder $force_console_name"

	puts -nonewline $sock $cmd

	flush $sock

	set mesg [read $sock 8]

#	--- if the socket connection to the daemon has been
#	--- lost due to the daemon being killed or crashing, then the
#	--- read message will have no length. 
#	--- Set the socket to zero and noconnection to 0.
	if { [string length $mesg] == 0 } {
		catch { close $sock }
		set sock 0
		set noconnection 0
#		--- error message to indicate that there was a problem.
		set errmsg [read $sock $count]
		set errmsg [ctoken errmsg "\0"]
		InfoMsg error \
			$errmsg \
			[pcm catget force_conn_d title] wait
		return -1
	}

	binary scan $mesg i1i1 type count

	# Request was successfuly sent to cmfd. If type is 1, then
	# it means cmfd successfully executed the command.
	if { $type == 1 } {
		# Determine the IP Address of the host from which 
		# any user has opened a connection to the port.
		for { set i 0 } { $i < $count } { incr i } {
			set ipaddr [read $sock 64]
			set ipaddr [ctoken ipaddr "\0"]
			return $ipaddr
		}
	} elseif { $type == 2 } {
#		--- error message to indicate that there was a problem.
		set errmsg [read $sock $count]
		set errmsg [ctoken errmsg "\0"]
		InfoMsg error \
			$errmsg \
			[pcm catget force_conn_d title] wait
		return -1
	} else {
		catch { close $sock }
		set sock 0
		set noconnection 0
		return -1
	}

}

#############################################################################
# Called when the "ostype_list_d" window is displayed.
#############################################################################

ostype_list_d proc displayCB {} {
	global ostypef

	# Initialize the list.
	set l {}

#       --- open the models file
	set retval [ catch { open $ostypef r} InFile ]

	if { $retval != 0 } {
	   general_error
	   return
	}
#
#	--- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {

		# Get rid of leading whitespace.
	        set line [string trimleft $line " \t"]

		# If the line contains a comment then skip it.
		if { [string compare -length 1 $line "#"] == 0 } {
			continue
		}

		# if the line is blank, skip it
		if { [string length $line] == 0 } {
		   continue
		}

		# Parse the fields.
		set ostype [ctoken line "|"]
		set sp_sup [ctoken line "|"]

		# Put the items we are going to display in a list.
		set field_list [list $ostype ]

		# Add the items to the list window.
		$self.ostype_list setListItem l $field_list 1
	}

	close $InFile

	$self.ostype_list  setVal $l 
}

#############################################################################
# Called when the "OK" button is pressed in the "ostype_list_d" window.
#############################################################################

ostype_list_d.ok proc invokeCB {} {

	global parent

	set disp_str [ostype_list_d.ostype_list getCurSelection]

	# The display string is in the form of key list.
	set keylist [lindex $disp_str 0]
	set key [lindex $keylist 0]

	set ostype [lindex $key 0]

	$parent.os_type setVal $ostype

	ostype_list_d hide
}

#############################################################################
# Called when the "Cancel" button is pressed in the "ostype_list_d" window.
#############################################################################

ostype_list_d.cancel proc invokeCB {} {
	ostype_list_d hide
}

#############################################################################
# Called when the user double clicks on the "ostype_list" widget.
#############################################################################

ostype_list_d.ostype_list proc doubleClkCB {} {

	# Act like if the "OK" button was pressed.
	ostype_list_d.ok invokeCB
}


############################################################################
# Called when the "templates_list_d" window is displayed.
#############################################################################

templates_list_d proc displayCB {} {
global templatesf

# Initialize the list.
set tlist {}

#       --- open the models file
set retval [ catch { open $templatesf r} InFile ]

if { $retval != 0 } {
general_error
return
}
#
#	--- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
while { -1 != [ gets $InFile line ] } {

# Get rid of leading whitespace.
set line [string trimleft $line " \t"]

# If the line contains a comment then skip it.
if { [string compare -length 1 $line "#"] == 0 } {
continue
}

# if the line is blank, skip it
if { [string length $line] == 0 } {
continue
}

# Parse the fields.
set templates [ctoken line "|"]
set id_sup [ctoken line "|"]

# Put the items we are going to display in a list.
set field_list [list $templates ]

# Add the items to the list window.
$self.templates_list setListItem tlist $field_list 1
}

close $InFile

$self.templates_list  setVal $tlist 
}


#############################################################################
# Called when the "OK" button is pressed in the "templates_list_d" window.
#############################################################################

templates_list_d.ok proc invokeCB {} {

global parent

set disp_str [templates_list_d.templates_list getCurSelection]

# The display string is in the form of key list.
set keylist [lindex $disp_str 0]
set key [lindex $keylist 0]

set templates [lindex $key 0]

$parent.templatesl setVal $templates

templates_list_d hide
}

#############################################################################
# Called when the "Cancel" button is pressed in the "templates_list_d" window.
#############################################################################

templates_list_d.cancel proc invokeCB {} {
templates_list_d hide
}

#############################################################################
# Called when the user double clicks on the "templates_list" widget.
#############################################################################

templates_list_d.templates_list proc doubleClkCB {} {

# Act like if the "OK" button was pressed.
templates_list_d.ok invokeCB
}

#############################################################################
# proc getTemplateId 
# given a template description, returns its template ID
#############################################################################

proc getTemplateId { tDescription } {

	global templatesf

	set templateId ""

# Initialize the list.
	set l {}

#       --- open the models file
	set retval [ catch { open $templatesf r} InFile ]

	if { $retval != 0 } {
		general_error
		return ""
}
#
#	--- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {

# Get rid of leading whitespace.
	set line [string trimleft $line " \t"]

# If the line contains a comment then skip it.
	if { [string compare -length 1 $line "#"] == 0 } {
		continue
	}

# if the line is blank, skip it
	if { [string length $line] == 0 } {
		continue
	}

# Parse the description and id fields.
	set d [ctoken line "|"]
	set ti [ctoken line "|"]

	set ti [string trim $ti]

	if { $d == $tDescription } {
		set templateId $ti
		break
		}
	}

	close $InFile

	return $templateId
}


#############################################################################
# proc getTemplateId 
# given a template description, returns its template ID
#############################################################################

proc getTemplateDescription { templateId } {

	global templatesf
	set tDescription ""

# Initialize the list.
	set l {}

#       --- open the models file
	set retval [ catch { open $templatesf r} InFile ]

	if { $retval != 0 } {
		general_error
		return ""
	}
#
#	--- read each line in the file, throwing out comments
#           or blank lines, and parsing actual lines
	while { -1 != [ gets $InFile line ] } {

# Get rid of leading whitespace.
	set line [string trimleft $line " \t"]

# If the line contains a comment then skip it.
	if { [string compare -length 1 $line "#"] == 0 } {
		continue
		}

# if the line is blank, skip it
	if { [string length $line] == 0 } {
		continue
		}

# Parse the description and id fields.
	set d [ctoken line "|"]
	set ti [ctoken line "|"]
	set ti [string trimleft $ti " \t"]

	if { $ti == $templateId } {
		set tDescription $d
		break
		}
	}

	close $InFile

	return $tDescription
}


