<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
                xmlns:ol="http://schemas.amsd.com/mpmu/server/offline"
                xmlns:mi="http://schemas.amsd.com/mpmu/server/meta"
                exclude-result-prefixes="mv smll ol mi"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
    <xsl:strip-space elements="*" />

    <xsl:include href="IDKnowledge.xslt" />

    <xsl:variable name="urnPrefix" select="'urn:amsd.com:mpmu:server:'" />
    <xsl:variable name="storageURI" select="concat ($urnPrefix, 'storage')" />

    <xsl:template match="smll:GetTopology|GetSystemBoxConfiguration|GetComboBoxConfiguration|smll:GetPartitioning">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>

<!--
    <xsl:template match="/smll:*">
        <xsl:message terminate="yes" />
    </xsl:template>
-->

    <xsl:template match="mv:LogicalCPU">
        <xsl:copy>
            <xsl:apply-templates select="@*" />
<!--
            <xsl:variable name="marvelId">
                <xsl:apply-templates select="/smll:*/smll:Input/smll:Destination/*" mode="createID.IDREF">
                    <xsl:with-param name="refName" select="'MarvelRef'" />
                </xsl:apply-templates>
            </xsl:variable>
-->
            <xsl:variable name="marvelId" select="/smll:*/smll:Input/smll:Destination/*/@marvelId" />

            <xsl:variable name="platformType">
                <xsl:for-each select="document ($storageURI)">
                    <xsl:choose>
                        <xsl:when test="id ($marvelId)/@platformType = '2P System'">
                            <xsl:value-of select="number (0)" />
                        </xsl:when>
                        <xsl:when test="id ($marvelId)/@platformType = '8P System'">
                            <xsl:value-of select="number (1)" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="number (1)" />
                            <!--xsl:message terminate="yes" /-->
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:variable>

            <xsl:variable name="rackNumber" select="floor (@x div 8) * 4 + floor ((@y * $platformType) div 4)" />
            <xsl:variable name="boxNumber" select="floor ((@x mod 8) div 4) * 2 + floor ((((@y mod 4) * $platformType) + (@y * (1 - $platformType))) div 2)" />
            <xsl:variable name="dualCPUModuleNumber" select="@x mod 4" />
            <xsl:variable name="cpuNumber" select="@y mod 2" />

            <xsl:variable name="systemBoxId">
                <xsl:for-each select="document ($storageURI)">
<!--
                    <xsl:message>
                        <xsl:value-of select="concat ('  id = ', @id)" />
                        <xsl:value-of select="concat (', marvelId = ', $marvelId)" />
                        <xsl:value-of select="concat (', Marvel our id = ', id ($marvelId)/@id)" />
                        <xsl:value-of select="concat (', rackNumber = ', $rackNumber)" />
                        <xsl:value-of select="concat (', boxNumber = ', $boxNumber)" />
                    </xsl:message>
-->

                    <xsl:value-of select="id ($marvelId)/mv:Racks/mv:Rack[@number = $rackNumber]/mv:SystemBox[@number = $boxNumber]/@id|
                                          id ($marvelId)/mv:Racks/mv:Rack[@number = $rackNumber]/mv:ComboBox[@number = $boxNumber]/@id
                                         " />
                </xsl:for-each>
            </xsl:variable>

<!--
            <xsl:message>
                <xsl:value-of select="concat ('  marvelId = ', /smll:*/smll:Input/smll:Destination/*/@marvelId)" />
                <xsl:value-of select="concat (', x = ', @x)" />
                <xsl:value-of select="concat (', y = ', @y)" />
                <xsl:value-of select="concat (', rackNumber = ', floor (@x div 8) * 4 + floor (@y div 4))" />
                <xsl:value-of select="concat (', boxNumber = ', floor ((@x mod 8) div 4) * 2 + floor ((@y mod 4) div 2))" />
                <xsl:value-of select="concat (', dualCPUModuleNumber = ', (@x mod 4))" />
                <xsl:value-of select="concat (', cpuNumber = ', (@y mod 2))" />
                <xsl:value-of select="concat (', systemBox = ', $systemBoxId)" />
            </xsl:message>
-->

            <xsl:for-each select="document ($storageURI)">
                <xsl:variable name="systemBox" select="id ($systemBoxId)" />
                <xsl:if test="$systemBox">
                    <xsl:choose>
                        <xsl:when test="$systemBox/mv:DualCPUModule[@number = $dualCPUModuleNumber]/mv:CPU[@number = $cpuNumber]">
                            <xsl:attribute name="physicalCPURef">
                                <xsl:value-of select="$systemBox/mv:DualCPUModule[@number = $dualCPUModuleNumber]/mv:CPU[@number = $cpuNumber]/@id" />
                            </xsl:attribute>
                        </xsl:when>
                        <xsl:when test="$systemBox/mv:DualCPUModuleFiller[@number = $dualCPUModuleNumber]">
                            <xsl:attribute name="dualCPUModuleFillerRef">
                                <xsl:value-of select="$systemBox/mv:DualCPUModuleFiller[@number = $dualCPUModuleNumber]/@id" />
                            </xsl:attribute>
                        </xsl:when>
                        <xsl:when test="local-name ($systemBox) = 'SystemBox'">
                            <xsl:attribute name="systemBoxRef">
                                <xsl:value-of select="$systemBox/@id" />
                            </xsl:attribute>
                        </xsl:when>
                        <xsl:when test="local-name ($systemBox) = 'ComboBox'">
                            <xsl:attribute name="comboBoxRef">
                                <xsl:value-of select="$systemBox/@id" />
                            </xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:message terminate="yes" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </xsl:for-each>

            <xsl:apply-templates select="*" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="mv:CPU">
        <xsl:copy>
            <xsl:apply-templates select="@*" />
<!--
            <xsl:variable name="marvelId">
                <xsl:apply-templates select="/smll:*/smll:Input/smll:Destination/*" mode="createID.IDREF">
                    <xsl:with-param name="refName" select="'MarvelRef'" />
                </xsl:apply-templates>
            </xsl:variable>
-->
            <xsl:variable name="marvelId" select="/smll:*/smll:Input/smll:Destination/*/@marvelId" />

            <xsl:variable name="platformType">
                <xsl:for-each select="document ($storageURI)">
                    <xsl:choose>
                        <xsl:when test="id ($marvelId)/@platformType = '2P System'">
                            <xsl:value-of select="number (0)" />
                        </xsl:when>
                        <xsl:when test="id ($marvelId)/@platformType = '8P System'">
                            <xsl:value-of select="number (1)" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="number (1)" />
                            <!--xsl:message terminate="yes" /-->
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:variable>

            <xsl:variable name="rackNumber" select="/smll:*/smll:Input/smll:Destination/*/@rackNumber" />
            <xsl:variable name="boxNumber" select="/smll:*/smll:Input/smll:Destination/*/@boxNumber" />
            <xsl:variable name="dualCPUModuleNumber" select="../@number" />
            <xsl:variable name="cpuNumber" select="@number" />

            <xsl:variable name="x" select="(floor ($rackNumber div 4) * 8 + floor ($boxNumber div 2) * 4 + $dualCPUModuleNumber) * $platformType" />
            <xsl:variable name="y" select="($rackNumber mod 4) * 4 + ((($boxNumber * $platformType) mod 2) + ($boxNumber * (1 - $platformType))) * 2 + $cpuNumber" />

<!--
            <xsl:message>
                <xsl:value-of select="concat ('  marvelId = ', /smll:*/smll:Input/smll:Destination/*/@marvelId)" />
                <xsl:value-of select="concat (', x = ', @x)" />
                <xsl:value-of select="concat (', y = ', @y)" />
                <xsl:value-of select="concat (', rackNumber = ', floor (@x div 8) * 4 + floor (@y div 4))" />
                <xsl:value-of select="concat (', boxNumber = ', floor ((@x mod 8) div 4) * 2 + floor ((@y mod 4) div 2))" />
                <xsl:value-of select="concat (', dualCPUModuleNumber = ', (@x mod 4))" />
                <xsl:value-of select="concat (', cpuNumber = ', (@y mod 2))" />
                <xsl:value-of select="concat (', systemBox = ', $systemBoxId)" />
            </xsl:message>
-->

            <xsl:for-each select="document ($storageURI)">
                <xsl:variable name="logicalCPU" select="id ($marvelId)/mv:LogicalCPUs/mv:LogicalCPU[@x = $x and @y = $y]" />

                <xsl:if test="$logicalCPU">
                    <xsl:attribute name="logicalCPURef">
                        <xsl:value-of select="$logicalCPU/@id" />
                    </xsl:attribute>
                </xsl:if>
            </xsl:for-each>

            <xsl:apply-templates select="*" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
