<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:er="http://schemas.amsd.com/mpmu/server/events-reaction"
                exclude-result-prefixes="mv er"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
    <xsl:strip-space elements="*" />

    <xsl:param name="platformType" select="'8P System'" />

    <xsl:include href="IDKnowledge.xslt" />

    <xsl:variable name="urnPrefix" select="'urn:amsd.com:mpmu:server:'" />
    <xsl:variable name="storageURI" select="concat ($urnPrefix, 'storage')" />
    <xsl:variable name="EventsReaction" select="document ('EventsReaction.xml')/er:Events/er:Event" />

    <xsl:template match="mv:Events">
        <xsl:element name="EventsReactions" namespace="">
            <xsl:apply-templates select="*" />
        </xsl:element>
    </xsl:template>

    <xsl:template match="mv:Event">
        <xsl:apply-templates select="$EventsReaction[@type = current ()/@type]/er:Action">
            <xsl:with-param name="event" select="." />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="er:Action">
        <xsl:param name="event" />

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  Action name - ', @name)" />
            <xsl:value-of select="concat (', convertTo - ', @convertDestinationToType)" />
        </xsl:message>
-->

        <xsl:variable name="destinationId">
            <xsl:choose>
                <xsl:when test="not (er:AgentRestriction)">
                    <xsl:choose>
                        <xsl:when test="@convertDestinationToType">
                            <xsl:apply-templates select="$event/*[contains (local-name (), 'AgentRef')]" mode="createID.IDREF">
                                <xsl:with-param name="refName" select="@convertDestinationToType" />
                            </xsl:apply-templates>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="$event/*[contains (local-name (), 'AgentRef')]" mode="createID.IDREF" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$event/*[local-name () = current ()/er:AgentRestriction[@platformType = $platformType]/@type]">
                    <xsl:choose>
                        <xsl:when test="@convertDestinationToType">
                            <xsl:apply-templates select="$event/*[local-name () = current ()/er:AgentRestriction[@platformType = $platformType]/@type]" mode="createID.IDREF">
                                <xsl:with-param name="refName" select="@convertToType" />
                            </xsl:apply-templates>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="$event/*[local-name () = current ()/er:AgentRestriction[@platformType = $platformType]/@type]" mode="createID.IDREF" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$event/*[local-name () = current ()/er:AgentRestriction[not (@platformType)]/@type]">
                    <xsl:choose>
                        <xsl:when test="@convertDestinationToType">
                            <xsl:apply-templates select="$event/*[local-name () = current ()/er:AgentRestriction[not (@platformType)]/@type]" mode="createID.IDREF">
                                <xsl:with-param name="refName" select="@convertToType" />
                            </xsl:apply-templates>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="$event/*[local-name () = current ()/er:AgentRestriction[not (@platformType)]/@type]" mode="createID.IDREF" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>

        <xsl:if test="string-length ($destinationId) != 0">
            <xsl:element name="Action" namespace="">
                <xsl:attribute name="name" namespace="">
                    <xsl:value-of select="@name" />
                </xsl:attribute>
                <xsl:attribute name="destinationId" namespace="">
                    <xsl:value-of select="$destinationId" />
                </xsl:attribute>
                <xsl:if test="@name='GetSystemPowerSupplies'">
                    <xsl:attribute name="keyId" namespace="">
                        <xsl:value-of select="document ($storageURI)/mv:Marvels/mv:Marvel/mv:Racks/mv:Rack/mv:PowerSupplySubRack[mv:PowerInterface/@connectedSystemBoxRef=$destinationId]/@id" />
                    </xsl:attribute>
                </xsl:if>
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <xsl:template match="@*|*" mode="copyOnly">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyOnly" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
