<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
                xmlns:mi="http://schemas.amsd.com/mpmu/server/meta"
                exclude-result-prefixes="mv smll mi"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
    <xsl:strip-space elements="*" />

    <xsl:include href="IDKnowledge.xslt" />

    <xsl:param name="platformType" select="'8P System'" />

    <xsl:variable name="refTranslations" select="document ('MetaInfo.xml')/mi:MetaInfo/mi:RefTranslations" />
    
    <!--xsl:variable name="separator" select="'-'" /-->

    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test ="mv:Events">
                <xsl:apply-templates select="*">
                    <xsl:with-param name="parentId">
                        <xsl:apply-templates select="/*/*[1]/*[1]" mode="convert">
                            <xsl:with-param name="refName" select="'MarvelRef'" />
                        </xsl:apply-templates>
                    </xsl:with-param>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="*" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="/*/smll:Output">
        <xsl:copy>
            <xsl:apply-templates select="@*" />
            <xsl:apply-templates>
                <xsl:with-param name="parentPrefix">
                    <xsl:apply-templates select="../smll:Input" mode="prefix" />
                </xsl:with-param>
                <xsl:with-param name="parentId">
                    <xsl:apply-templates select="../smll:Input" mode="convert" />
                </xsl:with-param>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="/smll:GetSystemBoxConfiguration/smll:Input/smll:Destination/*|
                         /smll:GetIOBoxConfiguration/smll:Input/smll:Destination/*|
                         /smll:GetComboBoxConfiguration/smll:Input/smll:Destination/*
                        " mode="convert">
        <xsl:call-template name="Ref2ID0">
            <xsl:with-param name="castTo" select="'RackRef'" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="/smll:GetSystemPowerSupplies/smll:Input/smll:Destination/*|
                         /smll:GetSystemPowerInterfaces/smll:Input/smll:Destination/*
                        " mode="convert">
        <xsl:call-template name="Ref2ID0">
            <xsl:with-param name="castTo" select="'RacksRef'" />
        </xsl:call-template>
    </xsl:template>

    <!--xsl:template match="/smll:GetTopology/smll:Input" mode="convert">
        <xsl:apply-templates select="Param/*" mode="convert" />
    </xsl:template>

    <xsl:template match="/smll:GetTopology/smll:Input/smll:Param/*" mode="convert">
        <xsl:call-template name="AsMarvelRef" />
    </xsl:template-->

    <!-- Templates for creating IDREF -->
    <!-- "createIDREF"'s mode templates -->
    <!-- "convert"'s mode templates -->
    <!-- Physical state of Marvel -->
<!--
-->
    <xsl:template match="mv:IPCable">
        <xsl:param name="parentId" />

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  parentId - ', $parentId)" />
            <xsl:value-of select="concat (', firstPortDirection - ', @firstPortDirection)" />
            <xsl:value-of select="concat (', secondPortDirection - ', @secondPortDirection)" />
        </xsl:message>
-->

        <xsl:variable name="firstEndRef">
            <xsl:for-each select="mv:FirstEndRef">
                <xsl:call-template name="Ref2ID0">
                    <xsl:with-param name="castTo" select="'SystemBoxRef'" />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="secondEndRef">
            <xsl:for-each select="mv:SecondEndRef">
                <xsl:call-template name="Ref2ID0">
                    <xsl:with-param name="castTo" select="'SystemBoxRef'" />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:variable>

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  firstEndRef - ', $firstEndRef)" />
            <xsl:value-of select="concat (', secondEndRef - ', $secondEndRef)" />
            <xsl:value-of select="concat (', firstPortDirection - ', @firstPortDirection)" />
            <xsl:value-of select="concat (', secondPortDirection - ', @secondPortDirection)" />
        </xsl:message>
-->

        <xsl:call-template name="FillInID">
            <xsl:with-param name="prefix" select="'IPC'" />
            <xsl:with-param name="parentId" select="$parentId" />
            <xsl:with-param name="localId" select="concat ($firstEndRef, $separator, @firstPortDirection, $separator, $secondEndRef, $separator, @secondPortDirection)" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="mv:IOCable">
        <xsl:param name="parentId" />

        <xsl:variable name="ioRiserEndRef">
            <xsl:for-each select="mv:IORiserEndRef">
                <xsl:call-template name="Ref2ID0">
                    <xsl:with-param name="castTo" select="'IORiserRef'" />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="cpuEndRef">
            <xsl:for-each select="mv:CPUEndRef">
                <xsl:call-template name="Ref2ID0">
                    <xsl:with-param name="castTo" select="'CPURef'" />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:variable>

        <xsl:call-template name="FillInID">
            <xsl:with-param name="prefix" select="'IOC'" />
            <xsl:with-param name="parentId" select="$parentId" />
            <xsl:with-param name="localId" select="concat ($ioRiserEndRef, $separator, $cpuEndRef)" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="mv:IPConnection">
        <xsl:param name="parentId" />

        <xsl:variable name="firstEndRef">
            <xsl:for-each select="mv:FirstEndRef">
                <xsl:call-template name="Ref2ID0">
                    <xsl:with-param name="castTo" select="'LogicalCPURef'" />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="secondEndRef">
            <xsl:for-each select="mv:SecondEndRef">
                <xsl:call-template name="Ref2ID0">
                    <xsl:with-param name="castTo" select="'LogicalCPURef'" />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:variable>

        <xsl:call-template name="FillInID">
            <xsl:with-param name="prefix" select="'IPN'" />
            <xsl:with-param name="parentId" select="$parentId" />
            <xsl:with-param name="localId" select="concat ($firstEndRef, $separator, $secondEndRef)" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="mv:*" mode="FillInTree">
        <xsl:copy>
            <xsl:apply-templates select="@*" />
            <xsl:apply-templates select="*">
                <xsl:with-param name="parentPrefix" select="$IDAssignment/mi:Element[@name=local-name (current ())]" />
                <xsl:with-param name="parentId" select="substring-after (@id, $separator)" />
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="mv:*" name="FillInIDElement">
        <xsl:param name="parentPrefix" />
        <xsl:param name="parentId" />
        <xsl:param name="elementName" select="local-name ()" />

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  FillInIDElement', '')" />
            <xsl:value-of select="concat (', local-name() - ', local-name ())" />
            <xsl:value-of select="concat (', parentId - ', $parentId)" />
        </xsl:message>
-->

<!--
        <xsl:param name="parentElementName" select="local-name (./..)" />
        <xsl:variable name="element" select="$IDAssignment/mi:Element[@name=$elementName and @parentName=$parentElementName]|
                                             $IDAssignment/mi:Element[@name=$elementName]
                                            " />
-->
        <xsl:variable name="element" select="$IDAssignment/mi:Element[@name=$elementName]" />

        <xsl:choose>
            <xsl:when test="$element">
                <xsl:variable name="idPrefix">
                    <xsl:choose>
                        <xsl:when test ="$element/@idPrefix">
                            <xsl:value-of select="$element/@idPrefix" />
                        </xsl:when>
                        <xsl:when test ="$element/@idAdditionalPrefix">
                            <!--xsl:variable name="basePrefix" select="substring ($parentPrefix, 0, string-length ($parentPrefix) - number ($element/@idReplacePrefixChars))" /-->

                            <xsl:variable name="basePrefix">
                                <xsl:choose>
                                    <xsl:when test="$element/@idReplacePrefixChars">
                                        <xsl:value-of select="substring ($parentPrefix, 0, string-length ($parentPrefix) - $element/@idReplacePrefixChars + 1)" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$parentPrefix" />
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <xsl:value-of select="concat ($basePrefix, $element/@idAdditionalPrefix)" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:message terminate="yes" />
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:variable name="current" select="." />
                    <xsl:for-each select="$element/mi:IdPrefixConditionalAddendum">
                        <xsl:variable name="ifExist">
                            <xsl:call-template name="EvaluateIfExist">
                                <xsl:with-param name="currentElement" select="$current" />
                                <xsl:with-param name="expression" select="@ifExist" />
                            </xsl:call-template>
                        </xsl:variable>
                        <xsl:if test="$ifExist = 'true'">
                            <xsl:value-of select="@value" />
                        </xsl:if>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:call-template name="FillInID">
                    <xsl:with-param name="prefix" select="$idPrefix" />
                    <xsl:with-param name="parentId" select="$parentId" />
                    <xsl:with-param name="localId">
                        <xsl:choose>
                            <xsl:when test="$element/@localId">
                                <xsl:call-template name="EvaluateLocalId">
                                    <xsl:with-param name="currentElement" select="." />
                                    <xsl:with-param name="expression" select="$element/@localId" />
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="current" select="." />
                                <xsl:for-each select="$element/mi:LocalId">
                                    <xsl:if test="position () != 1">
                                        <xsl:value-of select="$separator" />
                                    </xsl:if>
                                    <xsl:call-template name="EvaluateLocalId">
                                        <xsl:with-param name="currentElement" select="$current" />
                                        <xsl:with-param name="expression" select="@name" />
                                    </xsl:call-template>
                                </xsl:for-each>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="copyTemplate" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="EvaluateLocalId">
        <xsl:param name="currentElement" />
        <xsl:param name="expression" />

        <xsl:call-template name="EvaluateExpression">
            <xsl:with-param name="currentElement" select="$currentElement" />
            <xsl:with-param name="expression" select="$expression" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="EvaluateIfExist">
        <xsl:param name="currentElement" />
        <xsl:param name="expression" />

        <xsl:call-template name="EvaluateExpression">
            <xsl:with-param name="currentElement" select="$currentElement" />
            <xsl:with-param name="expression" select="$expression" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="EvaluateExpression">
        <xsl:param name="currentElement" />
        <xsl:param name="expression" />
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  currentElement - ', local-name ($currentElement))" />
            <xsl:value-of select="concat (', expression - ', $expression)" />
        </xsl:message>
-->

        <xsl:choose>
            <xsl:when test="starts-with ($expression, 'function.')">
                <xsl:variable name="function" select="substring-after ($expression, 'function.')" />
                <xsl:call-template name="ExecuteFunction">
                    <xsl:with-param name="function" select="$function" />
                    <xsl:with-param name="currentElement" select="$currentElement" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$currentElement/@*[local-name ()=$expression]" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="ExecuteFunction">
        <xsl:param name="function" />
        <xsl:param name="currentElement" />
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  function - ', $function)" />
            <xsl:value-of select="concat (', currentElement - ', local-name ($currentElement))" />
        </xsl:message>
-->

        <xsl:choose>
            <xsl:when test="starts-with ($function, 'depunctuate.')">
                <xsl:variable name="parameter" select="substring-after ($function, 'depunctuate.')" />
<!--
                <xsl:message>
                    <xsl:value-of select="concat ('  function - ', $function)" />
                    <xsl:value-of select="concat (', currentElement - ', local-name ($currentElement))" />
                    <xsl:value-of select="concat (', parameter - ', $parameter)" />
                    <xsl:value-of select="concat (', expression - ', $currentElement/@*[local-name ()=$parameter])" />
                </xsl:message>
-->
                <xsl:call-template name="depunctuate">
                    <xsl:with-param name="what" select="$currentElement/@*[local-name ()=$parameter]" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="starts-with ($function, 'ifExistCurrentAndUp.')">
                <xsl:variable name="parameters" select="substring-after ($function, 'ifExistCurrentAndUp.')" />
                <xsl:variable name="elementName" select="substring-before ($parameters, '.')" />
                <xsl:variable name="attributeName" select="substring-after ($parameters, '.')" />
<!--
                <xsl:message>
                    <xsl:value-of select="concat ('  function - ', $function)" />
                    <xsl:value-of select="concat (', currentElement - ', local-name ($currentElement))" />
                    <xsl:value-of select="concat (', parameter - ', $parameter)" />
                    <xsl:value-of select="concat (', expression - ', $currentElement/@*[local-name ()=$parameter])" />
                </xsl:message>
-->
                <xsl:call-template name="ifExistCurrentAndUp">
                    <xsl:with-param name="currentElement" select="$currentElement" />
                    <xsl:with-param name="elementName" select="$elementName" />
                    <xsl:with-param name="attributeName" select="$attributeName" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="depunctuate">
        <xsl:param name="what" />
        <xsl:param name="separators" select="'-:'" />
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  what - ', $what)" />
            <xsl:value-of select="concat (', separators - ', $separators)" />
        </xsl:message>
-->

        <xsl:choose>
            <xsl:when test="string-length ($separators) != 0">
                <xsl:call-template name="depunctuate">
                    <xsl:with-param name="what">
                        <xsl:call-template name="depunctuate1">
                            <xsl:with-param name="what" select="$what" />
                            <xsl:with-param name="separator" select="substring ($separators, 1, 1)" />
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="separators" select="substring ($separators, 2)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$what" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="depunctuate1">
        <xsl:param name="what" />
        <xsl:param name="separator" />

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  what - ', $what)" />
            <xsl:value-of select="concat (', separator - ', $separator)" />
        </xsl:message>
-->

        <xsl:choose>
            <xsl:when test="contains ($what, $separator)">
                <xsl:call-template name="depunctuate1">
                    <xsl:with-param name="what" select="concat (substring-before ($what, $separator), substring-after ($what, $separator))" />
                    <xsl:with-param name="separator" select="$separator" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$what" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="ifExistCurrentAndUp">
        <xsl:param name="currentElement" />
        <xsl:param name="elementName" />
        <xsl:param name="attributeName" />

        <xsl:choose>
            <xsl:when test="local-name ($currentElement) = $elementName">
                <xsl:value-of select="$currentElement/@*[local-name () = $attributeName]" />
            </xsl:when>
            <xsl:when test="$currentElement/..">
                <xsl:call-template name="ifExistCurrentAndUp">
                    <xsl:with-param name="currentElement" select="$currentElement/.." />
                    <xsl:with-param name="elementName" select="$elementName" />
                    <xsl:with-param name="attributeName" select="$attributeName" />
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="mv:Marvel">
        <xsl:apply-templates select="." mode="FillInTree" />
    </xsl:template>

    <xsl:template name="FillInID">
        <xsl:param name="prefix" />
        <xsl:param name="parentId" />
        <xsl:param name="localId" select="''" />
        <xsl:copy>
            <xsl:variable name="fullId">
                <xsl:choose>
                    <xsl:when test="$localId = ''">
                        <xsl:value-of select="$parentId" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat ($parentId, $separator, $localId)" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:attribute name="id"><xsl:value-of select="concat ($prefix, $separator, $fullId)" /></xsl:attribute>
            <xsl:apply-templates select="@*[local-name () != 'id']" />

            <xsl:apply-templates select="." mode="IDREFTranslate" />

            <xsl:apply-templates select="*" mode="FillInID">
                <xsl:with-param name="parentPrefix" select="$prefix" />
                <xsl:with-param name="parentId" select="$fullId" />
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*" mode="IDREFTranslate">
        <xsl:variable name="sourceElement" select="." />
        <xsl:variable name="refElement" select="$refTranslations/mi:Element[@name = local-name (current ())]" />
        <xsl:if test="$refElement">
            <xsl:for-each select="$refElement/mi:Ref">
                <xsl:variable name="ref" select="$sourceElement/*[local-name () = current ()/@name]" />
                <xsl:if test="$ref">
                    <xsl:attribute name="{@attributeName}">
                        <xsl:apply-templates select="$ref" mode="createID.IDREF">
                            <xsl:with-param name="platformType" select="$platformType" />
                        </xsl:apply-templates>
                    </xsl:attribute>
                </xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <!--xsl:template match="mv:PhysicalCPURef|mv:DualCPUModuleFillerRef|mv:SystemBoxRef|mv:ComboBoxRef|
                         mv:HardPartitionRef|mv:SubPartitionRef|mv:HardPartitionIORef|mv:SubPartitionIORef|
                         mv:ConnectedIORiserRef|mv:FirstEndRef|mv:SecondEndRef|mv:CPUEndRef|mv:IORiserEndRef|
                         mv:ConnectedSystemBoxRef|mv:IOBoxRef|mv:PowerInterfaceRef|
                         mv:SystemBoxAgentRef|mv:DualCPUModuleAgentRef|mv:IOBoxAgentRef|mv:ComboBoxAgentRef|
                         mv:MarvelComponentRef|mv:SystemBoxComponentRef|mv:DualCPUModuleComponentRef|mv:CPUComponentRef|
                         mv:IOBoxComponentRef|mv:IORiserComponentRef|mv:ComboBoxComponentRef|
                         mv:PowerInterfaceComponentRef|mv:PowerSupplyComponentRef|
                         mv:PartitionsComponentRef|mv:HardPartitionComponentRef|mv:SubPartitionComponentRef" mode="FillInID" /-->

    <xsl:template match="mv:*" mode="FillInID">
        <xsl:param name="parentPrefix" />
        <xsl:param name="parentId" />
        <xsl:apply-templates select="self::node ()[not ($refTranslations/mi:Element/mi:Ref/@name = local-name ())]">
            <xsl:with-param name="parentPrefix" select="$parentPrefix" />
            <xsl:with-param name="parentId" select="$parentId" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="*|@*" name="copyTemplate">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>

    <!--xsl:template match="*|@*|text()|comment()|processing-instruction()" mode="*" /-->

</xsl:stylesheet>
