<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
                exclude-result-prefixes="smll"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
    <xsl:strip-space elements="*" />

    <xsl:param name="logDates" select="''" />

    <xsl:variable name="urnPrefix" select="'urn:amsd.com:mpmu:server:'" />
    <xsl:variable name="logURI" select="concat ($urnPrefix, 'log')" />
    <xsl:variable name="log" select="document ($logURI)" />

    <xsl:template match="/smll:*">
        <xsl:copy>
            <xsl:message>
                <xsl:value-of select="concat ('  Unknown action: ', local-name ())" />
            </xsl:message>

            <xsl:apply-templates select="@*|*" mode="copyOnly" />

            <xsl:element name="Result" namespace="http://schemas.amsd.com/mpmu/smlan/logical">
                <xsl:attribute name="error">
                    <xsl:value-of select="'-1'" />
                </xsl:attribute>
                <xsl:attribute name="desc">
                    <xsl:value-of select="concat ('Unknown action: ', local-name ())" />
                </xsl:attribute>
            </xsl:element>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="/smll:GetLogs">

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  ', local-name ())" />
            <xsl:value-of select="concat (', logDates = ', $logDates)" />
        </xsl:message>
-->

        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyOnly" />

            <xsl:element name="Output" namespace="http://schemas.amsd.com/mpmu/smlan/logical">
                <xsl:element name="Logs" namespace="http://schemas.amsd.com/mpmu/marvel/general">
                    <xsl:call-template name="CreateLogElement">
                        <xsl:with-param name="logDates" select="concat ($logDates, ' ')" />
                    </xsl:call-template>
                </xsl:element>
            </xsl:element>

            <xsl:element name="Result" namespace="http://schemas.amsd.com/mpmu/smlan/logical">
                <xsl:attribute name="error">
                    <xsl:value-of select="'0'" />
                </xsl:attribute>
                <xsl:attribute name="desc">
                    <xsl:value-of select="'Querying logs completed successfully.'" />
                </xsl:attribute>
            </xsl:element>
        </xsl:copy>
    </xsl:template>

    <xsl:template name="CreateLogElement">
        <xsl:param name="logDates" />

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  ', local-name ())" />
            <xsl:value-of select="concat (', logDates = ', $logDates)" />
        </xsl:message>
-->

        <xsl:variable name="logDate" select="substring-before ($logDates, ' ')" />
        <xsl:if test="$logDate != ''">
            <xsl:element name="Log" namespace="http://schemas.amsd.com/mpmu/marvel/general">
                <xsl:attribute name="dateFilter">
                    <xsl:value-of select="$logDate" />
                </xsl:attribute>
            </xsl:element>

            <xsl:call-template name="CreateLogElement">
                <xsl:with-param name="logDates" select="substring-after ($logDates, ' ')" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template match="/smll:GetLog">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyOnly" />

            <xsl:element name="Output" namespace="http://schemas.amsd.com/mpmu/smlan/logical">
                <xsl:element name="Log" namespace="http://schemas.amsd.com/mpmu/marvel/general">
                    <xsl:attribute name="dateFilter">
                        <xsl:value-of select="smll:Input/smll:LogDate/@value" />
                    </xsl:attribute>

                    <xsl:apply-templates select="$log/*/*" mode="copyOnly" />
                </xsl:element>
            </xsl:element>

            <xsl:element name="Result" namespace="http://schemas.amsd.com/mpmu/smlan/logical">
                <xsl:attribute name="error">
                    <xsl:value-of select="'0'" />
                </xsl:attribute>
                <xsl:attribute name="desc">
                    <xsl:value-of select="'Querying log completed successfully.'" />
                </xsl:attribute>
            </xsl:element>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*" mode="copyOnly">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyOnly" />
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="@*|*">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
