<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
                xmlns:ol="http://schemas.amsd.com/mpmu/server/offline"
                xmlns:mi="http://schemas.amsd.com/mpmu/server/meta"
                exclude-result-prefixes="mv smll ol mi"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
    <xsl:strip-space elements="*" />

    <xsl:include href="IDKnowledge.xslt" />

    <xsl:param name="command" />
    <xsl:param name="fileName" />

    <xsl:variable name="loadOfflineConfigurationCommand" select="'LoadOfflineConfiguration'" />
    <xsl:variable name="removeOfflineConfigurationCommand" select="'RemoveOfflineConfiguration'" />

    <xsl:variable name="urnPrefix" select="'urn:amsd.com:mpmu:server:'" />
    <xsl:variable name="storageURI" select="concat ($urnPrefix, 'storage')" />

    <xsl:variable name="offlineExecution" select="document ('OfflineExecution.xml')" />

    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test="not ($command)">
                <xsl:apply-templates select="." mode="offline" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$command = $loadOfflineConfigurationCommand">
                        <xsl:for-each select="*">
                            <xsl:copy>
                                <xsl:apply-templates select="@*|*" mode="copyOnly" />
                                <xsl:if test="not (*[@id = document ($fileName)/*/@id])">
                                    <xsl:apply-templates select="document ($fileName)" mode="copyOnly" />
                                </xsl:if>
                            </xsl:copy>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:message terminate="yes" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template name="getDestinationId">
        <xsl:param name="commandDescription" />

        <xsl:choose>
            <xsl:when test="not ($commandDescription/@ref)">
                <xsl:apply-templates select="smll:Input" mode="createID.IDREF" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="smll:Input/smll:Destination/*" mode="createID.IDREF">
                    <xsl:with-param name="refName" select="$commandDescription/@ref" />
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getRootIds">
        <xsl:param name="commandDescription" />
        <xsl:param name="destinationId">
            <xsl:call-template name="getDestinationId">
                <xsl:with-param name="commandDescription" select="$commandDescription" />
            </xsl:call-template>
        </xsl:param>

        <xsl:for-each select="document ($storageURI)">
            <xsl:variable name="commandRoot" select="id ($destinationId)" />

            <xsl:if test="$commandRoot">
                <xsl:choose>
                    <xsl:when test="$commandDescription/@root">
                        <xsl:value-of select="$commandRoot/*[local-name () = $commandDescription/@root]/@id" />
                    </xsl:when>
                    <xsl:when test="$commandDescription/ol:Root">
                        <xsl:for-each select="$commandDescription/ol:Root">
                            <xsl:if test="position () != 1">
                                <xsl:value-of select="' '" />
                            </xsl:if>
                            <xsl:value-of select="$commandRoot/*[local-name () = current ()/@name]/@id" />
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$destinationId" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>


    <xsl:template match="/smll:*" mode="offline">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyOnly" />

            <xsl:variable name="commandDescription" select="$offlineExecution/ol:Commands/ol:Command[@name = local-name (current ())]" />

            <xsl:choose>
                <xsl:when test="$commandDescription/@category = 'query'">
                    <xsl:apply-templates select="." mode="queryCommands" />
                </xsl:when>
                <xsl:when test="$commandDescription/@category = 'control'">
                    <xsl:apply-templates select="." mode="controlCommands" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="applyResult">
                        <xsl:with-param name="commandDescription" select="$commandDescription" />
                        <xsl:with-param name="result" select="'-1'" />
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="/smll:*" mode="queryCommands" name="retrieveInformation">
        <xsl:param name="commandName" select="local-name ()" />
        <xsl:param name="commandDescription" select="$offlineExecution/ol:Commands/ol:Command[@name = $commandName]" />

        <xsl:variable name="responseRootIds">
            <xsl:call-template name="getRootIds">
                <xsl:with-param name="commandDescription" select="$commandDescription" />
            </xsl:call-template>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="string-length (normalize-space ($responseRootIds)) != 0">
                <xsl:element name="Output" namespace="http://schemas.amsd.com/mpmu/smlan/logical">
                    <xsl:for-each select="document ($storageURI)">
                        <xsl:for-each select="id ($responseRootIds)">
                            <xsl:apply-templates select="." mode="offline">
                                <xsl:with-param name="commandDescription" select="$commandDescription" />
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:element>

                <xsl:call-template name="applyResult">
                    <xsl:with-param name="commandDescription" select="$commandDescription" />
                    <xsl:with-param name="result" select="'0'" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="applyResult">
                    <xsl:with-param name="commandDescription" select="$commandDescription" />
                    <xsl:with-param name="result" select="'-1'" />
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="@*|text()" mode="offline">
        <xsl:copy />
    </xsl:template>

    <xsl:template match="*" mode="offline">
        <xsl:param name="commandDescription" />

        <xsl:if test="$commandDescription/ol:ResultBranch[@name = local-name (current ())]">
            <xsl:copy>
                <xsl:apply-templates select="@*|text()|*" mode="offline">
                    <xsl:with-param name="commandDescription" select="$commandDescription" />
                </xsl:apply-templates>
            </xsl:copy>
        </xsl:if>
    </xsl:template>


    <xsl:template match="/smll:*" mode="controlCommands">
        <xsl:param name="commandName" select="local-name ()" />
        <xsl:param name="commandDescription" select="$offlineExecution/ol:Commands/ol:Command[@name = $commandName]" />

        <xsl:variable name="rootId">
            <xsl:call-template name="getRootIds">
                <xsl:with-param name="commandDescription" select="$commandDescription" />
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="command" select="." />
        <xsl:variable name="commandInputParameter" select="smll:Input" />

        <xsl:for-each select="document ($storageURI)">
            <xsl:variable name="destination" select="id ($rootId)" />

            <xsl:variable name="checkResult">
                <xsl:apply-templates select="$command" mode="additionalCheck">
                    <xsl:with-param name="rootId" select="$rootId" />
                    <xsl:with-param name="destination" select="$destination" />
                    <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                </xsl:apply-templates>
            </xsl:variable>

            <xsl:call-template name="applyResult">
                <xsl:with-param name="commandDescription" select="$commandDescription" />
                <xsl:with-param name="result" select="$checkResult" />
            </xsl:call-template>

            <xsl:if test="$checkResult = number (0)">
                <xsl:element name="Updates" namespace="http://schemas.amsd.com/mpmu/smlan/logical">
                    <xsl:if test="$commandDescription/ol:MultipleInput">
<!--
                        <xsl:message>
                            <xsl:value-of select="concat ('  MultipleInput - ', $commandDescription/ol:MultipleInput/@name)" />
                            <xsl:value-of select="concat (', commandInputParameter[1] - ', local-name ($commandInputParameter/*[1]))" />
                            <xsl:value-of select="concat (', commandInputParameter[2] - ', local-name ($commandInputParameter/*[2]))" />
                            <xsl:value-of select="concat (', commandInputParameter[3] - ', local-name ($commandInputParameter/*[3]))" />
                            <xsl:value-of select="concat (', MultipleInputParameter - ', local-name ($commandInputParameter/*[local-name () = $commandDescription/ol:MultipleInput/@name]/*))" />
                        </xsl:message>
-->

                        <xsl:for-each select="$commandInputParameter/*[local-name () = $commandDescription/ol:MultipleInput/@name]/*">
                            <xsl:apply-templates select="$commandDescription/ol:MultipleInput/ol:Update" mode="controlCommands">
                                <xsl:with-param name="rootId" select="$rootId" />
                                <xsl:with-param name="destination" select="$destination" />
                                <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                                <xsl:with-param name="multipleDestinationId">
                                    <xsl:apply-templates select="." mode="createID.IDREF" />
                                </xsl:with-param>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="$commandDescription/ol:Update">
                        <xsl:apply-templates select="$commandDescription/ol:Update" mode="controlCommands">
                            <xsl:with-param name="rootId" select="$rootId" />
                            <xsl:with-param name="destination" select="$destination" />
                            <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                        </xsl:apply-templates>
                    </xsl:if>
                </xsl:element>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="smll:CreateHardPartition|/smll:CreateSubPartition" mode="additionalCheck">
        <xsl:param name="rootId" />
        <xsl:param name="destination" />
        <xsl:param name="commandInputParameter" />

        <xsl:choose>
            <xsl:when test="not ($destination)">
                <xsl:value-of select="number (-1)" />
            </xsl:when>
            <xsl:when test="$destination/*[@name = $commandInputParameter/smll:PartitionName/@value]">
                <xsl:value-of select="number (1)" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="number (0)" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template match="smll:AssignLogicalCPUs" mode="additionalCheck">
        <xsl:param name="rootId" />
        <xsl:param name="destination" />
        <xsl:param name="commandInputParameter" />

        <xsl:variable name="refFrom" select="document ('MetaInfo.xml')/mi:MetaInfo/mi:RefTranslations/mi:Element/mi:Ref[@name = local-name ($commandInputParameter/smll:CurrentlyAssignedTo/*)]" />
        <xsl:variable name="partitionFrom">
            <xsl:apply-templates select="$commandInputParameter/smll:CurrentlyAssignedTo/*" mode="createID.IDREF" />
        </xsl:variable>

        <xsl:variable name="refTo" select="document ('MetaInfo.xml')/mi:MetaInfo/mi:RefTranslations/mi:Element/mi:Ref[@name = local-name ($commandInputParameter/smll:Destination/*)]" />
        <xsl:variable name="partitionTo">
            <xsl:apply-templates select="$commandInputParameter/smll:Destination/*" mode="createID.IDREF" />
        </xsl:variable>

        <xsl:variable name="checkSourceCPU">
            <xsl:for-each select="$commandInputParameter/smll:LogicalCPUs/*">
                <xsl:variable name="logicalCPUId">
                    <xsl:apply-templates select="." mode="createID.IDREF" />
                </xsl:variable>

                <xsl:for-each select="document ($storageURI)">
                    <xsl:variable name="logicalCPU" select="id ($logicalCPUId)" />
                    <xsl:if test="not (boolean ($logicalCPU) and
                                       ((boolean ($refFrom) and
                                         $logicalCPU/@*[local-name () = $refFrom/@attributeName] and
                                         string ($logicalCPU/@*[local-name () = $refFrom/@attributeName]) =
                                             $partitionFrom) or
                                        (not ($refFrom) and
                                         not ($logicalCPU/@hardPartitionRef or $logicalCPU/@subPartitionRef))
                                       ))">
                        <xsl:value-of select="1" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>

        <xsl:variable name="hardPartitionFrom">
            <xsl:if test="$refFrom">
                <xsl:apply-templates select="$commandInputParameter/smll:CurrentlyAssignedTo/*" mode="createID.IDREF">
                    <xsl:with-param name="refName" select="'HardPartitionRef'" />
                </xsl:apply-templates>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="hardPartitionTo">
            <xsl:if test="$refTo">
                <xsl:apply-templates select="$commandInputParameter/smll:Destination/*" mode="createID.IDREF">
                    <xsl:with-param name="refName" select="'HardPartitionRef'" />
                </xsl:apply-templates>
            </xsl:if>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="not ($destination)">
                <xsl:value-of select="number (-1)" />
            </xsl:when>
            <xsl:when test="string-length ($checkSourceCPU) != 0">
                <xsl:value-of select="number (-2)" />
            </xsl:when>
            <xsl:when test="boolean ($refFrom) and boolean ($refTo) and $hardPartitionFrom != $hardPartitionTo">
                <xsl:value-of select="number (-3)" />
            </xsl:when>
            <xsl:when test="(boolean ($refFrom) and boolean ($refTo) and $partitionFrom = $partitionTo) or
                            (not ($refFrom) and not ($refTo))
                           ">
                <xsl:value-of select="number (1)" />
            </xsl:when>
            <xsl:when test="(boolean ($refFrom) != boolean ($refTo)) or
                            (boolean ($refFrom) and $hardPartitionFrom = $hardPartitionTo and
                                                    $partitionFrom != $partitionTo)
                           ">
                <xsl:value-of select="number (0)" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="smll:*" mode="additionalCheck">
        <xsl:param name="rootId" />
        <xsl:param name="destination" />
        <xsl:param name="commandInputParameter" />

        <xsl:choose>
            <xsl:when test="$destination">
                <xsl:value-of select="number (0)" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="number (-1)" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="applyResult">
        <xsl:param name="commandDescription" />
        <xsl:param name="result" />

        <xsl:variable name="resultDescription"
                      select="$commandDescription/ol:Result[@result = $result] |
                              $offlineExecution/ol:Commands/ol:Result[@category = $commandDescription/@category and @result = $result] |
                              $offlineExecution/ol:Commands/ol:Result[not (@category) and @result = $result]
                             " />
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  resultDescription - ', $resultDescription/@description)" />
            <xsl:value-of select="concat ('  rootResultDescription - ', $offlineExecution/ol:Commands/ol:Result[@category = $commandDescription/@category and @result = $result]/@description)" />
            <xsl:value-of select="concat (', result - ', $result)" />
            <xsl:value-of select="concat (', commandDescription.category - ',  $commandDescription/@category)" />
        </xsl:message>
-->

        <xsl:element name="Result" namespace="http://schemas.amsd.com/mpmu/smlan/logical">
            <xsl:attribute name="error">
                <xsl:value-of select="$result" />
            </xsl:attribute>
            <xsl:attribute name="desc">
                <xsl:value-of select="$resultDescription/@description" />
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="ol:Update" mode="controlCommands">
        <xsl:param name="rootId" />
        <xsl:param name="destination" />
        <xsl:param name="commandInputParameter" />
        <xsl:param name="multipleDestinationId" />

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  rootId - ', $rootId)" />
            <xsl:value-of select="concat (', destination - ', local-name ($destination))" />
        </xsl:message>
-->

        <xsl:choose>
            <xsl:when test="@required">
                <xsl:variable name="requiredAttribute" select="ol:Attribute[@name = current ()/@required]" />
<!--
                <xsl:message>
                    <xsl:value-of select="concat ('  requiredAttribute - ', $requiredAttribute)" />
                </xsl:message>
-->

                <xsl:variable name="attributeValue">
                    <xsl:apply-templates select="$requiredAttribute" mode="controlCommands">
                        <xsl:with-param name="rootId" select="$rootId" />
                        <xsl:with-param name="destination" select="$destination" />
                        <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                        <xsl:with-param name="multipleDestinationId" select="$multipleDestinationId" />
                        <xsl:with-param name="checkOnly" select="true ()" />
                    </xsl:apply-templates>
                </xsl:variable>

                <xsl:if test="string-length ($attributeValue) != 0">
                    <xsl:call-template name="createUpdate">
                        <xsl:with-param name="rootId" select="$rootId" />
                        <xsl:with-param name="destination" select="$destination" />
                        <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                        <xsl:with-param name="multipleDestinationId" select="$multipleDestinationId" />
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="createUpdate">
                    <xsl:with-param name="rootId" select="$rootId" />
                    <xsl:with-param name="destination" select="$destination" />
                    <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                    <xsl:with-param name="multipleDestinationId" select="$multipleDestinationId" />
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="createUpdate">
        <xsl:param name="rootId" />
        <xsl:param name="destination" />
        <xsl:param name="commandInputParameter" />
        <xsl:param name="multipleDestinationId" />

        <xsl:element name="{@name}" namespace="http://schemas.amsd.com/mpmu/data/update">
            <xsl:attribute name="category">
                <xsl:value-of select="'mpmu.server.storage'" />
            </xsl:attribute>

            <xsl:apply-templates select="ol:Id" mode="controlCommands">
                <xsl:with-param name="rootId" select="$rootId" />
                <xsl:with-param name="destination" select="$destination" />
                <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                <xsl:with-param name="multipleDestinationId" select="$multipleDestinationId" />
            </xsl:apply-templates>

            <xsl:apply-templates select="ol:Attribute" mode="controlCommands">
                <xsl:with-param name="rootId" select="$rootId" />
                <xsl:with-param name="destination" select="$destination" />
                <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                <xsl:with-param name="multipleDestinationId" select="$multipleDestinationId" />
            </xsl:apply-templates>

            <xsl:if test="ol:Element">
                <xsl:element name="{ol:Element/@name}" namespace="http://schemas.amsd.com/mpmu/marvel/general">
                    <xsl:apply-templates select="ol:Element/ol:Attribute" mode="controlCommands">
                        <xsl:with-param name="rootId" select="$rootId" />
                        <xsl:with-param name="destination" select="$destination" />
                        <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                        <xsl:with-param name="multipleDestinationId" select="$multipleDestinationId" />
                    </xsl:apply-templates>
                </xsl:element>
            </xsl:if>
        </xsl:element>
    </xsl:template>

    <xsl:template match="ol:Id|ol:Attribute" mode="controlCommands">
        <xsl:param name="rootId" />
        <xsl:param name="destination" />
        <xsl:param name="commandInputParameter" />
        <xsl:param name="multipleDestinationId" />
        <xsl:param name="checkOnly" />

        <xsl:variable name="attributeValue">
            <xsl:choose>
                <xsl:when test="starts-with (@value, 'function.')">
                    <xsl:variable name="functionName" select="substring-after (@value, 'function.')" />
                    <xsl:call-template name="ExecuteFunction">
                        <xsl:with-param name="functionName" select="$functionName" />
                        <xsl:with-param name="rootId" select="$rootId" />
                        <xsl:with-param name="destination" select="$destination" />
                        <xsl:with-param name="attributeName" select="@name" />
                        <xsl:with-param name="commandInputParameter" select="$commandInputParameter" />
                        <xsl:with-param name="multipleDestinationId" select="$multipleDestinationId" />
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="starts-with (@value, 'value.')">
                    <xsl:variable name="valueName" select="substring-after (@value, 'value.')" />
                    <xsl:value-of select="$commandInputParameter/*[local-name () = $valueName]/@value" />
                </xsl:when>
                <xsl:when test="not (@value)">
                    <xsl:value-of select="$rootId" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@value" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="not ($checkOnly)">
                <xsl:if test="string-length ($attributeValue) != 0">
                    <xsl:attribute name="{@name}">
                        <xsl:value-of select="$attributeValue" />
                    </xsl:attribute>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$attributeValue" />
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <xsl:template name="ExecuteFunction">
        <xsl:param name="functionName" />
        <xsl:param name="rootId" />
        <xsl:param name="destination" />
        <xsl:param name="attributeName" />
        <xsl:param name="commandInputParameter" />
        <xsl:param name="multipleDestinationId" />
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  functionName - ', $functionName)" />
            <xsl:value-of select="concat (', rootId - ', $rootId)" />
        </xsl:message>
-->

        <xsl:choose>
            <xsl:when test="$functionName = 'calculateExclusiveValue'">
                <xsl:call-template name="calculateExclusiveValue">
                    <xsl:with-param name="attributeName" select="$attributeName" />
                    <xsl:with-param name="destination" select="$destination" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$functionName = 'destinationId'">
                <xsl:value-of select="$rootId" />
            </xsl:when>
            <xsl:when test="starts-with ($functionName, 'refTranslationFrom.')">
                <xsl:variable name="fromParameter" select="substring-after ($functionName, 'refTranslationFrom.')" />
                <xsl:call-template name="refTranslationFrom">
                    <xsl:with-param name="fromParameter" select="local-name ($commandInputParameter/*[local-name () = $fromParameter]/*)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$functionName = 'multipleDestinationId'">
                <xsl:value-of select="$multipleDestinationId" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="calculateExclusiveValue">
        <xsl:param name="attributeName" />
        <xsl:param name="destination" />
        <xsl:param name="value" select="number (0)" />

        <xsl:choose>
            <xsl:when test="$destination/*/@*[local-name () = $attributeName] = $value">
                <xsl:call-template name="calculateExclusiveValue">
                    <xsl:with-param name="attributeName" select="$attributeName" />
                    <xsl:with-param name="destination" select="$destination" />
                    <xsl:with-param name="value" select="number ($value + 1)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$value" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="refTranslationFrom">
        <xsl:param name="fromParameter" />

        <xsl:variable name="ref" select="document ('MetaInfo.xml')/mi:MetaInfo/mi:RefTranslations/mi:Element/mi:Ref[@name = $fromParameter]" />
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  fromParameter - ', $fromParameter)" />
            <xsl:value-of select="concat (', attributeName - ', $ref/@attributeName)" />
        </xsl:message>
-->

        <xsl:choose>
            <xsl:when test="$ref">
                <xsl:value-of select="$ref/@attributeName" />
            </xsl:when>
            <xsl:otherwise>
                <!--xsl:message terminate="yes" /-->
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template match="@*|*" mode="copyOnly">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyOnly" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
