<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:smlp="http://schemas.amsd.com/mpmu/smlan/protocol"
    xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
    xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
    xmlns:sma="http://schemas.amsd.com/mpmu/smlan/alerts"
    xmlns:javaeg="http://xml.apache.org/xslt/java/com.hp.asd.mpmu.server.smlanlib.EntryGenerator"
    exclude-result-prefixes="javaeg smll smlp xs mv #default"
    version="2.2"
>
    <xsl:output indent="yes" method="xml" encoding="UTF-8"/>

    <xsl:variable name="emulatorSMLANProtocolVersion" select="1.8"/>

    <xsl:variable name="definesXml">urn:xmls-amsd-com:mpmu:defines</xsl:variable>
    <xsl:variable name="alertsXml">urn:xmls-amsd-com:mpmu:smlan:alerts</xsl:variable>
    <xsl:variable name="protocolXsd">urn:schemas-amsd-com:mpmu:smlan:protocol</xsl:variable>

    <xsl:variable name="logicalXml">urn:xmls-amsd-com:mpmu:smlan:logical</xsl:variable>

    <xsl:variable name="mv-uri">http://schemas.amsd.com/mpmu/marvel/general</xsl:variable>
    <xsl:variable name="smll-uri">http://schemas.amsd.com/mpmu/smlan/logical</xsl:variable>

    <xsl:variable name="hardPartitionLocator" select="255"/>
    <xsl:variable name="smlanProtocolVersion" select="string(document($protocolXsd)/xs:schema/@version)"/>

    <xsl:variable name="rackPerfix" select="string('Rack')"/>
    <xsl:variable name="boxPerfix" select="string('Box')"/>

    <xsl:variable name="defaultCmdTimeOut" select="number(10)"/>
    <xsl:variable name="defaultCmdRetry" select="number(2)"/>

    <!-- ******************** commands *********************** -->

    <xsl:template match="smll:GetTopology">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:variable name="entityHandle" select="string(javaeg:getEntityHandle())"/>

            <xsl:choose>
                <xsl:when test="starts-with($entityHandle, $rackPerfix)">
                    <!--
                        [$entityHandle] format [Rack<number>RackBox<number>Box]
                    -->
                    <xsl:element name="GetMBMConfiguration">
                        <xsl:variable name="mbmIPAddress">
                            <xsl:call-template name="makeMBMIPAddress">
                                <xsl:with-param name="rackNumber" select="number(substring-before(substring-after($entityHandle, $rackPerfix), $rackPerfix))"/>
                                <xsl:with-param name="boxNumber" select="number(substring-before(substring-after($entityHandle, $boxPerfix), $boxPerfix))"/>
                            </xsl:call-template>
                        </xsl:variable>
                        <xsl:call-template name="makeHeader">
                            <xsl:with-param name="commandName" select="string('GetMBMConfiguration')"/>
                            <xsl:with-param name="destinationIPAddress" select="$mbmIPAddress"/>
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="GetSystemTopology">
                        <xsl:call-template name="makeHeader">
                            <xsl:with-param name="commandName" select="string('GetSystemTopology')"/>
                        </xsl:call-template>
                        <xsl:element name="EntityHandle">
                            <xsl:value-of select="string(javaeg:getEntityHandle())"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetPartitioning">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetPartitionDatabase">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetPartitionDatabase')"/>
                </xsl:call-template>
            </xsl:element>

        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetCabling">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetCablingConfiguration">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetCablingConfiguration')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:GetSystemBoxConfiguration">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetMBMConfiguration">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetMBMConfiguration')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:GetIOBoxConfiguration">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetPBMConfiguration">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetPBMConfiguration')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:PowerOnHardPartition">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="PowerOnPartition">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('PowerOnPartition')"/>
                </xsl:call-template>

                <xsl:call-template name="makePartitionLocation"/>

                <xsl:apply-templates select="smll:Input/smll:LevelToStart"/>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:PowerOffHardPartition">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="PowerOffPartition">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('PowerOffPartition')"/>
                </xsl:call-template>

                <xsl:call-template name="makePartitionLocation"/>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:StartSubPartition">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="StartPartition">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('StartPartition')"/>
                </xsl:call-template>

                <xsl:call-template name="makePartitionLocation"/>

                <xsl:apply-templates select="smll:Input/smll:LevelToStart"/>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:ResetHardPartition">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="ResetPartition">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('ResetPartition')"/>
                </xsl:call-template>

                <xsl:call-template name="makePartitionLocation"/>

                <xsl:apply-templates select="smll:Input/smll:LevelToStart"/>
            </xsl:element>
        </Packet>
    </xsl:template>


    <xsl:template match="smll:LevelToStart">
        <xsl:variable name="startLevelNode" select="document($definesXml)/Defs/DataType[@name='LevelToStart']/Define[@id=string(current()/@value)]"/>
        <xsl:if test="$startLevelNode">
            <xsl:element name="StartLevel">
                <xsl:value-of select="number($startLevelNode/@number)"/>
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:DestroyHardPartition | smll:DestroySubPartition">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="DestroyPartition">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('DestroyPartition')"/>
                </xsl:call-template>
                <xsl:call-template name="makePartitionLocation"/>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:HaltOnSubPartition | smll:HaltOffSubPartition">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="HaltPartition">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('HaltPartition')"/>
                </xsl:call-template>

                <xsl:call-template name="makePartitionLocation"/>

                <xsl:element name="Action">
                    <xsl:choose>
                        <xsl:when test="name(.)='HaltOnSubPartition'">
                            <xsl:value-of select="1"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>


    <xsl:template name="makePartitionLocation">
        <xsl:element name="HardPartition">
            <xsl:value-of select="number(smll:Input/smll:Destination/*/@hardPartitionNumber)"/>
        </xsl:element>
        <xsl:variable name="spRef" select="smll:Input/smll:Destination/mv:SubPartitionRef"/>
        <xsl:element name="SubPartition">
            <xsl:choose>
                <xsl:when test="$spRef">
                    <xsl:value-of select="number($spRef/@subPartitionNumber)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$hardPartitionLocator"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>


    <!-- ***************************************************************** -->

    <xsl:template match="smll:CreateSubPartition">
        <xsl:call-template name="makePartitionCommand">
            <xsl:with-param name="hardPartitionNumber" select="number(smll:Input/smll:Destination/mv:HardPartitionRef/@hardPartitionNumber)"/>
        </xsl:call-template>
    </xsl:template>


    <xsl:template match="smll:CreateHardPartition">
        <xsl:call-template name="makePartitionCommand">
            <xsl:with-param name="ev7Allowed" select="number(smll:Input/smll:MaximumCPUs/@value)"/>
            <xsl:with-param name="subPartitionType" select="number(document($definesXml)/Defs/DataType[@name='SubPartitionType']/Define[@id=current()/smll:Input/smll:SubPartitionType/@value]/@number)"/>
            <xsl:with-param name="striping" select="number(document($definesXml)/Defs/DataType[@name='Striping']/Define[@id=current()/smll:Input/smll:Striping/@value]/@number)"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="smll:SetHardPartitionAttributes">
        <xsl:call-template name="makePartitionCommand">
            <xsl:with-param name="cmdName" select="string('SetPartitionAttributes')"/>
            <xsl:with-param name="hardPartitionNumber" select="number(smll:Input/smll:Destination/mv:HardPartitionRef/@hardPartitionNumber)"/>
            <xsl:with-param name="ev7Allowed" select="number(smll:Input/smll:MaximumCPUs/@value)"/>
            <xsl:with-param name="subPartitionType" select="number(document($definesXml)/Defs/DataType[@name='SubPartitionType']/Define[@id=current()/smll:Input/smll:SubPartitionType/@value]/@number)"/>
            <xsl:with-param name="striping" select="number(document($definesXml)/Defs/DataType[@name='Striping']/Define[@id=current()/smll:Input/smll:Striping/@value]/@number)"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="makePartitionCommand">
        <xsl:param name="hardPartitionNumber" select="255"/>
        <xsl:param name="ev7Allowed" select="0"/>
        <xsl:param name="subPartitionType" select="0"/>
        <xsl:param name="striping" select="0"/>
        <xsl:param name="cmdName" select="string('CreatePartition')"/>

        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="{$cmdName}">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string($cmdName)"/>
                </xsl:call-template>

                <xsl:element name="HardPartition">
                    <xsl:value-of select="number($hardPartitionNumber)"/>
                </xsl:element>

                <xsl:element name="SubPartition">
                    <xsl:value-of select="255"/>
                </xsl:element>

                <xsl:if test="smll:Input/smll:PartitionName">
                    <xsl:element name="PartitionName">
                        <xsl:value-of select="string(smll:Input/smll:PartitionName/@value)"/>
                    </xsl:element>
                </xsl:if>

                <xsl:element name="Attributes">
                    <xsl:element name="EV7Allowed">
                        <xsl:value-of select="number($ev7Allowed)"/>
                    </xsl:element>
                    <xsl:element name="SubPartitionsType">
                        <xsl:value-of select="number($subPartitionType)"/>
                    </xsl:element>
                    <xsl:element name="Modifiers">
                        <xsl:value-of select="number($striping)"/>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->


    <xsl:template match="smll:AssignLogicalCPUs">
        <xsl:variable name="dest" select="smll:Input/smll:Destination"/>
        <xsl:variable name="cur" select="smll:Input/smll:CurrentlyAssignedTo"/>

        <xsl:choose>
            <xsl:when test="$dest/mv:MarvelRef and $cur/mv:HardPartitionRef">
                <xsl:call-template name="removeCPUs">
                    <xsl:with-param name="hardPartitionNumber" select="$cur/mv:HardPartitionRef/@hardPartitionNumber"/>
                    <xsl:with-param name="freePoolDestination" select="number(0)"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$dest/mv:MarvelRef and $cur/mv:SubPartitionRef">
                <xsl:call-template name="removeCPUs">
                    <xsl:with-param name="hardPartitionNumber" select="$cur/mv:SubPartitionRef/@hardPartitionNumber"/>
                    <xsl:with-param name="freePoolDestination" select="number(0)"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$dest/mv:HardPartitionRef and $cur/mv:SubPartitionRef">
                <xsl:call-template name="removeCPUs">
                    <xsl:with-param name="hardPartitionNumber" select="$cur/mv:SubPartitionRef/@hardPartitionNumber"/>
                    <xsl:with-param name="freePoolDestination" select="number(1)"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$dest/mv:SubPartitionRef and ($cur/mv:HardPartitionRef or $cur/mv:MarvelRef)">
                <xsl:call-template name="moveCPUs">
                    <xsl:with-param name="hardPartitionNumber" select="$dest/mv:SubPartitionRef/@hardPartitionNumber"/>
                    <xsl:with-param name="subPartitionNumber" select="$dest/mv:SubPartitionRef/@subPartitionNumber"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$dest/mv:HardPartitionRef and $cur/mv:MarvelRef">
                <xsl:call-template name="moveCPUs">
                    <xsl:with-param name="hardPartitionNumber" select="$dest/mv:HardPartitionRef/@hardPartitionNumber"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">invalid format for AssignLogicalCPUs</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="removeCPUs">
        <xsl:param name="hardPartitionNumber"/>
        <xsl:param name="freePoolDestination"/>
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="RemoveEV7s">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('RemoveEV7s')"/>
                </xsl:call-template>

                <xsl:element name="HardPartition">
                    <xsl:value-of select="$hardPartitionNumber"/>
                </xsl:element>
                <xsl:element name="FPDestination">
                    <xsl:value-of select="$freePoolDestination"/>
                </xsl:element>

                <xsl:apply-templates select="smll:Input/smll:LogicalCPUs"/>
            </xsl:element>
        </Packet>
    </xsl:template>


    <xsl:template name="moveCPUs">
        <xsl:param name="hardPartitionNumber"/>
        <xsl:param name="subPartitionNumber" select="number(255)"/>
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="MoveEV7s">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('MoveEV7s')"/>
                </xsl:call-template>

                <xsl:element name="HardPartition">
                    <xsl:value-of select="$hardPartitionNumber"/>
                </xsl:element>
                <xsl:element name="SubPartition">
                    <xsl:value-of select="$subPartitionNumber"/>
                </xsl:element>

                <xsl:apply-templates select="smll:Input/smll:LogicalCPUs"/>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template match="smll:Input/smll:LogicalCPUs">
        <xsl:element name="EV7List">
            <xsl:element name="EV7Count">
                <xsl:value-of select="count(*)"/>
            </xsl:element>
            <xsl:apply-templates select="mv:LogicalCPURef"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="mv:LogicalCPURef">
        <xsl:element name="EV7">
            <xsl:element name="NS">
                <xsl:value-of select="number(@y)"/>
            </xsl:element>
            <xsl:element name="EW">
                <xsl:value-of select="number(@x)"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:ReconfigureCabling">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="ReconfigureCabling">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('ReconfigureCabling')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:SaveEntirePartitionDatabase">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="SavePartitionDatabase">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('SavePartitionDatabase')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->

    <xsl:template match="smll:SaveAllHardPartitionAssignments | smll:SaveHardPartitionAssignments">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="SavePartitionAssignments">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('SavePartitionAssignments')"/>
                </xsl:call-template>
                <xsl:variable name="hard" select="smll:Input/smll:Destination/mv:HardPartitionRef"/>
                <xsl:element name="HardPartition">
                    <xsl:choose>
                        <xsl:when test="$hard">
                            <xsl:value-of select="number($hard/@hardPartitionNumber)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="255"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
                <xsl:element name="SubPartition">
                    <xsl:value-of select="255"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>


    <!-- ***************************************************************** -->
    <xsl:template match="smll:PowerOnComponent | smll:PowerOffComponent">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="PowerOnOff">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('PowerOnOff')"/>
                </xsl:call-template>

                <xsl:element name="Action">
                    <xsl:choose>
                        <xsl:when test="name(.)='PowerOnComponent'">
                            <xsl:value-of select="1"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>


    <!-- ***************************************************************** -->
    <xsl:template match="smll:TurnOnAllCableLEDs | smll:TurnOffAllCableLEDs">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="TestLeds">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('TestLeds')"/>
                </xsl:call-template>
                <xsl:choose>
                    <xsl:when test="name(.)='TurnOnAllCableLEDs'">
                        <xsl:element name="IndicatorMode">
                            <xsl:value-of select="1"/>
                        </xsl:element>
                        <xsl:element name="Interval">
                            <xsl:value-of select="number(smll:Input/smll:TestInterval/@value)"/>
                        </xsl:element>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="IndicatorMode">
                            <xsl:value-of select="0"/>
                        </xsl:element>
                        <xsl:element name="Interval">
                            <xsl:value-of select="0"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </Packet>
    </xsl:template>


    <!-- ***************************************************************** -->
    <xsl:template match="smll:GetVoltages">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetVoltageReadings">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetVoltageReadings')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->
    <xsl:template match="smll:GetTemperatures">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetTemperatureReadings">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetTemperatureReadings')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->
    <xsl:template match="smll:GetFans">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetFanRPMReadings">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetFanRPMReadings')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->
    <xsl:template match="smll:GetPCISlotInfo">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetPCISlotInfo">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetPCISlotInfo')"/>
                </xsl:call-template>
                <xsl:element name="IO7RiserNumber">
                    <xsl:value-of select="number(smll:Input/smll:Destination/mv:IORiserRef/@ioRiserNumber)"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>


    <!-- ***************************************************************** -->
    <xsl:template match="smll:GetFirmwareVersion">
        <xsl:variable name="module" select="document($definesXml)/Defs/DataType[@name='Firmware']"/>
        <xsl:variable name="state" select="document($definesXml)/Defs/DataType[@name='FirmwareState']"/>

        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetFirmwareVersion">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetFirmwareVersion')"/>
                </xsl:call-template>
                <xsl:element name="Module">
                    <xsl:value-of select="number($module/Define[@id=current()/smll:Input/smll:Destination/*/@module]/@number)"/>
                </xsl:element>
                <xsl:element name="State">
                    <xsl:value-of select="number($state/Define[@id=current()/smll:Input/smll:Destination/*/@state]/@number)"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->
    <xsl:template match="smll:UpgradeFirmware">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="UpgradeFirmware">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('UpgradeFirmware')"/>
                </xsl:call-template>
                <xsl:call-template name="makeFirmwareParams"/>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ***************************************************************** -->
    <xsl:template match="smll:LoadTestFirmware">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="LoadTestFirmware">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('LoadTestFirmware')"/>
                </xsl:call-template>
                <xsl:call-template name="makeFirmwareParams"/>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template name="makeFirmwareParams">
        <xsl:variable name="module" select="document($definesXml)/Defs/DataType[@name='Firmware']"/>
        <xsl:element name="Module">
            <xsl:value-of select="number($module/Define[@id=current()/smll:Input/smll:Destination/*/@module]/@number)"/>
        </xsl:element>
        <xsl:element name="Server">
            <xsl:choose>
                <xsl:when test="smll:Input/smll:TFTPServerAddress">
                    <xsl:value-of select="javaeg:encodeIpAddress(string(smll:Input/smll:TFTPServerAddress/@value))"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="javaeg:encodeIpAddress(string('255.255.255.255'))"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
        <xsl:element name="Filename">
            <xsl:choose>
                <xsl:when test="smll:Input/smll:ModuleFileName">
                    <xsl:value-of select="javaeg:makeFullHEX(string(smll:Input/smll:ModuleFileName/@value), 256)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="javaeg:makeFullHEX(string(''), 256)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <!-- ***************************************************************** -->
    <xsl:template match="smll:DisableTestFirmware">
        <xsl:variable name="module" select="document($definesXml)/Defs/DataType[@name='Firmware']"/>

        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="DisableTestFirmware">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('DisableTestFirmware')"/>
                </xsl:call-template>
                <xsl:element name="Module">
                    <xsl:value-of select="number($module/Define[@id=current()/smll:Input/smll:Destination/*/@module]/@number)"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetIPConnections">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetIPConnections">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetIPConnections')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="smll:GetAttentionIndicators">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetAttentionIndicator">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetAttentionIndicator')"/>
                </xsl:call-template>
                <xsl:call-template name="makeIndicatorDestination"/>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template match="smll:TurnOnAttentionIndicator | smll:TurnOffAttentionIndicator">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="SetAttentionIndicator">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('SetAttentionIndicator')"/>
                </xsl:call-template>
                <xsl:call-template name="makeIndicatorDestination"/>
                <xsl:element name="State">
                    <xsl:choose>
                        <xsl:when test="name(.)='TurnOnAttentionIndicator'">
                            <xsl:value-of select="1"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template name="makeIndicatorDestination">
        <xsl:element name="Rack">
            <xsl:value-of select="0"/>
        </xsl:element>
        <xsl:element name="Box">
            <xsl:value-of select="0"/>
        </xsl:element>
        <xsl:element name="Instance">
            <xsl:value-of select="0"/>
        </xsl:element>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="smll:GetSystemPowerSupplies | smll:GetInternalPowerSupplies">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetStateOfPowerSupplies">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetStateOfPowerSupplies')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetSystemPowerInterfaces">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetPSTray">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetPSTray')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:SetOCPDisplay">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="SetOCPDisplayData">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('SetOCPDisplayData')"/>
                </xsl:call-template>
                <xsl:element name="DisplayData">
                    <xsl:value-of select="javaeg:makeFullHEX(string(smll:Input/smll:OCPText/@value), 120)"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="smll:SetFanSpeed">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="SetFanSpeed">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('SetFanSpeed')"/>
                </xsl:call-template>
                <xsl:element name="Locator">
                    <xsl:value-of select="document($definesXml)/Defs/DataType/Define[@id=string(current()/smll:Input/smll:Destination/*/@locator)]/@number"/>
                </xsl:element>
                <xsl:element name="Speed">
                    <xsl:value-of select="number(smll:Input/smll:FanSpeedLevel/@value)"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="smll:GetSwitch">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetSwitchState">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetSwitchState')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:AssignMemory">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:variable name="subRef" select="smll:Input/smll:Destination/mv:SubPartitionRef"/>

            <xsl:element name="AssignMemory">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('AssignMemory')"/>
                </xsl:call-template>
                <xsl:element name="HardPartition">
                    <xsl:choose>
                        <xsl:when test="$subRef">
                            <xsl:value-of select="number($subRef/@hardPartitionNumber)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="number(smll:Input/smll:Destination/mv:HardPartitionRef/@hardPartitionNumber)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
                <xsl:element name="SubPartition">
                    <xsl:choose>
                        <xsl:when test="$subRef">
                            <xsl:value-of select="number($subRef/@subPartitionNumber)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="number(255)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
                <xsl:element name="Community">
                    <xsl:choose>
                        <xsl:when test="$subRef">
                            <xsl:value-of select="number(0)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="number(1)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
                <xsl:element name="MemorySize">
                    <xsl:value-of select="number(smll:Input/smll:Size/@value) * 1024 * 1024"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:AssignIOPort">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="AssignIOPort">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('AssignIOPort')"/>
                </xsl:call-template>
                <xsl:element name="HardPartition">
                    <xsl:value-of select="number(smll:Input/smll:Destination/mv:SubPartitionRef/@hardPartitionNumber)"/>
                </xsl:element>
                <xsl:element name="SubPartition">
                    <xsl:value-of select="number(smll:Input/smll:Destination/mv:SubPartitionRef/@subPartitionNumber)"/>
                </xsl:element>
                <xsl:element name="Community">
                    <xsl:value-of select="0"/>
                </xsl:element>
                <xsl:element name="EV7">
                    <xsl:element name="NS">
                        <xsl:value-of select="number(smll:Input/smll:LogicalCPU/mv:LogicalCPURef/@y)"/>
                    </xsl:element>
                    <xsl:element name="EW">
                        <xsl:value-of select="number(smll:Input/smll:LogicalCPU/mv:LogicalCPURef/@x)"/>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:SetVoltages">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="SetVolts">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('SetVolts')"/>
                </xsl:call-template>
                <xsl:element name="Voltage">
                    <xsl:element name="CPU">
                        <xsl:value-of select="number(smll:Input/smll:CPUVoltage/@value) * 1000"/>
                    </xsl:element>
                    <xsl:element name="Terminal">
                        <xsl:value-of select="number(smll:Input/smll:TerminatorVoltage/@value) * 1000"/>
                    </xsl:element>
                    <xsl:element name="RIMM">
                        <xsl:value-of select="number(smll:Input/smll:RIMMVoltage/@value) * 1000"/>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="smll:SetFrequency">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="SetFrequency">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('SetFrequency')"/>
                </xsl:call-template>
                <xsl:element name="Frequency">
                    <xsl:value-of select="number(smll:Input/smll:CPUFrequency/@value)"/>
                </xsl:element>
                <xsl:element name="Ratio">
                    <xsl:element name="IP">
                        <xsl:value-of select="number(smll:Input/smll:IPRatio/@value)*10"/>
                    </xsl:element>
                    <xsl:element name="IO">
                        <xsl:value-of select="number(smll:Input/smll:IORatio/@value)*10"/>
                    </xsl:element>
                    <xsl:element name="Zbox">
                        <xsl:value-of select="number(smll:Input/smll:ZBoxRatio/@value)*10"/>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetFrequency">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetFrequency">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetFrequency')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetIntrusions">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetIntrusion">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetIntrusion')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:TurnOnIPCableLEDs | smll:TurnOffIPCableLEDs">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="CableAssist">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('CableAssist')"/>
                </xsl:call-template>

                <xsl:element name="IndicatorMode">
                    <xsl:choose>
                        <xsl:when test="name(.)='TurnOnIPCableLEDs'">
                            <xsl:value-of select="1"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
                <xsl:variable name="dest" select="smll:Input/smll:Destination/mv:IPCableRef"/>
                <xsl:call-template name="CableEndPoint">
                    <xsl:with-param name="name" select="string('FirstEnd')"/>
                    <xsl:with-param name="rack" select="$dest/mv:FirstEndRef/@rackNumber"/>
                    <xsl:with-param name="box" select="$dest/mv:FirstEndRef/@boxNumber"/>
                    <xsl:with-param name="direction" select="document($definesXml)/Defs/DataType[@name='PortDirection']/Define[@id=string($dest/@firstPortDirection)]/@number"/>
                </xsl:call-template>
                <xsl:element name="AbsentFlag">
                    <xsl:value-of select="1"/>
                </xsl:element>
                <xsl:call-template name="CableEndPoint">
                    <xsl:with-param name="name" select="string('SecondEnd')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:TurnOnIOCableLEDs | smll:TurnOffIOCableLEDs">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="CableAssist">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('CableAssist')"/>
                </xsl:call-template>

                <xsl:element name="IndicatorMode">
                    <xsl:choose>
                        <xsl:when test="name(.)='TurnOnIOCableLEDs'">
                            <xsl:value-of select="1"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
                <xsl:variable name="dest" select="smll:Input/smll:Destination/mv:CPURef"/>
                <xsl:call-template name="CableEndPoint">
                    <xsl:with-param name="name" select="string('FirstEnd')"/>
                    <xsl:with-param name="rack" select="$dest/@rackNumber"/>
                    <xsl:with-param name="box" select="$dest/@boxNumber"/>
                    <xsl:with-param name="direction" select="6"/>
                    <xsl:with-param name="number" select="number($dest/@moduleNumber) * 2 + number($dest/@cpuNumber)"/>
                </xsl:call-template>
                <xsl:element name="AbsentFlag">
                    <xsl:value-of select="0"/>
                </xsl:element>
                <xsl:variable name="dest2" select="smll:Input/smll:IORiserEnd/mv:IORiserRef"/>
                <xsl:call-template name="CableEndPoint">
                    <xsl:with-param name="name" select="string('SecondEnd')"/>
                    <xsl:with-param name="rack" select="$dest2/@rackNumber"/>
                    <xsl:with-param name="box" select="$dest2/@boxNumber"/>
                    <xsl:with-param name="direction" select="7"/>
                    <xsl:with-param name="number" select="$dest2/@ioRiserNumber"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template name="CableEndPoint">
        <xsl:param name="name"/>
        <xsl:param name="rack" select="0"/>
        <xsl:param name="box" select="0"/>
        <xsl:param name="direction" select="0"/>
        <xsl:param name="number" select="0"/>

        <xsl:element name="{$name}">
            <xsl:element name="Rack">
                <xsl:value-of select="$rack"/>
            </xsl:element>
            <xsl:element name="Box">
                <xsl:value-of select="$box"/>
            </xsl:element>
            <xsl:element name="Direction">
                <xsl:value-of select="$direction"/>
            </xsl:element>
            <xsl:element name="Number">
                <xsl:value-of select="$number"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="smll:GetErrorLogCounter">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetErrorLogCount">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetErrorLogCount')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetErrorLogEntry">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetErrorLogEntry">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetErrorLogEntry')"/>
                </xsl:call-template>
                <xsl:element name="EntryNumber"><xsl:value-of select="number(smll:Input/smll:EntryNumber/@value)"/></xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetLogEntries">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">
            <xsl:choose>
                <xsl:when test="javaeg:getState('counterState')">
                    <xsl:element name="GetErrorLogCount">
                        <xsl:call-template name="makeHeader">
                            <xsl:with-param name="commandName" select="string('GetErrorLogCount')"/>
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="GetErrorLogEntry">
                        <xsl:call-template name="makeHeader">
                            <xsl:with-param name="commandName" select="string('GetErrorLogEntry')"/>
                        </xsl:call-template>
                        <xsl:element name="EntryNumber"><xsl:value-of select="string(javaeg:getEntityHandle())"/></xsl:element>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:GetPMUAgentAddress">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetPMUAgentAddress">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetPMUAgentAddress')"/>
                </xsl:call-template>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="smll:AlertsOnError">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="Subscribe">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('Subscribe')"/>
                </xsl:call-template>
                <xsl:element name="IPAddress">
                    <xsl:value-of select="javaeg:getOriginatorIPAddress()"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template match="smll:AlertsOn">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="Subscribe">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('Subscribe')"/>
                </xsl:call-template>
                <xsl:element name="IPAddress">
                    <xsl:value-of select="javaeg:getOriginatorIPAddress()"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template match="smll:AlertsOff">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="Unsubscribe">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('Unsubscribe')"/>
                </xsl:call-template>
                <xsl:element name="SID">
                    <xsl:value-of select="smll:Input/smll:SubscriptionID/@value"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template match="smll:AlertsRenew">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="RenewSubscription">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('RenewSubscription')"/>
                </xsl:call-template>
                <xsl:element name="SID">
                    <xsl:value-of select="smll:Input/smll:SubscriptionID/@value"/>
                </xsl:element>
                <xsl:element name="IPAddress">
                    <xsl:value-of select="javaeg:getOriginatorIPAddress()"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template match="smll:AlertsTest">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="Alert">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('Alert')"/>
                </xsl:call-template>
                <xsl:element name="Function">
                    <xsl:value-of select="number(9)"/>
                </xsl:element>
                <xsl:element name="EntryFormat">
                    <xsl:value-of select="number(6)"/>
                </xsl:element>
                <xsl:element name="Entry">
                    <xsl:element name="ErrorCode">
                        <xsl:value-of select="'0000100D'"/>
                    </xsl:element>
                    <xsl:element name="MicroIP">
                        <xsl:value-of select="'0005FE0A'"/>
                    </xsl:element>
                    <xsl:element name="Cabinet">
                        <xsl:value-of select="number(0)"/>
                    </xsl:element>
                    <xsl:element name="Drawer">
                        <xsl:value-of select="number(0)"/>
                    </xsl:element>
                    <xsl:element name="Instance">
                        <xsl:value-of select="number(0)"/>
                    </xsl:element>
                    <xsl:element name="EventType">
                        <xsl:value-of select="number(10)"/>
                    </xsl:element>
                    <xsl:element name="Severity">
                        <xsl:value-of select="number(0)"/>
                    </xsl:element>
                    <xsl:element name="QData">
                        <xsl:element name="Size">
                            <xsl:value-of select="number(1)"/>
                        </xsl:element>
                        <xsl:element name="Data">
                            <xsl:value-of select="'X'"/>
                        </xsl:element>
                    </xsl:element>
                    <xsl:element name="Text">
                        <xsl:element name="Size">
                            <xsl:value-of select="number(19)"/>
                        </xsl:element>
                        <xsl:element name="Data">
                            <xsl:value-of select="'IOR0 has been added'"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <xsl:template match="smll:SaveCDL">
        <Packet
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns="http://schemas.amsd.com/mpmu/smlan/protocol"
            xsi:schemaLocation="http://schemas.amsd.com/mpmu/smlan/protocol SMLANProtocol.xsd">

            <xsl:element name="GetCDL">
                <xsl:call-template name="makeHeader">
                    <xsl:with-param name="commandName" select="string('GetCDL')"/>
                </xsl:call-template>
                <xsl:element name="EntityHandle">
                    <xsl:value-of select="string(javaeg:getEntityHandle())"/>
                </xsl:element>
                <xsl:element name="HP">
                    <xsl:value-of select="number(smll:Input/smll:Destination/mv:HardPartitionRef/@hardPartitionNumber)"/>
                </xsl:element>
            </xsl:element>
        </Packet>
    </xsl:template>

    <!-- ******************** base *********************** -->

    <xsl:template name="makeHeader">
        <xsl:param name="commandName"/>
        <xsl:param name="destinationIPAddress"/>

        <xsl:variable name="commandNode" select="document($protocolXsd)/xs:schema/xs:complexType/xs:choice/xs:element[@name=$commandName]"/>

        <xsl:element name="Header">
            <!--
            <xsl:variable name="udpDestination" select="string(document($configXml)/mv:Marvels/mv:Marvel[@id=current()/smll:Input/smll:Destination/*/@marvelId and string(@type)=string('live')]/@pmuAddress)"/>

            <xsl:variable name="udpDestination" select="javaeg:translateMarvelId(string(current()/smll:Input/smll:Destination/*/@marvelId))"/>

            <xsl:if test="not($udpDestination) or not(javaeg:setUdpDestinationIPAddress(string($udpDestination)))">
                <xsl:message terminate="yes">Ip for Marvel '<xsl:value-of select="string(smll:Input/smll:Destination/*/@marvelId)"/>' not found!</xsl:message>
            </xsl:if>
            -->
            <xsl:element name="OriginatorIPAddress">
                <xsl:value-of select="javaeg:getOriginatorIPAddress()"/>
            </xsl:element>

            <xsl:element name="DestinationIPAddress">
                <xsl:choose>
                    <xsl:when test="$destinationIPAddress">
                        <xsl:value-of select="javaeg:encodeIpAddress(string($destinationIPAddress))"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="smll:Input/smll:Destination/*"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>

            <xsl:element name="Identifier">
                <xsl:value-of select="javaeg:nextIdentifier()"/>
            </xsl:element>

            <xsl:variable name="commandCode" select="string($commandNode/@smlp:packetCode)"/>
            <xsl:choose>
                <xsl:when test="string-length($commandCode)=4">
                    <xsl:element name="CommandCode">
                        <xsl:value-of select="string(javaeg:setupCmdCode($commandCode))"/>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:message terminate="yes">Invalid cmdCode '<xsl:value-of select="$commandCode"/>' for '<xsl:value-of select="$commandName"/>' !</xsl:message>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>

        <xsl:choose>
            <xsl:when test="$commandNode/@smlp:timeOut">
                <xsl:variable name="timeout" select="javaeg:setCmdTimeOut(number($commandNode/@smlp:timeOut))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="timeout" select="javaeg:setCmdTimeOut($defaultCmdTimeOut)"/>
            </xsl:otherwise>
        </xsl:choose>

        <xsl:choose>
            <xsl:when test="$commandNode/@smlp:cntRetry">
                <xsl:variable name="retry" select="javaeg:setCmdTimeOutRetry(number($commandNode/@smlp:cntRetry))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="retry" select="javaeg:setCmdTimeOutRetry($defaultCmdRetry)"/>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <xsl:template match="mv:SystemBoxRef | mv:SystemBoxFanRef | mv:SystemBoxFirmwareVersionRef | mv:SystemBoxFirmwareModuleRef">
        <xsl:call-template name="makeMBMIPAddressEx"/>
    </xsl:template>

    <xsl:template match="mv:ComboBoxRef | mv:ComboBoxFanRef | mv:ComboBoxFirmwareVersionRef | mv:ComboBoxFirmwareModuleRef">
        <xsl:call-template name="makeMBMIPAddressEx"/>
    </xsl:template>

    <xsl:template match="mv:CPURef">
        <xsl:call-template name="makeMBMIPAddressEx"/>
    </xsl:template>

    <xsl:template match="mv:IPCableRef">
        <xsl:variable name="mbmIPAddress">
            <xsl:call-template name="makeMBMIPAddress">
                <xsl:with-param name="rackNumber" select="number(mv:FirstEndRef/@rackNumber)"/>
                <xsl:with-param name="boxNumber" select="number(mv:FirstEndRef/@boxNumber)"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="javaeg:encodeIpAddress(string($mbmIPAddress))"/>
    </xsl:template>

    <xsl:template match="mv:IORiserRef">
        <xsl:call-template name="makePBMIPAddressEx"/>
    </xsl:template>

    <xsl:template match="mv:IOBoxRef | mv:IOBoxFanRef | mv:IOBoxFirmwareVersionRef | mv:IOBoxFirmwareModuleRef">
        <xsl:call-template name="makePBMIPAddressEx"/>
    </xsl:template>

    <xsl:template match="mv:DualCPUModuleRef | mv:DualCPUModuleFirmwareVersionRef | mv:DualCPUModuleFirmwareModuleRef">
        <xsl:variable name="cmmIPAddress">
            <xsl:call-template name="makeCMMIPAddress">
                <xsl:with-param name="rackNumber" select="number(@rackNumber)"/>
                <xsl:with-param name="boxNumber" select="number(@boxNumber)"/>
                <xsl:with-param name="cmmNumber" select="number(@moduleNumber)"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="javaeg:encodeIpAddress(string($cmmIPAddress))"/>
    </xsl:template>

    <xsl:template match="mv:HardPartitionRef | mv:SubPartitionRef">
        <xsl:variable name="pmuIPAddress">
            <xsl:call-template name="makePMUIPAddress"/>
        </xsl:variable>
        <xsl:value-of select="javaeg:encodeIpAddress(string($pmuIPAddress))"/>
    </xsl:template>

    <xsl:template match="mv:MarvelRef | mv:MarvelFirmwareVersionRef | mv:MarvelFirmwareModuleRef">
        <xsl:variable name="pmuIPAddress">
            <xsl:call-template name="makePMUIPAddress"/>
        </xsl:variable>
        <xsl:value-of select="javaeg:encodeIpAddress(string($pmuIPAddress))"/>
    </xsl:template>

    <!-- ******************** responses *********************** -->

    <xsl:template match="PowerOnPartitionResponse | PowerOffPartitionResponse | ResetPartitionResponse | StartPartitionResponse | HaltPartitionResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="PowerOnOffResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="TestLedsResponse | SetAttentionIndicatorResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="CreatePartitionResponse | DestroyPartitionResponse | SetPartitionAttributesResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="MoveEV7sResponse | RemoveEV7sResponse | AssignMemoryResponse | AssignIOPortResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="ReconfigureCablingResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="SavePartitionDatabaseResponse | SavePartitionAssignmentsResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="SetOCPDisplayDataResponse | SetFanSpeedResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="SetVoltsResponse | SetFrequencyResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="CableAssistResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UpgradeFirmwareResponse | LoadTestFirmwareResponse | DisableTestFirmwareResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="GetCDLResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->
    <xsl:key name="racks" match="GetSystemTopologyResponse/Entity[ParentIPAddress='00000000' or number(ComponentType)=5]/Rack" use="."/>

    <xsl:template match="GetSystemTopologyAllResponse">

        <xsl:variable name="marvelId" select="document($logicalXml)/*/smll:Input/smll:Destination/mv:MarvelRef/@marvelId"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="Racks" namespace="{$mv-uri}">
                    <xsl:variable name="root" select="GetSystemTopologyResponse/Entity[ParentIPAddress='00000000' or number(ComponentType)=5]"/>
                    <xsl:variable name="system" select="string(@system)"/>
                    <xsl:for-each select="$root/Rack[not(key('racks', .)[2]) or not((.|key('racks', .)[1])[2])]">
                        <xsl:sort order="ascending" select="." data-type="number"/>
                        <xsl:call-template name="makeRack">
                            <xsl:with-param name="root" select="$root"/>
                            <xsl:with-param name="system" select="$system"/>
                            <xsl:with-param name="marvelId" select="$marvelId"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template name="makeRack">
        <xsl:param name="root"/>
        <xsl:param name="system"/>
        <xsl:param name="marvelId"/>

        <xsl:element name="Rack" namespace="{$mv-uri}">
            <xsl:variable name="rack" select="number(.)"/>
            <xsl:attribute name="number" namespace="">
                <xsl:value-of select="$rack"/>
            </xsl:attribute>
            <xsl:for-each select="$root[number(Rack)=$rack]">
                <xsl:sort order="ascending" select="Box" data-type="number"/>
                <xsl:if test="number(ComponentType)!=5 or $root[number(ComponentType)=5 and number(Rack)=$rack and number(Box)=number(current()/Box)][1]=current()">
                    <xsl:call-template name="makeBox">
                        <xsl:with-param name="system" select="$system"/>
                        <xsl:with-param name="marvelId" select="$marvelId"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:for-each>
        </xsl:element>
    </xsl:template>

    <xsl:template name="makeBox">
        <xsl:param name="system"/>
        <xsl:param name="marvelId"/>

        <xsl:choose>
            <xsl:when test="number(ComponentType)=3">
                <xsl:variable name="componentName">
                    <xsl:choose>
                        <xsl:when test="$system='2P'">
                            <xsl:value-of select="string('ComboBox')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="string('SystemBox')"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>

                <xsl:element name="{$componentName}" namespace="{$mv-uri}">
                    <xsl:attribute name="number" namespace="">
                        <xsl:value-of select="number(Box)"/>
                    </xsl:attribute>
                    <xsl:attribute name="mbmAddress" namespace="">
                        <xsl:value-of select="javaeg:decodeHexIpAddress(string(IPAddress))"/>
                    </xsl:attribute>
                    <xsl:for-each select="../../GetSystemTopologyResponse/Entity[number(ComponentType)=2 and string(ParentIPAddress)=string(current()/IPAddress)]">
                        <xsl:element name="DualCPUModule" namespace="{$mv-uri}">
                            <xsl:attribute name="number" namespace="">
                                <xsl:value-of select="number(Instance)"/>
                            </xsl:attribute>
                            <xsl:attribute name="cmmAddress" namespace="">
                                <xsl:value-of select="javaeg:decodeHexIpAddress(string(IPAddress))"/>
                            </xsl:attribute>
                            <xsl:for-each select="../../GetSystemTopologyResponse/Entity[number(ComponentType)=1 and string(ParentIPAddress)=string(current()/IPAddress)]">
                                <xsl:element name="CPU" namespace="{$mv-uri}">
                                    <xsl:attribute name="number" namespace="">
                                        <xsl:value-of select="number(Instance) mod 2"/>
                                    </xsl:attribute>
                                </xsl:element>
                            </xsl:for-each>
                        </xsl:element>
                    </xsl:for-each>

                    <xsl:for-each select="../../GetSystemTopologyResponse/Entity[number(ComponentType)=5 and string(ParentIPAddress)=string(current()/IPAddress)]">
                        <xsl:element name="PowerInterfaceRef" namespace="{$mv-uri}">
                            <xsl:attribute name="marvelId" namespace="">
                                <xsl:value-of select="$marvelId"/>
                            </xsl:attribute>
                            <xsl:attribute name="rackNumber" namespace="">
                                <xsl:value-of select="number(Rack)"/>
                            </xsl:attribute>
                            <xsl:attribute name="boxNumber" namespace="">
                                <xsl:value-of select="number(Box)"/>
                            </xsl:attribute>
                            <xsl:attribute name="powerInterfaceNumber" namespace="">
                                <xsl:value-of select="number(Instance)"/>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:for-each>
                </xsl:element>
            </xsl:when>
            <xsl:when test="number(ComponentType)=4">
                <xsl:element name="IOBox" namespace="{$mv-uri}">
                    <xsl:attribute name="number" namespace="">
                        <xsl:value-of select="number(Box)"/>
                    </xsl:attribute>
                    <xsl:attribute name="pbmAddress" namespace="">
                        <xsl:value-of select="javaeg:decodeHexIpAddress(string(IPAddress))"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:when>
            <xsl:when test="number(ComponentType)=5">
                <xsl:element name="PowerSupplySubRack" namespace="{$mv-uri}">
                    <xsl:attribute name="number" namespace="">
                        <xsl:value-of select="number(Box)"/>
                    </xsl:attribute>

                    <xsl:for-each select="../../GetSystemTopologyResponse/Entity[number(ComponentType)=5 and number(Rack)=number(current()/Rack) and number(Box)=number(current()/Box)]">
                        <xsl:element name="PowerInterface" namespace="{$mv-uri}">
                            <xsl:attribute name="number" namespace="">
                                <xsl:value-of select="number(Instance)"/>
                            </xsl:attribute>
                            <xsl:element name="ConnectedSystemBoxRef" namespace="{$mv-uri}">
                                <xsl:attribute name="marvelId" namespace="">
                                    <xsl:value-of select="$marvelId"/>
                                </xsl:attribute>
                                <xsl:variable name="connectedSystemBox" select="../../GetSystemTopologyResponse/Entity[number(ComponentType)=3 and string(IPAddress)=string(current()/ParentIPAddress)]"/>
                                <xsl:attribute name="rackNumber" namespace="">
                                    <xsl:value-of select="number($connectedSystemBox/Rack)"/>
                                </xsl:attribute>
                                <xsl:attribute name="boxNumber" namespace="">
                                    <xsl:value-of select="number($connectedSystemBox/Box)"/>
                                </xsl:attribute>
                            </xsl:element>
                        </xsl:element>
                    </xsl:for-each>
                </xsl:element>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetPBMConfigurationResponse">
        <xsl:variable name="ioBoxRefNode" select="document($logicalXml)/*/smll:Input/smll:Destination/mv:*"/>

        <xsl:variable name="bmStatusSet" select="document($definesXml)/Defs/DataType[@name='BMStatus']"/>
        <xsl:variable name="powerStateSet" select="document($definesXml)/Defs/DataType[@name='PowerState']"/>
        <xsl:variable name="backplaneTypeSet" select="document($definesXml)/Defs/DataType[@name='IOBoxBackplaneType']"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="IOBox" namespace="{$mv-uri}">
                    <xsl:attribute name="number" namespace="">
                        <xsl:value-of select="number($ioBoxRefNode/@boxNumber)"/>
                    </xsl:attribute>
                    <xsl:attribute name="pbmAddress" namespace="">
                        <xsl:call-template name="makePBMIPAddress">
                            <xsl:with-param name="rackNumber" select="number($ioBoxRefNode/@rackNumber)"/>
                            <xsl:with-param name="boxNumber" select="number($ioBoxRefNode/@boxNumber)"/>
                        </xsl:call-template>
                    </xsl:attribute>

                    <xsl:call-template name="makeAttribute">
                        <xsl:with-param name="name" select="string('poweredOn')"/>
                        <xsl:with-param name="value" select="string($powerStateSet/Define[number(@number)=number(current()/PowerState)]/@id)"/>
                    </xsl:call-template>

                    <xsl:call-template name="makeAttribute">
                        <xsl:with-param name="name" select="string('backplaneType')"/>
                        <xsl:with-param name="value" select="string($backplaneTypeSet/Define[number(@number)=number(current()/BackplaneType)]/@id)"/>
                    </xsl:call-template>

                    <xsl:variable name="pbmStatus" select="number(Status)"/>
                    <xsl:attribute name="pbmStatus" namespace="">
                        <xsl:value-of select="string($bmStatusSet/Define[number(@number)=number($pbmStatus) or number(@number)=255]/@id)"/>
                    </xsl:attribute>
                    <xsl:if test="$pbmStatus>0">
                        <xsl:attribute name="pbmPOSTCode" namespace="">
                            <xsl:value-of select="$pbmStatus"/>
                        </xsl:attribute>
                    </xsl:if>

                    <xsl:variable name="io7Risers" select="javaeg:hex2Int(string(IO7Risers))"/>

                    <xsl:if test="boolean(javaeg:andMask($io7Risers, '1'))">
                        <xsl:element name="IORiser" namespace="{$mv-uri}">
                            <xsl:attribute name="number" namespace="">
                                <xsl:value-of select="0"/>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                    <xsl:if test="boolean(javaeg:andMask($io7Risers, '2'))">
                        <xsl:element name="IORiser" namespace="{$mv-uri}">
                            <xsl:attribute name="number" namespace="">
                                <xsl:value-of select="1"/>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                    <xsl:if test="boolean(javaeg:andMask($io7Risers, '4'))">
                        <xsl:element name="IORiser" namespace="{$mv-uri}">
                            <xsl:attribute name="number" namespace="">
                                <xsl:value-of select="2"/>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                    <xsl:if test="boolean(javaeg:andMask($io7Risers, '8'))">
                        <xsl:element name="IORiser" namespace="{$mv-uri}">
                            <xsl:attribute name="number" namespace="">
                                <xsl:value-of select="3"/>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetMBMConfigurationResponse">
        <xsl:variable name="systemBoxRefNode" select="document($logicalXml)/*/smll:Input/smll:Destination/mv:*"/>

        <xsl:variable name="cmmStatusSet" select="document($definesXml)/Defs/DataType[@name='CMMStatus']"/>
        <xsl:variable name="ev7StatusSet" select="document($definesXml)/Defs/DataType[@name='EV7Status']"/>
        <xsl:variable name="bmStatusSet" select="document($definesXml)/Defs/DataType[@name='BMStatus']"/>
        <xsl:variable name="powerStateSet" select="document($definesXml)/Defs/DataType[@name='PowerState']"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="SystemBox" namespace="{$mv-uri}">
                    <xsl:attribute name="number" namespace="">
                        <xsl:value-of select="number($systemBoxRefNode/@boxNumber)"/>
                    </xsl:attribute>
                    <xsl:attribute name="mbmAddress" namespace="">
                        <xsl:call-template name="makeMBMIPAddress">
                            <xsl:with-param name="rackNumber" select="number($systemBoxRefNode/@rackNumber)"/>
                            <xsl:with-param name="boxNumber" select="number($systemBoxRefNode/@boxNumber)"/>
                        </xsl:call-template>
                    </xsl:attribute>

                    <xsl:variable name="backplaneTypeSet" select="document($definesXml)/Defs/DataType[@name='SystemBoxBackplaneType']"/>
                    <xsl:call-template name="makeAttribute">
                        <xsl:with-param name="name" select="string('backplaneType')"/>
                        <xsl:with-param name="value" select="string($backplaneTypeSet/Define[number(@number)=number(current()/BackplaneType)]/@id)"/>
                    </xsl:call-template>

                    <xsl:variable name="mbmStatus" select="number(Status)"/>

                    <xsl:attribute name="mbmStatus" namespace="">
                        <xsl:value-of select="string($bmStatusSet/Define[number(@number)=number($mbmStatus) or number(@number)=255]/@id)"/>
                    </xsl:attribute>
                    <xsl:if test="$mbmStatus>0">
                        <xsl:attribute name="mbmPOSTCode" namespace="">
                            <xsl:value-of select="$mbmStatus"/>
                        </xsl:attribute>
                    </xsl:if>

                    <xsl:call-template name="makeAttribute">
                        <xsl:with-param name="name" select="string('poweredOn')"/>
                        <xsl:with-param name="value" select="string($powerStateSet/Define[number(@number)=number(current()/PowerState)]/@id)"/>
                    </xsl:call-template>

                    <xsl:for-each select="CMM">
                        <xsl:variable name="cmmStatus" select="number(Status)"/>
                        <xsl:variable name="cmmStatusNode" select="$cmmStatusSet/Define[number(@number)=number($cmmStatus) or number(@number)=255]"/>
                        <xsl:if test="number($cmmStatus)!=-1">
                            <xsl:choose>
                                <xsl:when test="string($cmmStatusNode/@name)='filler'">
                                    <xsl:element name="DualCPUModuleFiller" namespace="{$mv-uri}">
                                        <xsl:attribute name="number" namespace="">
                                            <xsl:value-of select="position()-1"/>
                                        </xsl:attribute>
                                    </xsl:element>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:element name="DualCPUModule" namespace="{$mv-uri}">
                                        <xsl:attribute name="number" namespace="">
                                            <xsl:value-of select="position()-1"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="cmmStatus" namespace="">
                                            <xsl:value-of select="string($cmmStatusNode/@id)"/>
                                        </xsl:attribute>
                                        <xsl:if test="$cmmStatus>0">
                                            <xsl:attribute name="cmmPOSTCode" namespace="">
                                                <xsl:value-of select="number($cmmStatus)"/>
                                            </xsl:attribute>
                                        </xsl:if>
                                        <xsl:attribute name="cmmAddress" namespace="">
                                            <xsl:call-template name="makeCMMIPAddress">
                                                <xsl:with-param name="rackNumber" select="number($systemBoxRefNode/@rackNumber)"/>
                                                <xsl:with-param name="boxNumber" select="number($systemBoxRefNode/@boxNumber)"/>
                                                <xsl:with-param name="cmmNumber" select="position()-1"/>
                                            </xsl:call-template>
                                        </xsl:attribute>

                                        <xsl:variable name="powerState" select="number(PowerState)"/>

                                        <xsl:call-template name="makeAttribute">
                                            <xsl:with-param name="name" select="string('poweredOn')"/>
                                            <xsl:with-param name="value" select="string($powerStateSet/Define[number(@number)=number($powerState)]/@id)"/>
                                        </xsl:call-template>

                                        <xsl:for-each select="EV7">
                                            <xsl:element name="CPU" namespace="{$mv-uri}">
                                                <xsl:attribute name="number" namespace="">
                                                    <xsl:value-of select="position()-1"/>
                                                </xsl:attribute>

                                                <xsl:variable name="ev7Status" select="number(Status)"/>

                                                <xsl:call-template name="makeAttribute">
                                                    <xsl:with-param name="name" select="string('status')"/>
                                                    <xsl:with-param name="value" select="string($ev7StatusSet/Define[number(@number)=number($ev7Status)]/@id)"/>
                                                </xsl:call-template>

                                                <xsl:variable name="additionalStatus" select="javaeg:hex2Int(string(AdditionalStatus))"/>

                                                <xsl:attribute name="zbox0Failed" namespace="">
                                                    <xsl:value-of select="boolean(javaeg:andMask($additionalStatus, '1'))"/>
                                                </xsl:attribute>
                                                <xsl:attribute name="zbox1Failed" namespace="">
                                                    <xsl:value-of select="boolean(javaeg:andMask($additionalStatus, '2'))"/>
                                                </xsl:attribute>
                                                <xsl:attribute name="ioPortFailed" namespace="">
                                                    <xsl:value-of select="boolean(javaeg:andMask($additionalStatus, '4'))"/>
                                                </xsl:attribute>

                                                <xsl:for-each select="Memory/RIMM">
                                                    <xsl:if test="number(.)>0">
                                                        <xsl:element name="MemoryModule" namespace="{$mv-uri}">
                                                            <xsl:attribute name="number" namespace="">
                                                                <xsl:value-of select="position()-1"/>
                                                            </xsl:attribute>
                                                            <xsl:attribute name="capacity" namespace="">
                                                                <xsl:value-of select="number(.)"/>
                                                            </xsl:attribute>
                                                            <xsl:attribute name="failed" namespace="">
                                                                <xsl:value-of select="boolean(javaeg:checkBit($additionalStatus, position()+3))"/>
                                                            </xsl:attribute>
                                                        </xsl:element>
                                                    </xsl:if>
                                                </xsl:for-each>
                                            </xsl:element>
                                        </xsl:for-each>
                                    </xsl:element>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="GetPartitionDatabaseResponse">
        <xsl:variable name="spTypeNode" select="document($definesXml)/Defs/DataType[@name='SubPartitionType']"/>
        <xsl:variable name="spStateNode" select="document($definesXml)/Defs/DataType[@name='SubPartitionState']"/>
        <xsl:variable name="hpStateNode" select="document($definesXml)/Defs/DataType[@name='HardPartitionState']"/>
        <xsl:variable name="stTypeNode" select="document($definesXml)/Defs/DataType[@name='Striping']"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="LogicalCPUs" namespace="{$mv-uri}">
                    <xsl:apply-templates select="EV7s/Description"/>
                    <xsl:apply-templates select="IO7s/Description"/>
                </xsl:element>
                <xsl:element name="Partitions" namespace="{$mv-uri}">
                    <xsl:apply-templates select="HardPartitions/Description">
                        <xsl:with-param name="spTypeNode" select="$spTypeNode"/>
                        <xsl:with-param name="spStateNode" select="$spStateNode"/>
                        <xsl:with-param name="hpStateNode" select="$hpStateNode"/>
                        <xsl:with-param name="stTypeNode" select="$stTypeNode"/>
                        <xsl:sort order="ascending" data-type="number" select="HardPartition"/>
                    </xsl:apply-templates>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="IO7s/Description">
        <xsl:variable name="y" select="number(EV7Coords/NS)"/>
        <xsl:variable name="x" select="number(EV7Coords/EW)"/>
        <xsl:variable name="ev7Node" select="../../EV7s/Description/EV7Coords[number(NS)=$y and number(EW)=$x]"/>

        <xsl:if test="not($ev7Node)">
            <xsl:element name="LogicalCPU" namespace="{$mv-uri}">
                <xsl:attribute name="x" namespace=""><xsl:value-of select="$x"/></xsl:attribute>
                <xsl:attribute name="y" namespace=""><xsl:value-of select="$y"/></xsl:attribute>
                <xsl:apply-templates select="PBMThumbwheel/Rack"/>
                <!--
                <xsl:apply-templates select="PartitionMembership/SubPartition">
                    <xsl:with-param name="mode" select="'IO'"/>
                </xsl:apply-templates>
                -->
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <xsl:template match="EV7s/Description">
        <xsl:element name="LogicalCPU" namespace="{$mv-uri}">
            <xsl:variable name="y" select="number(EV7Coords/NS)"/>
            <xsl:variable name="x" select="number(EV7Coords/EW)"/>

            <xsl:attribute name="x" namespace=""><xsl:value-of select="$x"/></xsl:attribute>
            <xsl:attribute name="y" namespace=""><xsl:value-of select="$y"/></xsl:attribute>

            <xsl:if test="number(Pid)!=255">
                <xsl:attribute name="processorID" namespace=""><xsl:value-of select="number(Pid)"/></xsl:attribute>
            </xsl:if>

            <xsl:if test="number(Type)=128">
                <xsl:attribute name="primary" namespace=""><xsl:value-of select="true()"/></xsl:attribute>
            </xsl:if>

            <xsl:variable name="io7Node" select="../../IO7s/Description/EV7Coords[number(NS)=$y and number(EW)=$x]/.."/>

            <xsl:if test="$io7Node">
                <xsl:apply-templates select="$io7Node/PBMThumbwheel/Rack"/>
                <xsl:apply-templates select="PartitionMembership/SubPartition">
                    <xsl:with-param name="mode" select="'IO'"/>
                    <xsl:with-param name="ioPortSubPartition" select="number(IOPortSub)"/>
                </xsl:apply-templates>
            </xsl:if>
            <xsl:apply-templates select="PartitionMembership/SubPartition"/>

        </xsl:element>
    </xsl:template>

    <xsl:template match="HardPartitions/Description">
        <xsl:param name="spTypeNode"/>
        <xsl:param name="spStateNode"/>
        <xsl:param name="hpStateNode"/>
        <xsl:param name="stTypeNode"/>

        <xsl:element name="HardPartition" namespace="{$mv-uri}">
            <xsl:attribute name="number" namespace=""><xsl:value-of select="number(HardPartition)"/></xsl:attribute>
            <xsl:attribute name="name" namespace=""><xsl:value-of select="PartitionName"/></xsl:attribute>

            <xsl:variable name="hardPStateValue" select="javaeg:andMask(javaeg:hex2Int(string(PartitionState)), '01')"/>

            <xsl:call-template name="makeAttribute">
                <xsl:with-param name="name" select="string('state')"/>
                <xsl:with-param name="value" select="string($hpStateNode/Define[number(@number)=$hardPStateValue]/@id)"/>
            </xsl:call-template>

            <xsl:attribute name="maximumCPUs" namespace=""><xsl:value-of select="number(Attributes/EV7Allowed)"/></xsl:attribute>

            <xsl:call-template name="makeAttribute">
                <xsl:with-param name="name" select="string('subPartitionType')"/>
                <xsl:with-param name="value" select="string($spTypeNode/Define[number(@number)=number(current()/Attributes/SubPartitionsType)]/@id)"/>
            </xsl:call-template>

            <xsl:call-template name="makeAttribute">
                <xsl:with-param name="name" select="string('striping')"/>
                <xsl:with-param name="value" select="string($stTypeNode/Define[number(@number)=number(current()/Attributes/Modifiers)]/@id)"/>
            </xsl:call-template>

            <xsl:variable name="memories" select="../../Memories"/>
            <xsl:variable name="hardPartition" select="number(HardPartition)"/>

            <!-- calculate CommunitySize in MB number(AssignmentType)=1 -->

            <xsl:call-template name="makeMemoryAttribute">
                <xsl:with-param name="name" select="string('communitySize')"/>
                <xsl:with-param name="value" select="$memories/Description[number(HardPartition)=number($hardPartition) and number(AssignmentType)=1]/MemorySize"/>
            </xsl:call-template>

            <xsl:for-each select="../../SubPartitions/Description[number(HardPartition)=number($hardPartition) and number(SubPartition)!=255]">
                <xsl:sort order="ascending" data-type="number" select="SubPartition"/>
                <xsl:element name="SubPartition" namespace="{$mv-uri}">
                    <xsl:attribute name="number" namespace=""><xsl:value-of select="number(SubPartition)"/></xsl:attribute>
                    <xsl:attribute name="name" namespace=""><xsl:value-of select="PartitionName"/></xsl:attribute>

                    <xsl:variable name="subPStateValue" select="javaeg:andMask(javaeg:hex2Int(string(PartitionState)), '07')"/>

                    <xsl:call-template name="makeAttribute">
                        <xsl:with-param name="name" select="string('state')"/>
                        <xsl:with-param name="value" select="string($spStateNode/Define[number(@number)=$subPStateValue]/@id)"/>
                    </xsl:call-template>

                    <xsl:attribute name="telnetPort" namespace=""><xsl:value-of select="number(TelnetPort)"/></xsl:attribute>
                    <xsl:attribute name="deltaTime" namespace=""><xsl:value-of select="DeltaTime"/></xsl:attribute>

                    <!-- calculate memorySize in MB number(AssignmentType)=0 -->
                    <xsl:call-template name="makeMemoryAttribute">
                        <xsl:with-param name="name" select="string('memorySize')"/>
                        <xsl:with-param name="value" select="$memories/Description[number(HardPartition)=number($hardPartition) and number(AssignmentType)=0 and number(AssignmentNumber)=number(current()/SubPartition)]/MemorySize"/>
                    </xsl:call-template>
                </xsl:element>
            </xsl:for-each>
        </xsl:element>
    </xsl:template>

    <xsl:template match="PBMThumbwheel/Rack">
        <xsl:element name="ConnectedIORiserRef" namespace="{$mv-uri}">
            <xsl:call-template name="makeMarvelId"/>
            <xsl:attribute name="rackNumber" namespace=""><xsl:value-of select="number(.)"/></xsl:attribute>
            <xsl:attribute name="boxNumber" namespace=""><xsl:value-of select="number(../Box)"/></xsl:attribute>
            <xsl:attribute name="ioRiserNumber" namespace=""><xsl:value-of select="number(../../IO7RiserLocation)"/></xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="PartitionMembership/SubPartition">
        <xsl:param name="mode"/>
        <xsl:param name="ioPortSubPartition" select="256"/>

        <xsl:if test="number(../HardPartition)!=255">
            <xsl:choose>
                <xsl:when test="($ioPortSubPartition=256 and number(.)=255) or $ioPortSubPartition=255">
                    <xsl:element name="{concat('HardPartition', $mode, 'Ref')}" namespace="{$mv-uri}">
                        <xsl:call-template name="makeMarvelId"/>
                        <xsl:attribute name="hardPartitionNumber" namespace=""><xsl:value-of select="number(../HardPartition)"/></xsl:attribute>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="{concat('SubPartition', $mode, 'Ref')}" namespace="{$mv-uri}">
                        <xsl:call-template name="makeMarvelId"/>
                        <xsl:attribute name="hardPartitionNumber" namespace=""><xsl:value-of select="number(../HardPartition)"/></xsl:attribute>
                        <xsl:attribute name="subPartitionNumber" namespace="">
                            <xsl:choose>
                                <xsl:when test="$ioPortSubPartition=256">
                                    <xsl:value-of select="number(.)"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$ioPortSubPartition"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="GetCablingConfigurationResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="IPCables" namespace="{$mv-uri}">
                    <xsl:apply-templates select="MBM/Description"/>
                </xsl:element>
                <xsl:element name="IOCables" namespace="{$mv-uri}">
                    <xsl:apply-templates select="PBM/Description"/>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="MBM/Description">
        <xsl:param name="cableStatusSet"/>
        <xsl:apply-templates select="Cables/Description" mode="IP">
            <xsl:with-param name="rack" select="number(Rack)"/>
            <xsl:with-param name="box" select="number(Box)"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="PBM/Description">
        <xsl:param name="cableStatusSet"/>
        <xsl:apply-templates select="Cables/Description" mode="IO">
            <xsl:with-param name="rack" select="number(Rack)"/>
            <xsl:with-param name="box" select="number(Box)"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="Cables/Description" mode="IP">
        <xsl:param name="rack"/>
        <xsl:param name="box"/>

        <xsl:variable name="cableStatusSet" select="document($definesXml)/Defs/DataType[@name='CableStatus']"/>
        <xsl:variable name="portDirectionSet" select="document($definesXml)/Defs/DataType[@name='PortDirection']"/>
        <xsl:variable name="cableStatus" select="number(Status)"/>

        <xsl:element name="IPCable" namespace="{$mv-uri}">

            <xsl:call-template name="makeAttribute">
                <xsl:with-param name="name" select="string('status')"/>
                <xsl:with-param name="value" select="string($cableStatusSet/Define[number(@number)=$cableStatus]/@id)"/>
            </xsl:call-template>

            <xsl:variable name="portDirection" select="number(position()-1)"/>
            <xsl:call-template name="makeAttribute">
                <xsl:with-param name="name" select="string('firstPortDirection')"/>
                <xsl:with-param name="value" select="string($portDirectionSet/Define[number(@number)=$portDirection]/@id)"/>
            </xsl:call-template>

            <!-- 1 - connected -->
            <xsl:if test="$cableStatus=1">
                <xsl:variable name="portDirection2" select="javaeg:andMask(number(PortDirection), '7F')"/>
                <xsl:call-template name="makeAttribute">
                    <xsl:with-param name="name" select="string('secondPortDirection')"/>
                    <xsl:with-param name="value" select="string($portDirectionSet/Define[number(@number)=$portDirection2]/@id)"/>
                </xsl:call-template>
            </xsl:if>

            <xsl:element name="FirstEndRef" namespace="{$mv-uri}">
                <xsl:call-template name="makeMarvelId"/>
                <xsl:attribute name="rackNumber" namespace="">
                    <xsl:value-of select="$rack"/>
                </xsl:attribute>
                <xsl:attribute name="boxNumber" namespace="">
                    <xsl:value-of select="$box"/>
                </xsl:attribute>
            </xsl:element>

            <!-- 1 - connected -->
            <xsl:if test="$cableStatus=1">
                <xsl:element name="SecondEndRef" namespace="{$mv-uri}">
                    <xsl:call-template name="makeMarvelId"/>
                    <xsl:attribute name="rackNumber" namespace="">
                        <xsl:value-of select="number(Rack)"/>
                    </xsl:attribute>
                    <xsl:attribute name="boxNumber" namespace="">
                        <xsl:value-of select="number(Box)"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:if>

        </xsl:element>
    </xsl:template>

    <xsl:template match="Cables/Description" mode="IO">
        <xsl:param name="rack"/>
        <xsl:param name="box"/>

        <xsl:variable name="cableStatusSet" select="document($definesXml)/Defs/DataType[@name='CableStatus']"/>
        <xsl:variable name="cableStatus" select="number(Status)"/>
        <xsl:if test="number(Status)=1">
            <xsl:element name="IOCable" namespace="{$mv-uri}">

                <xsl:call-template name="makeAttribute">
                    <xsl:with-param name="name" select="string('status')"/>
                    <xsl:with-param name="value" select="string($cableStatusSet/Define[number(@number)=$cableStatus]/@id)"/>
                </xsl:call-template>
                <xsl:element name="IORiserEndRef" namespace="{$mv-uri}">
                    <xsl:call-template name="makeMarvelId"/>
                    <xsl:attribute name="rackNumber" namespace="">
                        <xsl:value-of select="$rack"/>
                    </xsl:attribute>
                    <xsl:attribute name="boxNumber" namespace="">
                        <xsl:value-of select="$box"/>
                    </xsl:attribute>
                    <xsl:attribute name="ioRiserNumber" namespace="">
                        <xsl:value-of select="position()-1"/>
                    </xsl:attribute>
                </xsl:element>
                <xsl:element name="CPUEndRef" namespace="{$mv-uri}">
                    <xsl:call-template name="makeMarvelId"/>
                    <xsl:attribute name="rackNumber" namespace="">
                        <xsl:value-of select="number(Rack)"/>
                    </xsl:attribute>
                    <xsl:attribute name="boxNumber" namespace="">
                        <xsl:value-of select="number(Box)"/>
                    </xsl:attribute>

                    <xsl:variable name="cpuNumber" select="number(EV7Reference)"/>
                    <xsl:attribute name="moduleNumber" namespace="">
                        <xsl:value-of select="($cpuNumber - ($cpuNumber mod 2)) div 2"/>
                    </xsl:attribute>
                    <xsl:attribute name="cpuNumber" namespace="">
                        <xsl:value-of select="$cpuNumber mod 2"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:element>
        </xsl:if>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="GetVoltageReadingsResponse">
        <xsl:variable name="refNodeName" select="name(document($logicalXml)/*/smll:Input/smll:Destination/*)"/>
        <xsl:variable name="voltageLocatorSet" select="document($definesXml)/Defs/DataType[@name='VoltageLocator' and @agent=$refNodeName]"/>
        <xsl:variable name="generalStatusSet" select="document($definesXml)/Defs/DataType[@name='GeneralStatus']"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:for-each select="Description">
                    <xsl:element name="Voltage" namespace="{$mv-uri}">
                        <xsl:call-template name="makeAttribute">
                            <xsl:with-param name="name" select="string('locator')"/>
                            <xsl:with-param name="value" select="string($voltageLocatorSet/Define[number(@number)=number(current()/Locator)]/@id)"/>
                        </xsl:call-template>

                        <xsl:variable name="status" select="number(Status)"/>
                        <xsl:call-template name="makeAttribute">
                            <xsl:with-param name="name" select="string('status')"/>
                            <xsl:with-param name="value" select="string($generalStatusSet/Define[number(@number)=$status]/@id)"/>
                        </xsl:call-template>
                        <xsl:if test="$status >= 0">
                            <xsl:attribute name="actual" namespace="">
                                <xsl:value-of select="number(Reading) div 1000"/>
                            </xsl:attribute>
                            <xsl:attribute name="nominal" namespace="">
                                <xsl:value-of select="number(Nominal) div 1000"/>
                            </xsl:attribute>
                            <xsl:attribute name="highWarning" namespace="">
                                <xsl:value-of select="number(HighWarningLimit) div 1000"/>
                            </xsl:attribute>
                            <xsl:attribute name="lowWarning" namespace="">
                                <xsl:value-of select="number(LowWarningLimit) div 1000"/>
                            </xsl:attribute>
                            <xsl:attribute name="highFailure" namespace="">
                                <xsl:value-of select="number(HighFailureLimit) div 1000"/>
                            </xsl:attribute>
                            <xsl:attribute name="lowFailure" namespace="">
                                <xsl:value-of select="number(LowFailureLimit) div 1000"/>
                            </xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="GetTemperatureReadingsResponse">
        <xsl:variable name="refNodeName" select="name(document($logicalXml)/*/smll:Input/smll:Destination/*)"/>
        <xsl:variable name="temperatureLocatorSet" select="document($definesXml)/Defs/DataType[@name='TemperatureLocator' and @agent=$refNodeName]"/>
        <xsl:variable name="generalStatusSet" select="document($definesXml)/Defs/DataType[@name='GeneralStatus']"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:for-each select="Description">
                    <xsl:element name="Temperature" namespace="{$mv-uri}">
                        <xsl:call-template name="makeAttribute">
                            <xsl:with-param name="name" select="string('locator')"/>
                            <xsl:with-param name="value" select="string($temperatureLocatorSet/Define[number(@number)=number(current()/Locator)]/@id)"/>
                        </xsl:call-template>

                        <xsl:variable name="status" select="number(Status)"/>
                        <xsl:call-template name="makeAttribute">
                            <xsl:with-param name="name" select="string('status')"/>
                            <xsl:with-param name="value" select="string($generalStatusSet/Define[number(@number)=$status]/@id)"/>
                        </xsl:call-template>

                        <xsl:if test="$status >= 0">
                            <xsl:attribute name="actual" namespace="">
                                <xsl:value-of select="number(Reading) div 10"/>
                            </xsl:attribute>
                            <xsl:attribute name="highWarning" namespace="">
                                <xsl:value-of select="number(WarningLimit) div 10"/>
                            </xsl:attribute>
                            <xsl:attribute name="highFailure" namespace="">
                                <xsl:value-of select="number(FailureLimit) div 10"/>
                            </xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetFanRPMReadingsResponse">
        <xsl:variable name="refNodeName" select="name(document($logicalXml)/*/smll:Input/smll:Destination/*)"/>
        <xsl:variable name="fanLocatorSet" select="document($definesXml)/Defs/DataType[@name='FanLocator' and @agent=$refNodeName]"/>
        <xsl:variable name="generalStatusSet" select="document($definesXml)/Defs/DataType[@name='GeneralStatus']"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:for-each select="Description">
                    <xsl:element name="Fan" namespace="{$mv-uri}">
                        <xsl:call-template name="makeAttribute">
                            <xsl:with-param name="name" select="string('locator')"/>
                            <xsl:with-param name="value" select="string($fanLocatorSet/Define[number(@number)=number(current()/Locator)]/@id)"/>
                        </xsl:call-template>

                        <xsl:variable name="status" select="number(Status)"/>
                        <xsl:call-template name="makeAttribute">
                            <xsl:with-param name="name" select="string('status')"/>
                            <xsl:with-param name="value" select="string($generalStatusSet/Define[number(@number)=$status]/@id)"/>
                        </xsl:call-template>

                        <xsl:if test="$status >= 0">
                            <xsl:attribute name="actual" namespace="">
                                <xsl:value-of select="number(Reading)"/>
                            </xsl:attribute>
                            <xsl:attribute name="lowWarning" namespace="">
                                <xsl:value-of select="number(WarningLimit)"/>
                            </xsl:attribute>
                            <xsl:attribute name="lowFailure" namespace="">
                                <xsl:value-of select="number(FailureLimit)"/>
                            </xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetPCISlotInfoResponse">
        <xsl:variable name="ioRiserNumber" select="number(document($logicalXml)/*/smll:Input/smll:Destination/mv:IORiserRef/@ioRiserNumber)"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="IORiser" namespace="{$mv-uri}">
                    <xsl:attribute name="number" namespace="">
                        <xsl:value-of select="$ioRiserNumber"/>
                    </xsl:attribute>
                    <xsl:if test="number(PCISlots/SlotCount)>0">
                        <xsl:for-each select="PCISlots/Description">
                            <xsl:element name="PCISlot" namespace="{$mv-uri}">
                                <xsl:attribute name="number" namespace="">
                                    <xsl:value-of select="number(Slot)"/>
                                </xsl:attribute>
                                <xsl:element name="PCIConfigurationData" namespace="{$mv-uri}"><xsl:value-of select="string(ConfigurationData/Data)"/></xsl:element>
                            </xsl:element>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="GetIPConnectionsResponse">
        <xsl:variable name="enabledStatusSet" select="document($definesXml)/Defs/DataType[@name='ConnectionEnabledStatus']"/>
        <xsl:variable name="goodStatusSet" select="document($definesXml)/Defs/DataType[@name='ConnectionGoodStatus']"/>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="IPConnections" namespace="{$mv-uri}">
                    <xsl:if test="number(EV7Connections/EV7ConnectionCount)>0">
                        <xsl:for-each select="EV7Connections/Description">
                            <xsl:element name="IPConnection" namespace="{$mv-uri}">
                                <xsl:call-template name="makeAttribute">
                                    <xsl:with-param name="name" select="string('enabled')"/>
                                    <xsl:with-param name="value" select="string($enabledStatusSet/Define[number(@number)=number(current()/EnableStatus)]/@id)"/>
                                </xsl:call-template>
                                <xsl:call-template name="makeAttribute">
                                    <xsl:with-param name="name" select="string('cableTestOK')"/>
                                    <xsl:with-param name="value" select="string($goodStatusSet/Define[number(@number)=number(current()/GoodStatus)]/@id)"/>
                                </xsl:call-template>
                                <xsl:element name="FirstEndRef" namespace="{$mv-uri}">
                                    <xsl:call-template name="makeMarvelId"/>
                                    <xsl:call-template name="makeXY">
                                        <xsl:with-param name="id" select="string(ID1)"/>
                                    </xsl:call-template>
                                </xsl:element>
                                <xsl:element name="SecondEndRef" namespace="{$mv-uri}">
                                    <xsl:call-template name="makeMarvelId"/>
                                    <xsl:call-template name="makeXY">
                                        <xsl:with-param name="id" select="string(ID2)"/>
                                    </xsl:call-template>
                                </xsl:element>
                            </xsl:element>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template name="makeXY">
        <xsl:param name="id"/>
        <xsl:attribute name="x" namespace="">
            <xsl:value-of select="javaeg:hex2Int(substring($id,1,1))"/>
        </xsl:attribute>
        <xsl:attribute name="y" namespace="">
            <xsl:value-of select="javaeg:hex2Int(substring($id,2,1))"/>
        </xsl:attribute>
    </xsl:template>

    <!-- ******************************************************* -->
    <xsl:template match="GetAttentionIndicatorResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="AttentionIndicators" namespace="{$mv-uri}">
                    <xsl:variable name="leds" select="javaeg:hex2Int(string(LEDStatus))"/>
                    <xsl:attribute name="green" namespace="">
                        <xsl:value-of select="boolean(javaeg:andMask($leds, '1'))"/>
                    </xsl:attribute>
                    <xsl:attribute name="yellow" namespace="">
                        <xsl:value-of select="boolean(javaeg:andMask($leds, '2'))"/>
                    </xsl:attribute>
<!--
                    <xsl:attribute name="blue" namespace="">
                        <xsl:value-of select="boolean(javaeg:andMask($leds, '4'))"/>
                    </xsl:attribute>
-->
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetFirmwareVersionResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="FirmwareVersion" namespace="{$mv-uri}">
                    <xsl:attribute name="module" namespace="">
                        <xsl:value-of select="string(document($logicalXml)/*/smll:Input/smll:Destination/*/@module)"/>
                    </xsl:attribute>
                    <xsl:attribute name="state" namespace="">
                        <xsl:value-of select="string(document($logicalXml)/*/smll:Input/smll:Destination/*/@state)"/>
                    </xsl:attribute>
                    <xsl:attribute name="imageRevision" namespace="">
                        <xsl:value-of select="string(ImageRevision)"/>
                    </xsl:attribute>
                    <xsl:attribute name="majorProtocolRevision" namespace="">
                        <xsl:value-of select="string(MajorRevision)"/>
                    </xsl:attribute>
                    <xsl:attribute name="minorProtocolRevision" namespace="">
                        <xsl:value-of select="string(MinorRevision)"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->
    <xsl:key name="psRacks" match="PowerSupplies/Description/Rack" use="."/>
    <xsl:key name="psBoxs" match="Description/Box" use="."/>

    <xsl:template match="GetStateOfPowerSuppliesResponse | GetPSTrayResponse">
        <xsl:variable name="generalStatusSet" select="document($definesXml)/Defs/DataType[@name='GeneralStatus']"/>
        <xsl:variable name="powerSupplyTypeSet" select="document($definesXml)/Defs/DataType[@name='PowerSupplySubRackType']"/>

        <xsl:variable name="systemPSRefNode" select="document($logicalXml)/smll:*/smll:Input/smll:Destination/mv:SystemBoxRef"/>

        <xsl:variable name="isPSTrayResponse" select="boolean(name(.)='GetPSTrayResponse')"/>

        <xsl:variable name="elementName">
            <xsl:choose>
                <xsl:when test="$isPSTrayResponse">
                    <xsl:value-of select="string('PowerInterface')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="string('PowerSupply')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:choose>
                    <xsl:when test="$systemPSRefNode">
                         <xsl:for-each select="PowerSupplies/Description/Rack[not(key('psRacks', .)[2]) or not((.|key('psRacks', .)[1])[2])]">
                            <xsl:sort order="ascending" select="." data-type="number"/>
                                <xsl:element name="Rack" namespace="{$mv-uri}">
                                    <xsl:variable name="rack" select="number(../Rack)"/>
                                    <xsl:attribute name="number" namespace="">
                                        <xsl:value-of select="$rack"/>
                                    </xsl:attribute>
                                    <xsl:for-each select="../../Description/Box[not(key('psBoxs', .)[2]) or not((.|key('psBoxs', .)[1])[2])]">
                                        <xsl:sort order="ascending" select="." data-type="number"/>
                                        <xsl:if test="number(../Rack)=$rack">
                                            <xsl:element name="PowerSupplySubRack" namespace="{$mv-uri}">
                                                <xsl:variable name="box" select="number(../Box)"/>
                                                <xsl:variable name="psType" select="number(../Type)"/>

                                                <xsl:attribute name="number" namespace="">
                                                    <xsl:value-of select="$box"/>
                                                </xsl:attribute>
                                                <xsl:attribute name="type" namespace="">
                                                    <xsl:value-of select="$powerSupplyTypeSet/Define[number(@number)=number($psType)]/@id"/>
                                                </xsl:attribute>

                                                <xsl:apply-templates select="../../../PowerSupplies/Description[number(Rack)=$rack and number(Box)=$box]">
                                                    <xsl:with-param name="ps" select="$elementName"/>
                                                    <xsl:with-param name="generalStatusSet" select="$generalStatusSet"/>
                                                    <xsl:with-param name="powerSupplyTypeSet" select="$powerSupplyTypeSet"/>
                                                    <xsl:with-param name="systemPSRefNode" select="$systemPSRefNode"/>
                                                </xsl:apply-templates>

                                            </xsl:element>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:element>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="PowerSupplies/Description">
                            <xsl:with-param name="ps" select="string('PowerSupply')"/>
                            <xsl:with-param name="generalStatusSet" select="$generalStatusSet"/>
                            <xsl:with-param name="powerSupplyTypeSet" select="$powerSupplyTypeSet"/>
                        </xsl:apply-templates>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="@*" mode="pss">
        <xsl:copy>
            <xsl:apply-templates select="@*" mode="pss"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="PowerSupplies/Description">
        <xsl:param name="ps"/>
        <xsl:param name="generalStatusSet"/>
        <xsl:param name="powerSupplyTypeSet"/>
        <xsl:param name="systemPSRefNode"/>

        <xsl:if test="number(OverallStatus)!=-1">
            <xsl:element name="{$ps}" namespace="{$mv-uri}">
                <xsl:attribute name="number" namespace="">
                    <xsl:value-of select="number(Locator)"/>
                </xsl:attribute>
                <xsl:call-template name="makeAttribute">
                    <xsl:with-param name="name" select="string('overallStatus')"/>
                    <xsl:with-param name="value" select="string($generalStatusSet/Define[number(@number)=number(current()/OverallStatus)]/@id)"/>
                </xsl:call-template>

                <xsl:if test="$ps=string('PowerInterface')">
                    <xsl:element name="ConnectedSystemBoxRef" namespace="{$mv-uri}">
                        <xsl:apply-templates select="$systemPSRefNode/@*" mode="pss"/>
                    </xsl:element>
                </xsl:if>

                <xsl:if test="number(OverallStatus)>=0">
                    <xsl:variable name="psPrefix" select="$powerSupplyTypeSet/Define[number(@number)=number(current()/Type)]/@name"/>
                    <xsl:if test="$psPrefix">
                        <xsl:variable name="statusSet" select="document($definesXml)/Defs/DataType[@id=$psPrefix]"/>
                        <xsl:for-each select="current()/Status/*">
                            <xsl:if test="number(.)!=-2">
                                <xsl:element name="Status" namespace="{$mv-uri}">
                                    <xsl:call-template name="makeAttribute">
                                        <xsl:with-param name="name" select="string('locator')"/>
                                        <xsl:with-param name="value" select="string($statusSet/Define[@name=name(current())]/@id)"/>
                                    </xsl:call-template>
                                    <xsl:call-template name="makeAttribute">
                                        <xsl:with-param name="name" select="string('status')"/>
                                        <xsl:with-param name="value" select="string($generalStatusSet/Define[number(@number)=number(current())]/@id)"/>
                                    </xsl:call-template>
                                </xsl:element>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:if>
            </xsl:element>
        </xsl:if>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="GetSwitchStateResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="Switch" namespace="{$mv-uri}">
                    <xsl:call-template name="makeAttribute">
                        <xsl:with-param name="name" select="string('reading')"/>
                        <xsl:with-param name="value" select="document($definesXml)/Defs/DataType[@name='SwitchReading']/Define[number(@number)=number(current()/SwitchReading)]/@id"/>
                    </xsl:call-template>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetFrequencyResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="Frequency" namespace="{$mv-uri}">
                    <xsl:attribute name="cpuFrequency" namespace="">
                        <xsl:value-of select="number(Frequency)"/>
                    </xsl:attribute>
                    <xsl:attribute name="ipRatio" namespace="">
                        <xsl:value-of select="number(Ratio/IP) div 10"/>
                    </xsl:attribute>
                    <xsl:attribute name="ioRatio" namespace="">
                        <xsl:value-of select="number(Ratio/IO) div 10"/>
                    </xsl:attribute>
                    <xsl:attribute name="zBoxRatio" namespace="">
                        <xsl:value-of select="number(Ratio/Zbox) div 10"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetIntrusionResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="Intrusions" namespace="{$mv-uri}">
                    <xsl:variable name="refNodeName" select="name(document($logicalXml)/*/smll:Input/smll:Destination/*)"/>
                    <xsl:variable name="inrusionLocatorSet" select="document($definesXml)/Defs/DataType[@name='InrusionLocator' and @agent=$refNodeName]"/>
                    <xsl:variable name="inrusionStatusSet" select="document($definesXml)/Defs/DataType[@name='InrusionStatus']"/>
                    <xsl:for-each select="Description">
                        <xsl:element name="Intrusion" namespace="{$mv-uri}">
                            <xsl:call-template name="makeAttribute">
                                <xsl:with-param name="name" select="string('locator')"/>
                                <xsl:with-param name="value" select="string($inrusionLocatorSet/Define[number(@number)=number(current()/Locator)]/@id)"/>
                            </xsl:call-template>
                            <xsl:call-template name="makeAttribute">
                                <xsl:with-param name="name" select="string('status')"/>
                                <xsl:with-param name="value" select="string($inrusionStatusSet/Define[number(@number)=number(current()/Status)]/@id)"/>
                            </xsl:call-template>
                        </xsl:element>
                    </xsl:for-each>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>


    <!-- ******************************************************* -->

    <xsl:template match="GetErrorLogCountResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="Lowest" namespace="{$smll-uri}">
                    <xsl:attribute name="value" namespace="">
                        <xsl:value-of select="number(LowestEntryNumber)"/>
                    </xsl:attribute>
                </xsl:element>
                <xsl:element name="Highest" namespace="{$smll-uri}">
                    <xsl:attribute name="value" namespace="">
                        <xsl:value-of select="number(HighestEntryNumber)"/>
                    </xsl:attribute>
                </xsl:element>
                <xsl:element name="TimeStamp" namespace="{$smll-uri}">
                    <xsl:attribute name="value" namespace="">
                        <xsl:apply-templates select="TimeStamp" mode="errorlog"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetLogEntriesResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:variable name="logEntries" select="*"/>
                <xsl:variable name="lastEntry" select="$logEntries[count($logEntries)]"/>
                <xsl:element name="LogFragment" namespace="{$smll-uri}">
                    <xsl:choose>
                        <xsl:when test="$lastEntry">
                            <xsl:attribute name="lastEntryNumber" namespace="">
                                <xsl:value-of select="number($lastEntry/EntryHeader/EntryNumber)"/>
                            </xsl:attribute>
                            <xsl:attribute name="lastTimeStamp" namespace="">
                                <xsl:apply-templates select="$lastEntry/EntryHeader/TimeStamp" mode="errorlog"/>
                            </xsl:attribute>
                            <xsl:for-each select="$logEntries">
                                <xsl:call-template name="makeErrorLogEntry"/>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="not(@emptyLog)">
                                <xsl:if test="document($logicalXml)/smll:GetLogEntries/smll:Input/smll:LastEntryNumber">
                                    <xsl:attribute name="lastEntryNumber" namespace="">
                                        <xsl:value-of select="document($logicalXml)/smll:GetLogEntries/smll:Input/smll:LastEntryNumber/@value"/>
                                    </xsl:attribute>
                                </xsl:if>
                                <xsl:if test="document($logicalXml)/smll:GetLogEntries/smll:Input/smll:LastTimeStamp">
                                    <xsl:attribute name="lastTimeStamp" namespace="">
                                        <xsl:value-of select="document($logicalXml)/smll:GetLogEntries/smll:Input/smll:LastTimeStamp/@value"/>
                                    </xsl:attribute>
                                </xsl:if>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:element>
            <xsl:choose>
                <xsl:when test="@lostEntries">
                    <xsl:call-template name="makeResult">
                        <xsl:with-param name="value" select="10"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="makeResult"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetErrorLogEntryTextResponse | GetErrorLogEntryBinaryResponse | GetErrorLogEntryDiagResponse | GetErrorLogEntryLogoutResponse | GetErrorLogEntrySystemEventResponse | ResponseErrorLogEntryHeader">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:call-template name="makeErrorLogEntry"/>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template name="makeErrorLogEntry">
        <xsl:element name="LogEntry" namespace="{$mv-uri}">
            <xsl:attribute name="timeStamp" namespace="">
                <xsl:apply-templates select="EntryHeader/TimeStamp" mode="errorlog"/>
            </xsl:attribute>
            <xsl:attribute name="entryNumber" namespace="">
                <xsl:value-of select="number(EntryHeader/EntryNumber)"/>
            </xsl:attribute>

            <xsl:choose>
                <xsl:when test="number(EntryHeader/EntryFormat)=1">
                    <xsl:element name="TextReport" namespace="{$mv-uri}">
                        <xsl:attribute name="text" namespace="">
                            <xsl:value-of select="string(Entry/Text)"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="number(EntryHeader/EntryFormat)=2">
                    <xsl:element name="BinaryReport" namespace="{$mv-uri}">
                        <xsl:attribute name="tag" namespace="">
                            <xsl:value-of select="string(Entry/Tag)"/>
                        </xsl:attribute>
                        <xsl:attribute name="binary" namespace="">
                            <xsl:value-of select="string(Entry/Binary)"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="number(EntryHeader/EntryFormat)=3">
                    <xsl:element name="DiagReport" namespace="{$mv-uri}">
                        <xsl:attribute name="instance" namespace="">
                            <xsl:value-of select="number(Entry/Instance)"/>
                        </xsl:attribute>
                        <xsl:attribute name="text" namespace="">
                            <xsl:value-of select="string('Diagnostic Error: cabinet ')"/>
                            <xsl:value-of select="number(Entry/Rack)"/>
                            <xsl:value-of select="string(', drawer ')"/>
                            <xsl:value-of select="number(Entry/Box)"/>
                            <xsl:value-of select="string(', instance ')"/>
                            <xsl:value-of select="number(Entry/Instance)"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="number(EntryHeader/EntryFormat)=4">
                    <xsl:element name="EV7LogOutReport" namespace="{$mv-uri}">
                        <xsl:attribute name="instance" namespace="">
                            <xsl:value-of select="number(Entry/Instance)"/>
                        </xsl:attribute>
                        <xsl:attribute name="text" namespace="">
                            <xsl:value-of select="string('EV7 PAL Error: cabinet ')"/>
                            <xsl:value-of select="number(Entry/Rack)"/>
                            <xsl:value-of select="string(', drawer ')"/>
                            <xsl:value-of select="number(Entry/Box)"/>
                            <xsl:value-of select="string(', instance ')"/>
                            <xsl:value-of select="number(Entry/Instance)"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="number(EntryHeader/EntryFormat)=5">
                    <xsl:element name="SysEventReport" namespace="{$mv-uri}">
                        <xsl:attribute name="text" namespace="">
                            <xsl:value-of select="string('SYS EVENT')"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="UnknownFormatReport" namespace="{$mv-uri}">
                        <xsl:attribute name="text" namespace="">
                            <xsl:value-of select="string('Unknown Entry Format: ')"/>
                            <xsl:value-of select="number(EntryHeader/EntryFormat)"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:variable name="dest" select="document($logicalXml)/*/smll:Input/smll:Destination/*"/>
            <xsl:element name="{name($dest)}" namespace="{$mv-uri}">
                <xsl:copy-of select="$dest/@*"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="TimeStamp" mode="errorlog">
            <xsl:value-of select="format-number(Year, '2000')"/>
            <xsl:value-of select="string('-')"/>
            <xsl:value-of select="format-number(Month, '00')"/>
            <xsl:value-of select="string('-')"/>
            <xsl:value-of select="format-number(Day, '00')"/>
            <xsl:value-of select="string('T')"/>
            <xsl:value-of select="format-number(Hours, '00')"/>
            <xsl:value-of select="string(':')"/>
            <xsl:value-of select="format-number(Minutes, '00')"/>
            <xsl:value-of select="string(':')"/>
            <xsl:value-of select="format-number(Seconds, '00')"/>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="GetPMUAgentAddressResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="Marvel" namespace="{$mv-uri}">
                    <xsl:call-template name="makeAttribute">
                        <xsl:with-param name="name" select="string('pmuAgentAddress')"/>
                        <xsl:with-param name="value" select="javaeg:decodeHexIpAddress(string(IPAddress))"/>
                    </xsl:call-template>
                    <xsl:call-template name="makeMarvelId"/>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <!-- ******************************************************* -->

    <xsl:template match="SubscribeResponse">
        <xsl:element name="Response" namespace="">
            <xsl:element name="Output" namespace="{$smll-uri}">
                <xsl:element name="SubscriptionId" namespace="{$smll-uri}">
                    <xsl:call-template name="makeAttribute">
                        <xsl:with-param name="name" select="string('value')"/>
                        <xsl:with-param name="value" select="SID"/>
                    </xsl:call-template>
                </xsl:element>
            </xsl:element>
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UnsubscribeResponse | RenewSubscriptionResponse">
        <xsl:element name="Response" namespace="">
            <xsl:call-template name="makeResult"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="Alert">
        <xsl:element name="Event" namespace="{$mv-uri}">
            <xsl:attribute name="uniqueTag" namespace="">
                <xsl:value-of select="@uniqueTag"/>
            </xsl:attribute>
            <xsl:attribute name="timeStamp" namespace="">
                <xsl:value-of select="@timeStamp"/>
            </xsl:attribute>
            <xsl:call-template name="makeAttribute">
                <xsl:with-param name="name" select="string('severity')"/>
                <xsl:with-param name="value" select="string(document($definesXml)/Defs/DataType[@name='Severity']/Define[number(@number)=number(current()/Entry/Severity)]/@id)"/>
            </xsl:call-template>
            <xsl:call-template name="makeAttribute">
                <xsl:with-param name="name" select="string('description')"/>
                <xsl:with-param name="value" select="string(Entry/Text/Data)"/>
            </xsl:call-template>

            <xsl:variable name="alert" select="document($alertsXml)/sma:Alerts/sma:Alert[@code=string(current()/Entry/ErrorCode)]"/>
            <xsl:variable name="qData" select="string(Entry/QData/Data)"/>

            <xsl:call-template name="makeAdditionalAttributes">
                <xsl:with-param name="element" select="$alert"/>
                <xsl:with-param name="data" select="$qData"/>
            </xsl:call-template>

            <xsl:call-template name="makeAttribute">
                <xsl:with-param name="name" select="string('type')"/>
                <xsl:with-param name="value" select="string($alert/@type)"/>
            </xsl:call-template>

            <xsl:variable name="microIP" select="string(Entry/MicroIP)"/>
            <!-- nn.mm.pp.ee from smlan spec 2.2 -->
            <xsl:variable name="ee" select="javaeg:hex2Int(substring($microIP, 1, 2))"/>
            <xsl:variable name="pp" select="javaeg:hex2Int(substring($microIP, 3, 2))"/>
            <xsl:variable name="mm" select="javaeg:hex2Int(substring($microIP, 5, 2))"/>

            <xsl:variable name="mmRack" select="javaeg:hex2Int(substring($microIP, 5, 1))"/>
            <xsl:variable name="mmBox" select="javaeg:hex2Int(substring($microIP, 6, 1))"/>

            <xsl:choose>
                <!-- PBM -->
                <xsl:when test="$mm=254">
                    <xsl:element name="IOBoxAgentRef" namespace="{$mv-uri}">
                        <xsl:call-template name="makeAgentRefAttr">
                            <xsl:with-param name="rackNumber" select="$ee"/>
                            <xsl:with-param name="boxNumber" select="$pp"/>
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <!-- MBM -->
                    <xsl:if test="$pp=0">
                        <xsl:element name="SystemBoxAgentRef" namespace="{$mv-uri}">
                            <xsl:call-template name="makeAgentRefAttr">
                                <xsl:with-param name="rackNumber" select="$mmRack"/>
                                <xsl:with-param name="boxNumber" select="$mmBox"/>
                            </xsl:call-template>
                        </xsl:element>
                    </xsl:if>
                    <!-- CMM -->
                    <xsl:if test="$pp>0 and $ee=0">
                        <xsl:variable name="ppp">
                            <xsl:choose>
                                <xsl:when test="$pp=1">
                                    <xsl:value-of select="0"/>
                                </xsl:when>
                                <xsl:when test="$pp=2">
                                    <xsl:value-of select="1"/>
                                </xsl:when>
                                <xsl:when test="$pp=3">
                                    <xsl:value-of select="2"/>
                                </xsl:when>
                                <xsl:when test="$pp=4">
                                    <xsl:value-of select="3"/>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:variable>
                        <xsl:element name="DualCPUModuleAgentRef" namespace="{$mv-uri}">
                            <xsl:call-template name="makeAgentRefAttr">
                                <xsl:with-param name="rackNumber" select="$mmRack"/>
                                <xsl:with-param name="boxNumber" select="$mmBox"/>
                                <xsl:with-param name="moduleNumber" select="$ppp"/>
                            </xsl:call-template>
                        </xsl:element>
                        </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
            <!--RelatedComponentRef creation-->
            <xsl:variable name="eventType" select="number(Entry/EventType)"/>
            <xsl:variable name="relatedComponentRef" select="$alert/sma:RelatedComponentRefConversion"/>

            <xsl:variable name="relatedComponentRefName">
                <xsl:choose>
                    <xsl:when test="$relatedComponentRef">
                        <xsl:value-of select="$relatedComponentRef/@name"/>
                    </xsl:when>
                    <xsl:when test="$eventType=1"> <!--CPURef-->
                        <xsl:value-of select="'CPUComponentRef'"/>
                    </xsl:when>
                    <xsl:when test="$eventType=2"> <!--DualCPUModuleRef-->
                        <xsl:value-of select="'DualCPUModuleComponentRef'"/>
                    </xsl:when>
                    <xsl:when test="$eventType=3"> <!--SystemBoxRef-->
                        <xsl:value-of select="'SystemBoxComponentRef'"/>
                    </xsl:when>
                    <xsl:when test="$eventType=4"> <!--IOBoxRef-->
                        <xsl:value-of select="'IOBoxComponentRef'"/>
                    </xsl:when>
                    <xsl:when test="$eventType=5"> <!--PowerSupplyRef-->
                        <xsl:value-of select="'PowerSupplyComponentRef'"/>
                    </xsl:when>
                    <xsl:when test="$eventType=6"> <!--IORiserRef-->
                        <xsl:value-of select="'IORiserComponentRef'"/>
                    </xsl:when>
                    <xsl:when test="$eventType=12"> <!--MarvelRef-->
                        <xsl:value-of select="'MarvelComponentRef'"/>
                    </xsl:when>
                    <xsl:when test="$eventType=13"> <!--PowerInterfaceRef-->
                        <xsl:value-of select="'PowerInterfaceComponentRef'"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="''"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:if test="string-length($relatedComponentRefName)>0">
                <xsl:element name="{$relatedComponentRefName}" namespace="{$mv-uri}">
                    <xsl:attribute name="marvelId">
                        <xsl:value-of select="@marvelId"/>
                    </xsl:attribute>

                    <xsl:call-template name="makeAdditionalAttributes">
                        <xsl:with-param name="element" select="$relatedComponentRef"/>
                        <xsl:with-param name="data" select="$qData"/>
                    </xsl:call-template>

                    <xsl:if test="$eventType!=12"> <!--All except MarvelRef-->
                        <xsl:attribute name="rackNumber">
                            <xsl:value-of select="number(Entry/Cabinet)"/>
                        </xsl:attribute>
                        <xsl:attribute name="boxNumber">
                            <xsl:value-of select="number(Entry/Drawer)"/>
                        </xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="$eventType=1"> <!--CPURef-->
                                <xsl:attribute name="moduleNumber">
                                    <xsl:value-of select="(number(Entry/Instance) - (number(Entry/Instance) mod 2)) div 2"/>
                                </xsl:attribute>
                                <xsl:attribute name="cpuNumber">
                                    <xsl:value-of select="number(Entry/Instance) mod 2"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:when test="$eventType=2"> <!--DualCPUModuleRef-->
                                <xsl:attribute name="moduleNumber">
                                    <xsl:value-of select="number(Entry/Instance)"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:when test="$eventType=5"> <!--PowerSupplyRef-->
                                <xsl:attribute name="powerSupplyNumber">
                                    <xsl:value-of select="number(Entry/Instance)"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:when test="$eventType=6"> <!--IORiserRef-->
                                <xsl:attribute name="ioRiserNumber">
                                    <xsl:value-of select="number(Entry/Instance)"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:when test="$eventType=13"> <!--PowerInterfaceRef-->
                                <xsl:attribute name="powerInterfaceNumber">
                                    <xsl:value-of select="number(Entry/Instance)"/>
                                </xsl:attribute>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:if>
                </xsl:element>
            </xsl:if>
        </xsl:element>
    </xsl:template>

    <xsl:template name="makeAdditionalAttributes">
        <xsl:param name="element"/>
        <xsl:param name="data"/>
        <xsl:if test="$data">
            <xsl:for-each select="$element/sma:AdditionalAttribute">
                <xsl:variable name="value" select="javaeg:getSubStringByIndex($data, number(@qualifyingDataPosition))"/>
                <xsl:if test="$value">
                    <xsl:attribute name="{string(@name)}">
                        <xsl:value-of select="$value"/>
                    </xsl:attribute>
                </xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <xsl:template name="makeAgentRefAttr">
        <xsl:param name="rackNumber"/>
        <xsl:param name="boxNumber"/>
        <xsl:param name="moduleNumber"/>
        <xsl:attribute name="marvelId" namespace="">
            <xsl:value-of select="@marvelId"/>
        </xsl:attribute>
        <xsl:attribute name="rackNumber" namespace="">
            <xsl:value-of select="$rackNumber"/>
        </xsl:attribute>
        <xsl:attribute name="boxNumber" namespace="">
            <xsl:value-of select="$boxNumber"/>
        </xsl:attribute>
        <xsl:if test="$moduleNumber">
            <xsl:attribute name="moduleNumber" namespace="">
                <xsl:value-of select="$moduleNumber"/>
            </xsl:attribute>
        </xsl:if>
    </xsl:template>


    <!-- ******************** tools *********************** -->

    <xsl:template name="makeMBMIPAddress">
        <xsl:param name="rackNumber"/>
        <xsl:param name="boxNumber"/>
        <xsl:value-of select="concat('10.',$rackNumber*16+$boxNumber,'.0.1')"/>
    </xsl:template>

    <xsl:template name="makePBMIPAddress">
        <xsl:param name="rackNumber"/>
        <xsl:param name="boxNumber"/>
        <xsl:value-of select="concat('10.254.',$boxNumber,'.',$rackNumber)"/>
    </xsl:template>

    <xsl:template name="makeCMMIPAddress">
        <xsl:param name="rackNumber"/>
        <xsl:param name="boxNumber"/>
        <xsl:param name="cmmNumber"/>
        <xsl:value-of select="concat('10.',$rackNumber*16+$boxNumber,'.',$cmmNumber+1,'.0')"/>
    </xsl:template>

    <xsl:template name="makePMUIPAddress">
        <xsl:value-of select="string('10.253.0.1')"/>
    </xsl:template>

    <xsl:template name="makeMarvelId">
        <xsl:attribute name="marvelId" namespace="">
            <xsl:value-of select="document($logicalXml)/*/smll:Input/smll:Destination/*/@marvelId"/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template name="makeResult">
        <xsl:param name="value" select="0"/>
        <xsl:element name="Result" namespace="{$smll-uri}">
            <xsl:attribute name="error" namespace="">
                <xsl:value-of select="$value"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template name="makeAttribute">
        <xsl:param name="name"/>
        <xsl:param name="value"/>

        <xsl:if test="$value">
            <xsl:attribute name="{$name}" namespace="">
                <xsl:value-of select="$value"/>
            </xsl:attribute>
        </xsl:if>
    </xsl:template>

    <xsl:template name="makeMemoryAttribute">
        <xsl:param name="name"/>
        <xsl:param name="value"/>

        <xsl:choose>
            <xsl:when test="$value">
                <xsl:attribute name="{$name}" namespace="">
                    <xsl:value-of select="floor(number($value) div 1024 div 1024)"/>
                </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="{$name}" namespace="">
                    <xsl:value-of select="number(0)"/>
                </xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="makeMBMIPAddressEx">
        <xsl:variable name="mbmIPAddress">
            <xsl:call-template name="makeMBMIPAddress">
                <xsl:with-param name="rackNumber" select="number(@rackNumber)"/>
                <xsl:with-param name="boxNumber" select="number(@boxNumber)"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="javaeg:encodeIpAddress(string($mbmIPAddress))"/>
    </xsl:template>

    <xsl:template name="makePBMIPAddressEx">
        <xsl:variable name="pbmIPAddress">
            <xsl:call-template name="makePBMIPAddress">
                <xsl:with-param name="rackNumber" select="number(@rackNumber)"/>
                <xsl:with-param name="boxNumber" select="number(@boxNumber)"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="javaeg:encodeIpAddress(string($pbmIPAddress))"/>
    </xsl:template>

    <!-- ******************** default *********************** -->

    <xsl:template match="*">
        <xsl:message terminate="yes">Command '<xsl:value-of select="name()"/>' not found!</xsl:message>
    </xsl:template>

    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="text()|@*|processing-instruction()|comment()"/>

</xsl:stylesheet>
