/* 
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: evm.h,v $
 * Revision 1.1.1.1  2003/12/11 15:40:40  ajay
 * Importing Evm sources.
 *
 * Revision 1.1.1.1  2002/09/12 15:43:20  lsn
 * EVM source - Linux initial version
 *
 * Revision 1.1.24.1  2001/09/26  18:57:10  Anthony_Hoffman
 * 	redo of wildcatos submits
 *
 * Revision 1.1.22.5  2001/08/30  20:55:05  Jem_Treadwell
 * 	QAR 84715: Added EvmMAX_CLUSTER_EVENT_SIZE
 *
 * Revision 1.1.22.4  2001/08/01  12:57:52  Jem_Treadwell
 * 	Added binary write functions
 *
 * Revision 1.1.22.3  2001/07/25  20:21:00  Anthony_Hoffman
 * 	changes for feature tag yk.evm.003.event_queuing
 *
 * Revision 1.1.22.2  2001/02/15  20:48:09  Jem_Treadwell
 * 	QAR 85324: Added error codes EvmERROR_INVALID_TYPE and function
 * 	prototype EvmVarCheckType().  Also added code EvmERROR_EVENT_TOO_BIG,
 * 	for expected future use.
 *
 * Revision 1.1.22.1  2000/11/02  20:53:25  Anthony_Hoffman
 * 	add support for remote authentication
 * 	remote authentication functional submit
 *
 * Revision 1.1.18.7  2000/03/14  21:18:11  Jem_Treadwell
 * 	QAR 78197: Added EvmVarFormat
 *
 * Revision 1.1.18.6  2000/01/13  21:43:09  Jem_Treadwell
 * 	Added event format options, and changed EvmEventPostImmedVa prototype
 *
 * Revision 1.1.18.5  1999/12/15  21:34:12  Jem_Treadwell
 * 	Added EvmConnCreateSubscriber macro
 *
 * Revision 1.1.18.4  1999/12/13  16:37:29  Bruce_Gayliard
 * 	Merge of zinc Rolling Upgrade changes.
 *
 * Revision 1.1.18.3  1999/12/08  20:05:37  Bruce_Gayliard
 * 	EVM support for interrupt level, new convenience functions.
 *
 * Revision 1.1.18.2  1999/11/04  21:08:50  Bruce_Gayliard
 * Merge Information
 *     Merge Revision:  ZULUOS:1.1.18.1
 *     User  Revision:  Bruce_Gayliard_zulukern_br:1.1.17.1
 *    Common Ancestor:  1.1
 * 	Merge in Tony's EvmEventAutoExtendName
 * 	[1999/11/04  21:08:25  Bruce_Gayliard]
 *
 * 	Added function prototypes for kenel post and convenience functions.
 * 	[1999/11/04  12:06:44  Bruce_Gayliard]
 *
 * Revision 1.1.5.22  1999/03/30  16:01:54  Bruce_Gayliard
 * 	Build fix from (70172) mod. Need type in usr build.
 * 	[1999/03/30  15:37:46  Bruce_Gayliard]
 *
 * Revision 1.1.5.21  1999/03/29  20:55:21  Stuart_Hollander
 * 	Moved kernel subscribe pieces from kevm.h to evm.h (70172)
 * 	[1999/03/28  18:01:30  Stuart_Hollander]
 * 
 * Revision 1.1.5.20  1999/03/19  21:53:09  Bruce_Gayliard
 * 	Drop from EVM shared sandbox to steel BL 23.
 * 	[1999/03/19  13:29:36  Bruce_Gayliard]
 * 
 * Revision 1.1.9.42  1999/03/18  20:46:55  Bruce_Gayliard
 * 	Remove deprecated I18N type - P/O QAR 68723.
 * 	[1999/03/18  20:46:27  Bruce_Gayliard]
 * 
 * Revision 1.1.9.41  1999/02/22  19:21:56  Anthony_Hoffman
 * 	support for new filter file syntax, function signature change
 * 	[1999/02/22  19:17:11  Anthony_Hoffman]
 * 
 * Revision 1.1.9.40  1999/02/12  14:32:26  Bruce_Gayliard
 * 	Resync with BL22 of steelos.
 * 	[1999/02/12  14:31:32  Bruce_Gayliard]
 * 
 * Revision 1.1.5.19  1999/02/10  21:00:25  Bruce_Gayliard
 * 	Drop from EVM shared sandbox to steel BL 22.
 * 	[1999/02/09  21:07:16  Bruce_Gayliard]
 * 
 * Revision 1.1.9.39  1999/02/04  19:19:18  Anthony_Hoffman
 * 	fix for @@filter problem
 * 	[1999/02/04  19:18:05  Anthony_Hoffman]
 * 
 * Revision 1.1.9.38  1998/12/28  22:38:20  Jem_Treadwell
 * 	Removed obsolete entries
 * 	[1998/12/28  22:37:54  Jem_Treadwell]
 * 
 * Revision 1.1.9.37  1998/12/02  19:55:46  Bruce_Gayliard
 * 	New error code for connection refused.
 * 	[1998/12/02  19:48:27  Bruce_Gayliard]
 * 
 * Revision 1.1.9.36  1998/11/23  22:59:21  Jem_Treadwell
 * 	Added nonblock function and changed EVM_CONN to EvmCONN
 * 	[1998/11/23  22:57:46  Jem_Treadwell]
 * 
 * Revision 1.1.9.35  1998/11/03  20:41:11  Bruce_Gayliard
 * 	Allow for override of items set by posting operations.
 * 	[1998/11/03  20:40:19  Bruce_Gayliard]
 * 
 * Revision 1.1.9.34  1998/10/21  20:51:45  Jem_Treadwell
 * 	Changed EvmEventI18N typedefs to EvmI18N
 * 	[1998/10/21  20:38:40  Jem_Treadwell]
 * 
 * Revision 1.1.9.33  1998/10/21  17:30:52  Bruce_Gayliard
 * 	Sync with kernel code.
 * 	[1998/10/21  17:29:54  Bruce_Gayliard]
 * 
 * Revision 1.1.5.16  1998/10/19  15:02:10  Stuart_Hollander
 * 	Include evm_p.h when in kernel so we pick up macros for event names
 * 	[1998/10/16  14:40:14  Stuart_Hollander]
 * 
 * Revision 1.1.5.15  1998/10/14  23:18:31  Bruce_Gayliard
 * 	First BL 20 drop from evman shared sandbox.
 * 	[1998/10/13  18:38:27  Bruce_Gayliard]
 * 
 * Revision 1.1.9.32  1998/10/09  13:06:03  Bruce_Gayliard
 * 	Added new code for EvmConnControl.
 * 	[1998/10/09  12:54:22  Bruce_Gayliard]
 * 
 * Revision 1.1.9.31  1998/09/30  13:43:10  Jem_Treadwell
 * 	Moved these functions from evm_p.h to evm.h:
 * 	  EvmEventNameMatch
 * 	  EvmEventNameMatchStr
 * 	  EvmConnControl
 * 	  EvmEventFormatFromTemplate
 * 
 * 	Also moved some private constants to evm_p.h.
 * 	[1998/09/30  13:42:02  Jem_Treadwell]
 * 
 * Revision 1.1.9.30  1998/09/02  20:13:59  Bruce_Gayliard
 * 	Changed EvmERROR_TCL to EvmERROR_PROTOCOL_MISMATCH
 * 	[1998/09/02  20:03:05  Bruce_Gayliard]
 * 
 * Revision 1.1.9.29  1998/09/01  14:29:20  Bruce_Gayliard
 * 	Fix QAR 61430 - added item list functions to parallel varargs functions.
 * 	[1998/09/01  14:24:37  Bruce_Gayliard]
 * 
 * Revision 1.1.9.28  1998/07/24  15:47:45  Bruce_Gayliard
 * 	Revert arguments for EvmStatusTextGet().
 * 	  a_text is a macro defined in exec.h, and cannot be used.
 * 	  The previous naming was known to work.
 * 	[1998/07/24  15:26:38  Bruce_Gayliard]
 * 
 * 	Remove EvmEventDump() proto from kernel build.
 * 	[1998/07/24  15:05:51  Bruce_Gayliard]
 * 
 * Revision 1.1.9.27  1998/06/10  21:03:23  Jem_Treadwell
 * 	Cleanup, including moving private functions to evm_p.h
 * 	[1998/06/10  20:58:12  Jem_Treadwell]
 * 
 * Revision 1.1.9.26  1998/05/14  14:59:14  Jem_Treadwell
 * 	Changed the hostList arg to EvmConnSubscribe to void* for now
 * 	[1998/05/14  14:58:25  Jem_Treadwell]
 * 
 * Revision 1.1.9.25  1998/04/24  12:49:16  Bruce_Gayliard
 * 	Added functions to get to event queue pointer in handle.
 * 	[1998/04/24  12:48:03  Bruce_Gayliard]
 * 
 * Revision 1.1.9.24  1998/04/16  18:04:09  Jem_Treadwell
 * 	Added exit code, and minor cleanup
 * 	[1998/04/16  18:03:35  Jem_Treadwell]
 * 
 * Revision 1.1.9.23  1998/04/14  17:57:19  Bruce_Gayliard
 * 	Added support for daemon and logger ops.
 * 	[1998/04/14  17:55:47  Bruce_Gayliard]
 * 
 * Revision 1.1.9.22  1998/02/12  19:44:55  Jem_Treadwell
 * 	Added common exit codes
 * 	[1998/02/12  19:44:23  Jem_Treadwell]
 * 
 * Revision 1.1.9.21  1998/01/21  17:19:20  Bruce_Gayliard
 * 	Give user better event failure messages.
 * 	[1998/01/21  17:03:34  Bruce_Gayliard]
 * 
 * Revision 1.1.9.20  1997/12/01  18:16:29  Bruce_Gayliard
 * 	Clean up EvmVarInit() and place in unsupported API domain.
 * 	[1997/12/01  18:15:14  Bruce_Gayliard]
 * 
 * Revision 1.1.9.19  1997/10/10  15:05:34  Jem_Treadwell
 * 	Moved message function prototype to msgcat.h
 * 	[1997/10/10  15:05:02  Jem_Treadwell]
 * 
 * Revision 1.1.9.18  1997/10/09  21:15:30  Bruce_Gayliard
 * 	Added structures to address QAR 56206.
 * 	[1997/10/09  21:02:10  Bruce_Gayliard]
 * 
 * Revision 1.1.9.16  1997/10/08  22:03:15  Bruce_Gayliard
 * 	Wave 4 enablers: event flags for kernel use.
 * 	[1997/10/08  21:58:00  Bruce_Gayliard]
 * 
 * Revision 1.1.9.15  1997/09/29  18:50:11  Bruce_Gayliard
 * 	Fix for kernel build, don't include user proto's.
 * 	[1997/09/29  18:47:54  Bruce_Gayliard]
 * 
 * Revision 1.1.9.14  1997/09/28  17:01:21  Jem_Treadwell
 * 	Added msg cat function and exit codes
 * 	[1997/09/28  17:00:55  Jem_Treadwell]
 * 
 * Revision 1.1.9.13  1997/09/28  04:34:06  Bruce_Gayliard
 * 	First crack at registration queries - need more work.
 * 	[1997/09/28  04:31:57  Bruce_Gayliard]
 * 
 * Revision 1.1.9.12  1997/09/19  17:58:27  Jem_Treadwell
 * 	Added service support
 * 	[1997/09/19  17:56:39  Jem_Treadwell]
 * 
 * Revision 1.1.9.11  1997/09/11  20:26:13  Jem_Treadwell
 * 	Changed unused error codes to unused
 * 	[1997/09/11  20:25:35  Jem_Treadwell]
 * 
 * Revision 1.1.9.10  1997/09/08  14:34:40  Bruce_Gayliard
 * 	Service connection - no more retriever connection.
 * 	[1997/09/05  21:30:54  Bruce_Gayliard]
 * 
 * Revision 1.1.9.9  1997/08/15  14:31:08  Bruce_Gayliard
 * 	Remove 128 bit stuff, add session id, new flags.
 * 	[1997/08/15  14:26:07  Bruce_Gayliard]
 * 
 * Revision 1.1.9.8  1997/08/14  17:17:29  John_Hainsworth
 * 	Added EvmFilterDirSet().
 * 	[1997/08/14  17:16:37  John_Hainsworth]
 * 
 * Revision 1.1.9.7  1997/08/08  21:11:00  Jem_Treadwell
 * 	Add binlog support
 * 	[1997/08/08  21:10:21  Jem_Treadwell]
 * 
 * Revision 1.1.9.6  1997/08/07  15:56:40  John_Hainsworth
 * 	Fix up the use of const once and for all!
 * 	[1997/08/07  15:19:56  John_Hainsworth]
 * 
 * Revision 1.1.9.5  1997/07/15  17:28:03  Bruce_Gayliard
 * 	Support for synchronizers, Insight mods, and prep for BL 12 drop.
 * 	[1997/07/15  17:20:13  Bruce_Gayliard]
 * 
 * Revision 1.1.9.4  1997/06/30  17:53:15  Jem_Treadwell
 * 	Added EvmERROR_SIGNAL
 * 	[1997/06/30  17:52:33  Jem_Treadwell]
 * 
 * Revision 1.1.9.3  1997/06/19  19:49:45  Jem_Treadwell
 * 	Added EvmERROR_EOF
 * 	[1997/06/19  19:48:58  Jem_Treadwell]
 * 
 * Revision 1.1.9.2  1997/06/18  18:41:10  John_Hainsworth
 * 	Added EvmEventCompare() & friends.
 * 	[1997/06/18  18:36:26  John_Hainsworth]
 * 
 * Revision 1.1.5.3  1997/05/20  13:33:58  Stuart_Hollander
 * 	Prepare to bsubmit to steel pre-bl11
 * 	[1997/05/18  18:19:20  Stuart_Hollander]
 * 
 * Revision 1.1.3.17  1997/05/17  22:37:48  Bruce_Gayliard
 * 	Removed checksum, hr_time; added clusterId, ppid.
 * 	[1997/05/17  22:36:05  Bruce_Gayliard]
 * 
 * Revision 1.1.3.16  1997/05/16  15:11:54  Stuart_Hollander
 * 	private functions are not for kernel
 * 	[1997/05/16  15:07:32  Stuart_Hollander]
 * 
 * 	include of stdio.h applies not to kernel
 * 	[1997/05/16  15:05:15  Stuart_Hollander]
 * 
 * 	added EvmERROR_INTERRUPT_LEVEL
 * 	[1997/05/16  14:39:39  Stuart_Hollander]
 * 
 * Revision 1.1.3.15  1997/05/15  19:24:07  Jem_Treadwell
 * 	Include stdio.h
 * 	[1997/05/15  19:23:23  Jem_Treadwell]
 * 
 * Revision 1.1.3.14  1997/05/15  19:10:15  Jem_Treadwell
 * 	Fixed duplicate lines added by mistake on last change
 * 	[1997/05/15  19:09:42  Jem_Treadwell]
 * 
 * Revision 1.1.3.13  1997/05/15  17:17:12  Jem_Treadwell
 * 	Added private function section
 * 	[1997/05/15  17:16:21  Jem_Treadwell]
 * 
 * Revision 1.1.3.12  1997/05/08  20:42:13  Jem_Treadwell
 * 	Added EvmEventFormatFromTemplate()
 * 	[1997/05/08  20:41:33  Jem_Treadwell]
 * 
 * Revision 1.1.3.11  1997/05/08  17:41:31  John_Hainsworth
 * 	Changed EvmCallback_t so that it returns void.
 * 	Added EvmREASON_SUBSCRIBE_COMPLETE.
 * 	[1997/05/08  17:40:08  John_Hainsworth]
 * 
 * Revision 1.1.3.10  1997/05/01  14:41:33  Jem_Treadwell
 * 	Added #defines for default I18N values
 * 	[1997/05/01  14:38:15  Jem_Treadwell]
 * 
 * Revision 1.1.3.9  1997/04/30  19:16:05  Bruce_Gayliard
 * 	Env var changes, name for LOCAL_PORT, remove retriever var, add config var.
 * 	[1997/04/30  13:22:52  Bruce_Gayliard]
 * 
 * Revision 1.1.3.8  1997/04/22  19:40:57  Bruce_Gayliard
 * 	Incorporate modifications for validation function.
 * 	[1997/04/22  19:39:37  Bruce_Gayliard]
 * 
 * Revision 1.1.3.7  1997/04/14  21:08:38  Bruce_Gayliard
 * 	Started changes to separate platform dependent types (added evm_types.h).
 * 	[1997/04/14  20:59:21  Bruce_Gayliard]
 * 
 * Revision 1.1.3.6  1997/04/07  19:42:29  Bruce_Gayliard
 * 	 	** Merge Information **
 * 		** Command used:	bsubmit -visual **
 * 		** Ancestor revision:	1.1.3.4 **
 * 		** Merge revision:	1.1.3.5 **
 * 	 	** End **
 * 	Support for signals, subprocesses, retriever, and LINUX.
 * 	[1997/04/07  19:30:16  Bruce_Gayliard]
 * 
 * Revision 1.1.3.5  1997/04/07  17:56:41  John_Hainsworth
 * 	Added timeout argument to EvmConnWait().
 * 	Added EvmERROR_TIMEOUT & EvmERROR_QUEUE_FULL & EvmERROR_PROTOCOL.
 * 	Added NULL or invalid values for all datatypes.
 * 	[1997/04/04  23:26:11  John_Hainsworth]
 * 
 * Revision 1.1.3.4  1997/03/28  21:55:34  Bruce_Gayliard
 * 	Fixed return value of EvmItemListFree.
 * 	[1997/03/28  21:54:37  Bruce_Gayliard]
 * 
 * Revision 1.1.3.3  1997/03/12  19:39:58  Bruce_Gayliard
 * 	**** Transfer of WiP1 to steelos tree.
 * 	[1997/03/12  19:39:09  Bruce_Gayliard]
 * 
 * Revision 1.1.3.2  1997/03/12  19:21:13  Bruce_Gayliard
 * 	 	** Merge Information **
 * 		** Command used:	bsubmit -visual **
 * 		** Ancestor revision:	1.1 **
 * 		** Merge revision:	1.1.3.1 **
 * 	 	** End **
 * 
 * 	     EvmUint8_t was not declared "unsigned".
 * 	     [1997/02/10  21:21:59  Jem_Treadwell]
 * 
 * 	             ** Merge Information **
 * 	             ** Command used:        bsubmit -visual **
 * 	             ** Ancestor revision:   1.1.2.20 **
 * 	             ** Merge revision:      1.1.2.21 **
 * 	             ** End **
 * 	     Incorporated modifications for non-blocking I/O.
 * 	     [1997/01/29  17:18:44  Bruce_Gayliard]
 * 
 * 	     Made a parameters const wherever it made sense.
 * 	     [1997/01/28  22:33:25  John_Hainsworth]
 * 
 * 	             ** Merge Information **
 * 	             ** Command used:        bsubmit -visual **
 * 	             ** Ancestor revision:   1.1.2.18 **
 * 	             ** Merge revision:      1.1.2.19 **
 * 	             ** End **
 * 	     IMMEDIATE->WAIT,NONE->IGNORE,MSG_FORM->FORMAT
 * 	     Added status return to EvmEventDestroy().
 * 	     Removed union in CallbackData structure.
 * 	     [1997/01/21  19:08:24  John_Hainsworth]
 * 
 * 	     Added PARTIAL error (for daemon) and aligned some prototypes;
 * 	     [1997/01/21  15:16:34  Bruce_Gayliard]
 * 
 * 	     Align with evmui.c for VarList functions (use of VarList type).
 * 	     [1997/01/20  21:34:23  Bruce_Gayliard]
 * 
 * 	     VarFree modified to take pointer as argument.
 * 	     [1997/01/20  18:42:59  Bruce_Gayliard]
 * 
 * 	     Add EvmStatusTextGet().
 * 	     [1997/01/20  15:52:33  John_Hainsworth]
 * 
 * 	     Modified ItemList and VarList type definitions and functions to return
 * 	     list of item ids and list of variable names (only) respectively.
 * 	     Added item and variable free functions.
 * 	     Modified VarGet function to operate on a structure allocated by caller.
 * 	     [1997/01/17  22:23:03  Bruce_Gayliard]
 * 
 * 	     Cleaned up EvmGetLocalSocketPath() interface.
 * 	     [1997/01/14  21:48:55  John_Hainsworth]
 * 
 * 	     New status values and default domain socket path name.
 * 	     [1997/01/10  17:56:48  Bruce_Gayliard]
 * 
 * 	     Various cleanups.
 * 	     [1997/01/09  22:22:23  John_Hainsworth]
 * 
 * 	     Add #ifdef kernel change for Stuart.
 * 	     [1997/01/08  16:52:45  John_Hainsworth]
 * 
 * 	     Fix problems found by compiling with cxx.
 * 	     [1997/01/07  17:09:26  John_Hainsworth]
 * 
 * 	     Argument to EvmConnSubscribe is EvmString_t, not EvmFilter_t
 * 	     [1997/01/06  23:49:21  John_Hainsworth]
 * 
 * 	     Added EvmEventWrite and EvmEventRead.
 * 	     [1997/01/06  19:17:58  John_Hainsworth]
 * 
 * 	     Fix tabstops.
 * 	     [1997/01/03  19:13:21  Bruce_Gayliard]
 * 
 * 	     Completed addition (name change needed) for kernel and cluster flags/booleans.
 * 	     [1997/01/03  17:54:37  Bruce_Gayliard]
 * 
 * 	     Added boolean types for kernel and cluster event items.
 * 	     [1997/01/03  14:42:11  Bruce_Gayliard]
 * 
 * 	     Added EvmEventFormat(), and some tab alignment cleanup
 * 	     [1997/01/02  22:13:03  Jem_Treadwell]
 * 
 * 	     Cleaned up evm.h
 * 	     [1997/01/02  18:06:48  John_Hainsworth]
 * 
 * 	     Merge of connection API with Jem Treadwell's changes
 * 	     [1996/12/31  23:33:18  John_Hainsworth]
 * 
 * 	     Created
 * 	     [1996/12/20  18:43:12  John_Hainsworth]
 * 
 * $EndLog$
 * 
 * @(#)$RCSfile: evm.h,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/12/11 15:40:40 $
 * 
 * MODULE:	evm.h
 *
 * ABSTRACT:	Public C-language for the EVM API.
 *
 * NOTES:	
*/
#ifndef	__EVM_H__
#define	__EVM_H__


/******************* System include files */
#ifndef _KERNEL
#include <stdio.h>
#endif


/******************* Application specific include files */
#include <evm_types.h>



/******************* Datatypes */
/******************* Constant parameters */
#define EvmMAX_CLUSTER_EVENT_SIZE (128*1024)


/******************* Macros */

/* Simple derived types */
typedef	EvmChar_t		*EvmString_t;
typedef	const EvmChar_t		*EvmConstString_t;

typedef EvmInt32_t		EvmI18NMsgId_t;
#define EvmI18N_MSG_ID_NONE	(EvmI18NMsgId_t)0

typedef EvmInt32_t		EvmI18NSetId_t;
#define EvmI18N_SET_DEFAULT	(EvmI18NSetId_t)1

typedef EvmString_t		EvmI18NCatalog_t;
typedef EvmInt32_t		EvmFd_t;
typedef int       		EvmMemberId_t;
typedef EvmUint32_t		EvmTimestamp_t;
typedef EvmUint32_t		EvmCount_t;
typedef EvmUint32_t		EvmEventId_t;

typedef EvmUint32_t		EvmIpAddress_t;
#define EvmIpAddress_UNDEFINED (~((EvmIpAddress_t)0))

/* Event priority datatype */
typedef EvmUint16_t	EvmPriority_t;

#define EvmPRIO_EMERGENCY	700
#define EvmPRIO_MAX		EvmPRIO_EMERGENCY
#define EvmPRIO_ALERT		600
#define EvmPRIO_CRITICAL	500
#define EvmPRIO_ERROR		400
#define EvmPRIO_WARNING		300
#define EvmPRIO_NOTICE		200
#define EvmPRIO_INFORMATION	100
#define EvmPRIO_DEBUG		0


/******************* Event format flags */
#define EvmFMT_NO_REPEAT_COUNT  1 << 0

 
/*
 * Anonymous structure available for type checking.
 */
struct EvmEventHandle_s;
typedef struct EvmEventHandle_s	*EvmEvent_t;
typedef const struct EvmEventHandle_s * EvmConstEvent_t;

/*
 * Available types for user supplied event variables.
 */
typedef enum	EvmVarType_e
{
	EvmTYPE_NONE = 0,
	EvmTYPE_BOOLEAN,
	EvmTYPE_FIRST = EvmTYPE_BOOLEAN,
	EvmTYPE_CHAR,
	EvmTYPE_INT16,
	EvmTYPE_INT32,
	EvmTYPE_INT64,
	EvmTYPE_UINT8,
	EvmTYPE_UINT16,
	EvmTYPE_UINT32,
	EvmTYPE_UINT64,
	EvmTYPE_FLOAT,
	EvmTYPE_DOUBLE,
	EvmTYPE_STRING,
	EvmTYPE_OPAQUE,
	EvmTYPE_MAX = EvmTYPE_OPAQUE
} EvmVarType_t;

typedef union	EvmVarValue_u
{
	EvmString_t	STRING;
	EvmBoolean_t	BOOLEAN;
	EvmChar_t	CHAR;
	EvmInt16_t	INT16;
	EvmInt32_t	INT32;
	EvmInt64_t	INT64;
	EvmUint8_t	UINT8;
	EvmUint16_t	UINT16;
	EvmUint32_t	UINT32;
	EvmUint64_t	UINT64;
	EvmFloat_t	FLOAT;
	EvmDouble_t	DOUBLE;
	EvmOpaque_t	OPAQUE;
} EvmVarValue_t;

#define EvmNUMBER_OF_VARTYPES (EvmTYPE_MAX - EvmTYPE_FIRST + 1)

typedef	EvmUint32_t	EvmSize_t;

typedef EvmConstString_t	EvmVarName_t;

typedef struct EvmVarStruct_s
{
	EvmVarType_t		type;
	EvmVarName_t		name_p;
	EvmVarValue_t		value;
	EvmSize_t		length;
	EvmI18NMsgId_t		msgId;
} EvmVarStruct_t;

typedef EvmVarName_t	*EvmVarList_t;

#define EvmTYPE_IS_VALID(pbp) \
	(((pbp) <= EvmTYPE_MAX) && ((pbp) > EvmTYPE_NONE))

/*
 * Definition of the EVM event item identifiers.  The existing
 * enumerations should not be changed, except to replace
 * "UNUSED" enumerations and increase the value of "MAX".
 */
typedef enum	EvmItemId_e
{
	EvmITEM_NONE = 0,
	EvmITEM_FIRST = 1,
	EvmITEM_NAME = EvmITEM_FIRST,
	EvmITEM_UNUSED_1,		/* Do not remove; OK to reassign */
	EvmITEM_KERNEL_ONLY,
	EvmITEM_CLUSTER_EVENT,
	EvmITEM_PRIORITY,
	EvmITEM_PID,
	EvmITEM_PPID,
	EvmITEM_EVENT_ID,
	EvmITEM_MEMBER_ID,
	EvmITEM_TIMESTAMP,
	EvmITEM_HOST_IP,
	EvmITEM_REPEAT_COUNT,
	EvmITEM_LAST_TIMESTAMP,
	EvmITEM_I18N_MSG_ID,
	EvmITEM_I18N_SET_ID,
	EvmITEM_I18N_CATALOG,
	EvmITEM_CLUSTER_IP,
	EvmITEM_HOST_NAME,
	EvmITEM_CLUSTER_NAME,
	EvmITEM_USER_NAME,
	EvmITEM_FORMAT,
	EvmITEM_REF,
	EvmITEM_PREDEFINED_MAX = EvmITEM_REF,	/* Last item defined by EVM. */
	EvmITEM_VAR,
	EvmITEM_MAX = EvmITEM_VAR,	 /* Used for item validation. */

	/* This group of items is used for internal EVM operations only. */
	EvmITEM_INTERNAL_USE_FIRST = 512,       /* Table of internal items. */
	EvmITEM_HDR_EXT_SIZE = EvmITEM_INTERNAL_USE_FIRST,
	EvmITEM_FORMATTED,
	EvmITEM_INTERNAL_USE_LAST = EvmITEM_HDR_EXT_SIZE,

	/*
	 * The following enumeration values are used to distinguish
	 * different variable types when setting values in an event using
	 * convenicence wrapper functions.  They do not specify discrete
	 * items, and will never be returned when retrieving information
	 * about the contents of an event.  These values must be greater
	 * than the value of EvmITEM_MAX.
	 */
	EvmITEM_VAR_FIRST = 1024,
	EvmITEM_VAR_BOOLEAN = EvmITEM_VAR_FIRST,
	EvmITEM_VAR_CHAR,
	EvmITEM_VAR_INT16,
	EvmITEM_VAR_INT32,
	EvmITEM_VAR_INT64,
	EvmITEM_VAR_UINT8,
	EvmITEM_VAR_UINT16,
	EvmITEM_VAR_UINT32,
	EvmITEM_VAR_UINT64,
	EvmITEM_VAR_FLOAT,
	EvmITEM_VAR_DOUBLE,
	EvmITEM_VAR_STRING,
	EvmITEM_VAR_STRING_I18N,
	EvmITEM_VAR_OPAQUE,
	EvmITEM_VAR_MAX = EvmITEM_VAR_OPAQUE
} EvmItemId_t;

#define EvmITEM_IS_VALID(pbp) \
	(((pbp) <= EvmITEM_MAX) && ((pbp) > EvmITEM_NONE))

#define EvmNUMBER_OF_ITEMS (EvmITEM_MAX - EvmITEM_FIRST + 1)

typedef union	EvmItemValue_u
{
	EvmString_t		NAME;
	EvmBoolean_t		KERNEL_ONLY;
	EvmBoolean_t		CLUSTER_EVENT;
	EvmPriority_t		PRIORITY;
	EvmMemberId_t		MEMBER_ID;
	EvmPid_t		PID;
	EvmPid_t		PPID;
	EvmEventId_t		EVENT_ID;
	EvmTimestamp_t		TIMESTAMP;
	EvmIpAddress_t		HOST_IP;
	EvmI18NMsgId_t		I18N_MSG_ID;
	EvmI18NSetId_t		I18N_SET_ID;
	EvmI18NCatalog_t	I18N_CATALOG;
	EvmCount_t		REPEAT_COUNT;
	EvmTimestamp_t		LAST_TIMESTAMP;
	EvmIpAddress_t		CLUSTER_IP;
	EvmString_t		HOST_NAME;
	EvmString_t		CLUSTER_NAME;
	EvmString_t		USER_NAME;
	EvmString_t		FORMAT;
	EvmString_t		REF;
	EvmVarStruct_t *	VAR;
} EvmItemValue_t;

typedef	EvmItemId_t	*EvmItemList_t;

/*
 * Definition of item/value list.
 */

typedef	struct EvmItemEntry_s
{
	EvmItemId_t	id;
	EvmItemValue_t	value;
} EvmItemEntry_t;

typedef	EvmItemEntry_t	*EvmItemEntryList_t;

/*
 * Error/Status return codes for all EVM functions
 */
typedef	enum EvmStatus_e
{
	EvmERROR_NONE = 0,
	EvmERROR_NOT_IMPLEMENTED = 1,
	EvmERROR_INVALID_ARGUMENT = 2,
	EvmERROR_NOT_SET = 3,
	EvmERROR_NOT_PRESENT = 4,
	EvmERROR_PROTOCOL_MISMATCH = 5,
	EvmERROR_NO_MEMORY = 6,
	EvmERROR_INVALID_VARARGS_LIST = 7,
	EvmERROR_FILTER_NOT_VALID = 8,
	EvmERROR_INVALID_VALUE = 9,
	EvmERROR_NOT_INITIALIZED = 10,
	EvmERROR_SELECT = 11,
	EvmERROR_SERVICE_TERMINATED = 12,
	EvmERROR_CONNECT = 13,
	EvmERROR_READ = 14,
	EvmERROR_WRITE = 15,
	EvmERROR_OPEN = 16,
	EvmERROR_EVENT_REJECTED = 17,
	EvmERROR_RESOURCE = 18,
	EvmERROR_SEQUENCE = 19,
	EvmERROR_CONNECTION_LOST = 20,
	EvmERROR_INVALID_OPERATION = 21,
	EvmERROR_INVALID_MESSAGE = 22,
	EvmERROR_PARTIAL = 23,
	EvmERROR_WOULDBLOCK = 24,
	EvmERROR_TIMEOUT = 25,
	EvmERROR_QUEUE_FULL = 26,
	EvmERROR_PROTOCOL = 27,
	EvmERROR_INTERRUPT_LEVEL = 28,	/* op prohibited at interrupt level */
	EvmERROR_EOF = 29,
	EvmERROR_SIGNAL = 30,
	EvmERROR_SYNCHRONIZATION_FAILURE = 31,
	EvmERROR_EVENT_NOT_VALID = 32,
	EvmERROR_QUEUED = 33,
	EvmERROR_CONNECTION_REFUSED = 34,
	EvmERROR_TOO_MANY_ITEMS = 35,
	EvmERROR_INVALID_TYPE = 36,
	EvmERROR_EVENT_TOO_BIG = 37,
	EvmERROR_LAST
} EvmStatus_t;


/*
 * Common program exit codes:
 */
#define EvmEXIT_OK 		0
#define EvmEXIT_USAGE 		1
#define EvmEXIT_ARGS 		2
#define EvmEXIT_ENV 		3
#define EvmEXIT_CONFIG 		4
#define EvmEXIT_OPEN_ERR 	5
#define EvmEXIT_IO_ERR	 	6
#define EvmEXIT_TIMEOUT 	7
#define EvmEXIT_CONNECTION 	8
#define EvmEXIT_POST 		9
#define EvmEXIT_SUBSCRIBE 	10
#define EvmEXIT_SERVICE 	11
#define EvmEXIT_CHANNEL_ERR 	12
#define EvmEXIT_FILTER 		13
#define EvmEXIT_MEMORY 		14
#define EvmEXIT_ACCESS 	        15
#define EvmEXIT_UNKNOWN_HOST 	16

#define EvmEXIT_ERROR 		99



/***** DATATYPES FOR THE FILTER EVALUATOR API */

/* if C++
 *    declare C++ classes types correctly
 * else (C)
 *    declare C structs to simulate C++ classes
 */
#ifdef __cplusplus
class EvmFilterEval_c;

#else /* !defined(__cplusplus) */
struct EvmFilterEval_s;
typedef struct EvmFilterEval_s EvmFilterEval_c;

#endif /* !defined(__cplusplus) */

/* Opaque filter evaluator datatype */
typedef EvmFilterEval_c * EvmFilter_t;



/***** CONNECTION HANDLING DATATYPES *****/

/* Opaque datatype for a connection to an event switch/distributor */
typedef struct EvmConnection_s * EvmConnection_t;

typedef EvmOpaque_t EvmCallbackArg_t;

/* Purpose of a connection */
typedef enum EvmConnectionType_e {
	EvmCONNECTION_POST,
	EvmCONNECTION_LISTEN,
	EvmCONNECTION_SERVICE,

	EvmCONNECTION_INTERNAL_USE_FIRST = 512,  /* Table of internal types. */
	EvmCONNECTION_AUTHENT_1 = EvmCONNECTION_INTERNAL_USE_FIRST,
	EvmCONNECTION_AUTHENT_2
} EvmConnectionType_t;

/* Response type for a connection */
typedef enum EvmResponseMode_e {
        EvmRESPONSE_WAIT,
        EvmRESPONSE_CALLBACK,
        EvmRESPONSE_IGNORE
} EvmResponseMode_t;

/* Transport mechanism for a connection: type and supporting data */
typedef enum EvmTransportType_e {
        EvmTRANSPORT_DOMAIN_SOCKET,
        EvmTRANSPORT_TCPIP
} EvmTransportType_t;

/* Connection control request codes */
typedef	enum	EvmConnControlRequest_e
{
		EvmCONN_RCV_SZ_GET,
		EvmCONN_RCV_SZ_SET,
		EvmCONN_SND_SZ_GET,
		EvmCONN_SND_SZ_SET,
		EvmCONN_CHECKSUM_ENABLE,
		EvmCONN_CHECKSUM_DISABLE,
		EvmCONN_CHECKSUM_IS_ENABLED,
		EvmCONN_IS_CLUSTER_ALIAS,
		EvmCONN_REMOTE_IS_ON_CLUSTER,
		EvmCONN_LOCAL_HOST_NAME_GET,
		EvmCONN_LOCAL_IP_GET,
		EvmCONN_REMOTE_HOST_NAME_GET,
		EvmCONN_REMOTE_IP_GET,
		EvmCONN_CLUSTER_LIST_GET,
		EvmCONN_CLUSTER_HOST_IP_GET,
		EvmCONN_POST_ITEM_MASK_SET,
		EvmCONN_POST_ITEM_MASK_RESET,
		EvmCONN_POST_NONBLOCK_SET
} EvmConnControlRequest_t;


struct EvmDomainSocketData_s {
        EvmString_t name; /* if NULL, use default */
};

struct EvmTcpipData_s {
        EvmInt32_t portNumber; /* if -1, use default */
        EvmString_t hostName; /* if NULL, use local host */
};

typedef union EvmTransportData_u {
        struct EvmDomainSocketData_s domainSocket;
        struct EvmTcpipData_s tcpip;
} EvmTransportData_t;

typedef struct EvmTransport_s {
        EvmTransportType_t type;
        EvmTransportData_t data;
} EvmTransport_t;

/* data returned by a callback */
typedef enum EvmCallbackReason_e {
    EvmREASON_POST_COMPLETE, 
    EvmREASON_EVENT_DELIVERED, 
    EvmREASON_SUBSCRIBE_COMPLETE,
    EvmREASON_TEMPLATE_INFO_DELIVERED,
    EvmREASON_REGISTRATION_DELIVERED,
    EvmREASON_EVENTS_MISSED,
    EvmREASON_KBUFF_OVERFLOW 
} EvmCallbackReason_t;

typedef struct EvmCallbackTemplateData_s {
    EvmPointer_t userArg;
    EvmBoolean_t resetToFirst;
    EvmPriority_t squelchLevel;
} EvmCallbackTemplateData_t;

typedef struct EvmCallbackEventMissedData_s {
    EvmInt32_t missedCount;
} EvmCallbackEventMissedData_t;

typedef struct EvmCallbackKBuffOverflowData_s {
    EvmInt32_t			missedCount;
} EvmCallbackKBuffOverflowData_t;

typedef union EvmCallbackExtension_u {
    EvmCallbackTemplateData_t 		templateData;
    EvmCallbackEventMissedData_t 	eventMissedData;
    EvmCallbackKBuffOverflowData_t 	kBuffOverflowData;
} EvmCallbackExtension_t;

typedef struct EvmCallbackData_s {
    EvmCallbackReason_t 	reason;
    EvmEvent_t 			event; 
    EvmStatus_t 		status;
    EvmCallbackExtension_t 	extension;
} EvmCallbackData_t;

/*
 * Callback used by connection to provide asynchronous response. 
 */
typedef void (*EvmCallback_t) (EvmConnection_t a_conn,
			       EvmCallbackArg_t a_callbackArg,
			       EvmCallbackData_t * a_callbackData);



/******************* MACROS FOR NULL VARIABLE TYPES */

/*
 * The following macros define values that are guaranteed to be invalid
 * for their respective datatypes.
 * These values can be used as flags for uninitialized variables.
 */
#define EvmEventNULL		((EvmEvent_t)0)
#define EvmVarListNULL		((EvmVarList_t)0)
#define EvmItemListNULL		((EvmItemList_t)0)
#define EvmFilterNULL		((EvmFilter_t)0)
#define EvmTransportNULL	((EvmTransport_t *)0)
#define EvmCallbackNULL		((EvmCallback_t)0)
#define EvmCallbackArgNULL	((EvmCallbackArg_t)0)
#define EvmCallbackDataNULL	((EvmCallbackData_t)0)
#define EvmConnectionNULL	((EvmConnection_t)0)

/*
 * This macro defines the timeout value if you want no timeout
 * (i.e. wait forever if necessary).
 */
#define EvmTIMEOUT_NONE		((struct timeval *)0)




/******************* GLOBAL FUNCTIONS */

#ifdef __cplusplus
/* tell C++ compiler not to mangle the following function names */
extern "C"
{
#endif /* !defined(__cplusplus) */


/***** EVM STATUS CODE INTERPRETATION *****/

/*
 * Returns up to a_nBytes of descriptive text about an EVM error code in
 * the user-supplied buffer p_text.
 */
EvmStatus_t
EvmStatusTextGet (EvmStatus_t p_status,
		  EvmString_t p_text,
		  EvmSize_t p_nBytes);


/***** GENERAL EVENT MANIPULATION */

#define EvmEventCreate(ev)	EvmEventCreateVa((ev),EvmITEM_NONE)

EvmStatus_t
EvmEventDup (EvmEvent_t * dup_ev, EvmConstEvent_t ev);

EvmStatus_t
EvmEventDestroy (EvmEvent_t a_ev_p);

/*
 * Indicating a single item/value_reference pair (item may be variable):
 *	EvmStatus_t
 *	EvmEventCreateVa (EvmEvent_t	a_ev_p,
 *			  EvmItemId_t itemId, EvmItemValue_t item,
 *			  ...
 *			  EvmITEM_NONE);
 */
EvmStatus_t
EvmEventCreateVa (EvmEvent_t * a_ev_p, ...);

EvmStatus_t
EvmEventCreateFromList (EvmEvent_t *	a_ev_p,
			EvmItemEntryList_t	a_ivlist_p,
			EvmCount_t		a_number);

EvmStatus_t
EvmEventValidate (EvmConstEvent_t a_event);

EvmStatus_t
EvmEventFormat (char * a_buff, size_t a_bufflen, EvmConstEvent_t a_ev);

EvmStatus_t
EvmEventFormatOpt(char *a_buff, size_t a_bufflen, EvmConstEvent_t a_ev,
			    EvmUint32_t a_flags);

EvmStatus_t
EvmEventFormatFromTemplate(char * a_buff, size_t a_bufflen,
			   EvmString_t a_template, EvmConstEvent_t a_ev);

#ifndef _KERNEL

EvmStatus_t
EvmEventDump (EvmConstEvent_t a_event, FILE * a_fd);

#endif

EvmStatus_t
EvmEventWrite (EvmFd_t a_fileDes, EvmConstEvent_t a_ev_p);

EvmStatus_t
EvmItemWriteBinary(EvmFd_t a_fd,EvmEvent_t a_ev,EvmString_t a_itemname);

EvmStatus_t
EvmVarWriteBinary(EvmFd_t a_fd,EvmEvent_t a_ev,EvmString_t a_varname);

EvmStatus_t
EvmEventRead (EvmFd_t a_fileDes, EvmEvent_t * a_ev_p);

EvmStatus_t
EvmEventAutoExtendName (EvmEvent_t a_event, EvmUint32_t *count );

#ifdef _KERNEL

/* Interrupt level kernel event posting routine. */
EvmStatus_t
EvmEventPostImmedVa (void *a_null, ...);

#endif


/***** EVENT ITEM MANIPULATION */

/*
 * Indicating a single item/value_reference pair (item may be variable):
 *	EvmStatus_t
 *	EvmItemSetVa (EvmEvent_t	a_ev_p,
 *		      EvmItemId_t itemId, EvmItemValue_t item,
 *		      ...
 *		      EvmITEM_NONE);
 */
EvmStatus_t
EvmItemSetVa (EvmEvent_t a_ev_p, ...);

#define EvmItemSet(ev,id,val)	EvmItemSetVa((ev),(id),(val),EvmITEM_NONE)

EvmStatus_t
EvmItemEntryListSet (EvmEvent_t		a_ev_p,
		     EvmItemEntryList_t	a_ivlist_p,
		     EvmCount_t		a_number);

EvmStatus_t
EvmItemGet (EvmConstEvent_t	a_ev_p,
	    EvmItemId_t		a_item,
	    EvmItemValue_t *	a_value_p);

EvmStatus_t
EvmItemRelease (EvmItemId_t	a_item,
		EvmItemValue_t	a_value);

EvmStatus_t
EvmItemListGet (EvmConstEvent_t	a_ev_p,
		EvmCount_t 	*a_number_p,
		EvmItemList_t 	*a_list_p);

EvmStatus_t
EvmItemListFree (EvmItemList_t a_list_p);


/***** EVENT VARIABLE MANIPULATION */

EvmStatus_t
EvmVarSet (EvmEvent_t		a_ev_p,
	   EvmVarName_t		a_name_p,
	   EvmVarType_t		a_type,
	   const EvmVarValue_t	a_value,
	   EvmI18NMsgId_t	a_msgId,
	   EvmSize_t		a_valLen);

EvmStatus_t
EvmVarGet (EvmConstEvent_t	a_ev_p,
	   EvmVarName_t		a_name, 
	   EvmVarStruct_t *	a_var_p);

EvmStatus_t
EvmVarRelease (EvmVarStruct_t	*a_var_p);

EvmStatus_t
EvmVarListGet (EvmConstEvent_t	a_ev_p,
	       EvmCount_t 	*a_number_p,
	       EvmVarList_t 	*a_list_p);

EvmStatus_t
EvmVarListFree (EvmVarList_t 	a_list_p);

EvmStatus_t
EvmVarFormat(EvmConstEvent_t a_ev, const char *a_varname, char *a_buff,
		size_t a_buffsz, EvmBoolean_t a_translate);


/***** VARSET WRAPPER FUNCTIONS */

EvmStatus_t EvmVarSetBoolean(EvmEvent_t ev,EvmVarName_t name,
	const EvmBoolean_t value);

EvmStatus_t EvmVarSetChar(EvmEvent_t ev,EvmVarName_t name,
	const EvmChar_t value);

EvmStatus_t EvmVarSetInt16(EvmEvent_t ev,EvmVarName_t name,
	const EvmInt16_t value);

EvmStatus_t EvmVarSetInt32(EvmEvent_t ev,EvmVarName_t name,
	const EvmInt32_t value);

#ifndef LINUX
EvmStatus_t EvmVarSetInt64(EvmEvent_t ev,EvmVarName_t name,
	const EvmInt64_t value);
#endif

EvmStatus_t EvmVarSetUint8(EvmEvent_t ev,EvmVarName_t name,
	const EvmUint8_t value);

EvmStatus_t EvmVarSetUint16(EvmEvent_t ev,EvmVarName_t name,
	const EvmUint16_t value);

EvmStatus_t EvmVarSetUint32(EvmEvent_t ev,EvmVarName_t name,
	const EvmUint32_t value);

#ifndef LINUX
EvmStatus_t EvmVarSetUint64(EvmEvent_t ev,EvmVarName_t name,
	const EvmUint64_t value);
#endif
#ifndef _KERNEL
EvmStatus_t EvmVarSetFloat(EvmEvent_t ev,EvmVarName_t name,
	const EvmFloat_t value);
#endif

#ifndef _KERNEL
EvmStatus_t EvmVarSetDouble(EvmEvent_t ev,EvmVarName_t name,
	const EvmDouble_t value);
#endif

EvmStatus_t EvmVarSetString(EvmEvent_t ev,EvmVarName_t name,
	const EvmString_t value);

EvmStatus_t EvmVarSetStringI18n(EvmEvent_t ev,EvmVarName_t name,
	const EvmString_t value,EvmI18NMsgId_t msgid);

EvmStatus_t EvmVarSetOpaque(EvmEvent_t ev,EvmVarName_t name,
	const EvmOpaque_t value,EvmSize_t size);

/***** VARGET WRAPPER FUNCTIONS */

EvmStatus_t
EvmVarGetType(EvmEvent_t ev, EvmVarName_t varname, EvmVarType_t *type);

EvmStatus_t
EvmVarCheckType(EvmEvent_t ev, EvmVarName_t varname, EvmVarType_t type);

EvmStatus_t EvmVarGetBoolean(EvmEvent_t ev,EvmVarName_t name,
	EvmBoolean_t *value);

EvmStatus_t EvmVarGetChar(EvmEvent_t ev,EvmVarName_t name,
	EvmChar_t *value);

EvmStatus_t EvmVarGetInt16(EvmEvent_t ev,EvmVarName_t name,
	EvmInt16_t *value);

EvmStatus_t EvmVarGetInt32(EvmEvent_t ev,EvmVarName_t name,
	EvmInt32_t *value);

EvmStatus_t EvmVarGetInt64(EvmEvent_t ev,EvmVarName_t name,
	EvmInt64_t *value);

EvmStatus_t EvmVarGetUint8(EvmEvent_t ev,EvmVarName_t name,
	EvmUint8_t *value);

EvmStatus_t EvmVarGetUint16(EvmEvent_t ev,EvmVarName_t name,
	EvmUint16_t *value);

EvmStatus_t EvmVarGetUint32(EvmEvent_t ev,EvmVarName_t name,
	EvmUint32_t *value);

EvmStatus_t EvmVarGetUint64(EvmEvent_t ev,EvmVarName_t name,
	EvmUint64_t *value);

#ifndef _KERNEL
EvmStatus_t EvmVarGetFloat(EvmEvent_t ev,EvmVarName_t name,
	EvmFloat_t *value);
#endif

#ifndef _KERNEL
EvmStatus_t EvmVarGetDouble(EvmEvent_t ev,EvmVarName_t name,
	EvmDouble_t *value);
#endif

EvmStatus_t EvmVarGetOpaque(EvmEvent_t ev,EvmVarName_t name,
	EvmOpaque_t *buff,EvmSize_t *size);

EvmStatus_t EvmVarGetString(EvmEvent_t ev,EvmVarName_t name,
	EvmString_t *string,EvmI18NMsgId_t *msgid);

/***** FILTER FUNCTIONS */

EvmStatus_t
EvmFilterCreate (EvmFilter_t	*a_filter_p);

EvmStatus_t
EvmFilterDestroy (EvmFilter_t	a_filter);

EvmStatus_t
EvmFilterSet (EvmFilter_t	a_filter,
	      EvmConstString_t	a_value);
    
EvmStatus_t
EvmFilterDirSet (EvmFilter_t		a_filter,
		 EvmConstString_t	a_directory);
    
EvmStatus_t
EvmFilterTest (EvmFilter_t	a_filter,
	       EvmConstEvent_t	a_event,
	       EvmBoolean_t	*a_matchFlag_p);

EvmStatus_t
EvmFilterIsFile( const char *a_filter, EvmBoolean_t *o_arg);

EvmStatus_t
EvmFilterReadFile( const char *a_filter, char **o_filter);

/***** EVENT NAME MATCHING */

EvmStatus_t
EvmEventNameMatchStr(const char *a_pattern, const char * a_candidate,
        EvmBoolean_t *a_match);

EvmStatus_t
EvmEventNameMatch(const char *a_pattern, EvmEvent_t a_event,
        EvmBoolean_t *a_match);

/***** GENERAL CONNECTION HANDLING *****/

/* Create a connection */
EvmStatus_t
EvmConnCreate (EvmConnectionType_t	a_type,
	       EvmResponseMode_t	a_mode,
	       const EvmTransport_t	*a_transport, /* NULL for default */
	       EvmCallback_t		a_callback,
	       EvmCallbackArg_t		a_callbackArg,
	       EvmConnection_t		*a_conn_p);

#define EvmConnCreatePoster(conn) \
	EvmConnCreate(EvmCONNECTION_POST,EvmRESPONSE_WAIT,NULL,NULL,NULL,(conn))

#define EvmConnCreateSubscriber(callback,arg,conn) \
	EvmConnCreate(EvmCONNECTION_LISTEN,EvmRESPONSE_CALLBACK,NULL, \
				(callback),(arg),(conn))

/* Disconnect and destroy a connection */
EvmStatus_t
EvmConnDestroy (EvmConnection_t	a_conn);

/* Get the Fd for this connection */
EvmStatus_t
EvmConnFdGet (EvmConnection_t	a_conn,
	      EvmFd_t 		*a_fd);

/* Check for unprocessed response information on this connection */
EvmStatus_t
EvmConnCheck (EvmConnection_t	a_conn,
	      EvmBoolean_t	*a_responsePresent_p);

/* Wait for response on this connection. */
#ifndef _SYS_TIME_H_
struct timeval; /* defined in <sys/time.h> */
#endif
EvmStatus_t
EvmConnWait (EvmConnection_t a_conn, const struct timeval *a_timeout);

/*
 * Handle any outstanding i/o for the connection:
 */
EvmStatus_t
EvmConnDispatch (EvmConnection_t a_conn);

/*
 * Connection control function:
 */
EvmStatus_t
EvmConnControl (EvmConnection_t a_conn,
                EvmInt32_t a_request,
                void *a_argument);

/*
 * Flush queued messages:
 */
EvmStatus_t
EvmConnFlush (EvmConnection_t	a_conn,
	      EvmInt32_t	*a_count);


#ifndef _KERNEL
/*
 * Get socket buffer max size
 */
EvmInt32_t
EvmGetSocketBufferLimit( void );

#endif


/***** EVENT POSTING *****/

/* Post an event to a connection */
EvmStatus_t
EvmEventPost (
#ifndef _KERNEL
	      EvmConnection_t a_conn,
#endif /* _KERNEL */
	      EvmEvent_t a_event);
                            

EvmStatus_t EvmEventPostVa(
#ifndef _KERNEL
	      EvmConnection_t a_conn,
#endif /* _KERNEL */
	      EvmEvent_t a_event, ...);

/***** EVENT LISTENING & SUBSCRIPTION *****/

/* Subscribe for events */
EvmStatus_t
EvmConnSubscribe (EvmConnection_t	a_conn,
		  void		 	*a_hostList, /* Not used */
		  EvmConstString_t	a_filter);

#ifndef _KERNEL


EvmStatus_t
EvmConnRegistrationGet (EvmConnection_t         a_conn,
                        EvmConstString_t        a_eventClass,
                        EvmPointer_t            a_userArg);


EvmStatus_t
EvmConnTemplateScan (EvmConnection_t    a_conn,
                     EvmConstString_t   a_filter,
                     EvmPointer_t       a_userArg);


/***** EVM SERVICE FUNCTIONS *****/

EvmStatus_t
EvmSrvStart (char		*a_service_name,
	     char		*a_arg_string,
	     EvmTransport_t	*a_transport,
	     EvmConnection_t	*a_conn);

EvmStatus_t
EvmSrvMessageGet (EvmConnection_t	a_conn,
		  EvmEvent_t		*a_ev,
		  char			**a_msg,
		  char			**a_errmsg,
		  EvmInt32_t		*a_data);


typedef unsigned long EvmItemMask_t;
#define EvmItemMask_(a_item) (0x1L<<((int)(a_item)))
#define EvmItemMaskALL ((EvmItemMask_t)(-1L))

#endif /* End of non-kernel only */

/*
 * evm_p.h depends on definitions above, so must
 * be included at the end.
 */
#include <evm_p.h>

typedef char *EvmHandle_S_t ;
#ifdef _KERNEL
EvmStatus_t EvmKernelEventSubscribe
	(EvmHandle_S_t	*, char *, char *, void (*)(EvmEvent_t, void *), void *);
EvmStatus_t EvmKernelEventUnsubscribe(EvmHandle_S_t);
#endif

#ifdef __cplusplus
/* end of non-mangled-function-name block */
}
#endif /* __cplusplus */

#endif	/* __EVM_H__ */
