/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: evm_p.h,v $
 * Revision 1.1.1.1  2003/12/11 15:40:40  ajay
 * Importing Evm sources.
 *
 * Revision 1.1.1.1  2002/09/12 15:43:20  lsn
 * EVM source - Linux initial version
 *
 * Revision 1.1.14.1  2001/09/26  18:57:11  Anthony_Hoffman
 * 	redo of wildcatos submits
 *
 * Revision 1.1.12.2  2001/04/05  16:02:16  Jem_Treadwell
 * 	Added EvmBinlogEventSize().
 *
 * Revision 1.1.12.1  2000/11/02  20:53:27  Anthony_Hoffman
 * 	add remote authentication support - extra arg in EvmConnCreateStep
 * 	remote authentication functional submit
 *
 * Revision 1.1.10.2  2000/01/19  22:21:47  Jem_Treadwell
 * 	Added prototype for EvmConnProtocolVersionGet()
 *
 * Revision 1.1.10.1  1999/12/08  20:05:38  Bruce_Gayliard
 * 	EVM support for interrupt level posting.
 *
 * Revision 1.1.5.9  1999/02/24  22:27:59  Jem_Treadwell
 * 	Drop from EVM shared sandbox to Steel BL22
 * 	[1999/02/24  16:51:34  Jem_Treadwell]
 *
 * Revision 1.1.2.15  1999/02/22  17:57:34  Jem_Treadwell
 * 	Changed eventname macro to new name
 * 	[1999/02/22  17:57:10  Jem_Treadwell]
 * 
 * Revision 1.1.2.14  1998/11/24  18:01:17  Bruce_Gayliard
 * 	Added stepwise EvmCreate function.
 * 	[1998/11/24  18:00:48  Bruce_Gayliard]
 * 
 * Revision 1.1.2.13  1998/11/06  14:49:50  Bruce_Gayliard
 * 	Support new /var/evm directory structure.
 * 	[1998/11/06  14:48:54  Bruce_Gayliard]
 * 
 * Revision 1.1.2.12  1998/10/28  22:04:56  Jem_Treadwell
 * 	Updated binlog support prototypes
 * 	[1998/10/28  22:04:30  Jem_Treadwell]
 * 
 * Revision 1.1.2.11  1998/10/21  20:51:46  Jem_Treadwell
 * 	Changed EvmEventI18N typedefs to EvmI18N
 * 	[1998/10/21  20:38:44  Jem_Treadwell]
 * 
 * Revision 1.1.2.10  1998/09/30  13:43:08  Jem_Treadwell
 * 	Moved these functions from evm_p.h to evm.h:
 * 	  EvmEventNameMatch
 * 	  EvmEventNameMatchStr
 * 	  EvmConnControl
 * 	  EvmEventFormatFromTemplate
 * 
 * 	Also moved some private constants to evm_p.h.
 * 	[1998/09/30  13:42:25  Jem_Treadwell]
 * 
 * Revision 1.1.2.9  1998/09/29  18:33:25  Bruce_Gayliard
 * 	Added codes for cluster info in ConnControl.
 * 	[1998/09/29  18:32:41  Bruce_Gayliard]
 * 
 * Revision 1.1.2.8  1998/09/10  13:08:58  Jem_Treadwell
 * 	Added event name macros
 * 	[1998/09/10  13:08:17  Jem_Treadwell]
 * 
 * Revision 1.1.2.7  1998/08/28  15:42:25  Bruce_Gayliard
 * 	Removed EvmConnBufSizes* functions, added EvmConnControl enums.
 * 	[1998/08/28  15:30:27  Bruce_Gayliard]
 * 
 * Revision 1.1.2.6  1998/08/21  18:05:42  Bruce_Gayliard
 * 	 	** Merge Information **
 * 		** Command used:	bsubmit -visual **
 * 		** Ancestor revision:	1.1.2.4 **
 * 		** Merge revision:	1.1.2.5 **
 * 	 	** End **
 * 	Added EvmConnControl base function.
 * 	[1998/08/21  17:48:25  Bruce_Gayliard]
 * 
 * Revision 1.1.2.5  1998/08/20  18:15:29  Jem_Treadwell
 * 	Added EvmValidateBinlogEvent
 * 	[1998/08/20  18:15:06  Jem_Treadwell]
 * 
 * Revision 1.1.2.4  1998/07/17  18:19:01  Bruce_Gayliard
 * 	Added prototypes for new match functions.
 * 	[1998/07/17  15:54:52  Bruce_Gayliard]
 * 
 * 	Added prototype for _EvmFilenameConstruct
 * 	[1998/07/15  12:14:57  Bruce_Gayliard]
 * 
 * Revision 1.1.2.3  1998/07/01  16:52:43  Bruce_Gayliard
 * 	Added functions to set and get connection buffer sizes.
 * 	[1998/07/01  15:49:19  Bruce_Gayliard]
 * 
 * Revision 1.1.2.2  1998/06/10  21:03:22  Jem_Treadwell
 * 	Initial submit
 * 	[1998/06/10  21:02:39  Jem_Treadwell]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: evm_p.h,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/12/11 15:40:40 $
 */

/*=====================================================================
 * This header file contains function prototypes and definitions for
 * "private" facilities used internally by EVM, which are not intended
 * for public use.  The interfaces for these facilities are not
 * published, and are not guaranteed to be present in future releases,
 * or to remain unchanged.
 *=====================================================================*/

#ifndef	__EVM_P_H__
#define	__EVM_P_H__

#include <evm.h>

#ifdef __cplusplus
extern "C"
{

#endif /* !defined(__cplusplus) */

/*
 * These macros should be used by system components to define
 * system event names in a vendor-neutral manner:
 */
#define _EvmSYSTEM_VENDOR	     "sys"
#define _EvmSYSTEM_PRODUCT	     "unix"
#define _EvmSYSTEM_VP	             _EvmSYSTEM_VENDOR "." _EvmSYSTEM_PRODUCT
#define _EvmSYSTEM_EVENT_NAME(x)     _EvmSYSTEM_VP "." x

#define _EvmEVM_EVENT_NAME(x)        _EvmSYSTEM_VP ".evm." x


#ifndef _KERNEL


EvmStatus_t
EvmConnProtocolVersionGet(EvmConnection_t a_conn, EvmUint16_t *a_version);

EvmStatus_t
EvmEventDataSizeGet (EvmConstEvent_t a_event, EvmSize_t * a_size);

EvmStatus_t
_EvmItemSetAutoWithContext(EvmEvent_t a_event,
                           EvmItemMask_t a_items,
                           EvmConnection_t a_conn);

EvmConstString_t
EvmItemDescription(EvmItemId_t a_itemid);

EvmStatus_t
EvmItemIdFromName(EvmConstString_t a_itemname, EvmItemId_t *a_itemid);

EvmStatus_t
EvmItemNameFromId(EvmItemId_t a_itemid, EvmConstString_t * a_name);

EvmStatus_t
EvmVarInit (struct EvmVarStruct_s   *a_var_p,
            EvmVarName_t            a_name_p,
            EvmVarType_t            a_type,
            const EvmVarValue_t     a_value,
            EvmI18NMsgId_t          a_msgId,
            EvmSize_t               a_valLen);

EvmStatus_t
EvmConnCreateStep (EvmConnectionType_t          a_type,
                   EvmResponseMode_t            a_responseMode,
                   const EvmTransport_t *       a_transport,
                   const EvmCallback_t          a_callback,
                   const EvmCallbackArg_t       a_callbackArg,
                   EvmConnection_t *            a_conn_p,
                   EvmBoolean_t                 a_stepwise,
		   EvmUint32_t *                a_cookie);

#define EvmItemCompare(e1,e2,item,same) _EvmItemCompare(e1,e2,item,0,same)
EvmStatus_t
_EvmItemCompare (EvmConstEvent_t a_event1,
		 EvmConstEvent_t a_event2,
		 EvmItemId_t a_item,
		 unsigned int a_debug,
		 EvmBoolean_t * a_same);

#define EvmVarCompare(e1,e2,name,same) _EvmItemCompare(e1,e2,name,0,same)
EvmStatus_t
_EvmVarCompare (EvmConstEvent_t a_event1,
		EvmConstEvent_t a_event2,
		EvmVarName_t a_name,
		unsigned int a_debug,
		EvmBoolean_t * a_same);

#define EvmEventCompare(e1,e2,igmsk,same) _EvmEventCompare(e1,e2,igmsk,0,same)
EvmStatus_t
_EvmEventCompare (EvmConstEvent_t a_event1,
		  EvmConstEvent_t a_event2,
		  EvmItemMask_t a_ignoreMask,
		  unsigned int a_debug,
		  EvmBoolean_t * a_same);

EvmStatus_t
_EvmItemSetAuto (EvmEvent_t a_event, EvmItemMask_t a_items);

EvmStatus_t
_EvmQueuePointerGet (EvmEvent_t a_event, EvmEvent_t *a_next);

EvmStatus_t
_EvmQueuePointerSet (EvmEvent_t a_event, EvmEvent_t a_next);

#define EvmEventMergeTemplate(a_event, a_template) \
	_evmMerge(a_event,a_template)

EvmString_t
_EvmFilenameConstruct(EvmString_t a_fileNameBase,
                      EvmInt32_t a_ident,
                      EvmPid_t a_pid);


/*==========================================================
 * Support for Binary Error Log (binlog) interpretation
 *==========================================================*/
#ifdef EVM_INCLUDE_BINLOG_SUPPORT
#include <dec/binlog/binlog.h>

EvmStatus_t
EvmBinlogEventToEvm(char *a_event, EvmEvent_t *a_evm_event);

void
EvmBinlogSCSIReporter(unsigned char * buf);

void
EvmBinlogValidateEvent(char *a_event, EvmBoolean_t *a_valid);

int
EvmBinlogEventSize(char *a_event);

EvmBoolean_t
EvmBinlogEventIsCEH(char *a_event);

#endif /* End of binlog support */


/*==========================================================
 * General constants - these could be moved
 *==========================================================*/
/*
 * Path for the local domain socket.
 * The environment variable overrides the default value.
 */
#define EvmLOCAL_PORT_DEFAULT "/var/evm/sockets/evmd"
#define EvmLOCAL_PORT_ENVVAR "EVM_LOCAL_PORT"

/*
 * Path for the daemon configuration file.
 * The environment variable overrides the default value.
 */
#define EvmDAEMON_CONFIG_DEFAULT "/etc/evmdaemon.conf"
#define EvmDAEMON_CONFIG_ENVVAR "EVM_DAEMON_CONFIGURATION"

#endif /* _KERNEL */

#ifdef _KERNEL
#ifdef _KEVM_ILP_DEBUG

void
KevmIntBufPostTest(void);

/* Trigger is number of executions after which an event is posted. */
#define KEVM_INT_POST_TEST_TRIGGER 5000

#define KEVM_INT_POST_TEST_PERIODIC 					\
{									\
   static _Static_Kevm_Int_Buf_test_count = 0;				\
									\
   if (_Static_Kevm_Int_Buf_test_count++ >= KEVM_INT_POST_TEST_TRIGGER)	\
   {									\
      _Static_Kevm_Int_Buf_test_count = 0;				\
      KevmIntBufPostTest();						\
   }									\
}

#else

#define KEVM_INT_POST_TEST_PERIODIC  

#endif
#endif


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __EVM_P_H__ */
