/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: evm_types.h,v $
 * Revision 1.1.1.1  2003/12/11 15:40:41  ajay
 * Importing Evm sources.
 *
 * Revision 1.1.1.1  2002/09/12 15:43:20  lsn
 * EVM source - Linux initial version
 *
 * Revision 1.1.15.1  2001/09/26  18:57:12  Anthony_Hoffman
 * 	redo of wildcatos submits
 *
 * Revision 1.1.13.1  2001/07/30  18:06:01  Anthony_Hoffman
 * 	wc.evm.002.portability
 *
 * Revision 1.1.9.4  1999/05/06  18:07:02  James_Woodward
 * 	steel bl23 pass 3 merge
 * 	[1999/05/06  15:18:01  James_Woodward]
 *
 * Revision 1.1.4.8  1999/03/29  20:47:27  Bruce_Gayliard
 * 	Fixes for QAR 70082 - uninit/unused vars and portability.
 * 	[1999/03/29  17:20:27  Bruce_Gayliard]
 * 
 * Revision 1.1.6.7  1999/03/29  16:28:17  Bruce_Gayliard
 * 	Fixes for QAR 70082 - various code cleanup issues.
 * 	[1999/03/29  16:19:44  Bruce_Gayliard]
 * 
 * Revision 1.1.9.3  1998/09/29  16:50:27  Andrew_Duane
 * 	 	** Merge Information **
 * 		** Command used:	bmerge -jSTEELOS_BL16:STEELOS_BL18 **
 * 		** Ancestor revision:	1.1.4.5 **
 * 		** Merge revision:	1.1.4.7 **
 * 	 	** End **
 * 	[1998/09/29  14:12:26  Andrew_Duane]
 * 
 * Revision 1.1.6.6  1998/07/24  15:47:46  Bruce_Gayliard
 * 	Build fix for kernel - can't include float.h.
 * 	[1998/07/24  15:29:45  Bruce_Gayliard]
 * 
 * Revision 1.1.9.2  1998/07/24  14:01:45  Ray_Lanza
 * 	Initial Zulu pass for __alpha conditionals
 * 	[1998/07/23  16:53:54  Ray_Lanza]
 * 
 * Revision 1.1.4.7  1998/07/22  16:08:09  Bruce_Gayliard
 * 	Build fix for kernel - can't include float.h.
 * 	[1998/07/22  15:34:47  Bruce_Gayliard]
 * 
 * Revision 1.1.4.6  1998/07/21  20:43:45  Bruce_Gayliard
 * 	EVM drop to steel BL 17 from evman shared sandbox.
 * 	[1998/07/20  20:08:31  Bruce_Gayliard]
 * 
 * Revision 1.1.6.5  1998/06/24  15:32:35  Bruce_Gayliard
 * 	Added float.h for MIN and MAX values, removed a DEFECT line (public).
 * 	[1998/06/23  19:26:25  Bruce_Gayliard]
 * 
 * Revision 1.1.4.5  1997/11/20  22:36:43  Bruce_Gayliard
 * 	BL 14 drop from EVM shared sandbox.
 * 	[1997/11/19  21:19:43  Bruce_Gayliard]
 * 
 * Revision 1.1.6.4  1997/11/06  17:27:57  Bruce_Gayliard
 * 	Fixes for QAR 56248, QAR 56576, and old code review comments.
 * 	[1997/11/06  17:26:48  Bruce_Gayliard]
 * 
 * Revision 1.1.6.3  1997/09/28  04:34:07  Bruce_Gayliard
 * 	First crack at registration queries - need more work.
 * 	[1997/09/28  04:32:01  Bruce_Gayliard]
 * 
 * Revision 1.1.6.2  1997/08/15  14:31:13  Bruce_Gayliard
 * 	Remove 128 bit stuff, add session id, new flags.
 * 	[1997/08/15  14:26:11  Bruce_Gayliard]
 * 
 * Revision 1.1.4.2  1997/05/20  13:34:04  Stuart_Hollander
 * 	Prepare to bsubmit to steel pre-bl11
 * 	[1997/05/18  18:18:06  Stuart_Hollander]
 * 
 * Revision 1.1.2.2  1997/04/14  21:08:40  Bruce_Gayliard
 * 	Initial version - split out platform dependences, evm type definitions.
 * 	[1997/04/14  21:06:46  Bruce_Gayliard]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: evm_types.h,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/12/11 15:40:41 $
 */
#ifndef	__EVM_TYPES_H__
#define	__EVM_TYPES_H__

/******************* System include files */

#include <sys/types.h> /* pid_t */

/* Can only pull in float.h in user space. */
#ifndef _KERNEL
#include <float.h> /* EVM_FLOAT_MIN, _MAX, EVM_DOUBLE_MIN, _MAX */
#endif

/******************* Application specific include files - NONE */

/******************* Global data - NONE */




/******************* Datatypes */
/******************* Constant parameters */
/******************* Macros */

/*
 * Basic types, defined by EVM for ease of portability
 */

#ifdef __arch64__

typedef	short		EvmInt16_t;
typedef	int		EvmInt32_t;
typedef	long		EvmInt64_t;
typedef	unsigned short	EvmUint16_t;
typedef	unsigned int	EvmUint32_t;
typedef	unsigned long	EvmUint64_t;

#else

typedef	short		EvmInt16_t;
typedef	int		EvmInt32_t;
typedef	unsigned short	EvmUint16_t;
typedef	unsigned int	EvmUint32_t;

/* Define 64 bit datatypes as arrays of 32 bit numbers  */
typedef signed long long EvmInt64_t;
typedef unsigned long long EvmUint64_t;

#endif /* __arch64__ */

#ifdef LINUX
#include <evm_linux.h>
#endif /* LINUX */

typedef	char		EvmChar_t;
typedef	unsigned char	EvmUint8_t;
typedef	float		EvmFloat_t;
typedef	double		EvmDouble_t;
typedef pid_t		EvmPid_t;
typedef	void		*EvmOpaque_t;
typedef	void		*EvmPointer_t;

/* Define boolean datatype as an enumerated type */
typedef	enum	EvmBoolean_e
{
	EvmFALSE = 0,
	EvmTRUE = 1
} EvmBoolean_t;

#define EVM_INT8_MIN	SCHAR_MIN
#define EVM_INT8_MAX	SCHAR_MAX
#define EVM_INT16_MIN	SHRT_MIN
#define EVM_INT16_MAX	SHRT_MAX
#define EVM_INT32_MIN	INT_MIN
#define EVM_INT32_MAX	INT_MAX
#define EVM_INT64_MIN	LONG_MIN
#define EVM_INT64_MAX	LONG_MAX
#define EVM_UINT8_MAX	UCHAR_MAX
#define EVM_UINT16_MAX	USHRT_MAX
#define EVM_UINT32_MAX	UINT_MAX
#define EVM_UINT64_MAX	ULONG_MAX
#define EVM_FLOAT_MIN	FLT_MIN
#define EVM_FLOAT_MAX	FLT_MAX
#define EVM_DOUBLE_MIN	DBL_MIN
#define EVM_DOUBLE_MAX	DBL_MAX

#endif	/* __EVM_TYPES_H__ */
