 /*D  * Copyright (c) 1982, 1986 Regents of the University of California.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedF  * provided that this notice is preserved and that due credit is givenJ  * to the University of California at Berkeley. The name of the UniversityC  * may not be used to endorse or promote products derived from this D  * software without specific prior written permission. This software=  * is provided ``as is'' without express or implied warranty.   *'  *	@(#)ip_icmp.h	7.3 (Berkeley) 12/7/87   */    /*2  * Interface Control Message Protocol Definitions.  * Per RFC 792, September 1981.   */    /*  * Structure of an icmp header.   */ 
 struct icmp { 4 	u_char	icmp_type;		/* type of message, see below */' 	u_char	icmp_code;		/* type sub code */ ; 	u_short	icmp_cksum;		/* ones complement cksum of struct */  	union {( 		u_char ih_pptr;			/* ICMP_PARAMPROB *// 		struct in_addr ih_gwaddr;	/* ICMP_REDIRECT */  		struct ih_idseq {  			n_short	icd_id; 			n_short	icd_seq; 
 		} ih_idseq;  		int ih_void; 	} icmp_hun;" #define	icmp_pptr	icmp_hun.ih_pptr& #define	icmp_gwaddr	icmp_hun.ih_gwaddr) #define	icmp_id		icmp_hun.ih_idseq.icd_id * #define	icmp_seq	icmp_hun.ih_idseq.icd_seq" #define	icmp_void	icmp_hun.ih_void 	union { 		struct id_ts { 			n_time its_otime; 			n_time its_rtime; 			n_time its_ttime;
 		} id_ts; 		struct id_ip  {  			struct ip idi_ip;) 			/* options and then 64 bits of data */ 
 		} id_ip; 		u_long	id_mask;  		char	id_data[1]; 	} icmp_dun;+ #define	icmp_otime	icmp_dun.id_ts.its_otime + #define	icmp_rtime	icmp_dun.id_ts.its_rtime + #define	icmp_ttime	icmp_dun.id_ts.its_ttime & #define	icmp_ip		icmp_dun.id_ip.idi_ip" #define	icmp_mask	icmp_dun.id_mask" #define	icmp_data	icmp_dun.id_data };   /*4  * Lower bounds on packet lengths for various types.:  * For the error advice packets must first insure that the=  * packet is large enought to contain the returned ip header. <  * Only then can we do the check to see if 64 bits of packet?  * data have been returned, since we need to check the returned   * ip header length.  */ * #define	ICMP_MINLEN	8				/* abs minimum */< #define	ICMP_TSLEN	(8 + 3 * sizeof (n_time))	/* timestamp */- #define	ICMP_MASKLEN	12				/* address mask */ = #define	ICMP_ADVLENMIN	(8 + sizeof (struct ip) + 8)	/* min */ : #define	ICMP_ADVLEN(p)	(8 + ((p)->icmp_ip.ip_hl << 2) + 8)2 	/* N.B.: must separately check that ip_hl >= 5 */   /*,  * Definition of type and code field values.  */ + #define	ICMP_ECHOREPLY		0		/* echo reply */ 7 #define	ICMP_UNREACH		3		/* dest unreachable, codes: */ * #define		ICMP_UNREACH_NET	0		/* bad net */, #define		ICMP_UNREACH_HOST	1		/* bad host */4 #define		ICMP_UNREACH_PROTOCOL	2		/* bad protocol */, #define		ICMP_UNREACH_PORT	3		/* bad port */9 #define		ICMP_UNREACH_NEEDFRAG	4		/* IP_DF caused drop */ 7 #define		ICMP_UNREACH_SRCFAIL	5		/* src route failed */ 9 #define	ICMP_SOURCEQUENCH	4		/* packet lost, slow down */ 5 #define	ICMP_REDIRECT		5		/* shorter route, codes: */ / #define		ICMP_REDIRECT_NET	0		/* for network */ - #define		ICMP_REDIRECT_HOST	1		/* for host */ 6 #define		ICMP_REDIRECT_TOSNET	2		/* for tos and net */8 #define		ICMP_REDIRECT_TOSHOST	3		/* for tos and host */( #define	ICMP_ECHO		8		/* echo service */5 #define	ICMP_TIMXCEED		11		/* time exceeded, code: */ 9 #define		ICMP_TIMXCEED_INTRANS	0		/* ttl==0 in transit */ 5 #define		ICMP_TIMXCEED_REASS	1		/* ttl==0 in reass */ / #define	ICMP_PARAMPROB		12		/* ip header bad */ 0 #define	ICMP_TSTAMP		13		/* timestamp request */2 #define	ICMP_TSTAMPREPLY	14		/* timestamp reply */0 #define	ICMP_IREQ		15		/* information request */3 #define	ICMP_IREQREPLY		16		/* information reply */ 4 #define	ICMP_MASKREQ		17		/* address mask request */4 #define	ICMP_MASKREPLY		18		/* address mask reply */   #define	ICMP_MAXTYPE		18   #define	ICMP_INFOTYPE(type) \ 6 	((type) == ICMP_ECHOREPLY || (type) == ICMP_ECHO || \9 	(type) == ICMP_TSTAMP || (type) == ICMP_TSTAMPREPLY || \ 5 	(type) == ICMP_IREQ || (type) == ICMP_IREQREPLY || \ 4 	(type) == ICMP_MASKREQ || (type) == ICMP_MASKREPLY)