/*
 * Prototypes for fast_utc routines.
 */
#include <time.h>

int futc_initialize ( int apply_default_dst );
time_t futc_local_to_gmt ( time_t local_time );
time_t futc_current_time ( time_t *gmt_time );
int futc_decode_vms_date ( int length, char *date_time, time_t *gmt_time );
int futc_vms_time ( time_t unix_time, long vms_time[2] );
/*
 * The futc_time_cache function saves a string associated with a specific
 * in a caller-supplied static structure (initialized to FUTC_TCACHE_INIT)
 * or returns the previously.  It's intended use to optimize time encoding
 * where the same time_t value (i.e. current time) may be encoded repeatedly.
 */
typedef struct { char *value; time_t time; int vlen; } futc_tcache;
#define FUTC_TCACHE_INIT { (char *) 0, (time_t) 0, 0 }
int futc_test_cache ( time_t cand_time, 
	char *buffer, int bufsize, futc_tcache *cache );
int futc_update_cache ( time_t new_time, char *buffer, int bufsize,
	futc_tcache *cache );
