/*
 * routines for efficient processing of HTTP request headers.  The session
 * control block (SCB) contains a req_atom array that assigns a unique code 
 * in the range 1-31 for each header line in the request array that indicates 
 * the header type (accept, connection, etc).  Atom number zero is reserved 
 * an is used to mark the end of the req_atom array.  Other pre-defined atoms 
 * are:
 *    HDR_ATOM_CONTINUE		Header line is a continuation line.
 *    HDR_ATOM_OTHER		Header label does not match known atoms.
 *
 * The req_atom_summary member of the SCB contains a bit for each atom present
 * in the request header.  Bit zero must be set for the summary mask to be
 * valid, indicating the header has been scanned by http_scan_headers.
 *
 * String comparisons are always case-insensitive.
 */
#define HDR_ATOM_CONTINUE 2
#define HDR_ATOM_OTHER 1
/*
 * Define structure to hold atom values for common HTTP request headers.
 */
struct {
    int accept;
    int connection;
    int content_length;
    int content_type;
    int host;
    int if_modified_since;
    int authorization;
    int from;
    int range;
    int referer;
    int user_agent;
    int accept_encoding;
    int accept_language;
/*  int proxy_authorization
    int max_forwards */

    int allow;
    int content_base;
    int content_encoding;
    int content_language;
    int content_location;
    int content_MD5;
    int content_range;
    int expires;
    int last_modified;
    int title;
    int transfer_encoding;
    int extension_header;
} http_std_atoms;
struct {
    long accept;
    long connection;
    long content_length;
    long content_type;
    long host;
    long if_modified_since;
    long authorization;
    long from;
    long range;
    long referer;
    long user_agent;
    long accept_encoding;
    long accept_language;
/*  long proxy_authorization
    long max_forwards */

    long allow;
    long content_base;
    long content_encoding;
    long content_language;
    long content_location;
    long content_MD5;
    long content_range;
    long expires;
    long last_modified;
    long title;
    long transfer_encoding;
    long extension_header;
} http_std_amask;
int http_init_standard_atoms();
/*
 * Return value is atom number or -1.  Duplicate creates are allowed, returning
 * the existing atom number.
 */
int http_create_atom ( char *label, long *mask );	/* return atom value */
/*
 * Inhibit prototypes below if session.h not included.
 */
#ifdef SCB_TYPEDEF
int http_summarize_headers ( SCB_TYPEDEF scb );
int http_extract_header ( int atom, SCB_TYPEDEF scb, char *buffer,
	int bufsize, int *length );
int http_extract_header_lines ( int atom, SCB_TYPEDEF scb, char *buffer,
	int bufsize, int *length );
#endif
