#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

int main ( int argc, char **argv )
{
    struct timespec delta, abstime;
    int status, LIB$SUB_TIMES();
    long time1[2], time2[2], time3[2];
    pthread_mutex_t mut;
    pthread_cond_t cond;

    time1[0] = 0; time1[1] = 12342871;
    time2[0] = 0; time2[1] = 0;
    status = LIB$SUB_TIMES ( time1, time2, time3 );
    printf("Time difference status: %d, %d %d\n", status, time3[0], time3[1] );

    if ( argc < 2 ) exit(20);
    if ( argc > 2 ) {
	time_t test_time;
	test_time = (time_t) atoi ( argv[2] );
	printf("arg[2] convert: %s\n", ctime(&test_time)  );
    }

    pthread_mutex_init ( &mut, pthread_mutexattr_default );
    pthread_cond_init ( &cond, pthread_condattr_default );

    delta.tv_sec = atoi(argv[1]);
    delta.tv_nsec = 0;

    status = pthread_get_expiration_np ( &delta, &abstime );
    printf("Status of get exp: %d, abstime: %d %d\n", status,
	abstime.tv_sec, abstime.tv_nsec );

    printf("Reconvert: %s\n", ctime(&abstime.tv_sec) );

    pthread_mutex_lock ( &mut );
    status = pthread_cond_timedwait ( &cond, &mut, &abstime );
    printf("Status of timedwait: %d\n", status );
}
