c  Job_Daemon.for  - v2.01   SysBRC     2-Apr-1997
c  Changes to make the daemon a little more flexable in case a fortran
c  compiler is unavailable at sites that wish to run the daemon.
c
c  - Use a logical name to point to the daemon's input data file, update
c    the startup com-file to reflect this.
c  - Increase the job array size to 25.
c
c  Job_Daemon.for  - v2.0    SysBRC    14-Mar-1997
c
c  Abstract
c  This daemon will periodically look for the presence of certain files on
c  disk, if those 'trigger' files are found then specific batch jobs are 
c  enqueued for given userids. It is presumed that the batch jobs will remove
c  the trigger files.
c
c  This allows for 'on demand' processing without running needless batch jobs
c  or multiple daemons or other initiating processes.
c
c  If continuous processing is desired it is more efficient to have the
c  batch jobs either run continuously or resubmit themselves (or run as
c  detached jobs - perhaps under a CLI).
c
c  The job queue is sized for 25 jobs.
c  The daemon cycle time is set to 300 seconds.
c
c  Privileges:
c
c  You will need to be able to "find" the trigger files on disk, either by
c  having the files and paths to the files readable (W:E) or by having the
c  enough privs to read down the path (group may do, in the general case you
c  may want sysprv).
c
c  If submitting jobs for usernames other than the one the daemon runs
c  under you will need to start the Daemon with CMKRNL.
c
c  Origin: generalized version of PRTSRVD.For by SysBRC
c
c  Data file format:
c  -----------------
c  Each job in the data input file must be separated by at least one
c  comment line. The comment indicator is the asterisks (*).
c
c  The Input data file must being with a comment line.
c  
c  Each valid job will have 4 required data lines in the input file, the
c  fifth data line is optional. The data lines must be contiguous.
c
c  The data file is case-insensitive.
c  The options may appear in either order and are independent of one another.
c  The DELAY value is integral and is a value in MINUTES.
c  White space between the DELAY keyword and its value are NOT allowed.
c  In line comments are not permitted.
c
c  An invalid input file may cause the daemon to exit.
c
c  The five data lines are:
c       * comment line
c       1) userid               [USERNAME]
c       2) name of batch queue  [QUEUE]
c       3) file to search for   [TRIGGER_FILE]
c       4) file to submit       [BATCH_FILE]
c       5) options (optional)   PRINT DELAY=nn
c
c Sample input data file:
c       * comment line(s) at start of data file
c       * Submit for user ADDUSER the com-file STAFF:[ADDUSER]NEW-USER.COM
c       * to the queue OPER$BATCH if the file STAFF:[ADDUSER]NEWUSERS.DAT is
c       * found on disk. Further, PRINT the batch log file and do NOT submit
c       * jobs more frequently than every 60 minutes even if data is available
c       * more frequently.
c       adduser
c       oper$batch
c       staff:[adduser]newusers.dat
c       staff:[adduser]new-user.com
c       print delay=60
c       * comments between first and second entry
c       * Submit for user LASER the com-file STAFF:[LASER]LASER-PROCESSING.COM
c       * to the queue OPER$BATCH if the file SPOOL_DISK:[LASER]*C.DAT is
c       * found on disk. Since no options are present the job will be queued
c       * with the item code SJC$_NO_LOG_SPOOL, equivalent to SUBMIT/NOPRINT,
c       * a new batch job will be submitted as frequently as the daemon cycles
c       * if a trigger file is found.
c       adduser
c       oper$batch
c       staff:[laser]*c.dat
c       staff:[laser]laser-processing.com
c       * comments between second and third entry
c
c  v1.0    SysEER    12-Jul-1993
c  Ellen E Rothman Cuttler coded original version.
c
c  v2.0    SysBRC    14-Mar-1997
c  Add 5th input line for option. Modify job record structure to support
c  new fields, print_flag, delay_time, delay_countdown.
c
c  Invalid or unrecognized parameters or values will cause warnings to be
c  issued but will result in correct default behavior (NoPrint, NoDelay).
c
c--------------------------------------------------------------------------
c  Author's information
c
c   Brian R Cuttler              |  phone   518-442-3906  fax  518-442-3697
c   VMS System Manager           |  email   sysbrc@cnsvax.albany.edu
c   State Univ of NY at Albany   |  url     http://www.albany.edu/~sysbrc
c   Albany, NY 12222
c--------------------------------------------------------------------------

        implicit none

        include    '($ssdef)'
        include    '($rmsdef)'
        include    '($sjcdef)'
        include    '($syssrvnam)'

c  Define item list structure for $sndjbc call
        structure        /itmlst/
          union
            map
              integer*2 buflen, itmcod
              integer*4 bufadr, retadr
            end map
            map
              integer*4 end_list
            end map
          end union
        end structure

c  Define structure to hold list of jobs, trigger and user information
c  Given the about description of the first 4 data lines there is little
c  interesting to add here.
c  The "print_flag" is a binary field that indicates the presence of the 
c  PRINT option. If "print_flag" is set than when we load the $sndjbcw call
c  we will clear the item code that controls batch log printing.
c  The "delay_time" stores the minimum amount of time that between batch
c  job submissions. The value is in SECONDS.
c  The "delay_countdown" is the time since last batch job submission. The
c  value is in SECONDS and is decremented by the daemon cycle interval.
        structure        /joblst/
            character*12  username
            character*20  queue
            character*80  trigger_file
            character*80  batch_file
            integer*4     delay_time, delay_countdown, print_flag
        end structure

c  Define I/O status block structure used by the $sndjbcw call.
        structure /iosblk/
          integer*4 sts, zeroed
        end structure

c  Define variables
c  "Sleeptime" is a 'real' and is in seconds as required by lib$wait
c  "Ret_Stat" is the return value/status of system calls
c  "i" is an index to loops - specifically the list of jobs to look for
c  "entry_number" is the job entry number of submitted batch jobs
c  "job_count" is the number of jobs listed in the data file
c  "date_addr" is the system date in dd-mmm-yy format
c  "time_addr" is the system time in hh:mm:ss format
c  "data_file" is the input file containing the list of jobs to manage
c  "found_file" is a flag indicating whether a 'trigger' file was found
c  "delimiter" is a separator and comment indicator in the data file
c  "version" is the current version level of this program
c  "index*" as used as indices for parsing the OPTIONS string.
c  "options" (optional) fifth line of input data

        real*4          sleeptime /300.0/
        integer*4       ret_stat, entry_number, job_index,
     &                  lib$wait, lib$find_file, lib$find_file_end, 
     &                  lib$cvt_dtb, cont /0/, job_count /0/, for$rab,
     &                  index1, index2, delay
        character*4     version
        character*9     date_addr, time_addr
        character*80    data_file, found_file, delimiter, options

        data    version     /'2.01'/
        data    data_file   /'job_daemon_input_data'/

c  Create item lists records for I/O status block and $sndjbcw call,
c  only one item list of each type is needed.
c  Also create an array of data records, one record for each job that
c  the daemon may be asked to handle.
        record  /itmlst/ s(6)
        record  /iosblk/ iosb
        record  /joblst/ job(25)   ! accepting up to 25 jobs

1       format(a)

c  Fill data block for $sndjbcw call, we will use an enter_file operation
c  and submit the job for another user.  We will also /NoPrint the log file
c  and retrieve the job entry number.
c  Load only static values, values that will need to be updated for each
c  call (such as command file name or queue name) will be filled in later).

        s(1).buflen = 20
        s(1).itmcod = sjc$_queue
c        s(1).bufadr = %loc(queue)             ! fill in later
        s(1).retadr = 0
        s(2).buflen = 80
        s(2).itmcod = sjc$_file_specification
c        s(2).bufadr = %loc(batch_file)        ! fill in later
        s(2).retadr = 0
        s(3).buflen = 4
        s(3).itmcod = sjc$_entry_number_output
        s(3).bufadr = %loc(entry_number)
        s(3).retadr = 0
        s(4).buflen = 12
        s(4).itmcod = sjc$_username
c        s(4).bufadr = %loc(username)          ! fill in later
        s(4).retadr = 0
        s(5).buflen = 0
c        s(5).itmcod = sjc$_No_Log_Spool       ! fill in later
        s(5).bufadr = 0
        s(5).retadr = 0
        s(6).end_list = 0

c  Get the system DATE and TIME [built-in FORTRAN functions]
c  Log the Daemon version, and startup time in the Log file [Sys$Output]
        Call DATE (date_addr)
        Call TIME (time_addr)
        Write (6,6) 
        Write (6,2) version
        Write (6,4) date_addr, time_addr
        Write (6,5) sleeptime
        Write (6,6)
        Write (6,108)
        Write (6,108)

c These 'Format' statements have a total output length of 49 chars
2       Format (4x,'*********',3x,'JOB_DAEMON ', 
     &          'version ',A4' *********')
4       Format (4x,'*****',3x,' Started ',A9,3x,A8,3x,'*****')
5       Format (4x,'***',1x,' Daemon cycle time is ',
     &          F6.0,1x,'seconds.',1x,'***')
6       Format (4x,'*********************************************')

c  Open the input data file, load the job list array.
        Open (10, file=data_file, status='OLD',
     &        Organization='SEQUENTIAL', Form='FORMATTED',
     &        CarriageControl='LIST',
     &        ReadOnly, Err=900)

c  The 'comment' delimiter is the asterisk [*].
c  At least one delimiter MUST appear between entries in the data file.
c  although several can be used to demark comments.
c  The first line of the data file MUST be an asterisk.
c  Trailing comment delimiter is optional.

c  First, make sure the data file begins with a delimiter
        Read(10, 1, End=20)  delimiter
        If (delimiter(1:1) .NE. '*') Then
           Goto 905
        EndIf

c  Handle multiple comment delimiters between entries.
c  Read job entries into memory
10      Read(10, 1, End=20)  delimiter
        If (delimiter(1:1) .NE. '*') Then
           job_count = job_count + 1
           job(job_count).username = delimiter
           Call str$upcase(job(job_count).username,
     &                    job(job_count).username)
           Read(10, 1, End=910)  job(job_count).queue
           Call str$upcase(job(job_count).queue,job(job_count).queue)
           Read(10, 1, End=910)  job(job_count).trigger_file
           Call str$upcase(job(job_count).trigger_file,
     &                  job(job_count).trigger_file)
           Read(10, 1, End=910)  job(job_count).batch_file
           Call str$upcase(job(job_count).batch_file,
     &                  job(job_count).batch_file)

c  Set the default values for the options.
c  NoPrint, No delay between print jobs, even if a delay is specified 
c  do not cause a delay if a trigger file is found on daemon startup.

           job(job_count).print_flag = 0
           job(job_count).delay_time = 0
           job(job_count).delay_countdown = 0

c  Check for options 5th data line, If found check for parameters and values.
c  If line is not found, either delimiter or end_of_file then proceed normally.

           Read(10, 1, End=11)  options
           If (options(1:1) .NE. '*') Then
              Call str$upcase(options, options)

c  Set the job record's print_flag if the PRINT option is found (index to
c  substring is NON-ZERO).

              index1 = index(options, 'PRINT')
              If (index1 .NE. 0) job(job_count).print_flag = 1

c  If the DELAY option is found get the value of the parameter, (string, 
c  integer in MINUTES).
c
c  If the value is a valid string store it as DELAY_TIME in the job record.
c
c  If the option is missing or invalid leave the default value of 0 but
c  print a warning to the output file.
c
c  lib$cvt_dtb fails (returns 0) if the string input value is not an integer
c  or contains white space.
c
c  Convert the value to SECONDS from MINUTES since the daemon cycle time
c  is in seconds and may not be in multiples 60.
c
              index1 = index(options, 'DELAY=')
              If (index1 .NE. 0) then
                 index2 = index(options(index1:), ' ')
                 index2 = index1 + index2 - 2
                 ret_stat = lib$cvt_dtb( %val(index2-index1-5),
     &                          %ref(options(index1+6:index2)),
     &                          %ref(delay) )
                 If (ret_stat .EQ. 1) then
                       job(job_count).delay_time = delay * 60
                    Else
                       write(6,88)
                       write(6,108)
                 EndIf
              EndIf  ! end parsing for DELAY parameter

           EndIf ! end parsing for OPTIONAL data line

c  Put an entry in the Log [sys$output] for each job in the data file
11         Call DATE (date_addr)
           Call TIME (time_addr)
           Write (6,12) job_count, date_addr, time_addr 
           Write (6,14) job(job_count).username
           If (job(job_count).print_flag .EQ. 1) then
                 Write (6,7)
              Else
                 Write (6,8)
           EndIf
           Write (6,9) job(job_count).delay_time
           Write (6,16) job(job_count).queue
           Write (6,18) job(job_count).batch_file
           Write (6,*) ' '

12         Format (' JOB_DAEMON: Job #',I2,':',3x,A9,'  ',A8)
14         Format (' -Submit job with username ', A10)
16         Format (' -Use Batch Queue ', A20)
18         Format (' -Command Procedure is ', A64)
7          Format (' -Batch log file is PRINTED.')
8          Format (' -Batch log is stored on disk.')
9          Format (' -Job Delay time is ', I, ' seconds.')
88         Format (' ERR: Invalid DELAY value, using value of zero (0)')

c  Make sure there is a delimiter between entries in the data file
           Read(10, 1, End=20)  delimiter
           If (delimiter(1:1) .NE. '*') Then
              Goto 915      
           EndIf
        EndIf
        Goto 10

20      Close(10)

c  Log the total number of jobs found in data file - make sure we don't
c  exceed the maximum number of allowed job entries. [size of job array]
c  Make sure we aren't running on an empty data file.

        Write (6,22) job_count
        Write (6,108)
        Write (6,6)
        Write (6,6)
        Write (6,108)

        If ((job_count .eq. 0) .or. (job_count .gt. 10)) then 
           Goto 920
        EndIf

22      Format (' JOB_DAEMON: Total of ',I2,' jobs found')
102     Format (' JOB_DAEMON:',3x,A9,2x,A8,' -- ',
     &                     'JOB #',I2,' user ',A10)
106     Format ('    *** Submitted ENTRY number ',I6)
108     Format (x)
109     Format (4x,'Delayed pending timer, time remaining ',
     &             I, ' (seconds)')

c  Decrement the wait timer for each job on each pass of the daemon.
c
c  Search for trigger files.
c  If trigger is found than check the delay_countdown of the job, if the 
c  countdown is 0 than load job dependant data into $sndjbcw item list
c  and enqueue the job, also reset the countdown timer so we wait a while
c  before trying to submit the job again.
c
c  While we could skip the search for the trigger file if the delay_countdown
c  is not expired, I thought it would be revealing if we informed the user
c  of the presence of the trigger file rather than ignoring it.

100     Do While (.True.)
           Do  job_index = 1, job_count

c  decrement count down timer by daemon sleep interval

              If (job(job_index).delay_countdown .GT. 0)
     &           job(job_index).delay_countdown = 
     &              job(job_index).delay_countdown - sleeptime

c  search for trigger file
              ret_stat = lib$find_file( job(job_index).trigger_file,
     &                          found_file, %ref(cont), , , , )

c  if found write to log file
              If (ret_stat .EQ. RMS$_Normal) Then
                   Call DATE (date_addr)
                   Call TIME (time_addr)
                   Write (6,102) date_addr, time_addr, job_index, 
     &                           job(job_index).username

c  If delay timer has expired then load item codes for:
c      Printing
c      command procedure name
c      queue name
c      userid to submit job under
c
c  Return item code will capture batch job entry number.

c  If delay timer not expired log remaining time to output.

                   If (job(job_index).delay_countdown .LE. 0) then
                         job(job_index).delay_countdown = 
     &                           job(job_index).delay_time

                         If (job(job_index).print_flag .EQ. 1) then
                               s(5).itmcod = 0
                            Else
                               s(5).itmcod = sjc$_No_Log_Spool
                         EndIf

                         s(1).bufadr = %loc( job(job_index).queue )
                         s(2).bufadr = %loc( job(job_index).batch_file )
                         s(4).bufadr = %loc( job(job_index).username )

                         ret_stat = sys$sndjbcw( , 
     &                                  %val(sjc$_enter_file), ,
     &                                  s, iosb,,)
                         If ((.NOT. ret_stat) .OR. 
     &                                     (.NOT. iosb.sts)) Then
                               Call lib$signal(%val(ret_stat))
                               Call lib$signal(%val(iosb.sts))
                            Else
                               Write (6,106) entry_number
                         EndIf
                      Else
                         Write (6,109) job(job_index).delay_countdown 
                   EndIf                   
                   Write (6,108)
              EndIf

c  Lib$Find_File_End dissolves the search_context and re-sets 'cont'
c  to 0; so it will have correct value for next call to Lib$find_file.

                ret_stat = lib$find_file_end(%ref(cont))

           EndDo

c  Flush the output buffers for the log file, this way we will be able
c  to actually read the output as it become current.

        ret_stat = sys$flush(%val(for$rab(6)))
        If (.NOT. ret_stat) Call lib$signal(%val(ret_stat))

c  Wait specified time.
        ret_stat = lib$wait(sleeptime)

        EndDo

c =========================================================================
c -------->     E R R O R   a n d   E X I T   M e s s a g e s     <--------
c =========================================================================

900     Write (6,*) ' JOB_DAEMON: Error Opening input file.'
        Goto 925

905     Write (6,*) ' JOB_DAEMON: Bad input file format'
        Write (6,*) '    - must begin with a delimiter [*]'
        Goto 925

910     Write (6,*) ' JOB_DAEMON: Error Reading input file.'
        Write (6,*) '    - Data may be corrupt'
        Goto 925

915     Write (6,*) ' JOB_DAEMON: Bad input file format'
        Write (6,*) '    - must use delimiter [*] between entries'
        Goto 925

920     Write (6,*) ' JOB_DAEMON: Error in data file'
        Write (6,*) '    - invalid # of jobs found: ',job_count 
        Goto 925

925     STOP 'JOB-DAEMON-F-ABORT, Job_Daemon aborting'

999     End
