J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CMPDIR              %%   \ @  *                %% |          utility.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module utility VERSION   #include <stdio.h> #include <clidef.h>  #include <climsgdef.h> #include <ctype.h> #include <descrip.h> #include <prvdef.h>  #include <ssdef.h> #include <string.h>  #include <stdlib.h> A #include <rms.h>                /* Include the RMS definitions */      globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;    #ifdef __ALPHA #define ARCH 1 #else  #define ARCH 0 #endif  H #define JPI$_CURPRIV 1024           /* current process privilege mask */   #define BACKUP 1 #define CREATE 2 #define EXPIRE 4 #define REVISE 8   #define DATEERROR 1  #define SIZEERROR 2 C #define BOTHERROR 3             /* both date and size mismatches */    typedef struct {     unsigned char FileName[80];  } FILE_LST;    struct FAB Fab;  struct NAM Nam;   D extern FILE_LST *ListPtr1;          /* file pointer for FileList1 */D extern FILE_LST *ListPtr2;          /* file pointer for FileList2 */  F extern int DateMode;                /* type of date info to compare */H extern int MaxPtr1;                 /* addr of last slot in FileList1 */H extern int MaxPtr2;                 /* addr of last slot in FileList2 */ extern int status;  @ extern short DateErr;               /* total date diff errors */K extern short DateFlg;               /* specifies the date value to check */ D extern short DtFlg;                 /* specifies TT: is a DecTerm */M extern short ErrStat;               /* mismatch of target date and/or size */ I extern short OutFlg;                /* image output directed to a file */ @ extern short SizeErr;               /* total size diff errors */N extern short SizeFlg;               /* specifies if file sizes are compared */  F extern char BoldOff[16];            /* esc string to disable hilite */E extern char BoldOn[16];             /* esc string to enable hilite */ M extern char CmdVerb[32];            /* foreign command invoking this image */ E extern char DirPath1[64];           /* input file from cmd line P1 */ E extern char DirPath2[64];           /* input file from cmd line P2 */  extern char OutFile[80];   extern int CheckPrv(); extern int lib$get_input();  extern void ShowHelp();  extern void ShowVers();    extern FILE *outfp;    globalvalue CMPDIR_CLD;     J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: FormatHiliteE  * Description: Check if current terminal device is a DecTerm. If so, C  *              compare discrepencies will be highlited in specific C  *              colors rather than conventional bold highlite for a :  *              non-decterm display. DecTerm error colors:6  *                      Red - both date and size error.  *                     Cyan - size match error.  *                   Yellow - date match error  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int FormatHilite() { 3     int     jpicode = 797;      /* JPI$_TERMINAL */ :     short   termlen = 0;        /* terminal name length */:     char    termdev[20];        /* terminal device name */  "     $DESCRIPTOR(DscTerm, termdev);  /         /* get invoking terminal device name */   ?     status = lib$getjpi(&jpicode, 0, 0, 0, &DscTerm, &termlen); .     if(status != SS$_NORMAL) lib$stop(status);     termdev[termlen] = 0; )     if(strncmp(termdev, "FTA", 3) == 0) { ;         DtFlg = TRUE;       /* indicate we are a DecTerm */          switch((int)ErrStat) {D             case DATEERROR: /* if only date err, hilite is YELLOW */.                 strcpy(BoldOn, "\033[49;33m");/                 strcpy(BoldOff, "\033[49;30m");                  break;B             case SIZEERROR: /* if only size err, hilite is CYAN */.                 strcpy(BoldOn, "\033[49;36m");/                 strcpy(BoldOff, "\033[49;30m");                  break;F             case BOTHERROR: /* if both date and size error, use RED */.                 strcpy(BoldOn, "\033[49;31m");/                 strcpy(BoldOff, "\033[49;30m");                  break;	         }      } E     else {      /* not a decterm, use conventional bold for hilite */ "         strcpy(BoldOn, "\033[1m");#         strcpy(BoldOff, "\033[0m");      }      return(SS$_NORMAL);    }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckFilePath G  * Description: CheckFilePath parses the passed pathname for validity.  H  *              If the path is valid, we return RMS$_NORMAL, else returnD  *              status value from SYS$PARSE/SYS$SEARCH. This routine&  *              is probably redundant.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ ! int CheckFilePath(char *FilePath)  {      int status; I     char ps_rsa[NAM$C_MAXRSS];      /* parse/search resultant filename */ I     char ps_esa[NAM$C_MAXRSS];      /* parse/search expanded  filename */   -         /* initialize Fab & Nam structures */        Fab = cc$rms_fab; 6     Fab.fab$l_fna = FilePath;       /* name of file */%     Fab.fab$b_fns = strlen(FilePath); C     Fab.fab$l_nam = &Nam;           /* FAB has an associated NAM */ >     Nam = cc$rms_nam;               /* (currently not used) */;     Nam.nam$l_esa = &ps_esa;        /* expanded filespec */ #     Nam.nam$b_ess = sizeof(ps_esa); <     Nam.nam$l_rsa = &ps_rsa;        /* resultant filespec */#     Nam.nam$b_rss = sizeof(ps_rsa);   5         /* perform sys$parse and sys$search on Fab */        status = sys$parse(&Fab); -     if(status != RMS$_NORMAL) return(status);      status = sys$search(&Fab);-     if(status != RMS$_NORMAL) return(status);      return(RMS$_NORMAL); }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckPrv C  * Description: Verify user running this image has sufficient privs F  *              to access any file on system in read mode. Currently, A  *              READALL will permit all necessary access. If priv ?  *              not available then exit with nopriv error code. D  *              (Note: on VAX we use BYPASS, as READALL not in CRTL)  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckPrv() {      int enabflg = 1;     int prmflg = 0;      int PrvStat;     int PrivMask1 = 0;     int PrivMask2 = 0;     int CurPriv[2] = 0;   @     struct  {short len, code; int *bufadr, *retlen;} JpiItem[2];  %     JpiItem[0].len = sizeof(CurPriv); #     JpiItem[0].code = JPI$_CURPRIV; !     JpiItem[0].bufadr = &CurPriv;      JpiItem[0].retlen = 0;     JpiItem[1].len = 0;      JpiItem[1].code = 0;   #ifdef __ALPHA     PrivMask2 |= PRV$M_READALL;      PrivMask1 |= PRV$M_SETPRV;6     PrvStat = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);,     if(PrvStat != SS$_NORMAL) exit(PrvStat);A     if((CurPriv[0] & PrivMask2) == PrivMask2) return(SS$_NORMAL);       if(PrivMask1 & CurPriv[0]) {5         CurPriv[0] |= (PRV$M_SETPRV + PRV$M_READALL); ;         PrvStat = sys$setprv(enabflg, &CurPriv, prmflg, 0);          return(PrvStat);     }  #else   /* else is VAX */      PrivMask2 |= PRV$M_BYPASS;     PrivMask1 |= PRV$M_SETPRV;6     PrvStat = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);,     if(PrvStat != SS$_NORMAL) exit(PrvStat);A     if((CurPriv[0] & PrivMask2) == PrivMask2) return(SS$_NORMAL);       if(PrivMask1 & CurPriv[0]) {4         CurPriv[0] |= (PRV$M_SETPRV + PRV$M_BYPASS);;         PrvStat = sys$setprv(enabflg, &CurPriv, prmflg, 0);          return(PrvStat);     }  #endif     return(SS$_NOPRIV);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetCliInfo F  * Description: check for parameters and qualifiers which were enteredJ  *              at the command line. If values are required, verify syntax-  *              and set respective variables.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetCliInfo()  { @     char Buffer[80];               /* temporary string buffer */:     char CliStr[80];               /* cli string buffer */I     char CmdLine[132];             /* buffer reflecting input cmd line */      char LineBuf[132];  E     int CliStat;                   /* return status from cli calls */        short BufLen; D     short CliStrLen;               /* integer for cli value sizes */     short CmdLen;   F     $DESCRIPTOR(DscCli, CliStr);   /* cli param or qualifier string */I     $DESCRIPTOR(DscBuf, Buffer);   /* string returned by cli$get_value */ "     $DESCRIPTOR(DscLbuf, LineBuf);!     $DESCRIPTOR(DscCmd, CmdLine); !     $DESCRIPTOR(DscOut, OutFile);      G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */  6     CliStat = lib$get_foreign(&DscCmd, 0, &CmdLen, 0);,     if(CliStat != SS$_NORMAL) exit(CliStat);     CmdLine[CmdLen] = '\0';      strcpy(LineBuf, "CMPDIR ");      strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); G     CliStat = cli$dcl_parse(&DscLbuf, CMPDIR_CLD, lib$get_input, 0, 0); -     if(CliStat != CLI$_NORMAL) exit(CliStat);   >         /* check for presence of HELP or VERSION qualifiers */       strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();        strcpy(CliStr,"HELP");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();   &         /* check for DATE qualifier */       strcpy(CliStr,"DATE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0';              DateFlg = TRUE; A             if(strncmp(Buffer, "BA", 2) == 0) DateMode |= BACKUP; A             if(strncmp(Buffer, "CR", 2) == 0) DateMode |= CREATE; A             if(strncmp(Buffer, "EX", 2) == 0) DateMode |= EXPIRE; A             if(strncmp(Buffer, "RE", 2) == 0) DateMode |= REVISE; 	         }      }   &         /* check for SIZE qualifier */       strcpy(CliStr,"SIZE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); /     if(CliStat == CLI$_PRESENT) SizeFlg = TRUE;   (         /* check for OUTPUT qualifier */       strcpy(CliStr, "OUTPUT"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscOut, &CliStrLen);#         if(CliStat == SS$_NORMAL) { &             OutFile[CliStrLen] = '\0';             OutFlg = TRUE;	         }          else {5             sprintf(OutFile, "%s_DIFF.LST", CmdVerb);              OutFlg = TRUE;	         }      } %     else strcpy(OutFile, ctermid(0));       outfp = fopen(OutFile,"w+");C     if(!outfp) exit(0x1852C);   /* RMS-F-FNM, error in file name */   3         /* get filepath info for PATH1 and PATH2 */        strcpy(CliStr,"PATH1"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; D             strcpy(DirPath1, Buffer);    /* input path to compare */	         }      } @     else {          /* Filepath not specified on command line */         exit(0x381F0);H     }    /* %CLI-W-ABSENT, entity or value absent from command string */       strcpy(CliStr,"PATH2"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; D             strcpy(DirPath2, Buffer);    /* input path to compare */	         }      } @     else {          /* Filepath not specified on command line */         exit(0x381F0);H     }    /* %CLI-W-ABSENT, entity or value absent from command string */   }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setN  *              length to -1 and return SS$_BUFFEROVF. Eelse return SS$_NORMAL  *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */       short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */       int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */   D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */  =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */  8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr; 0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */  A         /* here we use recall allocation to determine the size of B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;  B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */       if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */*         else {             *length = -1;%"             return(SS$_BUFFEROVF);	         }_     }_2     else *length = *Sptr;       /*  8 bit value */  C         /* get buffer length and copy cmd line to callers buffer */        Sptr -= *length;!     strncpy(Dptr, Sptr, *length);|     return(SS$_NORMAL);4 }          J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *   *    Function: CompareFilenamesH  * Description: The filenames pointed to by ListPtr1 and ListPtr2 may beF  *              the same filename with different file version numbers.J  *              Compare the two filenames without version numbers, if they?  *              differ, return FALSE. If the same, return TRUE.*  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */o int CompareFilenames() {s     int SflStat;     char fname1[80];     char fname2[80];     char *ptr = 0;       strcpy(fname1, ListPtr1);      strcpy(fname2, ListPtr2);      ptr = strchr(fname1, ';');     if(ptr) *ptr = 0;      ptr = strchr(fname2, ';');     if(ptr) *ptr = 0;u%     SflStat = strcmp(fname1, fname2);s     if(!SflStat) return(TRUE);     else  return(FALSE); }i    J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowErrorsH  * Description: If the qualifiers /DATE and/or /SIZE were on the commandH  *              line, AND either DateErr or SizeErr are nonzero, displayI  *              the respective error count values and return SS$_DATAERR.e'  *              Else return SS$_NORMAL.<  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowErrors()R {d'     char HiliteOff[] = {"\033[49;30m"};IB     char DateOn[] = {"\033[49;33m"};        /* hilite is YELLOW */@     char SizeOn[] = {"\033[49;36m"};        /* hilite is CYAN */       if(DtFlg) {d         if(DateFlg && !SizeFlg) A             fprintf(outfp, "%26sDifferences:    %sDate = %d%s\n",d1                 " ", DateOn, DateErr, HiliteOff);          if(!DateFlg && SizeFlg)IA             fprintf(outfp, "%26sDifferences:    %sSize = %d%s\n",i1                 " ", SizeOn, SizeErr, HiliteOff);          if(DateFlg && SizeFlg) tP             fprintf(outfp, "%26sDifferences:    %sDate = %d%s, %sSize = %d%s\n",M                 " ", DateOn, DateErr, HiliteOff, SizeOn, SizeErr, HiliteOff);      } 
     else {         if(DateFlg && !SizeFlg)*=             fprintf(outfp, "%26sDifferences:    Date = %d\n",                  " ", DateErr);         if(!DateFlg && SizeFlg) =             fprintf(outfp, "%26sDifferences:    Size = %d\n",s                 " ", SizeErr);         if(DateFlg && SizeFlg)H             fprintf(outfp, "%26sDifferences:    Date = %d, Size = %d\n",'                 " ", DateErr, SizeErr);      }      fprintf(outfp, "\n\n");r }/    H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowHelp H  * Description: Display a brief combination of CMPDIR.README and the cduI  *              CMPDIR.CLD file. It provides a command line glance at the 9  *              optional implementations of CMPDIR usage.a  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */1 void ShowHelp()* {c0     printf("\n  %s (%s)\n\n", CmdVerb, VERSION);L     printf("\tAllows user to compare the contents of two directories.\n\n");$     printf("      Parameters:\n\n");L     printf("\tPATH1, PATH2 - the filepaths of the two directories to be\n");L     printf("\t\tcompared. The parameters are directory paths and cannot\n");8     printf("\t\tspecify filenames. Usage example:\n\n");G     printf("\t\t\t$ %s DKA100:[DOG.BARK] DKB300:[DOG.SLEEP] /DATE\n\n",*                 CmdVerb);*#     printf("      Qualifiers\n\n"); K     printf("\t/DATE - compares the specified date-time values of each \n");eO     printf("\t\tmatching pair of files. The compare is for BACKUP, CREATE,\n");eI     printf("\t\tEXPIRE, or REVISE. Revise (modify) is the default.\n\n");tO     printf("\t/OUTPUT - place output results to specified file rather than\n"); H     printf("\t\tSYS$OUTPUT. If filespec is omitted, file %s_DIFF.LST\n",                 CmdVerb); 7     printf("\t\tis created in default directory.\n\n");*O     printf("\t/SIZE - verifies the used and allocated size is identical on\n"); 4     printf("\t\tboth files of matched pairs.\n\n"); /     printf("\t/HELP - Displays this text\n\n");a;     printf("\t/VERSION - Displays version, build date,\n");iB     printf("\t\tand required privs for VMS Install utility.\n\n");     exit(1); }d         H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowVers)C  * Description: Displays current installed version, build date, andvC  *              required privs for interactive usage and/or the VMSaC  *              install utility (note bypass used for directories).R  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */3 void ShowVers()  { 1     printf("\n\t\t%s by Lyle W West\n", CmdVerb); F     printf("\t\tVersion: %s (%s)\n", VERSION, ARCH ? "Alpha" : "Vax");9     printf("\t\tLink Date: %s (%s)\n", __DATE__, "DecC"); .     printf("\t\tRequired Privs: READALL\n\n");     exit(1); }a            