/*****************************************************************************
I. Numeric Order Codes

This Appendix contains SCSI-2 additional sense codes and operation codes in 
numeric order as a reference.  In the event of a conflict with the 
alphabetical definitions of these codes in Table 7-41 and in the appropriate 
tables of commands in sections 7 through 17, those definitions should be 
regarded as correct.
******************************************************************************/
struct
{
    unsigned char asc;
    unsigned char ascq;
    unsigned direct_access : 1;
    unsigned sequential_access : 1;
    unsigned printer : 1;
    unsigned processor : 1;
    unsigned worm : 1;
    unsigned cdrom : 1;
    unsigned scanner : 1;
    unsigned optical : 1;
    unsigned media_changer : 1;
    unsigned communication : 1;
    char *description;
} sense_key_info[] = 
{
/*    asc  ascq  D T L P W R S O M C  Description */
    {0x00, 0x00, 1,1,1,1,1,1,1,1,1,1, "NO ADDITIONAL SENSE INFORMATION"},
    {0x00, 0x01, 0,1,0,0,0,0,0,0,0,0, "FILEMARK DETECTED"},
    {0x00, 0x02, 0,1,0,0,0,0,1,0,0,0, "END-OF-PARTITION/MEDIUM DETECTED"},
    {0x00, 0x03, 0,1,0,0,0,0,0,0,0,0, "SETMARK DETECTED"},
    {0x00, 0x04, 0,1,0,0,0,0,1,0,0,0, "BEGINNING-OF-PARTITION/MEDIUM DETECTED"},
    {0x00, 0x05, 0,1,0,0,0,0,1,0,0,0, "END-OF-DATA DETECTED"},
    {0x00, 0x06, 1,1,1,1,1,1,1,1,1,1, "I/O PROCESS TERMINATED"},
    {0x00, 0x11, 0,0,0,0,0,1,0,0,0,0, "AUDIO PLAY OPERATION IN PROGRESS"},
    {0x00, 0x12, 0,0,0,0,0,1,0,0,0,0, "AUDIO PLAY OPERATION PAUSED"},
    {0x00, 0x13, 0,0,0,0,0,1,0,0,0,0, "AUDIO PLAY OPERATION SUCCESSFULLY COMPLETED"},
    {0x00, 0x14, 0,0,0,0,0,1,0,0,0,0, "AUDIO PLAY OPERATION STOPPED DUE TO ERROR"},
    {0x00, 0x15, 0,0,0,0,0,1,0,0,0,0, "NO CURRENT AUDIO STATUS TO RETURN"},
    {0x01, 0x00, 1,0,0,0,1,0,0,1,0,0, "NO INDEX/SECTOR SIGNAL"},
    {0x02, 0x00, 1,0,0,0,1,1,0,1,1,0, "NO SEEK COMPLETE"},
    {0x03, 0x00, 1,1,1,0,1,0,1,1,0,0, "PERIPHERAL DEVICE WRITE FAULT"},
    {0x03, 0x01, 0,1,0,0,0,0,0,0,0,0, "NO WRITE CURRENT"},
    {0x03, 0x02, 0,1,0,0,0,0,0,0,0,0, "EXCESSIVE WRITE ERRORS"},
    {0x04, 0x00, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT NOT READY, CAUSE NOT REPORTABLE"},
    {0x04, 0x01, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT IS IN PROCESS OF BECOMING READY"},
    {0x04, 0x02, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT NOT READY, INITIALIZING COMMAND REQUIRED"},
    {0x04, 0x03, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT NOT READY, MANUAL INTERVENTION REQUIRED"},
    {0x04, 0x04, 1,1,1,0,0,0,0,1,0,0, "LOGICAL UNIT NOT READY, FORMAT IN PROGRESS"},
    {0x05, 0x00, 1,1,1,0,1,1,1,1,1,1, "LOGICAL UNIT DOES NOT RESPOND TO SELECTION"},
    {0x06, 0x00, 1,0,0,0,1,1,0,1,1,0, "NO REFERENCE POSITION FOUND"},
    {0x07, 0x00, 1,1,1,0,1,1,1,1,1,0, "MULTIPLE PERIPHERAL DEVICES SELECTED"},
    {0x08, 0x00, 1,1,1,0,1,1,1,1,1,1, "LOGICAL UNIT COMMUNICATION FAILURE"},
    {0x08, 0x01, 1,1,1,0,1,1,1,1,1,1, "LOGICAL UNIT COMMUNICATION TIME-OUT"},
    {0x08, 0x02, 1,1,1,0,1,1,1,1,1,1, "LOGICAL UNIT COMMUNICATION PARITY ERROR"},
    {0x09, 0x00, 1,1,0,0,1,1,0,1,0,0, "TRACK FOLLOWING ERROR"},
    {0x09, 0x01, 0,0,0,0,1,1,0,1,0,0, "TRACKING SERVO FAILURE"},
    {0x09, 0x02, 0,0,0,0,1,1,0,1,0,0, "FOCUS SERVO FAILURE"},
    {0x09, 0x03, 0,0,0,0,1,1,0,1,0,0, "SPINDLE SERVO FAILURE"},
    {0x0A, 0x00, 1,1,1,1,1,1,1,1,1,1, "ERROR LOG OVERFLOW"},
    {0x0B, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x0C, 0x00, 0,1,0,0,0,0,1,0,0,0, "WRITE ERROR"},
    {0x0C, 0x01, 1,0,0,0,1,0,0,1,0,0, "WRITE ERROR RECOVERED WITH AUTO REALLOCATION"},
    {0x0C, 0x02, 1,0,0,0,1,0,0,1,0,0, "WRITE ERROR - AUTO REALLOCATION FAILED"},
    {0x0D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x0E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x0F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x10, 0x00, 1,0,0,0,1,0,0,1,0,0, "ID CRC OR ECC ERROR"},
    {0x11, 0x00, 1,1,0,0,1,1,1,1,0,0, "UNRECOVERED READ ERROR"},
    {0x11, 0x01, 1,1,0,0,1,0,1,1,0,0, "READ RETRIES EXHAUSTED"},
    {0x11, 0x02, 1,1,0,0,1,0,1,1,0,0, "ERROR TOO LONG TO CORRECT"},
    {0x11, 0x03, 1,1,0,0,1,0,1,1,0,0, "MULTIPLE READ ERRORS"},
    {0x11, 0x04, 1,0,0,0,1,0,0,1,0,0, "UNRECOVERED READ ERROR - AUTO REALLOCATE FAILED"},
    {0x11, 0x05, 0,0,0,0,1,1,0,1,0,0, "L-EC UNCORRECTABLE ERROR"},
    {0x11, 0x06, 0,0,0,0,1,1,0,1,0,0, "CIRC UNRECOVERED ERROR"},
    {0x11, 0x07, 0,0,0,0,1,0,0,1,0,0, "DATA RESYCHRONIZATION ERROR"},
    {0x11, 0x08, 0,1,0,0,0,0,0,0,0,0, "INCOMPLETE BLOCK READ"},
    {0x11, 0x09, 0,1,0,0,0,0,0,0,0,0, "NO GAP FOUND"},
    {0x11, 0x0A, 1,1,0,0,0,0,0,1,0,0, "MISCORRECTED ERROR"},
    {0x11, 0x0B, 1,0,0,0,1,0,0,1,0,0, "UNRECOVERED READ ERROR - RECOMMEND REASSIGNMENT"},
    {0x11, 0x0C, 1,0,0,0,1,0,0,1,0,0, "UNRECOVERED READ ERROR - RECOMMEND REWRITE THE DATA"},
    {0x12, 0x00, 1,0,0,0,1,0,0,1,0,0, "ADDRESS MARK NOT FOUND FOR ID FIELD"},
    {0x13, 0x00, 1,0,0,0,1,0,0,1,0,0, "ADDRESS MARK NOT FOUND FOR DATA FIELD"},
    {0x14, 0x00, 1,1,1,0,1,1,1,1,0,0, "RECORDED ENTITY NOT FOUND"},
    {0x14, 0x01, 1,1,0,0,1,1,0,1,0,0, "RECORD NOT FOUND"},
    {0x14, 0x02, 0,1,0,0,0,0,0,0,0,0, "FILEMARK OR SETMARK NOT FOUND"},
    {0x14, 0x03, 0,1,0,0,0,0,0,0,0,0, "END-OF-DATA NOT FOUND"},
    {0x14, 0x04, 0,1,0,0,0,0,0,0,0,0, "BLOCK SEQUENCE ERROR"},
    {0x15, 0x00, 1,1,1,0,1,1,1,1,1,0, "RANDOM POSITIONING ERROR"},
    {0x15, 0x01, 1,1,1,0,1,1,1,1,1,0, "MECHANICAL POSITIONING ERROR"},
    {0x15, 0x02, 1,1,0,0,1,1,0,1,0,0, "POSITIONING ERROR DETECTED BY READ OF MEDIUM"},
    {0x16, 0x00, 1,0,0,0,1,0,0,1,0,0, "DATA SYNCHRONIZATION MARK ERROR"},
    {0x17, 0x00, 1,1,0,0,1,1,1,1,0,0, "RECOVERED DATA WITH NO ERROR CORRECTION APPLIED"},
    {0x17, 0x01, 1,1,0,0,1,1,1,1,0,0, "RECOVERED DATA WITH RETRIES"},
    {0x17, 0x02, 1,1,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH POSITIVE HEAD OFFSET"},
    {0x17, 0x03, 1,1,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH NEGATIVE HEAD OFFSET"},
    {0x17, 0x04, 0,0,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH RETRIES AND/OR CIRC APPLIED"},
    {0x17, 0x05, 1,0,0,0,1,1,0,1,0,0, "RECOVERED DATA USING PREVIOUS SECTOR ID"},
    {0x17, 0x06, 1,0,0,0,1,0,0,1,0,0, "RECOVERED DATA WITHOUT ECC - DATA AUTO-REALLOCATED"},
    {0x17, 0x07, 1,0,0,0,1,0,0,1,0,0, "RECOVERED DATA WITHOUT ECC - RECOMMEND REASSIGNMENT"},
    {0x18, 0x00, 1,1,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH ERROR CORRECTION APPLIED"},
    {0x18, 0x01, 1,0,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH ERROR CORRECTION AND RETRIES APPLIED"},
    {0x18, 0x02, 1,0,0,0,1,1,0,1,0,0, "RECOVERED DATA - DATA AUTO-REALLOCATED"},
    {0x18, 0x03, 0,0,0,0,0,1,0,0,0,0, "RECOVERED DATA WITH CIRC"},
    {0x18, 0x04, 0,0,0,0,0,1,0,0,0,0, "RECOVERED DATA WITH LEC"},
    {0x18, 0x05, 1,0,0,0,1,1,0,1,0,0, "RECOVERED DATA - RECOMMEND REASSIGNMENT"},
    {0x19, 0x00, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST ERROR"},
    {0x19, 0x01, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST NOT AVAILABLE"},
    {0x19, 0x02, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST ERROR IN PRIMARY LIST"},
    {0x19, 0x03, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST ERROR IN GROWN LIST"},
    {0x1A, 0x00, 1,1,1,1,1,1,1,1,1,1, "PARAMETER LIST LENGTH ERROR"},
    {0x1B, 0x00, 1,1,1,1,1,1,1,1,1,1, "SYNCHRONOUS DATA TRANSFER ERROR"},
    {0x1C, 0x00, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST NOT FOUND"},
    {0x1C, 0x01, 1,0,0,0,0,0,0,1,0,0, "PRIMARY DEFECT LIST NOT FOUND"},
    {0x1C, 0x02, 1,0,0,0,0,0,0,1,0,0, "GROWN DEFECT LIST NOT FOUND"},
    {0x1D, 0x00, 1,0,0,0,1,0,0,1,0,0, "MISCOMPARE DURING VERIFY OPERATION"},
    {0x1E, 0x00, 1,0,0,0,1,0,0,1,0,0, "RECOVERED ID WITH ECC CORRECTION"},
    {0x1F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x20, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID COMMAND OPERATION CODE"},
    {0x21, 0x00, 1,1,0,0,1,1,0,1,1,0, "LOGICAL BLOCK ADDRESS OUT OF RANGE"},
    {0x21, 0x01, 0,0,0,0,0,0,0,0,1,0, "INVALID ELEMENT ADDRESS"},
    {0x22, 0x00, 1,0,0,0,0,0,0,0,0,0, "ILLEGAL FUNCTION (SHOULD USE 20 00, 24 00, OR 26 00)"},
    {0x23, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x24, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID FIELD IN CDB"},
    {0x25, 0x00, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT NOT SUPPORTED"},
    {0x26, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID FIELD IN PARAMETER LIST"},
    {0x26, 0x01, 1,1,1,1,1,1,1,1,1,1, "PARAMETER NOT SUPPORTED"},
    {0x26, 0x02, 1,1,1,1,1,1,1,1,1,1, "PARAMETER VALUE INVALID"},
    {0x26, 0x03, 1,1,1,1,1,1,1,1,1,1, "THRESHOLD PARAMETERS NOT SUPPORTED"},
    {0x27, 0x00, 1,1,0,0,1,0,0,1,0,0, "WRITE PROTECTED"},
    {0x28, 0x00, 1,1,1,1,1,1,1,1,1,1, "NOT READY TO READY TRANSITION (MEDIUM MAY HAVE CHANGED)"},
    {0x28, 0x01, 0,0,0,0,0,0,0,0,1,0, "IMPORT OR EXPORT ELEMENT ACCESSED"},
    {0x29, 0x00, 1,1,1,1,1,1,1,1,1,1, "POWER ON, RESET, OR BUS DEVICE RESET OCCURRED"},
    {0x2A, 0x00, 1,1,1,0,1,1,1,1,1,1, "PARAMETERS CHANGED"},
    {0x2A, 0x01, 1,1,1,0,1,1,1,1,1,1, "MODE PARAMETERS CHANGED"},
    {0x2A, 0x02, 1,1,1,0,1,1,1,1,1,1, "LOG PARAMETERS CHANGED"},
    {0x2B, 0x00, 1,1,1,1,1,1,1,1,0,1, "COPY CANNOT EXECUTE SINCE HOST CANNOT DISCONNECT"},
    {0x2C, 0x00, 1,1,1,1,1,1,1,1,1,1, "COMMAND SEQUENCE ERROR"},
    {0x2C, 0x01, 0,0,0,0,0,0,1,0,0,0, "TOO MANY WINDOWS SPECIFIED"},
    {0x2C, 0x02, 0,0,0,0,0,0,1,0,0,0, "INVALID COMBINATION OF WINDOWS SPECIFIED"},
    {0x2D, 0x00, 0,1,0,0,0,0,0,0,0,0, "OVERWRITE ERROR ON UPDATE IN PLACE"},
    {0x2E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x2F, 0x00, 1,1,1,1,1,1,1,1,1,1, "COMMANDS CLEARED BY ANOTHER INITIATOR"},
    {0x30, 0x00, 1,1,0,0,1,1,0,1,1,0, "INCOMPATIBLE MEDIUM INSTALLED"},
    {0x30, 0x01, 1,1,0,0,1,1,0,1,0,0, "CANNOT READ MEDIUM - UNKNOWN FORMAT"},
    {0x30, 0x02, 1,1,0,0,1,1,0,1,0,0, "CANNOT READ MEDIUM - INCOMPATIBLE FORMAT"},
    {0x30, 0x03, 1,1,0,0,0,0,0,0,0,0, "CLEANING CARTRIDGE INSTALLED"},
    {0x31, 0x00, 1,1,0,0,1,0,0,1,0,0, "MEDIUM FORMAT CORRUPTED"},
    {0x31, 0x01, 1,0,1,0,0,0,0,1,0,0, "FORMAT COMMAND FAILED"},
    {0x32, 0x00, 1,0,0,0,1,0,0,1,0,0, "NO DEFECT SPARE LOCATION AVAILABLE"},
    {0x32, 0x01, 1,0,0,0,1,0,0,1,0,0, "DEFECT LIST UPDATE FAILURE"},
    {0x33, 0x00, 0,1,0,0,0,0,0,0,0,0, "TAPE LENGTH ERROR"},
    {0x34, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x35, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x36, 0x00, 0,0,1,0,0,0,0,0,0,0, "RIBBON, INK, OR TONER FAILURE"},
    {0x37, 0x00, 1,1,1,0,1,1,1,1,1,1, "ROUNDED PARAMETER"},
    {0x38, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x39, 0x00, 1,1,1,0,1,1,1,1,1,1, "SAVING PARAMETERS NOT SUPPORTED"},
    {0x3A, 0x00, 1,1,1,0,1,1,1,1,1,0, "MEDIUM NOT PRESENT"},
    {0x3B, 0x00, 0,1,1,0,0,0,0,0,0,0, "SEQUENTIAL POSITIONING ERROR"},
    {0x3B, 0x01, 0,1,0,0,0,0,0,0,0,0, "TAPE POSITION ERROR AT BEGINNING-OF-MEDIUM"},
    {0x3B, 0x02, 0,1,0,0,0,0,0,0,0,0, "TAPE POSITION ERROR AT END-OF-MEDIUM"},
    {0x3B, 0x03, 0,0,1,0,0,0,0,0,0,0, "TAPE OR ELECTRONIC VERTICAL FORMS UNIT NOT READY"},
    {0x3B, 0x04, 0,0,1,0,0,0,0,0,0,0, "SLEW FAILURE"},
    {0x3B, 0x05, 0,0,1,0,0,0,0,0,0,0, "PAPER JAM"},
    {0x3B, 0x06, 0,0,1,0,0,0,0,0,0,0, "FAILED TO SENSE TOP-OF-FORM"},
    {0x3B, 0x07, 0,0,1,0,0,0,0,0,0,0, "FAILED TO SENSE BOTTOM-OF-FORM"},
    {0x3B, 0x08, 0,1,0,0,0,0,0,0,0,0, "REPOSITION ERROR"},
    {0x3B, 0x09, 0,0,0,0,0,0,1,0,0,0, "READ PAST END OF MEDIUM"},
    {0x3B, 0x0A, 0,0,0,0,0,0,1,0,0,0, "READ PAST BEGINNING OF MEDIUM"},
    {0x3B, 0x0B, 0,0,0,0,0,0,1,0,0,0, "POSITION PAST END OF MEDIUM"},
    {0x3B, 0x0C, 0,0,0,0,0,0,1,0,0,0, "POSITION PAST BEGINNING OF MEDIUM"},
    {0x3B, 0x0D, 0,0,0,0,0,0,0,0,1,0, "MEDIUM DESTINATION ELEMENT FULL"},
    {0x3B, 0x0E, 0,0,0,0,0,0,0,0,1,0, "MEDIUM SOURCE ELEMENT EMPTY"},
    {0x3C, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x3D, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID BITS IN IDENTIFY MESSAGE"},
    {0x3E, 0x00, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT HAS NOT SELF-CONFIGURED YET"},
    {0x3F, 0x00, 1,1,1,1,1,1,1,1,1,1, "TARGET OPERATING CONDITIONS HAVE CHANGED"},
    {0x3F, 0x01, 1,1,1,1,1,1,1,1,1,1, "MICROCODE HAS BEEN CHANGED"},
    {0x3F, 0x02, 1,1,1,1,1,1,1,1,1,1, "CHANGED OPERATING DEFINITION"},
    {0x3F, 0x03, 1,1,1,1,1,1,1,1,1,1, "INQUIRY DATA HAS CHANGED"},
    {0x40, 0x00, 1,0,0,0,0,0,0,0,0,0, "RAM FAILURE (SHOULD USE 40 NN)"},
    {0x40, 0x00, 1,1,1,1,1,1,1,1,1,1, "DIAGNOSTIC FAILURE ON COMPONENT NN (80H-FFH)"},
    {0x41, 0x00, 1,0,0,0,0,0,0,0,0,0, "DATA PATH FAILURE (SHOULD USE 40 NN)"},
    {0x42, 0x00, 1,0,0,0,0,0,0,0,0,0, "POWER-ON OR SELF-TEST FAILURE (SHOULD USE 40 NN)"},
    {0x43, 0x00, 1,1,1,1,1,1,1,1,1,1, "MESSAGE ERROR"},
    {0x44, 0x00, 1,1,1,1,1,1,1,1,1,1, "INTERNAL TARGET FAILURE"},
    {0x45, 0x00, 1,1,1,1,1,1,1,1,1,1, "SELECT OR RESELECT FAILURE"},
    {0x46, 0x00, 1,1,1,1,1,1,1,1,1,1, "UNSUCCESSFUL SOFT RESET"},
    {0x47, 0x00, 1,1,1,1,1,1,1,1,1,1, "SCSI PARITY ERROR"},
    {0x48, 0x00, 1,1,1,1,1,1,1,1,1,1, "INITIATOR DETECTED ERROR MESSAGE RECEIVED"},
    {0x49, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID MESSAGE ERROR"},
    {0x4A, 0x00, 1,1,1,1,1,1,1,1,1,1, "COMMAND PHASE ERROR"},
    {0x4B, 0x00, 1,1,1,1,1,1,1,1,1,1, "DATA PHASE ERROR"},
    {0x4C, 0x00, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT FAILED SELF-CONFIGURATION"},
    {0x4D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x4E, 0x00, 1,1,1,1,1,1,1,1,1,1, "OVERLAPPED COMMANDS ATTEMPTED"},
    {0x4F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x50, 0x00, 0,1,0,0,0,0,0,0,0,0, "WRITE APPEND ERROR"},
    {0x50, 0x01, 0,1,0,0,0,0,0,0,0,0, "WRITE APPEND POSITION ERROR"},
    {0x50, 0x02, 0,1,0,0,0,0,0,0,0,0, "POSITION ERROR RELATED TO TIMING"},
    {0x51, 0x00, 0,1,0,0,0,0,0,1,0,0, "ERASE FAILURE"},
    {0x52, 0x00, 0,1,0,0,0,0,0,0,0,0, "CARTRIDGE FAULT"},
    {0x53, 0x00, 1,1,1,0,1,1,1,1,1,0, "MEDIA LOAD OR EJECT FAILED"},
    {0x53, 0x01, 0,1,0,0,0,0,0,0,0,0, "UNLOAD TAPE FAILURE"},
    {0x53, 0x02, 1,1,0,0,1,1,0,1,1,0, "MEDIUM REMOVAL PREVENTED"},
    {0x54, 0x00, 0,0,0,1,0,0,0,0,0,0, "SCSI TO HOST SYSTEM INTERFACE FAILURE"},
    {0x55, 0x00, 0,0,0,1,0,0,0,0,0,0, "SYSTEM RESOURCE FAILURE"},
    {0x56, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x57, 0x00, 0,0,0,0,0,1,0,0,0,0, "UNABLE TO RECOVER TABLE-OF-CONTENTS"},
    {0x58, 0x00, 0,0,0,0,0,0,0,1,0,0, "GENERATION DOES NOT EXIST"},
    {0x59, 0x00, 0,0,0,0,0,0,0,1,0,0, "UPDATED BLOCK READ"},
    {0x5A, 0x00, 1,1,1,1,1,1,1,1,1,0, "OPERATOR REQUEST OR STATE CHANGE INPUT (UNSPECIFIED)"},
    {0x5A, 0x01, 1,1,0,0,1,1,0,1,1,0, "OPERATOR MEDIUM REMOVAL REQUEST"},
    {0x5A, 0x02, 1,1,0,0,1,0,0,1,0,0, "OPERATOR SELECTED WRITE PROTECT"},
    {0x5A, 0x03, 1,1,0,0,1,0,0,1,0,0, "OPERATOR SELECTED WRITE PERMIT"},
    {0x5B, 0x00, 1,1,1,1,1,1,1,1,1,0, "LOG EXCEPTION"},
    {0x5B, 0x01, 1,1,1,1,1,1,1,1,1,0, "THRESHOLD CONDITION MET"},
    {0x5B, 0x02, 1,1,1,1,1,1,1,1,1,0, "LOG COUNTER AT MAXIMUM"},
    {0x5B, 0x03, 1,1,1,1,1,1,1,1,1,0, "LOG LIST CODES EXHAUSTED"},
    {0x5C, 0x00, 1,0,0,0,0,0,0,1,0,0, "RPL STATUS CHANGE"},
    {0x5C, 0x01, 1,0,0,0,0,0,0,1,0,0, "SPINDLES SYNCHRONIZED"},
    {0x5C, 0x02, 1,0,0,0,0,0,0,1,0,0, "SPINDLES NOT SYNCHRONIZED"},
    {0x5D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x5E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x5F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x60, 0x00, 0,0,0,0,0,0,1,0,0,0, "LAMP FAILURE"},
    {0x61, 0x00, 0,0,0,0,0,0,1,0,0,0, "VIDEO ACQUISITION ERROR"},
    {0x61, 0x01, 0,0,0,0,0,0,1,0,0,0, "UNABLE TO ACQUIRE VIDEO"},
    {0x61, 0x02, 0,0,0,0,0,0,1,0,0,0, "OUT OF FOCUS"},
    {0x62, 0x00, 0,0,0,0,0,0,1,0,0,0, "SCAN HEAD POSITIONING ERROR"},
    {0x63, 0x00, 0,0,0,0,0,1,0,0,0,0, "END OF USER AREA ENCOUNTERED ON THIS TRACK"},
    {0x64, 0x00, 0,0,0,0,0,1,0,0,0,0, "ILLEGAL MODE FOR THIS TRACK"},
    {0x65, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x66, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x67, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x68, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x69, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x6A, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x6B, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x6C, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x6D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x6E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x6F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x70, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x71, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x72, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x73, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x74, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x75, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x76, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x77, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x78, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x79, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x7A, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x7B, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x7C, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x7D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x7E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},
    {0x7F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""}
    /**************************************************************
    80 XX     \
    THROUGH    >     VENDOR SPECIFIC.
    FF XX     /

    XX 80     \
    THROUGH    >     VENDOR SPECIFIC QUALIFICATION OF STANDARD ASC.
    XX FF     /
                     ALL CODES NOT SHOWN ARE BLANK OR RESERVED.
    **************************************************************/
};




struct
{
    unsigned char opcode;
    unsigned char direct_access;
    unsigned char sequential_access;
    unsigned char printer;
    unsigned char processor;
    unsigned char worm;
    unsigned char cdrom;
    unsigned char scanner;
    unsigned char optical;
    unsigned char media_changer;
    unsigned char communication;
    char *description;
} opcode_table[] = 
{
/******************************************************************************
Device Columns M = Mandatory
Key:           O = Optional
               V = Vendor unique
                 = Reserved (Blank)

   D          = Direct-Access Device
    T         = Sequential-Access Device
     L        = Printer Device
      P       = Processor Device
       W      = Write-Once Device
        R     = CD-ROM Device
         S    = Scanner Device
          O   = Optical Memory Device
           M  = Medium Changer Device
            C = Communication Device
******************************************************************************/
/* Opcode   D   T   L   P   W   R   S   O   M   C   Description              */
    {0x00, 'M','M','M','M','M','M','M','M','M','M', "TEST UNIT READY"},
    {0x01, ' ','M',' ',' ',' ',' ',' ',' ',' ',' ', "REWIND"},
    {0x01, 'O',' ','V',' ','O','O',' ','O','O',' ', "REZERO UNIT"},
    {0x02, 'V','V','V','V','V','V',' ',' ','V',' ', ""},
    {0x03, 'M','M','M','M','M','M','M','M','M','M', "REQUEST SENSE"},
    {0x04, ' ',' ','O',' ',' ',' ',' ',' ',' ',' ', "FORMAT"},
    {0x04, 'M',' ',' ',' ',' ',' ',' ','O',' ',' ', "FORMAT UNIT"},
    {0x05, 'V','M','V','V','V','V',' ',' ','V',' ', "READ BLOCK LIMITS"},
    {0x06, 'V','V','V','V','V','V',' ',' ','V',' ', ""},
    {0x07, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "INITIALIZE ELEMENT STATUS"},
    {0x07, 'O','V','V',' ','O',' ',' ','O','V',' ', "REASSIGN BLOCKS"},
    {0x08, ' ',' ',' ',' ',' ',' ',' ',' ',' ','M', "GET MESSAGE(06)"},
    {0x08, 'O','M','V',' ','O','O',' ','O','V',' ', "READ(06)"},
    {0x08, ' ',' ',' ','O',' ',' ',' ',' ',' ',' ', "RECEIVE"},
    {0x09, 'V','V','V','V','V','V',' ',' ','V',' ', ""},
    {0x0A, ' ',' ','M',' ',' ',' ',' ',' ',' ',' ', "PRINT"},
    {0x0A, ' ',' ',' ',' ',' ',' ',' ',' ',' ','M', "SEND MESSAGE(06)"},
    {0x0A, ' ',' ',' ','M',' ',' ',' ',' ',' ',' ', "SEND(06)"},
    {0x0A, 'O','M',' ',' ','O',' ',' ','O','V',' ', "WRITE(06)"},
    {0x0B, 'O',' ',' ',' ','O','O',' ','O','V',' ', "SEEK(06)"},
    {0x0B, ' ',' ','O',' ',' ',' ',' ',' ',' ',' ', "SLEW AND PRINT"},
    {0x0C, 'V','V','V','V','V','V',' ',' ','V',' ', ""},
    {0x0D, 'V','V','V','V','V','V',' ',' ','V',' ', ""},
    {0x0E, 'V','V','V','V','V','V',' ',' ','V',' ', ""},
    {0x0F, 'V','O','V','V','V','V',' ',' ','V',' ', "READ REVERSE"},
    {0x10, ' ',' ','O',' ','O',' ',' ',' ',' ',' ', "SYNCHRONIZE BUFFER"},
    {0x10, 'V','M',' ','V','V','V',' ',' ',' ',' ', "WRITE FILEMARKS"},
    {0x11, 'V','M','V','V','V','V',' ',' ',' ',' ', "SPACE"},
    {0x12, 'M','M','M','M','M','M','M','M','M','M', "INQUIRY"},
    {0x13, 'V','O','V','V','V','V',' ',' ',' ',' ', "VERIFY(06)"},
    {0x14, 'V','O','O','V','V','V',' ',' ',' ',' ', "RECOVER BUFFERED DATA"},
    {0x15, 'O','M','O',' ','O','O','O','O','O','O', "MODE SELECT(06)"},
    {0x16, 'M',' ',' ',' ','M','M',' ','M','O',' ', "RESERVE"},
    {0x16, ' ','M','M',' ',' ',' ','M',' ',' ',' ', "RESERVE UNIT"},
    {0x17, 'M',' ',' ',' ','M','M',' ','M','O',' ', "RELEASE"},
    {0x17, ' ','M','M',' ',' ',' ','M',' ',' ',' ', "RELEASE UNIT"},
    {0x18, 'O','O','O','O','O','O','O','O',' ',' ', "COPY"},
    {0x19, 'V','M','V','V','V','V',' ',' ',' ',' ', "ERASE"},
    {0x1A, 'O','M','O',' ','O','O','O','O','O','O', "MODE SENSE(06)"},
    {0x1B, ' ','O',' ',' ',' ',' ',' ',' ',' ',' ', "LOAD UNLOAD"},
    {0x1B, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "SCAN"},
    {0x1B, ' ',' ','O',' ',' ',' ',' ',' ',' ',' ', "STOP PRINT"},
    {0x1B, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "STOP START UNIT"},
    {0x1C, 'O','O','O','O','O','O','O','O','O','O', "RECEIVE DIAGNOSTIC RESULTS"},
    {0x1D, 'M','M','M','M','M','M','M','M','M','M', "SEND DIAGNOSTIC"},
    {0x1E, 'O','O',' ',' ','O','O',' ','O','O',' ', "PREVENT ALLOW MEDIUM REMOVAL"},
    {0x1F, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x20, 'V',' ',' ',' ','V','V',' ','V',' ',' ', ""},
    {0x21, 'V',' ',' ',' ','V','V',' ','V',' ',' ', ""},
    {0x22, 'V',' ',' ',' ','V','V',' ','V',' ',' ', ""},
    {0x23, 'V',' ',' ',' ','V','V',' ','V',' ',' ', ""},
    {0x24, 'V',' ',' ',' ','V','V','M',' ',' ',' ', "SET WINDOW"},
    {0x25, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "GET WINDOW"},
    {0x25, 'M',' ',' ',' ','M',' ',' ','M',' ',' ', "READ CAPACITY"},
    {0x25, ' ',' ',' ',' ',' ','M',' ',' ',' ',' ', "READ CD-ROM CAPACITY"},
    {0x26, 'V',' ',' ',' ','V','V',' ',' ',' ',' ', ""},
    {0x27, 'V',' ',' ',' ','V','V',' ',' ',' ',' ', ""},
    {0x28, ' ',' ',' ',' ',' ',' ',' ',' ',' ','O', "GET MESSAGE(10)"},
    {0x28, 'M',' ',' ',' ','M','M','M','M',' ',' ', "READ(10)"},
    {0x29, 'V',' ',' ',' ','V','V',' ','O',' ',' ', "READ GENERATION"},
    {0x2A, ' ',' ',' ',' ',' ',' ',' ',' ',' ','O', "SEND MESSAGE(10)"},
    {0x2A, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "SEND(10)"},
    {0x2A, 'M',' ',' ',' ','M',' ',' ','M',' ',' ', "WRITE(10)"},
    {0x2B, ' ','O',' ',' ',' ',' ',' ',' ',' ',' ', "LOCATE"},
    {0x2B, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "POSITION TO ELEMENT"},
    {0x2B, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SEEK(10)"},
    {0x2C, 'V',' ',' ',' ',' ',' ',' ','O',' ',' ', "ERASE(10)"},
    {0x2D, 'V',' ',' ',' ','O',' ',' ','O',' ',' ', "READ UPDATED BLOCK"},
    {0x2E, 'O',' ',' ',' ','O',' ',' ','O',' ',' ', "WRITE AND VERIFY(10)"},
    {0x2F, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "VERIFY(10)"},
    {0x30, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA HIGH(10)"},
    {0x31, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "OBJECT POSITION"},
    {0x31, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA EQUAL(10)"},
    {0x32, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA LOW(10)"},
    {0x33, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SET LIMITS(10)"},
    {0x34, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "GET DATA BUFFER STATUS"},
    {0x34, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "PRE-FETCH"},
    {0x34, ' ','O',' ',' ',' ',' ',' ',' ',' ',' ', "READ POSITION"},
    {0x35, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SYNCHRONIZE CACHE"},
    {0x36, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "LOCK UNLOCK CACHE"},
    {0x37, 'O',' ',' ',' ',' ',' ',' ','O',' ',' ', "READ DEFECT DATA(10)"},
    {0x38, ' ',' ',' ',' ','O',' ',' ','O',' ',' ', "MEDIUM SCAN"},
    {0x39, 'O','O','O','O','O','O','O','O',' ',' ', "COMPARE"},
    {0x3A, 'O','O','O','O','O','O','O','O',' ',' ', "COPY AND VERIFY"},
    {0x3B, 'O','O','O','O','O','O','O','O','O','O', "WRITE BUFFER"},
    {0x3C, 'O','O','O','O','O','O','O','O','O','O', "READ BUFFER"},
    {0x3D, ' ',' ',' ',' ','O',' ',' ','O',' ',' ', "UPDATE BLOCK"},
    {0x3E, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "READ LONG"},
    {0x3F, 'O',' ',' ',' ','O',' ',' ','O',' ',' ', "WRITE LONG"},
    {0x40, 'O','O','O','O','O','O','O','O','O','O', "CHANGE DEFINITION"},
    {0x41, 'O',' ',' ',' ',' ',' ',' ',' ',' ',' ', "WRITE SAME"},
    {0x42, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "READ SUB-CHANNEL"},
    {0x43, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "READ TOC"},
    {0x44, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "READ HEADER"},
    {0x45, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY AUDIO(10)"},
    {0x46, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x47, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY AUDIO MSF"},
    {0x48, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY AUDIO TRACK INDEX"},
    {0x49, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY TRACK RELATIVE(10)"},
    {0x4A, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x4B, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PAUSE RESUME"},
    {0x4C, 'O','O','O','O','O','O','O','O','O','O', "LOG SELECT"},
    {0x4D, 'O','O','O','O','O','O','O','O','O','O', "LOG SENSE"},
    {0x4E, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x4F, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x50, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x51, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x52, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x53, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x54, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x55, 'O','O','O',' ','O','O','O','O','O','O', "MODE SELECT(10)"},
    {0x56, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x57, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x58, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x59, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x5A, 'O','O','O',' ','O','O','O','O','O','O', "MODE SENSE(10)"},
    {0x5B, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x5C, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x5D, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x5E, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0x5F, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xA0, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xA1, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xA2, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xA3, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xA4, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xA5, ' ',' ',' ',' ',' ',' ',' ',' ','M',' ', "MOVE MEDIUM"},
    {0xA5, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY AUDIO(12)"},
    {0xA6, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "EXCHANGE MEDIUM"},
    {0xA7, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xA8, ' ',' ',' ',' ',' ',' ',' ',' ',' ','O', "GET MESSAGE(12)"},
    {0xA8, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "READ(12)"},
    {0xA9, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY TRACK RELATIVE(12)"},
    {0xAA, ' ',' ',' ',' ',' ',' ',' ',' ',' ','O', "SEND MESSAGE(12)"},
    {0xAA, ' ',' ',' ',' ','O',' ',' ','O',' ',' ', "WRITE(12)"},
    {0xAB, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xAC, ' ',' ',' ',' ',' ',' ',' ','O',' ',' ', "ERASE(12)"},
    {0xAD, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xAE, ' ',' ',' ',' ','O',' ',' ','O',' ',' ', "WRITE AND VERIFY(12)"},
    {0xAF, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "VERIFY(12)"},
    {0xB0, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA HIGH(12)"},
    {0xB1, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA EQUAL(12)"},
    {0xB2, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA LOW(12)"},
    {0xB3, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "SET LIMITS(12)"},
    {0xB4, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xB5, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xB5, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "REQUEST VOLUME ELEMENT ADDRESS"},
    {0xB6, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xB6, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "SEND VOLUME TAG"},
    {0xB7, ' ',' ',' ',' ',' ',' ',' ','O',' ',' ', "READ DEFECT DATA(12)"},
    {0xB8, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xB8, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "READ ELEMENT STATUS"},
    {0xB9, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xBA, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xBB, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xBC, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xBD, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xBE, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},
    {0xBF, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""}
};
/* DEC/CMS REPLACEMENT HISTORY, Element CDROM-TABLES.H*/
/* *1    22-MAY-1994 09:12:53 SYSTIMK "CDROM codes"*/
/* DEC/CMS REPLACEMENT HISTORY, Element CDROM-TABLES.H*/
