D /******************************************************************/   #ifdef VAXC			/* v1.2-004 */J #module SHELL_MUNG "Jym V1.2-005"       /* Only VAX C understands this. */ #else				/* v1.2-004 */ @ #define	TRUE		1	/* GNU C stdio.h doesn't define TRUE and FALSE*/ #define	FALSE		0 #endif   /* SHELL_MUNG.C O **============================================================================= 8 ** Copyright (C) 1989 Jym Dyer (jym@wheaties.ai.mit.edu) **G ** This program is free software; you can redistribute it and/or modify G ** it under the terms of the GNU General Public License as published by F ** the Free Software Foundation; either version 1, or (at your option) ** any later version.  **B ** This program is distributed in the hope that it will be useful,A ** but WITHOUT ANY WARRANTY; without even the implied warranty of @ ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ** GNU General Public License for more details.  **D ** You should have received a copy of the GNU General Public License> ** along with this program; if not, write to the Free Software< ** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.O **-----------------------------------------------------------------------------  ** Version:     V1.2-005O **-----------------------------------------------------------------------------  ** Facility:    GNU O **-----------------------------------------------------------------------------  ** Prefix:      SHELL_O **-----------------------------------------------------------------------------  ** Abstract  ** ~~~~~~~~ O **  If you think "shell mung" is a step in the preparation of a good mung dahl, N ** you're right, but in this context "mung" is the verb.  ("Mung" historicallyN ** means "mung until no good," but one could easily interpret it to mean "mung4 ** until nearly gnu".  Or something to that effect.)J **  This file provides the shell_glob() and shell_mung() functions for theK ** VMS/DCL/VAX C user.  The shell_glob() function "globs" (parses filespecs J ** with wildcards and matches them with existing files).  The shell_mung()L ** function provides GNU-shell-like IO redirection and globbing:  it changesJ ** `stderr', `stdin', and/or `stdout' to do the IO redirection; it mungs aN ** VAX C program's main() function's `argc' and `argv' variables (using shell_L ** glob()) to do the globbing; and it truncates `argv[0]' down to a filenameE ** and filetype or, if the file is a .EXE file, to just the filename. L **  This makes it easy to port many GNU utilities to VMS, as these utilitiesO ** often expect the shell to have done the work that shell_mung() does.  It can A ** also be used to port Un*x utilities as well, if anybody cares. O **-----------------------------------------------------------------------------  ** Functions ** ~~~~~~~~~ ** shell_glob()  ** shell_mung()  ** (static) truncate_argv_0() O **-----------------------------------------------------------------------------  ** Environment ** ~~~~~~~~~~~L **  Must be linked with the VAX C RTL.  Intended for use with the DCL CLI onL ** VMS; it would be pointless to use shell_mung() with the SHELL CLI, though- ** shell_glob() might possibly come in handy. M **  Must be linked with xmalloc() and xrealloc() functions, which are readily K ** available from GNU source code.  These are simply malloc() and realloc() ; ** functions that exit if there is an error getting memory. O **----------------------------------------------------------------------------- 9 ** Author:      Jym Dyer (jym@wheaties.ai.mit) 8-Apr-1988 O **-----------------------------------------------------------------------------  ** Modifications ** ~~~~~~~~~~~~~H ** 1.0-001 - Original version.  Inspired by the DECUS C getredirection()L **           function written by Martin Minow, Jerry Leichter, and Jym Dyer. **           {Jym 8-Apr-1988} I ** 1.1-002 - Added `shell_default' and use of same by shell_glob(), which = **           allows default filespecs to be used in globbing.  **           {Jym 9-Jan-1989} < ** 1.2-003 - Made shell_glob() accept unglobbable filespecs.O **         - In addition to '-', '+' is now accepted as the start of an option.  **           {Jym 3-Jun-1989} 8 ** 1.2-004 - Made changes to allow compilation by GNU C.? **	     {Hunter Goatley, goathunter@WKUVX1.BITNET, 12-SEP-1991} K ** 1.2-005 - Added Andrew Greer's patch to fix problem parsing non-filespec  **	     arguments to options? **	     {Hunter Goatley, goathunter@WKUVX1.BITNET, 22-SEP-1991} 0 **	     {Andrew Greer, <Andrew.Greer@vuw.ac.nz>}O **=============================================================================  */   /* -=- FILE INCLUSIONS -=- */    #include <ctype.h> #include <errno.h> #include <stdio.h> #include <string.h>    #include <fab.h> #include <nam.h> #include <rmsdef.h>  #include <stsdef.h>    #ifndef VAXC				/* v1.2-004 */C #define _tolower(c)     ((c) >= 'A' && (c) <= 'Z' ? (c) | 0x20:(c)) 9 #endif			/* Also changed tolower() calls to _tolower() */   " /* -=- FORWARD DECLARATIONS -=- */   extern void *  xmalloc();  extern void *  xrealloc();   extern void  sys$exit(); extern int  sys$parse(); extern int  sys$search();    extern char **  shell_glob(); ! static char *  truncate_argv_0();   ( /* -=- GLOBAL VARIABLE DEFINITION -=- */   #ifdef VAXC				/* v1.2-004 */ O globaldef char *  shell_default = NULL; /* Default filespec for shell_glob().*/  #else F char *  shell_default = NULL;		/* Default filespec for shell_glob().*/ #endifJ                                         /* Initialized here to NULL, whichL                                         ** means that no default filespec is@                                         ** used by shell_glob().*                                         */   /* -=- FUNCTIONS -=- */    /* shell_glob() O **-----------------------------------------------------------------------------  ** Functional Description  ** ~~~~~~~~~~~~~~~~~~~~~~ M **  Given a filespec, this function parses that filespec out and searches for M ** the file---or, if the filespec has wildcard characters in it, the files--- N ** associated with the filespec.  It returns a newly-allocated vector of file-O ** specs that are also newly-allocated.  This function can be used to find only O ** the first file that matches the filespec or all the files that match it.  In M ** the latter case, this function will also provide a count of the files that  ** were found.L **  Filespecs returned by this function are in lowercase, to approximate the ** "look and feel" of GNU.M **  This function is used by shell_mung(), and is also handy for general use. O **-----------------------------------------------------------------------------  ** Usage ** ~~~~~N **  This function returns a vector---that is, a pointer to pointers.  Thus you= ** will need to declare this function and a vector like this:  **% **      extern char **  shell_glob();  ** **      char **  filespec_v; **M **  To find only the first match of a wildcarded filespec, or just to get the L ** fully-parsed filespec of a given filespec, call shell_glob() with NULL as@ ** its second parameter.  For example, if you call it like this: **+ **      static int const  filespec = "*.c";  **      char **  filespec_v; **              ... / **      filespec_v = shell_glob(filespec,NULL);  **N ** The value in `filespec_v[0]' will be (for example) "dev:[dir]bar.c;".  NoteJ ** that the character string pointer is the content of the vector, not the ** vector itself. O **  With this usage, `filespec_v' points to a pointer (actually an array of one N ** pointer, which is the same thing).  When used to get a number of filespecs,% ** it points to an array of pointers. H **  To get all the filespecs that match a filespec, use an address of anB ** integer as shell_glob()'s second parameter, as in this example: **+ **      static int const  filespec = "*.c";  **      int  filespec_count; **      char **  filespec_v; **              ... : **      filespec_v = shell_glob(filespec,&filespec_count); **- ** The result of this would be (for example),  ** **      filespec_count = 3, ) **      filespec_v[0] = "dev:[dir]bar.c", - **      filespec_v[1] = "dev:[dir]baz.c", and ) **      filespec_v[2] = "dev:[dir]foo.c".  **M **  In either type of usage, both the vector and the character strings are in  ** newly-allocated memory.N **  VMS globbing entails a feature that allows one to fill in parts of a file-L ** spec with default values.  This feature can be used by shell_glob() usingO ** `shell_default', a global character string.  Use of this character string is L ** optional, and it is initially set to NULL, meaning no default filespec is6 ** used.  To use it, you need to declare it like this: **( **      globalref char *  shell_default; **N **  The most frequent use of a default filespec in VMS is to provide a default& ** filetype, as shown in this example: **+ **      static int const  filespec = "*.c";  **      int  filespec_count; **      char **  filespec_v; **              ...  **      shell_default = ".c"; : **      filespec_v = shell_glob(filespec,&filespec_count); **N ** If `user_string' (which is, of course, a character string) is (for example)N ** "foo*", a filespec without a filetype, shell_glob() will look for all filesN ** whose filespecs match "foo*.c".  If `user_string' were "foo*.h", a filespecM ** that has a filetype, the default filespec ".c" is ignored and shell_glob() : ** will look for all files whose filespecs match "foo*.h".M **  Default filespecs can include devices, directories, filenames, filetypes, K ** and version numbers.  Wildcards can be used in filenames, filetypes, and L ** version numbers.  To turn default filespecs off, just set `shell_default' ** back to NULL.L **  If the given filespec cannot be globbed, shell_glob() will simply returnN ** a filespec vector with an array of one pointer, pointing to the unglobbableK ** given filespec.  The given filespec, therefore, should be something that N ** will stick around for as long as you expect to use the filespec vector.  InI ** particular, don't call shell_glob() from a function using an automatic O ** character string variable of that function and expect the string to still be . ** available when you've exited that function.O **-----------------------------------------------------------------------------  ** Calling Sequence  ** ~~~~~~~~~~~~~~~~ < ** filespec_v = shell_glob(given_filespec,filespec_count_p);O **----------------------------------------------------------------------------- # ** Formal Arguments     Description # ** ~~~~~~~~~~~~~~~~     ~~~~~~~~~~~ N ** given_filespec       Filespec "as given"---that is, as typed on the commandD **                      line.  This is what we parse and search for.K ** filespec_count_p     Pointer to an integer that is to receive a count of N **                      filespecs found that match `given_filespec'.  If NULL,N **                      indicates that we're only to search for the first file6 **                      that matches `given_filespec'.O **----------------------------------------------------------------------------- # ** Implicit Input       Description # ** ~~~~~~~~~~~~~~       ~~~~~~~~~~~ O ** shell_default        This global variable is a character string of a default H **                      filespec.  If NULL, no default filespec is used.O **-----------------------------------------------------------------------------  ** Implicit Outputs:    NoneO **-----------------------------------------------------------------------------  ** Return Value  ** ~~~~~~~~~~~~ ; **  Returns a vector of pointers to newly-parsed filespecs. O **-----------------------------------------------------------------------------  ** Side Effects  ** ~~~~~~~~~~~~ M **  Memory is allocated for the filespec vector and for the filespecs that it 
 ** points to. O **-----------------------------------------------------------------------------  */ char ** + shell_glob(given_filespec,filespec_count_p)   char *  given_filespec;  int *  filespec_count_p;  {    /* --- LOCAL VARIABLES --- */   M   register char *  character_p;         /* General-purpose character pointer, G                                         ** used to convert filespecs to 5                                         ** lowercase. *                                         */4   register char  * expanded_filespec;	/* v1.2-004 */O                                         /* Buffer to hold the expanded filespec F                                         ** from a call to sys$parse().*                                         */O   register int  filespec_count = 0;     /* Count of filespecs that sys$search() 1                                         ** finds. *                                         */O   register char **  filespec_v = NULL;  /* Vector of pointers to filespecs that M                                         ** sys$search() finds.  Allocated and N                                         ** reallocated as filespecs are found.*                                         */K   static char *our_path;                /* The default device and directory L                                         ** path.  Initialized the first timeC                                         ** this function is called. *                                         */4   register char * resultant_filespec;	/* v1.2-004 */N                                         /* Buffer to hold a resultant filespecG                                         ** from a call to sys$search(). *                                         */N   register int  status;                 /* Status codes returned from calls toH                                         ** sys$parse() and sys$search().*                                         */A   struct FAB  fab = cc$rms_fab;         /* RMS file access block. *                                         */:   struct NAM  nam = cc$rms_nam;         /* RMS name block.*                                         */     /* --- INITIALIZE PATH --- */   @   resultant_filespec = xmalloc(NAM$C_MAXRSS + 1);	/* v1.2-004 */?   expanded_filespec = xmalloc(NAM$C_MAXRSS + 1);	/* v1.2-004 */    if (our_path == NULL) 7    (char *) our_path = getenv("PATH");			/* v1.2-004 */ #    /* our_path = getenv("PATH"); */   &   /* --- INITIALIZE FAB AND NAM --- */     if (shell_default != NULL)   { "     fab.fab$l_dna = shell_default;*     fab.fab$b_dns = strlen(shell_default);   } !   fab.fab$l_fna = given_filespec; )   fab.fab$b_fns = strlen(given_filespec);    fab.fab$l_nam = &nam; 4   nam.nam$l_esa = expanded_filespec;		/* v1.2-004 */   nam.nam$b_ess = NAM$C_MAXRSS; 5   nam.nam$l_rsa = resultant_filespec;		/* v1.2-004 */    nam.nam$b_rss = NAM$C_MAXRSS;   ,   /* --- PARSE OUT THE GIVEN FILESPEC --- */  0   if ((status = sys$parse(&fab)) == RMS$_NORMAL)   { *     /* --- SEARCH FOR FILE OR FILES --- */  6     while ((status = sys$search(&fab)) == RMS$_NORMAL)     { E       filespec_v = ((filespec_v == NULL) ? xmalloc(sizeof (char *)) : D        xrealloc(filespec_v,(filespec_count + 1) * sizeof (char *)));  *       nam.nam$l_rsa[nam.nam$b_rsl] = '\0';D       for (character_p = nam.nam$l_rsa; *character_p; ++character_p)=        *character_p = _tolower(*character_p);		/* v1.2-004 */   M       if (strncmp(nam.nam$l_rsa,our_path,nam.nam$b_dev + nam.nam$b_dir) == 0)        { -         filespec_v[filespec_count] = xmalloc( C           (int) (nam.nam$b_rsl - nam.nam$b_dev - nam.nam$b_dir) + 1 
         );:         strcpy(filespec_v[filespec_count],nam.nam$l_name);       } B       else if (strncmp(nam.nam$l_rsa,our_path,nam.nam$b_dev) == 0)       { -         filespec_v[filespec_count] = xmalloc( 3           (int) (nam.nam$b_rsl - nam.nam$b_dev) + 1 
         );9         strcpy(filespec_v[filespec_count],nam.nam$l_dir);        } 
       else       { F         filespec_v[filespec_count] = xmalloc((int) nam.nam$b_rsl + 1);9         strcpy(filespec_v[filespec_count],nam.nam$l_rsa);        }   #       if (filespec_count_p == NULL) 
        break;        ++filespec_count;        } /* sys$search() while */  B     /* --- UPDATE FILESPEC COUNT AND RETURN FILESPEC VECTOR --- */  8     if ((status == RMS$_NORMAL) || (status == RMS$_NMF))     {        if (filespec_count_p) *        *filespec_count_p = filespec_count;       return filespec_v;     }      } /* sys$parse() if */  9   /* --- RETURN VECTOR REFERRING TO GIVEN FILESPEC --- */s  J   /* If we get here, we either could not parse the given filespec or couldI   ** not find it.  In such cases we simply return a vector that refers to    ** the given filespec.   */(   filespec_v = xmalloc(sizeof (char *));!   filespec_v[0] = given_filespec;y   if (filespec_count_p)d    *filespec_count_p = 1;f   return filespec_v;   } /* shell_glob() */   /* shell_mung() O **-----------------------------------------------------------------------------e ** Functional Description  ** ~~~~~~~~~~~~~~~~~~~~~~aK **  Given a description of the command line that invoked a program from thelM ** main() function's `argc' and `argv' variables, this function changes those K ** variables to reflect wildcard matching of filespecs in that command linenK ** and changes standard IO file pointers `stderr', `stdin', and `stdout' toy= ** reflect any IO redirection requested in that command line. O **-----------------------------------------------------------------------------  ** Usage ** ~~~~~O **  Since shell_mung() is written for programs running VAX C programs under theVO ** DCL CLI on VMS, a call to shell_mung() should be predicated on these things:- **) **      #if defined(VAXC) && defined(VMS)-  **        if (!shell$is_shell())+ **         shell_mung(&argc,&argv,...,...);* **      #endif **K ** One should call shell_mung() before doing anything else---in particular,-L ** before anything is done with `argc', `argv', and parts of the standard IO ** library.nM **  The first and second arguments to shell_mung() should always be addresses.N ** of `argc' and `argv', respectively.  The third and fourth arguments requireL ** a bit more thought.  Before they are explained, though, we have to define ** some terms.M **  A "parameter" is a position-dependent command line argument that isn't aneN ** IO redirection (those start with '<' or '>'), an option or an option value.O ** An "option" is similar to a DCL qualifier, except that it starts with '-' oreK ** '+' instead of '/'.  A "value" is a string that follows certain options.rN ** Which options have values is something that varies from program to program.M ** A value in DCL is indicated with a equal sign (e.g. /qualifier=value), butaN ** here it can either be concatenated to an option (e.g. -ovalue) or appear asN ** an argument following the option (e.g. -o value).  "Globbing," as mentionedN ** above, is to parse wildcarded filespecs and match them with existing files.J ** A "mung" is a legume used in Indian cooking, often after being shelled.N **  The third argument to shell_mung() is the number of the parameter where weK ** expect filespecs to appear---in other words, the parameters we expect to N ** need globbing.  A GNU-shell-like command language interpreter will glob anyO ** argument that has a wildcard character in it, unless that argument is put in~O ** single quotes.  DCL doesn't glob arguments, and though you can put arguments*L ** in double quotes to pass them through exactly as typed, by the time VAX CO ** has processed them into `argv' strings, the double quotes have been strippednO ** off.  This is why we have to tell shell_mung() where to start globbing.  ThehN ** assumption is made that unglobbable arguments (such as strings) will appearN ** as parameters before globbable arguments (such as filespecs), an assumptionM ** that holds for most GNU utilities, probably because it's the only rational8L ** way to code utilities that accept multiple filespecs on the command line.N **  As an example, consider the following command line, where "fgrep" is a DCL* ** command to run the GNU "fgrep" program: **  **      $ fgrep -n xyzzy *.c *.h **M ** "xyzzy", "*.c", and "*.h" are the parameters.  For fgrep, the string to bedO ** searched for is always the first parameter ("xyzzy" in this case); the filesaM ** to be searched always begin as a second parameter.  The "-n" is an option,0N ** which could be placed anywhere.  The following commands mean the same thing ** as the previous one:d **  **      $ fgrep xyzzy -n *.c *.h  **      $ fgrep xyzzy *.c -n *.h  **      $ fgrep xyzzy *.c *.h -n **M ** (It is, however, usually considered better form to type the options first.1L ** Some programs actually require that certain options appear before certainK ** parameters.)  To indicate that we expect input filespecs to begin as the2G ** second parameter, we call shell_mung() with 2 as its third argument:= **& **      shell_mung(&argc,&argv,2,...); **A ** This changes `argc' and `argv' so that if the user types this:c ** **      $ fgrep -n xyzzy *.c **4 ** It's as if the user had typed this (for example): **E **      $ fgrep -n xyzzy dev:[dir]bar.c dev:[dir]baz.c dev:[dir]foo.ce **O ** If all of the parameters are to be considered globbable filespecs, the thirdxM ** argument to shell_mung() should be 1 (indicating, of course, that globbingFN ** can start with the first parameter).  If no parameters are to be consideredL ** globbable, shell_mung()'s third argument should be 0.  If the user uses a= ** negative number as the third argument, it is treated as 0.cO **  The fourth argument is a list of options which are followed by values, with1K ** indications as to which values are to be globbed, and which option/valuehL ** combinations are to be considered as replacements for parameters (more on: ** this later).  The list is passed as a character string.O **  As an example, the "make" program has a "-f" option that expects a filespec  ** as its value: **1 **      $ make [-f makefile] [target] [macros]...  **O ** To indicate that we have a "-f" option followed by a globbable value, we putN) ** 'f' in shell_mung()'s fourth argument:- **& **      shell_mung(&argc,&argv,0,"f"); **N ** When an option's value is globbed, only the first matching filespec is usedO ** to replace that value.  If, for example, "makefile.vms" and "makefile.xenix" M ** are the only two files in your directory, and the user types one of these:  ** **      $ make -fmakefile.*  **      $ make -f makefile.* **= ** It's as if the user had typed one of these (respectively):i **& **      $ make -fdev:[dir]makefile.vms' **      $ make -f dev:[dir]makefile.vmsf **N **  Options with unglobbable values must also be listed, with indications thatC ** they are unglobbable.  The "from" program is an example of this:f **! **      $ from [-s sender] [user]e **M ** The "-s" option is followed by a username, not an input filespec.  Thus we = ** put a '-' after the 's' in shell_mung()'s fourth argument:- **' **      shell_mung(&argc,&argv,0,"s-");  **M **  There are times when an option/value combination can replace a parameter.iJ ** Using fgrep as an example again, its first parameter---the string to beH ** searched for---can be replaced by the "-e" and "-f" options and theirM ** values.  The "-e" option is used when the string to be searched for startstJ ** with a '-' character and could be confused with an option, and the "-f"M ** option is used when the string or strings to be searched for is in a file.:N ** We indicate such options by appending a '+' character to them in the string+ ** that is shell_mungs()'s fourth argument:s *** **      shell_mung(&argc,&argv,2,"e+-f+"); **M ** (Note that the "-e" option also has a '-' character following it, since weeO ** don't want its value to be globbed.  When both '+' and '-' are used, the '+'iL ** should always be first.)  It should be noted that such option/value pairsO ** should be typed early in the command line, in positions where the parametersiF ** they're replacing would have been.  For example, you would do this: **' **      $ fgrep -f stringfile inputfileg **/ ** But this would be an invitation to disaster:m **' **      $ fgrep inputfile -f stringfile= **K **  Programs that use the getopt() library function to process options will N ** help you decide which options to include in shell_mung()'s fourth argument.M ** The third argument to getopt() is a list of options, and options that have M ** values are followed by a ':' character.  Here's an example from the source" ** to the GNU "grep" program:  **O **      while ((c = getopt(argc,argv,"0123456789A:B:CVbce:f:hilnsvwx")) != EOF)r **M ** This tells us that the "-A", "-B", "-e", and "-f" options have values.  OfaM ** these, "-A", "-B", and "-e" have unglobbable values; and "-e" and "-f" canaH ** replace a parameter.  Thus, our call to shell_mung() for the GNU grep ** program looks like this:r **. **      shell_mung(&argc,&argv,2,"A-B-e+-f+"); **< **  The IO redirection capabilities provided are as follows: **2 **      <infile         Input comes from "infile".1 **      >outfile        Output goes to "outfile".s: **      >&outfile       Output and errors go to "outfile".5 **      >>outfile       Output appended to "outfile".i@ **      >>&outfile      Output and errors appended to "outfile". **N ** They can be used anywhere on the command line, except between an option and& ** its value.  Here are some examples: **2 **      $ fgrep xyzzy *.txt >&lines_with_xyzzy.lisB **      $ from -s flintstone >>accumulated_flintstone_missives.dat) **      $ my_mailer -d <mail_commands.coma **M ** Some notes:  (1) The filespecs must be next to the redirection characters;eM ** they can't be separate arguments.  (2) For input redirection, the "infile"oO ** is globbed to the first matching filespec, just like an option's value.  (3)eN ** The "<<" redirection characters are not implemented.  Unlike shell scripts,O ** VMS DCL command procedures define standard input as records that don't start J ** with a '$' character, or aren't the record defined by the DECK command.N ** Thus, "<<" redirection is irrelevant.  (4) The "!" redirection character asL ** used in ">!", ">&!", ">>!", and ">>&!" is also not implemented.  VMS usesO ** file versions, which makes it irrelevant.  (5) If a globbable argument turnswJ ** out to be unglobbable, the new vector will simply point to the originalO ** argument.  (6) Pipes (as in the "|" and "|&" redirection characters) are nota ** implemented.iO **-----------------------------------------------------------------------------e ** Calling Sequence. ** ~~~~~~~~~~~~~~~~-N ** delta-arg-count = shell_mung(argc_p,argv_p,parameter_number,option_string);O **-----------------------------------------------------------------------------t# ** Formal Arguments     Description-# ** ~~~~~~~~~~~~~~~~     ~~~~~~~~~~~-D ** argc_p               Pointer to argument count (main()'s `argc').E ** argv_p               Pointer to argument vector (main()'s `argv').,O ** parameter_number     Position among parameters where filespecs are expected.dJ ** option_string        List of options that may be followed by filespecs.O **-----------------------------------------------------------------------------c ** Implicit Inputs:     NoneO **-----------------------------------------------------------------------------  ** Implicit Outputs:    NoneO **------------------------------------------------------------------------------ ** Return Valuei ** ~~~~~~~~~~~~cL **  Returns the number of new arguments that have been added to the argumentL ** vector.  In other words, the difference between the new value of `argc_p' ** and its old value.fO **------------------------------------------------------------------------------ ** Side Effects- ** ~~~~~~~~~~~~ L **  Function may cause the program to exit if it can't open files for error,M ** input, and output redirection.  Uses global variable `vaxc$errno' for exito
 ** status.O **------------------------------------------------------------------------------ */ int-8 shell_mung(argc_p,argv_p,parameter_number,option_string)  int *  argc_p;e  char ***  argv_p;  int  parameter_number;c  char *  option_string;  {*   /* --- LOCAL VARIABLES --- */-  L   register char *  arg_p;               /* General-purpose argument pointer.*                                         */O   int  filespec_count;                  /* Number of filespecs in `filespec_v',iF                                         ** returned from shell_glob().*                                         */L   char **  filespec_v;                  /* Vector of filespecs returned from8                                         ** shell_glob().*                                         */O   char  from_err_too = FALSE;           /* Flag set to indicate that error textsM                                         ** will be redirected to a file along @                                         ** with the output text.*                                         */O   register int  i_new;                  /* Index to new pointers in `new_argv'. *                                         */M   register int  i_old;                  /* Index to old pointers in `argv_p'. *                                         */N   char **  new_argv;                    /* New argument vector, which `argv_p'K                                         ** will end up being replaced with.a*                                         */K   int  new_argv_count;                  /* Count of pointers in `new_argv'.a*                                         */I   int  output_fd;                       /* File descriptor for file being L                                         ** created as redirected output, forG                                         ** use with creat() and dup2(). *                                         */M   int  parameter_count = 0;             /* Counts parameters---arguments thattJ                                         ** don't have '<' or '>' or '-' inJ                                         ** front of them.  When and if theL                                         ** count reaches `parameter_number',K                                         ** we start attempting to parse theuC                                         ** parameters as filespecs. *                                         */O   register char *  place_p;             /* Location of a character, as returned0F                                         ** from strchr() or strrchr().*                                         */  !   /* --- INITIALIZE THINGS --- */   &   /* Allocate the new argument vector.   */   new_argv_count = *argc_p; 7   new_argv = xmalloc(new_argv_count * sizeof (char *));n  B   /* Replace main()'s `argv[0]' with a GNU-like truncated version.   */.   new_argv[0] = truncate_argv_0((*argv_p)[0]);  ,   /* --- TRAVERSE THE ARGUMENT VECTOR --- */  3   for (i_new = i_old = 1; i_old < *argc_p; ++i_old)/'    switch (*(arg_p = (*argv_p)[i_old])).   {_6     /* If it begins with '<', we're redirecting input.     */
     case '<': *     filespec_v = shell_glob(++arg_p,NULL);/     if (freopen(*filespec_v,"r",stdin) == NULL)A     {        perror(*filespec_v);-       sys$exit(vaxc$errno | STS$M_INHIB_MSG);a     }b     free(*filespec_v);     free(filespec_v);(     --new_argv_count;x
     break;  K     /* If it begins with '>', we're redirecting output.  This comes in four*J     ** varieties, as one can append output to an existing file and/or sendL     ** error text out along with the output.  If we're told to append it (byK     ** two '>' characters), we try to access the filespec and append to it.mJ     ** If we can't access it, we proceed as if we were told to create one.L     ** We create an output file (which is also what we're told to do when weL     ** only get one '>' character) with "standard" VMS attributes.  If we'reI     ** told to redirect error text as well (by the '&' character), we set=*     ** `stderr' to refer to the same file.     */
     case '>':      if (*++arg_p == '>')     {n       if (*++arg_p == '&')       {t         from_err_too = TRUE;         ++arg_p;       }        if (access(arg_p,2) == 0)i       {f.         if (freopen(arg_p,"a",stdout) != NULL)	         { #           if (from_err_too == TRUE).            stderr = stdout;            --new_argv_count;L           break;	         }i         perror(arg_p);/         sys$exit(vaxc$errno | STS$M_INHIB_MSG);E       }T     }TI     /* We get to this point if we didn't want to append output text to an G     ** existing file, or if an attempt to establish append access to anp      ** existing file has failed.     */3     if ((from_err_too == FALSE) && (*arg_p == '&'))T     {T       from_err_too = TRUE;       ++arg_p;     }e     if (F       ((output_fd = creat(arg_p,0,"rat=cr","rfm=var","mrs=512")) != 1)/       && (dup2(output_fd,fileno(stdout)) != -1)eL       && ((from_err_too == FALSE) || (dup2(output_fd,fileno(stderr)) != -1))     )      {c       --new_argv_count;        break;     }p     perror(arg_p);+     sys$exit(vaxc$errno | STS$M_INHIB_MSG);l  I     /* If it begins with '-' or '+', it's an option.  We check it against-H     ** `option_string' to see if it's an option followed by an argument.     */
     case '-':i
     case '+':o     if (       (option_string == NULL)rI       || (((char *) place_p = strchr(option_string,(*(arg_p + 1)))) == 0)o     )e     { G       /* Option is not in `option_string'.  We copy it into `new_argv'.l       */        new_argv[i_new++] = arg_p;     }e     else     { N       /* Option is in `option_string'.  First we check to see if its existenceN       ** is to be thought of as introducing a parameter.  This is indicated byA       ** a '+' character following the option in `option_string'.r       */       if (*++place_p == '+')        ++parameter_count;l
       else        --place_p;   O       /* Next we check to see if the string following it is to be considered anlK       ** input filespec.  If a '-' character follows the option in `option_*K       ** string' (or a '+' character following that option), that indicates-0       ** that it's not to be considered as such.       */       if (*++place_p == '-')       {h"         new_argv[i_new++] = arg_p;1         if ((arg_p = (*argv_p)[++i_old]) == NULL)a             goto BREAKOUT;         else					/* V1.2-005 */i6             new_argv[i_new++] = arg_p;		/* V1.2-005 */       } 
       else       {mK         /* The string after the option is an input filespec, so we glob it.tN         ** But we glob it to return only the first match (if it's a wildcard),$         ** not all possible matches.
         */!         if (*(arg_p + 2) == '\0')'	         {'M           new_argv = xrealloc(new_argv,(++new_argv_count * sizeof (char *)));i$           new_argv[i_new++] = arg_p;3           if ((arg_p = (*argv_p)[++i_old]) == NULL)             goto BREAKOUT;i  .           filespec_v = shell_glob(arg_p,NULL);*           new_argv[i_new++] = *filespec_v;           free(filespec_v);u	         }i         else	         {l4           filespec_v = shell_glob((arg_p + 2),NULL);A           new_argv[i_new] = xmalloc(2 + strlen(*filespec_v) + 1);g*           memcpy(new_argv[i_new],arg_p,2);6           strcpy((new_argv[i_new++] + 2),*filespec_v);           free(*filespec_v);           free(filespec_v);e	         }p       }o     }r
     break;  K     /* If we get here, the argument is a parameter.  If we're not concernedrL     ** about parameters (that is, if `parameter_number' is zero or less), orM     ** if the parameter count is less than `parameter_number', we simply copyoL     ** the parameter into the new argument vector.  Otherwise, the parameterM     ** and those following it are expected to be filespecs, and an attempt islJ     ** made to parse them as such and put all resulting filespecs into the     ** argument vector.n     */     default:J     if ((parameter_number <= 0) || (++parameter_count < parameter_number))      new_argv[i_new++] = arg_p;t     else     {e5       filespec_v = shell_glob(arg_p,&filespec_count);s       if (filespec_count == 1)'        new_argv[i_new++] = *filespec_v; 
       else       {p-         new_argv_count += filespec_count - 1;nI         new_argv = xrealloc(new_argv,(new_argv_count * sizeof (char *))); O         memcpy(&new_argv[i_new],filespec_v,(filespec_count * sizeof (char *)));*          i_new += filespec_count;       }e       free(filespec_v);s     } 
     break;     } /* for/switch */  	 BREAKOUT:s     new_argv[i_new] = NULL;s  9   /* --- UPDATE ARGUMENT COUNT AND ARGUMENT VECTOR --- */p     *argc_p = i_new;   *argv_p = new_argv;h     return i_new - i_old;h   } /* shell_mung() */   /* -=- STATIC FUNCTION -=- */e   /* truncate_argv_0O **-----------------------------------------------------------------------------h ** Functional Descriptionb ** ~~~~~~~~~~~~~~~~~~~~~~oM **  Programs written in VAX C, when run under VMS DCL, will have their entireeN ** filespec (i.e., the filespec of the running image) in the main() function'sM ** `argv[0]' variable.  While this makes sense from a VMS standpoint, it does=O ** not look very good in programs ported from GNU, which often use `argv[0]' asv ** an error message prefix.hO **  This function, which is called from shell_mung(), truncates the filespec in K ** `argv[0]' to just the filename or, if the filetype is not ".EXE", to thev ** filename and filetype. O **-----------------------------------------------------------------------------n ** Calling Sequenceu ** ~~~~~~~~~~~~~~~~o1 ** new_argv[0] = truncate_argv_0(given_filespec);sO **-----------------------------------------------------------------------------s# ** Formal Argument      Descriptionu# ** ~~~~~~~~~~~~~~~      ~~~~~~~~~~~ N ** given_filespec       The filespec to be truncated.  Assumed to be `argv[0]'K **                      or a pointer to the same thing `argv[0]' points to. O **-----------------------------------------------------------------------------e ** Implicit Inputs:     NoneO **-----------------------------------------------------------------------------l ** Implicit Outputs:    NoneO **-----------------------------------------------------------------------------f ** Return Valuec ** ~~~~~~~~~~~~TG **  Returns the truncated filespec, which is in newly-allocated memory.uO **-----------------------------------------------------------------------------v ** Side EffectsW ** ~~~~~~~~~~~~a3 **  Memory is allocated for the truncated filespec.sO **-----------------------------------------------------------------------------x */
 static char *  truncate_argv_0(given_filespec)t  char *  given_filespec; {    /* --- LOCAL VARIABLES --- */   M   register char *  character_p;         /* General-purpose character pointer,rF                                         ** used to lowercase filespec.*                                         */,   char  * expanded_filespec;		/* v1.2-004 */O                                         /* Buffer to hold the expanded filespeceF                                         ** from a call to sys$parse().*                                         */N   register char *  filespec_p;          /* Pointer to truncated filespec to be4                                         ** returned.*                                         */J   struct FAB  fab = cc$rms_fab;         /* RMS file access block for file.*                                         */C   struct NAM  nam = cc$rms_nam;         /* RMS name block for file.v*                                         */  (   /* --- INITIALIZE FABS AND NAMS --- */  ?   expanded_filespec = xmalloc(NAM$C_MAXRSS + 1);	/* v1.2-004 */o!   fab.fab$l_fna = given_filespec;r)   fab.fab$b_fns = strlen(given_filespec);W   fab.fab$l_nam = &nam;y5   nam.nam$l_esa = expanded_filespec;			/* v1.2-004 */a   nam.nam$b_ess = NAM$C_MAXRSS;e   nam.nam$b_nop = NAM$M_SYNCHK;c  ,   /* --- PARSE OUT THE GIVEN FILESPEC --- */     sys$parse(&fab);  4   /* --- NUL-TERMINATE AND LOWERCASE FILESPEC --- */     *nam.nam$l_ver = '\0';  @   for (character_p = nam.nam$l_esa; *character_p; ++character_p)8    *character_p = _tolower(*character_p);	/* v1.2-004 */  )   /* --- RETURN TRUNCATED FILESPEC --- */e  $   if (strcmp(nam.nam$l_type,".exe"))=    filespec_p = xmalloc(nam.nam$b_name + nam.nam$b_type + 1);    else   {r     *nam.nam$l_type = '\0';t-     filespec_p = xmalloc(nam.nam$b_name + 1);    }   $   strcpy(filespec_p,nam.nam$l_name);   return filespec_p;   } /* truncate_argv_0() */ 