 $!B $!	This is a sample queue processor command procedure for use withG $!	the EXECSYMB server symbiont.  It illustrates the general structure  J $!	of such a procedure, and includes examples of some "programming tricks"D $!	that can be used to accomplish useful, though unobvious, effects. $!D $!	(For efficiency, a production version of this procedure should be5 $!	 stripped of most -- or all -- of these comments.)  $!P $!============================================================================== $!1 $!	First, do normal command procedure setup stuff  $!
 $ SET NOON $ SET NOVERIFY $!G $!	EXECSYMB identifies our mailboxes, queue and device names with group H $!	logical names (group 1, i.e. table LNM$GROUP_000001) that contain ourG $!	process ID.  Here we find our own process ID and get the information  $!	set up by EXECSYMB: $!* $!	QUEUE_NAME_pid	is the name of our queueE $!	DEVICE_NAME_pid is the "/ON=" parameter, without the nodename, and ; $!			can be used to pass a parameter of up to 31 characters D $!	CMD_MBX_pid	is our input mailbox, for reading input from EXECSYMBG $!	STAT_W_MBX_pid	is our status output mailbox, for reporting status to 
 $!			EXECSYMB  $! $ PID==F$GETJPI("","PID") ) $ QUEUENAME=F$TRNLNM("QUEUE_NAME_''PID'") + $ DEVICENAME=F$TRNLNM("DEVICE_NAME_''PID'")  $!J $!	Symbionts don't have real SYS$OUTPUT/SYS$INPUT/SYS$ERROR devices -- but@ $!	we're not a symbiont, just an ordinary detached process!  OurE $!	SYS$OUTPUT goes to a log file named SYS_EXECSYMB:queuename.OUT (or H $!	SYS$MANAGER:queuename.OUT if SYS_EXECSYMB isn't defined system-wide.)I $!	So we can write useful information into the log file -- and it will be E $!	readable from other processes without having to stop this process.  $!F $ WRITE SYS$OUTPUT F$TIME()," SAMPLEPROC starting on queue ",QUEUENAME $!@ $!	Initialize things -- i.e. open the input and status mailboxes $! $INIT:* $ OPEN/READ/ERR=NOMBX INPUT CMD_MBX_'PID':- $ OPEN/WRITE/ERR=NOMBX STAT STAT_W_MBX_'PID':  $!B $!	Come here on an explicit RESET, or after completing an EXECUTE.E $!	Reset symbols values to defaults, etc.  (Note that if the queue is B $!	set up with NONULL, you should reinitialize the item symbols toB $!	defaults, as nothing will be passed if the item isn't present.) $!F $!	EXEC_STEP, the "command" that EXECSYMB passes to terminate a task'sI $!	items, can be used with symbol substitution in a GOTO -- in which case B $!	it has to be initialized with the name of the input loop label. $! $RESET: $ $ WRITE SYS$OUTPUT F$TIME()," RESET" $ EXEC_STEP="INPUT"  $!H $!	The input loop.  Since this queue uses the ASCII format for items, weF $!	do two reads per item -- the first gets the name of the item (whichE $!	we'll use as a symbol name), and the second reads the value of the 0 $!	item (which becomes the value of the symbol.) $!G $!	Eventually we'll get an EXEC_STEP item that will change the value of F $!	the EXEC_STEP symbol (usually to EXECUTE, but sometimes to RESET or: $!	even EXIT); at that point we'll break out of this loop. $! $INPUT:  $ READ/ERR=ERRMBX INPUT SYMBOL $ READ/ERR=ERRMBX INPUT 'SYMBOL  $ GOTO 'EXEC_STEP  $!G $!	On EXEC_STEP=EXECUTE (i.e. perform the task specified by the list of  $!	items) we'll come here. $!	 $EXECUTE:  $!G $!	Under normal circumstances, where this procedure actually "executes" G $!	the request specified by the task, we complete the task by sending a J $!	success status to EXECSYMB, and branching to the RESET section to start $!	over for the next task. $!; $!	If we report an error status, several things may happen:  $!G $!	(1) If this task was part of a multi-task job, no further tasks will C $!	    be processed for this job, and EXECSYMB will report an error H $!	    status to the job controller.  (If the queue is set /RETAIN=ERRORC $!	    then the job controller will retain this job as completed in  $!	    error.) $!H $!	    There's also a clever alternative to /RETAIN=ERROR.  If you don'tD $!	    need the "TIME=" queue parameter for anything else, set it asG $!	    follows:  TIME="7305 " (i.e. retry after 7305 days).  It happens D $!	    that 7305 days is exactly 20 years (anytime between the yearsI $!	    1901 and 2099, at least!)  Then, if the job aborts with a severity F $!	    of "error" or "fatal error", the entry will get requeued -- andG $!	    its "/AFTER" date will be *exactly* 20 years after the time when E $!	    the job was aborted.  This feature has helped us pinpoint the  H $!	    time of occurrence of various problems affecting EXECSYMB queues. $!E $!	(2) If this queue was set up with TIME="some nonzero delta time",  I $!	    i.e. an error retry interval was specified, *AND* the status had a I $!	    severity level of 2 ("error") or 4 ("fatal error"), then EXECSYMB  J $!	    will simply requeue the job with the specified delta time, and willH $!	    report nothing to the job controller.  (Actually, it will requestE $!	    that the job controller abort this task and requeue it /AFTER= F $!	    now plus the specified delta time.)  The presence or absence ofH $!	    the NOCHECKPOINT parameter in the queue setup will determine, forI $!	    multi-task jobs, whether the retry will start over from the first  G $!	    task in this job (NOCHECK) or from the start of the current task  $!	    (CHECK, the default). $!I $!	    Starting with V3.2.4 of EXECSYMB, you can disable the requeue-for- E $!	    retry feature on a job-by-job basis.  If you want to report an J $!	    error status (with severity level 2 or 4) but you do *not* want theE $!	    job requeued, return the negative of the actual error status.  D $!	    EXECSYMB detects the negative status, and reports the correctI $!	    (positive) status as the job/task completion status -- but doesn't ! $!	    requeue the job for retry.  $! $ WRITE STAT "%X00000001"  $ GOTO RESET $!P $!------------------------------------------------------------------------------ $!E $!	What follows are examples of alternate ways of "executing" a task, E $!	which illustrate some useful programming techniques or "tricks"...  $!P $!------------------------------------------------------------------------------ $!J $!	[Example 1]  Suppose all you want to do is requeue this job to another C $!	queue, possibly modifying some of its qualifiers in the process.  $!B $!	To do this, the queue must be set up with the TIME="delta time"A $!	parameter, and the delta-time must be long enough to give this E $!	procedure a chance to modify the job before it starts again.  (One H $!	minute is reasonable; longer times don't matter -- the following code9 $!	will release the job as soon as it has been modified.) G $!	Assume, for this example, that the symbol QUALS contains the desired I $!	list of qualifier changes for this job, and that NEWQUEUE contains the 2 $!	name of the queue to which to requeue this job. $!H $!	First, report a fatal error status (e.g. abort), aborting the currentH $!	task.  EXECSYMB will then send us an EXEC_STEP item with RESET as its) $!	value.  We read and discard this item.  $! $ WRITE STAT "%X0000002C"  $ READ INPUT SYMBOL  $ READ INPUT 'SYMBOL $!H $!	Next, we get the entry number (supplied as a hex number in %Xxxxxxxxx $!	format) as a decimal number.  $! $ N='ENTRY_NUMBER  $!G $!	We need to wait until EXECSYMB tells the job controller to abort the H $!	job and put it in a HOLD state, and the job controller does so.  ThatG $!	may take a while on a busy system -- so we wait a while and retry if @ $!	it fails because the job is still active (status %X100480FA). $!
 $WAITLOOP: $ WAIT 00:00:05.00  $ SET ENTRY 'N/REQUEUE='NEWQUEUE0 $ IF '$STATUS .EQ. %X100480FA THEN GOTO WAITLOOP $!F $!	Once the job is inactive and requeued, we remove the "checkpointed"C $!	status, change the qualifiers, and release the job.  Then we can @ $!	execute the RESET that was requested, and go do the next job. $!$ $ SET ENTRY 'N/NOCHECK/RELEASE'QUALSO $ WRITE SYS$OUTPUT F$TIME()," Requeued entry ",N," to ",NEWQUEUE," with ",QUALS  $ GOTO RESET $!P $!------------------------------------------------------------------------------ $!E $!	[Example 2]  This isn't really a code example -- just a note about G $!	using EXECSYMB queue processors with "spool files".  (A "spool file" H $!	is a temporary file that's created to hold output between the time itH $!	is generated and when it's actually printed.  Spool files do not haveC $!	directory entries, and so end up with invalid filespecs such as:  $!		NODE$DUA0:[]FILENAME.LIS; F $!	Spool files are produced when a device (terminal, printer, etc.) isG $!	spooled to a queue, as well as by some utilities (e.g. MAIL produces < $!	a spool file when you use the PRINT command within MAIL.) $!C $!	Spool files aren't a problem at all, unless your queue processor E $!	actually tries to use the FILE_SPECIFICATION item.  Under ordinary G $!	circumstances, as mentioned above, this will be an invalid filespec. A $!	EXECSYMB's solution to the problem is implemented through the  C $!	"SPOOL=[directory]" parameter in the queue setup.  The directory E $!	specified in this parameter should exist on *every* disk on which  D $!	spool files may be produced.  Then, if EXECSYMB sees a spool fileI $!	being processed by a queue that has "SPOOL=" specified, it temporarily E $!	enters the file into the specified "spool directory".  Since spool A $!	files get automatically deleted by the job controller (but the G $!	directory entry does not), EXECSYMB also removes the directory entry  $!	when the task finishes. $!I $!	At our site, we routinely create a [SPOOL] directory on each disk, and C $!	put SPOOL=[SPOOL] in the queue setup of all EXECSYMB queues that  $!	require	it. $!P $!------------------------------------------------------------------------------ $!I $!	[Example 3]  Another note:  if the current task involves a spool file, D $!	or if the file in the current task has an explicit /DELETE on it,G $!	the file will be deleted by the job controller as soon as the job is E $!	finished (not the *task* but the whole *job*, since an abort might 7 $!	require the job to be restarted from the beginning.)  $!G $!	This isn't a problem if the file is completely processed by the time E $!	the task finishes.  However, suppose the queue processor wants to  G $!	take the file and do something to it (*not* requeue the whole job to B $!	another queue) which may involve a delay.  (For example, a mailG $!	processing queue might want to create a job in a "network" queue and G $!	have the file copied to another network node.  The actual copying of C $!	the file might take place a long time after this task finishes.)  $!I $!	To account for the possibility that the file may get deleted, you have H $!	to make a copy of the file.  Here's some DCL code that does this, andI $!	does reasonable error checking, and returns the resulting filespec for  $!	use in further processing.  $!  $!	First, the mainline DCL code: $!H $!	Call a DCL subroutine to do the work and produce a temporary log file $ CALL/OUT='PID'.TMP DOCOPY 6 $!	Read the log file, looking for the "copied to" line# $ OPEN/READ/ERR=NOLOG TMP 'PID'.TMP 
 $READLOOP:% $ READ/END=BADLOG/ERR=BADLOG TMP LINE ! $ IX=F$LOCATE(" copied to ",LINE)  $ L=F$LENGTH(LINE)! $ IF IX .EQ. L THEN GOTO READLOOP  $ CLOSE TMP 0 $!	If "copied to" was found, delete the log file $ DELETE 'PID'.TMP;*F $!	Extract the new filespec, and strip off the extra stuff COPY put on+ $ NEWFILESPEC=F$EXTRACT(IX+11,L-IX-11,LINE)  $ IP=F$LOCATE("(",NEWFILESPEC)2 $ IF IP .EQ. F$LENGTH(NEWFILESPEC) THEN GOTO NFSOK8 $ NEWFILESPEC=F$EDIT(F$EXTRACT(0,IP,NEWFILESPEC),"TRIM") $ IP=F$LOCATE("::",NEWFILESPEC) 2 $ IF IP .EQ. F$LENGTH(NEWFILESPEC) THEN GOTO NFSOKD $ NEWFILESPEC=F$EXTRACT(IP+2,F$LENGTH(NEWFILESPEC)-IP-2,NEWFILESPEC) $NFSOK:  $!= $!	Error handling is required in case the READ or OPEN fails. D $!	(No code is shows after the NOLOG label, but you'd have to handle9 $!	the fact that the COPY failed and produced no output.)  $! $BADLOG: $ CLOSE TMP  $ DELETE 'DEVICENAME'.TMP;*  $NOLOG:  $!I $!	Finally, here's the subroutine (assume "DESTINATION" symbol is defined = $!	to contain the device and directory where to put the file)  $! $DOCOPY: SUBROUTINE 2 $ COPY/LOG 'FILE_SPECIFICATION 'DESTINATION':*.*;0 $ ENDSUBROUTINE  $!P $!------------------------------------------------------------------------------ $!I $!	[Example 4]  If your queue processor does a substantial amount of work F $!	on some tasks, it may be nice to provide some quick feedback to theI $!	users.  One easy way to do that is to use the V5.x "queue description" H $!	text field to display a status message, updating it as you go throughB $!	major sections of the procedure.  Here's an example of some DCLH $!	commands that will set the queue description to something meaningful. $!H $!	First, in the initial setup code at the start, add code such as this: $!" $ WEARE=F$ENVIRONMENT("PROCEDURE")& $ PVERS=F$PARSE(WEARE,,,"VERSION")-";"N $ QSTAT="SET QUEUE "+QUEUENAME+"/DESC=""V"+PVERS+" Status: "+"'"+"'F$TIME()' " $!J $!	This defines the QSTAT symbol to enable commands such as the following  $!	to work:  $! $ 'QSTAT' Idle"  $!B $!	...which sets the "description" of the queue, as listed by the 8 $!	SHOW QUEUE/FULL command, to look something like this: $!. $!		<V82 Status:  3-MAY-1990 17:04:24.17 Idle> $!G $!	This lets you know which version of the command procedure is active, D $!	when the status message was last updated, and what the status is.E $!	These commands may then be placed at major points in the procedure H $!	(e.g. after labels such as RESET, EXECUTE, etc., and before/after DCLD $!	commands that may do time-consuming operations) to provide status1 $!	feedback for both users and system manager(s).  $!E $!	Of course, you can do similar things with SET QUEUE/DESCR that are 9 $!	simpler, or more complicated, than what's shown above.  $!P $!------------------------------------------------------------------------------ $!E $!	[Example 5]  Dynamic queue processors that have short timeouts may F $!	create a large number of log files.  Although version limits may beE $!	used to limit the number of files, there are better alternatives.  H $!	(Fixed version limits may result in the deletion of very recent filesJ $!	that contain important error information.)  Furthermore, version limitsC $!	do not deal with the problem that occurs when the version number J $!	reaches 32767 and attempts to "wrap around".  The following code *does* $!	handle both problems. $!G $!	First, check to see if more than a certain number of versions of the J $!	log file are present -- to avoid doing this code too often.  (64 is the" $!	number of versions used below.) $!& $ OURQUE=F$TRNLNM("QUEUE_NAME_''PID'")8 $ IF F$SEARCH("SYS_EXECSYMB:''OURQUE'.OUT;-64") .NES. "" $ THEN $!F $!	Next, a trick to avoid deleting files over a weekend.  If yesterdayD $!	was a Saturday or a Sunday, we don't purge.  This allows a systemJ $!	manager to examine the weekend's files on Monday.  Obviously, you couldH $!	use other tricks here, or change the PURGE/BEFORE to specify a period $!	of time (e.g. several days).  $!? $  IF F$EXTRACT(0,1,F$CVTIME("YESTERDAY",,"WEEKDAY")) .NES. "S"  $  THEN 4 $   PURGE/BEFORE=YESTERDAY SYS_EXECSYMB:'OURQUE'.OUT $  ENDIF $!I $!	Now, take care of high version numbers.  Check the highest number, and H $!	if it's "high" (defined as "at least 32000" here -- you can set it as> $!	you wish) then it renumbers all the log files (via RENAME). $!3 $  LOGFILE=F$SEARCH("SYS_EXECSYMB:''OURQUE'.OUT;0") + $  LOGVERS=F$PARSE(LOGFILE,,,"VERSION")-";"  $  IF 'LOGVERS .GE. 32000  $  THEN  $!F $!	Determine the lowest present version number, so that you can rename. $!	it to ;1 and rename the others in sequence. $!5 $   LOGFILE=F$SEARCH("SYS_EXECSYMB:''OURQUE'.OUT;-0") , $   LOGVERS=F$PARSE(LOGFILE,,,"VERSION")-";" $   DELTAVERS='LOGVERS'-1  $!? $!	Rename each .OUT file to .OUTTMP with the new version number  $! $RENLOG:4 $   LOGFILE=F$SEARCH("SYS_EXECSYMB:''OURQUE'.OUT;0")( $   IF LOGFILE .EQS. "" THEN GOTO LOGREN, $   LOGVERS=F$PARSE(LOGFILE,,,"VERSION")-";" $   NEWVERS='LOGVERS'-DELTAVERS ' $   RENAME 'LOGFILE' *.OUTTMP;'NEWVERS'  $   GOTO RENLOG  $!F $!	Finally, rename all the .OUTTMP files to .OUT with the same version $! $LOGREN:1 $   RENAME SYS_EXECSYMB:'OURQUE'.OUTTMP;* *.OUT;*  $  ENDIF $ ENDIF  $!P $!------------------------------------------------------------------------------ $!* $!	That's the end of the EXECUTE examples! $!J $!	Come here when EXECSYMB sends EXEC_STEP=EXIT.  This means that EXECSYMB  $!	wants us to exit gracefully. H $!	This happens if the queue is being stopped, or if we are a "dynamic" G $!	queue processor (i.e. DYN="some nonzero delta time" was specified in H $!	the queue setup) and the timeout period has elapsed without a new job $!	coming in for us. $! $EXIT: $ EXIT 1 $!G $!	Some error handling:  if one of the mailboxes couldn't be opened, we G $!	can't go on, so we save the error status, write a message, and exit.  $! $NOMBX:  $ STATUS=$STATUS3 $ WRITE SYS$OUTPUT "Mailbox open failure; exiting."  $ EXIT 'STATUS $!E $!	More error handling: if we get an end-of-file or other error on a  H $!	mailbox, we close both mailboxes and try to reopen them.  If EXECSYMBI $!	has gone away for some reason, that will send us to NOMBX above, where E $!	we'll exit.  If we succeed in reopening the mailboxes, we can then  $!	proceed as usual. $! $ERRMBX:7 $ WRITE SYS$OUTPUT "Mailbox I/O error; reinitializing."  $ CLOSE STAT
 $ CLOSE INPUT  $ GOTO INIT 