 #ifdef VAXC ' #module CLUE$COMMANDS "BOL-V1.0/AUG-96"  #else . #pragma module CLUE$COMMANDS "BOL-V1.0/AUG-96" #endif  G /* This module provides the DEBUG, EXIT, HELP and TERMINAL commands. */   < /* Include definitions from LIB. These includes were created<    by the MLB2H (Macro library to .H file) DCL procedure. */   #include "inc:ihddef.h"  #include "inc:ihidef.h"   # /* Include modules form STARLET. */    #include dcdef #include iodef #include tt2def    #include "clue$include.h"   B /* Define ICB (image control block) layout. This must be done here-    since no ICB definition in LIB.MLB exists.   @    We define the structure only up to last field of interest. */   struct __ICB {   unsigned int   ICB$L_FLINK;  unsigned int   ICB$L_BLINK;  unsigned short ICB$W_SIZE;   unsigned char  ICB$B_TYPE;   unsigned char  ICB$B_SPARE1;   unsigned char  ICB$B_ACCMOD;   unsigned char  ICB$B_ACT_CODE;   unsigned short ICB$W_CHAN;   unsigned int   ICB$L_FLAGS;%  unsigned char  ICB$T_IMAGE_NAME[40];   unsigned int   ICB$L_SPARE2;    unsigned char  ICB$B_MATCH_CTL;   unsigned char  ICB$B_SPARE3[3];"  unsigned char  ICB$B_MINOR_ID[3];  unsigned char  ICB$B_MAJOR_ID; !  unsigned int   ICB$L_START_ADDR;   unsigned int   ICB$L_END_ADDR;  };  ' #define __ICB_SIZE sizeof(struct __ICB)    extern int G_exit_flg;   /* External functions. */   ' int symbol_value(),symval_and_trymem();   	 /******/    void clue$sda_debug()  { @  /* Process the DEBUG command. This command displays information9     about all activated images by the current process. */   -  int imghdrptr,					/* Ptr to image header */ 1      iacptr,					/* Ptr to activate image list */ )      icbptr;					/* Ptr to current ICB */   &  char buffer[20],				/* Text buffer */3       hdrbuf[512],				/* Buffer for image header */ !       *ptr;					/* Aux pointer */   3  struct __IHD *ihdptr;				/* Ptr to image header */ 4  struct __IHI *ihiptr;				/* Ptr to image ID area */  3  struct __ICB icbbuf;				/* Buffer receiving ICB */   7  /* Set header string and start display at new page. */   C  sda$extend_format_subheading(desc("CLUE VAX Debug Information:"));     sda$extend_new_page();     sda$extend_skip_lines(1);  "  /* Print VMS and CLUE version. */  1  symbol_value(desc("SYS$GQ_VERSION"),&imghdrptr);   ?  sda$extend_reqmem(imghdrptr,buffer,8);	 /* Get VMS version. */   @  /* The VMS version is an 8-byte, blank filled string. If blanks-     are in the string, don't display them. */   +  buffer[8] = 0;				/* Mark end of string */    /  ptr = strchr(buffer,' ');		/* Blanks found? */   -  if (ptr) *ptr = 0;			/* Yes, mark new end */   >  sda$extend_print(desc("  Current VMS Version:  !AZ"),buffer);  H  sda$extend_print(desc("  CLUE Version:         CLUE !AZ"),S_CLUE_VERS);    sda$extend_skip_lines(1);    /* Print main image ID. */   3  sda$extend_print(desc("  Image Identification:"));     sda$extend_skip_lines(1);    /* Get image header. */  7  symval_and_trymem(desc("CTL$GL_IMGHDRBF"),&imghdrptr);   +  sda$extend_reqmem(imghdrptr,&imghdrptr,4);   )  sda$extend_reqmem(imghdrptr,hdrbuf,512);   !  ihdptr = (struct __IHD*) hdrbuf;   '  ptr = hdrbuf + ihdptr->IHD$W_IMGIDOFF;     ihiptr = (struct __IHI*) ptr;    C  sda$extend_print(desc("!_Image name:  !AC"),ihiptr->IHI$T_IMGNAM);   B  sda$extend_print(desc("!_Image ident: !AC"),ihiptr->IHI$T_IMGID);  E  sda$extend_print(desc("!_Link Date:   !%D"),ihiptr->IHI$Q_LINKTIME);   1  /* Print all images activated by the process. */     sda$extend_skip_lines(1);  7  sda$extend_print(desc("  Process Activated Images:"));     sda$extend_skip_lines(1);   <  sda$extend_print(desc("!_Start VA  End VA    Image Name"));    /* Get ptr to image list. */   1  symbol_value(desc("IAC$GL_IMAGE_LIST"),&iacptr);   C  /* Information about activated images is stored in data structures E     called ICB's (Image control blocks). They are linked in a double-      linked queue. */  B  sda$extend_reqmem(iacptr,&icbptr,4);		/* Get first ICB address */  B  /* If the pointer to the next ICB is the same as the initial ptr,(     we have travered the entire list. */    while(iacptr != icbptr)  {>   sda$extend_reqmem(icbptr,&icbbuf,__ICB_SIZE);	/* Copy ICB */  H   /* Display info: start address, end address and image name (ASCIC). */  C   sda$extend_print(desc("!_!XL  !XL  !AC"),icbbuf.ICB$L_START_ADDR, 2 			icbbuf.ICB$L_END_ADDR,icbbuf.ICB$T_IMAGE_NAME);  B   sda$extend_reqmem(icbptr,&icbptr,4);		/* Get next ICB address */  } }   	 /******/    void clue$sda_exit() { > /* Process EXIT command. Simply set our global exit flag. This4    will cause the main command loop to terminate. */    G_exit_flg = 1; }   	 /******/    void clue$sda_help() { ( /* HELP - display online information. */  !  char dcl_buf[120], hlp_buf[128];     short len;     $DESCRIPTOR(dcl_p1,"P1");  $DESCRIPTOR(lib,"CLUE$HELP");    $DESCRIPTOR(dcl,dcl_buf);  $DESCRIPTOR(hlp,hlp_buf);  9  strcpy(hlp_buf, "CLUE ");			/* CLUE is the main topic */   I  if (cli$get_value(&dcl_p1,&dcl,&len) & 1)	/* If a subtopic was given, */   {2   dcl_buf[len] = 0;				/* copy it into the help */  *   strcat(hlp_buf,dcl_buf);			/* buffer. */  }<  hlp.dsc$w_length = strlen(hlp_buf);		/* Build descriptor */  8  sda$extend_display_help(&lib,&hlp);		/* Display help */ }   	 /******/    void clue$sda_terminal() { 7 /* TERMINAL - changes terminal's page size or width. */   B  char w_132[] = "\033[?3h",		/* Escape sequenze for large width */B       w_80[]  = "\033[?3l";		/* Escape sequenze for small width */  .  char dclretbuf[10];			/* DCL return buffer */  !  short chan,				/* I/O channel */ 1        retlen,				/* Length of qualifier value */ )        iosb[4];				/* I/O status block */   #  int status,				/* Return status */ )      flg;				/* We must do IO$SET_MODE */   *  struct					/* Terminal characteristics */(  {					/* structure for IO$_SENSEMODE */&   char class;				/* and IO$_SETMODE */   char type;   short width;   char baschar[3];   char page;   int  extchar; 	  } ttbuf;   6  $DESCRIPTOR(sysout,"SYS$OUTPUT");	/* Output device */4  $DESCRIPTOR(dcl_pag,"PAGE");		/* /PAGE qualifier */6  $DESCRIPTOR(dcl_wid,"WIDTH");		/* /WIDTH qualifier */6  $DESCRIPTOR(dclret,dclretbuf);		/* Qualifier value */  A  status = sys$assign(&sysout,&chan,0,0,0); /* Assign a channel */   '  if (!(status & 1)) lib$signal(status);   ,  /* Get current terminal characteristics. */  O  status = sys$qiow(0,chan,IO$_SENSEMODE,iosb,0,0,&ttbuf,sizeof(ttbuf),0,0,0,0);   '  if (!(status & 1)) lib$signal(status);   )  if (!(iosb[0] & 1)) lib$signal(iosb[0]);   7  /* if SYS$OUTPUT is not a terminal, ignore command. */   %  if (ttbuf.class != DC$_TERM) return;   (  flg = 0;					/* Assume nothing to do */  1  /* Obtain desired new width and/or page size. */   @  if (cli$present(&dcl_pag) == CLI$_PRESENT)	/* /PAGE present? */  {?   cli$get_value(&dcl_pag,&dclret,&retlen);	/* Yes, get value */   2   dclretbuf[retlen] = 0;			/* Make ASCIZ string */  6   sscanf(dclretbuf,"%d",&status);		/* Get new value */  ,   ttbuf.page = status;				/* and store it */  -   /* Valid terminal page range is 1...255. */   9   if (ttbuf.page < 1 || ttbuf.width > 255)	/* Check it */    { N    sda$extend_print(desc("%CLUE-E-BADVAL, value !UW invalid /PAGE qualifier"),
 	ttbuf.page);   
    return;   } +   flg = 1;					/* We must do IO$_SETMODE */   }A  if (cli$present(&dcl_wid) == CLI$_PRESENT)	/* /WIDTH present? */   {?   cli$get_value(&dcl_wid,&dclret,&retlen);	/* Yes, get value */   2   dclretbuf[retlen] = 0;			/* Make ASCIZ string */  6   sscanf(dclretbuf,"%d",&status);		/* Get new value */  -   ttbuf.width = status;				/* and store it */   .   /* Valid terminal width range is 1...511. */  :   if (ttbuf.width < 1 || ttbuf.width > 511)	/* Check it */   { O    sda$extend_print(desc("%CLUE-E-BADVAL, value !UW invalid /WIDTH qualifier"),  	ttbuf.width);  
    return;   } ;   /* Send small/large screen width escape sequence, if this :      terminal has the DECCRT attribute set in its extended      characteristics. */  #   if (ttbuf.extchar & TT2$M_DECCRT)   2   status = sys$qiow(0,chan,IO$_WRITEVBLK,iosb,0,0,; 	   ttbuf.width > 80 ? w_132 : w_80,sizeof(w_132),0,0,0,0);   )   flg = 1;					/* Mark given qualifier */   }1  /* Now set new page size and/or screen width. */   	  if (flg)   {N   status = sys$qiow(0,chan,IO$_SETMODE,iosb,0,0,&ttbuf,sizeof(ttbuf),0,0,0,0);  (   if (!(status & 1)) lib$signal(status);  *   if (!(iosb[0] & 1)) lib$signal(iosb[0]);  }  /* That's all here. */  } 