#if !defined BINTREE_H
#define BINTREE_H

#if defined(__DECCXX)
#include "../EZSaveSource/EZSave.h"
#else
#include "..\EZSaveSource\EZSave.h"
#endif

#if !defined(_RWSTD_NO_NAMESPACE)
using namespace EZSave;
#endif

const int MaxNameLength = 15;

// node of the binary tree - data consists of a name and age
class BinTreeNode
{
private:
  char m_Name[MaxNameLength+1];
  int m_Age;
  EZPtr<BinTreeNode> m_pLeftChild;  // See Note below
  EZPtr<BinTreeNode> m_pRightChild; // See Note below
public:
  BinTreeNode() {}
  BinTreeNode(const char *pName, int age);
  ~BinTreeNode();

  friend class BinTree;
};

// object to manage a binary tree
class BinTree
{
private:
  EZPtr<BinTreeNode> m_pTopNode;  // See Note below
  void PrintTree(const EZPtr<BinTreeNode> &) const;
public:
  BinTree() {}
  ~BinTree() { EZDelete(m_pTopNode); }
  void AddToTree(const char *pName, int age);
  void PrintTree() const;
};

/*****
Note:  All EZPtr objects will have their internal pointers initialized to
0 if we are not in the process of restoring saved objects.
*****/

// C++ functions to create a random name and random age
int RandomAge();
const char * RandomName();

#endif
