 #define module_name files_info #define module_ident "V2.0-000" P /*******************************************************************************   C  Copyright 1992, 1994 by Edward A. Heinrich of The LOKI Group, Inc. M  This code may be freely distributed and modified for non-commercial purposes .  as long as this copyright notice is retained.  P *******************************************************************************/   /*  * FACILITY:  *	VMS privileged utilities   *  * PROGRAM:   *	FILES_INFO.C   *  * AUTHOR:				CREATION DATE:(  *	Edward A. Heinrich			January 22, 1992  *  * BUILD INSTRUCTIONS:  *  *	$ cc   files_info  *	$ mac  files_macro #  *	$ link files_info, sys$input/opt   *	  files_macro  *	  sys$share:vaxcrtl/share!  *	  sys$system:sys.stb/selective $  *	  sys$system:sysdef.stb/selective  *	  * USAGE:   *	$ set command files_info   *	$ files_info FILENAME.EXT  *  * ENVIRONMENT: ?  *	User and kernel mode code that acquires the FILSYS spinlock.   *  *  * MODIFICATION HISTORY:  *-  *	V2.0-000	Hunter Goatley		23-NOV-1994 21:54 C  *		Modified to compile under OpenVMS AXP (using CC/STANDARD=VAXC). /  *		Someday it would be nice to ANSI-ize it....   **  *	V1.2		Hunter Goatley		17-FEB-1994 07:478  *		Modified to allow the use of a foreign symbol and to8  *		automatically try to enable the required privileges.  *;  *	V1.1-001	Edward A. Heinrich	15-Apr-1993	22:10 (Tax day!) C  *		This time *really* fix it, (and test it to insure it is fixed!) <  *		While the last edit prevented the kernel mode code from >  *		trampling on memory, I neglected to restrict the user-mode=  *		display loop from exceeding the bounds of the KARGS list. @  *		Added some more display bits from WCB$W_ACON field. Changed A  *		KARGS.COUNT to UNSIGNED (thanks WHG!) to fix value displayed.   *0  *	V1.1-00		Edward A. Heinrich	06-Apr-1993	11:00;  *		Ooops!  Catch exceeding processCount limit on number of 9  *		processes that are accessing a particular file.  Some *  *		corrections and additions to comments.  *  */ 
 #ifdef __DECC ' #pragma module module_name module_ident  #else   #module module_name module_ident #endif  = #include <dcdef.h>			/* Device classes definition file     */ = #include <descrip.h>			/* VMS descriptor definitions	      */ 8 #include <devdef.h>			/* Device characteristics	      */8 #include <fab.h>			/* RMS FAB block definitions	      */0 #include <jpidef.h>			/* GETJPI codes			      */8 #include <nam.h>			/* RMS NAM block definitions	      */6 #include <psldef.h>			/* PSL bit definitions		      */= #include <ssdef.h>			/* System completion status codes     */ 6 #include <stsdef.h>			/* Status return codes		      */7 #include <prvdef.h>			/* Privilege mask codes		      */  #include <stdio.h> #include <lib$routines.h>  #include <str$routines.h>  #include <starlet.h>  B #define	processCount 50			/* Number of processes we care about  */  
 #ifdef __DECC  #define GLOBALVALUE extern #define GLOBALREF extern #else  #define GLOBALVALUE globalvalue  #define GLOBALREF globalref  #endif  
 #ifdef __DECC  #pragma extern_model save   #pragma extern_model globalvalue #endif< GLOBALVALUE WCB$M_NOTFCP;		/* Not accessed via XQP		      */; GLOBALVALUE WCB$M_CATHEDRAL;		/* Cathedral window		      */ > GLOBALVALUE WCB$M_OVERDRAWN;		/* Exceeded disk quota		      */? GLOBALVALUE WCB$M_COMPLETE;		/* File completely mapped	      */ A GLOBALVALUE WCB$M_READ;			/* File opened for READ access	      */ B GLOBALVALUE WCB$M_WRITE;		/* File is opened for WRITE access    */> GLOBALVALUE WCB$V_SEQONLY;		/* Sequential access only	      */: GLOBALVALUE WCB$V_SPOOL;		/* SPOOL file on close		      */7 GLOBALVALUE WCB$V_NOREAD;		/* No read sharing		      */ 9 GLOBALVALUE WCB$V_NOWRITE;		/* No write sharing		      */   
 #ifdef __DECC " #pragma extern_model strict_refdef #endif1 GLOBALREF files_cld;			/* The CLD table		      */ 
 #ifdef __DECC  #pragma extern_model restore #endif  ! extern long LOCK_NONPAGED_CODE();  extern long cli$dcl_parse(); extern long cli$get_value(); /*G  *	Global storage shared between privileged/non-privileged code threads   */  typedef struct wcbstr  	{5 	long	pid;			/* PID of process w/ file opened      */ 7 	long	reads;			/* Number of read operations done     */ 6 	long	writes;			/* Number of write operations	      */ #ifdef __alpha> 	unsigned long   acon;		/* Access control information	      */ #else = 	unsigned short	acon;		/* Access control information	      */  #endif9 	unsigned short	access;		/* Access control byte		      */  	}; 	 struct 	{ # 	struct	wcbstr open [processCount]; > 	unsigned int	count;		/* Number of times file was opened    */G 	struct	dsc$descriptor_s file;	/* Address of filename to search for  */ H 	struct	dsc$descriptor_s device;/* Address of device name to look on  */ 	union	{; 		long    fileid;		/* Overlay FID as long and 3 shorts   */ 9 		short	fid [3];	/* File id of file interested in      */  		} id; - 	unsigned int	fSize;		/* File size			      */ 3 	unsigned int	eof;		/* End of file marker		      */ , 	short	acnt;			/* XQP access count		      */( 	short	wcnt;			/* Write count			      */4 	short	sts;			/* Copy of FCB$W_STATUS field	      */4 	} kargs;			/* Allocate kernel argument list      */    4 main ()					/* You've gotta start somewhere ...   */ {  /*3  *	Declare externally defined routines we reference   */ E extern int  search_list ();		/* Declare forward routine to compiler*/ E extern int  convert_pid ();		/* IPID to EPID conversion routine    */ @ extern void dummy ();			/* Last address to be locked in memory*/  = long	lockCode [2];			/* Starting/ending addresses to lock  */ = long	lockData [2];			/* Same thing for data structures     */ 1 long	status;				/* Local status variable	      */ - long	i,j;				/* Local loop indicies		      */ 4 long	faoList [15];			/* SYS$FAOL item list		      */7 long	userLen;			/* Returned length of userName	      */ 9 short	lowPID;				/* Used to determine if process/VMS   */  /*%  *	Define RMS related data structures   */ B char	rss [NAM$C_MAXRSS];		/* Buffer for resultant filename      */B char	ess [NAM$C_MAXRSS];		/* Buffer for expanded filename string*/: struct	FAB	fab;			/* Allocate storage for FAB block     */3 struct	NAM	nam;			/* Storage for NAM block	      */  /*+  *	Define formatting and display structures   */ ? char	fileBuffer [255];		/* Space for file name storage	      */ H char 	fmt [] = {"!XL !12AS   !7UL   !7UL  !AS!AS!AS!AS!AS!AS!AS!AS!AS"};2 char	userName [16];			/* Username buffer		      */L struct 	dsc$descriptor_s foreignDesc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};I struct 	dsc$descriptor_s userDesc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}; G struct 	dsc$descriptor_s faoFmt = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}; G struct 	dsc$descriptor_s fileDesc = {255, DSC$K_DTYPE_T, DSC$K_CLASS_S, + 			0};	/* Descriptor for filename 	      */ N $DESCRIPTOR (faoFmt1, "!/FILE: !AS");	/* FAO format string for filename     */ $DESCRIPTOR (faoFmt2, H "Total access count of !UW, XQP access !UW, writers !UW, size !UL/!UL");C $DESCRIPTOR (p1Desc, "P1");		/* Name of required parameter	      */ K $DESCRIPTOR (strRead,      "Read");	/* File opened for READ access	      */ W $DESCRIPTOR (strReadC,     "Read (I/O cache)");	/* File opened for READ access	      */ M $DESCRIPTOR (strWrite,     "Write");	/* File opened for WRITE access	      */ I $DESCRIPTOR (strNotFCP,    ", Not FCP");/* Not accessed via XQP		      */ N $DESCRIPTOR (strOverdrawn, ", Exquota");/* User has exceed disk quota	      */) $DESCRIPTOR (strComplete,  ", Complete"); * $DESCRIPTOR (strCathedral, ", Cathedral");L $DESCRIPTOR (strDir,     ", Directory");/* File is a directory file	      */K $DESCRIPTOR (strMarkdel, ", Delete");	/* File is marked for delete	      */ H $DESCRIPTOR (strSpool,   ", Spool");	/* File spooled upon close	      */) $DESCRIPTOR (strSeqonly, ", Sequential"); P $DESCRIPTOR (strNoRead,  ", NoReadShr");/* File not opened for READ sharing   */) $DESCRIPTOR (strNoWrite, ", NoWriteShr"); - 					/* File not opened for WRITE sharing  */ I $DESCRIPTOR (systemDesc, "VMS");	/* Opened by VMS, not a process	      */ K $DESCRIPTOR (CLIverbDesc, "FILES ");	/* Verb used by CLI$DCL_PARSE	      */ 4 struct	{				/* Define structure used for GETJPI   */ 	short	len; 5 	short	code;			/* We obtain current username	      */ 7 	long	*buff;			/* Address of buffer to contain it    */ 6 	long	rlen;			/* Resultant length buffer address    */5 	long	mbz;			/* Terminate the item list here	      */ * 	} jpiList = {12, JPI$_USERNAME, 0, 0, 0}; unsigned long int minpriv[2];    /*9  *  Init the descriptors, etc., here to keep DEC C quiet.   */ " userDesc.dsc$a_pointer = userName; faoFmt.dsc$a_pointer = fmt; $ fileDesc.dsc$a_pointer = fileBuffer;  ! jpiList.buff = (long *)&userName;  jpiList.rlen = (long) &userLen;    /*H  *	Using the DCL parsing routines, obtain the filename we are interested  *	in looking for.  */   ) minpriv[0] = PRV$M_CMKRNL | PRV$M_PSWAPM;   L status = sys$setprv (1, &minpriv,0,0);	/* Turn on needed privileges	      *// if (!(status & STS$M_SUCCESS)) return (status);   I lib$get_foreign (&foreignDesc);		/* Get foreign command line           */ 6 str$concat (&foreignDesc, &CLIverbDesc, &foreignDesc);A status = cli$dcl_parse (&foreignDesc, &files_cld, &lib$get_input,  			&lib$get_input); 2 if (!(status & STS$M_SUCCESS)) return(SS$_NORMAL);  . cli$get_value (&p1Desc, &fileDesc, &fileDesc); /*(  *	Initialize the RMS FAB data structure  */ 3 fab		= cc$rms_fab;		/* Initialize the FAB		      */ : fab.fab$l_nam	= &nam;			/* Point FAB to NAM block	      */D fab.fab$l_fop	= FAB$M_NAM;		/* Say we want to parse NAM block     */N fab.fab$b_fns	= fileDesc.dsc$w_length;/* Length of target device name	      */I fab.fab$l_fna	= fileDesc.dsc$a_pointer;/* Address of text string	      */  /*$  *	Next set up the RMS NAM structure  */ 7 nam		= cc$rms_nam;		/* Ditto for the NAM block	      */ > nam.nam$b_ess	= NAM$C_MAXRSS;		/* Size of ESS buffer		      */> nam.nam$l_esa	= ess;			/* Resultant file name address	      */> nam.nam$l_rsa	= rss;			/* Resultant file name address	      */D nam.nam$b_rss	= NAM$C_MAXRSS;		/* Go for the full size here	      */F nam.nam$b_nop	= NAM$M_NOCONCEAL;	/* Don't conceal device name	      */ /*1  *	Now try to parse it.... (with fingers crossed)   */ A status	= sys$parse (&fab);		/* Parse the input filename 	      */ G if	(!(status & STS$M_SUCCESS))	/* Check for errors on the PARSE call */  	{' 	printf ("\n\7Error parsing filename"); C 	return sys$exit (status);	/* Log message and exit w/ status     */  	} /*H  *	See if we have a node name in there, if we do issue error message and  *	exit to DCL.   */ H if	(nam.nam$l_fnb & NAM$M_NODE)	/* If a node name was part of it      */ 	{5 	printf ("\n\7Filename cannot contain a NODENAME\n");  	return; 	} /*<  *	Also check for wildcard characters.  We do not allow any.  */ K if	(nam.nam$l_fnb & NAM$M_WILDCARD)/* If a wildcard was part of it       */  	{8 	printf ("\n\7Filename cannot contain any WILDCARDS\n"); 	return; 	} /*=  *	Next search for the file.  This is done to obtain the FID.   */ A status	= sys$search (&fab);		/* Search for the filename 	      */ G if	(!(status & STS$M_SUCCESS))	/* Check for errors on the SEARCH     */  	{. 	printf ("\n\7File did not exist %d", status); 	return; 	} /*G  *	We need to lock the pages containing both code and data that will be E  *	referenced by code executing at elevated IPL and while holding the   *	FILSYS spinlock.   */ H lockData [0] = (long) &kargs;			/* Stash address of KARGS structure   */- lockData [1] = lockData [0] + sizeof (kargs);  #if 0 E lockCode [0] = search_list;		/* Also save addresses of code to     */ ? lockCode [1] = dummy;			/* ...be locked down in memory	      */  #endif5 status = sys$lckpag (lockData, lockData, PSL$C_USER);  /*D  *	If we have success in locking the data, then try to lock the code  */  if	(status & STS$M_SUCCESS)  	status = LOCK_NONPAGED_CODE();  if	(!(status & STS$M_SUCCESS)) 	{3 	printf ("\n\7Unable to lock code/data in memory"); = 	sys$exit (status);		/* Display the exact VMS message      */  	}+ kargs.file.dsc$w_length	   = nam.nam$b_rsl; + kargs.file.dsc$a_pointer   = nam.nam$l_rsa; + kargs.device.dsc$a_pointer = nam.nam$l_dev; + kargs.device.dsc$w_length  = nam.nam$b_dev; + kargs.device.dsc$b_dtype   = DSC$K_DTYPE_T; + kargs.device.dsc$b_class   = DSC$K_CLASS_S; N kargs.id.fid [0] = nam.nam$w_fid [0];	/* Propagate the file id to the       */N kargs.id.fid [1] = nam.nam$w_fid [1];	/* ...argument list used by the	      */F kargs.id.fid [2] = nam.nam$w_fid [2];	/* ...kernel mode code		      */N status = sys$cmkrnl (search_list, 0);	/* Kernel mode to search FCB chain    */ /*G  *	We have finished w/ the elevated IPL code so we can unlock the pages $  *	of memory we locked down earlier.  */ 2 /* sys$ulkpag (lockCode, lockCode, PSL$C_USER); */, sys$ulkpag (lockData, lockData, PSL$C_USER);   fileDesc.dsc$w_length = 120;6 sys$fao (&faoFmt1, &fileDesc, &fileDesc, &kargs.file); lib$put_output (&fileDesc);  if	(status != SS$_NORMAL) ' 	printf ("is NOT opened at this time");  else	{ 	fileDesc.dsc$w_length = 120; B 	sys$fao (&faoFmt2, &fileDesc, &fileDesc, kargs.count, kargs.acnt,& 		kargs.wcnt, kargs.eof, kargs.fSize); 	lib$put_output (&fileDesc);  	if	(kargs.count > processCount) 		{ B 		printf ("\n\nOnly displaying %d accesses out of of %ld total\n", 			processCount, kargs.count); 		kargs.count = processCount;  		} P 	printf ("\n   PID     USERNAME      READS    WRITES   ACCESS CHARACTERISTICS");P 	printf ("\n-------- ------------  --------  --------  ----------------------");   	for	(i=0; i<kargs.count; i++) 		{ 0 		j = 5;			/* Starting item list offset	      */ 		fileDesc.dsc$w_length = 120; 		lowPID = kargs.open[i].pid; 4 		if	(lowPID != 0)	/* If not opened by VMS		      */ 			{7 			convert_pid (kargs.open[i].pid, &kargs.open[i].pid); 3 			status	= sys$getjpiw (0, &kargs.open[i].pid, 0,   				&jpiList, 0, 0, 0);  			} 		else	status = 0; 		if	(status & STS$M_SUCCESS)  			{# 			userDesc.dsc$w_length = userLen; # 			faoList [0] = kargs.open[i].pid; " 			faoList [1] = (long) &userDesc; 			} 		else	{ 			faoList [0] = 0; $ 			faoList [1] = (long) &systemDesc; 			}$ 		faoList [2] = kargs.open[i].reads;% 		faoList [3] = kargs.open[i].writes; ) 		if	(kargs.open[i].access & WCB$M_WRITE) " 			faoList [4] = (long) &strWrite;& 		else	faoList [4] = (long) &strRead; - 		if	(kargs.open[i].access & WCB$M_CATHEDRAL) ( 			faoList [j++] = (long) &strCathedral;* 		if	(kargs.open[i].access & WCB$M_NOTFCP)% 			faoList [j++] = (long) &strNotFCP; - 		if	(kargs.open[i].access & WCB$M_OVERDRAWN) ( 			faoList [j++] = (long) &strOverdrawn;, 		if	(kargs.open[i].access & WCB$M_COMPLETE)' 			faoList [j++] = (long) &strComplete; . 		if	(kargs.open[i].acon & (1<<WCB$V_SEQONLY))& 			faoList [j++] = (long) &strSeqonly;, 		if	(kargs.open[i].acon & (1<<WCB$V_SPOOL))$ 			faoList [j++] = (long) &strSpool;- 		if	(kargs.open[i].acon & (1<<WCB$V_NOREAD)) % 			faoList [j++] = (long) &strNoRead; . 		if	(kargs.open[i].acon & (1<<WCB$V_NOWRITE))& 			faoList [j++] = (long) &strNoWrite;  7 		faoList [j] = 0;	/* Terminate item list here	      */   : 		/* Special case: on AXP, the Virtual I/O Cache has files< 		 * open for some periods of time.  Include a special check= 		 * here for that case (process is VMS, reads = 0, writes is " 		 * non-zero, and access is READ. 		 */ ( 		if ((lowPID == 0)		/* Opened by VMS */. 		&& (kargs.open[i].reads == 0)	/* No reads */7 		&& (kargs.open[i].writes != 0)	/* Some # of writes */ + 		&& !(kargs.open[i].access & WCB$M_WRITE)) ! 			faoList[4] = (long) &strReadC;   ' 		faoFmt.dsc$w_length = 28 + ((j-5)*3); , 					/* Compute length of item list	      */4 		sys$faol (&faoFmt, &fileDesc, &fileDesc, faoList); 		lib$put_output (&fileDesc);  		}  	} }    /*  * ROUTINE:	SEARCH_LIST   *  * FUNCTIONAL DESCRIPTION:>  *	Subroutine to traverse FCB list looking for a matching FID.  *
  * INPUTS:  *	None.  *  * IMPLICIT INPUTS:   *	KARGS structure  *  * ENVIRONMENT: 6  *	Kernel mode code that acquires the FILSYS spinlock.  *  */  int search_list () {   H extern	int find_device_ucb ();		/* Find UCB associated w/ device      */@ extern 	int lock_filsys ();		/* Acquire FILSYS spinlock	      */B extern 	int unlock_filsys ();		/* Release FILSYS spinlock	      */  
 #ifdef __DECC* #pragma extern_model save*" #pragma extern_model strict_refdef #endifG GLOBALREF long EXE$GL_SYSUCB;		/* Address of SYS$SYSDEVICE UCB	      */b  
 #ifdef __DECCt  #pragma extern_model globalvalue #endifA GLOBALVALUE UCB$L_VCB;			/* Obtain Volume Control Block offset */*= GLOBALVALUE VCB$L_FCBFL;		/* VCB FCB listhead offset	      */*= GLOBALVALUE VCB$L_FCBBL;		/* VCB FCB listtail offset	      */O? GLOBALVALUE FCB$L_FCBFL;		/* FCB forward queue pointer	      */wB GLOBALVALUE FCB$L_WLFL;			/* FCB WCB queue forward pointer      */: GLOBALVALUE FCB$L_FILESIZE;		/* Size of the file		      */: GLOBALVALUE FCB$L_EFBLK;		/* End of file marker 		      */= GLOBALVALUE FCB$W_SEGN;			/* FCB file segment number	      */:8 GLOBALVALUE FCB$W_FID_NUM;		/* FCB file number		      */@ GLOBALVALUE FCB$W_FID_SEQ;		/* FCB file sequence number	      */B GLOBALVALUE FCB$W_FID_RVN;		/* FCB relative volume number	      */> GLOBALVALUE WCB$L_PID;			/* Process ID with file open	      */@ GLOBALVALUE WCB$L_READS;		/* Number of reads completed 	      */A GLOBALVALUE WCB$L_WRITES;		/* Number of writes completed	      */ 4 GLOBALVALUE WCB$B_ACCESS;		/* Access bits			      */> GLOBALVALUE UCB$L_DEVCHAR;		/* Device characteristics	      */   #ifdef __alpha< GLOBALVALUE FCB$L_ACNT;			/* FCB Access CouNT field	      */C GLOBALVALUE FCB$L_REFCNT;		/* FCB number of times file is opened */ 8 GLOBALVALUE FCB$L_STATUS;		/* FCB status field		      */; GLOBALVALUE FCB$L_WCNT;			/* Writer count from FCB	      */, GLOBALVALUE WCB$L_ACON;t #define FCB$W_ACNT FCB$L_ACNTf! #define FCB$W_REFCNT FCB$L_REFCNTG! #define FCB$W_STATUS FCB$L_STATUSa #define FCB$W_WCNT FCB$L_WCNTh #define WCB$W_ACON WCB$L_ACONG6 long	*acon;				/* Address of WCB$W_ACON field	      */ #define ACON_CAST (long *)6 long	*acnt;				/* Address of FCB$W_ACNT field	      */ #define ACNT_CAST (long *)@ unsigned long	*count;			/* Address of FCB$W_REFCNT field      */$ #define COUNT_CAST (unsigned long *)6 long	*wcnt;				/* Address of FCB$W_WCNT field	      */ #define WCNT_CAST (long *)6 long	*sts;				/* Address of FCB$W_STATUS field      */ #define STS_CAST (long *)  #else < GLOBALVALUE FCB$W_ACNT;			/* FCB Access CouNT field	      */C GLOBALVALUE FCB$W_REFCNT;		/* FCB number of times file is opened */<8 GLOBALVALUE FCB$W_STATUS;		/* FCB status field		      */; GLOBALVALUE FCB$W_WCNT;			/* Writer count from FCB	      */  GLOBALVALUE WCB$W_ACON;	7 short	*acon;				/* Address of WCB$W_ACON field	      */  #define ACON_CAST (short *)/7 short	*acnt;				/* Address of FCB$W_ACNT field	      */f #define ACNT_CAST (short *)	A unsigned short	*count;			/* Address of FCB$W_REFCNT field      */ % #define COUNT_CAST (unsigned short *)n7 short	*wcnt;				/* Address of FCB$W_WCNT field	      */  #define WCNT_CAST (short *)*7 short	*sts;				/* Address of FCB$W_STATUS field      */  #define STS_CAST (short *) #endif  
 #ifdef __DECC  #pragma extern_model restore #endif  6 long	*fcb;				/* Address of FCB queue listhead      */: long	*fcbHeader;			/* Saved copy of above address	      */5 long	ucb;				/* Address of UCB for disk device     */v5 long	vcb;				/* Address of Volume Control Block    */e7 long 	*chr;				/* Address of UCB$L_DEVCHAR field     */E1 long	status;				/* Local status variable	      */P8 char	*access;			/* Address of WCB$B_ACCESS field      */6 short	*seg;				/* Address of FCB$W_SEGN field	      */5 long	*id;				/* Used to map FID into a longword    */e6 short	*fid;				/* Used to map FID into a word	      */7 long	*size;				/* Address of FCB$L_FILESIZE field    */ 6 long	*eof;				/* End of file mark, FCB$L_EFBLK      */9 long	*wcbList;			/* Address of 1st WCB queued to FCB   */t/ long	*wcb;				/* Address of WCB entry		      */x4 long	*pid;				/* Address of WCB$L_PID field	      */8 long	*reads;				/* Address of WCB$L_READS field	      */8 long	*writes;			/* Address of WCB$L_WRITES field      */2 long	i;				/* Index into kargs.open array	      */ /*I  *	If the user did not specify a device name in the filespec then we willcG  *	search thru the FCBs hanging off the system disk UCB.  Otherwise, weoC  *	call FIND_DEVICE_UCB to obtain the UCB associated w/ the device.i  */oI if	(kargs.device.dsc$w_length == 0)/* If no device was specified	      */_? 	ucb = EXE$GL_SYSUCB;		/* Use address of system disk UCB     */ 1 else	{				/* Else go look up UCB address	      */r0 	status = find_device_ucb (&kargs.device, &ucb); 	if	(!(status & STS$M_SUCCESS)) : 		return status;		/* Exit back to caller if errors      */ /*0  *	Make sure this is a files oriented device....  */n& 	chr = (long *) (ucb + UCB$L_DEVCHAR);B 	if	(!(*chr & DEV$M_FOD))	/* Is this for a FILES-oriented device*/@ 		return (SS$_IVDEVNAM);	/* No - exit to user mode then	      */ 	} /*D  *	We now have the UCB of the device to examine.  Acquire the FILSYSC  *	spinlock to prevent changes from hosing us.  Then obtain the VCB	  *	address from the UCB.  */gB status	= SS$_NOSUCHFILE;		/* Presume not opened by anyone       */; lock_filsys ();				/* Call Macro-32 routine for spinlock */ A vcb = ucb + UCB$L_VCB;			/* Obtain Volume Control Block address*/sM fcbHeader = (long *) (vcb + VCB$L_FCBFL);	/* Address of FCB listhead	      */ K if	(*fcbHeader == vcb+ VCB$L_FCBBL)/* If there are NO opened files       */e. 	{				/* ... on this device  - unlikely?    */< 	unlock_filsys ();		/* Then relinquish FILSYS spinlock    */3 	return status;			/* And return to caller		      */e 	}E fcb  = (long *) *fcbHeader;		/* Get address of 1st FCB on VCB queue*/d; fcbHeader = fcb;			/* Address of 1st entry on list	      */D5 while (1)				/* Loop until we get back to head of Q*/o      { #ifdef __alphad      count = (unsigned long *) ((char *)fcb + FCB$W_REFCNT);/* Get REFERENCE count from FCB	      */ #elseee      count = (unsigned short *) ((char *)fcb + FCB$W_REFCNT);/* Get REFERENCE count from FCB	      */  #endif:      if	   (*count != 0)		/* Is this FCB in use?		      */ 	   {  /*J  *	File ids, FIDs, consist of six bytes, three contiguous 2 byte entities.H  *	We take advantage of that and map the first two entries as a longword"  *	to make the comparisons faster.  */ 1 	   id = (long *) ((char *) fcb + FCB$W_FID_NUM); " 	   if    (*id == kargs.id.fileid) 		 {2 		 fid = (short *) ((char *) fcb + FCB$W_FID_RVN); /*H  *	If we found the desired file is opened, then collect some informationK  *	on it.  Obtain from the FCB: Sizes, Active Count, Write Count, & Status.   */ / 		 seg = (short *) ((char *) fcb + FCB$W_SEGN);D! 		 if	((*fid == kargs.id.fid [2])	 		    &&   (*seg == 0)) + 			{		/* Is this an extension FCB?	      */u 			kargs.count = *count;5 			size = (long *) ((char *) fcb + FCB$L_FILESIZE);		$ 			kargs.fSize = *size;2/ 			eof = (long *) ((char *) fcb + FCB$L_EFBLK);c 			kargs.eof = *eof;0 			acnt = ACNT_CAST ((char *) fcb + FCB$W_ACNT); 			kargs.acnt = *acnt;0 			wcnt = WCNT_CAST ((char *) fcb + FCB$W_WCNT); 			kargs.wcnt = *wcnt;/ 			seg = (short *) ((char *) fcb + FCB$W_SEGN);O0 			sts = STS_CAST ((char *) fcb + FCB$W_STATUS);: 			kargs.sts = *sts;/* Copy status field from FCB	      */3 			i = 0;		/* Initialize the process index to 0  */ 2 			wcbList = (long *) ((char *) fcb + FCB$L_WLFL);D 			wcb = (long *) *wcbList; /* Get 1st WCB entry on FCB queue     */ /*D  *	For each WCB entry queued to the FCB obtain information about the0  *	process and the way it is accessing the file.  */x 			while (1) 		 		{. 				pid = (long *) ((char *) wcb + WCB$L_PID); 				kargs.open[i].pid  = *pid;2 				reads = (long *) ((char *) wcb + WCB$L_READS);! 				kargs.open[i].reads = *reads;d4 				writes = (long *) ((char *) wcb + WCB$L_WRITES);# 				kargs.open[i].writes = *writes; ) 				access = (char *) wcb + WCB$B_ACCESS;"# 				kargs.open[i].access = *access;/1 				acon = ACON_CAST ((char *) wcb + WCB$W_ACON);R! 				kargs.open[i++].acon = *acon;* 				wcb = (long *) *wcb; 				if	(wcb == wcbList)  					break;" 				if	(i > processCount)i 					break;  				}T 			status = SS$_NORMAL;O3 			break;		/* Say found the file open & exit loop*/s 			} 		 } 	   }PD      fcb  = (long *) *fcb;		/* Get address of next FCB in queue   */D      if (fcb == fcbHeader)		/* Loop until we get back to head of Q*/2 	   break;			/* Jump out of loop if we do	      */3      }					/* Point at NEXT FCB and loop back    */  /*G  *	When we get here we have either found the file of interest and taken F  *	an expedited exit from the loop or we have search thru all the FCBsE  *	and were unable to find the file on the FCB list.  Either way, we o=  *	will release the FILSYS spinlock and return to our caller.t  */u< unlock_filsys ();			/* Relinquish FILSYS spinlock first   */3 return status;				/* Then return to caller	      */  }L   /*>  *	Dummy routine to make addressing the end of routine easier.  */i
 void dummy ()w {r }n