 /*  *++  *  * Module: popd.c   *  * Abstract:F  *	This module manages a set of routines to change the current workingB  *	directory. To change the current default directory the function  *	SET_DEFAULT is called.   *  * Environment:   *	VAX/VMS operating system.  *	  * Notes:   *  * Constraints:   *
  * Author:  *	Eric M. LaFranchi  *  * Creation Date:   *	22-jun-1988  *  * Modification History:  *  *--  */   = #include <ctype.h>			/* Character Type Classification Mac  */ ; #include <ssdef.h>			/* Standard VMS messages code	      */ : #include <stdio.h>			/* Standard I/O definitions.	      */> #include <stdlib.h>			/* Standard library definitions.      */> #include <string.h>			/* Standard string definitions.       */> #include <descrip.h>			/* VMS descriptor definitions.	      */A #include <climsgdef.h>			/* Command definition utility symbols.*/   > #include "dirutl.h"			/* directory utility macros and def   */  ,     /* CLI qualifier descriptor definitions.      */ 9 static const $DESCRIPTOR( pop_entry, "DIRECTORY_ENTRY" ); ; static const $DESCRIPTOR( remove_dir, "REMOVE_DIRECTORY" ); ? static const $DESCRIPTOR( validate_dir, "VALIDATE_DIRECTORY" ); A static const $DESCRIPTOR( delete_all, "DELETE_ALL_DIRECTORIES" );      /*  *++  * Function: change_default( )  *  * Abstract:C  *	The change_default routine changes the default directory to the    *	specified directory.   *
  * Inputs:  *	None   *  * Outputs:   *	None   *  * Return Value:  *	VMS status code  *--  */  static unsigned long int 2 change_default( struct dsc$descriptor_s *new_dir ) { !     static $DESCALLOC( def_dir );        char dirbuf[MAXDIRLEN];        register status;   	/* initialize descriptors 	 */3     $DESCFILL( def_dir, sizeof( dirbuf ), dirbuf );   5 	/* change our current directory to the new directory  	 */$     status = set_default( new_dir );+     if ( !(status & 1) ) return ( status );   ' 	/* write out the new default directory  	 */     show_default( );       return ( SS$_NORMAL ); }    /*  *++  * Function: retrieve_dir( )  *  * Abstract:F  *	retrieve_dir is a recursive subroutine to search down the directoryB  *	stack to the specified entry and pull the entry from the stack.  *
  * Inputs:;  *	dsc -- pointer to descriptor to to contain new directory ;  *	level -- remaining number directories to search in stack   *  * Outputs:   *	None   *  * Return Value:  *	Normal status code   *  * Special Notes: A  *	This is a recursive procedure, all the variables must be auto.   *  *--  */  static unsigned long int 5 retrieve_dir( struct dsc$descriptor_s *const retdesc,   	      unsigned long int level ) {      char dirbuf[MAXDIRLEN]; $     struct dsc$descriptor_s dirspec;       register status;   	/* initial dirspec descriptor 	 */3     $DESCFILL( dirspec, sizeof( dirbuf ), dirbuf );   - 	/* get the top entry off the directory stack  	 */     status = pop( &dirspec ); +     if ( !(status & 1) ) return ( status );        if ( level == 0 )      { . 	retdesc->dsc$w_length = dirspec.dsc$w_length;7 	memcpy( retdesc->dsc$a_pointer, dirspec.dsc$a_pointer,  		retdesc->dsc$w_length );  ( 	    /* Found directory, return success. 	     */ 	return ( SS$_NORMAL );      }   .     status = retrieve_dir( retdesc, --level );+     if ( !(status & 1) ) return ( status );        status = push( &dirspec );     return ( status ); }    /*  *++  * Function: main( )  *  * Abstract:E  *	Main process the command line arguments and performs the operation C  *	of managing the directory stack and changing the current working 
  *	directory.   *
  * Inputs:  *	None   *  * Outputs:   *	None   *  * Return Value:  *	VMS status code  *--  */  static main( )  {      static $DESCALLOC( depth ); !     static $DESCALLOC( dirspec );        char depbuf[MAXDIRLEN];      char dirbuf[MAXDIRLEN]; 
     struct     {  	unsigned short	argcnt;  	unsigned short	msg_opt; 	unsigned long	msg_cod;  	unsigned short	fao_cnt; 	unsigned short	new_opt; 	unsigned long	fao1;
     } msgvec;        register status, lvl;   ! 	/* Initialize dirspec descriptor  	 */1     $DESCFILL( depth, sizeof( depbuf ), depbuf ); 3     $DESCFILL( dirspec, sizeof( dirbuf ), dirbuf );   B 	/* Check if the /ALL qualifier has been specified, if so, pop all( 	 * the entries off the directory stack. 	 */5     if ( CLI$PRESENT( &delete_all ) == CLI$_PRESENT )  	return ( init_stack( ) );  A 	/* Is the /remove qualifier present, if so extract the specified @ 	 * directory entry, otherwise take the top entry off the stack. 	 */5     if ( CLI$PRESENT( &remove_dir ) == CLI$_PRESENT )      { D 	status = CLI$GET_VALUE( &remove_dir, &depth, &depth.dsc$w_length ); 	if ( status != CLI$_ABSENT )  	{4 	    depth.dsc$a_pointer[depth.dsc$w_length] = '\0';- 	    lvl = atol((char *)depth.dsc$a_pointer);  	} 	else 
 	    lvl = 1;    	if ( lvl > 0 ) 2 	    status = retrieve_dir( &dirspec, (lvl - 1) );  # 	if ( !(status & 1) || (lvl <= 0) )  	{ 	    if ( lvl == 0 )! 		status = DIRUTL$_TOPSTACKENTRY; 	 	    else ' 	        status = DIRUTL$_NOSTACKENTRY;   6 		/* build message vector and give message to the user 		 */  	    msgvec.argcnt = 3;  	    msgvec.msg_opt = 0x0f;  	    msgvec.msg_cod = status;  	    msgvec.fao_cnt = 1; 	    msgvec.new_opt = 0x0f;  	    msgvec.fao1 = lvl;   * 	    SYS$PUTMSG( &msgvec, NULL, NULL, 0 ); 	    SYS$EXIT( SS$_NORMAL ); 	}   	return( SS$_NORMAL );     }   @ 	/* Is the /entry qualifier present, if so extract the specified, 	 * stack entry and set the directory to it. 	 */4     if ( CLI$PRESENT( &pop_entry ) == CLI$_PRESENT )     { C 	status = CLI$GET_VALUE( &pop_entry, &depth, &depth.dsc$w_length ); 0 	depth.dsc$a_pointer[depth.dsc$w_length] = '\0';) 	lvl = atol((char *)depth.dsc$a_pointer);    	if ( lvl > 0 ) 2 	    status = retrieve_dir( &dirspec, (lvl - 1) );  # 	if ( !(status & 1) || (lvl <= 0) )  	{ 	    if ( lvl == 0 )! 		status = DIRUTL$_TOPSTACKENTRY; 	 	    else ' 	        status = DIRUTL$_NOSTACKENTRY;   6 		/* build message vector and give message to the user 		 */  	    msgvec.argcnt = 3;  	    msgvec.msg_opt = 0x0f;  	    msgvec.msg_cod = status;  	    msgvec.fao_cnt = 1; 	    msgvec.new_opt = 0x0f;  	    msgvec.fao1 = lvl;   * 	    SYS$PUTMSG( &msgvec, NULL, NULL, 0 ); 	    SYS$EXIT( SS$_NORMAL ); 	}       }      else' 	if ( !((status = pop(&dirspec)) & 1) )  	    return ( status );   ) 	/* Change the current working directory.  	 */(     status = change_default( &dirspec );+     if ( !(status & 1) ) return ( status );        return( SS$_NORMAL );  } 