%       SUBROUTINE QUEUE_ETHER_READ_ETH  C - CP DATA DECLARATIONS for QUEUE_ETHER_READ_ETH  C        IMPLICIT NONE  C  C   declare local variables  C 4       INTEGER*4 ILV_STATUS, QLV_DELAY(2)/-200000,-1/ C  C   declare local COMMON's C         INCLUDE 'ETHERMON_ETH.INC' C  C   declare local procedures C *       EXTERNAL	ETHER_READ_ETH, ETHER_DELAY C  C   declare system procedures  C #       INTEGER*4 SYS$QIO, SYS$SETIMR "       EXTERNAL	SYS$QIO, SYS$SETIMR C ! C   declare system symbolic codes  C        EXTERNAL	IO$_READVBLK  C  CP BEGIN QUEUE_ETHER_READ_ETH  CP.  update read counter C )       NCVETH_READCOUNT=NCVETH_READCOUNT+1  C 0 CP.  IF read count exceeds NCPETH_WAITCOUNT THEN C 2       IF(NCVETH_READCOUNT.GT.NCPETH_WAITCOUNT)THEN C C CP.  .  queue delay timer (to give main-level code time to execute)  C 3 	ILV_STATUS=SYS$SETIMR(%VAL(0),		! use scratch EF#, 4      +			      QLV_DELAY,	! specify 20 milliseconds,<      +			      ETHER_DELAY,%VAL(1500))! specify delay timer. 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF C 	 CP.  ELSE  C 
       ELSE C 5 CP.  .  zero the packet header buffer's protocol area  C  	SCVETH_ADDRBUF.CLR_PROT=0 	SCVETH_ADDRBUF.ECTL=0 	SCVETH_ADDRBUF.PID(0)=0 	SCVETH_ADDRBUF.PID(1)=0 	SCVETH_ADDRBUF.PID(2)=0 	SCVETH_ADDRBUF.PID(3)=0 	SCVETH_ADDRBUF.PID(4)=0 C 7 CP.  .  queue another read request to the Ethernet port  C 0 	ILV_STATUS=SYS$QIO(%VAL(0),		! use scratch EFN,9      +			 %VAL(NCVETH_CHAN),	! specify channel to device, ,      +			 IO$_READVBLK,		! specify function,8      +			 %REF(NCVETH_IOSB),	! specify I/O status block,)      +			 ETHER_READ_ETH,,	! specify AST, 0      +			 %REF(BCVETH_RCVBUF),	! specify buffer,;      +			 %VAL(ICPETH_MAXBUFSIZ),,,		! specify buffer size, >      +			 %REF(SCVETH_ADDRBUF),)	! specify no more parameters. 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END QUEUE_ETHER_READ_ETH  C 	       END        OPTIONS /CHECK=NOOVERFLOW        SUBROUTINE ETHER_DELAY C $ CP DATA DECLARATIONS for ETHER_DELAY C        IMPLICIT NONE  C  C   declare local COMMON's C         INCLUDE 'ETHERMON_CMD.INC'        INCLUDE 'ETHERMON_ETH.INC' C ! C   declare system symbolic codes  C        EXTERNAL NMA$C_LINFM_ETH C  CP BEGIN ETHER_DELAY CP.  zero read counter C        NCVETH_READCOUNT=0A       IF(.NOT.LCVCMD_INPROGRESS) NCVETH_READCOUNT=NCPETH_IDLEWAIT  C  CP.  update performance counter  C )       ICVETH_COUNTWAIT=ICVETH_COUNTWAIT+1  C " CP   queue up a real Ethernet read C !       IF(.NOT.LCVETH_STARTED)THEN 	 	CONTINUE         ELSEIF(LCVETH_FASTQIO)THEN 	CALL QUEUE_ETHER_READ_FAST 5       ELSEIF(ICVETH_FMT.EQ.%LOC(NMA$C_LINFM_ETH))THEN  	CALL QUEUE_ETHER_READ_ETH
       ELSE 	CALL QUEUE_ETHER_READ_IEEE        ENDIF  C  CP.  RETURN  C        RETURN C  CP END ETHER_DELAY C 	       END        SUBROUTINE ETHER_READ_ETH  C ' CP DATA DECLARATIONS for ETHER_READ_ETH  C        IMPLICIT NONE  C  C   declare local COMMON's C         INCLUDE 'ETHERMON_ETH.INC' C ( C   declare local symbolic message codes C        EXTERNAL	ETH__CMPETHRD C  CP BEGIN ETHER_READ_ETH % CP.  IF interface is not running THEN  C !       IF(.NOT.LCVETH_STARTED)THEN  C  CP.  .  do nothing C 	 	CONTINUE  C , CP.  ELSEIF status of read is erroneous THEN C %       ELSEIF(.NOT.NCVETH_IOSB(0))THEN  C  CP.  .  report error C 5 	CALL LIB$SIGNAL(ETH__CMPETHRD,,%VAL(NCVETH_IOSB(0)))  C 	 CP.  ELSE  C 
       ELSE C C CP.  .  determine if packet is Ethernet or IEEE 802 extended format  C 4 	LCVETH_IEEE=.FALSE.	! always assume Ethernet format 	NCVETH_HDRSIZE=14# 	NCVETH_PROT=SCVETH_ADDRBUF.W_PROT  A 	IF(SCVETH_ADDRBUF.W_PROT .NE. 'AAAA'X)THEN	! IEEE 802 SNAP SAP's < 	  CALL ETHER_READ		! don't pass IEEE 802.3 extended packets 	ENDIF C  CP.  .  queue up another read  C  	CALL QUEUE_ETHER_READ_ETH C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END ETHER_READ_ETH  C 	       END &       SUBROUTINE QUEUE_ETHER_READ_IEEE C . CP DATA DECLARATIONS for QUEUE_ETHER_READ_IEEE C        IMPLICIT NONE  C  C   declare local variables  C 4       INTEGER*4 ILV_STATUS, QLV_DELAY(2)/-200000,-1/ C  C   declare local COMMON's C         INCLUDE 'ETHERMON_ETH.INC' C  C   declare local procedures C +       EXTERNAL	ETHER_READ_IEEE, ETHER_DELAY  C  C   declare system procedures  C #       INTEGER*4 SYS$QIO, SYS$SETIMR "       EXTERNAL	SYS$QIO, SYS$SETIMR C ! C   declare system symbolic codes  C        EXTERNAL	IO$_READVBLK  C  CP BEGIN QUEUE_ETHER_READ_IEEE CP.  update read counter C )       NCVETH_READCOUNT=NCVETH_READCOUNT+1  C 0 CP.  IF read count exceeds NCPETH_WAITCOUNT THEN C 2       IF(NCVETH_READCOUNT.GT.NCPETH_WAITCOUNT)THEN C C CP.  .  queue delay timer (to give main-level code time to execute)  C 3 	ILV_STATUS=SYS$SETIMR(%VAL(0),		! use scratch EF#, 4      +			      QLV_DELAY,	! specify 20 milliseconds,<      +			      ETHER_DELAY,%VAL(1500))! specify delay timer. 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF C 	 CP.  ELSE  C 
       ELSE C 5 CP.  .  zero the packet header buffer's protocol area  C  	SCVETH_ADDRBUF.CLR_PROT=0 	SCVETH_ADDRBUF.ECTL=0 	SCVETH_ADDRBUF.PID(0)=0 	SCVETH_ADDRBUF.PID(1)=0 	SCVETH_ADDRBUF.PID(2)=0 	SCVETH_ADDRBUF.PID(3)=0 	SCVETH_ADDRBUF.PID(4)=0 C 7 CP.  .  queue another read request to the Ethernet port  C 0 	ILV_STATUS=SYS$QIO(%VAL(0),		! use scratch EFN,9      +			 %VAL(NCVETH_CHAN),	! specify channel to device, ,      +			 IO$_READVBLK,		! specify function,8      +			 %REF(NCVETH_IOSB),	! specify I/O status block,*      +			 ETHER_READ_IEEE,,	! specify AST,0      +			 %REF(BCVETH_RCVBUF),	! specify buffer,9      +			 %VAL(ICPETH_MAXBUFSIZ),,,! specify buffer size, >      +			 %REF(SCVETH_ADDRBUF),)	! specify no more parameters. 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END QUEUE_ETHER_READ_IEEE C 	       END         SUBROUTINE ETHER_READ_IEEE C ( CP DATA DECLARATIONS for ETHER_READ_IEEE C        IMPLICIT NONE  C  C   declare local COMMON's C         INCLUDE 'ETHERMON_ETH.INC' C ( C   declare local symbolic message codes C        EXTERNAL	ETH__CMPETHRD C  CP BEGIN ETHER_READ_IEEE% CP.  IF interface is not running THEN  C !       IF(.NOT.LCVETH_STARTED)THEN  C  CP.  .  do nothing C 	 	CONTINUE  C , CP.  ELSEIF status of read is erroneous THEN C %       ELSEIF(.NOT.NCVETH_IOSB(0))THEN  C  CP.  .  report error C 5 	CALL LIB$SIGNAL(ETH__CMPETHRD,,%VAL(NCVETH_IOSB(0)))  C 	 CP.  ELSE  C 
       ELSE C C CP.  .  determine if packet is Ethernet or IEEE 802 extended format  C 8 	LCVETH_IEEE=.FALSE.		! initially assume Ethernet format 	NCVETH_HDRSIZE=14# 	NCVETH_PROT=SCVETH_ADDRBUF.W_PROT  B 	IF(SCVETH_ADDRBUF.W_PROT .EQ. 'AAAA'X .AND.	! IEEE 802 SNAP SAP's-      +	   SCVETH_ADDRBUF.ECTL .EQ. '03'X)THEN ' 	  BCVETH_PROT(0)=SCVETH_ADDRBUF.PID(3) ' 	  BCVETH_PROT(1)=SCVETH_ADDRBUF.PID(4)  	  LCVETH_IEEE=.TRUE.  	  NCVETH_HDRSIZE=22 	ENDIF C  CP.  .  process the message  C  	CALL ETHER_READ C  CP.  .  queue up another read  C  	CALL QUEUE_ETHER_READ_IEEE  C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END ETHER_READ_IEEE C 	       END &       SUBROUTINE QUEUE_ETHER_READ_FAST C . CP DATA DECLARATIONS for QUEUE_ETHER_READ_FAST C        IMPLICIT NONE  C  C   declare local variables  C 4       INTEGER*4 ILV_STATUS, QLV_DELAY(2)/-200000,-1/ C  C   declare local COMMON's C         INCLUDE 'ETHERMON_ETH.INC' C  C   declare local procedures C        INTEGER*4 FAST_$QIO 6       EXTERNAL	FAST_$QIO, ETHER_READ_FAST, ETHER_DELAY C  C   declare system procedures  C        INTEGER*4 SYS$SETIMR       EXTERNAL	SYS$SETIMR  C ! C   declare system symbolic codes  C        EXTERNAL	IO$_READVBLK  C  CP BEGIN QUEUE_ETHER_READ_FAST CP.  update read counter C )       NCVETH_READCOUNT=NCVETH_READCOUNT+1  C 0 CP.  IF read count exceeds NCPETH_WAITCOUNT THEN C 2       IF(NCVETH_READCOUNT.GT.NCPETH_WAITCOUNT)THEN C C CP.  .  queue delay timer (to give main-level code time to execute)  C 3 	ILV_STATUS=SYS$SETIMR(%VAL(0),		! use scratch EF#, 4      +			      QLV_DELAY,	! specify 20 milliseconds,<      +			      ETHER_DELAY,%VAL(1500))! specify delay timer. 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF C 	 CP.  ELSE  C 
       ELSE C 7 CP.  .  queue another read request to the Ethernet port  C 2 	ILV_STATUS=FAST_$QIO(%VAL(0),		! use scratch EFN,9      +			 %VAL(NCVETH_CHAN),	! specify channel to device, ,      +			 IO$_READVBLK,		! specify function,8      +			 %REF(NCVETH_IOSB),	! specify I/O status block,*      +			 ETHER_READ_FAST,,	! specify AST,0      +			 %REF(BCVETH_RCVBUF),	! specify buffer,9      +			 %VAL(ICPETH_MAXBUFSIZ),,,! specify buffer size, >      +			 %REF(SCVETH_ADDRBUF),)	! specify no more parameters. 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END QUEUE_ETHER_READ_FAST C 	       END         SUBROUTINE ETHER_READ_FAST C ( CP DATA DECLARATIONS for ETHER_READ_FAST C        IMPLICIT NONE  C  C   declare local COMMON's C         INCLUDE 'ETHERMON_ETH.INC' C ( C   declare local symbolic message codes C        EXTERNAL	ETH__CMPETHRD C  CP BEGIN ETHER_READ_FAST% CP.  IF interface is not running THEN  C !       IF(.NOT.LCVETH_STARTED)THEN  C  CP.  .  do nothing C 	 	CONTINUE  C , CP.  ELSEIF status of read is erroneous THEN C %       ELSEIF(.NOT.NCVETH_IOSB(0))THEN  C  CP.  .  report error C 5 	CALL LIB$SIGNAL(ETH__CMPETHRD,,%VAL(NCVETH_IOSB(0)))  C 	 CP.  ELSE  C 
       ELSE C I CP.  .  convert packet format to DEC-standard Ethernet or IEEE 802 format  C F 	NCVETH_HDRSIZE=IAND(NCVETH_IOSB(2),'FF'X) ! get len passed by FASTSHR8 	IF(NCVETH_HDRSIZE.GT.2) NCVETH_HDRSIZE=NCVETH_HDRSIZE+29 	NCVETH_HDRSIZE=NCVETH_HDRSIZE+12	! add size of addresses  	IF(NCVETH_HDRSIZE.EQ.14)THEN  	  LCVETH_IEEE=0% 	  NCVETH_PROT=SCVETH_ADDRBUF.W_PROT  ! 	ELSEIF(NCVETH_HDRSIZE.EQ.22)THEN  	  LCVETH_IEEE=-1 ' 	  BCVETH_PROT(0)=SCVETH_ADDRBUF.PID(3) ' 	  BCVETH_PROT(1)=SCVETH_ADDRBUF.PID(4) ! 	ELSEIF(NCVETH_HDRSIZE.EQ.17)THEN  	  LCVETH_IEEE=+1 % 	  BCVETH_PROT(0)=SCVETH_ADDRBUF.DSAP % 	  BCVETH_PROT(1)=SCVETH_ADDRBUF.SSAP ! 	ELSEIF(NCVETH_HDRSIZE.EQ.18)THEN  	  LCVETH_IEEE=+1 % 	  BCVETH_PROT(0)=SCVETH_ADDRBUF.DSAP % 	  BCVETH_PROT(1)=SCVETH_ADDRBUF.SSAP  	ENDIF C  CP.  .  process the message  C  	CALL ETHER_READ C  CP.  .  queue up another read  C  	CALL QUEUE_ETHER_READ_FAST  C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END ETHER_READ_FAST C 	       END        OPTIONS /CHECK=NOOVERFLOW        SUBROUTINE ETHER_READ  C # CP DATA DECLARATIONS for ETHER_READ  C        IMPLICIT NONE  C  C   declare local variables  C         INTEGER*4 ILP_MOP_DEVTYPES$       PARAMETER(ILP_MOP_DEVTYPES=20)       BYTE	BLV_MOP_VER8       BYTE	B_PKT_LEN(0:1), BLV_MOP_FUNC, BLV_MOP_SYSTYP,;      +		BLV_MOP_DEVTYP, BLV_MOP_HWA(0:5), BLV_MOP_CUA(0:5), 7      +		BLV_DEVTYP_MOP(ILP_MOP_DEVTYPES), B_SPORT(0:1),       +		B_DPORT(0:1)4       CHARACTER*6 CLV_MOP_DEVTYPES(ILP_MOP_DEVTYPES)*       CHARACTER*6 CLV_MOP_HWA, CLV_MOP_CUA       CHARACTER*23 CLV_TIME        CHARACTER*40 CLV_SCR?       INTEGER*2 LN, W_PKT_LEN, NLV_MOP_HWA(0:2), NLV_IOSB(0:3),       +		N_SPORT, N_DPORTG       INTEGER*4 I, J, K, QLV_TIME(2), ILV_NFBDSC(0:1), ILV_KEYDSC(0:1), :      +		ILV_BUFDSC(0:1), ILV_KEY(0:1), ILV_STATUS, ILV_SI,4      +		ILV_DI, ILV_SM, ILV_DM, ILV_PI, ILV_S_MANUF,       +		ILV_D_MANUF, ILV_MOP_HWA:       LOGICAL*4 LLV_EXCLUDE, LLV_ONLY(3), LLV_ONLYEXIST(3)(       LOGICAL*1 LLV_PROTKNOWN(0:'FFFF'X)@       DATA LLV_PROTKNOWN('0360'X)/.TRUE./,	! DEC: DECnet Phase 4>      +	   LLV_PROTKNOWN('0160'X)/.TRUE./,	! DEC: MOP Dump/LoadC      +	   LLV_PROTKNOWN('0260'X)/.TRUE./,	! DEC: MOP Remote Console 5      +	   LLV_PROTKNOWN('0760'X)/.TRUE./,	! DEC: LAVC ;      +	   LLV_PROTKNOWN('0008'X)/.TRUE./,	! DoD Internet IP 8      +	   LLV_PROTKNOWN('0608'X)/.TRUE./,	! Internet ARP7      +	   LLV_PROTKNOWN('3580'X)/.TRUE./,	! Reverse ARP ?      +	   LLV_PROTKNOWN('0006'X)/.TRUE./,	! XEROX: NS IDP (U-B) 6      +	   LLV_PROTKNOWN('9B80'X)/.TRUE./,	! AppleTalk 9      +	   LLV_PROTKNOWN('F380'X)/.TRUE./,	! AppleTalk ARP 4      +	   LLV_PROTKNOWN('0460'X)/.TRUE./,	! DEC: LAT@      +	   LLV_PROTKNOWN('8808'X)/.TRUE./,	! Xyplex: terminal net6      +	   LLV_PROTKNOWN('0570'X)/.TRUE./,	! U-B Bridge;      +	   LLV_PROTKNOWN('3880'X)/.TRUE./,	! DEC: LAN Bridge ;      +	   LLV_PROTKNOWN('8080'X)/.TRUE./,	! Vitalink bridge 3      +	   LLV_PROTKNOWN('0090'X)/.TRUE./	! Loopback G       DATA (BLV_DEVTYP_MOP(I),CLV_MOP_DEVTYPES(I),I=1,ILP_MOP_DEVTYPES)       +		/'01'x, 'deuna',      +		 '05'x, 'deqna',      +		 '0B'x, 'delua',-      +		 '15'x, 'debet',	! DEC LAN Bridge 100       +		 '17'x, 'debna',      +		 '21'x, 'lat??',      +		 '25'x, 'delqa',      +		 '27'x, 'desva',      +		 '2B'x, 'PC??1',      +		 '2D'x, 'TrfMn',-      +		 '35'x, 'db200',	! DEC LAN Bridge 200       +		 '3F'x, 'vx??1',      +		 '40'x, 'vx??2',      +		 '41'x, 'debni',      +		 '42'x, 'demna',      +		 '4B'x, 'deqta',A      +		 '4C'x, 'db150',	! DEC LAN Bridge 150 (replacement DEBET) *      +		 '72'x, 'vt1200',	! DEC X-terminal      +		 '75'x, 'MacII',      +		 '79'x, 'CSrtr'/)       EQUIVALENCE (W_PKT_LEN, B_PKT_LEN), ?      +		  (BLV_MOP_HWA, CLV_MOP_HWA, NLV_MOP_HWA, ILV_MOP_HWA), %      +		  (BLV_MOP_CUA, CLV_MOP_CUA),       +		  (B_SPORT, N_SPORT),       +		  (B_DPORT, N_DPORT)       STRUCTURE /ARPMSG/ 	UNION 	  MAP 	    CHARACTER*28 BUF 
 	  END MAP 	  MAP
 	    UNION
 	      MAP 		INTEGER*2	HW_SPACE 		INTEGER*2	PROT_SPACE 	      END MAP
 	      MAP 		BYTE	B_HW_SPACE(0:1) 		BYTE	B_PROT_SPACE(0:1) 	      END MAP 	    END UNION 	    BYTE	H_LEN  	    BYTE	P_LEN 
 	    UNION
 	      MAP 		INTEGER*2	OPCODE 	      END MAP
 	      MAP 		BYTE		B_OPCODE(0:1)  	      END MAP 	    END UNION
 	    UNION
 	      MAP 		BYTE		S_BHWA(0:5)  	      END MAP
 	      MAP 		INTEGER*2	S_HWA(0:2) 	      END MAP
 	      MAP 		INTEGER*4	S_LHWA 	      END MAP 	    END UNION
 	    UNION
 	      MAP 		BYTE	S_PTA(0:3)  	      END MAP
 	      MAP 		INTEGER*4 LS_PTA 	      END MAP 	    END UNION
 	    UNION
 	      MAP 		BYTE		T_BHWA(0:5)  	      END MAP
 	      MAP 		INTEGER*2	T_HWA(0:2) 	      END MAP
 	      MAP 		INTEGER*4	T_LHWA 	      END MAP 	    END UNION
 	    UNION
 	      MAP 		BYTE	T_PTA(0:3)  	      END MAP
 	      MAP 		INTEGER*4 LT_PTA 	      END MAP 	    END UNION
 	  END MAP
 	END UNION       END STRUCTURE ! /ARPMSG/       RECORD /ARPMSG/ SLV_ARP        STRUCTURE /LAVC_ARP/ 	UNION 	 MAP  	  CHARACTER*56 BUF 	 	 END MAP  	 MAP  	  INTEGER*2 PAD_LEN 	  UNION 	    MAP 	      INTEGER*2 DEST(0:2) 	    END MAP 	    MAP 	      INTEGER*4 LDEST 	      INTEGER*2 LDEST4  	    END MAP 	  END UNION 	  INTEGER*2 W_GROUP 	  UNION 	    MAP 	      INTEGER*2 SRC(0:2)  	    END MAP 	    MAP 	      INTEGER*4 LSRC  	      INTEGER*2 LSRC4 	    END MAP 	  END UNION 	  INTEGER*4 DUMMY2(0:1) 	  INTEGER*2 DUMMY25 	  BYTE	NAMELEN  	  CHARACTER*6 NAME  	  INTEGER*2 %FILL 	  BYTE	DUMMY3(0:4)  	  INTEGER*4 %FILL(2)  	  INTEGER*4 DUMMY4  	  INTEGER*4 NODE_CLASS 	 	 END MAP 
 	END UNION        END STRUCTURE ! /LAVC_ARP/        RECORD /LAVC_ARP/ SLV_LAVC       STRUCTURE /IP/ 	UNION 	  MAP 	    CHARACTER*20 BUF 
 	  END MAP 	  MAP 	    BYTE	VERS_IHL 	    BYTE	SVCTYP 	    INTEGER*2	LENGTH  	    INTEGER*2	ID  	    INTEGER*2	FRAG_OFF 
 	    BYTE	TTL  	    BYTE	PROTOCOL 	    INTEGER*2	CHECKSUM 
 	    UNION
 	      MAP 		BYTE	SRC(0:3)  		BYTE	DEST(0:3) 	      END MAP
 	      MAP 		INTEGER*4 LSRC 		INTEGER*4 LDEST  	      END MAP 	    END UNION
 	  END MAP
 	END UNION       END STRUCTURE ! /IP/       RECORD /IP/ SLV_IP       STRUCTURE /UDP/  	UNION 	  MAP
 	    UNION
 	      MAP 		INTEGER*2 SPORT  		INTEGER*2 DPORT  	      END MAP
 	      MAP 		BYTE	  B_SPORT(0:1)  		BYTE	  B_DPORT(0:1)  	      END MAP 	    END UNION 	    INTEGER*2 LENGTHT 	    INTEGER*2 CHECKSUME
 	  END MAP 	  MAP 	    CHARACTER*8 BUF
 	  END MAP
 	END UNION       END STRUCTURE ! /UDP/        RECORD /UDP/ SLV_UDP       STRUCTURE /TCP/r 	UNION 	  MAP
 	    UNION
 	      MAP 		INTEGER*2 SPORT  		INTEGER*2 DPORTr 	      END MAP
 	      MAP 		BYTE	  B_SPORT(0:1)D 		BYTE	  B_DPORT(0:1)y 	      END MAP 	    END UNION 	    INTEGER*4 SEQ_NUM 	    INTEGER*4 ACK_NUM 	    INTEGER*2 FLAGS 	    INTEGER*2 WINDOWi 	    INTEGER*2 CHECKSUMN 	    INTEGER*2 URGENT_PTRG
 	  END MAP 	  MAP 	    CHARACTER*20 BUFc
 	  END MAP
 	END UNION       END STRUCTURE ! /TCP/        RECORD /TCP/ SLV_TCP       STRUCTURE /APPLE_DDP/  	UNION 	  MAP 	    BYTE	B_LEN_HOP(0:1) 	    BYTE	B_CSUM(0:1)  	    BYTE	B_DNET(0:1)i 	    BYTE	B_SNET(0:1)  	    BYTE	B_DNODEI 	    BYTE	B_SNODER 	    BYTE	B_DSOCKETt 	    BYTE	B_SSOCKET  	    BYTE	B_DDPTYPEf
 	  END MAP 	  MAP 	    CHARACTER*13 C_BUFY
 	  END MAP
 	END UNION!       END STRUCTURE ! /APPLE_DDP/N        RECORD /APPLE_DDP/ SLV_DDP       STRUCTURE /NFB/E
 	BYTE		FCT 	BYTE		FLAGS 	BYTE		DATABASEp 	BYTE		OPERb 	INTEGER*4	SRCH_KEY  	INTEGER*4	SRCH2_KEY 	INTEGER*2	DUMMY 	INTEGER*2	CELL_SIZE 	INTEGER*4	ITMLST(2)       END STRUCTURE ! /NFB/V       RECORD /NFB/ SLV_NFB!       PARAMETER NFB$C_FC_SHOW=34,.      +		NFB$M_NOUPD='4'X,       +		NFB$C_DB_NDI=2,h      +		NFB$C_OP_EQL=0,V      +		NFB$C_WILDCARD=1,       +		NFB$C_NDI_ADD=33619986,N      +		NFB$C_NDI_NNA=33685571       STRUCTURE /XNS/O 	UNION 	  MAP 	    CHARACTER*54 BUF+
 	  END MAP 	  MAP" 	    INTEGER*2	DUMMY		! XNS header 	    INTEGER*2	LENGTH! 	    BYTE	HOPCOUNT 	    BYTE	TYPE! 	    PARAMETER	BLP_XNSTYP_PEP = 4+ 	    INTEGER*4	DNETF 	    INTEGER*2	DNODE(0:2)i 	    INTEGER*2	DSOCKET 	    INTEGER*4	SNETi 	    INTEGER*2	SNODE(0:2)( 	    INTEGER*2	SSOCKET# 	    INTEGER*4	MSG_ID		! PEP headerE 	    INTEGER*2	CLIENT . 	    PARAMETER	NLP_PEPCLIENT_COURIER = '0100'X0 	    INTEGER*2	COURIER_TYPE	! Courier RPC header 	    INTEGER*2	COURIER_TRNID 	    INTEGER*4	COURIER_PGMID 	    INTEGER*2	COURIER_VERSO 	    INTEGER*2	COURIER_PROCIDM 	    INTEGER*4	%FILL 	    INTEGER*2	COURIER_ARGCNT 
 	  END MAP
 	END UNION       END STRUCTURE ! /XNS/_       RECORD /XNS/ SLV_XNS Cm" C   declare system data structures CA!       INCLUDE '($FABDEF)	/NOLIST'L!       INCLUDE '($NAMDEF)	/NOLIST' !       INCLUDE '($RABDEF)	/NOLIST'. CC C   declare local COMMON's C=!       INCLUDE 'ETHERMON_ADDR.INC'e$       INCLUDE 'ETHERMON_BRIDGES.INC'        INCLUDE 'ETHERMON_ETH.INC'#       INCLUDE 'ETHERMON_FILTER.INC' "       INCLUDE 'ETHERMON_MANUF.INC'!       INCLUDE 'ETHERMON_PING.INC'A!       INCLUDE 'ETHERMON_PROT.INC'F"       INCLUDE 'ETHERMON_STATS.INC'"       INCLUDE 'ETHERMON_TCPIP.INC'"       INCLUDE 'ETHERMON_TRACE.INC' CU C   declare local procedures C        LOGICAL*1 VALIDATE_IPADDRN,       EXTERNAL	NETACP_QUERY, VALIDATE_IPADDR CU( C   declare local symbolic message codes CT9       EXTERNAL	ETH__QIONETACP, ETH__IMOPMSG, ETH__MOPMSG, 6      +		ETH__BADAPPLE, ETH__FNDINETGW, ETH__FNDMLTIPA,5      +		ETH__PROXYARP, ETH__UNKIPARP, ETH__UNKARPOPC, 6      +		ETH__ERRQWRMBX, ETH__ERRCWRMBX, ETH__DUPIPADR,!      +		ETH__MDUPIP, ETH__NEWNODEgK       EXTERNAL	ETH__ADRPROTOVF, ETH__NONSTDMOP, ETH__PROTBLOVF, ! debuggingC5      +		ETH__ADRTBLOVF, ETH__MNFTBLOVF			 ! debuggingH C  C   declare system proceduresS C)*       INTEGER*4 SYS$QIO, SYS$PUT, SYS$QIOW)       EXTERNAL	SYS$QIO, SYS$PUT, SYS$QIOW0 C ! C   declare system symbolic codes  CP!       INCLUDE '($IODEF)		/NOLIST'e!       INCLUDE '($SSDEF)		/NOLIST'  CV CP BEGIN ETHER_READw- CP.  add entry to protocol and address tables  CV       ILV_PI=ICVPRT_NUMNAMES>       DO WHILE ((NCVPRT_PROT_NUM(ILV_PI) .NE. NCVETH_PROT .OR.;      +		   LCVPRT_PROT_IEEE(ILV_PI) .NE. LCVETH_IEEE) .AND.p      +		  ILV_PI .GT. 1) 	ILV_PI=ILV_PI-1       ENDDOC6       IF(NCVPRT_PROT_NUM(ILV_PI) .NE. NCVETH_PROT .OR.6      +	 LCVPRT_PROT_IEEE(ILV_PI) .NE. LCVETH_IEEE)THEN- 	IF(ICVPRT_NUMNAMES .GE. ICPPRT_MAXNAMES)THENE! 	  IF(LCVETH_MESSAGES .EQ. 3)THENL$ 	    CALL LIB$SIGNAL(ETH__PROTBLOVF) 	  ENDIF 	  ILV_PI=0  	ELSE $ 	  ICVPRT_NUMNAMES=ICVPRT_NUMNAMES+1 	  ILV_PI=ICVPRT_NUMNAMESA& 	  NCVPRT_PROT_NUM(ILV_PI)=NCVETH_PROT 	  CCVPRT_PROTNAM(ILV_PI)=' 'H 	  NCVPRT_PROTNAMLEN(ILV_PI)=0' 	  LCVPRT_PROT_IEEE(ILV_PI)=LCVETH_IEEER 	ENDIF       ENDIFA       LCVPRT_REF(ILV_PI)=.TRUE.u@       ILV_SI=IAND(ZEXT(SCVETH_ADDRBUF.W_SRC(2)),ICPADR_MAXADDRS)	       I=0E.       DO WHILE ((SCVADR_ADDR(ILV_SI).LNUM .NE."      +				SCVETH_ADDRBUF.LSRC .OR.(      +		 SCVADR_ADDR(ILV_SI).NUM(2) .NE.(      +				SCVETH_ADDRBUF.W_SRC(2)) .AND."      +		ICVADR_FLAGS(ILV_SI) .AND.!      +		I.LT.(ICPADR_MAXADDRS/2))H& 	ILV_SI=IAND(ILV_SI+1,ICPADR_MAXADDRS) 	I=I+1       ENDDO "       IF(ICVADR_FLAGS(ILV_SI))THENA         IF(SCVADR_ADDR(ILV_SI).LNUM .NE. SCVETH_ADDRBUF.LSRC .OR.(F      +	   SCVADR_ADDR(ILV_SI).NUM(2) .NE. SCVETH_ADDRBUF.W_SRC(2))THEN 	  ILV_SI=-1! 	  IF(LCVETH_MESSAGES .EQ. 3)THENp$ 	    CALL LIB$SIGNAL(ETH__ADRTBLOVF) 	  ENDIF 	ELSEI= 	  ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_SREF)L 	  I=1,    10	  DO WHILE (I.LE.ICPADR_MAXPROTS .AND.,      +		    BCVADR_PROTFLAGS(I,ILV_SI) .AND.7      +		    NCVADR_PROTONADDR(I,ILV_SI).NE.NCVETH_PROT)R
 	    I=I+1 	  ENDDO 	  IF(I.LE.ICPADR_MAXPROTS)THEN.5 	    IF(BCVADR_PROTFLAGS(I,ILV_SI).AND.	! slot in usenF      +	       (((BCVADR_PROTFLAGS(I,ILV_SI).AND.ICPADR_IEEE).NE.0.AND.      +		 .NOT.LCVETH_IEEE).OR.F      +	        ((BCVADR_PROTFLAGS(I,ILV_SI).AND.ICPADR_IEEE).EQ.0.AND.      +		 LCVETH_IEEE)))THEN  	      I=I+1 	      GOTO 10
 	    ENDIF, 	    NCVADR_PROTONADDR(I,ILV_SI)=NCVETH_PROT 	    IF(LCVETH_IEEE)THEN@ 	      BCVADR_PROTFLAGS(I,ILV_SI)=BCVADR_PROTFLAGS(I,ILV_SI).OR./      +				(ICPADR_USED+ICPADR_SREF+ICPADR_IEEE)_	 	    ELSE!@ 	      BCVADR_PROTFLAGS(I,ILV_SI)=BCVADR_PROTFLAGS(I,ILV_SI).OR.#      +				(ICPADR_USED+ICPADR_SREF) 
 	    ENDIF% 	  ELSEIF(LCVETH_MESSAGES .EQ. 3)THEN B 	    CALL LIB$SIGNAL(ETH__ADRPROTOVF,%VAL(8),%VAL(BCVETH_PROT(0)),:      +			%VAL(BCVETH_PROT(1)),%VAL(SCVETH_ADDRBUF.SRC(0)),A      +			%VAL(SCVETH_ADDRBUF.SRC(1)),%VAL(SCVETH_ADDRBUF.SRC(2)),OA      +			%VAL(SCVETH_ADDRBUF.SRC(3)),%VAL(SCVETH_ADDRBUF.SRC(4)), %      +			%VAL(SCVETH_ADDRBUF.SRC(5)))N 	  ENDIF 	ENDIF
       ELSE" 	ICVADR_NUMADDRS=ICVADR_NUMADDRS+1- 	SCVADR_ADDR(ILV_SI).LNUM=SCVETH_ADDRBUF.LSRCS3 	SCVADR_ADDR(ILV_SI).NUM(2)=SCVETH_ADDRBUF.W_SRC(2) - 	ICVADR_FLAGS(ILV_SI)=ICPADR_USED+ICPADR_SREFN( 	NCVADR_PROTONADDR(1,ILV_SI)=NCVETH_PROT 	IF(LCVETH_IEEE)THENA 	  BCVADR_PROTFLAGS(1,ILV_SI)=ICPADR_USED+ICPADR_SREF+ICPADR_IEEE  	ELSE 5 	  BCVADR_PROTFLAGS(1,ILV_SI)=ICPADR_USED+ICPADR_SREF  	ENDIF 	IF(LCVETH_MSGS_ENB(1))THENa( 	  CALL LIB$SIGNAL(ETH__NEWNODE,%VAL(6),A      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),RA      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),0A      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)))V 	ENDIF       ENDIFDA       ILV_DI=IAND(ZEXT(SCVETH_ADDRBUF.W_DEST(2)),ICPADR_MAXADDRS)E	       I=0 .       DO WHILE ((SCVADR_ADDR(ILV_DI).LNUM .NE.#      +				SCVETH_ADDRBUF.LDEST .OR. (      +		 SCVADR_ADDR(ILV_DI).NUM(2) .NE.)      +				SCVETH_ADDRBUF.W_DEST(2)) .AND. "      +		ICVADR_FLAGS(ILV_DI) .AND.!      +		I.LT.(ICPADR_MAXADDRS/2))R& 	ILV_DI=IAND(ILV_DI+1,ICPADR_MAXADDRS) 	I=I+1       ENDDOA"       IF(ICVADR_FLAGS(ILV_DI))THEN; 	IF(SCVADR_ADDR(ILV_DI).LNUM .NE. SCVETH_ADDRBUF.LDEST .OR. G      +	   SCVADR_ADDR(ILV_DI).NUM(2) .NE. SCVETH_ADDRBUF.W_DEST(2))THEN/ 	  ILV_DI=-1! 	  IF(LCVETH_MESSAGES .EQ. 3)THEND$ 	    CALL LIB$SIGNAL(ETH__ADRTBLOVF) 	  ENDIF 	ELSE = 	  ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_DREF)_ 	  I=1,    11	  DO WHILE (I.LE.ICPADR_MAXPROTS .AND.,      +		    BCVADR_PROTFLAGS(I,ILV_DI) .AND.7      +		    NCVADR_PROTONADDR(I,ILV_DI).NE.NCVETH_PROT) 
 	    I=I+1 	  ENDDO 	  IF(I.LE.ICPADR_MAXPROTS)THENE5 	    IF(BCVADR_PROTFLAGS(I,ILV_DI).AND.	! slot in useEF      +	       (((BCVADR_PROTFLAGS(I,ILV_DI).AND.ICPADR_IEEE).NE.0.AND.      +		 .NOT.LCVETH_IEEE).OR.F      +	        ((BCVADR_PROTFLAGS(I,ILV_DI).AND.ICPADR_IEEE).EQ.0.AND.      +		 LCVETH_IEEE)))THENo 	      I=I+1 	      GOTO 11
 	    ENDIF, 	    NCVADR_PROTONADDR(I,ILV_DI)=NCVETH_PROT 	    IF(LCVETH_IEEE)THEN@ 	      BCVADR_PROTFLAGS(I,ILV_DI)=BCVADR_PROTFLAGS(I,ILV_DI).OR./      +				(ICPADR_USED+ICPADR_DREF+ICPADR_IEEE)L	 	    ELSET@ 	      BCVADR_PROTFLAGS(I,ILV_DI)=BCVADR_PROTFLAGS(I,ILV_DI).OR.#      +				(ICPADR_USED+ICPADR_DREF)p
 	    ENDIF% 	  ELSEIF(LCVETH_MESSAGES .EQ. 3)THENaB 	    CALL LIB$SIGNAL(ETH__ADRPROTOVF,%VAL(8),%VAL(BCVETH_PROT(0)),:      +		%VAL(BCVETH_PROT(1)),%VAL(SCVETH_ADDRBUF.DEST(0)),B      +		%VAL(SCVETH_ADDRBUF.DEST(1)),%VAL(SCVETH_ADDRBUF.DEST(2)),B      +		%VAL(SCVETH_ADDRBUF.DEST(3)),%VAL(SCVETH_ADDRBUF.DEST(4)),%      +		%VAL(SCVETH_ADDRBUF.DEST(5)))! 	  ENDIF 	ENDIF
       ELSE" 	ICVADR_NUMADDRS=ICVADR_NUMADDRS+1. 	SCVADR_ADDR(ILV_DI).LNUM=SCVETH_ADDRBUF.LDEST4 	SCVADR_ADDR(ILV_DI).NUM(2)=SCVETH_ADDRBUF.W_DEST(2)- 	ICVADR_FLAGS(ILV_DI)=ICPADR_USED+ICPADR_DREF ( 	NCVADR_PROTONADDR(1,ILV_DI)=NCVETH_PROT 	IF(LCVETH_IEEE)THENA 	  BCVADR_PROTFLAGS(1,ILV_DI)=ICPADR_USED+ICPADR_DREF+ICPADR_IEEER 	ELSEA5 	  BCVADR_PROTFLAGS(1,ILV_DI)=ICPADR_USED+ICPADR_DREFM 	ENDIF       ENDIFD7       ILV_S_MANUF=IAND(SCVETH_ADDRBUF.LSRC,'00FFFFFE'X)a       ILV_SM=ICVMNF_NUMNAMES?       DO WHILE (ICVMNF_MANUF_NUM(ILV_SM) .NE. ILV_S_MANUF .AND.n      +		ILV_SM .GT. 1) 	ILV_SM=ILV_SM-1       ENDDO 7       IF(ICVMNF_MANUF_NUM(ILV_SM) .NE. ILV_S_MANUF)THEN + 	IF(ICVMNF_NUMNAMES.GE.ICPMNF_MAXNAMES)THENL! 	  IF(LCVETH_MESSAGES .EQ. 3)THEN $ 	    CALL LIB$SIGNAL(ETH__MNFTBLOVF) 	  ENDIF 	  ILV_SM=0L 	ELSE_$ 	  ICVMNF_NUMNAMES=ICVMNF_NUMNAMES+1 	  ILV_SM=ICVMNF_NUMNAMESa' 	  ICVMNF_MANUF_NUM(ILV_SM)=ILV_S_MANUFE 	  CCVMNF_MANUFNAM(ILV_SM)=' ' 	  NCVMNF_MANUFNAMLEN(ILV_SM)=0g 	  CCVMNF_NAM(ILV_SM)=' 'I 	  NCVMNF_NAMLEN(ILV_SM)=0 	  LCVMNF_SREF(ILV_SM)=.TRUE.V 	ENDIF
       ELSE 	LCVMNF_SREF(ILV_SM)=.TRUE.s       ENDIFE8       ILV_D_MANUF=IAND(SCVETH_ADDRBUF.LDEST,'00FFFFFE'X)(       IF(ILV_S_MANUF.EQ.ILV_D_MANUF)THEN 	ILV_DM=ILV_SM 	LCVMNF_DREF(ILV_DM)=.TRUE.T
       ELSE 	ILV_DM=ICVMNF_NUMNAMESB: 	DO WHILE (ICVMNF_MANUF_NUM(ILV_DM) .NE. ILV_D_MANUF .AND.      +		  ILV_DM .GT. 1) 	  ILV_DM=ILV_DM-1 	ENDDO2 	IF(ICVMNF_MANUF_NUM(ILV_DM) .NE. ILV_D_MANUF)THEN- 	  IF(ICVMNF_NUMNAMES.GE.ICPMNF_MAXNAMES)THENL# 	    IF(LCVETH_MESSAGES .EQ. 3)THENE& 	      CALL LIB$SIGNAL(ETH__MNFTBLOVF)
 	    ENDIF
 	    ILV_DM=0  	  ELSE & 	    ICVMNF_NUMNAMES=ICVMNF_NUMNAMES+1 	    ILV_DM=ICVMNF_NUMNAMESh) 	    ICVMNF_MANUF_NUM(ILV_DM)=ILV_D_MANUF   	    CCVMNF_MANUFNAM(ILV_DM)=' '! 	    NCVMNF_MANUFNAMLEN(ILV_DM)=0  	    CCVMNF_NAM(ILV_DM)=' '  	    NCVMNF_NAMLEN(ILV_DM)=0 	    LCVMNF_DREF(ILV_DM)=.TRUE.E 	  ENDIF 	ELSE  	  LCVMNF_DREF(ILV_DM)=.TRUE.R 	ENDIF       ENDIFC CN> CP.  IF protocol type is not yet decipherable by ETHERMON THEN C_4       IF(.NOT.LLV_PROTKNOWN(JZEXT(NCVETH_PROT)))THEN CE CP.  .  do nothing CE	 	CONTINUE0 C,L CP.  ELSEIF protocol type is XEROX NS IDP (06-00) or U-B Bridge (70-05) THEN C_)       ELSEIF((NCVETH_PROT .EQ.'0006'X.OR.D*      +	      NCVETH_PROT .EQ.'0570'X).AND.!      +	     .NOT.LCVETH_IEEE)THENP CI* CP.  .  IF XNS and source index legal THEN C," 	IF(NCVETH_PROT .EQ. '0006'X .AND.      +	   ILV_SI .GE. 0)THEN CR0 CP.  .  .  copy XNS prefix into header structure CV0 	  SLV_XNS.BUF=CCVETH_RCVBUF(1:LEN(SLV_XNS.BUF)) C*D CP.  .  .  IF datalink source matches XNS header source address THEN CU9 	  IF(SLV_XNS.SNODE(0) .EQ. SCVETH_ADDRBUF.W_SRC(0) .AND.I?      +	     SLV_XNS.SNODE(1) .EQ. SCVETH_ADDRBUF.W_SRC(1) .AND.M>      +	     SLV_XNS.SNODE(2) .EQ. SCVETH_ADDRBUF.W_SRC(2))THEN C ! CP.  .  .  .  save network numberF C)* 	    ICVADR_XNSNETNUM(ILV_SI)=SLV_XNS.SNET CD CP.  .  .  ENDIF C  	  ENDIF CR
 CP.  .  ENDIF) CR 	ENDIF C:A CP.  .  IF source Ethernet address looks like Ungermann-Bass THENP Cm, 	IF(SCVETH_ADDRBUF.W_SRC(0) .EQ.'DD00'X)THEN CR? CP.  .  .  IF source address looks like old Ungermann-Bass THENo Cn* 	  IF(SCVETH_ADDRBUF.SRC(2) .EQ.'00'X)THEN CR5 CP.  .  .  .  try to insert source into address table. CE 	    IF(ILV_SI.GE.0.AND.H      +	       NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-4.AND.<      +	       IAND(ICVADR_FLAGS(ILV_SI),ICPADR_UB).EQ.0)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN > 	        NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1? 	        CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=','T 	      ENDIF% 	      IF(NCVETH_PROT.EQ.'0570'X)THENRC 	        CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:)='BRG'(> 	        NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),-      +					      NCVADR_MISCNAMLEN(ILV_SI)+3)T 	      ENDIF> 	      ICVADR_SERNUM(ILV_SI)=JZEXT(SCVETH_ADDRBUF.SRC(3))*256+*      +			     JZEXT(SCVETH_ADDRBUF.SRC(4))! 	      CALL SYS$FAO('#!UL!AD',LN,!>      +		 CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:),.      +			 %VAL(ICVADR_SERNUM(ILV_SI)),%VAL(1),7      +			 %REF(ICHAR('A')+ZEXT(SCVETH_ADDRBUF.SRC(5))))T= 	      NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+LN	? 	      ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_UB)i
 	    ENDIF C2C CP.  .  .  ELSEIF source address looks like new Ungermann-Bass THENC CN. 	  ELSEIF(SCVETH_ADDRBUF.SRC(2) .EQ.'01'X)THEN Cv5 CP.  .  .  .  try to insert source into address table  C	 	    IF(ILV_SI.GE.0.AND.H      +	       NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-4.AND.<      +	       IAND(ICVADR_FLAGS(ILV_SI),ICPADR_UB).EQ.0)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN > 	        NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1? 	        CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=','  	      ENDIF% 	      IF(NCVETH_PROT.EQ.'0570'X)THENEC 	        CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:)='BRG' > 	        NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),-      +					      NCVADR_MISCNAMLEN(ILV_SI)+3)  	      ENDIF@ 	      ICVADR_SERNUM(ILV_SI)=JZEXT(SCVETH_ADDRBUF.SRC(3))*65536+/      +			     JZEXT(SCVETH_ADDRBUF.SRC(4))*256+ *      +			     JZEXT(SCVETH_ADDRBUF.SRC(5)) 	      CALL SYS$FAO('#!UL',LN,>      +		 CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:),&      +			 %VAL(ICVADR_SERNUM(ILV_SI)))= 	      NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+LN ? 	      ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_UB)E
 	    ENDIF CMJ CP.  .  .  ELSEIF source address looks like token-ring Ungermann-Bass THEN C . 	  ELSEIF(SCVETH_ADDRBUF.SRC(2) .EQ.'0F'X)THEN C 5 CP.  .  .  .  try to insert source into address tableE C  	    IF(ILV_SI.GE.0.AND.H      +	       NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-4.AND.<      +	       IAND(ICVADR_FLAGS(ILV_SI),ICPADR_UB).EQ.0)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THENA> 	        NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1? 	        CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=','I 	      ENDIF% 	      IF(NCVETH_PROT.EQ.'0570'X)THENGC 	        CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:)='BRG'D> 	        NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),-      +					      NCVADR_MISCNAMLEN(ILV_SI)+3)( 	      ENDIF@ 	      ICVADR_SERNUM(ILV_SI)=JZEXT(SCVETH_ADDRBUF.SRC(3))*65536+/      +			     JZEXT(SCVETH_ADDRBUF.SRC(4))*256+2*      +			     JZEXT(SCVETH_ADDRBUF.SRC(5))  	      CALL SYS$FAO('tr-!UL',LN,>      +		 CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:),&      +			 %VAL(ICVADR_SERNUM(ILV_SI)))= 	      NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+LN ? 	      ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_UB) 
 	    ENDIF C_ CP.  .  .  ENDIF C  	  ENDIF CT& CP.  .  .  IF U-B bridge protocol THEN C # 	  IF(NCVETH_PROT .EQ. '0570'X)THEND C(- CP.  .  .  .  add this bridge to bridge tableS C  	    IF(ILV_SI.GE.0)THEN
 	      I=1/ 	      DO WHILE (I .LE. ICVBRG_NUMBRIDGES .AND.T'      +			ICVBRG_ADDRPTR(I) .NE. ILV_SI)  		I=I+1U 	      ENDDO% 	      IF(I.GT.ICVBRG_NUMBRIDGES)THEN   		IF(I.LE.ICPBRG_MAXBRIDGES)THEN 		  ICVBRG_NUMBRIDGES=I  		  ICVBRG_ADDRPTR(I)=ILV_SI2 		  ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),       +					   ICPADR_UNKLINADDR) 		  LCVBRG_MAPOK=.FALSE. 		ENDIF  	      ENDIF
 	    ENDIF C & CP.  .  .  ELSE {must be XNS protocol} C  	  ELSE  C 9 CP.  .  .  .  IF source port was 8900 (Bridge Logging) orP; CP			8800 (net mgmt) RPC-calling pgm 2 or 9 (bridge map) orR- CP			8800 (net mgmt) RPC-answering pgm 5 THENT C1) 	    IF(SLV_XNS.SSOCKET .EQ. '0089'X .OR. 1      +	       (SLV_XNS.SSOCKET .EQ. '0088'X .AND.R.      +		SLV_XNS.TYPE .EQ. BLP_XNSTYP_PEP .AND.7      +		SLV_XNS.CLIENT .EQ. NLP_PEPCLIENT_COURIER .AND._8      +		((SLV_XNS.COURIER_TYPE .EQ. 0 .AND.	  ! RPC call6      +		  (SLV_XNS.COURIER_PGMID .EQ. '02000000'X .OR.8      +		   SLV_XNS.COURIER_PGMID .EQ. '09000000'X)) .OR.=      +		 (SLV_XNS.COURIER_TYPE .EQ. '0200'X .AND. ! RPC replyT8      +		  SLV_XNS.COURIER_PGMID .EQ. '05000000'X))))THEN C 0 CP.  .  .  .  .  add this bridge to bridge table CS 	      IF(ILV_SI.GE.0)THEN 		I=1D* 		DO WHILE (I .LE. ICVBRG_NUMBRIDGES .AND.)      +			  ICVBRG_ADDRPTR(I) .NE. ILV_SI)A	 		  I=I+1  		ENDDOO  		IF(I.GT.ICVBRG_NUMBRIDGES)THEN" 		  IF(I.LE.ICPBRG_MAXBRIDGES)THEN 		    ICVBRG_NUMBRIDGES=I	 		    ICVBRG_ADDRPTR(I)=ILV_SI4 		    ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),"      +					     ICPADR_UNKLINADDR) 		    LCVBRG_MAPOK=.FALSE.	 		  ENDIF/ 		ENDIF  	      ENDIF CF CP.  .  .  .  ENDIF  C	
 	    ENDIF CXE CP.  .  .  .  IF destination is here (the monitoring port) or specialI" CP				bridge mapping multicast and CP			mapping in progress THEN= C8 	    IF(LCVBRG_MAPCMD .AND. :      +	       ((SCVETH_ADDRBUF.LDEST .EQ. ICVETH_PHA .AND.:      +		 SCVETH_ADDRBUF.W_DEST(2) .EQ. NCVETH_PHA(2)) .OR.4      +		(SCVETH_ADDRBUF.LDEST .EQ. '0001DD01'X .AND.5      +		 SCVETH_ADDRBUF.W_DEST(2) .EQ. '0100'X)))THEND CE: CP.  .  .  .  .  test if source was recognized as a bridge CG 	      IF(ILV_SI.GE.0)THEN 		I=1O* 		DO WHILE (I .LE. ICVBRG_NUMBRIDGES .AND.)      +			  ICVBRG_ADDRPTR(I) .NE. ILV_SI)P	 		  I=I+1U 		ENDDO1 	      ELSET 		I=ICPBRG_MAXBRIDGES+1r 	      ENDIF C , CP.  .  .  .  .  IF source was a bridge THEN CR' 	      IF(I .LE. ICVBRG_NUMBRIDGES)THEN  CT@ CP.  .  .  .  .  .  attempt to insert message into message queue CA/ 		IF(ICVBRG_QCOUNT .LT. ICPBRG_QUEUESIZE-1)THENR@ 		  ICVBRG_QPRODUCER=IAND(ICVBRG_QPRODUCER+1,ICPBRG_QUEUESIZE-1)2 		  NCVBRG_MSGLEN(ICVBRG_QPRODUCER)=NCVETH_IOSB(1)6 		  CCVBRG_MSGBUF(ICVBRG_QPRODUCER)(1:NCVETH_IOSB(1))=(      +			CCVETH_RCVBUF(1:NCVETH_IOSB(1))0 		  NCVBRG_MSGPROT(ICVBRG_QPRODUCER)=NCVETH_PROT! 		  ICVBRG_QCOUNT=ICVBRG_QCOUNT+1 % 		  CALL SYS$SETEF(%VAL(ICPBRG_QEFN))  		ELSE 		   		ENDIFR CC CP.  .  .  .  .  ENDIF C_ 	      ENDIF C  CP.  .  .  .  ENDIFG CC
 	    ENDIF CD CP.  .  .  ENDIF CF 	  ENDIF CD
 CP.  .  ENDIFT CN 	ENDIF CNC CP.  .  IF XNS and destination index legal and not a multicast THEN  Ce" 	IF(NCVETH_PROT .EQ. '0006'X .AND.      +	   ILV_DI .GE. 0 .AND. ,      +	   NOT(SCVETH_ADDRBUF.W_DEST(0)))THEN Ce0 CP.  .  .  copy XNS prefix into header structure CL0 	  SLV_XNS.BUF=CCVETH_RCVBUF(1:LEN(SLV_XNS.BUF)) C	N CP.  .  .  IF datalink destination matches XNS header destination address THEN CP: 	  IF(SLV_XNS.DNODE(0) .EQ. SCVETH_ADDRBUF.W_DEST(0) .AND.@      +	     SLV_XNS.DNODE(1) .EQ. SCVETH_ADDRBUF.W_DEST(1) .AND.?      +	     SLV_XNS.DNODE(2) .EQ. SCVETH_ADDRBUF.W_DEST(2))THEN  C+! CP.  .  .  .  save network number  Ce* 	    ICVADR_XNSNETNUM(ILV_DI)=SLV_XNS.DNET C) CP.  .  .  ENDIF C$ 	  ENDIF C 
 CP.  .  ENDIF  CE 	ENDIF COF CP.  .  IF destination Ethernet address looks like Ungermann-Bass THEN CL- 	IF(SCVETH_ADDRBUF.W_DEST(0) .EQ.'DD00'X)THENF C/D CP.  .  .  IF destination address looks like old Ungermann-Bass THEN Cs+ 	  IF(SCVETH_ADDRBUF.DEST(2) .EQ.'00'X)THEN  C : CP.  .  .  .  try to insert destination into address table C+ 	    IF(ILV_DI.GE.0.AND.H      +	       NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-4.AND.<      +	       IAND(ICVADR_FLAGS(ILV_DI),ICPADR_UB).EQ.0)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THENC> 	        NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+1? 	        CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=','T 	      ENDIF% 	      IF(NCVETH_PROT.EQ.'0570'X)THENNC 	        CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:)='BRG'M> 	        NCVADR_MISCNAMLEN(ILV_DI)=MIN(LEN(CCVADR_MISCNAM(0)),-      +					      NCVADR_MISCNAMLEN(ILV_DI)+3)I 	      ENDIF? 	      ICVADR_SERNUM(ILV_DI)=JZEXT(SCVETH_ADDRBUF.DEST(3))*256+L+      +			     JZEXT(SCVETH_ADDRBUF.DEST(4))R! 	      CALL SYS$FAO('#!UL!AD',LN,I>      +		 CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:),.      +			 %VAL(ICVADR_SERNUM(ILV_DI)),%VAL(1),8      +			 %REF(ICHAR('A')+ZEXT(SCVETH_ADDRBUF.DEST(5))))= 	      NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+LNS? 	      ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_UB)I
 	    ENDIF C_H CP.  .  .  ELSEIF destination address looks like new Ungermann-Bass THEN C / 	  ELSEIF(SCVETH_ADDRBUF.DEST(2) .EQ.'01'X)THENA CB: CP.  .  .  .  try to insert destination into address table CE 	    IF(ILV_DI.GE.0.AND.H      +	       NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-4.AND.<      +	       IAND(ICVADR_FLAGS(ILV_DI),ICPADR_UB).EQ.0)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THENI> 	        NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+1? 	        CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=','  	      ENDIF% 	      IF(NCVETH_PROT.EQ.'0570'X)THEN C 	        CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:)='BRG'.> 	        NCVADR_MISCNAMLEN(ILV_DI)=MIN(LEN(CCVADR_MISCNAM(0)),-      +					      NCVADR_MISCNAMLEN(ILV_DI)+3)+ 	      ENDIFA 	      ICVADR_SERNUM(ILV_DI)=JZEXT(SCVETH_ADDRBUF.DEST(3))*65536+T0      +			     JZEXT(SCVETH_ADDRBUF.DEST(4))*256++      +			     JZEXT(SCVETH_ADDRBUF.DEST(5))R 	      CALL SYS$FAO('#!UL',LN,>      +		 CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:),&      +			 %VAL(ICVADR_SERNUM(ILV_DI)))= 	      NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+LND? 	      ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_UB)E
 	    ENDIF C%O CP.  .  .  ELSEIF destination address looks like token-ring Ungermann-Bass THENR C)/ 	  ELSEIF(SCVETH_ADDRBUF.DEST(2) .EQ.'0F'X)THENE CA: CP.  .  .  .  try to insert destination into address table CE 	    IF(ILV_DI.GE.0.AND.H      +	       NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-4.AND.<      +	       IAND(ICVADR_FLAGS(ILV_DI),ICPADR_UB).EQ.0)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THENH> 	        NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+1? 	        CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=','N 	      ENDIF% 	      IF(NCVETH_PROT.EQ.'0570'X)THENEC 	        CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:)='BRG'A> 	        NCVADR_MISCNAMLEN(ILV_DI)=MIN(LEN(CCVADR_MISCNAM(0)),-      +					      NCVADR_MISCNAMLEN(ILV_DI)+3)A 	      ENDIFA 	      ICVADR_SERNUM(ILV_DI)=JZEXT(SCVETH_ADDRBUF.DEST(3))*65536+)0      +			     JZEXT(SCVETH_ADDRBUF.DEST(4))*256++      +			     JZEXT(SCVETH_ADDRBUF.DEST(5)))  	      CALL SYS$FAO('tr-!UL',LN,>      +		 CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:),&      +			 %VAL(ICVADR_SERNUM(ILV_DI)))= 	      NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+LNS? 	      ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_UB))
 	    ENDIF C+ CP.  .  .  ENDIF C) 	  ENDIF C+
 CP.  .  ENDIFM CD 	ENDIF CI2 CP.  ELSEIF protocol type is Loopback (90-00) THEN CD)       ELSEIF(NCVETH_PROT .EQ.'0090'X)THEN( CA@ CP.  .  IF this is from PING target and PINGing in progress THEN CR 	IF(ICVPNG_REPCNT .GT. 0 .AND.>      +	   SCVETH_ADDRBUF.W_SRC(0) .EQ. NCVPNG_ADDRBUF(0) .AND.>      +	   SCVETH_ADDRBUF.W_SRC(1) .EQ. NCVPNG_ADDRBUF(1) .AND.=      +	   SCVETH_ADDRBUF.W_SRC(2) .EQ. NCVPNG_ADDRBUF(2))THENF C  CP.  .  .  update PING count CP  	  ICVPNG_REPCNT=ICVPNG_REPCNT-1 CR' CP.  .  .  IF ping count completed THENC CR 	  IF(ICVPNG_REPCNT .LE. 0)THENR C ' CP.  .  .  .  wake up the mainline code_ CP 	    CALL SYS$WAKE(,)A CP CP.  .  .  ELSE) CD 	  ELSEi Cs# CP.  .  .  .  queue next PING write( CL8 	    ILV_STATUS=SYS$QIO(%VAL(3),		! specify scratch EF#,8      +			   %VAL(NCVETH_CHAN),	! specify device channel,4      +			   %VAL(IO$_WRITEVBLK),	! specify function,,      +			   ,,,			! specify no I/OSB or AST,/      +			   NCVPNG_SNDBUF,	! specify send data,C:      +			   %VAL(ICVPNG_SNDBUFLEN),	! specify data length,      +			   ,,			! skip P3, P4,I4      +			   NCVPNG_ADDRBUF,)	! specify send address. 	    IF(.NOT.ILV_STATUS)THEN( 	      CALL LIB$SIGNAL(%VAL(ILV_STATUS))
 	    ENDIF CP CP.  .  .  ENDIF CF 	  ENDIF CC
 CP.  .  ENDIFE C3 	ENDIF C > CP.  ELSEIF protocol type is DEC MOP Remote Console (60-02) or. CP			DEC MOP Dump/Load Assistance (60-01) THEN CS*       ELSEIF(NCVETH_PROT .EQ. '0260'X .OR.)      +	     NCVETH_PROT .EQ. '0160'X)THENL CV@ CP.  .  IF this is from PING target and PINGing in progress THEN CT 	IF(ICVPNG_REPCNT .GT. 0 .AND.(      +	   NCVETH_PROT .EQ. '0260'X .AND.>      +	   SCVETH_ADDRBUF.W_SRC(0) .EQ. NCVPNG_ADDRBUF(0) .AND.>      +	   SCVETH_ADDRBUF.W_SRC(1) .EQ. NCVPNG_ADDRBUF(1) .AND.=      +	   SCVETH_ADDRBUF.W_SRC(2) .EQ. NCVPNG_ADDRBUF(2))THEN) CV CP.  .  .  update PING count C   	  ICVPNG_REPCNT=ICVPNG_REPCNT-1 CE' CP.  .  .  IF ping count completed THENV C_ 	  IF(ICVPNG_REPCNT .LE. 0)THENC CR' CP.  .  .  .  wake up the mainline code_ CU 	    CALL SYS$WAKE(,)S C' CP.  .  .  ELSE  CL 	  ELSEN CU# CP.  .  .  .  queue next PING writeN CI8 	    ILV_STATUS=SYS$QIO(%VAL(3),		! specify scratch EF#,8      +			   %VAL(NCVETH_CHAN),	! specify device channel,4      +			   %VAL(IO$_WRITEVBLK),	! specify function,,      +			   ,,,			! specify no I/OSB or AST,/      +			   NCVPNG_SNDBUF,	! specify send data, 9      +			   %VAL(ICVPNG_SNDBUFLEN),! specify data length,U      +			   ,,			! skip P3, P4,E4      +			   NCVPNG_ADDRBUF,)	! specify send address. 	    IF(.NOT.ILV_STATUS)THEN( 	      CALL LIB$SIGNAL(%VAL(ILV_STATUS))
 	    ENDIF C  CP.  .  .  ENDIF C) 	  ENDIF C_
 CP.  .  ENDIFR CV 	ENDIF C 4 CP.  .  IF message is System ID periodic status THEN C  	IF((LCVETH_IEEE .AND.,      +	    BCVETH_RCVBUF(1) .EQ. '07'X .AND.+      +	    BCVETH_RCVBUF(2) .EQ. '00'X).OR.V"      +	   (.NOT. LCVETH_IEEE .AND.,      +	    BCVETH_RCVBUF(3) .EQ. '07'X .AND.,      +	    BCVETH_RCVBUF(4) .EQ. '00'X))THEN C	? CP.  .  .  IF sender has not yet had identification stored THENM CV8 	  IF(IAND(ICVADR_FLAGS(ILV_SI),ICPADR_MOP) .EQ. 0 .AND.      +	     ILV_SI .GE. 0)THEN CS CP.  .  .  .  clear data fieldsI CI 	    BLV_MOP_FUNC=0  	    BLV_MOP_DEVTYP=0= 	    BLV_MOP_SYSTYP=0N
 	    DO I=0,5N 	      BLV_MOP_HWA(I)=0=
 	    ENDDO
 	    DO I=0,5N 	      BLV_MOP_CUA(I)=0_
 	    ENDDO D	    BLV_MOP_VER=0D C'D CP.  .  .  .  compute base and length of message, based on IEEE flag C  	    IF(LCVETH_IEEE)THEN 	      I=5		! starting byteE  	      J=NCVETH_IOSB(1)	! length	 	    ELSE.
 	      I=7> 	      J=JZEXT(BCVETH_RCVBUF(1))+JZEXT(BCVETH_RCVBUF(2))*256+2
 	    ENDIF C  CP.  .  .  .  REPEAT CL 	    DO WHILE (I.LT.J) CO; CP.  .  .  .  .  IF entry type is function mask (0002) THENS C ( 	      IF(BCVETH_RCVBUF(I).EQ.'02'X.AND.)      +		 BCVETH_RCVBUF(I+1).EQ.'00'X)THENC CH  CP.  .  .  .  .  .  extract mask CN! 		BLV_MOP_FUNC=BCVETH_RCVBUF(I+3)+ C = CP.  .  .  .  .  ELSEIF entry type is MOP version (0001) THENe C -  	      ELSEIF(BCVETH_RCVBUF(I).EQ.'01'X.AND. -      +		     BCVETH_RCVBUF(I+1).EQ.'00'X)THEN  C * CP.  .  .  .  .  .  extract version number CF!  		BLV_MOP_VER=BCVETH_RCVBUF(I+3)  C F CP.  .  .  .  .  ELSEIF entry type is console user address (0003) THEN C , 	      ELSEIF(BCVETH_RCVBUF(I).EQ.'03'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'00'X)THENC CH0 CP.  .  .  .  .  .  extract console user address C)! 		IF(BCVETH_RCVBUF(I+2).GE.6)THEN & 		  CLV_MOP_CUA=CCVETH_RCVBUF(I+3:I+8) 		ENDIFI CDN CP.  .  .  .  .  ELSEIF entry type is some other console info (0004-0006) THEN CN, 	      ELSEIF(BCVETH_RCVBUF(I).GE.'04'X.AND.+      +		     BCVETH_RCVBUF(I).LE.'06'X.AND.m-      +		     BCVETH_RCVBUF(I+1).EQ.'00'X)THEN  C  CP.  .  .  .  .  .  do nothing Cl
 		CONTINUE CnF CP.  .  .  .  .  ELSEIF entry type is raw hardware address (0007) THEN C , 	      ELSEIF(BCVETH_RCVBUF(I).EQ.'07'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'00'X)THENA CM0 CP.  .  .  .  .  .  extract raw hardware address C ! 		IF(BCVETH_RCVBUF(I+2).GE.6)THENI& 		  CLV_MOP_HWA=CCVETH_RCVBUF(I+3:I+8) 		ENDIFE CL= CP.  .  .  .  .  ELSEIF entry type is device type (0064) THENC CL, 	      ELSEIF(BCVETH_RCVBUF(I).EQ.'64'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'00'X)THEN  C % CP.  .  .  .  .  .  extract type code  C # 		BLV_MOP_DEVTYP=BCVETH_RCVBUF(I+3)M C(M CP.  .  .  .  .  ELSEIF entry type is some other device info (0065-00C7) THEN) C 3 	      ELSEIF(JZEXT(BCVETH_RCVBUF(I)).GE.'65'X.AND. 2      +		     JZEXT(BCVETH_RCVBUF(I)).LE.'C7'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'00'X)THENA CB CP.  .  .  .  .  .  do nothing CU
 		CONTINUE C = CP.  .  .  .  .  ELSEIF entry type is software ID (00C8) THEN  C	, 	      ELSEIF(BCVETH_RCVBUF(I).EQ.'C8'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'00'X)THEN) C  CP.  .  .  .  .  .  G CP.  .  .  .  .  ELSEIF entry type is system processor type (012C) THEN( CA, 	      ELSEIF(BCVETH_RCVBUF(I).EQ.'2C'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'01'X)THEN  Ce% CP.  .  .  .  .  .  extract type codeA CB# 		BLV_MOP_SYSTYP=BCVETH_RCVBUF(I+3)  C.M CP.  .  .  .  .  ELSEIF entry type is some other system info (012D-018F) THEN+ C 4  	      ELSEIF(JZEXT(BCVETH_RCVBUF(I)).GE.'2D'X.AND.2      +		     JZEXT(BCVETH_RCVBUF(I)).LE.'8F'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'01'X)THEN( C_ CP.  .  .  .  .  .  do nothing CC
 		CONTINUE CN? CP.  .  .  .  .  ELSEIF entry type is datalink type (0190) THENR CS, 	      ELSEIF(BCVETH_RCVBUF(I).EQ.'90'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'01'X)THEN_ CC CP.  .  .  .  .  .  F CP.  .  .  .  .  ELSEIF entry type is datalink buffer size (0191) THEN CD, 	      ELSEIF(BCVETH_RCVBUF(I).EQ.'91'X.AND.-      +		     BCVETH_RCVBUF(I+1).EQ.'01'X)THENE CM CP.  .  .  .  .  .  0 CP.  .  .  .  .  ELSEIF debugging turned on THEN CD) 	      ELSEIF(LCVETH_MESSAGES .EQ. 3)THENE CA? CP.  .  .  .  .  .  signal report of non-standard MOP parameterI CA*  		CALL LIB$SIGNAL(ETH__NONSTDMOP,%VAL(8),A      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),SA      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),CA      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),oE      +		 %VAL(JZEXT(BCVETH_RCVBUF(I))+JZEXT(BCVETH_RCVBUF(I+1))*256),C"      +		 %VAL(BCVETH_RCVBUF(I+2))) C  CP.  .  .  .  .  ENDIF C  	      ENDIF Cs& CP.  .  .  .  .  advance to next field C & 	      I=I+JZEXT(BCVETH_RCVBUF(I+2))+3 CC" CP.  .  .  .  UNTIL end of message C 
 	    ENDDO CG8 CP.  .  .  .  format data into miscellaneous name string CLB 	    IF(NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THENC 		NCVADR_MISCNAMLEN(ILV_SI)=%      +				NCVADR_MISCNAMLEN(ILV_SI)+1Q8 		CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=',' 	      ENDIF" 	      IF(BLV_MOP_DEVTYP.NE.0)THEN 		I=1V& 		DO WHILE (I.LE.ILP_MOP_DEVTYPES.AND./      +			  BLV_DEVTYP_MOP(I).NE.BLV_MOP_DEVTYP)E	 		  I=I+1  		ENDDOE 		IF(I.LE.ILP_MOP_DEVTYPES)THEN.+ 		  IF(CLV_MOP_DEVTYPES(I)(6:6).EQ.' ')THEND0 		    CLV_SCR(1:6)=CLV_MOP_DEVTYPES(I)(1:5)//':'
 		    LN=6 		  ELSE+ 		    CLV_SCR(1:7)=CLV_MOP_DEVTYPES(I)//':'C
 		    LN=7	 		  ENDIFN 		ELSE 		  CLV_SCR(1:5)='t=xx:'2 		  CALL OTS$CVT_L_TZ(BLV_MOP_DEVTYP,CLV_SCR(3:4),      +					%VAL(2),%VAL(1))S 		  LN=5 		ENDIFD 	      ENDIF  	      IF(BLV_MOP_FUNC.NE.0)THEN 		CLV_SCR(LN+1:LN+2)='f='.4 		CALL OTS$CVT_L_TZ(BLV_MOP_FUNC,CLV_SCR(LN+3:LN+4),      +					%VAL(2),%VAL(1))E	 		LN=LN+4. 	      ENDIF" 	      IF(BLV_MOP_SYSTYP.NE.0)THEN 		IF(BLV_MOP_FUNC.NE.0)THEN( 		  LN=LN+1H 		  CLV_SCR(LN:LN)=';' 		ENDIFI 		CLV_SCR(LN+1:LN+2)='s='D6 		CALL OTS$CVT_L_TZ(BLV_MOP_SYSTYP,CLV_SCR(LN+3:LN+4),      +					%VAL(2),%VAL(1))I	 		LN=LN+4I 	      ENDIF3 	      IF(CLV_MOP_HWA .NE. SCVETH_ADDRBUF.CSRC.AND.=B      +		 .NOT.(BLV_MOP_HWA(0).EQ.0 .AND. BLV_MOP_HWA(1).EQ.0 .AND.(      +		       BLV_MOP_HWA(2).EQ.0))THEN2 		IF(BLV_MOP_FUNC.NE.0.OR.BLV_MOP_SYSTYP.NE.0)THEN 		  LN=LN+1E 		  CLV_SCR(LN:LN)=';' 		ENDIFe2 		CALL OTS$CVT_L_TZ(BLV_MOP_HWA(0),CLV_TIME(5:12),      +				  %VAL(8))1 		CALL OTS$CVT_L_TZ(BLV_MOP_HWA(4),CLV_TIME(1:4),g      +				  %VAL(4),%VAL(2))= 		CLV_SCR(LN+1:LN+14)='hw'//CLV_TIME(11:12)//CLV_TIME(9:10)//_6      +			CLV_TIME(7:8)//CLV_TIME(5:6)//CLV_TIME(3:4)//      +			CLV_TIME(1:2)
 		LN=LN+14( 		J=IAND(NLV_MOP_HWA(2),ICPADR_MAXADDRS) 		I=0L% 		DO WHILE ((SCVADR_ADDR(J).LNUM .NE.       +				ILV_MOP_HWA .OR.&      +			   SCVADR_ADDR(J).NUM(2) .NE.      +				NLV_MOP_HWA(2)) .AND.Q       +			  ICVADR_FLAGS(J) .AND."      +			  I.LT.ICPADR_MAXADDRS/2) 		  J=IAND(J+1,ICPADR_MAXADDRS)_	 		  I=I+10 		ENDDOD. 		IF(SCVADR_ADDR(J).LNUM .NE. ILV_MOP_HWA .OR.9      +		   SCVADR_ADDR(J).NUM(2) .NE. NLV_MOP_HWA(2))THENd 		  IF(ICVADR_FLAGS(J))THEN 
 		    J=-1 		  ELSE' 		    ICVADR_NUMADDRS=ICVADR_NUMADDRS+1G% 		    SCVADR_ADDR(J).LNUM=ILV_MOP_HWA.* 		    SCVADR_ADDR(J).NUM(2)=NLV_MOP_HWA(2)! 		    ICVADR_FLAGS(J)=ICPADR_USEDL	 		  ENDIFX 		ENDIFH 		IF(J.GE.0)THEN< 		  IF(NCVADR_MISCNAMLEN(J).LT.LEN(CCVADR_MISCNAM(0))-1)THEN' 		    IF(NCVADR_MISCNAMLEN(J).NE.0)THEN 3 		      NCVADR_MISCNAMLEN(J)=NCVADR_MISCNAMLEN(J)+1A4 		      CCVADR_MISCNAM(J)(NCVADR_MISCNAMLEN(J):)=',' 		    ENDIF 1 		    CALL OTS$CVT_L_TZ(SCVADR_ADDR(ILV_SI).LNUM, '      +				      CLV_TIME(5:12),%VAL(8))P3 		    CALL OTS$CVT_L_TZ(SCVADR_ADDR(ILV_SI).NUM(2),g.      +				      CLV_TIME(1:4),%VAL(4),%VAL(2))1 		    CCVADR_MISCNAM(J)(NCVADR_MISCNAMLEN(J)+1:)=.1      +			'log'//CLV_TIME(11:12)//CLV_TIME(9:10)//_6      +			CLV_TIME(7:8)//CLV_TIME(5:6)//CLV_TIME(3:4)//      +			CLV_TIME(1:2)6 		    NCVADR_MISCNAMLEN(J)=MIN(LEN(CCVADR_MISCNAM(0)),#      +					NCVADR_MISCNAMLEN(J)+15)d	 		  ENDIFe 		ENDIF  	      ENDIF< 	      CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:)=      +					CLV_SCR(1:LN)< 	      NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),(      +					NCVADR_MISCNAMLEN(ILV_SI)+LN)
 	    ENDIFB 	    IF(NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.G      +	       .NOT.(BLV_MOP_CUA(0).EQ.0 .AND. BLV_MOP_CUA(1).EQ.0 .AND.e&      +		     BLV_MOP_CUA(2).EQ.0))THEN7 	      CALL OTS$CVT_L_TZ(BLV_MOP_CUA(0),CLV_TIME(5:12),R      +				%VAL(8))6 	      CALL OTS$CVT_L_TZ(BLV_MOP_CUA(4),CLV_TIME(1:4),      +				%VAL(4),%VAL(2))6 	      CLV_SCR(1:12)=CLV_TIME(11:12)//CLV_TIME(9:10)//6      +			CLV_TIME(7:8)//CLV_TIME(5:6)//CLV_TIME(3:4)//      +			CLV_TIME(1:2)< 	      CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:)="      +				',Rcons:'//CLV_SCR(1:12)< 	      NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),(      +					NCVADR_MISCNAMLEN(ILV_SI)+19)
 	    ENDIF C.F CP.  .  .  .  mark that ID message has been processed for this address Ct> 	    ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_MOP) C K CP.  .  .  .  IF device type supplied and it is a DEBET (DEC Bridge 100) or : CP			DB150 (DEC Bridge 150) or DB200 (DEC Bridge 200) THEN CF$ 	    IF(BLV_MOP_DEVTYP.EQ.'15'X .OR.*      +	       BLV_MOP_DEVTYP.EQ.'35'X .OR.*      +	       BLV_MOP_DEVTYP.EQ.'4C'X)THEN C(1 CP.  .  .  .  .  add this address to bridge table. C 
 	      I=1/ 	      DO WHILE (I .LE. ICVBRG_NUMBRIDGES .AND..'      +			ICVBRG_ADDRPTR(I) .NE. ILV_SI)H 		I=I+1W 	      ENDDO% 	      IF(I.GT.ICVBRG_NUMBRIDGES)THEN   		IF(I.LE.ICPBRG_MAXBRIDGES)THEN 		  ICVBRG_NUMBRIDGES=I. 		  ICVBRG_ADDRPTR(I)=ILV_SI2 		  ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),       +					   ICPADR_UNKLINADDR) 		  LCVBRG_MAPOK=.FALSE. 		ENDIFD 	      ENDIF CQ CP.  .  .  .  ENDIFP C.
 	    ENDIF Ct CP.  .  .  ENDIF Ce 	  ENDIF Cn1 CP.  .  ELSEIF MOP message reporting enabled THEN0 CT 	ELSEIF(LCVETH_MSGS_ENB(3))THENs C ? CP.  .  .  report some other type of MOP message being received  C  	  IF(LCVETH_IEEE)THEN# 	    IF(NCVETH_PROT.EQ.'0160'X)THENN. 	      CALL LIB$SIGNAL(ETH__IMOPMSG,%VAL(10),,A      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)), A      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)), A      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),E      +		 'DLA',CC      +		 %VAL(JZEXT(BCVETH_RCVBUF(1))+JZEXT(BCVETH_RCVBUF(2))*256),S      +		 %VAL(NCVETH_IOSB(1)))' 	    ELSEIF(NCVETH_PROT.EQ.'0260'X)THENV. 	      CALL LIB$SIGNAL(ETH__IMOPMSG,%VAL(10),,A      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),SA      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),SA      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),(      +		 'RC',C      +		 %VAL(JZEXT(BCVETH_RCVBUF(1))+JZEXT(BCVETH_RCVBUF(2))*256),,      +		 %VAL(NCVETH_IOSB(1)))
 	    ENDIF 	  ELSE5# 	    IF(NCVETH_PROT.EQ.'0160'X)THEN)- 	      CALL LIB$SIGNAL(ETH__MOPMSG,%VAL(10),,LA      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),PA      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),HA      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),.      +		 'DLA',sC      +		 %VAL(JZEXT(BCVETH_RCVBUF(3))+JZEXT(BCVETH_RCVBUF(4))*256), C      +		 %VAL(JZEXT(BCVETH_RCVBUF(1))+JZEXT(BCVETH_RCVBUF(2))*256)) ' 	    ELSEIF(NCVETH_PROT.EQ.'0260'X)THENC- 	      CALL LIB$SIGNAL(ETH__MOPMSG,%VAL(10),,(A      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),AA      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),LA      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),       +		 'RC',C      +		 %VAL(JZEXT(BCVETH_RCVBUF(3))+JZEXT(BCVETH_RCVBUF(4))*256),_C      +		 %VAL(JZEXT(BCVETH_RCVBUF(1))+JZEXT(BCVETH_RCVBUF(2))*256))D
 	    ENDIF 	  ENDIF C 
 CP.  .  ENDIF  C  	ENDIF CN6 CP.  ELSEIF protocol type is DoD Internet (08-00) THEN C )       ELSEIF(NCVETH_PROT .EQ.'0008'X)THEN  C	& CP.  .  IF message is long enough THEN C  	IF(NCVETH_IOSB(1).GE.20)THEN+ CC& CP.  .  .  copy IP message into buffer C_! 	  SLV_IP.BUF=CCVETH_RCVBUF(1:20)N CI; CP.  .  .  IF message header is a recognized IP header THENI CD$ 	  IF(SLV_IP.VERS_IHL .GE.'45'X.AND.*      +	     SLV_IP.VERS_IHL .LE.'4F'X)THEN C E CP.  .  .  .  IF this is from PING target and PINGing in progress andn CP			an ICMP packet THEN CC" 	    IF(ICVPNG_REPCNT .GT. 0 .AND.B      +	       SCVETH_ADDRBUF.W_SRC(0) .EQ. NCVPNG_ADDRBUF(0) .AND.B      +	       SCVETH_ADDRBUF.W_SRC(1) .EQ. NCVPNG_ADDRBUF(1) .AND.B      +	       SCVETH_ADDRBUF.W_SRC(2) .EQ. NCVPNG_ADDRBUF(2) .AND.)      +	       SLV_IP.PROTOCOL .EQ. 1)THENR CS" CP.  .  .  .  .  update PING count CV$ 	      ICVPNG_REPCNT=ICVPNG_REPCNT-1 CI- CP.  .  .  .  .  IF ping count completed THENR CS# 	      IF(ICVPNG_REPCNT .LE. 0)THEN  C - CP.  .  .  .  .  .  wake up the mainline codeV C_ 		CALL SYS$WAKE(,) CM CP.  .  .  .  .  ELSEB CA 	      ELSEV C_) CP.  .  .  .  .  .  queue next PING write) C 4 		ILV_STATUS=SYS$QIO(%VAL(3),	! specify scratch EF#,8      +			   %VAL(NCVETH_CHAN),	! specify device channel,4      +			   %VAL(IO$_WRITEVBLK),	! specify function,,      +			   ,,,			! specify no I/OSB or AST,/      +			   NCVPNG_SNDBUF,	! specify send data, :      +			   %VAL(ICVPNG_SNDBUFLEN),	! specify data length,      +			   ,,			! skip P3, P4,V4      +			   NCVPNG_ADDRBUF,)	! specify send address. 		IF(.NOT.ILV_STATUS)THENV% 		  CALL LIB$SIGNAL(%VAL(ILV_STATUS))D 		ENDIF_ C) CP.  .  .  .  .  ENDIF C  	      ENDIF CD CP.  .  .  .  ENDIFM CD
 	    ENDIF CP5 CP.  .  .  .  try to insert source into address table  C  	    IF(ILV_SI.GE.0)THENI 	      IF(.NOT.VALIDATE_IPADDR(SLV_IP.LSRC))THEN ! legal class A/B/C only 3 		CONTINUE	! ignore class D and E network addressesC= 	      ELSEIF(IAND(ICVADR_FLAGS(ILV_SI),ICPADR_INET).EQ.0.OR.C5      +		 ICVADR_INETADR(ILV_SI) .EQ. SLV_IP.LSRC)THEN ( 		IF(NCVADR_INETNAMLEN(ILV_SI).EQ.0)THEN= 		  CALL SYS$FAO('!UB.!UB.!UB.!UB',NCVADR_INETNAMLEN(ILV_SI),N#      +			   CCVADR_INETNAM(ILV_SI), 4      +			   %VAL(SLV_IP.SRC(0)),%VAL(SLV_IP.SRC(1)),4      +			   %VAL(SLV_IP.SRC(2)),%VAL(SLV_IP.SRC(3)))& 		  ICVADR_INETADR(ILV_SI)=SLV_IP.LSRC 		ENDIF  		IF(LCVETH_MSGS_ENB(2))THEN 		  DO I=0,ICPADR_MAXADDRS 		    IF(ICVADR_FLAGS(I) .AND.;      +		       IAND(ICVADR_FLAGS(I),ICPADR_INET).NE.0 .AND._      +		       I.NE.ILV_SI)THEN ; 		      IF(ICVADR_INETADR(I).EQ.ICVADR_INETADR(ILV_SI))THEN	* 			CALL LIB$SIGNAL(ETH__DUPIPADR,%VAL(16),A      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),_A      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),IA      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),T(      +		 %VAL(BCVADR_INETADR(0,ILV_SI)),(      +		 %VAL(BCVADR_INETADR(1,ILV_SI)),(      +		 %VAL(BCVADR_INETADR(2,ILV_SI)),(      +		 %VAL(BCVADR_INETADR(3,ILV_SI)),C      +		 %VAL(SCVADR_ADDR(I).BNUM(0)),%VAL(SCVADR_ADDR(I).BNUM(1)),aC      +		 %VAL(SCVADR_ADDR(I).BNUM(2)),%VAL(SCVADR_ADDR(I).BNUM(3)), C      +		 %VAL(SCVADR_ADDR(I).BNUM(4)),%VAL(SCVADR_ADDR(I).BNUM(5)))I
 		      ENDIFI 		    ENDIFr	 		  ENDDOT 		ENDIFP( 		IF(SLV_IP.PROTOCOL .EQ. 17 .AND. ! UDPA      +		   IAND(SLV_IP.FRAG_OFF,'1FFF'X).EQ.0)THEN	! 1st fragmentN; 		  IF(BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+1)V      +				.EQ.'02'X.AND.A      +		     BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+2) +      +				.EQ.'08'X)THEN	! source= RIP portT@ 		    IF(IAND(ICVADR_FLAGS(ILV_SI),ICPADR_INETGATEWAY).EQ.0)THEN" 		      IF(LCVETH_MSGS_ENB(4))THEN* 			CALL LIB$SIGNAL(ETH__FNDINETGW,%VAL(6),A      +			%VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),UA      +			%VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),(A      +			%VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)))s
 		      ENDIFh6 		      ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),%      +					       ICPADR_INETGATEWAY)O 		    ENDIF ? 		  ELSEIF(BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+1)I      +				.EQ.'00'X.AND.E      +		         BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+2)D+      +				.EQ.'35'X)THEN	! source= DNS portI4 		    ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),!      +					     ICPADR_DNSSERVER)F	 		  ENDIFD 		ENDIFP< 		ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_INET)> 	      ELSEIF(IAND(ICVADR_FLAGS(ILV_SI),ICPADR_IARP).EQ.0)THEN( 		IF(SLV_IP.PROTOCOL .EQ. 17 .AND. ! UDPA      +		   IAND(SLV_IP.FRAG_OFF,'1FFF'X).EQ.0.AND.	! 1st fragmentN?      +		   BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+1)T      +				.EQ.'02'X.AND.?      +		   BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+2)d+      +				.EQ.'08'X)THEN	! source= RIP portC= 		  CALL SYS$FAO('!UB.!UB.!UB.!UB',NCVADR_INETNAMLEN(ILV_SI), #      +			   CCVADR_INETNAM(ILV_SI), 4      +			   %VAL(SLV_IP.SRC(0)),%VAL(SLV_IP.SRC(1)),4      +			   %VAL(SLV_IP.SRC(2)),%VAL(SLV_IP.SRC(3)))& 		  ICVADR_INETADR(ILV_SI)=SLV_IP.LSRC3 		  ICVADR_FLAGS(ILV_SI)=IAND(ICVADR_FLAGS(ILV_SI),P2      +					NOT(ICPADR_INETNAME+ICPADR_INETMLTIPA))> 		  IF(IAND(ICVADR_FLAGS(ILV_SI),ICPADR_INETGATEWAY).EQ.0.AND.$      +		     LCVETH_MSGS_ENB(4))THEN- 		    CALL LIB$SIGNAL(ETH__FNDINETGW,%VAL(6),BA      +			%VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)), A      +			%VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),IA      +			%VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)))V	 		  ENDIF02 		  ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),!      +					   ICPADR_INETGATEWAY)a# 		ELSEIF(IAND(ICVADR_FLAGS(ILV_SI),I<      +			    ICPADR_INETGATEWAY+ICPADR_INETMLTIPA).EQ.0)THEN 		  IF(LCVETH_MSGS_ENB(4))THEN. 		    CALL LIB$SIGNAL(ETH__FNDMLTIPA,%VAL(14),A      +			%VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),sA      +			%VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),.A      +			%VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)), (      +			%VAL(BCVADR_INETADR(0,ILV_SI)),(      +			%VAL(BCVADR_INETADR(1,ILV_SI)),(      +			%VAL(BCVADR_INETADR(2,ILV_SI)),(      +			%VAL(BCVADR_INETADR(3,ILV_SI)),1      +			%VAL(SLV_IP.SRC(0)),%VAL(SLV_IP.SRC(1)),+1      +			%VAL(SLV_IP.SRC(2)),%VAL(SLV_IP.SRC(3)))e	 		  ENDIFh2 		  ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),       +					   ICPADR_INETMLTIPA) 		ENDIF  	      ENDIF
 	    ENDIF CD: CP.  .  .  .  try to insert destination into address table C  	    IF(ILV_DI.GE.0)THENI 	      IF(.NOT.VALIDATE_IPADDR(SLV_IP.LDEST).OR. ! legal class A/B/C onlys?      +		 SCVETH_ADDRBUF.LDEST)THEN  ! don't store for multicast 3 		CONTINUE	! ignore class D and E network addresses = 	      ELSEIF(IAND(ICVADR_FLAGS(ILV_DI),ICPADR_INET).EQ.0.OR.C6      +		 ICVADR_INETADR(ILV_DI) .EQ. SLV_IP.LDEST)THEN( 		IF(NCVADR_INETNAMLEN(ILV_DI).EQ.0)THEN= 		  CALL SYS$FAO('!UB.!UB.!UB.!UB',NCVADR_INETNAMLEN(ILV_DI),E#      +			   CCVADR_INETNAM(ILV_DI), 6      +			   %VAL(SLV_IP.DEST(0)),%VAL(SLV_IP.DEST(1)),6      +			   %VAL(SLV_IP.DEST(2)),%VAL(SLV_IP.DEST(3)))' 		  ICVADR_INETADR(ILV_DI)=SLV_IP.LDESTn 		ENDIFi 		IF(LCVETH_MSGS_ENB(2))THEN 		  DO I=0,ICPADR_MAXADDRS 		    IF(ICVADR_FLAGS(I) .AND.;      +		       IAND(ICVADR_FLAGS(I),ICPADR_INET).NE.0 .AND..      +		       I.NE.ILV_DI)THEN.; 		      IF(ICVADR_INETADR(I).EQ.ICVADR_INETADR(ILV_DI))THENT( 			CALL LIB$SIGNAL(ETH__MDUPIP,%VAL(23),A      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),EA      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),PA      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),oE      +		 %DESCR(CCVADR_INETNAM(ILV_SI)(1:NCVADR_INETNAMLEN(ILV_SI))),NC      +		 %VAL(SCVETH_ADDRBUF.DEST(0)),%VAL(SCVETH_ADDRBUF.DEST(1)), C      +		 %VAL(SCVETH_ADDRBUF.DEST(2)),%VAL(SCVETH_ADDRBUF.DEST(3)),.C      +		 %VAL(SCVETH_ADDRBUF.DEST(4)),%VAL(SCVETH_ADDRBUF.DEST(5)),0(      +		 %VAL(BCVADR_INETADR(0,ILV_DI)),(      +		 %VAL(BCVADR_INETADR(1,ILV_DI)),(      +		 %VAL(BCVADR_INETADR(2,ILV_DI)),(      +		 %VAL(BCVADR_INETADR(3,ILV_DI)),C      +		 %VAL(SCVADR_ADDR(I).BNUM(0)),%VAL(SCVADR_ADDR(I).BNUM(1)),.C      +		 %VAL(SCVADR_ADDR(I).BNUM(2)),%VAL(SCVADR_ADDR(I).BNUM(3)),IC      +		 %VAL(SCVADR_ADDR(I).BNUM(4)),%VAL(SCVADR_ADDR(I).BNUM(5)))'
 		      ENDIF  		    ENDIF 	 		  ENDDO  		ENDIF ( 		IF(SLV_IP.PROTOCOL .EQ. 17 .AND. ! UDPA      +		   IAND(SLV_IP.FRAG_OFF,'1FFF'X).EQ.0)THEN	! 1st fragment ; 		  IF(BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+1).      +				.EQ.'00'X .AND.EA      +		     BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+2)E,      +				.EQ.'35'X .AND.	! source= DNS portA      +		     BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+3)S      +				.EQ.'00'X .AND.AA      +		     BCVETH_RCVBUF(IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+4)A)      +				.EQ.'35'X)THEN	! dest= DNS portF4 		    ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),!      +					     ICPADR_DNSSERVER)%	 		  ENDIFC 		ENDIFU< 		ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_INET)> 	      ELSEIF(IAND(ICVADR_FLAGS(ILV_DI),ICPADR_IARP).EQ.0)THEN 		IF(IAND(ICVADR_FLAGS(ILV_DI),f8      +			ICPADR_INETGATEWAY+ICPADR_INETMLTIPA).EQ.0)THEN 		  IF(LCVETH_MSGS_ENB(4))THEN. 		    CALL LIB$SIGNAL(ETH__FNDMLTIPA,%VAL(14),C      +			%VAL(SCVETH_ADDRBUF.DEST(0)),%VAL(SCVETH_ADDRBUF.DEST(1)),TC      +			%VAL(SCVETH_ADDRBUF.DEST(2)),%VAL(SCVETH_ADDRBUF.DEST(3)),EC      +			%VAL(SCVETH_ADDRBUF.DEST(4)),%VAL(SCVETH_ADDRBUF.DEST(5)),L(      +			%VAL(BCVADR_INETADR(0,ILV_DI)),(      +			%VAL(BCVADR_INETADR(1,ILV_DI)),(      +			%VAL(BCVADR_INETADR(2,ILV_DI)),(      +			%VAL(BCVADR_INETADR(3,ILV_DI)),3      +			%VAL(SLV_IP.DEST(0)),%VAL(SLV_IP.DEST(1)),=3      +			%VAL(SLV_IP.DEST(2)),%VAL(SLV_IP.DEST(3))) 	 		  ENDIFD2 		  ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),       +					   ICPADR_INETMLTIPA) 		ENDIF  	      ENDIF
 	    ENDIF CM CP.  .  .  ENDIF C  	  ENDIF C	
 CP.  .  ENDIFE C	 	ENDIF C:2 CP.  ELSEIF protocol type is DEC LAVC (60-07) THEN CR)       ELSEIF(NCVETH_PROT .EQ.'0760'X)THENN C E CP.  .  IF message addressed to LAVC Node ID for some LAVC group THEN1 C+- 	IF(SCVETH_ADDRBUF.LDEST .EQ.'010400AB'X.AND.S#      +	   NCVETH_IOSB(1).GE.62)THENA C)# CP.  .  .  copy message into bufferI CL# 	  SLV_LAVC.BUF=CCVETH_RCVBUF(1:56)F C.Q CP.  .  .  IF Ethernet addresses match and other message stuff looks "OK"(?) THEN= C 1 	  IF(SLV_LAVC.LSRC .EQ.SCVETH_ADDRBUF.LSRC .AND.49      +	     SLV_LAVC.LSRC4 .EQ.SCVETH_ADDRBUF.LSRC4 .AND. 3      +	     SLV_LAVC.DUMMY2(0) .EQ.'000800A0'X)THEN  C > CP.  .  .  .  try to insert group multicast into address table C  	    IF(ILV_DI.GE.0.AND.>      +	       IAND(ICVADR_FLAGS(ILV_DI),ICPADR_LAVC).EQ.0)THEND 	      IF(NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-1)THEN( 		IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THEN 		  NCVADR_MISCNAMLEN(ILV_DI)=%      +				NCVADR_MISCNAMLEN(ILV_DI)+1	: 		  CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=',' 		ENDIFT! 		CALL SYS$FAO('LAVC ID(!UW)',LN,)#      +			   CCVADR_MISCNAM(ILV_DI)( )      +					NCVADR_MISCNAMLEN(ILV_DI)+1:),V/      +			   %VAL(SCVETH_ADDRBUF.W_DEST(2)-256))(8 		NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+LN< 		ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_LAVC) 	      ENDIF
 	    ENDIF CL5 CP.  .  .  .  try to insert source into address table= CD 	    IF(ILV_SI.GE.0)THEN< 	      IF(IAND(ICVADR_FLAGS(ILV_SI),ICPADR_DECNET).EQ.0)THEN 		LN=SLV_LAVC.NAMELEN_ 		DO WHILE (LN.GE.1.AND.(      +			  SLV_LAVC.NAME(LN:LN) .EQ.' ') 		  LN=LN-11 		ENDDOE. 		CCVADR_DECNETNAM(ILV_SI)=SLV_LAVC.NAME(1:LN)  		NCVADR_DECNETNAMLEN(ILV_SI)=LN> 		ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_DECNET) 	      ENDIFD 	      IF(NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.9      +		 IAND(ICVADR_FLAGS(ILV_SI),ICPADR_LAVC).EQ.0)THENL( 		IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN9 		  NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1A: 		  CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=',' 		ENDIFA 		CALL SYS$FAO('LAVC!UW',LN,>      +			CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:),1      +			     %VAL(SCVETH_ADDRBUF.W_DEST(2)-256)),8 		NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+LN< 		ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_LAVC) 	      ENDIF
 	    ENDIF C_ CP.  .  .  ENDIF C: 	  ENDIF C	
 CP.  .  ENDIF  C  	ENDIF CS8 CP.  ELSEIF protocol type is DECnet routers (60-03) THEN CC)       ELSEIF(NCVETH_PROT .EQ.'0360'X)THEN  CDC CP.  .  IF we have non-currently-busy access to the DECnet ACP THEN  C	 	IF(.NOT.LCVETH_DECNETBUSY)THENI CA4 CP.  .  .  IF source address is a DECnet address and0 CP		entry needs to be made for this address THEN CA. 	  IF(SCVETH_ADDRBUF.LSRC .EQ.'000400AA'X.AND.      +	     ILV_SI.GE.0.AND.1      +	     NCVADR_DECNETNAMLEN(ILV_SI).EQ.0)THEN  C & CP.  .  .  .  ask NETACP for node name CCD 	    LCVETH_DECNETBUSY=.TRUE.	! mark that no more $QIO's can be done 	    ILV_NFBDSC(0)=24Z  	    ILV_NFBDSC(1)=%LOC(SLV_NFB) 	    SLV_NFB.FCT=NFB$C_FC_SHOW 	    SLV_NFB.FLAGS=NFB$M_NOUPD" 	    SLV_NFB.DATABASE=NFB$C_DB_NDI 	    SLV_NFB.OPER=NFB$C_OP_EQL# 	    SLV_NFB.SRCH_KEY=NFB$C_NDI_ADDC% 	    SLV_NFB.SRCH2_KEY=NFB$C_WILDCARD( 	    SLV_NFB.DUMMY=0 	    SLV_NFB.CELL_SIZE=0$ 	    SLV_NFB.ITMLST(1)=NFB$C_NDI_NNA 	    SLV_NFB.ITMLST(2)=0( 	    ILV_BUFDSC(0)=LEN(CCVETH_NETACPBUF)) 	    ILV_BUFDSC(1)=%LOC(CCVETH_NETACPBUF)m 	    ILV_KEYDSC(0)=8  	    ILV_KEYDSC(1)=%LOC(ILV_KEY) 	    ILV_KEY(0)=0O* 	    ILV_KEY(1)=ZEXT(SCVETH_ADDRBUF.LSRC4)3 	    ILV_STATUS=SYS$QIO(%VAL(0),	! use scratch EFN,D?      +			 %VAL(NCVETH_DECNETCHAN), ! specify channel to device,d3      +			 %VAL(IO$_ACPCONTROL),	! specify function,.;      +			 %REF(NCVETH_NETIOSB),	! specify I/O status block,L'      +			 NETACP_QUERY,		! specify AST, 8      +			 %VAL(ILV_SI),		! specify table slot# as param,*      +			 %REF(ILV_NFBDSC),	! specify NFB,2      +			 %REF(ILV_KEYDSC),,	! specify search key,6      +			 %REF(ILV_BUFDSC),,)	! specify return buffer. 	    IF(.NOT.ILV_STATUS)THEN8 	      CALL LIB$SIGNAL(ETH__QIONETACP,,%VAL(ILV_STATUS))
 	    ENDIF CR= CP.  .  .  ELSEIF destination address is a DECnet address andU0 CP		entry needs to be made for this address THEN C 3 	  ELSEIF(SCVETH_ADDRBUF.LDEST .EQ.'000400AA'X.AND.       +		 ILV_DI.GE.0.AND.D.      +		 NCVADR_DECNETNAMLEN(ILV_DI).EQ.0)THEN Cd& CP.  .  .  .  ask NETACP for node name CsD 	    LCVETH_DECNETBUSY=.TRUE.	! mark that no more $QIO's can be done 	    ILV_NFBDSC(0)=24)  	    ILV_NFBDSC(1)=%LOC(SLV_NFB) 	    SLV_NFB.FCT=NFB$C_FC_SHOW 	    SLV_NFB.FLAGS=NFB$M_NOUPD" 	    SLV_NFB.DATABASE=NFB$C_DB_NDI 	    SLV_NFB.OPER=NFB$C_OP_EQL# 	    SLV_NFB.SRCH_KEY=NFB$C_NDI_ADDC% 	    SLV_NFB.SRCH2_KEY=NFB$C_WILDCARDC 	    SLV_NFB.DUMMY=0 	    SLV_NFB.CELL_SIZE=0$ 	    SLV_NFB.ITMLST(1)=NFB$C_NDI_NNA 	    SLV_NFB.ITMLST(2)=0( 	    ILV_BUFDSC(0)=LEN(CCVETH_NETACPBUF)) 	    ILV_BUFDSC(1)=%LOC(CCVETH_NETACPBUF)Q 	    ILV_KEYDSC(0)=8  	    ILV_KEYDSC(1)=%LOC(ILV_KEY) 	    ILV_KEY(0)=0A+ 	    ILV_KEY(1)=ZEXT(SCVETH_ADDRBUF.LDEST4)S3 	    ILV_STATUS=SYS$QIO(%VAL(0),	! use scratch EFN,C?      +			 %VAL(NCVETH_DECNETCHAN), ! specify channel to device,(3      +			 %VAL(IO$_ACPCONTROL),	! specify function,A;      +			 %REF(NCVETH_NETIOSB),	! specify I/O status block, '      +			 NETACP_QUERY,		! specify AST, 8      +			 %VAL(ILV_DI),		! specify table slot# as param,*      +			 %REF(ILV_NFBDSC),	! specify NFB,2      +			 %REF(ILV_KEYDSC),,	! specify search key,6      +			 %REF(ILV_BUFDSC),,)	! specify return buffer. 	    IF(.NOT.ILV_STATUS)THEN8 	      CALL LIB$SIGNAL(ETH__QIONETACP,,%VAL(ILV_STATUS))
 	    ENDIF Cs CP.  .  .  ENDIF C( 	  ENDIF C(
 CP.  .  ENDIFH CV 	ENDIF C)= CP.  ELSEIF protocol type is ARP (08-06) or RARP (80-35) THEN) C5)       ELSEIF((NCVETH_PROT .EQ.'0608'X.OR.E*      +	      NCVETH_PROT .EQ.'3580'X).AND.!      +	     .NOT.LCVETH_IEEE)THENF CC& CP.  .  IF message is long enough THEN C	 	IF(NCVETH_IOSB(1).GE.28)THENA CC, CP.  .  .  copy ARP/RARP message into buffer CB" 	  SLV_ARP.BUF=CCVETH_RCVBUF(1:28) C I CP.  .  .  IF protocol address space specified in msg is Apollo DOMAIN or( CP		Berkeley trailers THEN C(* 	  IF((SLV_ARP.PROT_SPACE .EQ.'0010'X .OR.1      +	      SLV_ARP.PROT_SPACE .EQ.'1980'X).AND. $      +	     SLV_ARP.H_LEN .EQ.6.AND.$      +	     SLV_ARP.P_LEN .EQ.4)THEN CL0 CP.  .  .  .  do nothing (and avoid complaining) Cs
 	    CONTINUEo C N CP.  .  .  ELSEIF protocol address space specified in msg is DoD Internet THEN Cr- 	  ELSEIF(SLV_ARP.PROT_SPACE .EQ.'0008'X.AND.P!      +		 SLV_ARP.H_LEN .EQ.6.AND.o!      +		 SLV_ARP.P_LEN .EQ.4)THENL CPB CP.  .  .  .  IF message is ARP request, or ARP or RARP reply THEN C & 	    IF(SLV_ARP.OPCODE .EQ.'0100'X.OR.,      +	       SLV_ARP.OPCODE .EQ.'0200'X.OR.-      +	       SLV_ARP.OPCODE .EQ.'0400'X)THEN. C.6 CP.  .  .  .  .  IF source address index is valid THEN C( 	      IF(ILV_SI.GE.0)THEN CAI CP.  .  .  .  .  .  IF sender is reporting for itself (not by proxy) THENW CC7 		IF(SCVADR_ADDR(ILV_SI).LNUM .EQ. SLV_ARP.S_LHWA .AND.O@      +		   SCVADR_ADDR(ILV_SI).NUM(2) .EQ. SLV_ARP.S_HWA(2))THEN C > CP.  .  .  .  .  .  .  try to insert sender into address table Cc* 		  IF(NCVADR_INETNAMLEN(ILV_SI).EQ.0 .OR.<      +		     ICVADR_INETADR(ILV_SI) .NE. SLV_ARP.LS_PTA)THEN? 		    CALL SYS$FAO('!UB.!UB.!UB.!UB',NCVADR_INETNAMLEN(ILV_SI), "      +				 CCVADR_INETNAM(ILV_SI),9      +				 %VAL(SLV_ARP.S_PTA(0)),%VAL(SLV_ARP.S_PTA(1)),c9      +				 %VAL(SLV_ARP.S_PTA(2)),%VAL(SLV_ARP.S_PTA(3)))d+ 		    ICVADR_INETADR(ILV_SI)=SLV_ARP.LS_PTAK9 		    ICVADR_FLAGS(ILV_SI)=IOR(IAND(ICVADR_FLAGS(ILV_SI),B$      +						  NOT(ICPADR_INETNAME)),(      +					     ICPADR_INET+ICPADR_IARP)# 		    IF(IAND(ICVADR_FLAGS(ILV_SI),,<      +			    ICPADR_INETGATEWAY+ICPADR_INETMLTIPA).NE.0)THEN7 		      ICVADR_FLAGS(ILV_SI)=IAND(ICVADR_FLAGS(ILV_SI),	#      +						NOT(ICPADR_INETMLTIPA))  		    ENDIF 	 		  ENDIF. C ) CP.  .  .  .  .  .  ELSE {proxy reporter}  CI  		ELSEIF(LCVETH_MSGS_ENB(5))THEN C . CP.  .  .  .  .  .  .  announce proxy reporter CI+ 		  CALL LIB$SIGNAL(ETH__PROXYARP,%VAL(12),PA      +			%VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),rA      +			%VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),(A      +			%VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),.9      +			%VAL(SLV_ARP.S_BHWA(0)),%VAL(SLV_ARP.S_BHWA(1)),N9      +			%VAL(SLV_ARP.S_BHWA(2)),%VAL(SLV_ARP.S_BHWA(3)),S9      +			%VAL(SLV_ARP.S_BHWA(4)),%VAL(SLV_ARP.S_BHWA(5)))L CV CP.  .  .  .  .  .  ENDIF( C, 		ENDIF	 C  CP.  .  .  .  .  ENDIF CV 	      ENDIF C  CP.  .  .  .  ENDIF) CV
 	    ENDIF CI2 CP.  .  .  .  IF message is ARP or RARP reply THEN CA& 	    IF(SLV_ARP.OPCODE .EQ.'0200'X.OR.-      +	       SLV_ARP.OPCODE .EQ.'0400'X)THENN C ; CP.  .  .  .  .  IF destination address index is valid THENN CD 	      IF(ILV_DI.GE.0)THEN CTI CP.  .  .  .  .  .  IF target is receiving for itself (not by proxy) THENB CS7 		IF(SCVADR_ADDR(ILV_DI).LNUM .EQ. SLV_ARP.T_LHWA .AND.H@      +		   SCVADR_ADDR(ILV_DI).NUM(2) .EQ. SLV_ARP.T_HWA(2))THEN CA> CP.  .  .  .  .  .  .  try to insert target into address table CI* 		  IF(NCVADR_INETNAMLEN(ILV_DI).EQ.0 .OR.<      +		     ICVADR_INETADR(ILV_DI) .NE. SLV_ARP.LT_PTA)THEN? 		    CALL SYS$FAO('!UB.!UB.!UB.!UB',NCVADR_INETNAMLEN(ILV_DI),("      +				 CCVADR_INETNAM(ILV_DI),9      +				 %VAL(SLV_ARP.T_PTA(0)),%VAL(SLV_ARP.T_PTA(1)),D9      +				 %VAL(SLV_ARP.T_PTA(2)),%VAL(SLV_ARP.T_PTA(3)))L+ 		    ICVADR_INETADR(ILV_DI)=SLV_ARP.LT_PTA	9 		    ICVADR_FLAGS(ILV_DI)=IOR(IAND(ICVADR_FLAGS(ILV_DI), $      +						  NOT(ICPADR_INETNAME)),(      +					     ICPADR_INET+ICPADR_IARP)# 		    IF(IAND(ICVADR_FLAGS(ILV_DI),V<      +			    ICPADR_INETGATEWAY+ICPADR_INETMLTIPA).NE.0)THEN7 		      ICVADR_FLAGS(ILV_DI)=IAND(ICVADR_FLAGS(ILV_DI), #      +						NOT(ICPADR_INETMLTIPA))R 		    ENDIF 	 		  ENDIFC CR0 CP.  .  .  .  .  .  ELSE {proxy destination ?!?} C  		ELSE CS CP.  .  .  .  .  .  .  I CP.  .  .  .  .  .  ENDIFL C, 		ENDIF	 CA CP.  .  .  .  .  ENDIF CA 	      ENDIF CS CP.  .  .  .  ENDIFA CC
 	    ENDIF CC7 CP.  .  .  .  IF message is no recognized ARP type THENA CB' 	    IF(SLV_ARP.OPCODE .NE.'0100'X.AND. -      +	       SLV_ARP.OPCODE .NE.'0200'X.AND.R-      +	       SLV_ARP.OPCODE .NE.'0300'X.AND.R-      +	       SLV_ARP.OPCODE .NE.'0400'X.AND._5      +	       SLV_ARP.OPCODE .NE.'0500'X.AND.	! DRARP	5      +	       SLV_ARP.OPCODE .NE.'0600'X.AND.	! DRARPE5      +	       SLV_ARP.OPCODE .NE.'0700'X)THEN	! DRARPH C!4 CP.  .  .  .  .  report unrecognized ARP packet type C_& 	      IF(.NOT.LCVETH_MSGS_ENB(5))THEN
 		CONTINUE+ 	      ELSEIF(NCVETH_PROT .EQ. '0608'X)THENI* 		CALL LIB$SIGNAL(ETH__UNKARPOPC,%VAL(11),A      +			%VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),IA      +			%VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),FA      +			%VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),S5      +			%DESCR('ARP'),%VAL(SLV_ARP.B_PROT_SPACE(0)), '      +			%VAL(SLV_ARP.B_PROT_SPACE(1)),.=      +			%VAL(SLV_ARP.B_OPCODE(0)),%VAL(SLV_ARP.B_OPCODE(1)))p 	      ELSE ! RARP* 		CALL LIB$SIGNAL(ETH__UNKARPOPC,%VAL(11),A      +			%VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),.A      +			%VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),SA      +			%VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),F6      +			%DESCR('RARP'),%VAL(SLV_ARP.B_PROT_SPACE(0)),'      +			%VAL(SLV_ARP.B_PROT_SPACE(1)), =      +			%VAL(SLV_ARP.B_OPCODE(0)),%VAL(SLV_ARP.B_OPCODE(1)))  	      ENDIF CS CP.  .  .  .  ENDIF  CL
 	    ENDIF C_I CP.  .  .  ELSE {unrecognized ARP address type on Internet protocol type}B CS 	  ELSE  C 1 CP.  .  .  .  report unrecognized ARP packet typeF CC$ 	    IF(.NOT.LCVETH_MSGS_ENB(5))THEN 	      CONTINUEH) 	    ELSEIF(NCVETH_PROT .EQ. '0608'X)THENF. 	      CALL LIB$SIGNAL(ETH__UNKIPARP,%VAL(11),A      +			%VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)), A      +			%VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),LA      +			%VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),45      +			%DESCR('ARP'),%VAL(SLV_ARP.B_PROT_SPACE(0)),D'      +			%VAL(SLV_ARP.B_PROT_SPACE(1)),B1      +			%VAL(SLV_ARP.H_LEN),%VAL(SLV_ARP.P_LEN))% 	    ELSE ! RARP. 	      CALL LIB$SIGNAL(ETH__UNKIPARP,%VAL(11),A      +			%VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),VA      +			%VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),AA      +			%VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)),C6      +			%DESCR('RARP'),%VAL(SLV_ARP.B_PROT_SPACE(0)),'      +			%VAL(SLV_ARP.B_PROT_SPACE(1)),I1      +			%VAL(SLV_ARP.H_LEN),%VAL(SLV_ARP.P_LEN))M
 	    ENDIF C  CP.  .  .  ENDIF CE 	  ENDIF C 
 CP.  .  ENDIFo Cs 	ENDIF Ct4 CP.  ELSEIF protocol type is DEC Bridge (80-38) THEN C )       ELSEIF(NCVETH_PROT .EQ.'3880'X.AND..!      +	     .NOT.LCVETH_IEEE)THEN	 CV? CP.  .  IF source Ethernet address looks like a DEC Bridge THEN! Cn" 	IF(ILV_S_MANUF .EQ.'2B0008'X)THEN C 2 CP.  .  .  try to insert source into address table C. 	  IF(ILV_SI.GE.0.AND.F      +	     NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.?      +	     IAND(ICVADR_FLAGS(ILV_SI),ICPADR_DBRIDGE).EQ.0)THEND+ 	    IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN < 	      NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1= 	      CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=','A
 	    ENDIF> 	    ICVADR_SERNUM(ILV_SI)=JZEXT(SCVETH_ADDRBUF.W_SRC(2))*256+*      +			     JZEXT(SCVETH_ADDRBUF.SRC(3))  	    CALL SYS$FAO('brdg#!UL',LN,>      +		 CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:),&      +			 %VAL(ICVADR_SERNUM(ILV_SI))); 	    NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+LN(B 	    ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_DBRIDGE) 	    I=1- 	    DO WHILE (I .LE. ICVBRG_NUMBRIDGES .AND.D,      +		      ICVBRG_ADDRPTR(I) .NE. ILV_SI) 	      I=I+1
 	    ENDDO# 	    IF(I.GT.ICVBRG_NUMBRIDGES)THENE% 	      IF(I.LE.ICPBRG_MAXBRIDGES)THEN) 		ICVBRG_NUMBRIDGES=IE 		ICVBRG_ADDRPTR(I)=ILV_SI0 		ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),      +					 ICPADR_UNKLINADDR) 		LCVBRG_MAPOK=.FALSE. 	      ENDIF
 	    ENDIF 	  ENDIF CDM CP.  .  ELSEIF source looks like a Vitalink bridge speaking DEC protocol THENR CE& 	ELSEIF(ILV_S_MANUF .EQ.'7C0008'X)THEN CA* CP.  .  .  add this bridge to bridge table CI 	  IF(ILV_SI.GE.0)THENB 	    ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_DBRIDGE) 	    I=1- 	    DO WHILE (I .LE. ICVBRG_NUMBRIDGES .AND. ,      +		      ICVBRG_ADDRPTR(I) .NE. ILV_SI) 	      I=I+1
 	    ENDDO# 	    IF(I.GT.ICVBRG_NUMBRIDGES)THEN % 	      IF(I.LE.ICPBRG_MAXBRIDGES)THEN7 		ICVBRG_NUMBRIDGES=I  		ICVBRG_ADDRPTR(I)=ILV_SI0 		ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),      +					 ICPADR_UNKLINADDR) 		LCVBRG_MAPOK=.FALSE. 	      ENDIF
 	    ENDIF 	  ENDIF CF
 CP.  .  ENDIFI CE 	ENDIF C'9 CP.  .  IF destination is here (the monitoring port) THEN  C	. 	IF(SCVETH_ADDRBUF.LDEST .EQ. ICVETH_PHA .AND.:      +	   SCVETH_ADDRBUF.W_DEST(2) .EQ. NCVETH_PHA(2))THEN CB& CP.  .  .  IF mapping in progress THEN C  	  IF(LCVBRG_MAPCMD)THEN Cs: CP.  .  .  .  attempt to insert message into message queue CI2 	    IF(ICVBRG_QCOUNT .LT. ICPBRG_QUEUESIZE-1)THENC 	      ICVBRG_QPRODUCER=IAND(ICVBRG_QPRODUCER+1,ICPBRG_QUEUESIZE-1))5 	      NCVBRG_MSGLEN(ICVBRG_QPRODUCER)=NCVETH_IOSB(1)E9 	      CCVBRG_MSGBUF(ICVBRG_QPRODUCER)(1:NCVETH_IOSB(1))=_(      +			CCVETH_RCVBUF(1:NCVETH_IOSB(1))3 	      NCVBRG_MSGPROT(ICVBRG_QPRODUCER)=NCVETH_PROT($ 	      ICVBRG_QCOUNT=ICVBRG_QCOUNT+1( 	      CALL SYS$SETEF(%VAL(ICPBRG_QEFN))	 	    ELSE) 	      +
 	    ENDIF CA CP.  .  .  ENDIF CS 	  ENDIF C.H CP.  .  ELSEIF destination Ethernet address not multicaat and looks like CP			a DEC Bridge THEN CR( 	ELSEIF(ILV_D_MANUF .EQ. '2B0008'X .AND.,      +	       NOT(SCVETH_ADDRBUF.LDEST))THEN CR7 CP.  .  .  try to insert destination into address table  C+ 	  IF(ILV_DI.GE.0.AND.F      +	     NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.?      +	     IAND(ICVADR_FLAGS(ILV_DI),ICPADR_DBRIDGE).EQ.0)THENI+ 	    IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THEN < 	      NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+1= 	      CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=',' 
 	    ENDIF? 	    ICVADR_SERNUM(ILV_DI)=JZEXT(SCVETH_ADDRBUF.W_DEST(2))*256+ +      +			     JZEXT(SCVETH_ADDRBUF.DEST(3))f  	    CALL SYS$FAO('brdg#!UL',LN,>      +		 CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:),&      +			 %VAL(ICVADR_SERNUM(ILV_DI))); 	    NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+LN B 	    ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_DBRIDGE) 	    I=1- 	    DO WHILE (I .LE. ICVBRG_NUMBRIDGES .AND.D,      +		      ICVBRG_ADDRPTR(I) .NE. ILV_DI) 	      I=I+1
 	    ENDDO# 	    IF(I.GT.ICVBRG_NUMBRIDGES)THEN.% 	      IF(I.LE.ICPBRG_MAXBRIDGES)THEN  		ICVBRG_NUMBRIDGES=It 		ICVBRG_ADDRPTR(I)=ILV_DI0 		ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),      +					 ICPADR_UNKLINADDR) 		LCVBRG_MAPOK=.FALSE. 	      ENDIF
 	    ENDIF 	  ENDIF CC
 CP.  .  ENDIF  CF 	ENDIF CC1 CP.  ELSEIF protocol type is DEC LAT (60-04) THEN_ C=)       ELSEIF(NCVETH_PROT .EQ.'0460'X)THEN	 CCK CP.  .  IF source Ethernet address looks like a DECserver or DECbridge THENO CA! 	IF(ILV_S_MANUF.EQ.'2B0008'X)THENR CS2 CP.  .  .  try to insert source into address table C) 	  IF(ILV_SI.GE.0.AND.F      +	     NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.&      +	     IAND(ICVADR_FLAGS(ILV_SI),0      +		  ICPADR_DBRIDGE+ICPADR_DSERV).EQ.0)THEN+ 	    IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN < 	      NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1= 	      CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=','S
 	    ENDIF> 	    ICVADR_SERNUM(ILV_SI)=JZEXT(SCVETH_ADDRBUF.W_SRC(2))*256+*      +			     JZEXT(SCVETH_ADDRBUF.SRC(3))  	    CALL SYS$FAO('serv#!UL',LN,>      +		 CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:),&      +			 %VAL(ICVADR_SERNUM(ILV_SI))); 	    NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+LN_@ 	    ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_DSERV) 	  ENDIF C 
 CP.  .  ENDIFC CL 	ENDIF CNP CP.  .  IF destination Ethernet address looks like a DECserver or DECbridge THEN CN- 	IF(SCVETH_ADDRBUF.W_DEST(0) .EQ.'0008'X.AND.N/      +	   SCVETH_ADDRBUF.DEST(2) .EQ.'2B'X)THEND CI7 CP.  .  .  try to insert destination into address table  CV 	  IF(ILV_DI.GE.0.AND.F      +	     NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.&      +	     IAND(ICVADR_FLAGS(ILV_DI),0      +		  ICPADR_DBRIDGE+ICPADR_DSERV).EQ.0)THEN+ 	    IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THENN< 	      NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+1= 	      CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=',' 
 	    ENDIF? 	    ICVADR_SERNUM(ILV_DI)=JZEXT(SCVETH_ADDRBUF.W_DEST(2))*256+	+      +			     JZEXT(SCVETH_ADDRBUF.DEST(3)).  	    CALL SYS$FAO('serv#!UL',LN,>      +		 CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:),&      +			 %VAL(ICVADR_SERNUM(ILV_DI))); 	    NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+LND@ 	    ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_DSERV) 	  ENDIF C 
 CP.  .  ENDIFN CU 	ENDIF C 3 CP.  ELSEIF protocol type is AppleTalk (80-9B) THEN( C2)       ELSEIF(NCVETH_PROT .EQ.'9B80'X)THENS CN0 CP.  .  copy AppleTalk DDP header into structure C 1 	IF(LCVETH_IEEE)THEN			! IEEE 802.3, extended DDPE$ 	  SLV_DDP.C_BUF=CCVETH_RCVBUF(1:13) 	  J=14_; 	ELSEIF(BCVETH_RCVBUF(3).EQ.2)THEN	! Ethernet, extended DDPM$ 	  SLV_DDP.C_BUF=CCVETH_RCVBUF(4:16) 	  J=17MC 	ELSEIF(BCVETH_RCVBUF(3).EQ.1)THEN	! Ethernet, short DDP, bad news!N( 	  SLV_DDP.C_BUF(1:2)=CCVETH_RCVBUF(4:5) 	  SLV_DDP.B_CSUM(0)=0 	  SLV_DDP.B_CSUM(1)=0 	  SLV_DDP.B_DNET(0)=0 	  SLV_DDP.B_DNET(1)=0 	  SLV_DDP.B_SNET(0)=0 	  SLV_DDP.B_SNET(1)=0# 	  SLV_DDP.B_DNODE=BCVETH_RCVBUF(1)s# 	  SLV_DDP.B_SNODE=BCVETH_RCVBUF(2)E* 	  SLV_DDP.C_BUF(11:13)=CCVETH_RCVBUF(6:8) 	  J=9* 	ELSE					! not AppleTalk DDP, confused!!!) 	  CALL LIB$SIGNAL(ETH__BADAPPLE,%VAL(6),/A      +		 %VAL(SCVETH_ADDRBUF.SRC(0)),%VAL(SCVETH_ADDRBUF.SRC(1)),	A      +		 %VAL(SCVETH_ADDRBUF.SRC(2)),%VAL(SCVETH_ADDRBUF.SRC(3)),VA      +		 %VAL(SCVETH_ADDRBUF.SRC(4)),%VAL(SCVETH_ADDRBUF.SRC(5)))a 	ENDIF C - CP.  .  fill in source node AppleTalk addressf C.6 	IF(IAND(ICVADR_FLAGS(ILV_SI),ICPADR_MACNUM).EQ.0)THEN 	  IF(ILV_SI.GE.0.AND.F      +	     NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1)THEN$ 	    I=JZEXT(SLV_DDP.B_SNET(0))*256+%      +	      JZEXT(SLV_DDP.B_SNET(1))S/ 	    CALL SYS$FAO('!UL.!UB',LN,CLV_SCR,%VAL(I), %      +		       %VAL(SLV_DDP.B_SNODE))D+ 	    IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN < 	      NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1= 	      CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=','2
 	    ENDIF: 	    CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:)=      +			'Mac'//CLV_SCR(1:LN) : 	    NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),(      +			NCVADR_MISCNAMLEN(ILV_SI)+3+LN) 	  ENDIF? 	  ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_MACNUM)B 	ENDIF C0, CP.  .  IF destination is not multicast THEN CN# 	IF(.NOT. SCVETH_ADDRBUF.LDEST)THENN CV5 CP.  .  .  fill in destination node AppleTalk addressF C 8 	  IF(IAND(ICVADR_FLAGS(ILV_DI),ICPADR_MACNUM).EQ.0)THEN 	    IF(ILV_DI.GE.0.AND.H      +	       NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-1)THEN& 	      I=JZEXT(SLV_DDP.B_DNET(0))*256+       +		JZEXT(SLV_DDP.B_DNET(1))1 	      CALL SYS$FAO('!UL.!UB',LN,CLV_SCR,%VAL(I),        +			 %VAL(SLV_DDP.B_DNODE))- 	      IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THEN	7 		NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+1	8 		CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=',' 	      ENDIF< 	      CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI)+1:)=      +			'Mac'//CLV_SCR(1:LN)c< 	      NCVADR_MISCNAMLEN(ILV_DI)=MIN(LEN(CCVADR_MISCNAM(0)),(      +			NCVADR_MISCNAMLEN(ILV_DI)+3+LN)
 	    ENDIFA 	    ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_MACNUM)D 	  ENDIF CE
 CP.  .  ENDIFt C  	ENDIF C0= CP.  .  IF packet is Name Binding Protocol (NBP) message THEN0 C.& 	LN=0		! assume no match will be found' 	IF(SLV_DDP.B_DDPTYPE .EQ. 2)THEN	! NBPE C ' CP.  .  .  IF NBP function is LkUp THENN C	5 	  IF(BCVETH_RCVBUF(J).EQ.'21'X)THEN	! only one tupleR CA CP.  .  .  .  find zone name CV
 	    K=J+7. 	    K=K+BCVETH_RCVBUF(K)+1	! skip object name, 	    K=K+BCVETH_RCVBUF(K)+1	! skip type name C 6 CP.  .  .  .  IF source node zone not yet defined THEN CE 	    IF(ILV_SI.GE.0.AND.A      +	       IAND(ICVADR_FLAGS(ILV_SI),ICPADR_MACZONE).EQ.0)THEN  C.( CP.  .  .  .  .  IF legal zone name THEN C " 	      IF(K.LT.NCVETH_IOSB(1).AND.>      +		 BCVETH_RCVBUF(K).GE.1.AND.BCVETH_RCVBUF(K).LE.32.AND.:      +		 CCVETH_RCVBUF(K+1:K+BCVETH_RCVBUF(K)).NE.'*')THEN C > CP.  .  .  .  .  .  add router zone mark to miscellaneous name CN? 		IF(NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1)THEN.@ 		  I=INDEX(CCVADR_MISCNAM(ILV_SI)(1:NCVADR_MISCNAMLEN(ILV_SI)),      +			  'Mac')Q 		  IF(I.NE.0)THEN) 		    J=INDEX(CCVADR_MISCNAM(ILV_SI)(I+3: &      +					NCVADR_MISCNAMLEN(ILV_SI)),      +			    '.')+I+3  		    IF(J.GT.I+2)THEN5 		      DO WHILE (J.LE.NCVADR_MISCNAMLEN(ILV_SI).AND. 1      +				CCVADR_MISCNAM(ILV_SI)(J:J).GE.'0'.AND.n-      +				CCVADR_MISCNAM(ILV_SI)(J:J).LE.'9')) 			J=J+1
 		      ENDDO . 		      IF(J.GT.NCVADR_MISCNAMLEN(ILV_SI))THEN& 			CCVADR_MISCNAM(ILV_SI)(J:)=' rt '///      +				CCVETH_RCVBUF(K+1:K+BCVETH_RCVBUF(K))b 		      ELSE& 			CCVADR_MISCNAM(ILV_SI)(J:)=' rt '///      +				CCVETH_RCVBUF(K+1:K+BCVETH_RCVBUF(K))_&      +				//CCVADR_MISCNAM(ILV_SI)(J:)
 		      ENDIFN= 		      NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),	'      +					NCVADR_MISCNAMLEN(ILV_SI)+4+P      +						BCVETH_RCVBUF(K))R 		    ENDIFV	 		  ENDIFS 		ENDIFd0 		ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),      +					 ICPADR_MACZONE)I C( CP.  .  .  .  .  ENDIF C  	      ENDIF CA CP.  .  .  .  ENDIF+ C	
 	    ENDIF CED CP.  .  .  .  IF multicast destination and zone not yet defined THEN C_ 	    IF(ILV_DI .GE. 0 .AND.)(      +	       SCVETH_ADDRBUF.LDEST .AND.C      +	       IAND(ICVADR_FLAGS(ILV_DI),ICPADR_MACZONE) .EQ. 0)THEN  CN( CP.  .  .  .  .  IF legal zone name THEN CE" 	      IF(K.LT.NCVETH_IOSB(1).AND.>      +		 BCVETH_RCVBUF(K).GE.1.AND.BCVETH_RCVBUF(K).LE.32.AND.:      +		 CCVETH_RCVBUF(K+1:K+BCVETH_RCVBUF(K)).NE.'*')THEN C A CP.  .  .  .  .  .  add multicast zone name to miscellaneous name  C	? 		IF(NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-1)THEN+* 		  IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THEN; 		    NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+1R< 		    CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=','	 		  ENDIFS! 		  J=NCVADR_MISCNAMLEN(ILV_DI)+1%( 		  CCVADR_MISCNAM(ILV_DI)(J:)='zone '///      +				CCVETH_RCVBUF(K+1:K+BCVETH_RCVBUF(K)) 9 		  NCVADR_MISCNAMLEN(ILV_DI)=MIN(LEN(CCVADR_MISCNAM(0)), '      +					NCVADR_MISCNAMLEN(ILV_DI)+5+R      +						BCVETH_RCVBUF(K))I 		ENDIF.0 		ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),      +					 ICPADR_MACZONE)  C  CP.  .  .  .  .  ENDIF Cr 	      ENDIF Cd CP.  .  .  .  ENDIF( C_
 	    ENDIF CT- CP.  .  .  ELSEIF NBP function is FwdReq THENr Cs9 	  ELSEIF(BCVETH_RCVBUF(J).EQ.'41'X)THEN	! only one tuple  C. CP.  .  .  .  find zone name C 
 	    K=J+7. 	    K=K+BCVETH_RCVBUF(K)+1	! skip object name, 	    K=K+BCVETH_RCVBUF(K)+1	! skip type name Ca; CP.  .  .  .  IF destination node zone not yet defined THEN  C  	    IF(ILV_DI .GE. 0 .AND.I-      +	       NOT(SCVETH_ADDRBUF.LDEST) .AND.'C      +	       IAND(ICVADR_FLAGS(ILV_DI),ICPADR_MACZONE) .EQ. 0)THENA CL( CP.  .  .  .  .  IF legal zone name THEN CL" 	      IF(K.LT.NCVETH_IOSB(1).AND.>      +		 BCVETH_RCVBUF(K).GE.1.AND.BCVETH_RCVBUF(K).LE.32.AND.:      +		 CCVETH_RCVBUF(K+1:K+BCVETH_RCVBUF(K)).NE.'*')THEN C(> CP.  .  .  .  .  .  add router zone mark to miscellaneous name C+? 		IF(NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-1)THENV@ 		  I=INDEX(CCVADR_MISCNAM(ILV_DI)(1:NCVADR_MISCNAMLEN(ILV_DI)),      +			  'Mac')F 		  IF(I.NE.0)THEN) 		    J=INDEX(CCVADR_MISCNAM(ILV_DI)(I+3:R&      +					NCVADR_MISCNAMLEN(ILV_DI)),      +			    '.')+I+3. 		    IF(J.GT.I+2)THEN5 		      DO WHILE (J.LE.NCVADR_MISCNAMLEN(ILV_DI).AND..1      +				CCVADR_MISCNAM(ILV_DI)(J:J).GE.'0'.AND..-      +				CCVADR_MISCNAM(ILV_DI)(J:J).LE.'9')  			J=J+1
 		      ENDDOC. 		      IF(J.GT.NCVADR_MISCNAMLEN(ILV_DI))THEN& 			CCVADR_MISCNAM(ILV_DI)(J:)=' rt '///      +				CCVETH_RCVBUF(K+1:K+BCVETH_RCVBUF(K))E 		      ELSE& 			CCVADR_MISCNAM(ILV_DI)(J:)=' rt '///      +				CCVETH_RCVBUF(K+1:K+BCVETH_RCVBUF(K))X&      +				//CCVADR_MISCNAM(ILV_DI)(J:)
 		      ENDIF = 		      NCVADR_MISCNAMLEN(ILV_DI)=MIN(LEN(CCVADR_MISCNAM(0)), '      +					NCVADR_MISCNAMLEN(ILV_DI)+4+T      +						BCVETH_RCVBUF(K))  		    ENDIFe	 		  ENDIFP 		ENDIFy0 		ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),      +					 ICPADR_MACZONE)H CO CP.  .  .  .  .  ENDIF CL 	      ENDIF CU CP.  .  .  .  ENDIF  C+
 	    ENDIF CA CP.  .  .  ENDIF CC 	  ENDIF CS
 CP.  .  ENDIF+ C% 	ENDIF CA7 CP.  ELSEIF protocol type is AppleTalk ARP (80-F3) THENA CC)       ELSEIF(NCVETH_PROT .EQ.'F380'X)THENC C)& CP.  .  IF message is long enough THEN CR 	IF(NCVETH_IOSB(1).GE.28)THENL CR' CP.  .  .  copy ARP message into bufferR C_" 	  SLV_ARP.BUF=CCVETH_RCVBUF(1:28) C G CP.  .  .  IF protocol address space specified in msg is AppleTalk THEN% C() 	  IF(SLV_ARP.PROT_SPACE .EQ.'9B80'X.AND.S$      +	     SLV_ARP.H_LEN .EQ.6.AND.$      +	     SLV_ARP.P_LEN .EQ.4)THEN C 5 CP.  .  .  .  IF message is ARP request or reply THENS C5& 	    IF(SLV_ARP.OPCODE .EQ.'0100'X.OR.-      +	       SLV_ARP.OPCODE .EQ.'0200'X)THENR CS8 CP.  .  .  .  .  try to insert sender into address table C_ 	      IF(ILV_SI.GE.0.AND.C      +		 NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.g;      +		 IAND(ICVADR_FLAGS(ILV_SI),ICPADR_MACNUM).EQ.0)THENS" 		I=JZEXT(SLV_ARP.S_PTA(0))*65536+*      +			     JZEXT(SLV_ARP.S_PTA(1))*256+%      +			     JZEXT(SLV_ARP.S_PTA(2)) , 		CALL SYS$FAO('!UL.!UB',LN,CLV_SCR,%VAL(I),%      +			     %VAL(SLV_ARP.S_PTA(3)))(( 		IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN9 		  NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1F: 		  CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=',' 		ENDIFS7 		CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:)=P      +			'Mac'//CLV_SCR(1:LN))7 		NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),A(      +			NCVADR_MISCNAMLEN(ILV_SI)+3+LN)> 		ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_MACNUM) 	      ENDIF CE CP.  .  .  .  ENDIFA CC
 	    ENDIF CC* CP.  .  .  .  IF message is ARP reply THEN CA' 	    IF(SLV_ARP.OPCODE .EQ.'0200'X)THEN( CE CP.  .  .  .  ENDIFA CC
 	    ENDIF CC CP.  .  .  ENDIF CC 	  ENDIF CL
 CP.  .  ENDIF_ CC 	ENDIF C 9 CP.  ELSEIF protocol type is Vitalink Bridge (80-80) THEN. CE)       ELSEIF(NCVETH_PROT .EQ.'8080'X.AND.P!      +	     .NOT.LCVETH_IEEE)THENP C.E CP.  .  IF legal source entry and not tagged as Vitalink already THEN8 CH 	IF(ILV_SI.GE.0.AND.>      +	   IAND(ICVADR_FLAGS(ILV_SI),ICPADR_VITALINK).EQ.0)THEN CV% CP.  .  .  add source to bridge tableo Cl 	  I=1+ 	  DO WHILE (I .LE. ICVBRG_NUMBRIDGES .AND.0*      +		    ICVBRG_ADDRPTR(I) .NE. ILV_SI)
 	    I=I+1 	  ENDDO! 	  IF(I.GT.ICVBRG_NUMBRIDGES)THEN # 	    IF(I.LE.ICPBRG_MAXBRIDGES)THENC 	      ICVBRG_NUMBRIDGES=I 	      ICVBRG_ADDRPTR(I)=ILV_SII5 	      ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),(#      +				       ICPADR_UNKLINADDR)C 	      LCVBRG_MAPOK=.FALSE.L
 	    ENDIF 	  ENDIF CD CP.  .  .  IF destination is9 CP		at least partially logging multicast address and room) CP		to store name string THEN* C+/ 	  IF(SCVETH_ADDRBUF.W_DEST(2) .EQ.'0100'X.AND. F      +	     NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1)THEN CMH CP.  .  .  .  IF destination address is 3Com/Bridge or Vitalink logging  CP			multicast address THENL CI1 	    IF(SCVETH_ADDRBUF.LDEST .EQ.'04020009'X .OR.A7      +	       SCVETH_ADDRBUF.LDEST .EQ.'047C0009'X)THENE CC8 CP.  .  .  .  .  compute name of bridge from log message CI: 	      I=INDEX(CCVETH_RCVBUF(1:NCVETH_IOSB(1)),'NAME= ')+6 	      IF(I.LE.9)THEN.8 		I=INDEX(CCVETH_RCVBUF(1:NCVETH_IOSB(1)),'MESSAGE: ')+9 	      ENDIF 	      IF(I.LE.9)THENI8 		I=INDEX(CCVETH_RCVBUF(1:NCVETH_IOSB(1)),'WARNING: ')+9 	      ENDIF 	      IF(I.LE.9)THEN 6 		I=INDEX(CCVETH_RCVBUF(1:NCVETH_IOSB(1)),'ALARM: ')+7 	      ENDIF 	      IF(I.GE.14)THEN= 		J=MAX(INDEX(CCVETH_RCVBUF(I:NCVETH_IOSB(1)),' 0800')+I-2,I) ( 		IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN9 		  NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1=: 		  CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=',' 		ENDIF.7 		CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:)=R)      +			'brdg('//CCVETH_RCVBUF(I:J)//')' 7 		NCVADR_MISCNAMLEN(ILV_SI)=MIN(LEN(CCVADR_MISCNAM(0)),R+      +			NCVADR_MISCNAMLEN(ILV_SI)+(J-I)+7)	@ 		ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_VITALINK) 	      ENDIF C	 CP.  .  .  .  ENDIF) C	
 	    ENDIF CA CP.  .  .  ENDIF C  	  ENDIF CE
 CP.  .  ENDIF. CN 	ENDIF CE0 CP.  ELSEIF protocol type is Xyplex (08-88) THEN Ci)       ELSEIF(NCVETH_PROT .EQ.'8808'X.AND.T!      +	     .NOT.LCVETH_IEEE)THENC CH* CP.  .  IF valid source address entry THEN C  	IF(ILV_SI.GE.0)THEN Cp8 CP.  .  .  IF source Ethernet address looks "OK"(?) THEN C . 	  IF(SCVETH_ADDRBUF.LSRC .EQ.'00870008'X)THEN C 5 CP.  .  .  .  try to insert source into address table  CVB 	    IF(NCVADR_MISCNAMLEN(ILV_SI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.@      +	       IAND(ICVADR_FLAGS(ILV_SI),ICPADR_XYPLEX).EQ.0)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_SI).NE.0)THEN+7 		NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+1(8 		CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI):)=',' 	      ENDIF> 	      ICVADR_SERNUM(ILV_SI)=JZEXT(SCVETH_ADDRBUF.SRC(4))*256+*      +			     JZEXT(SCVETH_ADDRBUF.SRC(5))! 	      CALL SYS$FAO('unit!UW',LN,h=      +		CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_SI)+1:),H&      +			 %VAL(ICVADR_SERNUM(ILV_SI)))= 	      NCVADR_MISCNAMLEN(ILV_SI)=NCVADR_MISCNAMLEN(ILV_SI)+LN 
 	    ENDIF Cn CP.  .  .  ENDIF C  	  ENDIF? 	  ICVADR_FLAGS(ILV_SI)=IOR(ICVADR_FLAGS(ILV_SI),ICPADR_XYPLEX)L CI
 CP.  .  ENDIF_ CC 	ENDIF CN/ CP.  .  IF valid destination address entry THEND CD 	IF(ILV_DI.GE.0)THEN CC= CP.  .  .  IF destination Ethernet address looks "OK"(?) THENV C)/ 	  IF(SCVETH_ADDRBUF.LDEST .EQ.'00870008'X)THENA CL: CP.  .  .  .  try to insert destination into address table C_B 	    IF(NCVADR_MISCNAMLEN(ILV_DI).LT.LEN(CCVADR_MISCNAM(0))-1.AND.@      +	       IAND(ICVADR_FLAGS(ILV_DI),ICPADR_XYPLEX).EQ.0)THEN- 	      IF(NCVADR_MISCNAMLEN(ILV_DI).NE.0)THENE7 		NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+1 8 		CCVADR_MISCNAM(ILV_DI)(NCVADR_MISCNAMLEN(ILV_DI):)=',' 	      ENDIF? 	      ICVADR_SERNUM(ILV_DI)=JZEXT(SCVETH_ADDRBUF.DEST(4))*256+ +      +			     JZEXT(SCVETH_ADDRBUF.DEST(5))D! 	      CALL SYS$FAO('unit!UW',LN,N=      +		CCVADR_MISCNAM(ILV_SI)(NCVADR_MISCNAMLEN(ILV_DI)+1:),I&      +			 %VAL(ICVADR_SERNUM(ILV_DI)))= 	      NCVADR_MISCNAMLEN(ILV_DI)=NCVADR_MISCNAMLEN(ILV_DI)+LN 
 	    ENDIF CI CP.  .  .  ENDIF CG 	  ENDIF? 	  ICVADR_FLAGS(ILV_DI)=IOR(ICVADR_FLAGS(ILV_DI),ICPADR_XYPLEX)E CF
 CP.  .  ENDIF  CD 	ENDIF C 
 CP.  ENDIF C        ENDIFP CE( CP.  add statistics to pre-filter counts C (       ICVSTT_BYTES_S_PRE(ICVSTT_BUFNUM)=9      +			ICVSTT_BYTES_S_PRE(ICVSTT_BUFNUM)+NCVETH_IOSB(1)E'       ICVSTT_MSGS_S_PRE(ICVSTT_BUFNUM)=_+      +			ICVSTT_MSGS_S_PRE(ICVSTT_BUFNUM)+1t6       ICVTRC_BYTES_PRE=ICVTRC_BYTES_PRE+NCVETH_IOSB(1)'       ICVTRC_MSGS_PRE=ICVTRC_MSGS_PRE+1_ C.E CP.  DO WHILE end of filter list not reached and message not rejected, C 	       I=0A       LLV_EXCLUDE=.FALSE..       LLV_ONLY(1)=.FALSE.N       LLV_ONLYEXIST(1)=.FALSE.       LLV_ONLY(2)=.FALSE.N       LLV_ONLYEXIST(2)=.FALSE.       LLV_ONLY(3)=.FALSE.C       LLV_ONLYEXIST(3)=.FALSE.7       IF(LCVFLT_ENB_SIZE .AND.		! must be in size rangeU.      +	 (NCVETH_IOSB(1).LT.NCVFLT_MINSIZE .OR./      +	  NCVETH_IOSB(1).GT.NCVFLT_MAXSIZE))THEN  	LLV_EXCLUDE=.TRUE.(       ENDIFR+       DO WHILE (I.LE.ICVFLT_NUMFILTERS.AND.D      +		.NOT.LLV_EXCLUDE)V C_< CP.  .  check if message is acceptable under current filters CG: 	IF(SCVFLT_FILTERS(I).ENABLE)THEN	! enable must be=1(odd) + 	  IF(SCVFLT_FILTERS(I).PROT_ACT .EQ.1)THENF: 	    IF(SCVFLT_FILTERS(I).W_PROTOCOL .EQ. NCVETH_PROT)THEN 	      LLV_EXCLUDE=.TRUE.A
 	    ENDIF/ 	  ELSEIF(SCVFLT_FILTERS(I).PROT_ACT .EQ.2)THEND: 	    IF(SCVFLT_FILTERS(I).W_PROTOCOL .EQ. NCVETH_PROT)THEN 	      LLV_ONLY(1)=.TRUE.V
 	    ENDIF 	    LLV_ONLYEXIST(1)=.TRUE. 	  ENDIF2 	  GOTO (2001,2002,2003,2004,2005,2006,2007,2008),"      +			SCVFLT_FILTERS(I).SRC_ACT 	    GOTO 2009+  2001	    IF(SCVFLT_FILTERS(I).LSOURCE .EQ.R"      +			SCVETH_ADDRBUF.LSRC .AND.-      +	       SCVFLT_FILTERS(I).LSOURCE4 .EQ.I"      +			SCVETH_ADDRBUF.LSRC4)THEN 	      LLV_EXCLUDE=.TRUE.I
 	    ENDIF 	    GOTO 2009+  2002	    IF(SCVFLT_FILTERS(I).LSOURCE .EQ.E"      +			SCVETH_ADDRBUF.LSRC .AND.-      +	       SCVFLT_FILTERS(I).LSOURCE4 .EQ.#"      +			SCVETH_ADDRBUF.LSRC4)THEN 	      LLV_ONLY(2)=.TRUE._
 	    ENDIF 	    LLV_ONLYEXIST(2)=.TRUE. 	    GOTO 2009<  2003	    IF(SCVFLT_FILTERS(I).LSOURCE .EQ. ILV_S_MANUF)THEN 	      LLV_EXCLUDE=.TRUE.R
 	    ENDIF 	    GOTO 2009<  2004	    IF(SCVFLT_FILTERS(I).LSOURCE .EQ. ILV_S_MANUF)THEN 	      LLV_ONLY(2)=.TRUE.0
 	    ENDIF 	    LLV_ONLYEXIST(2)=.TRUE. 	    GOTO 2009,  2005	    IF((SCVFLT_FILTERS(I).LSOURCE .EQ."      +			SCVETH_ADDRBUF.LSRC .AND..      +	        SCVFLT_FILTERS(I).LSOURCE4 .EQ.#      +			SCVETH_ADDRBUF.LSRC4) .OR.(-      +	       (SCVFLT_FILTERS(I).LSOURCE .EQ. #      +			SCVETH_ADDRBUF.LDEST .AND.4.      +	        SCVFLT_FILTERS(I).LSOURCE4 .EQ.$      +			SCVETH_ADDRBUF.LDEST4))THEN 	      LLV_EXCLUDE=.TRUE.H
 	    ENDIF 	    GOTO 2009,  2006	    IF((SCVFLT_FILTERS(I).LSOURCE .EQ."      +			SCVETH_ADDRBUF.LSRC .AND.'      +		SCVFLT_FILTERS(I).LSOURCE4 .EQ.(#      +			SCVETH_ADDRBUF.LSRC4) .OR.F-      +	       (SCVFLT_FILTERS(I).LSOURCE .EQ.S#      +			SCVETH_ADDRBUF.LDEST .AND.)'      +		SCVFLT_FILTERS(I).LSOURCE4 .EQ.c$      +			SCVETH_ADDRBUF.LDEST4))THEN 	      LLV_ONLY(2)=.TRUE.%
 	    ENDIF 	    LLV_ONLYEXIST(2)=.TRUE. 	    GOTO 2009<  2007	    IF(SCVFLT_FILTERS(I).LSOURCE .EQ. ILV_S_MANUF .OR.=      +	       SCVFLT_FILTERS(I).LSOURCE .EQ. ILV_D_MANUF)THENS 	      LLV_EXCLUDE=.TRUE..
 	    ENDIF 	    GOTO 2009<  2008	    IF(SCVFLT_FILTERS(I).LSOURCE .EQ. ILV_S_MANUF .OR.=      +	       SCVFLT_FILTERS(I).LSOURCE .EQ. ILV_D_MANUF)THENE 	      LLV_ONLY(2)=.TRUE.C
 	    ENDIF 	    LLV_ONLYEXIST(2)=.TRUE. 	    GOTO 2009  2009	  CONTINUEB 	  GOTO (2101,2102,2103,2104,2105,2106), SCVFLT_FILTERS(I).DST_ACT 	    GOTO 21090  2101	    IF(SCVFLT_FILTERS(I).LDESTINATION .EQ.#      +			SCVETH_ADDRBUF.LDEST .AND.C2      +	       SCVFLT_FILTERS(I).LDESTINATION4 .EQ.#      +			SCVETH_ADDRBUF.LDEST4)THENE 	      LLV_EXCLUDE=.TRUE.F
 	    ENDIF 	    GOTO 21090  2102	    IF(SCVFLT_FILTERS(I).LDESTINATION .EQ.#      +			SCVETH_ADDRBUF.LDEST .AND.N2      +	       SCVFLT_FILTERS(I).LDESTINATION4 .EQ.#      +			SCVETH_ADDRBUF.LDEST4)THEN  	      LLV_ONLY(3)=.TRUE.(
 	    ENDIF 	    LLV_ONLYEXIST(3)=.TRUE. 	    GOTO 2109A  2103	    IF(SCVFLT_FILTERS(I).LDESTINATION .EQ. ILV_D_MANUF)THENL 	      LLV_EXCLUDE=.TRUE.f
 	    ENDIF 	    GOTO 2109A  2104	    IF(SCVFLT_FILTERS(I).LDESTINATION .EQ. ILV_D_MANUF)THENE 	      LLV_ONLY(3)=.TRUE..
 	    ENDIF 	    LLV_ONLYEXIST(3)=.TRUE. 	    GOTO 2109&  2105	    IF(SCVETH_ADDRBUF.LDEST)THEN 	      LLV_EXCLUDE=.TRUE. 
 	    ENDIF 	    GOTO 2109&  2106	    IF(SCVETH_ADDRBUF.LDEST)THEN 	      LLV_ONLY(3)=.TRUE.L
 	    ENDIF 	    LLV_ONLYEXIST(3)=.TRUE. 	    GOTO 2109  2109	  CONTINUE 	ENDIF 	I=I+1 C=
 CP.  ENDDO CE       ENDDO  CC$ CP.  compute if message was rejected CV       DO I=1,3 	LLV_EXCLUDE=IOR(LLV_EXCLUDE,(,      +			IEOR(LLV_ONLY(I),LLV_ONLYEXIST(I)))       ENDDO_ C(! CP.  IF message not rejected THENV C)       IF(.NOT.LLV_EXCLUDE)THEN C+) CP.  .  add message to post-filter countsD C $ 	ICVSTT_BYTES_S_POST(ICVSTT_BUFNUM)=:      +			ICVSTT_BYTES_S_POST(ICVSTT_BUFNUM)+NCVETH_IOSB(1)# 	ICVSTT_MSGS_S_POST(ICVSTT_BUFNUM)=N,      +			ICVSTT_MSGS_S_POST(ICVSTT_BUFNUM)+1 C=
 CP.  ENDIF Cm       ENDIFf Cd= CP.  IF message not rejected or DISPLAY ignoring filters THENB Cu       IF(.NOT.LLV_EXCLUDE.OR.($      +	 ICVETH_DISPLAYMODE.LT.0)THEN C ! CP.  .  DO CASE (display mode) OF  CeD 	GOTO (1000,2000,3000,4000,5000,6000,7000), IABS(ICVETH_DISPLAYMODE)  	GOTO 9999		! if no display mode CaE CP.  .  CASE 1 (destinations): increment count of msgs with this addr  C(  1000	CONTINUE( 	  ICVADR_ADDRCNT(ILV_DI,ICVSTT_BUFNUM)=/      +			ICVADR_ADDRCNT(ILV_DI,ICVSTT_BUFNUM)+1I 	  GOTO 9999 C F CP.  .  CASE 2 (protocols): increment count of msgs with this protocol C1  2000	CONTINUE( 	  ICVSTT_PROTCNT(ILV_PI,ICVSTT_BUFNUM)=/      +			ICVSTT_PROTCNT(ILV_PI,ICVSTT_BUFNUM)+1  	  GOTO 9999 CtB CP.  .  CASE 3 (sizes): increment count of msgs in this size range CL  3000	CONTINUEE 	  ICVSTT_SIZECNT(MIN(MAX(NCVETH_IOSB(1)-1,0)/100,15),ICVSTT_BUFNUM)=N;      +		ICVSTT_SIZECNT(MIN(MAX(NCVETH_IOSB(1)-1,0)/100,15),N      +				ICVSTT_BUFNUM)+1 	  GOTO 9999 CN@ CP.  .  CASE 4 (sources): increment count of msgs with this addr C)  4000	CONTINUE( 	  ICVADR_ADDRCNT(ILV_SI,ICVSTT_BUFNUM)=/      +			ICVADR_ADDRCNT(ILV_SI,ICVSTT_BUFNUM)+1A 	  GOTO 9999 CCP CP.  .  CASE 5 (performance check): increment count of msgs with protocol, addrs CM  5000	CONTINUE( 	  ICVSTT_PROTCNT(ILV_PI,ICVSTT_BUFNUM)=/      +			ICVSTT_PROTCNT(ILV_PI,ICVSTT_BUFNUM)+1(( 	  ICVADR_ADDRCNT(ILV_SI,ICVSTT_BUFNUM)=/      +			ICVADR_ADDRCNT(ILV_SI,ICVSTT_BUFNUM)+1C( 	  ICVADR_ADDRCNT(ILV_DI,ICVSTT_BUFNUM)=/      +			ICVADR_ADDRCNT(ILV_DI,ICVSTT_BUFNUM)+1S 	  GOTO 9999 CIE CP.  .  CASE 6 (throughput): increment count of msgs in this timeslot  C+  6000	CONTINUE# 	  ICVSTT_PROTCNT(ICVSTT_BUFNUM,0)=	*      +			ICVSTT_PROTCNT(ICVSTT_BUFNUM,0)+1# 	  ICVSTT_PROTCNT(ICVSTT_BUFNUM,1)=O7      +			ICVSTT_PROTCNT(ICVSTT_BUFNUM,1)+NCVETH_IOSB(1)P 	  GOTO 9999 C+G CP.  .  CASE 7 (increment count of Internet IP messages with protocol):  C   7000	CONTINUE" 	  IF(NCVETH_PROT .EQ.'0008'X)THEN# 	    SLV_IP.BUF=CCVETH_RCVBUF(1:20) 9 	    ICVSTT_PROTCNT(ZEXT(SLV_IP.PROTOCOL),ICVSTT_BUFNUM)=.>      +			ICVSTT_PROTCNT(ZEXT(SLV_IP.PROTOCOL),ICVSTT_BUFNUM)+1, 	    I=IAND(ZEXT(SLV_IP.VERS_IHL),'0F'X)*4+1B 	    IF(IAND(SLV_IP.FRAG_OFF,'1FFF'X).NE.0)THEN	! not 1st fragment 	      CONTINUE_/ 	    ELSEIF(SLV_IP.PROTOCOL .EQ. 17)THEN		! UDPd' 	      SLV_UDP.BUF=CCVETH_RCVBUF(I:I+7)m$ 	      B_SPORT(0)=SLV_UDP.B_SPORT(1)$ 	      B_SPORT(1)=SLV_UDP.B_SPORT(0)$ 	      B_DPORT(0)=SLV_UDP.B_DPORT(1)$ 	      B_DPORT(1)=SLV_UDP.B_DPORT(0)
 	      I=1, 	      DO WHILE (I.LE.ICPTCP_MAXUDPPRT .AND.'      +			N_SPORT .NE. NCVTCP_UDPPRT(I))S 		I=I+1C 	      ENDDO
 	      J=1, 	      DO WHILE (J.LE.ICPTCP_MAXUDPPRT .AND.'      +			N_DPORT .NE. NCVTCP_UDPPRT(J))( 		J=J+1  	      ENDDO% 	      IF(I.GT.ICPTCP_MAXUDPPRT .AND. #      +		 J.GT.ICPTCP_MAXUDPPRT)THEN)" 		IF(JZEXT(N_SPORT) .LE. 1023)THEN 		  I=-1& 		ELSEIF(JZEXT(N_DPORT) .LE. 1023)THEN 		  J=-1 		ENDIF	 	      ENDIF& 	      IF(I .LE. ICPTCP_MAXUDPPRT)THEN 		I=1E+ 		DO WHILE (I .LE. ICVSTT_NUMUDPPORTS .AND.F0      +			  SLV_UDP.SPORT .NE. NCVSTT_UDPPORT(I))	 		  I=I+1E 		ENDDOE! 		IF(I.LE.ICVSTT_NUMUDPPORTS)THENn# 		  ICVSTT_UDPCNT(I,ICVSTT_BUFNUM)= *      +				ICVSTT_UDPCNT(I,ICVSTT_BUFNUM)+16 		ELSEIF(ICVSTT_NUMUDPPORTS.LT.ICPSTT_MAXUDPPORTS)THEN+ 		  ICVSTT_NUMUDPPORTS=ICVSTT_NUMUDPPORTS+1i 		  I=ICVSTT_NUMUDPPORTS# 		  NCVSTT_UDPPORT(I)=SLV_UDP.SPORTA$ 		  ICVSTT_UDPCNT(I,ICVSTT_BUFNUM)=1 		ENDIFA* 	      ELSEIF(J .LE. ICPTCP_MAXUDPPRT)THEN 		I=1R+ 		DO WHILE (I .LE. ICVSTT_NUMUDPPORTS .AND.I0      +			  SLV_UDP.DPORT .NE. NCVSTT_UDPPORT(I))	 		  I=I+1. 		ENDDO	! 		IF(I.LE.ICVSTT_NUMUDPPORTS)THENC# 		  ICVSTT_UDPCNT(I,ICVSTT_BUFNUM)=C*      +				ICVSTT_UDPCNT(I,ICVSTT_BUFNUM)+16 		ELSEIF(ICVSTT_NUMUDPPORTS.LT.ICPSTT_MAXUDPPORTS)THEN+ 		  ICVSTT_NUMUDPPORTS=ICVSTT_NUMUDPPORTS+1L 		  I=ICVSTT_NUMUDPPORTS# 		  NCVSTT_UDPPORT(I)=SLV_UDP.DPORTV$ 		  ICVSTT_UDPCNT(I,ICVSTT_BUFNUM)=1 		ENDIF' 	      ENDIF- 	    ELSEIF(SLV_IP.PROTOCOL .EQ. 6)THEN	! TCPD( 	      SLV_TCP.BUF=CCVETH_RCVBUF(I:I+19)$ 	      B_SPORT(0)=SLV_TCP.B_SPORT(1)$ 	      B_SPORT(1)=SLV_TCP.B_SPORT(0)$ 	      B_DPORT(0)=SLV_TCP.B_DPORT(1)$ 	      B_DPORT(1)=SLV_TCP.B_DPORT(0)
 	      I=1, 	      DO WHILE (I.LE.ICPTCP_MAXTCPPRT .AND.'      +			N_SPORT .NE. NCVTCP_TCPPRT(I))G 		I=I+1M 	      ENDDO
 	      J=1, 	      DO WHILE (J.LE.ICPTCP_MAXTCPPRT .AND.'      +			N_DPORT .NE. NCVTCP_TCPPRT(J))  		J=J+1L 	      ENDDO% 	      IF(I.GT.ICPTCP_MAXTCPPRT .AND.	#      +		 J.GT.ICPTCP_MAXTCPPRT)THENX 		IF(N_SPORT .LE. 1023)THENI 		  I=-1 		ELSEIF(N_DPORT .LE. 1023)THENM 		  J=-1 		ENDIFI 	      ENDIF& 	      IF(I .LE. ICPTCP_MAXTCPPRT)THEN 		I=1D+ 		DO WHILE (I .LE. ICVSTT_NUMTCPPORTS .AND. 0      +			  SLV_TCP.SPORT .NE. NCVSTT_TCPPORT(I))	 		  I=I+1D 		ENDDOL! 		IF(I.LE.ICVSTT_NUMTCPPORTS)THENH# 		  ICVSTT_TCPCNT(I,ICVSTT_BUFNUM)= *      +				ICVSTT_TCPCNT(I,ICVSTT_BUFNUM)+16 		ELSEIF(ICVSTT_NUMTCPPORTS.LT.ICPSTT_MAXTCPPORTS)THEN+ 		  ICVSTT_NUMTCPPORTS=ICVSTT_NUMTCPPORTS+1t 		  I=ICVSTT_NUMTCPPORTS# 		  NCVSTT_TCPPORT(I)=SLV_TCP.SPORTT$ 		  ICVSTT_TCPCNT(I,ICVSTT_BUFNUM)=1 		ENDIFo* 	      ELSEIF(J .LE. ICPTCP_MAXTCPPRT)THEN 		I=1 + 		DO WHILE (I .LE. ICVSTT_NUMTCPPORTS .AND. 0      +			  SLV_TCP.DPORT .NE. NCVSTT_TCPPORT(I))	 		  I=I+1t 		ENDDOe! 		IF(I.LE.ICVSTT_NUMTCPPORTS)THENa# 		  ICVSTT_TCPCNT(I,ICVSTT_BUFNUM)=E*      +				ICVSTT_TCPCNT(I,ICVSTT_BUFNUM)+16 		ELSEIF(ICVSTT_NUMTCPPORTS.LT.ICPSTT_MAXTCPPORTS)THEN+ 		  ICVSTT_NUMTCPPORTS=ICVSTT_NUMTCPPORTS+1p 		  I=ICVSTT_NUMTCPPORTS# 		  NCVSTT_TCPPORT(I)=SLV_TCP.DPORT $ 		  ICVSTT_TCPCNT(I,ICVSTT_BUFNUM)=1 		ENDIF. 	      ENDIF
 	    ENDIF 	  ENDIF 	  GOTO 9999 C_ CP.  .  END CASE C.  9999	CONTINUE CV
 CP.  ENDIF CI       ENDIF( CA5 CP.  IF tracing enabled and message not rejected THENS CI#       IF(NCVETH_TRACEFLAG.NE.0.AND.L      +	 .NOT.LLV_EXCLUDE)THEN	 C  CP.  .  update trace statistics  C+3 	ICVTRC_BYTES_POST=ICVTRC_BYTES_POST+NCVETH_IOSB(1).$ 	ICVTRC_MSGS_POST=ICVTRC_MSGS_POST+1 CV  CP.  .  write data to trace file CI. 	IF(IAND(NCVETH_TRACEFLAG,NCPETH_TRC_TYPE).EQ.      +			NCPETH_TRCTYP_BIN)THENI$ 	  CALL SYS$GETTIM(QCVETH_TIMESTAMP) 	  NCVETH_LENGTH=NCVETH_IOSB(1)ID 	  SCVTRC_RAB.RAB$W_RSZ=MIN(NCVETH_LENGTH,NCVTRC_MAXRECLEN)+(8+20+2)! 	  ILV_STATUS=SYS$PUT(SCVTRC_RAB)S 	  IF(.NOT.ILV_STATUS)THENA 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS),%VAL(SCVTRC_RAB.RAB$L_STV))R 	  ENDIF2 	ELSEIF(IAND(NCVETH_TRACEFLAG,NCPETH_TRC_TYPE).EQ.!      +			NCPETH_TRCTYP_ASCII)THENC 	  CALL SYS$ASCTIM(,CLV_TIME,,)F 	  IF(LCVETH_IEEE)THEN 	    CLV_SCR(1:1)='i'. 	  ELSEQ 	    CLV_SCR(1:1)=' '  	  ENDIF/ 	  WRITE(70,9000) CLV_TIME, SCVETH_ADDRBUF.SRC, )      +		SCVETH_ADDRBUF.DEST, BCVETH_PROT, $      +		CLV_SCR(1:1), NCVETH_IOSB(1)5  9000	  FORMAT(A23,' s:',Z2.2,5('-',Z2.2),' d:',Z2.2,Q/      +			5('-',Z2.2),' p:',Z2.2,'-',Z2.2,A1,I5)P 	  IF(NCVETH_IOSB(1).GT.0)THENA 	    WRITE(70,9001) (BCVETH_RCVBUF(I),I=1,MIN(NCVETH_IOSB(1),40))N  9001	    FORMAT(40(Z2.2:))G> 	    CALL SYS$FAO('!AF',,CLV_SCR,%VAL(MIN(NCVETH_IOSB(1),40)),      +				%REF(BCVETH_RCVBUF))= 	    WRITE(70,9002) (CLV_SCR(I:I),I=1,MIN(NCVETH_IOSB(1),40))A  9002	    FORMAT(40(X,A1:))I 	  ENDIF2 	ELSEIF(IAND(NCVETH_TRACEFLAG,NCPETH_TRC_TYPE).EQ.#      +			NCPETH_TRCTYP_SNIFFER)THENV 	  IF(NCVETH_HDRSIZE.EQ.14)THEND9 	    WRITE(70) SCVETH_ADDRBUF.CDEST, SCVETH_ADDRBUF.CSRC,A$      +		      SCVETH_ADDRBUF.W_PROT,F      +		      CCVETH_RCVBUF(1:MIN(NCVETH_IOSB(1),NCVTRC_MAXRECLEN-14))# 	  ELSEIF(NCVETH_HDRSIZE.EQ.17)THENa 	    W_PKT_LEN=NCVETH_IOSB(1)a9 	    WRITE(70) SCVETH_ADDRBUF.CDEST, SCVETH_ADDRBUF.CSRC,()      +		      B_PKT_LEN(1), B_PKT_LEN(0), 7      +		      SCVETH_ADDRBUF.DSAP, SCVETH_ADDRBUF.SSAP,A$      +		      SCVETH_ADDRBUF.CTL(0),F      +		      CCVETH_RCVBUF(1:MIN(NCVETH_IOSB(1),NCVTRC_MAXRECLEN-17))# 	  ELSEIF(NCVETH_HDRSIZE.EQ.18)THENF 	    W_PKT_LEN=NCVETH_IOSB(1) 9 	    WRITE(70) SCVETH_ADDRBUF.CDEST, SCVETH_ADDRBUF.CSRC, )      +		      B_PKT_LEN(1), B_PKT_LEN(0),m7      +		      SCVETH_ADDRBUF.DSAP, SCVETH_ADDRBUF.SSAP,O!      +		      SCVETH_ADDRBUF.CTL,9F      +		      CCVETH_RCVBUF(1:MIN(NCVETH_IOSB(1),NCVTRC_MAXRECLEN-18))# 	  ELSEIF(NCVETH_HDRSIZE.EQ.22)THENN 	    W_PKT_LEN=NCVETH_IOSB(1)(9 	    WRITE(70) SCVETH_ADDRBUF.CDEST, SCVETH_ADDRBUF.CSRC,	)      +		      B_PKT_LEN(1), B_PKT_LEN(0),A7      +		      SCVETH_ADDRBUF.DSAP, SCVETH_ADDRBUF.SSAP,N6      +		      SCVETH_ADDRBUF.ECTL, SCVETH_ADDRBUF.PID,F      +		      CCVETH_RCVBUF(1:MIN(NCVETH_IOSB(1),NCVTRC_MAXRECLEN-22)) 	  ENDIF2 	ELSEIF(IAND(NCVETH_TRACEFLAG,NCPETH_TRC_TYPE).EQ.$      +			NCPETH_TRCTYP_ANALYZER)THEN$ 	  CALL SYS$GETTIM(QCVETH_TIMESTAMP) 	  NCVETH_LENGTH=NCVETH_IOSB(1)'< 	  CALL SYS$SETRWM(%VAL(1))	! don't let mbx jam up operation3 	  ILV_STATUS=SYS$QIOW(%VAL(0),		! use scratch EF#,V>      +			      %VAL(NCVTRC_DATAMBXCHN), ! specify mbx channel,@      +			      %VAL(IO$_WRITEVBLK+IO$M_NOW), ! specify send now,5      +			      NLV_IOSB,,,	! specify I/O status area, =      +			      QCVETH_TIMESTAMP,	! specify buffer start addr,-8      +			      %VAL(MIN(NCVETH_LENGTH,NCVTRC_MAXRECLEN)+,      +						(8+20+2)),,,,) ! specify length./ 	  CALL SYS$SETRWM(%VAL(0))	! go back to normal_# 	  IF(ILV_STATUS.EQ.SS$_MBFULL)THENe, 	    ICVTRC_MSGS_MBFULL=ICVTRC_MSGS_MBFULL+1 	  ELSEIF(.NOT.ILV_STATUS)THEN6 	    CALL LIB$SIGNAL(ETH__ERRQWRMBX,,%VAL(ILV_STATUS))( 	  ELSEIF(NLV_IOSB(0).EQ.SS$_MBFULL)THEN, 	    ICVTRC_MSGS_MBFULL=ICVTRC_MSGS_MBFULL+1 	  ELSEIF(.NOT.NLV_IOSB(0))THENL7 	    CALL LIB$SIGNAL(ETH__ERRCWRMBX,,%VAL(NLV_IOSB(0)))E 	  ENDIF 	ENDIF C 
 CP.  ENDIF CM       ENDIFC CR CP.  RETURNL CI       RETURN CS CP END ETHER_READ_ CC	       ENDS