 #ifdef VAXC   #module CHKITM "BOL-V1.0/OCT-95" #else ' #pragma module CHKITM "BOL-V1.0/OCT-95"  #endif  C /* This routine processes the input item list (which corresponds to A    the qualifiers given at the Username: prompt) and performs the     required checks.   ;    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at) */   3 #include descrip		/* Definitions for descriptors */ 2 #include iacdef			/* Flags for image activation */+ #include ssdef			/* SS$_xxx status codes */ 1 #include starlet		/* SYS$xxx() system services */ * #include string			/* strxxx() functions */6 #include uaidef			/* UAI$M_xxx item codes and flags */  @ #include "chklgidef.h"		/* CHKLGI$_xxx login source constants */@ #include "lgibufdef.h"		/* LGIBUF structure field definitions */9 #include "lgimsgdef.h"		/* LGI$_xxx login status codes */ < #include "compdepnd.h"		/* Compiler-dependend definitions */  $ typedef struct dsc$descriptor_s dsc;   /*** Aux routine ***/    static int activate(int,dsc*);   /***  ***/    /*** CHKITM() ***/ /*** ======== ***/   /* Input arguments:   !  lgi:		login buffer, by reference &  initm:		input item list, by reference       Return codes:   	SS$_NORMAL:	validation ok  9 	SS$_BADPARAM:	invalid item code or string value too long   8 	LGI$_CAPTIVE:	no qualifiers allowed in captive accounts  3 	LGI$_CLIFAIL:	error activating command interpreter   = 	LGI$_CLITBLFAIL: error activating command interpreter tables   4 	LGI$_DEFCLI:	CLI-related qualifiers are not allowed  + 	LGI$_DISRECONNEC: no reconnections allowed   > 	Note that error codes returned by SYS$IMGACT are converted to0 	LGI$_CLIFAIL and LGI$_CLITBLFAIL, respectively.    7 	NOTE: THE IMAGE ACTIVATION SYSTEM SERVICE USED IN THIS 8 	      MODULE IS NOT SUPPORTED AND DOCUMENTED OFFICIALY. 	      USE IT ON YOUR OWN RISK.   */  F int chkitm(struct LGIBUF* lgi,	/* Buffer containing UAF information */ 	   void* initm) {   char *  clibuf[40],					/* Buffer for CLI name */0  tabbuf[40];					/* Buffer for CLI table name */    int  length,					/* Length field */    status;					/* Return status */  7  $DESCRIPTOR(clidsc,clibuf);			/* Descriptor for CLI */ =  $DESCRIPTOR(tabdsc,tabbuf);			/* Descriptor for CLI table */   5  struct itmlst *itmptr;				/* Pointer to item list */   6  /* Init CLI table name buffer (required for later) */     tabbuf[0] = '\0';   ;  /* Copy CLI name from UAF record, if it was found therein. '     Otherwise, use "DCL" as default. */   3  if (strlen(lgi->T_CLI)) strcpy(clibuf,lgi->T_CLI);     else strcpy(clibuf,"DCL");   '  /* Copy the CLI table name as well. */   9  if (strlen(lgi->T_CLITAB)) strcpy(tabbuf,lgi->T_CLITAB);   6  /* Process item list. Place pointer to first item. */  !  itmptr = (struct itmlst*) initm;   F  /* Scan the item list and call the approbiate routine. If 'code' = 0,D     the end of the list is reached, so return. This is also true, if#     an error status is returned. */     while(itmptr->code)  {   switch(itmptr->code)   {     case CHKLGI$_CLI:    {A     /* This emulates the /CLI= qualifier on the command line. The C       account must not have the RESTRICTED or CAPTIVE flags set. */   H     if (lgi->L_FLAGS & UAI$M_CAPTIVE || lgi->L_FLAGS & UAI$M_RESTRICTED)     return LGI$_CAPTIVE;  B     /* In addition, CLI-related qualifiers aren't allowed when the        DEFCLI flag is set. */   8     if (lgi->L_FLAGS & UAI$M_DEFCLI) return LGI$_DEFCLI;  5     /* The CLI name must not exceed 39 characters. */   C     if (itmptr->size < 0 || itmptr->size > 39) return SS$_BADPARAM;   "     /* Overwrite default value. */  5     strncpy(clibuf,(char*)itmptr->info,itmptr->size);         clibuf[itmptr->size] = '\0';  
     break;    }    case CHKLGI$_TABLES:     {*     /* Well, thats the same as for CLI. */  H     if (lgi->L_FLAGS & UAI$M_CAPTIVE || lgi->L_FLAGS & UAI$M_RESTRICTED)     return LGI$_CAPTIVE;  8     if (lgi->L_FLAGS & UAI$M_DEFCLI) return LGI$_DEFCLI;  C     if (itmptr->size < 0 || itmptr->size > 39) return SS$_BADPARAM;   $     /* Update the CLI table name. */  5     strncpy(tabbuf,(char*)itmptr->info,itmptr->size);         tabbuf[itmptr->size] = '\0';  
     break;    }    case CHKLGI$_COMMAND:    case CHKLGI$_DISK:     {G     /* These items only simulate the usage of the /COMMAND=, /NOCOMMAND D        and /DISK= qualifiers. They are allowed unless the CAPTIVE or#        RESTRICTED flags are set. */   H     if (lgi->L_FLAGS & UAI$M_CAPTIVE || lgi->L_FLAGS & UAI$M_RESTRICTED)     return LGI$_CAPTIVE;  
     break;    }    case CHKLGI$_CONNECT:    {G     /* This item emulates the usage of /CONNECT. This is allowed unless 5        CAPTIVE, RESTRICTED or DISRECONNECT is set. */   H     if (lgi->L_FLAGS & UAI$M_CAPTIVE || lgi->L_FLAGS & UAI$M_RESTRICTED)     return LGI$_CAPTIVE;  8     /* Return a specific error code for DISRECONNECT. */  D     if (lgi->L_FLAGS & UAI$M_DISRECONNECT) return LGI$_DISRECONNECT;  
     break;    }    default:     {)     /* Any other item code is invalid. */        return SS$_BADPARAM;    }   } -   /* Point to next item code and continue. */      itmptr++;   }E  /* The item list was processed completely here. The only thing we've H     to do here is to activate the specified or obtain CLI and CLI table.F     If the user has disabled this check, we can return immediately. */  ?  if (!(lgi->L_IFLAGS & CHKLGI$M_DO_CLI_CHK)) return SS$_NORMAL;   $  /* Update CLI descriptor length. */   &  clidsc.dsc$w_length = strlen(clibuf);  G  /* If no CLI table name was given, use 'cli_name'TABLES as default. */     if (!strlen(tabbuf))   {   strcpy(tabbuf,clibuf);     strcat(tabbuf,"TABLES");  }&  tabdsc.dsc$w_length = strlen(tabbuf);  B  /* Now try to activate the CLI and CLI table. If an error occurs,3     convert it to the approbiate LGI error code. */   G  if ((status = activate(1,&clidsc)) != SS$_NORMAL) return LGI$_CLIFAIL;   J  if ((status = activate(2,&tabdsc)) != SS$_NORMAL) return LGI$_CLITBLFAIL;    /* All done, return. */    return SS$_NORMAL;  }    /***  ***/   ( static int activate(int typ,dsc* imgnam) { =  /* Activates the given CLI (typ = 1) or CLI table (typ = 2).     Input arguments:   2  typ:           CLI (1) or CLI table (2), by value"  imgnam:	image name, by descriptor    Return codes:   	SS$_NORMAL:	validation ok  3 	LGI$_CLIFAIL:	error activating command interpreter   = 	LGI$_CLITBLFAIL: error activating command interpreter tables   ? 	Note that all error codes returned by SYS$IMGACT are converted 3 	to LGI$_CLIFAIL and LGI$_CLITBLFAIL, respectively.   */     char 6  hdrbuf[1024],				/* Buffer to receive image header */;  defnam1[] = "SYS$SYSTEM:.EXE",		/* Default spec for CLI */ @  defnam2[] = "SYS$SHARE:.EXE";		/* Default spec for CLI table */    int  status,				/* Return status */ &  flags,					/* Flags for activation */3  inadr[2] = {0,0},			/* Input address (P0 space) */ #  retadr[2];				/* Return address */   H  $DESCRIPTOR (defdsc, defnam1);		/* CLI/CLI table default spec descr. */    /* Initialize flags. */  @  flags = IAC$M_NOACT|IAC$M_SHAREABLE|IAC$M_EXPREG|IAC$M_P1MERGE;  (  /* Setup correct default image spec. */    if (typ == 2)  {!   defdsc.dsc$a_pointer = defnam2;   *   defdsc.dsc$w_length = strlen(defnam2);    }  /* Activate given image. */  C  status = sys$imgact(imgnam,&defdsc,hdrbuf,flags,inadr,retadr,0,0);    1  /* If not success, return LGI-specific error. */   N  if (status != SS$_NORMAL) status = typ == 1 ? LGI$_CLIFAIL : LGI$_CLITBLFAIL;    return status;  } 