 #ifdef VAXC   #module CHKTIM "BOL-V1.0/OCT-95" #else ' #pragma module CHKTIM "BOL-V1.0/OCT-95"  #endif  D /* This routine validates login days, login times and login sources.  ;    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at) */   1 #include lib$routines		/* LIB$xxx RTL routines */ . #include libdef			/* LIB$_xxxx status codes */8 #include libdtdef		/* LIB$K_xxx date/time definitions */2 #include ssdef			/* SS$_xxx system status codes */  @ #include "chklgidef.h"		/* CHKLGI$_xxx login source constants */@ #include "lgibufdef.h"		/* LGIBUF structure field definitions */9 #include "lgimsgdef.h"		/* LGI$_xxx login status codes */ = #include "compdepnd.h"		/* Compiler-dependend declarations */   A #define EXE$M_EXPLICITP 0x00080000	/* SET DAY/PRIMARY was done */ C #define EXE$M_EXPLICITS 0x00040000	/* SET DAY/SECONDARY was done */    /***  ***/    /*** CHKTIM() ***/ /*** ======== ***/   /* Input arguments:   /  lday:  Login day, by value (0 = not specified)      ltim:  Login time, by reference  D  lgi:   Login buffer containing additional information. By reference      Returns codes:   " 	SS$_NORMAL:    time validation ok  - 	LGI$_BADHOUR:  no login allowed at this time   , 	LGI$_BADDAY:   no login allowed at this day  1 	LGI$_RESTRICT: no login allowed from this source   " 	Any other error code returned by:  > 	o - RTL Routines: LIB$CVT_FROM_INTERNAL_TIME, LIB$DAY_OF_WEEK 	   */  % int chktim(int lday,		/* Login day */ ! 	   int* ltim,		/* Binary time */ ? 	   struct LGIBUF* lgi)	/* Buffer containing UAF information */  {   int  status,		/* Return status */   typ,			/* Login type */  day,			/* Login day */   hour,			/* Hour of day */  tmp,			/* Auxiliary value */ %  s_day,			/* 1 if sec. day, else 0 */ $  h_fld;			/* Login hour bit field */  A  /* These checks are entirely bypassed for detached processes. */   :  if (lgi->L_LGISRC == CHKLGI$_DETACHED) return SS$_NORMAL;  2  /* Handle DECwindows logins like local logins. */  K  typ = lgi->L_LGISRC == CHKLGI$_DECWINDOWS ? CHKLGI$_LOCAL : lgi->L_LGISRC;   +  /* Get login day. If specified, use it. */     if (lday) day = lday;  <  /* Otherwise, use given time to compute the current day. */  M  else if ((status = lib$day_of_week(ltim,&day)) != SS$_NORMAL) return status;     /* Get current hour. */  D  status = lib$cvt_from_internal_time(&LIB$K_HOUR_OF_DAY,&hour,ltim);  *  if (status != LIB$_NORMAL) return status;  A  /* Determine whether today is a primary or secondary day. If the B     operator has established this manually (SET DAY command), this$     overrides any setups in the UAF.  H     The system marks this by setting bit EXE$M_EXPLICITP in EXE$GL_FLAGS:     and, if SET DAY/SECONDARY was issued, also setting bit     EXE$M_EXPLICITS. */   $  if (EXE$GL_FLAGS & EXE$M_EXPLICITP)  {0   if (EXE$GL_FLAGS & EXE$M_EXPLICITS) s_day = 1;     else s_day = 0;   }  else   {J   /* Obtain this information from UAF. Convert day number to bit value. */          tmp = 1 << (day-1);   H   /* If the approbiate bit isn't set in the day vector (UAI$_PRIMEDAYS),6      it's a primary day, else it's a secondary day. */  '   if (tmp & lgi->L_PRIMDAYS) s_day = 1;      else s_day = 0;   }H  /* Select the required login bit field. They were stored by getusrnam()4     in the following order in an array of longwords:       0: network, primary      1: network, secondary      2: batch, primary      3: batch, secondary      4: local, primary      5: local, secondary      6: dialup, primary     7: dialup, secondary     8: remote, primary,      9: remote, secondary  E     This allows us easily to obtain the approbiate field by computing 3     the index in the array: (typ*2) - 2 + s_day. */     tmp = typ*2 - 2;   "  h_fld = lgi->L_ACCESS[tmp+s_day];  B  /* Now check for login source, day and time. Note that the caller+     can disable one or all of these checks.   <     If the bit field is 0, there is no login restriction. */    if (!h_fld) return SS$_NORMAL;   B  /* A value of 0x00FFFFFF means that the login is disabled for theB     entire day. If _both_ vectors (primary and secondary day) haveA     this value, the login is disabled for the given source and we 2     must return LGI$_RESTRICT to indicate this. */  G  if (!(lgi->L_IFLAGS & CHKLGI$M_SKP_SRC_CHK))		/* Skip if suppressed */   {)   if (lgi->L_ACCESS[tmp] == 0x00FFFFFF && ?       lgi->L_ACCESS[tmp+1] == 0x00FFFFFF) return LGI$_RESTRICT;   }@  /* If the current vector has the value 0x00FFFFFF, the login is&     entirely disabled on given day. */  G  if (!(lgi->L_IFLAGS & CHKLGI$M_SKP_DAY_CHK))		/* Skip if suppressed */   {.   if (h_fld == 0x00FFFFFF) return LGI$_BADDAY;  }:  /* Check whether the login is disabled at the given hour.  9     If necessary, shift the access bits. We always want a      value beetween 0 and 7. */  )  if (hour > 15)			/* For 16:00 - 23:00 */   {   h_fld = h_fld >> 16;     hour = hour - 16;   }'  if (hour > 7)			/* For 8:00 - 15:00 */   {   h_fld = h_fld >> 8;      hour = hour - 8;  }"  /* Compute the right hour bit. */    tmp = 1 << hour;   B  /* If the correspondig bit is set, access is denied for the hour.1     If the user requested it, skip this check. */   .  if (!(lgi->L_IFLAGS & CHKLGI$M_SKP_HOUR_CHK))  {'   if (tmp & h_fld) return LGI$_BADHOUR;   }  /* All done. */    return SS$_NORMAL;  } 