 [ CHECK(ALL),  IDENT('V0.1'),   INHERIT(     'SYS$LIBRARY:STARLET.PEN',*     'SYS$LIBRARY:PASCAL$LIB_ROUTINES.PEN',*     'SYS$LIBRARY:PASCAL$SMG_ROUTINES.PEN',     'VMS_TYPES.PEN',      'PASCAL_LBR_ROUTINES.PEN') ]   PROGRAM newhelp(input, output);     {+6 COMPONENT: NEWHELP -- Screen Oriented VMS Help Utility    PROGRAM DESCRIPTION:   :     A screen-oriented replacement for the VMS HELP command    AUTHORS:   2     George Merriman, Cambridge Computer Associates    CREATION DATE: 11-OCT-1991    DESIGN ISSUES:   C     This program uses an SMG window to provide scrolling help text  D     from the system help library. It works very much like the normalG     VMS help command, but does not support any command line qualifiers. H     Prev-Screen and Next-Screen scroll through the text. PF1-Prev-ScreenA     and PF1-Next-Screen scroll to the top and bottom of the text. K     The command line prompt is a little different from that in the standard I     HELP command, but is easy to use with command line editing. Broadcast B     message are trapped and displayed on the bottom of the screen.  ?     NEWHELP must be defined as a foreign command. A DCL command C     similar to the following will replace the standard HELp command      with NEWHELP:     	$ h*elp :== $<directory>NEWHELP  F     This program was written as an exercise in SMG and Pascal and was F     prompted to some extent by a request on DECUServe. In addition to F     this file, it requires two Pascal environment files: VMS_TYPES.PENG     and PASCAL_LBR_ROUTINES.PEN as compiled from the corresponding .PAS G     files. It also uses the standard DEC-supplied VMS environment files F     STARLET.PEN, PASCAL$SMG_ROUTINES.PEN and PASCAL$LIB_ROUTINES.PEN. E     The DCL command procedure NEWHELP_BUILD.COM will compile and link      the program.       VERSION:        V1.0    MODIFICATION HISTORY:    %      Date     |   Name  | Description P --------------+---------+-------------------------------------------------------G     10/15/92	Baron Chandler	Improved to allow additional help libraries     -}       CONST      HELP_ROWS	= 200;     CNTRL_W	= 23;      CNTRL_Z	= 26;        OB_MASK	= 2**CNTRL_W;    TYPE2     chr_array	    = PACKED ARRAY [1..256] OF CHAR;!     chr_array_ptr   = ^chr_array;      ob_rec	= RECORD  		    pbrd_id : vms_ulong; 		    arg	    : vms_ulong; 		    char    : vms_ubyte; 		  END;         key_string  = STRING(80); .     libraryarray= ARRAY [1..40] of key_string;,     key_array	= ARRAY [1..10] OF key_string;     long_str	= STRING(255);    VAR 8     pbrd	    : [VOLATILE] vms_ulong;	{ the pasteboard } @     kvdsp 	    : [VOLATILE] vms_ulong;	{ the keys help display }B     hvdsp	    : [VOLATILE] vms_ulong;	{ the main virtual display }E     cvdsp	    : [VOLATILE] vms_ulong;	{ the command virtual display } >     libdsp	    : [VOLATILE] vms_ulong;	{ the library display }C     bvdsp	    : [VOLATILE] vms_ulong;	{ the bdcst virtual display } =     kbrd	    : [VOLATILE] vms_ulong;	{ the virtual keyboard } +     vprt	    : vms_ulong;		{ the viewport } 7     vprt_size	    : integer;			{ size of the viewport } F     text_end	    : [VOLATILE] integer;	{ last row of text in display }4     scroll_count    : integer;			{ rows per scroll }<     cur_vprt_pos    : integer;			{ current scroll position }  9     pbrd_rows	    : [VOLATILE] vms_long;	{ display rows } 3     pbrd_cols	    : vms_long;			{ display columns }   8     in_line	    : PACKED ARRAY [1..256]	{ input string } 			OF CHAR; 3     in_length	    : vms_uword;		{ length of above } 1     out_line	    : STRING(80);		{ output string }   8     keys	    : key_array VALUE ZERO;	{ help topic keys }B     old_keys	    : key_array VALUE ZERO;	{ saved help topic keys }/     key_count	    : 0..10;			{ number of keys }   7     b_str	    : VARYING [255]		{ initial topic string }  			OF CHAR; <     k_index	    : integer;			{ index into the command line }4     term_code	    : vms_uword;		{ termination code }  (     ktbl	    : vms_ulong;		{ key table }-     r_stat	    : integer;			{ return status }   =     gold_state	    : BOOLEAN;			{ holds keyboard GOLD state }   6     lib_index	    : vms_ulong;		{ help library index }  E     error_msg	    : [VOLATILE] boolean	{ True error message showing }  			    := False;       same_key	    : boolean;   #     { used to pass get_help flags } '     more_help	    : [VOLATILE] boolean; %     bad_key	    : [VOLATILE] boolean;        PROCEDURE check_stat(  	msg		: STRING;  	code		: INTEGER 	);    {+   FUNCTIONAL DESCRIPTION:    7     Check_stat is a general-purpose VMS status checker.     FORMAL PARAMETERS:       msg: 3        message to issue to the terminal before exit          code:#        the VMS status code to check       
 SIDE EFFECTS:    *     Image exit if the status code is even.    -}   BEGIN    IF NOT ODD(code) THEN 	     BEGIN      WRITELN(msg);      $EXIT(code)      END  END; { check_stat }        [ASYNCHRONOUS, UNBOUND]  PROCEDURE bdcst_ast;   {+ FUNCTIONAL DESCRIPTION:    A     Bdcst_ast traps VMS broadcast messages and writes them to the      message window    FORMAL PARAMETERS:       None    
 SIDE EFFECTS:         Image exit on error.    IMPLICIT INPUT PARAMETERS:   H     The SMG context identifiers for the pasteboard and broadcast display    -}   VAR      msg_stat	: integer;      sys_stat	: integer; .     bdcst_msg	: PACKED ARRAY [1..256] OF CHAR;     bdcst_len	: vms_uword;     out_line	: STRING(256);    BEGIN     O { cancel current input operation, if any. This is because the cursor position } 4 { gets screwed up and we want to re-issue the read }# sys_stat := smg$cancel_input(kbrd);  if not odd(sys_stat) then      lib$signal(sys_stat);    msg_stat := 1;  # WHILE msg_stat <> SMG$_NO_MORMSG DO 	     BEGIN +     msg_stat := smg$get_broadcast_message (  		    pasteboard_id := pbrd, 		    message := bdcst_msg, # 		    message_length := bdcst_len);      IF NOT ODD(msg_stat) THEN  	lib$signal(msg_stat);  &     if msg_stat <> SMG$_NO_MORMSG then 	begin- 	out_line := SUBSTR(bdcst_msg, 1, bdcst_len);  	  	sys_stat := smg$put_chars ( 			display_id := bvdsp,  			text   := out_line, 			start_row := 1, 			start_column := 1,  			flags := SMG$M_ERASE_LINE); 	IF NOT ODD(sys_stat) THEN 	    lib$signal(sys_stat)          end      END;   error_msg := False   END; { bdcst_ast }      J { This is a trick to keep the compiler from generating a warning message }/ { There MUST be a better way of handling this } - [EXTERNAL( X_OB_AST ), ASYNCHRONOUS, UNBOUND]  PROCEDURE ob_ast; external;     [ASYNCHRONOUS, UNBOUND, GLOBAL] # PROCEDURE X_OB_AST(param : ob_rec);    {+ FUNCTIONAL DESCRIPTION:    C     x_ob_ast (alias ob_ast) traps out-of-band character interrupts.     FORMAL PARAMETERS:   	    param: ! 	the out-of-band interrupt record    
 RETURN VALUE:         NONE   
 SIDE EFFECTS:         Image exit on control-Z     DESIGN:    G     Two out-of-band control characters are processed: Control-Z causes  .     image exit; control-W repaints the screen.    IMPLICIT INPUT PARAMETERS:   %     The pasteboard context identifier     IMPLICIT OUTPUT PARAMETERS:         %[description_or_none]%     %[logical_properties]%    %[optional_routine_tags]%  -} VAR      sys_stat	: integer;    BEGIN   O { cancel current input operation, if any. This is because the cursor position } 4 { gets screwed up and we want to re-issue the read }# sys_stat := smg$cancel_input(kbrd);  if not odd(sys_stat) then      lib$signal(sys_stat);    IF param.char = CNTRL_W THEN	     BEGIN $     sys_stat := smg$repaint_screen (+                     pasteboard_id := pbrd);      IF NOT ODD(sys_stat) THEN  	lib$signal(sys_stat)      END    END; { ob_ast }        PROCEDURE set_screen;    {+ FUNCTIONAL DESCRIPTION:    >     Set_screen creates and initializes all of the SMG objects.    FORMAL PARAMETERS:       None    
 RETURN VALUE:         NONE   
 SIDE EFFECTS:         %[description_or_none]%     DESIGN:         %[description_or_none]%     IMPLICIT INPUT PARAMETERS:        The SMG context identifiers     IMPLICIT OUTPUT PARAMETERS:         The SMG context identifiers     %[logical_properties]%    %[optional_routine_tags]%  -}   VAR      sys_stat	    : integer;    BEGIN   # sys_stat := smg$create_pasteboard (      pasteboard_id := pbrd,+     number_of_pasteboard_rows := pbrd_rows, /     number_of_pasteboard_columns := pbrd_cols); 2 check_stat('$CREATE_PASTEBOARD failed', sys_stat); vprt_size := pbrd_rows - 3;   ) sys_stat := smg$create_virtual_keyboard ( $                 keyboard_id := kbrd, 		recall_size := 0);8 check_stat('$CREATE_VIRTUAL_KEYBOARD failed', sys_stat);   { create main help display }( sys_stat := smg$create_virtual_display (,                 number_of_rows := HELP_ROWS,/                 number_of_columns := pbrd_cols, %                 display_id := hvdsp); H check_stat('$CREATE_VIRTUAL_DISPLAY for main display failed', sys_stat);   { create command display }( sys_stat := smg$create_virtual_display ( 		display_attributes := & 		    SMG$M_BORDER + SMG$M_TRUNC_ICON,$                 number_of_rows := 1,/                 number_of_columns := pbrd_cols, %                 display_id := cvdsp); K check_stat('$CREATE_VIRTUAL_DISPLAY for command display failed', sys_stat);    { create broadcast display }( sys_stat := smg$create_virtual_display () 		display_attributes := SMG$M_TRUNC_ICON, $                 number_of_rows := 1,/                 number_of_columns := pbrd_cols, %                 display_id := bvdsp); M check_stat('$CREATE_VIRTUAL_DISPLAY for broadcast display failed', sys_stat);   ! sys_stat := smg$create_viewport ( $                 display_id := hvdsp,(                 viewport_row_start := 1,+                 viewport_column_start := 1, 2                 viewport_number_rows := vprt_size,6                 viewport_number_columns := pbrd_cols);0 check_stat('$CREATE_VIEWPORT failed', sys_stat);   { paste main display }' sys_stat := smg$paste_virtual_display ( $                 display_id := hvdsp,&                 pasteboard_id := pbrd,$                 pasteboard_row := 1,(                 pasteboard_column := 1);G check_stat('$PASTE_VIRTUAL_DISPLAY for main display failed', sys_stat);    { paste command display } ' sys_stat := smg$paste_virtual_display ( $                 display_id := cvdsp,&                 pasteboard_id := pbrd,0                 pasteboard_row := pbrd_rows - 1,(                 pasteboard_column := 1);J check_stat('$PASTE_VIRTUAL_DISPLAY for command display failed', sys_stat);     { paste broadcast display } ' sys_stat := smg$paste_virtual_display ( $                 display_id := bvdsp,&                 pasteboard_id := pbrd,,                 pasteboard_row := pbrd_rows,(                 pasteboard_column := 1);L check_stat('$PASTE_VIRTUAL_DISPLAY for broadcast display failed', sys_stat);  & sys_stat := smg$set_out_of_band_asts (&                 pasteboard_id := pbrd,9                 control_character_mask := OB_MASK, { ^W } '                 ast_routine := ob_ast); 4 check_stat('$SET_OUT_OF_BAND_AST failed', sys_stat);  ( sys_stat := smg$set_broadcast_trapping (&                 pasteboard_id := pbrd,*                 ast_routine := bdcst_ast);7 check_stat('$SET_BROADCAST_TRAPPING failed', sys_stat);   " sys_stat := smg$create_key_table (&                 key_table_id := ktbl);1 check_stat('$CREATE_KEY_TABLE failed', sys_stat);      sys_stat := smg$add_key_def (  		key_table_id := ktbl,  		key_name := 'HELP', % 		attributes := SMG$M_KEY_TERMINATE); 5 check_stat('$ADD_KEY_DEF for HELP failed', sys_stat);    sys_stat := smg$add_key_def ( %                 key_table_id := ktbl, "                 key_name := 'PF2',                 attributes :=  		    SMG$M_KEY_TERMINATE); 4 check_stat('$ADD_KEY_DEF for PF2 failed', sys_stat);     sys_stat := smg$add_key_def ( %                 key_table_id := ktbl, %                 key_name := 'SELECT',                  attributes :=  		    SMG$M_KEY_TERMINATE); 7 check_stat('$ADD_KEY_DEF for SELECT failed', sys_stat);    sys_stat := smg$add_key_def ( %                 key_table_id := ktbl, "                 key_name := 'PF1',                 attributes :=  		    SMG$M_KEY_TERMINATE); 5 check_stat('$ADD_KEY_DEF for GOLD failed', sys_stat);    sys_stat := smg$add_key_def ( %                 key_table_id := ktbl, *                 key_name := 'PREV_SCREEN',3                 attributes := SMG$M_KEY_TERMINATE); < check_stat('$ADD_KEY_DEF for PREV_SCREEN failed', sys_stat);   sys_stat := smg$add_key_def ( %                 key_table_id := ktbl, *                 key_name := 'NEXT_SCREEN',3                 attributes := SMG$M_KEY_TERMINATE); < check_stat('$ADD_KEY_DEF for NEXT_SCREEN failed', sys_stat);   sys_stat := smg$add_key_def ( %                 key_table_id := ktbl,                   key_name := '?',3                 attributes := SMG$M_KEY_TERMINATE); 6 check_stat('$ADD_KEY_DEF for ''?'' failed', sys_stat);   scroll_count := vprt_size - 2; cur_vprt_pos := 1;
 text_end := 1    END; { set_screen }       0 PROCEDURE scroll_display (term_code: vms_ulong);   {+ FUNCTIONAL DESCRIPTION:    9     Scroll_display scrolls the terminal window up or down     FORMAL PARAMETERS:   
    term_code: ?        the character code for the key used to request scrolling     %[more_subtags]%...   
 RETURN VALUE:         NONE   
 SIDE EFFECTS:         %[description_or_none]%     DESIGN:    A     The display is scrolled up and down with the Next-Screen and  E     Previous-Screen keys. If used with PF1 (the GOLD key) the display 5     is scrolled to the top or bottom of the display.      IMPLICIT INPUT PARAMETERS:   .     The help display ident and state variables    IMPLICIT OUTPUT PARAMETERS:    .     The help display ident and state variables    %[logical_properties]%    %[optional_routine_tags]%  -}  9 { local procedure to scroll the display in the viewport } 3 PROCEDURE scroll(dir : vms_ulong; lines: vms_long);      VAR  	sys_stat    : integer;   	     BEGIN %     sys_stat := smg$scroll_viewport (  		    display_id := hvdsp, 		    direction := dir,  		    count  := lines); 3     check_stat('$SCROLL_VIEWPORT failed', sys_stat)      END;  D { local procedure to set the viewport to a position in the display } PROCEDURE change(top: integer);      VAR  	sys_stat    : integer;   	     BEGIN %     sys_stat := smg$change_viewport ( (                     display_id := hvdsp,.                     viewport_row_start := top,/                     viewport_column_start := 1, :                     viewport_number_rows := pbrd_rows - 3,:                     viewport_number_columns := pbrd_cols);4     check_stat('$CHANGE_VIEWPORT failed', sys_stat);     END;   BEGIN { scroll_display }      & IF (term_code = SMG$K_TRM_PREV_SCREEN) 	AND (NOT gold_state) THEN	     BEGIN 0     cur_vprt_pos := cur_vprt_pos - scroll_count;     IF cur_vprt_pos >= 1 THEN  	BEGIN! 	scroll(SMG$M_DOWN, scroll_count)  	END     ELSE 	BEGIN 	change(1);  	cur_vprt_pos := 1 	END     END + ELSE IF (term_code = SMG$K_TRM_PREV_SCREEN)  	AND gold_state THEN	     BEGIN      change(1);     cur_vprt_pos := 1;     gold_state := FALSE      END      + ELSE IF (term_code = SMG$K_TRM_NEXT_SCREEN)  	AND (NOT gold_state) THEN	     BEGIN 0     cur_vprt_pos := cur_vprt_pos + scroll_count;6     IF cur_vprt_pos <= (text_end - vprt_size + 1) THEN 	BEGIN 	scroll(SMG$M_UP, scroll_count)  	END     ELSE 	BEGIN;         cur_vprt_pos := max((text_end - vprt_size + 1), 1);  	change(cur_vprt_pos)  	END     END + ELSE IF (term_code = SMG$K_TRM_NEXT_SCREEN)  	AND gold_state THEN	     BEGIN 7     cur_vprt_pos := max((text_end - vprt_size + 1), 1);      change(cur_vprt_pos);      gold_state := FALSE      END & ELSE IF term_code = SMG$K_TRM_PF1 THEN	     BEGIN       gold_state := NOT gold_state     END    END; { scroll_display }       ' PROCEDURE parse_topics(str : long_str);    {+ FUNCTIONAL DESCRIPTION:    E     Parse_topics parses the command line into the topic keyword array     FORMAL PARAMETERS:       str: $        the command line to be parsed    %[more_subtags]%...   
 RETURN VALUE:         NONE   
 SIDE EFFECTS:         %[description_or_none]%,    DESIGN:         %[description_or_none]%   S IMPLICIT INPUT PARAMETERS:  P     %[description_or_none]%$  _ IMPLICIT OUTPUT PARAMETERS:S  N	     keys:S 	the topic keyword array     key_count: 	the count of active keys   P %[logical_properties]%  i %[optional_routine_tags]%  -}   VARC>     k_start	: integer;	    { position of key in command line }2     k_len	: integer;	    { length of current key }<     in_white	: BOOLEAN;	    { used in parsing command line }#     in_key	: BOOLEAN;	    { ditto }m  1 { procedure to add a key to the topic key array }  PROCEDURE get_key;     	     BEGINw     IF k_len > 0 THEN  	BEGIN 	in_key := False;d 	key_count := key_count + 1;0 	keys[key_count] := SUBSTR(str, k_start, k_len); 	k_len := 0t 	END     END;   BEGIN { parse_topics }  " { initialize the topic key array } FOR k_index := 1 TO 10 DOh     keys[k_index] := ZERO;      in_white := True;  in_key := FALSE; key_count := 0; 
 k_index := 1;u k_len := 0;n  " { first parse out the topic keys } WHILE (k_index <= LENGTH(str)) 	AND (key_count < 10) DO	     BEGINL!     IF (str[k_index] <= ' ') THENa 	BEGIN 	IF in_key THENi
 	    BEGIN 	    get_key	 	    END;h 	in_white := Truem 	END#     ELSE IF str[k_index] = '/' THENd 	BEGIN 	IF in_key THENh
 	    BEGIN 	    get_key	 	    END;  	k_start := k_index; 	k_len := 1; 	in_white := False;y 	in_key := TrueU 	END     ELSE IF in_white THENf 	BEGIN 	k_start := k_index; 	k_len := 1; 	in_white := False;  	in_key := TrueU 	END     ELSE 	BEGIN 	k_len := k_len + 1; 	in_key := TrueI 	END;u     k_index := k_index + 1;      END;   get_key;     END; { parse_topics }M   T  # { trick to prevent compiler error } 2 [ASYNCHRONOUS, UNBOUND, EXTERNAL(x_help_routine)] ) FUNCTION help_routine:vms_long; EXTERNAL;   9 [ASYNCHRONOUS, UNBOUND, GLOBAL] FUNCTION x_help_routine (D*         txt_string      : vms_dsc$class_s; 	flags		: vms_defptr;- 	data		: vms_deftype;- 	key_level	: vms_ulong
 	): vms_long;r   {+ FUNCTIONAL DESCRIPTION:d  iA     X_help_routine (alias help_routine) is called by lbr$get_help F     to perform the actual output to the virtual display, line by line.   FORMAL PARAMETERS:       txt_string:% 	descriptor for the line of help textc
     flags:% 	status info passed from LBR$GET_HELPm	     data:	! 	user data passed to LBR$GET_HELPr     key_level: 	current key level  _
 RETURN VALUE:G  )     Status coder   
 SIDE EFFECTS:f  y     %[description_or_none]%A  1 DESIGN:k  s     %[description_or_none]%(  ) IMPLICIT INPUT PARAMETERS:  A3     Context identifier for the help virtual display:  O IMPLICIT OUTPUT PARAMETERS:   p     %[description_or_none]%V  T %[logical_properties]%  v %[optional_routine_tags]%	 -}   VART      out_prt	    : chr_array_ptr;!     out_string	    : STRING(255);O     sys_stat	    : integer;a 	d BEGIN}  3 if uand(flags::unsigned, HLP$M_KEYNAMLIN) <> 0 thent	     begin      more_help := False;I     bad_key := False     end;  ; more_help := (uand(flags::unsigned, HLP$M_OTHERINFO) <> 0);t8 bad_key := (uand(flags::unsigned, HLP$M_NOHLPTXT) <> 0);     # IF txt_string.dsc$w_length > 0 THENf	     BEGINs     out_string := SUBSTR( * 	txt_string.dsc$a_pointer::chr_array_ptr^, 	1,s 	txt_string.dsc$w_length);     ENDi   ELSE	     BEGINr     out_string := ZERO	     END; s   IF text_end < HELP_ROWS THEN	     BEGIN	     sys_stat := smg$put_line ( 		    display_id := hvdsp, 		    text   := out_string);     text_end := text_end + 1     END;   if text_end = HELP_ROWS then7     x_help_routine := 0		{ Zero indicates full buffer }: else     x_help_routine := sys_stat   END; { help_routine }k   r   PROCEDURE do_help;   {+ FUNCTIONAL DESCRIPTION:n   E     Do_help writes the help text for the requested topic to the help i     virtual display   O FORMAL PARAMETERS:       Nonee  	
 RETURN VALUE:h  o     None   
 SIDE EFFECTS:         %[description_or_none]%e    DESIGN:l        %[description_or_none]%     IMPLICIT INPUT PARAMETERS:  n1     The help virtual display and status variablesd     The library index variable  _ IMPLICIT OUTPUT PARAMETERS:p  b     %[description_or_none]%	    %[logical_properties]%    %[optional_routine_tags]%	 -}   VARs     i,     sys_stat	: integer; %     labeltxt 	: varying [70] of char;    BEGINe   text_end := 1;   labeltxt := '  ';a for i := 1 to 10 do]   IF keys[i] <> '' thenD)     labeltxt := labeltxt + keys[i] + ' ';: labeltxt := labeltxt + '  ';  ) if labeltxt = '' then labeltxt := 'HELP';e  2 { erase any error messages from the message line } if error_msg then		     begina#     sys_stat := smg$erase_display (i)                     display_id := bvdsp);oC     check_stat('$ERASE_DISPLAY for message line failed', sys_stat);s     error_msg := False     end;   sys_stat := smg$erase_display (  		display_id := hvdsp); ? check_stat('$ERASE_DISPLAY for main display failed', sys_stat);U  . sys_stat := smg$begin_pasteboard_update(pbrd);8 check_stat('$BEGIN_PASTEBOARD_UPDATE failed', sys_stat);  ! sys_stat := smg$change_viewport (e 		display_id := hvdsp, 		viewport_row_start := 1, 		viewport_column_start := 1,g( 		viewport_number_rows := pbrd_rows - 3,( 		viewport_number_columns := pbrd_cols);0 check_stat('$CHANGE_VIEWPORT failed', sys_stat);   sys_stat := lbr$get_help (     library_index := lib_index,      routine := help_routine,     key_1 := keys[1],s     key_2 := keys[2],      key_3 := keys[3],      key_4 := keys[4],l     key_5 := keys[5],n     key_6 := keys[6],s     key_7 := keys[7],      key_8 := keys[8],      key_9 := keys[9],      key_10 := keys[10]);  2 sys_stat := smg$label_border (display_id := cvdsp, 				text := labeltxt,  				position_code := SMG$K_TOP,<! 				rendition_set := SMG$M_BOLD);   . check_stat ('LABEL BORDER failed.', sys_stat);    5 if sys_stat = 0 then		{ Zero indicates full display } 	     beging     sys_stat := smg$put_chars (D 		    display_id := bvdsp,/ 		    text   := 'Display full, text truncated',  		    start_row := 1,  		    start_column := 1,! 		    flags := SMG$M_ERASE_LINE);t9     check_stat('$PUT_CHARS in do_help failed', sys_stat);      error_msg := Trues     endm else-     check_stat('$GET_HELP failed', sys_stat);(  , sys_stat := smg$end_pasteboard_update(pbrd);6 check_stat('$END_PASTEBOARD_UPDATE failed', sys_stat);    if not more_help or bad_key then	     begino     if key_count >= 1 then 	begin 	keys[key_count] := ZERO;e 	key_count := key_count - 1  	end     end_   END; { do_help }   U  5 function set_lib (VAR library:key_string):key_string;U   {+ FUNCTIONAL DESCRIPTION:T  r"     Set_lib opens the help library  P FORMAL PARAMETERS:  t    Noneb  t
 RETURN VALUE:b        None  e
 SIDE EFFECTS:O  L     %[description_or_none]%   e DESIGN:a  i     %[description_or_none]%V  E IMPLICIT INPUT PARAMETERS:  C     %[description_or_none]%o  o IMPLICIT OUTPUT PARAMETERS:w  u     The library index variable  o %[logical_properties]%    %[optional_routine_tags]%e -}   VARs     sys_stat : integer;T     wordnames,     library_file : key_string;     pos:integer;   BEGINU   sys_stat := lbr$ini_control (t     lib_index,     LBR$C_READ,p     LBR$C_TYP_HLP);n/ check_stat('LBR$INI_CONTROL failed', sys_stat);g  # if (SUBSTR(library,1,1) = '@') thent9     library_file := SUBSTR(library, 2, length(library)-1)  else     library_file := library;   sys_stat := lbr$open (     lib_index,     library_file);( check_stat('LBR$OPEN failed', sys_stat);  # pos := index(library_file, '.HLB');  if (pos>0) theny-     wordnames := SUBSTR(library_file,1,pos-1)  else     wordnames := library_file; pos := index(wordnames,  '::');a if (pos>0) then >     wordnames:= SUBSTR(wordnames, pos, length(wordnames)-pos); pos := index(wordnames, ':');  if (pos>0) thent@     wordnames:= SUBSTR(wordnames, pos+1, length(wordnames)-pos); pos := index(wordnames, ']');E if (pos>0) then @     wordnames:= SUBSTR(wordnames, pos+1, length(wordnames)-pos); set_lib := wordnames;_ END; { set_lib }      H PROCEDURE translate_hlp (VAR libraries:libraryarray; VAR numlib:integer;" 			 VAR descriptions:libraryarray;  			 VAR wordnames:libraryarray);   vars     pos,     i,j:integer;'     trnlnm : vms_item_list_template(2);t6     table,translation,logical : varying [255] of char;        begind     numlib := 0;  2     trnlnm[1].buf_len       	:= SIZE(translation);(     trnlnm[1].code      	:= LNM$_STRING;8     trnlnm[1].buffer     	:= IADDRESS(translation.body);:     trnlnm[1].ret_len    	:= IADDRESS(translation.length);       trnlnm[2].terminator	:= 0;         for i:= 1 to 4 do0	     begint         case i of_  	    1:  table := 'LNM$PROCESS'; 	    2:  table := 'LNM$GROUP'; 	    3:  table := 'LNM$SYSTEM';y 	    4:  table := 'LNM$JOB';         end;     for j:= 0 to 10 do	     beginu 	if (j>0) then  ' 	    writev(logical,'HLP$LIBRARY_',j:0)  	elset 	    logical := 'HLP$LIBRARY';" 	$trnlnm(attr := LNM$M_CASE_BLIND, 		tabnam := table, 		lognam := logical, 		itmlst := trnlnm);" 	if (length(translation) > 0) then 	begin 	    numlib := numlib + 1;& 	    libraries[numlib] := translation; 	    translation := '';o   	    (* Get description *)   	    if (j>0) then v/ 	        writev(logical,'HLP$DESCRIPTION_',j:0)o	 	    elsea& 	        logical := 'HLP$DESCRIPTION';& 	    $trnlnm(attr := LNM$M_CASE_BLIND, 		tabnam := table, 		lognam := logical, 		itmlst := trnlnm);& 	    if (length(translation) > 0) then
 	    begin- 	        descriptions[numlib] := translation;  	        translation := '';  	    end	 	    elseA 		descriptions[numlib] := '';  	end;,     end;     end;       for i:= 1 to numlib do	     begin +         pos := index(libraries[i], '.HLB');i         if (pos>0) then 8             wordnames[i] := SUBSTR(libraries[i],1,pos-1)         else$         wordnames[i]:= libraries[i];*         pos := index(wordnames[i],  '::');         if (pos>0) thenTJ   	    wordnames[i]:= SUBSTR(wordnames[i], pos, length(wordnames[i])-pos);(         pos := index(wordnames[i], ':');         if (pos>0) then Q             wordnames[i]:= SUBSTR(wordnames[i], pos+1, length(wordnames[i])-pos);b(         pos := index(wordnames[i], ']');         if (pos>0) thenpN     	    wordnames[i]:= SUBSTR(wordnames[i], pos+1, length(wordnames[i])-pos);     end;   end; 	         A function lib_list(var libraries:libraryarray; var numlib:integer; # 		   var descriptions:libraryarray;w, 		   var wordnames:libraryarray):key_string;           var' 	in_length : vms_uword;r.      	in_line : packed array [1..256] of char;3         term_code: vms_uword;			{ length of above }_
 	sys_stat, 	list_left_margin,
 	i : integer;, 	line : varying [255] of char;     	     begin 4 	sys_stat := smg$erase_display(display_id := cvdsp);) 	sys_stat := smg$create_virtual_display (E+                 number_of_rows := numlib+6,'% 		display_attributes := SMG$M_BORDER,_/                 number_of_columns := pbrd_cols,p&                 display_id := libdsp);L 	check_stat('$CREATE_VIRTUAL_DISPLAY for library display failed', sys_stat);1 	sys_stat := smg$label_border(display_id:=libdsp,t& 			text := 'HELP LIBRARIES AVAILABLE', 			position_code := SMG$K_TOP,  			rendition_set := SMG$M_BOLD);6 	writev (line, 'Library',' ':18,'Description',' ':29);> 	list_left_margin := (pbrd_cols div 2) - (length(line) div 2);3 	sys_stat := smg$put_chars(   display_id := libdsp,_ 			text := line,1 			rendition_set := SMG$M_BOLD + SMG$M_UNDERLINE,_ 			start_row := 2,% 			start_column := list_left_margin); + 	check_Stat('$put_chars failed', sys_stat);D 	for i := 1 to numlib do 	begin; 	    writev(line, wordnames[i],' ':25-length(wordnames[i]),d 		   descriptions[i]);7 	    sys_stat := smg$put_chars(   display_id := libdsp,	 		text := line,M 		start_row := 2+i,'$ 		start_column := list_left_margin);3 		check_stat('$put chars failed again.', sys_stat);  	end;a8 	    sys_stat := smg$put_chars (   display_id := libdsp,Y 		text := 'To select another library, enter the library name at the New Library? prompt',S 		start_row := numlib+5, 		start_column := 1);_0 	    check_stat('$put chars failed.', sys_stat);8 	    sys_stat := smg$put_chars (   display_id := libdsp,J 		text := 'or press the [RETURN] key to resume help in current library.',  		start_row:= numlib+6,y 		start_column := 1);e 	i := (pbrd_rows -numlib-6);0 	smg$paste_virtual_display(libdsp, pbrd, i-2,1);1         sys_stat := smg$repaste_virtual_display (E$                 display_id := bvdsp,&                 pasteboard_id := pbrd,,                 pasteboard_row := pbrd_rows,(                 pasteboard_column := 1);K 	check_stat('$PASTE_VIRTUAL_DISPLAY for command display failed', sys_stat); , 	sys_stat := smg$set_cursor_abs(cvdsp, 1,1);1 	check_stat('set cursor didn''t work', sys_stat);  	sys_stat := smg$read_string ( 			keyboard_id := kbrd,e 			resultant_string := in_line,t$ 			prompt_string := 'New Library? ',! 			resultant_length := in_length,i 			display_id := cvdsp,l& 			word_terminator_code := term_code);; 	if (sys_stat<> SS$_CANCEL) AND (sys_stat <> SS$_ABORT) ANDR  	    (sys_stat <> SMG$_EOF) then7    	    check_stat('$read string failed...', sys_stat);s    	if (sys_stat = SMG$_EOF) then 	begin 	    sys_stat := lbr$close (
 		lib_index);  	    if not odd(sys_stat) then 		lib$signal(sys_stat);c+ 	    r_stat := smg$delete_pasteboard(pbrd);V 	    $exit(sys_stat) 	end 	elseC 	if (in_length = 0) then 	    lib_list := ''I 	else  	BEGIN 	    lib_list := '';$ 	    for i:= 1 to length(in_line) do- 		if (in_line[i] >chr(96)) then in_line[i] :=h 		    chr(ord(in_line[i])-32); 	    for i:= 1 to numlib dom- 		if (length(wordnames[i]) >= in_length) thenR$ 		if (SUBSTR(in_line,1,in_length) = ) 			SUBSTR(wordnames[i],1,in_length)) thenE 		begin # 		    lib_list:= libraries[i];	    e 		    smg$erase_display(hvdsp);i 		end; 	end;i6 	    smg$delete_virtual_display(display_id := libdsp);. 	    sys_stat := smg$repaste_virtual_display ($                 display_id := cvdsp,&                 pasteboard_id := pbrd,0                 pasteboard_row := pbrd_rows - 1,(                 pasteboard_column := 1);. 	    sys_stat := smg$repaste_virtual_display ($                 display_id := bvdsp,&                 pasteboard_id := pbrd,,                 pasteboard_row := pbrd_rows,(                 pasteboard_column := 1);       end;    :4 function get_libname(VAR libraries:libraryarray; VAR0 		wordnames:libraryarray; var lookup:key_string; 		numlib:integer):key_String;t var      x,     i:integer;     temp : key_string;   begin=J     if (lookup[1] = '@') then lookup := substr(lookup,2,length(lookup)-1);     temp := '';t"     for i:= 1 to length(lookup) do+ 	if (lookup[i] > chr(96)) then lookup[i] :=t  	    chr(ord(lookup[i])-32);d     for i:= 1 to numlib do1 	if (length(wordnames[i]) >= length(lookup)) thenH9 	if (lookup = SUBSTR(wordnames[i],1,length(lookup))) theno 	    temp := libraries[i];     get_libname := temp; end;   PROCEDURE keys_help;   var 3         term_code: vms_uword;			{ length of above }  	line:  varying [255] of char; 	list_left_margin,
 	sys_stat,
 	i : integer;      	     beginn4 	sys_stat := smg$erase_display(display_id := cvdsp);) 	sys_stat := smg$create_virtual_display (G$                 number_of_rows := 9,% 		display_attributes := SMG$M_BORDER,s/                 number_of_columns := pbrd_cols,_%                 display_id := kvdsp); L 	check_stat('$CREATE_VIRTUAL_DISPLAY for keyhelp display failed', sys_stat);0 	sys_stat := smg$label_border(display_id:=kvdsp,' 			text := '  NEWHELP KEY DEFINITIONS',L 			position_code := SMG$K_TOP,  			rendition_set := SMG$M_BOLD);) 	writev (line, 'PRESS     ','TO',' ':30);n> 	list_left_margin := (pbrd_cols div 2) - (length(line) div 2);2 	sys_stat := smg$put_chars(   display_id := kvdsp, 			text := line,1 			rendition_set := SMG$M_BOLD + SMG$M_UNDERLINE,  			start_row := 2,% 			start_column := list_left_margin);s+ 	check_Stat('$put_chars failed', sys_stat);N    / 	writev (line, 'PF2       Display this help.'); 2 	sys_stat := smg$put_chars(   display_id := kvdsp, 			text := line, 			start_row := 3,% 			start_column := list_left_margin); + 	check_Stat('$put_chars failed', sys_stat);S  / 	writev (line, 'HELP      Display this help.'); 2 	sys_stat := smg$put_chars(   display_id := kvdsp, 			text := line, 			start_row := 4,% 			start_column := list_left_margin);S+ 	check_Stat('$put_chars failed', sys_stat);   ? 	writev (line, 'SELECT    List the available help libraries.');s2 	sys_stat := smg$put_chars(   display_id := kvdsp, 			text := line, 			start_row := 5,% 			start_column := list_left_margin);e+ 	check_Stat('$put_chars failed', sys_stat);e  ' 	writev (line, 'PREV SCRN Scroll up.');i2 	sys_stat := smg$put_chars(   display_id := kvdsp, 			text := line, 			start_row := 6,% 			start_column := list_left_margin);E+ 	check_Stat('$put_chars failed', sys_stat);   ) 	writev (line, 'NEXT SCRN Scroll down.');y2 	sys_stat := smg$put_chars(   display_id := kvdsp, 			text := line, 			start_row := 7,% 			start_column := list_left_margin);y+ 	check_Stat('$put_chars failed', sys_stat);s  * 	writev (line, 'CTRL-Z    Exit NEWHELP.');2 	sys_stat := smg$put_chars(   display_id := kvdsp, 			text := line, 			start_row := 8,% 			start_column := list_left_margin);s+ 	check_Stat('$put_chars failed', sys_stat);   - 	smg$paste_virtual_display(kvdsp, pbrd, 2,1);k, 	sys_stat := smg$set_cursor_abs(cvdsp, 1,1);1 	check_stat('set cursor didn''t work', sys_stat);] 	sys_stat := smg$read_string ( 			keyboard_id := kbrd,g 			resultant_string := in_line,_: 			prompt_string := 'Press RETURN to exit the KEY HELP: ', 			display_id := cvdsp);; 	if (sys_stat<> SS$_CANCEL) AND (sys_stat <> SS$_ABORT) ANDt  	    (sys_stat <> SMG$_EOF) then7    	    check_stat('$read string failed...', sys_stat);u    	if (sys_stat = SMG$_EOF) then 	begin 	    sys_stat := lbr$close (
 		lib_index);  	    if not odd(sys_stat) then 		lib$signal(sys_stat);R+ 	    r_stat := smg$delete_pasteboard(pbrd);U 	    $exit(sys_stat)
      	end;8         smg$delete_virtual_display(display_id := kvdsp);     end;        var_          promptstring,s     currentlib,m     library_file : key_string;4     libraries,descriptions,wordnames : libraryarray;     numlib : integer;i   BEGIN { main }  : translate_hlp(libraries, numlib, descriptions, wordnames);  & { Add system library to list as well }  ' library_file := 'SYS$HELP:HELPLIB.HLB';  numlib := numlib + 1;r, libraries[numlib] := 'SYS$HELP:HELPLIB.HLB';K descriptions[numlib] := 'Help about VMS-Layered products produced by DEC.';G wordnames[numlib] := 'HELPLIB';t     key_count := 0;N r_stat := lib$get_foreign (r,                 resultant_string := in_line,/                 resultant_length := in_length);n- check_stat('LIB$GET_FOREIGN failed', r_stat);  if in_length >0 then beginl0     parse_topics(SUBSTR(in_line, 1, in_length));(     if (SUBSTR(keys[1], 1,1) = '@') THEN	     beginrD 	library_file := get_libname(libraries, wordnames, keys[1], numlib); 	for k_index := 2 to 10 do& 	    keys[k_index-1] := keys[k_index]; 	keys[10] := ''; 	same_key := false;( 	key_count := key_count - 1;     end; end;   if key_count<1 thenl beginl     keys[1] := 'HELP';     key_count := 1;h end;   set_screen;n$ currentlib := set_lib(library_file); do_help;   term_code := SMG$K_TRM_CR; REPEAT$     { now build the initial string }.     old_keys := keys;			{ save previous keys }     b_str := ZERO;3     if (key_count = 1) and  (keys[1] = 'HELP') thene 	key_count := 0;$     FOR k_index := 1 to key_count DO 	BEGIN  	b_str := b_str + keys[k_index]; 	b_str := b_str + ' '  	END;t,     promptstring := currentlib + ' Topic? ';K     { The broadcast AST cancels the input operation, so maybe do it again }t+     r_stat := smg$set_cursor_abs(cvdsp,,1);:0     check_stat('SET CURSOR ABS failed', r_stat);&     r_stat := smg$erase_line(cvdsp,1);+     check_stat('ERASE LINE failed',r_stat);      r_stat := SS$_CANCEL; :     while (r_stat = SS$_CANCEL) OR (r_stat = SS$_ABORT) do 	begin# 	r_stat := smg$read_composed_line (L 			keyboard_id := kbrd,e, 			flags := (SMG$M_NOKEEP + SMG$M_NORECALL), 			initial_string := b_str,o 			resultant_string := in_line,  			key_table_id := ktbl,! 			prompt_string := promptstring,n! 			resultant_length := in_length,s 			display_id := cvdsp, & 			word_terminator_code := term_code); 	IF r_stat = SMG$_EOF THEN
 	    BEGIN 	    r_stat := lbr$close (
 		lib_index);  	    if not odd(r_stat) then 		lib$signal(r_stat);y+ 	    r_stat := smg$delete_pasteboard(pbrd);7 	    $exit(r_stat) 	    END= 	ELSE if (r_stat<> SS$_CANCEL) AND (r_stat <> SS$_ABORT) theny
 	    BEGIN8 	    check_stat('SMG$READ_COMPOSED_LINE failed', r_stat)	 	    END;t 	end; { while }b? 	if (term_code = SMG$K_TRM_HELP) or (term_code = SMG$K_TRM_PF2)s 	thenh 	    keys_help 	elser# 	if (term_code = SMG$K_TRM_SELECT) t 	then$
 	    beginH 	        keys[1] :=lib_list(libraries, numlib, descriptions, wordnames); 		if (length(keys[1]) >0) then 		begin)- 	            r_stat := lbr$close (lib_index);t# 	      	    if not odd(r_stat) thend 		        lib$signal(r_stat);E" 		    library_file := '@'+keys[1];* 		    currentlib := set_lib(library_file); 		    key_count :=1; 	 	    keys[1] := 'HELP';P 		    do_help; 		    same_key := true;m 		end; 	    end 	elsei 	IF (term_code <> SMG$K_TRM_CR)w1 		AND (term_code <> SMG$K_TRM_QUESTION_MARK) THENw
 	    BEGIN 	    scroll_display(term_code) 	    END 	ELSE 
 	    BEGIN1 	    parse_topics(SUBSTR(in_line, 1, in_length));; 	    same_key := True; 	    for k_index := 1 to 10 do' 		if keys[k_index] <> old_keys[k_index]  		    then same_key := False;  	    if (key_count >=1) then
 	    begin) 	    if (SUBSTR(keys[1], 1,1) = '@') THEN 
 	    beginE 		library_file := get_libname(libraries, wordnames, keys[1], numlib);=" 		if length(library_file) > 0 then 	        begin 	        r_stat := lbr$close (    	            lib_index);  	    	if not odd(r_stat) thenP 		    lib$signal(r_stat);G& 		currentlib := set_lib(library_file); 		for k_index := 2 to 10 dos' 		    keys[k_index-1] := keys[k_index];i 		keys[10] := '';g 	        same_key := false;r 		key_count := key_count - 1;, 		if (key_count < 1) thenf
 		   begin 			keys[1] := 'HELP';_ 			key_count := 1;	 		   end;: 		end; 	    end	 	    end;A 	    if same_key5 		    AND (term_code <> SMG$K_TRM_QUESTION_MARK) THEN  		begins 		if key_count >= 1 then 		    begint 		    keys[key_count] := ZERO;! 		    key_count := key_count - 1;d
 		do_help;	 		    endt 		else" 		if (currentlib = 'HELPLIB') then 		    beginm 		    r_stat := lbr$close (  			lib_index); 		    if not odd(r_stat) theny 			lib$signal(r_stat);, 		    r_stat := smg$delete_pasteboard(pbrd); 		    $exit(r_stat) 	 		    endi 		else 		begini/ 		    currentlib := set_lib(libraries[numlib]);D 		    do_help; 		end; 		end { if same_key }b	 	    elseO 		beginM	 		do_help  		endb	 	    END;N   UNTIL FALSE    END.