 /*     	PSTAT v1.1 + 	Copyright (C) 1993 by Brandeis University   	Author: Vadim Gorokhovsky  ! 	Created: v1.1 Summer-Autumn 1993  	Modified: v2.1 Winter 1993  	File: pstat.c  G       You are given permission to distribute and/or modify this program J       under the terms of the GNU general license as long as this copyright?       notice is retained.  See README.DOC for more information.  */   #include "pstat.h"  5 unsigned long int cont_display, cont_paste, keyboard;  unsigned long int boottime[2];I Flags_t flags = {FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,  H                  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,>                  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 0};K globalvalue MSG_IVLOGNAM, MSG_NONEXPR, MSG_NOPRIV, MSG_NOMATCH, MSG_NOCONT,              MSG_SUSPENDED;  0 void ticks_to_bin(long int ticks, timbuf_t *bin) { "   bin->day = ticks/(100*60*60*24);(   ticks = ticks-(bin->day*100*60*60*24);    bin->hour = ticks/(100*60*60);&   ticks = ticks-(bin->hour*100*60*60);   bin->minute = ticks/(100*60); %   ticks = ticks-(bin->minute*100*60);    bin->second = ticks/(100);"   ticks = ticks-(bin->second*100);   bin->hundredths = ticks; }     void uppercase_string(char *str) {                        while (*str=toupper(*str))
        str++;  }   & char *strpad(char *str, char c, int i) { 
   int j=0;     while(str[j++]);   j--;   while(j <= i){     str[j++] = c;    }    str[j] = '\0';
   return str;  }    void del_front_space(char *str)  {    int i=0, j=0;       while(isspace(str[i++])); 1   i--;                          /* one too far */    while(str[j++] = str[i++]);  }        void del_space(char *str)  {    while(*str && *str != ' ')
     str++;   *str = '\0'; }       void del_hundredths(char *str) { "   while(*str && *str !='.') str++;   *str = '\0'; }   - /* delete year from a standard date format */  void del_year(char *str) {    int i=6, j=11;     while(str[i++]=str[j++]);    str[i] = '\0'; }   ! int make_hundredths(timbuf_t tim)  { @    return tim.hundredths + tim.second*100 + tim.minute*60*100 + 8           tim.hour*60*60*100 + tim.day*24*60*60*100;     }   + float ratio(timbuf_t tim_1, timbuf_t tim_2)  {    int i_tim_1, i_tim_2;   #   i_tim_1 = make_hundredths(tim_1); #   i_tim_2 = make_hundredths(tim_2); J   return (i_tim_1 <= 0 || i_tim_2 <= 0) ? 0:((float) i_tim_2/i_tim_1)*100; }    void echeck(int status)  { 5   if (status != SS$_NORMAL && status != LIB$_NORMAL){      lib$signal(status);      exit(EXIT_FAILURE);    }  }    void cleanup(int status) { (   if (flags.continuous) delete_screen();   exit(status);  }    void check_error(int status) {    if (status == SS$_IVLOGNAM){     cleanup(MSG_IVLOGNAM);   }    if (status == SS$_NONEXPR){      cleanup(MSG_NONEXPR);    } )   if (flags.pid && status == SS$_NOPRIV){      cleanup(MSG_NOPRIV);   }  }   ( char *get_state(unsigned long int state) {    switch(state){!     case SCH$C_CEF: return "CEF"; !     case SCH$C_COM: return "COM"; #     case SCH$C_COMO: return "COMO"; !     case SCH$C_CUR: return "CUR"; %     case SCH$C_COLPG: return "COLPG"; !     case SCH$C_FPG: return "FPG"; !     case SCH$C_HIB: return "HIB"; #     case SCH$C_HIBO: return "HIBO"; !     case SCH$C_LEF: return "LEF"; #     case SCH$C_LEFO: return "LEFO"; %     case SCH$C_MWAIT: return "MWAIT"; !     case SCH$C_PFW: return "PFW"; #     case SCH$C_SUSP: return "SUSP"; %     case SCH$C_SUSPO: return "SUSPO";      default: return "";    }  }   ) char *get_id(long int id_num, char *ctrl)  {    char outbuf[257];    $DESCRIPTOR(ctrl_d, ctrl);    $DESCRIPTOR(outbuf_d, outbuf);   unsigned short int outlen;   long int direct=id_num;   %   ctrl_d.dsc$w_length = strlen(ctrl);    ctrl_d.dsc$a_pointer = ctrl;7   echeck(sys$fao(&ctrl_d, &outlen, &outbuf_d, direct));    outbuf[outlen] = '\0';   return outbuf; }   I int check_mode(long int pid, long int mpid, long int mode, long int type)  {    int ret_val=FALSE;     switch(mode){ 8     case JPI$K_NETWORK: ret_val |= flags.network; break;4     case JPI$K_BATCH: ret_val |= flags.batch; break;@     case JPI$K_INTERACTIVE: ret_val |= flags.interactive; break;   }    switch(type){ :     case JPI$K_DETACHED: ret_val |= flags.detached; break;6     case JPI$K_DIALUP: ret_val |= flags.dialup; break;6     case JPI$K_REMOTE: ret_val |= flags.remote; break;   }    if (pid != mpid){      if (flags.intersect){ )       ret_val = ret_val && flags.spawned;      } else if (flags.uni){)       ret_val = ret_val || flags.spawned;      } else {       ret_val = FALSE;     }    }    return ret_val;  }   * /* candidate in str_1, pattern in str_2 */( int match_wild(char *str_1, char *str_2) { $   char pattern[257], candidate[257];&   $DESCRIPTOR(candidate_d, candidate);"   $DESCRIPTOR(pattern_d, pattern);  "   pattern_d.dsc$a_pointer = str_2;)   pattern_d.dsc$w_length = strlen(str_2); $   candidate_d.dsc$a_pointer = str_1;+   candidate_d.dsc$w_length = strlen(str_1); B   return (STR$_MATCH == str$match_wild(&candidate_d, &pattern_d)); }   - int check_username(char *obj, char *username)  { $   if (! flags.username) return TRUE;2   return (! strncmp(obj, username, strlen(obj)) ||%           match_wild(username, obj));  }   + int check_process(char *obj, char *process)  { #   if (! flags.process) return TRUE; 1   return (! strncmp(obj, process, strlen(obj)) || $           match_wild(process, obj)); }   C int check_before(unsigned long log_tim[2], unsigned long before[2])  {    unsigned int res[2];  "   if (! flags.before) return TRUE;>   return (lib$sub_times(before, log_tim, res) == LIB$_NORMAL); }   A int check_after(unsigned long log_tim[2], unsigned long after[2])  {    unsigned int res[2];  !   if (! flags.after) return TRUE; =   return (lib$sub_times(log_tim, after, res) == LIB$_NORMAL);  }   % int check_less(float rat, float less)  {     if (! flags.less) return TRUE;   return (rat < less); }   + int check_greater(float rat, float greater)  { #   if (! flags.greater) return TRUE;    return (rat > greater);  }   ' int check_image(char *obj, char *image)  {    char name[257], name_1[257];   $DESCRIPTOR(name_d, name);
   int status;    ilist2_t itemlist[]={ +                         {0, FSCN$_NAME, 0}, !                         {0, 0, 0}                        };  !   if (! flags.image) return TRUE;    strcpy(name, image);&   name_d.dsc$w_length = strlen(image);.   echeck(sys$filescan(&name_d, &itemlist, 0));)   if (itemlist[0].len == 0) return FALSE; &   strcpy(name_1, itemlist[0].address);!   name_1[itemlist[0].len] = '\0'; 0   return (! strncmp(name_1, obj, strlen(obj)) ||#           match_wild(name_1, obj));  }   E Node fill_tree(Node tree, char *node, long int uic, long int ppgcnt,  M                long int gpgcnt, long int owner, char *state, char *terminal,  E                long int pri, char *image, long int prib, char *user,  L                long int pid, char *proc, char *cpu, char *log, char *delta,                 float rat)  {    Node temp;     temp = make_node(); #   strcpy(temp->data->state, state); )   strcpy(temp->data->terminal, terminal); !   strcpy(temp->data->user, user);    strcpy(temp->data->cpu, cpu);    strcpy(temp->data->log, log); #   strcpy(temp->data->delta, delta); !   strcpy(temp->data->proc, proc); #   strcpy(temp->data->image, image); !   strcpy(temp->data->node, node);    temp->data->uic = uic;   temp->data->pid = pid;   temp->data->rat = rat;   temp->data->ppgcnt = ppgcnt;   temp->data->gpgcnt = gpgcnt;   temp->data->owner = owner;   temp->data->pri = pri;   temp->data->prib = prib;   if (tree == NULL){     return temp;
   } else {     insert_tree(tree, temp);     return tree;   }  }   ! void dealloc(Node tree, Node key)  {    free(tree->data); 
   free(tree);  }   C void get_delta(unsigned long cur_tim[2], unsigned long log_tim[2],  E                unsigned long delta_tim[2], char log[], char delta[],  6                char cpu_str[], long ticks, float *rat) { "   char delta_str[40], log_str[40];&   $DESCRIPTOR(delta_str_d, delta_str);"   $DESCRIPTOR(log_str_d, log_str);   unsigned short timlen;   timbuf_t cpu_bin, delta_bin;  A   if (lib$sub_times(cur_tim, log_tim, delta_tim) == LIB$_NORMAL){ 8     echeck(sys$asctim(&timlen, &log_str_d, log_tim, 0));     log_str[timlen] = '\0';      del_hundredths(log_str);<     echeck(sys$asctim(&timlen, &delta_str_d, delta_tim, 0));     delta_str[timlen] = '\0';      del_front_space(delta_str); .     echeck(sys$numtim(&delta_bin, delta_tim));"     ticks_to_bin(ticks, &cpu_bin);%     *rat = ratio(delta_bin, cpu_bin); J     sprintf(cpu_str,"%1d %02d:%02d:%02d.%02d", cpu_bin.day, cpu_bin.hour, @             cpu_bin.minute, cpu_bin.second, cpu_bin.hundredths);     strcpy(log, log_str);      strcpy(delta, delta_str); 
   } else {     strcpy(log, "--Unknown--"); !     strcpy(delta, "--Unknown--");    }  }   5 unsigned long get_context(char *nodename, char *host)  {    char s_all[]="*";    unsigned long s_pid;    ilist3_t itemlist_pscan[] = { C                                  {sizeof(s_all)-1, PSCAN$_NODENAME, ;                                   s_all, PSCAN$M_WILDCARD}, C                                  {sizeof(s_all)-1, PSCAN$_USERNAME, ;                                   s_all, PSCAN$M_WILDCARD}, .                                  {0, 0, 0, 0} !                                };      if (flags.node){(     itemlist_pscan[0].buffer = nodename;-     itemlist_pscan[0].len = strlen(nodename); 
   } else {$     itemlist_pscan[0].buffer = host;)     itemlist_pscan[0].len = strlen(host);    } 4   echeck(sys$process_scan(&s_pid, &itemlist_pscan));   return s_pid;  }   ; void update_suspended(Node tree, unsigned long cur_tim[2],  L                       unsigned long log_tim[2], unsigned long delta_tim[2], H                       char log_str[], char delta_str[], char cpu_str[], B                       long ticks, float *rat, unsigned long state) { *   $DESCRIPTOR(log_str_d, tree->data->log);  ,   log_str_d.dsc$a_pointer = tree->data->log;3   log_str_d.dsc$w_length = strlen(tree->data->log); *   echeck(sys$bintim(&log_str_d, log_tim));E   get_delta(cur_tim, log_tim, delta_tim, log_str, delta_str, cpu_str,              ticks, rat);'   strcpy(tree->data->delta, delta_str); .   strcpy(tree->data->state, get_state(state)); }   P Node get_info(Node tree, char *nodename, char *host, int *pid, char *s_prcname, G               char *s_username, char *s_image, unsigned long before[2], @               unsigned long after[2], float less, float greater) { A   unsigned short int userlen, imagelen, prclen, termlen, nodelen;    long int ticks, status, mode; E   unsigned long int s_pid, mast_pid, proc_pid = -1, log_tim[2], type, E                     delta_tim[2], grp, pri, state, own_pid, last_pid, A                     ppgcnt, gpgcnt, group, prib, uic, cur_tim[2]; I   char prcname[16], username[13], cpu_str[40], delta_str[40], s_proc[16], C        image[257], terminal[9], log_str[40], node[16], s_all[]="*";    float rat;   ilist3_t itemlist_jpi[]={ @                         {sizeof(ticks), JPI$_CPUTIM, &ticks, 0},K                         {sizeof(image)-1, JPI$_IMAGNAME, image, &imagelen}, ?                         {sizeof(type), JPI$_JOBTYPE, &type, 0}, E                         {sizeof(log_tim), JPI$_LOGINTIM, log_tim, 0}, K                         {sizeof(mast_pid), JPI$_MASTER_PID, &mast_pid, 0},  <                         {sizeof(mode), JPI$_MODE, &mode, 0},3 			{sizeof(node)-1, JPI$_NODENAME, node, &nodelen}, C                         {sizeof(own_pid), JPI$_OWNER, &own_pid, 0}, D                         {sizeof(proc_pid), JPI$_PID, &proc_pid, 0}, B                         {sizeof(ppgcnt), JPI$_PPGCNT, &ppgcnt, 0},B                         {sizeof(gpgcnt), JPI$_GPGCNT, &gpgcnt, 0},K                         {sizeof(prcname)-1, JPI$_PRCNAM, prcname, &prclen}, 9                         {sizeof(pri), JPI$_PRI, &pri, 0}, <                         {sizeof(prib), JPI$_PRIB, &prib, 0},@                         {sizeof(state), JPI$_STATE, &state, 0}, P                         {sizeof(terminal)-1, JPI$_TERMINAL, terminal, &termlen},9                         {sizeof(uic), JPI$_UIC, &uic, 0}, Q                         {sizeof(username)-1, JPI$_USERNAME, username, &userlen},  $                         {0, 0, 0, 0}                       };     flags.found = 0;   if (! flags.pid){ (     s_pid = get_context(nodename, host);
   } else {     s_pid = *pid;    }    echeck(sys$gettim(cur_tim));   do{       last_pid = proc_pid; @      status = sys$getjpiw(0, &s_pid, 0, &itemlist_jpi, 0, 0, 0);      check_error(status); ;      if (last_pid == proc_pid || status == SS$_NOMOREPROC){ 
        break;       }"      if (status == SS$_SUSPENDED){        if (tree != NULL){ E          update_suspended(tree, cur_tim, log_tim, delta_tim, log_str, B                           delta_str, cpu_str, ticks, &rat, state);          flags.found++;         } else {            cleanup(MSG_SUSPENDED);        }      } else if (! flags.found){ $        traverse_post(tree, dealloc);        tree = NULL;       }      if (status == SS$_NORMAL){ 8        username[userlen] = '\0'; prcname[prclen] = '\0';8        terminal[termlen] = '\0'; image[imagelen] = '\0';1        node[nodelen] = '\0'; del_space(username); 9        if ((check_mode(proc_pid, mast_pid, mode, type) && 2            check_username(s_username, username) &&)            check_image(s_image, image) && 0            check_process(s_prcname, prcname) && +            check_before(log_tim, before) && *            check_after(log_tim, after)) ||            flags.pid){M          get_delta(cur_tim, log_tim, delta_tim, log_str, delta_str, cpu_str,                       ticks, &rat);G          if ((check_less(rat, less) && check_greater(rat, greater)) ||                flags.pid){$            if (username[0] == '\0'){*              strcpy(username, "--None--");            }$            if (terminal[0] == '\0'){*              strcpy(terminal, "--None--");            }F            tree = fill_tree(tree, node, uic, ppgcnt, gpgcnt, own_pid, C                             get_state(state), terminal, pri, image, H                             prib, username, proc_pid, prcname, cpu_str, 5                             log_str, delta_str, rat);             *pid = proc_pid;             flags.found++; 
          }        }      }    } while(! flags.pid);    if (flags.lock){       flags.pid = TRUE;    }    return tree;  }   3 char *trim_file(char *file, unsigned short int len)  { *   unsigned short int reslen, newlen = len;$   char old_file[257], new_file[257];$   $DESCRIPTOR(old_file_d, old_file);$   $DESCRIPTOR(new_file_d, new_file);     strcpy(old_file, file); )   old_file_d.dsc$w_length = strlen(file); H   echeck(lib$trim_filespec(&old_file_d, &new_file_d, &newlen, &reslen));   new_file[reslen] = '\0';   return new_file; }   L void print(Node tree, char *l_1, char *l_2, char *l_3, char *l_4, char *l_5) {    if (! flags.full){J     sprintf(l_1, "%-12s %-8X %-15s %15s   %15s %6.2f%%", tree->data->user,>            tree->data->pid, tree->data->proc, tree->data->cpu,/            tree->data->delta, tree->data->rat); 
   } else {N     sprintf(l_1, "Terminal: %-8s   PID: %-08X   Owner PID: %-08X   Node: %s", E            tree->data->terminal, tree->data->pid, tree->data->owner,              tree->data->node); C     sprintf(l_2, "Username: %-12s    UIC: %s=%s", tree->data->user, O            get_id(tree->data->uic, UIC_NUM), get_id(tree->data->uic, UIC_STR)); I     sprintf(l_3, "Process: %-15s    %-5s    Pri: %2d/%-2d    Login: %s",  A            tree->data->proc, tree->data->state, tree->data->pri,  .            tree->data->prib, tree->data->log);D     sprintf(l_4, "PhysMem: %5d+%-5d    Connect: %-15s  CPU: %-15s", F            tree->data->ppgcnt, tree->data->gpgcnt, tree->data->delta,             tree->data->cpu);@     sprintf(l_5, "Image: %s", trim_file(tree->data->image, 70));     strpad(l_5, ' ',78);   }  }   % char *get_sys(char *node, char *host)  {    int i;H   char nodename[16], version[9], swtype[5], swvers[5], curtime_str[40], 3        uptime_str[40], boottime_str[40], head[100]; *   unsigned long int curtime[2], uptime[2];   unsigned short int timlen;   ilist3_t itemlist[]={ H                        {sizeof(boottime)-1, SYI$_BOOTTIME, boottime, 0},H                        {sizeof(nodename)-1, SYI$_NODENAME, nodename, 0},E                        {sizeof(version)-1, SYI$_VERSION, version, 0},eG                        {sizeof(swtype)-1, SYI$_NODE_SWTYPE, swtype, 0}, G                        {sizeof(swvers)-1, SYI$_NODE_SWVERS, swvers, 0},"#                        {0, 0, 0, 0}o                      };i(   $DESCRIPTOR(uptime_str_d, uptime_str);*   $DESCRIPTOR(curtime_str_d, curtime_str);,   $DESCRIPTOR(boottime_str_d, boottime_str);   $DESCRIPTOR(node_d, node);     echeck(sys$gettim(curtime));+   if (! flags.node || ! strcmp(node, "*")){ 4     echeck(sys$getsyi(0, 0, 0, &itemlist, 0, 0, 0));
   } else {      node_d.dsc$a_pointer = node;'     node_d.dsc$w_length = strlen(node); :     echeck(sys$getsyi(0, 0, &node_d, &itemlist, 0, 0, 0));   } 3   echeck(lib$sub_times(curtime, boottime, uptime));18   echeck(sys$asctim(&timlen, &uptime_str_d, uptime, 0));   uptime_str[timlen] = '\0';<   echeck(sys$asctim(&timlen, &boottime_str_d, boottime, 0));   boottime_str[timlen] = '\0';   del_front_space(uptime_str); k   del_hundredths(uptime_str);(   del_space(swtype);   del_space(version);*   del_space(nodename);   uptime_str[timlen] = '\0';:   echeck(sys$asctim(&timlen, &curtime_str_d, curtime, 0));   curtime_str[timlen] = '\0'; ?   sprintf(head, "%s %s on %s Date: %s Up: %s", swtype, swvers,  ,          nodename, curtime_str, uptime_str);   strcpy(host, nodename);c   return head; }-   void header(char *head_a)* {e   char head_b[100];(  L   sprintf(head_b, "%-12s %-8s %-15s   %-15s   %-13s %5s", "Username", "PID",A          "Process Name",  "CPU Time", "Connect Time", "  Ratio");r   if (! flags.continuous){     printf("%s\n\n", head_a);      if (! flags.full){       printf("%s\n\n", head_b);o     } 
   } else {!     output_info(1, head_a, TRUE);;     if (! flags.full){$       output_info(3, head_b, FALSE);     }n   }h }i    int confirm(char message_text[]) {t   char text[256];    int cmp_len, status;     if (flags.confirm){1     if (flags.continuous){F       make_message_line(flags.continuous, MESSAGE_LINE, message_text);       read_string(text);G       make_message_line(flags.continuous, MESSAGE_LINE, MSG_LONGBLANK);n     } else {!       printf("%s", message_text);m       fgets(text, 256, stdin);"       text[strlen(text)-1] = '\0';     }O     uppercase_string(text);)/     if ((cmp_len=strlen(text)) <= 0) cmp_len=1;R'     if (strncmp(text, "YES", cmp_len)){)      return FALSE;     }s   }e   return TRUE; }t   void delete_process(Node tree) {t   unsigned short int userlen;S   char username[13];   unsigned long int pid=0;   long int uic;_   union prvdef prv;u   ilist3_t itemlist[]={ ?                         {sizeof(prv), JPI$_PROCPRIV, &prv, 0}, ;9                         {sizeof(uic), JPI$_UIC, &uic, 0}, O                         {sizeof(username), JPI$_USERNAME, username, &userlen}, "$                         {0, 0, 0, 0}                       };   6   echeck(sys$getjpiw(0, &pid, 0, &itemlist, 0, 0, 0));   del_space(username);G   if (uic == tree->data->uic || ! strcmp(username, tree->data->user) ||        prv.prv$v_world){L"     if (confirm(MSG_CONFIRM_DEL)){.       echeck(sys$delprc(&tree->data->pid, 0));       if (! flags.continuous){         if (flags.log){eK           printf("Process %s with PID %08X was deleted successfully.\n\n", a4                  tree->data->proc, tree->data->pid);	         }*       }      } else {       if (! flags.continuous){         printf("\n\n");b       }b     } 
   } else {@     make_message_line(flags.continuous, MESSAGE_LINE, MSG_PRIV);   }t }    r   void print_normal(Node tree) {;6   char l_1[TERMWIDTH], l_2[TERMWIDTH], l_3[TERMWIDTH],5        l_4[TERMWIDTH], l_5[TERMWIDTH], response[267];n  '   print(tree, l_1, l_2, l_3, l_4, l_5);o   if (! flags.full){     printf("%s\n", l_1);
   } else {>     printf("%s\n%s\n%s\n%s\n%s\n\n", l_1, l_2, l_3, l_4, l_5);   }a   if (flags.delete){     delete_process(tree);    }; }     void print_continuous(Node tree) {a6   char l_1[TERMWIDTH], l_2[TERMWIDTH], l_3[TERMWIDTH],&        l_4[TERMWIDTH], l_5[TERMWIDTH];  '   print(tree, l_1, l_2, l_3, l_4, l_5);|   if (! flags.full){     output_info(5, l_1, FALSE);|
   } else {     output_info(3, l_1, FALSE);i     output_info(4, l_2, FALSE);      output_info(5, l_3, FALSE);s     output_info(6, l_4, FALSE);i     output_info(7, l_5, FALSE);a   }a   paste_to_screen(); }   G void do_normal(char *nodename, int pid, char *prcname, char *username,  L                char *image, unsigned long before[2], unsigned long after[2],)                float less, float greater)P {(   Node tree=NULL;a    char head[100], host[16];       (   strcpy(head, get_sys(nodename, host));O   tree = get_info(tree, nodename, host, &pid, prcname, username, image, before,;(                   after, less, greater);   if (flags.found){M*     strcpy(head, get_sys(nodename, host));     header(head);     $     traverse_in(tree, print_normal);
   } else {     cleanup(MSG_NOMATCH);;   }e   traverse_post(tree, dealloc);r }(  J void do_continuous(char *nodename, int pid, char *prcname, char *username,L                char *image, unsigned long before[2], unsigned long after[2],)                float less, float greater)  {    Node tree=NULL;s   int c;   char head[100], host[16];e  (   strcpy(head, get_sys(nodename, host));   create_screen();   while(TRUE){J     tree = get_info(tree, nodename, host, &pid, prcname, username, image, 2                     before, after, less, greater);     if (flags.found == 1){,       strcpy(head, get_sys(nodename, host));       header(head);     *       traverse_in(tree, print_continuous);!     } else if (flags.found == 0){n       cleanup(MSG_NOMATCH);      } else {       cleanup(MSG_NOCONT);     }e     c = read_key(TRUE);      switch(c){       case SMG$K_TRM_F10: 5       case SMG$K_TRM_CTRLZ: delete_screen(); return; a4       case SMG$K_TRM_CTRLW: refresh_screen(); break;8       case SMG$K_TRM_CTRLD: delete_process(tree); break;     }d   }  }   . int have_cli (struct dsc$descriptor_d *entity) {  #ifndef VAX0!   unsigned int lib$sig_to_ret ();  #endif  !   lib$establish (lib$sig_to_ret);    return (CLI$PRESENT(entity));E }   C void get_command_line(char *nodename, int *num_pid, char *prcname, kK                       char *username, char *image, unsigned long before[2],LJ                       unsigned long after[2], float *less, float *greater) {    unsigned short int length;
   int status;)I   char l_prcname[16], l_username[13], l_image[257], l_pid[9], l_node[16], >        l_after[25], l_before[25], l_less[257], l_greater[257];    $DESCRIPTOR(s_less_d, l_less);&   $DESCRIPTOR(s_greater_d, l_greater);&   $DESCRIPTOR(s_prcname_d, l_prcname);(   $DESCRIPTOR(s_username_d, l_username);"   $DESCRIPTOR(s_image_d, l_image);   $DESCRIPTOR(s_pid_d, l_pid);    $DESCRIPTOR(s_node_d, l_node);$   $DESCRIPTOR(s_before_d, l_before);"   $DESCRIPTOR(s_after_d, l_after);    $DESCRIPTOR(after_d, "AFTER");"   $DESCRIPTOR(before_d, "BEFORE");&   $DESCRIPTOR(pid_d,"IDENTIFICATION");$   $DESCRIPTOR(process_d, "PROCESS");$   $DESCRIPTOR(version_d, "VERSION");&   $DESCRIPTOR(username_d, "USERNAME");    $DESCRIPTOR(image_d, "IMAGE");&   $DESCRIPTOR(contin_d, "CONTINUOUS");   $DESCRIPTOR(full_d, "FULL");   $DESCRIPTOR(log_d, "LOG");$   $DESCRIPTOR(confirm_d, "CONFIRM");"   $DESCRIPTOR(delete_d, "DELETE");   $DESCRIPTOR(type_d, "TYPE");   $DESCRIPTOR(lock_d, "LOCK");   $DESCRIPTOR(node_d, "NODE");+   $DESCRIPTOR(inter_d, "TYPE.INTERACTIVE");e%   $DESCRIPTOR(batch_d, "TYPE.BATCH"); ,   $DESCRIPTOR(subproc_d, "TYPE.SUBPROCESS");)   $DESCRIPTOR(network_d, "TYPE.NETWORK"); +   $DESCRIPTOR(detached_d, "TYPE.DETACHED");g'   $DESCRIPTOR(dialup_d, "TYPE.DIALUP");s'   $DESCRIPTOR(remote_d, "TYPE.REMOTE"); ;   $DESCRIPTOR(intersect_d, "TYPE.SUBPROCESS.INTERSECTION");*0   $DESCRIPTOR(union_d, "TYPE.SUBPROCESS.UNION");!   $DESCRIPTOR(any_d, "TYPE.ANY"); )   $DESCRIPTOR(less_d, "RATIO.LESS_THAN");n/   $DESCRIPTOR(greater_d, "RATIO.GREATER_THAN"); &   $DESCRIPTOR(pstat_verb_d, "PSTAT ");$   struct dsc$descriptor_d cmdline_d;"   globalref void *pstat_cli_table;     cmdline_d.dsc$w_length = 0; )   cmdline_d.dsc$b_dtype  = DSC$K_DTYPE_T; )   cmdline_d.dsc$b_class  = DSC$K_CLASS_D;l   cmdline_d.dsc$a_pointer = 0;  ,   if (have_cli(&username_d) == CLI$_SYNTAX){*     echeck (lib$get_foreign (&cmdline_d));@     echeck (STR$CONCAT (&cmdline_d, &pstat_verb_d, &cmdline_d));:     status = CLI$DCL_PARSE (&cmdline_d, &pstat_cli_table);7     if (! (status & 1)) exit(status | STS$M_INHIB_MSG);    }i/   if (CLI$PRESENT(&version_d) == CLI$_PRESENT){o      printf("%s\n", MSG_VERSION);     exit(EXIT_SUCCESS);t   }l,   if (CLI$PRESENT(&less_d) == CLI$_PRESENT){     flags.less = TRUE;/     CLI$GET_VALUE(&less_d, &s_less_d, &length);o     l_less[length]='\0';      sscanf(l_less, "%f", less);    }t/   if (CLI$PRESENT(&greater_d) == CLI$_PRESENT){      flags.greater = TRUE;C5     CLI$GET_VALUE(&greater_d, &s_greater_d, &length);,     l_greater[length]='\0'; &     sscanf(l_greater, "%f", greater);    }C,   if (CLI$PRESENT(&node_d) == CLI$_PRESENT){     flags.node = TRUE;/     CLI$GET_VALUE(&node_d, &s_node_d, &length);,     l_node[length]='\0';     strcpy(nodename, l_node);o   } -   if (CLI$PRESENT(&image_d) == CLI$_PRESENT){t     flags.image = TRUE;l1     CLI$GET_VALUE(&image_d, &s_image_d, &length);u     l_image[length]='\0';p     strcpy(image, l_image);    } 0   if (CLI$PRESENT(&username_d) == CLI$_PRESENT){     flags.username = TRUE;7     CLI$GET_VALUE(&username_d, &s_username_d, &length);,     l_username[length]='\0';!     strcpy(username, l_username);    }_+   if (CLI$PRESENT(&pid_d) == CLI$_PRESENT){]     flags.pid = TRUE;r-     CLI$GET_VALUE(&pid_d, &s_pid_d, &length);      l_pid[length]='\0'; "     sscanf(l_pid, "%X", num_pid); 
   } else {     *num_pid = -1; .   }_/   if (CLI$PRESENT(&process_d) == CLI$_PRESENT){g     flags.process = TRUE;)5     CLI$GET_VALUE(&process_d, &s_prcname_d, &length);e     l_prcname[length]='\0';i     strcpy(prcname, l_prcname);    } .   if (CLI$PRESENT(&before_d) == CLI$_PRESENT){     flags.before = TRUE;3     CLI$GET_VALUE(&before_d, &s_before_d, &length);f%     s_before_d.dsc$w_length = length;,     l_before[length]='\0';,     echeck(sys$bintim(&s_before_d, before));   }s-   if (CLI$PRESENT(&after_d) == CLI$_PRESENT){l     flags.after = TRUE; 1     CLI$GET_VALUE(&after_d, &s_after_d, &length);m$     s_after_d.dsc$w_length = length;     l_after[length]='\0';e*     echeck(sys$bintim(&s_after_d, after));   } !   status = CLI$PRESENT(&inter_d); =   if ((status == CLI$_PRESENT || status == CLI$_DEFAULTED) && K       ! flags.pid && ! flags.username && ! flags.process && ! flags.image){a     flags.interactive = TRUE;0   }l   status = CLI$PRESENT(&log_d);i:   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     flags.log = TRUE;3   }e    status = CLI$PRESENT(&lock_d);:   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     flags.lock = TRUE;   } .   if (CLI$PRESENT(&contin_d) == CLI$_PRESENT){     flags.continuous = TRUE;   }T,   if (CLI$PRESENT(&full_d) == CLI$_PRESENT){     flags.full = TRUE;   }l-   if (CLI$PRESENT(&batch_d) == CLI$_PRESENT){a     flags.batch = TRUE;    }_#   status = CLI$PRESENT(&subproc_d);s:   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     flags.spawned = TRUE;    } /   if (CLI$PRESENT(&network_d) == CLI$_PRESENT){      flags.network = TRUE;    } 0   if (CLI$PRESENT(&detached_d) == CLI$_PRESENT){     flags.detached = TRUE;   }(.   if (CLI$PRESENT(&dialup_d) == CLI$_PRESENT){     flags.dialup = TRUE;   }I.   if (CLI$PRESENT(&remote_d) == CLI$_PRESENT){     flags.remote = TRUE;   },%   status = CLI$PRESENT(&intersect_d); :   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     flags.intersect = TRUE;B   }i!   status = CLI$PRESENT(&union_d);z:   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     flags.uni = TRUE;J   }E#   status = CLI$PRESENT(&confirm_d); :   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     flags.confirm = TRUE;r   }-.   if (CLI$PRESENT(&delete_d) == CLI$_PRESENT){     flags.delete = TRUE;   } ,   if (CLI$PRESENT(&any_d) == CLI$_PRESENT ||G       ((flags.pid || flags.username || flags.process || flags.image) &&e1       ! (CLI$PRESENT(&type_d) == CLI$_PRESENT))){u     flags.dialup = TRUE;     flags.remote = TRUE;         flags.batch = TRUE;,     flags.network = TRUE;;     flags.interactive = TRUE;      flags.detached = TRUE;     flags.spawned = TRUE;)     flags.uni = TRUE;    }  }i   main() {S;   char prcname[16], username[13], image[257], nodename[16];u$   unsigned long before[2], after[2];   float less, greater;
   int pid;  K   get_command_line(nodename, &pid, prcname, username, image, before, after, $                    &less, &greater);   if (flags.continuous){I     do_continuous(nodename, pid, prcname, username, image, before, after, !                   less, greater);=
   } else {E     do_normal(nodename, pid, prcname, username, image, before, after,r#               less, greater);      ]   }0 } 