[INHERIT    ('SYS$LIBRARY:STARLET',
	    'SCUGLOBAL')]

PROGRAM SHOW_CLUSTER_USERS_SERVER(output);

CONST

    NFB$C_DECLNAME	=	%X15;
    tty_disconnect	=	1;
    null		=	''(0);
    mbx_buf_size	=	128;
    mbx_buf_size_l	=	32;
    mbx_efn		=	1;
    net_efn		=	2;

LABEL

    900;

VAR

    done		: BOOLEAN := FALSE;

    net_chan,
    mbx_chan,
    node_name_len,
    terminal_name_len,
    user_name_len    	: $WORD;


    net_iosb,
    mbx_iosb		: iosb_type;

    stat,
    mode,
    own_pid,
    csid_context,
    pid_context 	: INTEGER := 0;

    dev_char2		: PACKED ARRAY [0..31] OF BOOLEAN;

    net_func_blk	: PACKED ARRAY [1..5] OF $UBYTE := (5 of 0);
    mbx_buffer		: ARRAY [1..mbx_buf_size] OF $UBYTE;

    node_name		: PACKED ARRAY [1..node_name_size] OF CHAR;
    user_name		: PACKED ARRAY [1..12] OF CHAR;
    terminal_name	: PACKED ARRAY [1..7] OF CHAR;
    scu_server_name	: PACKED ARRAY [1..9] OF CHAR :=
	'SCUSERVER';

    local_node_name	: VARYING [node_name_size] OF CHAR;
    mbx_info		: VARYING [mbx_buf_size] OF CHAR;
    NCB			: VARYING [120] OF CHAR;

    scu_server_name_descr,
    net_func_blk_descr	: descr_type;

    dvi_list		: PACKED ARRAY [1..2] OF jpi_list_type :=
	(2 OF (0,0,0,0));

    jpi_list		: PACKED ARRAY [1..5] OF jpi_list_type :=
	(5 OF (0,0,0,0));

    syi_list		: PACKED ARRAY [1..2] OF jpi_list_type :=
	(2 OF (0,0,0,0));



PROCEDURE DISCONNECT_link;

VAR

    stat	:	INTEGER;

BEGIN	(* DISCONNECT_link *)

    stat := $QIOW(efn := %IMMED net_efn,
		    chan := %IMMED net_chan,
		    func := IO$_DEACCESS+IO$M_SYNCH,
		    iosb := net_iosb);

END;	(* DISCONNECT_link *)










PROCEDURE RETURN_users;

VAR

    done		: BOOLEAN;

    stat,
    indx,
    user_cnt,
    pid_context		: INTEGER;

    scu_rec		: scu_rec_type;
    user_list		: ARRAY [1..max_users] OF scu_rec_type;

    net_buffer		: [unsafe] ARRAY [1..SIZE(scu_rec)] OF $UBYTE;

BEGIN	(* RETURN_users *)

    (* Search all processes on local cluster node *)

    user_cnt := 0;
    pid_context := -1;

    REPEAT
	stat := $GETJPIW(pidadr := %REF pid_context, itmlst := jpi_list);

	IF (stat = SS$_NORMAL) AND (mode = JPI$K_INTERACTIVE) AND (own_pid = 0)
	THEN
	    BEGIN

		(* Get the terminal's secondary device characteristic *)

		stat := $GETDVIW(
		    devnam := terminal_name,
		    itmlst := dvi_list);

		user_cnt := user_cnt + 1;

		IF (dev_char2[tty_disconnect])
		    THEN user_list[user_cnt].class := scu$_disc_user
		    ELSE user_list[user_cnt].class := scu$_user;

		user_list[user_cnt].string := SUBSTR(user_name,1,user_name_len);

	    END;

    UNTIL stat = SS$_NOMOREPROC;

    REPEAT

    (* Sort user names here *)

	done := TRUE;	(* List may be sorted already *)

	FOR indx := 1 TO (user_cnt - 1) DO
	BEGIN
	    stat := STR$COMPARE(user_list[indx].string,
			user_list[indx+1].string);

	    IF (stat = 1) THEN
		BEGIN
		    scu_rec := user_list[indx];
		    user_list[indx] := user_list[indx+1];
		    user_list[indx+1] := scu_rec;

		    done := FALSE;	(* Not done sorting yet *)
		END;
	END;	

    UNTIL done;

    WRITEV(scu_rec.string,user_cnt:1);
    scu_rec.class := scu$_count;

    net_buffer := scu_rec;

    stat := $QIOW(efn := %IMMED net_efn,
		    chan := %IMMED net_chan,
		    func := IO$_WRITEVBLK,
		    iosb := net_iosb,
		    p1 := %IMMED IADDRESS(net_buffer[1]),
		    p2 := %IMMED SIZE(scu_rec));

    FOR indx := 1 to user_cnt DO
	BEGIN
	    net_buffer := user_list[indx];

	    stat := $QIOW(efn := %IMMED net_efn,
			    chan := %IMMED net_chan,
			    func := IO$_WRITEVBLK,
			    iosb := net_iosb,
			    p1 := %IMMED IADDRESS(net_buffer[1]),
			    p2 := %IMMED SIZE(scu_rec));

	END;

    WITH scu_rec DO
	BEGIN
	    class := scu$_done;
	    string := local_node_name;
	END;

	net_buffer := scu_rec;

	stat := $QIOW(efn := %IMMED net_efn,
		    chan := %IMMED net_chan,
		    func := IO$_WRITEVBLK,
		    iosb := net_iosb,
		    p1 := %IMMED IADDRESS(net_buffer[1]),
		    p2 := %IMMED SIZE(scu_rec));


END;	(* RETURN_users *)







PROCEDURE PROCESS_connection;

VAR

    stat	: INTEGER;

    NCB_descr	: descr_type;

BEGIN	(* PROCESS_connection *)

    NCB_descr.adr := IADDRESS(mbx_info.body);
    NCB_descr.len := mbx_info.length;

    IF (INDEX(mbx_info,'SCUSERVER') = 0) THEN
	
	(* Reject all non-SCUSERVER links *)

	BEGIN
	    stat := $QIOW(efn := %IMMED net_efn,
			    chan := %IMMED net_chan,
			    func := IO$_ACCESS+IO$M_ABORT,
			    iosb := net_iosb,
			    p2 := %REF NCB_descr);

	END
    ELSE
	BEGIN
	    stat := $QIOW(efn := %IMMED net_efn,
			    chan := %IMMED net_chan,
			    func := IO$_ACCESS,
			    iosb := net_iosb,
			    p2 := %REF NCB_descr);

	    RETURN_users;

	    DISCONNECT_link;

	END;

END;	(* PROCESS_connection *)








PROCEDURE PROCESS_mailbox;

VAR

    cnt			: [unsafe] $BYTE;

    len,
    indx		: INTEGER;

    mbx_msg_type,
    net_unit		: [unsafe] $WORD;

    mbx_msg		: [unsafe] PACKED ARRAY [1..mbx_buf_size] OF CHAR;

BEGIN	(* PROCESS_mailbox *)

	len := mbx_iosb[2] * 2;

	mbx_msg := mbx_buffer;

	mbx_msg_type := SUBSTR(mbx_msg,1,2);
	net_unit := SUBSTR(mbx_msg,3,2);

	cnt := mbx_msg[5];

	indx := cnt + 6;
	cnt := mbx_msg[indx];
	mbx_info := SUBSTR(mbx_msg,indx+1,cnt);

	CASE mbx_msg_type OF

	    MSG$_CONNECT	: PROCESS_connection;

	    MSG$_DISCON		: ;

	    MSG$_NETSHUT,MSG$_THIRDPARTY	: done := TRUE;

	    OTHERWISE	WRITELN('Unknown message type',HEX(mbx_msg_type,8));

	END;	(* CASE *)


END;	(* PROCESS_mailbox *)





BEGIN

    stat := $SETPRN(%STDESCR 'SCU_SERVER');
    IF NOT ODD(stat) THEN LIB$SIGNAL(stat);

    scu_server_name_descr.len := 9;
    scu_server_name_descr.adr := IADDRESS(scu_server_name);

    net_func_blk[1] := NFB$C_DECLNAME;
    net_func_blk_descr.len := 5;
    net_func_blk_descr.adr := IADDRESS(net_func_blk);

    WITH jpi_list[1] DO
	BEGIN
	    len := SIZE(user_name);
	    code := JPI$_USERNAME;
	    buf_adr := IADDRESS(user_name);
	    len_adr := IADDRESS(user_name_len);
	END;

    WITH jpi_list[2] DO
	BEGIN
	    len := 4;
	    code := JPI$_MODE;
	    buf_adr := IADDRESS(mode);
	END;

    WITH jpi_list[3] DO
	BEGIN
	    len := 4;
	    code := JPI$_OWNER;
	    buf_adr := IADDRESS(own_pid);
	END;

    WITH jpi_list[4] DO
	BEGIN
	    len := SIZE(terminal_name);
	    code := JPI$_TERMINAL;
	    buf_adr := IADDRESS(terminal_name);
	    len_adr := IADDRESS(terminal_name_len);
	END;

    WITH dvi_list[1] DO
	BEGIN
	    len := 4;
	    code := DVI$_DEVCHAR2;
	    buf_adr := IADDRESS(dev_char2);
	END;

    WITH syi_list[1] DO
	BEGIN
	    len := SIZE(node_name);
	    code := SYI$_NODENAME;
	    buf_adr := IADDRESS(node_name);
	    len_adr := IADDRESS(node_name_len);
	END;

    WITH syi_list[2] DO
	BEGIN
	    len := 0;
	    code := 0;
	    buf_adr := 0;
	END;

    stat := $GETSYIW(itmlst := syi_list);

    local_node_name := SUBSTR(node_name,1,node_name_len);

    (* Determine if this process was started by a remote request *)

    stat := $TRNLNM(tabnam := 'LNM$PROCESS_TABLE', lognam := 'SYS$NET');

    IF (stat = SS$_NORMAL) THEN
	WRITELN('SCUSERVER started by remote connect');

    (* Create a SYS$NET mailbox *)

    stat := $CREMBX(chan := mbx_chan,
	    maxmsg := mbx_buf_size,
	    bufquo := mbx_buf_size,
	    lognam := %STDESCR 'SCU_mbx');

    (* Connect to DECNET *)

    stat := $ASSIGN(chan := net_chan,
	    devnam := %STDESCR '_NET:',
	    mbxnam := %STDESCR 'SCU_mbx');

    (* Declare process as NETWORK task *)

    stat := $QIOW(efn := %IMMED net_efn,
	    chan := net_chan,
	    func := %IMMED IO$_ACPCONTROL,
	    p1 := %REF net_func_blk_descr,
	    p2 := %REF scu_server_name_descr);

REPEAT

    stat := $QIOW(efn := %IMMED mbx_efn,
		chan := %IMMED mbx_chan,
		func := IO$_READVBLK,
		iosb := mbx_iosb,
		p1 := %IMMED IADDRESS(mbx_buffer[1]),
		p2 := %IMMED mbx_buf_size);

    PROCESS_mailbox;

UNTIL DONE;

    (* Clean up any remaining connections *)

    IF (net_chan <> 0)
	THEN DISCONNECT_link;

900:	(* Error exit *)

END.
