[INHERIT ('SYS$LIBRARY:STARLET',
          'SCUGLOBAL')]

PROGRAM SHOW_cluster_users (INPUT,OUTPUT);
{
author:   unknown
date:     unknown
            10-nov-92   jon baker       provide display in 132 mode
            10-jan-93   jon baker       provide continuous update
            10-mar-93   jon baker       provide user the ability to change
                                        update of continuous
            10-jan-94   jon baker       provide brief display by showing
                                        only unique usernames.

purpose:  provide graphical view of users

}
CONST

    OPER                = %X'00040000';
    BLANK               = ' ';
    max_rows		= 20;
    max_width		= 10;
    cntrl_Y             = 25;
    CLI$_PRESENT        = %X'0003FD19';
    quit                = %X'FFFFFFFF';
    cntrl_y_c_mask      = %X'02000008';

TYPE

    AST_PARAM_TYPE      = ARRAY [1..3] OF INTEGER;
    str_type		= varying [15] of char;
    big_str_type	= varying [132] of char;
    $ULWORD		= [LONG] 0..maxint;
VAR
    LETTER              : $UWORD;
    PASTE_SIZE,
    STATUS              : INTEGER;
    PRIV                : UNSIGNED;
    BIT_MASK            : ARRAY [1..2] OF UNSIGNED;
    END_TEST,
    end_text            : packed array [1..90] of CHAR;
    TIME_STR            : PACKED ARRAY [1..2] OF CHAR;
    BRIEF,
    ONCE,
    CONTINUOUS          : BOOLEAN;
    TIME                : SINGLE := 0;
    CONTROL_CHARS       : [VOLATILE] $ULWORD := cntrl_y_c_mask;
    node_sum		: big_str_type;

    TIME_DIS		: [VOLATILE] INTEGER := 0;
    idx,
    idx2		: INTEGER := 0;
    tmp_string		: PACKED ARRAY [1..10] OF CHAR;
        
    num_windows,
    save_row,
    total_users		: INTEGER := 0;

    net_chan,
    node_name_len	: $WORD;

    net_iosb		: iosb_type;

    kb_id		: [VOLATILE] UNSIGNED := 0;    (* key BOARD ID *)
    pb_id		: INTEGER  := 0;    (* PASTE BOARD ID *)
    volatile_pb_id	: [VOLATILE] INTEGER  := 0;    (* PASTE BOARD ID *)
    stat,
    MSG_DIS_SUM,
    vir_dis_sum,
    WHICH,
    vid_att		: INTEGER := 0;
   
    USR_VIR_DIS,
    NOD_VIR_DIS         : ARRAY [1..12] OF INTEGER;
    
    cur_column	: INTEGER := -max_width + 1;
    csid_context	: INTEGER := -1;
    row_cnt		: INTEGER := max_rows;

    NCB			: VARYING [120] OF CHAR;
    cur_node_name	: VARYING [node_name_size] OF CHAR;
    local_node_name	: VARYING [node_name_size] OF CHAR;

    total_users_str	: VARYING [15] OF CHAR;
    final_text		: VARYING [80] OF CHAR;

    node_name		: PACKED ARRAY [1..node_name_size] OF CHAR;
    syi_list		: PACKED ARRAY [1..2] OF jpi_list_type;
    sentence		: [VOLATILE] PACKED ARRAY [1..512] of char; 

[ASYNCHRONOUS]  FUNCTION  CLI$GET_VALUE (
    ENTITY_DESC   : [CLASS_S] PACKED ARRAY [$11..$u1:INTEGER] OF CHAR;
    VAR RETDESC   : [CLASS_S,VOLATILE] PACKED ARRAY [$12..$u2:INTEGER] OF CHAR;
    VAR RETLENGTH : [VOLATILE] $UWORD := %IMMED 0) : INTEGER; EXTERNAL;

[ASYNCHRONOUS]  FUNCTION  CLI$PRESENT (
    ENTITY_DESC  : [CLASS_S] PACKED ARRAY [$11..$u1:INTEGER] OF CHAR) 
    : UNSIGNED; EXTERNAL;
 
[ASYNCHRONOUS] FUNCTION lib$getjpi (
     item_code : INTEGER;
     VAR process_id : [VOLATILE] UNSIGNED := %IMMED 0;
     process_name : [CLASS_S] PACKED ARRAY [$l3..$u3:INTEGER] 
                    OF CHAR := %IMMED 0;
     %REF resultant_value : [VOLATILE,UNSAFE] ARRAY [$l4..$u4:INTEGER] 
                    OF $UBYTE := %IMMED 0;
     VAR resultant_string : [CLASS_S,VOLATILE] PACKED ARRAY [$l5..$u5:INTEGER]
                    OF CHAR := %IMMED 0;
     VAR resultant_length : [VOLATILE] $UWORD := %IMMED 0) : INTEGER; EXTERNAL;
 
[ASYNCHRONOUS] PROCEDURE lib$stop (
	%IMMED condition_value : UNSIGNED;
	%IMMED number_of_arguments : INTEGER := %IMMED 0;
	%IMMED FAO_argument : [LIST,UNSAFE] INTEGER); EXTERNAL;
 
[ASYNCHRONOUS] FUNCTION smg$delete_virtual_display (
	display_id : UNSIGNED) : INTEGER; EXTERNAL;

[ASYNCHRONOUS] FUNCTION smg$erase_display (
	display_id : UNSIGNED;
	start_row : INTEGER := %IMMED 0;
	start_column : INTEGER := %IMMED 0;
	end_row : INTEGER := %IMMED 0;
	end_column : INTEGER := %IMMED 0) : INTEGER; EXTERNAL;

[ASYNCHRONOUS] FUNCTION smg$create_virtual_keyboard (
	VAR keyboard_id : [VOLATILE] UNSIGNED;
	input_device : [CLASS_S] PACKED ARRAY [$l2..$u2:INTEGER] OF CHAR := %IMMED 0;
	default_filespec : [CLASS_S] PACKED ARRAY [$l3..$u3:INTEGER] OF CHAR := %IMMED 0;
	VAR resultant_filespec : [CLASS_S,VOLATILE] PACKED ARRAY [$l4..$u4:INTEGER] OF CHAR := %IMMED 0;
	recall_size : $UBYTE := %IMMED 0) : INTEGER; EXTERNAL;

[ASYNCHRONOUS] FUNCTION smg$read_string (
  keyboard_id : UNSIGNED;
  VAR resultant_string : 
       [CLASS_S,VOLATILE] PACKED ARRAY [$l2..$u2:INTEGER] OF CHAR;
  prompt_string : 
       [CLASS_S] PACKED ARRAY [$l3..$u3:INTEGER] OF CHAR := %IMMED 0;
  maximum_length : INTEGER := %IMMED 0;
  modifiers : UNSIGNED := %IMMED 0;
  timeout : INTEGER := %IMMED 0;
  %REF terminator_set : 
       [UNSAFE] ARRAY [$l7..$u7:INTEGER] OF $UBYTE := %IMMED 0;
  VAR resultant_length : [VOLATILE] $UWORD := %IMMED 0;
  VAR word_terminator_code : [VOLATILE] $UWORD := %IMMED 0;
  display_id : UNSIGNED := %IMMED 0;

  initial_string : 
       [CLASS_S] PACKED ARRAY [$l11..$u11:INTEGER] OF CHAR := %IMMED 0;
  rendition_set : UNSIGNED := %IMMED 0;
  rendition_complement : UNSIGNED := %IMMED 0;
  terminator_string : 
       [CLASS_S] PACKED ARRAY [$l14..$u14:INTEGER] OF CHAR := %IMMED 0) 
  : INTEGER; EXTERNAL;

[ASYNCHRONOUS] FUNCTION smg$read_keystroke (
  keyboard_id : UNSIGNED;
  VAR word_terminator_code : [VOLATILE] $UWORD;
  prompt_string : [CLASS_S] PACKED ARRAY [$l3..$u3:INTEGER] OF CHAR := %IMMED 0;
  timeout : INTEGER := %IMMED 0;
  display_id : UNSIGNED := %IMMED 0;
  rendition_set : UNSIGNED := %IMMED 0;
  rendition_complement : UNSIGNED := %IMMED 0) : INTEGER; EXTERNAL;

[ASYNCHRONOUS] FUNCTION smg$put_chars (
	display_id : UNSIGNED;
	txt : [CLASS_S] PACKED ARRAY [$l2..$u2:INTEGER] OF CHAR;
	start_row : INTEGER := %IMMED 0;
	start_column : INTEGER := %IMMED 0;
	flags : UNSIGNED := %IMMED 0;
	rendition_set : UNSIGNED := %IMMED 0;
	rendition_complement : UNSIGNED := %IMMED 0;
	character_set : UNSIGNED := %IMMED 0) : INTEGER; EXTERNAL;

[ASYNCHRONOUS] FUNCTION smg$set_out_of_band_asts (
	pasteboard_id :  UNSIGNED;
	control_char_mask : $ULWORD;
	%IMMED [UNBOUND, ASYNCHRONOUS] PROCEDURE AST_routine;
	%IMMED AST_argument : UNSIGNED := %IMMED 0) : INTEGER; EXTERNAL;

[ASYNCHRONOUS] FUNCTION smg$delete_pasteboard (
	pasteboard_id : UNSIGNED;
	flags : UNSIGNED := %IMMED 0) : INTEGER; EXTERNAL;

[ASYNCHRONOUS] FUNCTION smg$change_pbd_characteristics (
	pasteboard_id : UNSIGNED;
	desired_width : INTEGER := %IMMED 0;
	VAR width : [VOLATILE] INTEGER := %IMMED 0;
	desired_height : INTEGER := %IMMED 0;
	VAR height : [VOLATILE] INTEGER := %IMMED 0;
	desired_background_color : UNSIGNED := %IMMED 0;
	VAR background_color : [VOLATILE] UNSIGNED := %IMMED 0) : INTEGER; 
        EXTERNAL;

[ASYNCHRONOUS] FUNCTION str$trim (
	VAR destination_string : [CLASS_S,VOLATILE] PACKED ARRAY [$l1..$u1:INTEGER] OF CHAR;
	source_string : [CLASS_S] PACKED ARRAY [$l2..$u2:INTEGER] OF CHAR;
	VAR resultant_length : [VOLATILE] $UWORD := %IMMED 0) : INTEGER; EXTERNAL;

[ASYNCHRONOUS] PROCEDURE CONTROL_CHAR_AST;

  begin

	SMG$READ_STRING (keyboard_id := kb_id,
		resultant_string := sentence,
		modifiers := trm$m_tm_purge + trm$m_tm_noecho
			+ trm$m_tm_trmnoecho,
		timeout := 0);
	SMG$DELETE_PASTEBOARD (pasteboard_id := volatile_pb_id );
                LIB$STOP (QUIT);

  end;	(*  CONTROL_CHAR_AST  *)

FUNCTION COMPRESS (STR : STR_TYPE) : STR_TYPE;

    VAR
       I, J, K      :    INTEGER;
       TEMP         :    STR_TYPE;

    BEGIN

       I := LENGTH (STR);
       J := 0;
       K := 0;
       TEMP := '     ';

       IF (I > J) THEN BEGIN
         REPEAT

           J := J + 1;
           IF (STR[J] <> ' ') THEN BEGIN
             K := K + 1;
             TEMP[K] := STR[J];
           END;    { IF }

         UNTIL (J = I);
       END;    { IF }

       COMPRESS := SUBSTR (TEMP, 1, K);

    END;    { COMPRESS }

FUNCTION Lower_Case ( str : str_type ) : str_type;

    VAR
    	I, J	:	integer;

    BEGIN

	i := length( str );

	j := 0;
	if i > j then
	    repeat
	    	j := j + 1;

		if (str[j] >= 'A') and (str[j] <= 'Z') then
		    str[j] := chr( ord( str[j] ) + 32 )
		else
		    str[j] := str[j];
	    until ( j = i );

	lower_case := str;

    END;    (*  Lower_Case  *)


    PROCEDURE DISPLAY_user_screen(var first:boolean);

    VAR

    	stat	:	INTEGER;

    BEGIN	(* DISPLAY_user_screen *)

        IF(first)THEN BEGIN
    	  row_cnt := 0;
          first := false;
          end
        ELSE BEGIN
          row_cnt := 2;
        END;

        WHICH := WHICH + 1;
	save_row := 0;

        cur_column := cur_column + max_width + 1;

        IF (USR_VIR_DIS[WHICH] = 0) THEN BEGIN
          SMG$CREATE_VIRTUAL_DISPLAY(
        	num_rows := max_rows+1,
    		num_columns := max_width,
    		new_display_id := USR_vir_dis[WHICH],
    		video_attributes := vid_att);
          END
        ELSE BEGIN
          SMG$ERASE_DISPLAY(
                          DISPLAY_ID := USR_VIR_DIS[WHICH]);
        END;    { IF - ELSE }
      
        num_windows := 1;

        SMG$PASTE_VIRTUAL_DISPLAY (
    		display_id := USR_vir_dis[WHICH],
		pasteboard_id := pb_id,
		pasteboard_row := 2,
		pasteboard_column := cur_column);
        
    END;	(* DISPLAY_user_screen *)

PROCEDURE DISPLAY_node_users(var first:boolean);

LABEL                   MESSAGE;
VAR

    BRIEF_USERS,
    TMP_VIR_DIS,
    tmp_count,
    tmp_row,
    dis_attributes,
    stat		: INTEGER;

    NCB_descr		: descr_type;

    net_buffer		: ARRAY [1..SIZE(scu_rec_type)] OF $UBYTE;

    scu_rec		: [UNSAFE] scu_rec_type; 
    TEMP_STR            : PACKED ARRAY [1..5] OF CHAR;
    LAST_USER           : VARYING [15] OF CHAR;



BEGIN	(* PROCEDURE DISPLAY_node_users *)

    BRIEF_USERS     := 0;
    TMP_COUNT       := 0;
    SCU_REC.CLASS   := SCU$_COUNT;
    SCU_REC.STRING  := '000000000000000';
    NCB_descr.adr := IADDRESS(NCB.body);

    NCB := cur_node_name + '::"TASK=SCUSERVER"';
    NCB_descr.len := NCB.length;

    (* Assign a channel to DECnet *)

    stat := $ASSIGN(chan := net_chan,
	devnam := %STDESCR '_NET:');

    stat := $QIOW(chan := %IMMED net_chan,
	func := IO$_ACCESS,
	iosb := net_iosb,
	p2 := %REF NCB_descr);

    IF NOT ODD(net_iosb[1])
    THEN
	$DASSGN(chan := net_chan)
    ELSE
	BEGIN

	    row_cnt := row_cnt + 1;

	    IF ( row_cnt >=  max_rows ) THEN BEGIN
{	      DISPLAY_user_screen(first);   }
              END
	    ELSE begin
		tmp_row := SMG$CURSOR_ROW( display_id := USR_vir_dis[WHICH] );

		save_row := tmp_row + save_row;
		tmp_row := save_row + 1;

        	num_windows := num_windows + 1;
		if ( (max_rows + 1) - tmp_row ) > 0 then BEGIN
                  IF (NOD_VIR_DIS[WHICH] = 0) THEN BEGIN
                    SMG$CREATE_VIRTUAL_DISPLAY(
					num_rows := (max_rows + 1) - tmp_row,
					num_columns := max_width,
					new_display_id := NOD_vir_dis[WHICH],
					video_attributes := vid_att);  
                    END
                  ELSE BEGIN
                    SMG$ERASE_DISPLAY(
                                     DISPLAY_ID := NOD_VIR_DIS[WHICH]);
                  END;    { IF - ELSE }
                        
        	  SMG$PASTE_VIRTUAL_DISPLAY (
					    display_id := NOD_vir_dis[WHICH],
					    pasteboard_id := pb_id,
					    pasteboard_row := tmp_row ,
					    pasteboard_column := cur_column);
		  row_cnt := row_cnt + 1;
		  end
		else BEGIN   
                  display_user_screen(first);
                end;   
	      end;

	    IF (STR$COMPARE_EQL(src1_str := cur_node_name,
		src2_str := local_node_name) = 0)
		THEN dis_attributes := SMG$M_REVERSE + SMG$M_BOLD
		ELSE dis_attributes := SMG$M_REVERSE;

	    stat := $QIOW(chan := %IMMED net_chan,
			func := IO$_READVBLK,
			iosb := net_iosb,
			p1 := %IMMED IADDRESS(net_buffer[1]),
			p2 := %IMMED SIZE(scu_rec_type));

            IF ((NET_BUFFER[1] < 0) OR (NET_BUFFER[1] > 3)) THEN BEGIN
              SCU_REC.CLASS := SCU$_COUNT;
              END
            ELSE BEGIN
	      scu_rec := net_buffer;
            END;   { IF - ELSE }

{            IF (SCU_REC.CLASS <> SCU$_DONE) THEN BEGIN   }
	    tmp_string := '          ';
	    tmp_string := cur_node_name + '(' + scu_rec.string + ')';

(*	    node_sum := node_sum + tmp_string + '  ';*)

	    SMG$PUT_WITH_SCROLL (
		display_id := NOD_vir_dis[WHICH],
		txt := tmp_string,
		rendition_set := %REF dis_attributes);
            TMP_VIR_DIS := NOD_VIR_DIS[WHICH];

	    readv( scu_rec.string, tmp_count, error := message );
            MESSAGE:

	    (* Get users on that node *)
            last_user := '   ';

	    REPEAT

		stat := $QIOW(chan := %IMMED net_chan,
			    func := IO$_READVBLK,
			    iosb := net_iosb,
			    p1 := %IMMED IADDRESS(net_buffer[1]),
			    p2 := %IMMED SIZE(scu_rec_type));


		IF NOT ODD(stat)
		    THEN LIB$SIGNAL(stat);

		IF NOT ODD(net_iosb[1])
		    THEN LIB$SIGNAL(net_iosb[1]);

		scu_rec := net_buffer;

		IF (scu_rec.class <> scu$_done) AND
		    (scu_rec.class <> scu$_count) THEN
		BEGIN
                  IF ((CLI$PRESENT('BRIEF') = CLI$_PRESENT) AND
                      (scu_rec.string <> last_user)) OR
                     (CLI$PRESENT('BRIEF') <> CLI$_PRESENT) THEN BEGIN
                    brief_users := brief_users + 1;
		    row_cnt := row_cnt + 1;
                    total_users := total_users + 1;

		    IF row_cnt > max_rows THEN BEGIN
                      DISPLAY_user_screen(first);
                      IF (NOD_VIR_DIS[WHICH] = 0) THEN BEGIN
                        SMG$CREATE_VIRTUAL_DISPLAY(
					num_rows := (max_rows + 1) - tmp_row,
					num_columns := max_width,
					new_display_id := NOD_vir_dis[WHICH],
					video_attributes := vid_att);  
                         END
                       ELSE BEGIN
                         SMG$ERASE_DISPLAY(
                                     DISPLAY_ID := NOD_VIR_DIS[WHICH]);
                       END;    { IF - ELSE }
                        
        	       SMG$PASTE_VIRTUAL_DISPLAY (
					    display_id := NOD_vir_dis[WHICH],
					    pasteboard_id := pb_id,
					    pasteboard_row := tmp_row ,
					    pasteboard_column := cur_column);
                    END;    { IF }
	
     (*	          scu_rec.string := lower_case( scu_rec.string );*)

		    IF (scu_rec.class = scu$_disc_user) THEN
			    dis_attributes := SMG$M_BOLD
		    ELSE
		    	    dis_attributes := 0;

		    SMG$PUT_WITH_SCROLL (
			display_id := NOD_vir_dis[WHICH],
			txt := scu_rec.string,
			rendition_set := %REF dis_attributes);
                  END;
		END;

              LAST_USER := SCU_REC.STRING;

	    UNTIL (stat <> SS$_NORMAL) OR (scu_rec.class = scu$_done);

            IF (BRIEF) THEN BEGIN
              WRITEV (SCU_REC.STRING, BRIEF_USERS);
              SCU_REC.STRING := COMPRESS (SCU_REC.STRING);
              TMP_STRING := CUR_NODE_NAME + '(' + SCU_REC.STRING + ')';
              IF (STR$COMPARE_EQL(src1_str := cur_node_name,
		src2_str := local_node_name) = 0)
		THEN dis_attributes := SMG$M_REVERSE + SMG$M_BOLD
		ELSE dis_attributes := SMG$M_REVERSE;
             stat := SMG$PUT_CHARS (
		display_id := tmp_vir_dis,
		txt := tmp_string,
                START_ROW := 1,
                START_COLUMN := 2,
                flags := %REF SMG$M_ERASE_LINE,
    		rendition_set := %REF dis_attributes );
              SMG$PUT_WITH_SCROLL (
		display_id := TMP_VIR_DIS,
		txt := tmp_string,
		rendition_set := %REF dis_attributes);
            END;    { IF }

	    stat := $QIOW(chan := %IMMED net_chan,
		func := IO$_DEACCESS+IO$M_ABORT,
		iosb := net_iosb);

{            END;    { IF }
	END;

END;	(* PROCEDURE DISPLAY_node_users *)



VAR
     mitch_column : INTEGER;
     first        : BOOLEAN;
BEGIN
     paste_size := 20;
{
     INITIALIZE STATIC VARIABLES
}
     ONCE := FALSE;
{
     SET UP TIME DIFFERENTIAL
}
   IF(CLI$PRESENT('CONTINUOUS') = CLI$_PRESENT)THEN BEGIN
     STATUS := LIB$GETJPI (
             ITEM_CODE := JPI$_PROCPRIV, 
             RESULTANT_VALUE := BIT_MASK  );
     PRIV := UAND (BIT_MASK[1], OPER);
     IF (PRIV = 0) THEN BEGIN
       stat := SMG$DELETE_PASTEBOARD (
			pasteboard_id := PB_id );
       WRITELN ('%SHOWCUSERS-E-NOPRIV, Insufficient privileges for',
                  ' continuous mode.');
       LIB$STOP (QUIT);
     END;    { IF }

     END_TEXT := ' Control_Y to exit:                   (Continuous Mode)';
     paste_size := paste_size + 36;

     STAT := CLI$GET_VALUE ('CONTINUOUS',TIME_STR);
     
     IF (TIME_STR[1] = BLANK) THEN BEGIN
       TIME := 9.0;
       END
     ELSE BEGIN 
       IF (TIME_STR[2] = BLANK) THEN BEGIN
         TIME_STR[2] := TIME_STR[1];
         TIME_STR[1] := '0';
       END;    { IF }
       TIME := 10 * (ORD(TIME_STR[1]) - 48) + (ORD(TIME_STR[2]) - 48);
     END;    { IF }

     IF (TIME < 3.0) THEN BEGIN
       TIME := 3.0;
       END
     ELSE IF (TIME > 15.0) THEN BEGIN
       TIME := 15.0;
     END;    { IF }
     END
   ELSE BEGIN
     END_TEXT := ' Control_Y to exit:';
     TIME := 0.1;
   END;    { IF - ELSE }
   CONTINUOUS := TRUE;

     IF(CLI$PRESENT('BRIEF') = CLI$_PRESENT)THEN BEGIN
       BRIEF := TRUE;
       IF(CLI$PRESENT('CONTINUOUS') = CLI$_PRESENT)THEN BEGIN
         END_TEST := SUBSTR (END_TEXT,1,55) + '        (brief mode on)    ';
         END
       ELSE BEGIN
         END_TEST := SUBSTR (END_TEXT,1,19) + '        (brief mode on)';
       END;
       END_TEXT := END_TEST;
       paste_size := paste_size + 24;
     END;    { IF }
{
    SET UP THE PASTBOARD STUFF
}
    FOR WHICH := 1 TO 12 DO BEGIN
      USR_VIR_DIS[WHICH] := 0;
      NOD_VIR_DIS[WHICH] := 0;
    END;    { FOR}
    (* Create the video display screen *)

    stat := SMG$CREATE_VIRTUAL_KEYBOARD (
            keyboard_id := kb_id);

    stat := SMG$CREATE_PASTEBOARD (
            new_pasteboard_id := pb_id,
	output_device := 'TT:');

    stat := SMG$CHANGE_PBD_CHARACTERISTICS(
            pasteboard_id := pb_id,
            desired_width := 132);

    control_chars := 33554440;
    volatile_pb_id := pb_id;
    stat := SMG$SET_OUT_OF_BAND_ASTS(
		pasteboard_id := volatile_pb_id,
		control_char_mask := control_chars,
		ast_routine := %IMMED CONTROL_char_ast);

   WHILE (CONTINUOUS) DO BEGIN
{
     SET CONTINUOUS VARIABLE

}
     IF (CLI$PRESENT('CONTINUOUS') <> CLI$_PRESENT) THEN BEGIN
       CONTINUOUS := FALSE;
     END;
{
     REINITIALIZE VARIABLES
}
     CUR_COLUMN      := (-MAX_WIDTH) + 1;
     IDX             := 0;
     IDX2            := 0;
     NUM_WINDOWS     := 0;
     SAVE_ROW        := 0;
     TOTAL_USERS     := 0;
     STAT            := 0;
     WHICH           := 0;
     PB_ID           := 0;
     VID_ATT         := 0;
     CSID_CONTEXT    := -1;
     ROW_CNT         := MAX_ROWS;

    WITH syi_list[1] DO
	BEGIN
	    len := SIZE(node_name);
	    code := SYI$_NODENAME;
	    buf_adr := IADDRESS(node_name);
	    len_adr := IADDRESS(node_name_len);
	END;

    WITH syi_list[2] DO
	BEGIN
	    len := 0;
	    code := 0;
	    buf_adr := 0;
	END;

    stat := $GETSYIW(itmlst := syi_list);

    IF (NOT ODD(stat))
	THEN LIB$SIGNAL(stat);

    local_node_name := SUBSTR(node_name,1,node_name_len);



    (* Search for all nodes in this cluster (including self) *)

    REPEAT

	stat := $GETSYIW(itmlst := syi_list, csidadr := %REF csid_context);

	IF (NOT ODD(stat)) AND (stat <> SS$_NOMORENODE)
	    THEN LIB$SIGNAL(stat);

	cur_node_name := SUBSTR(node_name,1,node_name_len);

	(* Connect to server and display users *)

	IF (stat = SS$_NORMAL) and (cur_node_name <> 'ZAPHOD')
	    THEN BEGIN 
{
    ADD BOOLEAN FIRST TO DIFFERENTIATE BETWEEN A NEW BOARD OR NOT
}
                   first := true;
                   DISPLAY_user_screen(first);
                   DISPLAY_node_users(first); 
                 END;

    UNTIL stat = SS$_NOMORENODE;

(* At least 3 columns will always be displayed *)
    if (cur_column < 24) then
     begin                                     
     cur_column := 24;
     WHICH := WHICH + 1;
     IF (USR_VIR_DIS[WHICH] = 0) THEN BEGIN
       SMG$CREATE_VIRTUAL_DISPLAY(
         	               num_rows := max_rows+1,
    		               num_columns := max_width,
    	          	       new_display_id := USR_vir_dis[WHICH],
    		               video_attributes := vid_att);
       END
     ELSE BEGIN
       SMG$ERASE_DISPLAY(
                        display_id := usr_vir_dis[WHICH]);
     END;    { IF - ELSE }

     SMG$PASTE_VIRTUAL_DISPLAY (
    		display_id := USR_vir_dis[WHICH],
		pasteboard_id := pb_id,
		pasteboard_row := 2,
		pasteboard_column := cur_column);
        end;        
                                                 
{     CLEAR OLD WINDOWS    }

     which := which + 1;
     WHILE (WHICH <=12) DO BEGIN
       IF (nod_VIR_DIS[WHICH] <> 0) THEN BEGIN
         smg$delete_virtual_display(
                                   display_id := usr_vir_dis[which]);
         SMG$DELETE_VIRTUAL_DISPLAY(
                                   display_id := nod_vir_dis[which]);
         usr_vir_dis[which] := 0;
         nod_vir_dis[which] := 0;
       END;    { IF }
       which := which + 1;
     END;    { WHILE }

(* Totals written using at least 3 column displays *)
    IF (VIR_DIS_SUM = 0) THEN BEGIN
      stat := SMG$CREATE_VIRTUAL_DISPLAY(
        	num_rows := 1,
    		num_columns := max(cur_column + max_width - 2, 32),
    		new_display_id := vir_dis_sum,
    		video_attributes := vid_att);
      END
    ELSE BEGIN
      STAT := SMG$DELETE_VIRTUAL_DISPLAY(
                 display_id := vir_dis_sum);
      VIR_DIS_SUM := 0;
      stat := SMG$CREATE_VIRTUAL_DISPLAY(
        	num_rows := 1,
    		num_columns := max(cur_column + max_width - 2, 32),
    		new_display_id := vir_dis_sum,
    		video_attributes := vid_att);
    END;    { IF - ELSE }

    stat := SMG$PASTE_VIRTUAL_DISPLAY (
    		display_id := vir_dis_sum,
		pasteboard_id := pb_id,
		pasteboard_row := max_rows + 2,
		pasteboard_column := 2		);

    WRITEV( total_users_str, total_users:1 );

(*    if ( cur_column < 24 ) then
      begin idx2 := 6;
	    node_sum := 'Total='
      end
    else  *)                                         
(*  Following message always appears *)
      begin idx2 := 23;
	    node_sum := 'ACC VAXcluster Users = '
      end;
                                       
(* Message is centered to at least 3 column-displays *)
    mitch_column := max (cur_column , 24);
    idx := ( (mitch_column - 1) + (max_width - 2) - idx2 ) DIV 2;
    WRITEV( final_text, ' ':idx );
    stat := SMG$PUT_WITH_SCROLL (
		display_id := vir_dis_sum,
		txt := final_text + node_sum + total_users_str,
    		rendition_set := %REF SMG$M_BOLD	);

    IF (NOT (ONCE)) THEN BEGIN
      ONCE := TRUE;

      IF (MSG_DIS_SUM = 0) THEN BEGIN
          stat := SMG$CREATE_VIRTUAL_DISPLAY(
          	  num_rows := 1,
    	  	  num_columns := paste_size,
    		  new_display_id := MSG_dis_sum,
                  display_attributes := 0,
                  video_attributes := 0);
        END
      ELSE BEGIN
        SMG$ERASE_DISPLAY(
                         DISPLAY_ID := MSG_DIS_SUM);
      END;    { IF - ELSE }
 
      stat := SMG$PASTE_VIRTUAL_DISPLAY (
    		display_id := MSG_DIS_SUM,
		pasteboard_id := pb_id,
		pasteboard_row := 24,
		pasteboard_column := 2		);

      stat := SMG$PUT_CHARS (
		display_id := MSG_DIS_SUM,
		txt := END_TEXT,
                START_ROW := 1,
                START_COLUMN := 2,
                flags := %REF SMG$M_ERASE_LINE,
    		rendition_set := %REF SMG$M_BLINK  );
    END;    { IF }

    (* Set the cursor at the bottom left of screen *)

    stat := SMG$SET_PHYSICAL_CURSOR(pasteboard_id := pb_id,
		pb_row := 24,
		pb_column := 1);

     LIB$WAIT(TIME);

	SMG$READ_STRING (keyboard_id := kb_id,
		resultant_string := sentence,
		modifiers := trm$m_tm_purge + trm$m_tm_noecho
			+ trm$m_tm_trmnoecho,

		timeout := 0);

    WHILE (NOT CONTINUOUS) DO BEGIN
	SMG$READ_STRING (keyboard_id := kb_id,
		resultant_string := sentence,
		modifiers := trm$m_tm_purge + trm$m_tm_noecho
			+ trm$m_tm_trmnoecho,
		timeout := 0);
        LIB$WAIT(TIME);
	END {WHILE}


  END;    { WHILE }
END.	(* SHOW_cluster_users *)
