type
	smg$terminator_mask = record
				size : unsigned;
				addr : unsigned;
			 end;
	smg$word = [word] 0..65535;
	smg$terminator_code = smg$word;

{ SMG routines in alphanumerical order }

{add_key_def}
{allow_escape}

function smg$begin_display_update (
			display_id : unsigned
			): unsigned; external;

function smg$begin_pasteboard_update (
			pasteboard_id : unsigned
			): unsigned; external;

[asynchronous, unbound] procedure smg$cancel_input
		(keyboard_id : [volatile] unsigned); external;

{change_pbd_characteristics}
{change_rendition}
{change_virtual_display}

function smg$check_for_occlusion (
			display_id : unsigned;
			pasteboard_id : unsigned;
			var occlusion_state : [writeonly] unsigned
			): unsigned; external;

function smg$control_mode (
			pasteboard_id : unsigned;
			new_mode : unsigned := %immed 0;
			var old_mode : unsigned := %immed 0
			): unsigned; external;

{copy_virtual_display}

function smg$create_key_table (
			var new_key_table_id : unsigned
			): unsigned; external;

function smg$create_pasteboard (
			var new_pasteboard_id : unsigned;
			%descr output_device : [readonly] varying [size] of char := %immed 0;
			var pb_rows, pb_columns : integer := %immed 0;
			preserve_screen_flag : unsigned := %immed 0
			): unsigned; external;

function smg$create_virtual_display (
			num_rows, num_columns : integer;
			var new_display_id : unsigned;
			display_attributes, video_attributes, char_set : unsigned := %immed 0
			): unsigned; external;

function smg$create_virtual_keyboard (
			var new_keyboard_id : unsigned;
			%descr filespec : [readonly] varying [filesize] of char := %immed 0;
			%descr default_filespec : [readonly] varying [defsize] of char := %immed 0;
			%descr resultant_filespec : [writeonly] varying [ressize] of char := %immed 0;
			recall_size : unsigned := %immed 0
			): unsigned; external;                   

function smg$cursor_column (
			display_id : unsigned
			): unsigned; external;

function smg$cursor_row (
			display_id : unsigned
			): unsigned; external;

{define-key}
{del_term_table}

function smg$delete_chars (
			display_id : unsigned;
			num_chars : unsigned;
			row : unsigned;
			column : unsigned
			): unsigned; external;

{delete_key_def}

function smg$delete_line (
			display_id : unsigned;
			start_line : unsigned;
			number_lines : unsigned := %immed 0
			): unsigned; external;

function smg$delete_pasteboard (
			pasteboard_id : unsigned;
			clear_screen_flag : unsigned := %immed 0
			): unsigned; external; 

function smg$delete_virtual_display (
			display_id : unsigned
			): unsigned; external;

function smg$delete_virtual_keyboard (
			keyboard_id : unsigned
			): unsigned; external;

{disable_broadcast_trapping}
{disable_unsolicited_input}

function smg$draw_line (display_id : unsigned;
			start_row : unsigned;
			start_column : unsigned;
			end_row : unsigned;
			end_column : unsigned;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0
			): unsigned; external;

function smg$draw_rectangle (
			display_id : unsigned;
			start_row : unsigned;
			start_column : unsigned;
			end_row : unsigned;
			end_column : unsigned;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0
			): unsigned; external;

{enable_unsolicited_input}

function smg$end_display_update (
			display_id : unsigned
			): unsigned; external;

function smg$end_pasteboard_update (
			pasteboard_id : unsigned
			): unsigned; external;

function smg$erase_chars (
			display_id : unsigned;
			number_of_chars : unsigned;
			row : unsigned;
			column : unsigned
			): unsigned; external;

function smg$erase_line (
			display_id : unsigned;
			start_row : unsigned := %immed 0;
			start_column : unsigned := %immed 0
			): unsigned; external;

function smg$erase_display (
			display_id : unsigned;
			start_row : unsigned := %immed 0;
			start_column : unsigned := %immed 0;
			end_row : unsigned := %immed 0;
			end_column : unsigned := %immed 0
			): unsigned; external;

function smg$erase_pasteboard	(
			pasteboard_id : unsigned
			): unsigned; external;

{find_cursor_display}

function smg$flush_buffer (
			pasteboard_id : unsigned
			): unsigned; external;

{get_broadcast_message}
{get_char_at_physical_cursor}
{get_display_attr}
{get_key_def}

function smg$get_keyboard_attributes (
			keyboard_id : unsigned;
			var p_kit : smg$type;
			p_kit_size : unsigned
			): unsigned; external;

{get_numeric_data}

function smg$get_pasteboard_attributes (
			pasteboard_id : unsigned;
			var pb_info_table : [writeonly] smg$type;
			pb_info_table_size : unsigned
			): unsigned; external;
                                            
{get_pasting_info}
{get_term_data}

function smg$home_cursor (
			display_id : [truncate] unsigned;
		  	position : unsigned := %immed 0
			): unsigned; external;

{init_term_table}
{init_term_table_by_type}
{insert_chars}
{insert_line}
{invalidate_display}

function smg$label_border (display_id : unsigned;
			   text : varying [tsize] of char;
			   position_code : unsigned := %immed 0;
			   units : unsigned := %immed 0;
			   rendition_set : unsigned := %immed 0;
			   rendition_complement : unsigned := %immed 0
			  ): unsigned; external;

{list_key_defs}

function smg$load_key_defs (
			key_table_id : unsigned;
			%descr filespec : [readonly] varying [filesize] of char;
			%descr default_filespec : [readonly] varying [defsize] of char := %immed 0;
			lognam_flag : unsigned := %immed 0
			): unsigned; external;
				
function smg$move_virtual_display (
			display_id : unsigned;
			pasteboard_id : unsigned;
			pasteboard_row, pasteboard_column : integer;
			top_display_id : unsigned := %immed 0
			): unsigned; external;

function smg$paste_virtual_display (
			display_id : unsigned;
			pasteboard_id : unsigned;
			pasteboard_row, pasteboard_column : integer
			): unsigned; external;

function smg$pop_virtual_display (
			display_id : unsigned;
			pasteboard_id : unsigned
			): unsigned; external;

function smg$put_chars	(
			display_id : unsigned;
			%descr text : [readonly] varying [size] of char;
			line_number, column_number : integer := %immed 0;
			erase_flag : unsigned := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0;
			char_set: unsigned := %immed 0
			): unsigned; external;

function smg$put_chars_highwide	(
			display_id : unsigned;
			%descr text : [readonly] varying [size] of char;
			line_number, column_number : integer := %immed 0;
			erase_flag : unsigned := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0;
			char_set: unsigned := %immed 0
			): unsigned; external;

function smg$put_chars_wide (
			display_id : unsigned;
			%descr text : [readonly] varying [size] of char;
			line_number, column_number : integer := %immed 0;
			erase_flag : unsigned := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0;
			char_set: unsigned := %immed 0
     			): unsigned; external;

function smg$put_line	(
			display_id : unsigned;
			%descr text : [readonly] varying [size] of char;
			line_advance : integer := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0;
			wrap_flag : unsigned := %immed 0;
			char_set: unsigned := %immed 0;
			direction : unsigned := %immed 0
			): unsigned; external;

function smg$put_line_wide (
			display_id : unsigned;
			%descr text : [readonly] varying [size] of char;
			line_advance : integer := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0;
			wrap_flag : unsigned := %immed 0;
			char_set: unsigned := %immed 0
			): unsigned; external;

function smg$put_pasteboard (
			pasteboard_id : unsigned;
			%immed [unbound] function p_rtn
				(%stdescr line : [readonly] packed
					array [l..u:integer] of char
				): unsigned;
			p_prm : unsigned;
			p_ff_flag : unsigned
			): unsigned; external;

{put_virtual_display_encoded}

function smg$put_with_scroll (
			display_id : unsigned;
			%descr text : [readonly] varying [size] of char;
			direction : unsigned := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0;
			wrap_flag : unsigned := %immed 0;
			char_set: unsigned := %immed 0
			): unsigned; external;

[asynchronous, unbound, external (smg$read_composed_line)]
function smg$read_composed_line_asy (
			keyboard_id : [volatile] unsigned;
			key_table_id : [volatile] unsigned := %immed 0;
			%descr received_text : [writeonly] varying [outsize] of char;
			%descr prompt_string : [readonly] varying [psize] of char := %immed 0;
			var received_string_length : [writeonly] smg$word:= %immed 0;
			display_id : unsigned := %immed 0;
			function_keys_flag : unsigned := %immed 0;
			%descr ini_string : [readonly] varying [isize] of char := %immed 0;
			timeout : unsigned := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0;
			var terminator_code : [writeonly] smg$terminator_code
			): unsigned; external;

function smg$read_composed_line (
			keyboard_id : unsigned;
			key_table_id : unsigned := %immed 0;
			%descr received_text : [writeonly] varying [outsize] of char;
			%descr prompt_string : [readonly] varying [psize] of char := %immed 0;
			var received_string_length : [writeonly] smg$word:= %immed 0;
			display_id : unsigned := %immed 0;
			function_keys_flag : unsigned := %immed 0;
			%descr ini_string : [readonly] varying [isize] of char := %immed 0;
			timeout : unsigned := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0;
			var terminator_code : [writeonly] smg$terminator_code
			): unsigned; external;

{read_from_display}

function smg$read_keystroke (
			keyboard_id : unsigned;
			var terminator_code : [writeonly] smg$terminator_code;
			%descr prompt_string : [readonly] varying [psize] of char := %immed 0;
			timeout : unsigned := %immed 0;
			display_id : unsigned := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0
			): unsigned; external;

function smg$read_string (
			keyboard_id : unsigned;
			%descr received_text : [writeonly] varying [rsize] of char;
			%descr prompt_string : [readonly] varying [psize] of char := %immed 0;
			max_length : unsigned := %immed 0;
			modifiers : unsigned := %immed 0;
			timeout : unsigned := %immed 0;
			%ref terminator_set : smg$terminator_mask := %immed 0;
			var received_string_length : [writeonly] smg$word := %immed 0;
			var terminator_code : [writeonly] smg$terminator_code := %immed 0;
			display_id : unsigned := %immed 0;
			%descr ini_string : [readonly] varying [isize] of char := %immed 0;
			rendition_set : unsigned := %immed 0;
			rendition_complement : unsigned := %immed 0
			): unsigned; external;

{read_verify}

function smg$repaint_screen (
			pasteboard_id: unsigned
			): unsigned; external;

function smg$repaste_virtual_display (
			display_id : unsigned;
			pasteboard_id : unsigned;
			pasteboard_row, pasteboard_column : integer
			): unsigned; external;

function smg$replace_input_line (
			keyboard_id : unsigned;
			%descr replace_string : [writeonly] varying [rsize] of char := %immed 0;
			line_count : integer := %immed 0
			): unsigned; external;

{restore_physical_screen}

function smg$return_cursor_pos (
			display_id : unsigned;
			var row_number, column_number : [writeonly] unsigned
			): unsigned; external;

{return_input_line}

function smg$ring_bell	(
			display_id : unsigned;
			number_of_times : unsigned := %immed 0
			): unsigned; external;

{save_physical_screen}
{scroll_display_area}
{set_broadcast_trapping}

function smg$set_cursor_abs (
			display_id : unsigned;
			row : unsigned := %immed 0;
			column : unsigned := %immed 0
			): unsigned; external;

function smg$set_cursor_mode (
			pasteboard_id : unsigned;
			cursor_mode : unsigned
			): unsigned; external;

function smg$set_cursor_rel (
			display_id : unsigned;
			delta_row : unsigned := %immed 0;
			delta_column : unsigned := %immed 0
			): unsigned; external;

{set_default_state}

function smg$set_display_scroll_region (
			display_id : unsigned;
			starting_line : unsigned := %immed 0;
			ending_line : unsigned := %immed 0
			): unsigned; external;

{set_keypad_mode}
{set_out_of_band_asts}

function smg$set_physical_cursor (
			pasteboard_id : unsigned;
			pb_row, pb_col : unsigned
			): unsigned; external;

function smg$snapshot 	(
			pasteboard_id : unsigned;
			ff_flag : unsigned := %immed 0
			): unsigned; external;

function smg$unpaste_virtual_display (
			display_id : unsigned;
			pasteboard_id : unsigned
			): unsigned; external;
